/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#include <rtl/ustring.hxx>
#include "PropertyIds.hxx"
#include <frozen/bits/defines.h>
#include <frozen/bits/elsa_std.h>
#include <frozen/unordered_map.h>

namespace writerfilter::dmapper{

namespace
{
    constexpr auto constPropertyMap = frozen::make_unordered_map<PropertyIds, std::u16string_view>(
    {
        { PROP_CHAR_WEIGHT, u"CharWeight"},
        { PROP_CHAR_POSTURE, u"CharPosture"},
        { PROP_CHAR_STRIKEOUT, u"CharStrikeout"},
        { PROP_CHAR_CONTOURED, u"CharContoured"},
        { PROP_CHAR_SHADOWED, u"CharShadowed"},
        { PROP_CHAR_CASE_MAP, u"CharCaseMap"},
        { PROP_CHAR_COLOR, u"CharColor"},
        { PROP_CHAR_COMPLEX_COLOR, u"CharComplexColor"},
        { PROP_CHAR_RELIEF, u"CharRelief"},
        { PROP_CHAR_UNDERLINE, u"CharUnderline"},
        { PROP_CHAR_UNDERLINE_COLOR, u"CharUnderlineColor"},
        { PROP_CHAR_UNDERLINE_COMPLEX_COLOR, u"CharUnderlineComplexColor"},
        { PROP_CHAR_UNDERLINE_HAS_COLOR, u"CharUnderlineHasColor"},
        { PROP_CHAR_WORD_MODE, u"CharWordMode"},
        { PROP_CHAR_ESCAPEMENT, u"CharEscapement"},
        { PROP_CHAR_ESCAPEMENT_HEIGHT, u"CharEscapementHeight"},
        { PROP_CHAR_HEIGHT, u"CharHeight"},
        { PROP_CHAR_HEIGHT_COMPLEX, u"CharHeightComplex"},
        { PROP_CHAR_LOCALE, u"CharLocale"},
        { PROP_CHAR_LOCALE_ASIAN, u"CharLocaleAsian"},
        { PROP_CHAR_LOCALE_COMPLEX, u"CharLocaleComplex"},
        { PROP_CHAR_WEIGHT_COMPLEX, u"CharWeightComplex"},
        { PROP_CHAR_POSTURE_COMPLEX, u"CharPostureComplex"},
        { PROP_CHAR_CHAR_KERNING, u"CharKerning"},
        { PROP_CHAR_AUTO_KERNING, u"CharAutoKerning"},
        { PROP_CHAR_SCALE_WIDTH, u"CharScaleWidth"},
        { PROP_CHAR_STYLE_NAME, u"CharStyleName"},
        { PROP_CHAR_FONT_NAME, u"CharFontName"},
        { PROP_CHAR_FONT_CHAR_SET, u"CharFontCharSet"},
        { PROP_CHAR_FONT_NAME_ASIAN, u"CharFontNameAsian"},
        { PROP_CHAR_HEIGHT_ASIAN, u"CharHeightAsian"},
        { PROP_CHAR_FONT_NAME_COMPLEX, u"CharFontNameComplex"},
        { PROP_CHAR_HIDDEN, u"CharHidden"},
        { PROP_CHAR_WEIGHT_ASIAN, u"CharWeightAsian"},
        { PROP_CHAR_POSTURE_ASIAN, u"CharPostureAsian"},
        { PROP_CHAR_BACK_COLOR, u"CharBackColor"},
        { PROP_CHAR_BACKGROUND_COMPLEX_COLOR, u"CharBackgroundComplexColor"},
        { PROP_CHAR_EMPHASIS, u"CharEmphasis"},
        { PROP_CHAR_COMBINE_IS_ON, u"CharCombineIsOn"},
        { PROP_CHAR_COMBINE_PREFIX, u"CharCombinePrefix"},
        { PROP_CHAR_COMBINE_SUFFIX, u"CharCombineSuffix"},
        { PROP_CHAR_ROTATION, u"CharRotation"},
        { PROP_CHAR_ROTATION_IS_FIT_TO_LINE, u"CharRotationIsFitToLine"},
        { PROP_CHAR_FLASH, u"CharFlash"},
        { PROP_CHAR_LEFT_BORDER, u"CharLeftBorder"},
        { PROP_CHAR_RIGHT_BORDER, u"CharRightBorder"},
        { PROP_CHAR_TOP_BORDER, u"CharTopBorder"},
        { PROP_CHAR_BOTTOM_BORDER, u"CharBottomBorder"},
        { PROP_CHAR_LEFT_BORDER_DISTANCE, u"CharLeftBorderDistance"},
        { PROP_CHAR_RIGHT_BORDER_DISTANCE, u"CharRightBorderDistance"},
        { PROP_CHAR_TOP_BORDER_DISTANCE, u"CharTopBorderDistance"},
        { PROP_CHAR_BOTTOM_BORDER_DISTANCE, u"CharBottomBorderDistance"},
        { PROP_CHAR_BORDER_LEFT_COMPLEX_COLOR, u"CharLeftBorderComplexColor"},
        { PROP_CHAR_BORDER_RIGHT_COMPLEX_COLOR, u"CharRightBorderComplexColor"},
        { PROP_CHAR_BORDER_TOP_COMPLEX_COLOR, u"CharTopBorderComplexColor"},
        { PROP_CHAR_BORDER_BOTTOM_COMPLEX_COLOR, u"CharBottomBorderComplexColor"},
        { PROP_CHAR_SHADOW_FORMAT, u"CharShadowFormat"},
        { PROP_CHAR_HIGHLIGHT, u"CharHighlight"},
        { PROP_PARA_STYLE_NAME, u"ParaStyleName"},
        { PROP_PARA_ADJUST, u"ParaAdjust"},
        { PROP_PARA_VERT_ALIGNMENT, u"ParaVertAlignment"},
        { PROP_PARA_LAST_LINE_ADJUST, u"ParaLastLineAdjust"},
        { PROP_PARA_RIGHT_MARGIN, u"ParaRightMargin"},
        { PROP_PARA_LEFT_MARGIN, u"ParaLeftMargin"},
        { PROP_PARA_FIRST_LINE_INDENT, u"ParaFirstLineIndent"},
        { PROP_PARA_KEEP_TOGETHER, u"ParaKeepTogether"},
        { PROP_PARA_TOP_MARGIN, u"ParaTopMargin"},
        { PROP_PARA_TOP_MARGIN_BEFORE_AUTO_SPACING, u"ParaTopMarginBeforeAutoSpacing"},
        { PROP_PARA_BOTTOM_MARGIN_AFTER_AUTO_SPACING, u"ParaBottomMarginAfterAutoSpacing"},
        { PROP_PARA_CONTEXT_MARGIN, u"ParaContextMargin"},
        { PROP_PARA_BOTTOM_MARGIN, u"ParaBottomMargin"},
        { PROP_PARA_IS_HYPHENATION, u"ParaIsHyphenation"},
        { PROP_PARA_HYPHENATION_NO_CAPS, u"ParaHyphenationNoCaps"},
        { PROP_PARA_HYPHENATION_ZONE, u"ParaHyphenationZone"},
        { PROP_PARA_LINE_NUMBER_COUNT, u"ParaLineNumberCount"},
        { PROP_PARA_IS_HANGING_PUNCTUATION, u"ParaIsHangingPunctuation"},
        { PROP_PARA_LINE_SPACING, u"ParaLineSpacing"},
        { PROP_PARA_TAB_STOPS, u"ParaTabStops"},
        { PROP_PARA_WIDOWS, u"ParaWidows"},
        { PROP_PARA_ORPHANS, u"ParaOrphans"},
        { PROP_PARA_LINE_NUMBER_START_VALUE, u"ParaLineNumberStartValue"},
        { PROP_NUMBERING_LEVEL, u"NumberingLevel"},
        { PROP_NUMBERING_RULES, u"NumberingRules"},
        { PROP_NUMBERING_TYPE, u"NumberingType"},
        { PROP_START_WITH, u"StartWith"},
        { PROP_ADJUST, u"Adjust"},
        { PROP_PARENT_NUMBERING, u"ParentNumbering"},
        { PROP_RIGHT_MARGIN, u"RightMargin"},
        { PROP_LEFT_MARGIN, u"LeftMargin"},
        { PROP_TOP_MARGIN, u"TopMargin"},
        { PROP_BOTTOM_MARGIN, u"BottomMargin"},
        { PROP_FIRST_LINE_OFFSET, u"FirstLineOffset"},
        { PROP_LEFT_BORDER, u"LeftBorder"},
        { PROP_RIGHT_BORDER, u"RightBorder"},
        { PROP_TOP_BORDER, u"TopBorder"},
        { PROP_BOTTOM_BORDER, u"BottomBorder"},
        { PROP_BORDER_LEFT_COMPLEX_COLOR, u"LeftBorderComplexColor"},
        { PROP_BORDER_RIGHT_COMPLEX_COLOR, u"RightBorderComplexColor"},
        { PROP_BORDER_TOP_COMPLEX_COLOR, u"TopBorderComplexColor"},
        { PROP_BORDER_BOTTOM_COMPLEX_COLOR, u"BottomBorderComplexColor"},
        { PROP_TABLE_BORDER, u"TableBorder"},
        { PROP_TABLE_ROW_DELETE, u"TableRowDelete"},
        { PROP_TABLE_ROW_INSERT, u"TableRowInsert"},
        { PROP_TABLE_CELL_DELETE, u"TableCellDelete"},
        { PROP_TABLE_CELL_INSERT, u"TableCellInsert"},
        { PROP_LEFT_BORDER_DISTANCE, u"LeftBorderDistance"},
        { PROP_RIGHT_BORDER_DISTANCE, u"RightBorderDistance"},
        { PROP_TOP_BORDER_DISTANCE, u"TopBorderDistance"},
        { PROP_BOTTOM_BORDER_DISTANCE, u"BottomBorderDistance"},
        { PROP_CURRENT_PRESENTATION, u"CurrentPresentation"},
        { PROP_IS_FIXED, u"IsFixed"},
        { PROP_SUB_TYPE, u"SubType"},
        { PROP_FILE_FORMAT, u"FileFormat"},
        { PROP_HYPER_LINK_U_R_L, u"HyperLinkURL"},
        { PROP_HYPERLINK, u"Hyperlink"},
        { PROP_NUMBER_FORMAT, u"NumberFormat"},
        { PROP_NAME, u"Name"},
        { PROP_IS_INPUT, u"IsInput"},
        { PROP_HINT, u"Hint"},
        { PROP_FULL_NAME, u"FullName"},
        { PROP_DESCRIPTION, u"Description"},
        { PROP_MACRO_NAME, u"MacroName"},
        { PROP_TITLE, u"Title"},
        { PROP_CONTENT, u"Content"},
        { PROP_INPUT_STREAM, u"InputStream"},
        { PROP_GRAPHIC, u"Graphic"},
        { PROP_ANCHOR_TYPE, u"AnchorType"},
        { PROP_SIZE, u"Size"},
        { PROP_HORI_ORIENT, u"HoriOrient"},
        { PROP_HORI_ORIENT_POSITION, u"HoriOrientPosition"},
        { PROP_HORI_ORIENT_RELATION, u"HoriOrientRelation"},
        { PROP_VERT_ORIENT, u"VertOrient"},
        { PROP_VERT_ORIENT_POSITION, u"VertOrientPosition"},
        { PROP_VERT_ORIENT_RELATION, u"VertOrientRelation"},
        { PROP_SIZE100th_M_M, u"Size100thMM"},
        { PROP_SIZE_PIXEL, u"SizePixel"},
        { PROP_SURROUND, u"Surround"},
        { PROP_SURROUND_CONTOUR, u"SurroundContour"},
        { PROP_ADJUST_CONTRAST, u"AdjustContrast"},
        { PROP_ADJUST_LUMINANCE, u"AdjustLuminance"},
        { PROP_GRAPHIC_COLOR_MODE, u"GraphicColorMode"},
        { PROP_CONTOUR_OUTSIDE, u"ContourOutside"},
        { PROP_CONTOUR_POLY_POLYGON, u"ContourPolyPolygon"},
        { PROP_PAGE_TOGGLE, u"PageToggle"},
        { PROP_BACK_COLOR, u"BackColor"},
        { PROP_BACK_COMPLEX_COLOR, u"BackComplexColor"},
        { PROP_BACK_COLOR_TRANSPARENCY, u"BackColorTransparency"},
        { PROP_ALLOW_OVERLAP, u"AllowOverlap"},
        { PROP_ALTERNATIVE_TEXT, u"AlternativeText"},
        { PROP_HEADER_TEXT_LEFT, u"HeaderTextLeft"},
        { PROP_HEADER_TEXT, u"HeaderText"},
        { PROP_HEADER_IS_SHARED, u"HeaderIsShared"},
        { PROP_HEADER_IS_ON, u"HeaderIsOn"},
        { PROP_FOOTER_TEXT_LEFT, u"FooterTextLeft"},
        { PROP_FOOTER_TEXT, u"FooterText"},
        { PROP_FOOTER_IS_SHARED, u"FooterIsShared"},
        { PROP_FOOTER_IS_ON, u"FooterIsOn"},
        { PROP_FOOTNOTE_COUNTING, u"FootnoteCounting"},
        { PROP_FOOTNOTE_LINE_ADJUST, u"FootnoteLineAdjust"},
        { PROP_WIDTH, u"Width"},
        { PROP_HEIGHT, u"Height"},
        { PROP_TEXT_COLUMNS, u"TextColumns"},
        { PROP_AUTOMATIC_DISTANCE, u"AutomaticDistance"},
        { PROP_IS_LANDSCAPE, u"IsLandscape"},
        { PROP_FIRST_PAGE, u"First Page"},
        { PROP_PAGE_DESC_NAME, u"PageDescName"},
        { PROP_PAGE_NUMBER_OFFSET, u"PageNumberOffset"},
        { PROP_BREAK_TYPE, u"BreakType"},
        { PROP_FOOTER_IS_DYNAMIC_HEIGHT, u"FooterIsDynamicHeight"},
        { PROP_FOOTER_DYNAMIC_SPACING, u"FooterDynamicSpacing"},
        { PROP_FOOTER_HEIGHT, u"FooterHeight"},
        { PROP_FOOTER_BODY_DISTANCE, u"FooterBodyDistance"},
        { PROP_HEADER_IS_DYNAMIC_HEIGHT, u"HeaderIsDynamicHeight"},
        { PROP_HEADER_DYNAMIC_SPACING, u"HeaderDynamicSpacing"},
        { PROP_HEADER_HEIGHT, u"HeaderHeight"},
        { PROP_HEADER_BODY_DISTANCE, u"HeaderBodyDistance"},
        { PROP_WRITING_MODE, u"WritingMode"},
        { PROP_GRID_MODE, u"GridMode"},
        { PROP_GRID_DISPLAY, u"GridDisplay"},
        { PROP_GRID_PRINT, u"GridPrint"},
        { PROP_GRID_LINES, u"GridLines"},
        { PROP_GRID_BASE_HEIGHT, u"GridBaseHeight"},
        { PROP_GRID_BASE_WIDTH, u"GridBaseWidth"},
        { PROP_GRID_RUBY_HEIGHT, u"GridRubyHeight"},
        { PROP_GRID_STANDARD_MODE, u"StandardPageMode"},
        { PROP_IS_ON, u"IsOn"},
        { PROP_RESTART_AT_EACH_PAGE, u"RestartAtEachPage"},
        { PROP_COUNT_EMPTY_LINES, u"CountEmptyLines"},
        { PROP_COUNT_LINES_IN_FRAMES, u"CountLinesInFrames"},
        { PROP_INTERVAL, u"Interval"},
        { PROP_DISTANCE, u"Distance"},
        { PROP_NUMBER_POSITION, u"NumberPosition"},
        { PROP_LEVEL, u"Level"},
        { PROP_LEVEL_FOLLOW, u"LabelFollowedBy"},
        { PROP_LEVEL_PARAGRAPH_STYLES, u"LevelParagraphStyles"},
        { PROP_LEVEL_FORMAT, u"LevelFormat"},
        { PROP_LIST_FORMAT, u"ListFormat"},
        { PROP_TOKEN_TYPE, u"TokenType"},
        { PROP_TOKEN_HYPERLINK_START, u"TokenHyperlinkStart"},
        { PROP_TOKEN_HYPERLINK_END, u"TokenHyperlinkEnd"},
        { PROP_TOKEN_CHAPTER_INFO, u"TokenChapterInfo"},
        { PROP_CHAPTER_FORMAT, u"ChapterFormat"},
        { PROP_TOKEN_TEXT, u"TokenText"},
        { PROP_TEXT, u"Text"},
        { PROP_CREATE_FROM_OUTLINE, u"CreateFromOutline"},
        { PROP_CREATE_FROM_MARKS, u"CreateFromMarks"},
        { PROP_STANDARD, u"Standard"},
        { PROP_SPLIT, u"Split"},
        { PROP_IS_SPLIT_ALLOWED, u"IsSplitAllowed"},
        { META_PROP_VERTICAL_BORDER, u"VerticalBorder"},
        { META_PROP_HORIZONTAL_BORDER, u"HorizontalBorder"},
        { PROP_HEADER_ROW_COUNT, u"HeaderRowCount"},
        { PROP_SIZE_TYPE, u"SizeType"},
        { PROP_TABLE_COLUMN_SEPARATORS, u"TableColumnSeparators"},
        { META_PROP_TABLE_STYLE_NAME, u"TableStyleName"},
        { PROP_TABLE_REDLINE_PARAMS, u"TableRedlineParams"},
        { PROP_REDLINE_AUTHOR, u"RedlineAuthor"},
        { PROP_REDLINE_DATE_TIME, u"RedlineDateTime"},
        { PROP_REDLINE_TYPE, u"RedlineType"},
        { PROP_REDLINE_REVERT_PROPERTIES, u"RedlineRevertProperties"},
        { PROP_IS_PROTECTED, u"IsProtected"},
        { PROP_SIZE_PROTECTED, u"SizeProtected"},
        { PROP_POSITION_PROTECTED, u"PositionProtected"},
        { PROP_OPAQUE, u"Opaque"},
        { PROP_VERTICAL_MERGE, u"VerticalMerge"},
        { PROP_BULLET_CHAR, u"BulletChar"},
        { PROP_BULLET_FONT_NAME, u"BulletFontName"},
        { PROP_TABS_RELATIVE_TO_INDENT, u"TabsRelativeToIndent"},
        { PROP_CREATE_FROM_LEVEL_PARAGRAPH_STYLES, u"CreateFromLevelParagraphStyles"},
        { PROP_DROP_CAP_FORMAT, u"DropCapFormat"},
        { PROP_REFERENCE_FIELD_PART, u"ReferenceFieldPart"},
        { PROP_SOURCE_NAME, u"SourceName"},
        { PROP_REFERENCE_FIELD_SOURCE, u"ReferenceFieldSource"},
        { PROP_WIDTH_TYPE, u"WidthType"},
        { PROP_TBL_LOOK, u"TblLook"},
        { PROP_TEXT_RANGE, u"TextRange"},
        { PROP_TEXT_VERTICAL_ADJUST, u"TextVerticalAdjust"},
        { PROP_SERVICE_CHAR_STYLE, u"com.sun.star.style.CharacterStyle"},
        { PROP_SERVICE_PARA_STYLE, u"com.sun.star.style.ParagraphStyle"},
        { PROP_CHARACTER_STYLES, u"CharacterStyles"},
        { PROP_PARAGRAPH_STYLES, u"ParagraphStyles"},
        { PROP_TABLE_BORDER_DISTANCES, u"TableBorderDistances"},
        { META_PROP_CELL_MAR_TOP, u"MetaPropCellMarTop"},
        { META_PROP_CELL_MAR_BOTTOM, u"MetaPropCellMarBottom"},
        { META_PROP_CELL_MAR_LEFT, u"MetaPropCellMarLeft"},
        { META_PROP_CELL_MAR_RIGHT, u"MetaPropCellMarRight"},
        { PROP_START_AT, u"StartAt"},
        { PROP_CHAR_PROP_HEIGHT, u"CharPropHeight"},
        { PROP_CHAR_PROP_HEIGHT_ASIAN, u"CharPropHeightAsian"},
        { PROP_CHAR_PROP_HEIGHT_COMPLEX, u"CharPropHeightComplex"},
        { PROP_FORMAT, u"Format"},
        { PROP_INSERT, u"Insert"},
        { PROP_DELETE, u"Delete"},
        { PROP_PARAGRAPH_FORMAT, u"ParagraphFormat"},
        { PROP_STREAM_NAME, u"StreamName"},
        { PROP_BITMAP, u"Bitmap"},
        { PROP_IS_DATE, u"IsDate"},
        { PROP_TAB_STOP_DISTANCE, u"TabStopDistance"},
        { PROP_INDENT_AT, u"IndentAt"},
        { PROP_FIRST_LINE_INDENT, u"FirstLineIndent"},
        { PROP_NUMBERING_STYLE_NAME, u"NumberingStyleName"},
        { PROP_OUTLINE_LEVEL, u"OutlineLevel"},
        { PROP_LISTTAB_STOP_POSITION, u"ListtabStopPosition"},
        { PROP_POSITION_AND_SPACE_MODE, u"PositionAndSpaceMode"},
        { PROP_PARA_SPLIT, u"ParaSplit"},
        { PROP_HELP, u"Help"},
        { PROP_HEADING_STYLE_NAME, u"HeadingStyleName"},
        { PROP_FRM_DIRECTION, u"FRMDirection"},
        { PROP_EMBEDDED_OBJECT, u"EmbeddedObject"},
        { PROP_IS_VISIBLE, u"IsVisible"},
        { PROP_PAGE_STYLE_LAYOUT, u"PageStyleLayout"},
        { PROP_Z_ORDER, u"ZOrder"},
        { PROP_EMBED_FONTS, u"EmbedFonts"},
        { PROP_EMBED_SYSTEM_FONTS, u"EmbedSystemFonts"},
        { PROP_SHADOW_FORMAT, u"ShadowFormat"},
        { PROP_RELATIVE_WIDTH, u"RelativeWidth"},
        { PROP_IS_WIDTH_RELATIVE, u"IsWidthRelative"},
        { PROP_GRAPHIC_BITMAP, u"GraphicBitmap"},
        { PROP_GRAPHIC_SIZE, u"GraphicSize"},
        { PROP_CHAR_SHADING_VALUE, u"CharShadingValue"},
        { PROP_CHAR_SHADING_MARKER, u"CharShadingMarker"},
        { PROP_LABEL_CATEGORY, u"LabelCategory"},
        { PROP_MIRROR_INDENTS, u"MirrorIndents"},
        { PROP_SURROUND_TEXT_WRAP_SMALL, u"SurroundTextWrapSmall"},
        { PROP_PARA_SHADOW_FORMAT, u"ParaShadowFormat"},
        { PROP_FOOTNOTE_LINE_RELATIVE_WIDTH, u"FootnoteLineRelativeWidth"},
        { PROP_TBL_HEADER, u"TblHeader"},
        { PROP_CHAR_THEME_NAME_ASCII, u"CharThemeNameAscii"},
        { PROP_CHAR_THEME_NAME_CS, u"CharThemeNameCs"},
        { PROP_CHAR_THEME_NAME_H_ANSI, u"CharThemeNameHAnsi"},
        { PROP_CHAR_THEME_NAME_EAST_ASIA, u"CharThemeNameEastAsia"},
        { PROP_CHAR_THEME_FONT_NAME_ASCII, u"CharThemeFontNameAscii"},
        { PROP_CHAR_THEME_FONT_NAME_CS, u"CharThemeFontNameCs"},
        { PROP_CHAR_THEME_FONT_NAME_EAST_ASIA, u"CharThemeFontNameEastAsia"},
        { PROP_CHAR_THEME_COLOR, u"CharThemeColor"},
        { PROP_CHAR_THEME_ORIGINAL_COLOR, u"CharThemeOriginalColor"},
        { PROP_CHAR_THEME_COLOR_SHADE, u"CharThemeColorShade"},
        { PROP_CHAR_THEME_FILL, u"CharThemeFill"},
        { PROP_HORIZONTAL_MERGE, u"HorizontalMerge"},
        { PROP_HIDE_TAB_LEADER_AND_PAGE_NUMBERS, u"HideTabLeaderAndPageNumber"},
        { PROP_TAB_IN_TOC, u"TabInTOC"},
        { PROP_TOC_BOOKMARK, u"TOCBookmark"},
        { PROP_TOC_NEW_LINE, u"TOCNewLine"},
        { PROP_TOC_PARAGRAPH_OUTLINE_LEVEL, u"TOCParagraphOutlineLevel"},
        { PROP_CHAR_THEME_COLOR_TINT, u"CharThemeColorTint"},
        { PROP_CHAR_GLOW_TEXT_EFFECT, u"CharGlowTextEffect"},
        { PROP_CHAR_SHADOW_TEXT_EFFECT, u"CharShadowTextEffect"},
        { PROP_CHAR_REFLECTION_TEXT_EFFECT, u"CharReflectionTextEffect"},
        { PROP_CHAR_TEXTOUTLINE_TEXT_EFFECT, u"CharTextOutlineTextEffect"},
        { PROP_CHAR_TEXTFILL_TEXT_EFFECT, u"CharTextFillTextEffect"},
        { PROP_CHAR_SCENE3D_TEXT_EFFECT, u"CharScene3DTextEffect"},
        { PROP_CHAR_PROPS3D_TEXT_EFFECT, u"CharProps3DTextEffect"},
        { PROP_CHAR_LIGATURES_TEXT_EFFECT, u"CharLigaturesTextEffect"},
        { PROP_CHAR_NUMFORM_TEXT_EFFECT, u"CharNumFormTextEffect"},
        { PROP_CHAR_NUMSPACING_TEXT_EFFECT, u"CharNumSpacingTextEffect"},
        { PROP_CHAR_STYLISTICSETS_TEXT_EFFECT, u"CharStylisticSetsTextEffect"},
        { PROP_CHAR_CNTXTALTS_TEXT_EFFECT, u"CharCntxtAltsTextEffect"},
        { PROP_SDTPR, u"SdtPr"},
        { PROP_CELL_INTEROP_GRAB_BAG, u"CellInteropGrabBag"},
        { PROP_TABLE_INTEROP_GRAB_BAG, u"TableInteropGrabBag"},
        { PROP_APPLY_PARAGRAPH_MARK_FORMAT_TO_NUMBERING, u"ApplyParagraphMarkFormatToNumbering"},
        { PROP_SDT_END_BEFORE, u"SdtEndBefore"},
        { PROP_PARA_SDT_END_BEFORE, u"ParaSdtEndBefore"},
        { META_PROP_TABLE_LOOK, u"TableStyleLook"},
        { PROP_PARA_CNF_STYLE, u"ParaCnfStyle"},
        { PROP_CELL_CNF_STYLE, u"CellCnfStyle"},
        { PROP_ROW_CNF_STYLE, u"RowCnfStyle"},
        { PROP_CELL_HIDE_MARK, u"CellHideMark"},
        { PROP_FOLLOW_TEXT_FLOW, u"IsFollowingTextFlow"},
        { PROP_FILL_STYLE, u"FillStyle"},
        { PROP_FILL_COLOR, u"FillColor"},
        { PROP_FILL_COMPLEX_COLOR, u"FillComplexColor"},
        { PROP_SNAP_TO_GRID, u"SnapToGrid"},
        { PROP_GRID_SNAP_TO_CHARS, u"GridSnapToChars"},
        { PROP_RUBY_STYLE, u"RubyCharStyleName"},
        { PROP_RUBY_TEXT, u"RubyText"},
        { PROP_RUBY_ADJUST, u"RubyAdjust"},
        { PROP_RUBY_POSITION, u"RubyPosition"},
        { PROP_DATABASE_NAME, u"DataBaseName"},
        { PROP_COMMAND_TYPE, u"DataCommandType"},
        { PROP_DATATABLE_NAME, u"DataTableName"},
        { PROP_DATACOLUMN_NAME, u"DataColumnName"},
        { PROP_CHAR_TRANSPARENCE, u"CharTransparence"},
        { PROP_CELL_FORMULA, u"CellFormula"},
        { PROP_CELL_FORMULA_CONVERTED, u"CellFormulaConverted"},
        { PROP_GUTTER_MARGIN, u"GutterMargin"},
        { PROP_RTL_GUTTER, u"RtlGutter"},
        { PROP_CURSOR_NOT_IGNORE_TABLES_IN_HF, u"CursorNotIgnoreTables"},
        { PROP_PARA_CONNECT_BORDERS, u"ParaIsConnectBorder"},
        { PROP_DECORATIVE, u"Decorative"},
    });
} // end anonymous ns

OUString getPropertyName( PropertyIds eId )
{
    auto iterator = constPropertyMap.find(eId);
    if (iterator != constPropertyMap.end())
        return OUString(iterator->second);

    return OUString();
}

bool isCharacterProperty( const PropertyIds eId )
{
    return eId > PROP_CHARACTER_STYLES && eId < PROP_CHARACTER_END;
}

bool isParagraphProperty( const PropertyIds eId )
{
    return (eId >= PROP_PARA_ADJUST && eId <= PROP_PARA_WIDOWS)
        || eId == PROP_FILL_COLOR
        || eId == PROP_FILL_COMPLEX_COLOR;
}

} //namespace writerfilter

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
