/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_EDITENG_UNONAMES_HXX
#define INCLUDED_EDITENG_UNONAMES_HXX

#include <rtl/ustring.hxx>

// Common across fields
inline constexpr OUStringLiteral UNO_TC_PROP_ANCHOR = u"Anchor";
inline constexpr OUStringLiteral UNO_TC_PROP_TEXTFIELD_TYPE = u"TextFieldType";
inline constexpr OUStringLiteral UNO_TC_PROP_IS_FIXED = u"IsFixed";
inline constexpr OUStringLiteral UNO_TC_PROP_CURRENT_PRESENTATION = u"CurrentPresentation";
inline constexpr OUStringLiteral UNO_TC_PROP_NAME = u"Name";
inline constexpr OUStringLiteral UNO_TC_PROP_IS_FIXED_LANGUAGE = u"IsFixedLanguage";
inline constexpr OUStringLiteral UNO_TC_PROP_NUMFORMAT = u"NumberFormat";

// Date & Time
inline constexpr OUStringLiteral UNO_TC_PROP_IS_DATE = u"IsDate";
inline constexpr OUStringLiteral UNO_TC_PROP_DATE_TIME = u"DateTime";

// URL
inline constexpr OUStringLiteral UNO_TC_PROP_URL_FORMAT = u"Format";
inline constexpr OUStringLiteral UNO_TC_PROP_URL_REPRESENTATION = u"Representation";
inline constexpr OUStringLiteral UNO_TC_PROP_URL_TARGET = u"TargetFrame";
inline constexpr OUStringLiteral UNO_TC_PROP_URL = u"URL";

// Table
inline constexpr OUStringLiteral UNO_TC_PROP_TABLE_POSITION = u"TablePosition";

// File
inline constexpr OUStringLiteral UNO_TC_PROP_FILE_FORMAT = u"FileFormat";

// Author
inline constexpr OUStringLiteral UNO_TC_PROP_AUTHOR_CONTENT = u"Content";
inline constexpr OUStringLiteral UNO_TC_PROP_AUTHOR_FORMAT = u"AuthorFormat";
inline constexpr OUStringLiteral UNO_TC_PROP_AUTHOR_FULLNAME = u"FullName";

// Measure
inline constexpr OUStringLiteral UNO_TC_PROP_MEASURE_KIND = u"Kind";

inline constexpr OUStringLiteral UNO_TR_PROP_SELECTION = u"Selection";

#endif // INCLUDED_EDITENG_UNONAMES_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
