/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SVX_SDTFSITM_HXX
#define INCLUDED_SVX_SDTFSITM_HXX

#include <svl/eitem.hxx>
#include <svx/svddef.hxx>
#include <svx/svxdllapi.h>

enum class SdrFitToSizeType
{
    NONE,         // - no fit-to-size
    Proportional, // - resize all glyphs proportionally
                  //   (might scale anisotrophically)
    AllLines,     // - like SdrFitToSizeType::Proportional, but
                  //   scales each line separately
    Autofit       // - mimics PPT's automatic adaption of
                  //   font size to text rect - comparable
                  //   to SdrFitToSizeType::Proportional, but
                  //   scales isotrophically
};

// No AutoGrow and no automatic line breaks for
// SdrFitToSizeType::Proportional and SdrFitToSizeType::AllLines.
// No automatic line breaks for AutoGrowingWidth as well (only if
// TextMaxFrameWidth is reached).


class SVX_DLLPUBLIC SdrTextFitToSizeTypeItem: public SfxEnumItem<SdrFitToSizeType> {
public:
    static SfxPoolItem* CreateDefault();
    SdrTextFitToSizeTypeItem(SdrFitToSizeType eFit=SdrFitToSizeType::NONE): SfxEnumItem(SDRATTR_TEXT_FITTOSIZE, eFit) {}
    SdrTextFitToSizeTypeItem(SvStream& rIn)                        : SfxEnumItem(SDRATTR_TEXT_FITTOSIZE, rIn)  {}
    virtual SfxPoolItem*     Clone(SfxItemPool* pPool=nullptr) const override;
    virtual SfxPoolItem*     Create(SvStream& rIn, sal_uInt16 nVer) const override;
    virtual sal_uInt16       GetValueCount() const override;

    virtual bool             QueryValue( css::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const override;
    virtual bool             PutValue( const css::uno::Any& rVal, sal_uInt8 nMemberId ) override;

    virtual OUString         GetValueTextByPos(sal_uInt16 nPos) const override;
    virtual bool GetPresentation(SfxItemPresentation ePres, MapUnit eCoreMetric, MapUnit ePresMetric, OUString& rText, const IntlWrapper * = nullptr) const override;
    virtual bool             HasBoolValue() const override;
    virtual bool             GetBoolValue() const override;
    virtual void             SetBoolValue(bool bVal) override;
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
