
# -*- coding: utf-8 -*-

#
# Generated  by generateDS.py version 2.29.24.
#

import base64
import datetime as datetime_
import re as re_
import sys
import warnings as warnings_

try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for a example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:
    
    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            if type(self) != type(other):
                return False
            return self.__dict__ == other.__dict__
        def __ne__(self, other):
            return not self.__eq__(other)
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class EnvelopeType(GeneratedsSuper):
    """Root OVF descriptor type"""
    subclass = None
    superclass = None
    def __init__(self, lang='en-US', References=None, Section=None, Content=None, Strings=None):
        self.original_tagname_ = None
        self.lang = _cast(None, lang)
        self.References = References
        if Section is None:
            self.Section = []
        else:
            self.Section = Section
        self.Content = Content
        if Strings is None:
            self.Strings = []
        else:
            self.Strings = Strings
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EnvelopeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EnvelopeType.subclass:
            return EnvelopeType.subclass(*args_, **kwargs_)
        else:
            return EnvelopeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_References(self): return self.References
    def set_References(self, References): self.References = References
    def get_Section(self): return self.Section
    def set_Section(self, Section): self.Section = Section
    def add_Section(self, value): self.Section.append(value)
    def insert_Section_at(self, index, value): self.Section.insert(index, value)
    def replace_Section_at(self, index, value): self.Section[index] = value
    def get_Content(self): return self.Content
    def set_Content(self, Content): self.Content = Content
    def get_Strings(self): return self.Strings
    def set_Strings(self, Strings): self.Strings = Strings
    def add_Strings(self, value): self.Strings.append(value)
    def insert_Strings_at(self, index, value): self.Strings.insert(index, value)
    def replace_Strings_at(self, index, value): self.Strings[index] = value
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.References is not None or
            self.Section or
            self.Content is not None or
            self.Strings
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='EnvelopeType', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EnvelopeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EnvelopeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='EnvelopeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='EnvelopeType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.lang != "en-US" and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='EnvelopeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.References is not None:
            self.References.export(outfile, level, namespaceprefix_, name_='References', pretty_print=pretty_print)
        for Section_ in self.Section:
            Section_.export(outfile, level, namespaceprefix_='ovf:', name_='Section', pretty_print=pretty_print)
        if self.Content is not None:
            self.Content.export(outfile, level, namespaceprefix_='ovf:', name_='Content', pretty_print=pretty_print)
        for Strings_ in self.Strings:
            Strings_.export(outfile, level, namespaceprefix_, name_='Strings', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'References':
            obj_ = References_Type.factory()
            obj_.build(child_)
            self.References = obj_
            obj_.original_tagname_ = 'References'
        elif nodeName_ == 'Section':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Section> element')
            self.Section.append(obj_)
            obj_.original_tagname_ = 'Section'
        elif nodeName_ == 'AnnotationSection':
            obj_ = AnnotationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'AnnotationSection'
        elif nodeName_ == 'ProductSection':
            obj_ = ProductSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ProductSection'
        elif nodeName_ == 'NetworkSection':
            obj_ = NetworkSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'NetworkSection'
        elif nodeName_ == 'DiskSection':
            obj_ = DiskSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DiskSection'
        elif nodeName_ == 'OperatingSystemSection':
            obj_ = OperatingSystemSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'OperatingSystemSection'
        elif nodeName_ == 'EulaSection':
            obj_ = EulaSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'EulaSection'
        elif nodeName_ == 'VirtualHardwareSection':
            obj_ = VirtualHardwareSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'VirtualHardwareSection'
        elif nodeName_ == 'ResourceAllocationSection':
            obj_ = ResourceAllocationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ResourceAllocationSection'
        elif nodeName_ == 'InstallSection':
            obj_ = InstallSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'InstallSection'
        elif nodeName_ == 'StartupSection':
            obj_ = StartupSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'StartupSection'
        elif nodeName_ == 'DeploymentOptionSection':
            obj_ = DeploymentOptionSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DeploymentOptionSection'
        elif nodeName_ == 'Content':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Content> element')
            self.Content = obj_
            obj_.original_tagname_ = 'Content'
        elif nodeName_ == 'VirtualSystem':
            obj_ = VirtualSystem_Type.factory()
            obj_.build(child_)
            self.Content = obj_
            obj_.original_tagname_ = 'VirtualSystem'
        elif nodeName_ == 'VirtualSystemCollection':
            obj_ = VirtualSystemCollection_Type.factory()
            obj_.build(child_)
            self.Content = obj_
            obj_.original_tagname_ = 'VirtualSystemCollection'
        elif nodeName_ == 'Strings':
            obj_ = Strings_Type.factory()
            obj_.build(child_)
            self.Strings.append(obj_)
            obj_.original_tagname_ = 'Strings'
# end class EnvelopeType


class References_Type(GeneratedsSuper):
    """Type for list of external resources"""
    subclass = None
    superclass = None
    def __init__(self, File=None, anytypeobjs_=None):
        self.original_tagname_ = None
        if File is None:
            self.File = []
        else:
            self.File = File
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, References_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if References_Type.subclass:
            return References_Type.subclass(*args_, **kwargs_)
        else:
            return References_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def add_File(self, value): self.File.append(value)
    def insert_File_at(self, index, value): self.File.insert(index, value)
    def replace_File_at(self, index, value): self.File[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.File or
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='References_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('References_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='References_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='References_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='References_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='References_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for File_ in self.File:
            File_.export(outfile, level, namespaceprefix_, name_='File', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File':
            obj_ = File_Type.factory()
            obj_.build(child_)
            self.File.append(obj_)
            obj_.original_tagname_ = 'File'
        else:
            obj_ = self.gds_build_any(child_, 'References_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
# end class References_Type


class File_Type(GeneratedsSuper):
    """Type for an external reference to a resourceReference key used in
    other parts of the packageLocation of external resourceSize in
    bytes of the files (if known)Compression type (gzip, bzip2, or
    none if empty or not specified)Chunk size (except for last
    chunk)"""
    subclass = None
    superclass = None
    def __init__(self, id=None, href=None, size=None, compression='', chunkSize=None, anytypeobjs_=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.href = _cast(None, href)
        self.size = _cast(int, size)
        self.compression = _cast(None, compression)
        self.chunkSize = _cast(int, chunkSize)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, File_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if File_Type.subclass:
            return File_Type.subclass(*args_, **kwargs_)
        else:
            return File_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_compression(self): return self.compression
    def set_compression(self, compression): self.compression = compression
    def get_chunkSize(self): return self.chunkSize
    def set_chunkSize(self, chunkSize): self.chunkSize = chunkSize
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='File_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('File_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='File_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='File_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='File_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.href), input_name='href')), ))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            outfile.write(' size="%s"' % self.gds_format_integer(self.size, input_name='size'))
        if self.compression != "" and 'compression' not in already_processed:
            already_processed.add('compression')
            outfile.write(' compression=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.compression), input_name='compression')), ))
        if self.chunkSize is not None and 'chunkSize' not in already_processed:
            already_processed.add('chunkSize')
            outfile.write(' chunkSize="%s"' % self.gds_format_integer(self.chunkSize, input_name='chunkSize'))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='File_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('size', node)
        if value is not None and 'size' not in already_processed:
            already_processed.add('size')
            try:
                self.size = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('compression', node)
        if value is not None and 'compression' not in already_processed:
            already_processed.add('compression')
            self.compression = value
        value = find_attr_value_('chunkSize', node)
        if value is not None and 'chunkSize' not in already_processed:
            already_processed.add('chunkSize')
            try:
                self.chunkSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'File_Type')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class File_Type


class Content_Type(GeneratedsSuper):
    """Base class for content"""
    subclass = None
    superclass = None
    def __init__(self, id=None, Info=None, Name=None, Section=None, extensiontype_=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.Info = Info
        self.Name = Name
        if Section is None:
            self.Section = []
        else:
            self.Section = Section
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Content_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Content_Type.subclass:
            return Content_Type.subclass(*args_, **kwargs_)
        else:
            return Content_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Info(self): return self.Info
    def set_Info(self, Info): self.Info = Info
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Section(self): return self.Section
    def set_Section(self, Section): self.Section = Section
    def add_Section(self, value): self.Section.append(value)
    def insert_Section_at(self, index, value): self.Section.insert(index, value)
    def replace_Section_at(self, index, value): self.Section[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Info is not None or
            self.Name is not None or
            self.Section
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='Content_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Content_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Content_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='Content_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='Content_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='Content_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Info is not None:
            self.Info.export(outfile, level, namespaceprefix_, name_='Info', pretty_print=pretty_print)
        if self.Name is not None:
            self.Name.export(outfile, level, namespaceprefix_, name_='Name', pretty_print=pretty_print)
        for Section_ in self.Section:
            Section_.export(outfile, level, namespaceprefix_='ovf:', name_='Section', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Info':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Info = obj_
            obj_.original_tagname_ = 'Info'
        elif nodeName_ == 'Name':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Name = obj_
            obj_.original_tagname_ = 'Name'
        elif nodeName_ == 'Section':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Section> element')
            self.Section.append(obj_)
            obj_.original_tagname_ = 'Section'
        elif nodeName_ == 'AnnotationSection':
            obj_ = AnnotationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'AnnotationSection'
        elif nodeName_ == 'ProductSection':
            obj_ = ProductSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ProductSection'
        elif nodeName_ == 'NetworkSection':
            obj_ = NetworkSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'NetworkSection'
        elif nodeName_ == 'DiskSection':
            obj_ = DiskSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DiskSection'
        elif nodeName_ == 'OperatingSystemSection':
            obj_ = OperatingSystemSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'OperatingSystemSection'
        elif nodeName_ == 'EulaSection':
            obj_ = EulaSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'EulaSection'
        elif nodeName_ == 'VirtualHardwareSection':
            obj_ = VirtualHardwareSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'VirtualHardwareSection'
        elif nodeName_ == 'ResourceAllocationSection':
            obj_ = ResourceAllocationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ResourceAllocationSection'
        elif nodeName_ == 'InstallSection':
            obj_ = InstallSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'InstallSection'
        elif nodeName_ == 'StartupSection':
            obj_ = StartupSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'StartupSection'
        elif nodeName_ == 'DeploymentOptionSection':
            obj_ = DeploymentOptionSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DeploymentOptionSection'
# end class Content_Type


class VirtualSystem_Type(Content_Type):
    """Content describing a virtual system"""
    subclass = None
    superclass = Content_Type
    def __init__(self, id=None, Info=None, Name=None, Section=None):
        self.original_tagname_ = None
        super(VirtualSystem_Type, self).__init__(id, Info, Name, Section, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VirtualSystem_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VirtualSystem_Type.subclass:
            return VirtualSystem_Type.subclass(*args_, **kwargs_)
        else:
            return VirtualSystem_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(VirtualSystem_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='VirtualSystem_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VirtualSystem_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VirtualSystem_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='VirtualSystem_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='VirtualSystem_Type'):
        super(VirtualSystem_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VirtualSystem_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='VirtualSystem_Type', fromsubclass_=False, pretty_print=True):
        super(VirtualSystem_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VirtualSystem_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(VirtualSystem_Type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class VirtualSystem_Type


class VirtualSystemCollection_Type(Content_Type):
    """A collection of Content."""
    subclass = None
    superclass = Content_Type
    def __init__(self, id=None, Info=None, Name=None, Section=None, Content=None):
        self.original_tagname_ = None
        super(VirtualSystemCollection_Type, self).__init__(id, Info, Name, Section, )
        if Content is None:
            self.Content = []
        else:
            self.Content = Content
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VirtualSystemCollection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VirtualSystemCollection_Type.subclass:
            return VirtualSystemCollection_Type.subclass(*args_, **kwargs_)
        else:
            return VirtualSystemCollection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Content(self): return self.Content
    def set_Content(self, Content): self.Content = Content
    def add_Content(self, value): self.Content.append(value)
    def insert_Content_at(self, index, value): self.Content.insert(index, value)
    def replace_Content_at(self, index, value): self.Content[index] = value
    def hasContent_(self):
        if (
            self.Content or
            super(VirtualSystemCollection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='VirtualSystemCollection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VirtualSystemCollection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VirtualSystemCollection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='VirtualSystemCollection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='VirtualSystemCollection_Type'):
        super(VirtualSystemCollection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VirtualSystemCollection_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='VirtualSystemCollection_Type', fromsubclass_=False, pretty_print=True):
        super(VirtualSystemCollection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Content_ in self.Content:
            Content_.export(outfile, level, namespaceprefix_='ovf:', name_='Content', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VirtualSystemCollection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Content':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Content> element')
            self.Content.append(obj_)
            obj_.original_tagname_ = 'Content'
        elif nodeName_ == 'VirtualSystem':
            obj_ = VirtualSystem_Type.factory()
            obj_.build(child_)
            self.Content.append(obj_)
            obj_.original_tagname_ = 'VirtualSystem'
        elif nodeName_ == 'VirtualSystemCollection':
            obj_ = VirtualSystemCollection_Type.factory()
            obj_.build(child_)
            self.Content.append(obj_)
            obj_.original_tagname_ = 'VirtualSystemCollection'
        super(VirtualSystemCollection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class VirtualSystemCollection_Type


class Strings_Type(GeneratedsSuper):
    """Type for string resource bundleLocale for this string resource
    bundleReference to external resource bundle"""
    subclass = None
    superclass = None
    def __init__(self, lang=None, fileRef=None, Msg=None):
        self.original_tagname_ = None
        self.lang = _cast(None, lang)
        self.fileRef = _cast(None, fileRef)
        if Msg is None:
            self.Msg = []
        else:
            self.Msg = Msg
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Strings_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Strings_Type.subclass:
            return Strings_Type.subclass(*args_, **kwargs_)
        else:
            return Strings_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Msg(self): return self.Msg
    def set_Msg(self, Msg): self.Msg = Msg
    def add_Msg(self, value): self.Msg.append(value)
    def insert_Msg_at(self, index, value): self.Msg.insert(index, value)
    def replace_Msg_at(self, index, value): self.Msg[index] = value
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def get_fileRef(self): return self.fileRef
    def set_fileRef(self, fileRef): self.fileRef = fileRef
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.Msg
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='Strings_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Strings_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Strings_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='Strings_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='Strings_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.fileRef is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            outfile.write(' fileRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.fileRef), input_name='fileRef')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='Strings_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Msg_ in self.Msg:
            Msg_.export(outfile, level, namespaceprefix_, name_='Msg', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('fileRef', node)
        if value is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            self.fileRef = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Msg':
            obj_ = MsgType.factory()
            obj_.build(child_)
            self.Msg.append(obj_)
            obj_.original_tagname_ = 'Msg'
# end class Strings_Type


class Section_Type(GeneratedsSuper):
    """Base type for Sections, subclassing this is the most common form of
    extensibility. Subtypes define more specific elements."""
    subclass = None
    superclass = None
    def __init__(self, required=None, Info=None, extensiontype_=None):
        self.original_tagname_ = None
        self.required = _cast(bool, required)
        self.Info = Info
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Section_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Section_Type.subclass:
            return Section_Type.subclass(*args_, **kwargs_)
        else:
            return Section_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Info(self): return self.Info
    def set_Info(self, Info): self.Info = Info
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Info is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='Section_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Section_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Section_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='Section_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='Section_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.required, input_name='required'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='Section_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Info is not None:
            self.Info.export(outfile, level, namespaceprefix_, name_='Info', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.add('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Info':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Info = obj_
            obj_.original_tagname_ = 'Info'
# end class Section_Type


class Msg_Type(GeneratedsSuper):
    """Type for localizable stringDefault string valueIdentifier for lookup
    in string resource bundle for alternate locale"""
    subclass = None
    superclass = None
    def __init__(self, msgid='', valueOf_=None):
        self.original_tagname_ = None
        self.msgid = _cast(None, msgid)
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Msg_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Msg_Type.subclass:
            return Msg_Type.subclass(*args_, **kwargs_)
        else:
            return Msg_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_msgid(self): return self.msgid
    def set_msgid(self, msgid): self.msgid = msgid
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='Msg_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Msg_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Msg_Type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='Msg_Type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='Msg_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.msgid != "" and 'msgid' not in already_processed:
            already_processed.add('msgid')
            outfile.write(' msgid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.msgid), input_name='msgid')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='Msg_Type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('msgid', node)
        if value is not None and 'msgid' not in already_processed:
            already_processed.add('msgid')
            self.msgid = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Msg_Type


class AnnotationSection_Type(Section_Type):
    """User defined annotation"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Annotation=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(AnnotationSection_Type, self).__init__(required, Info, )
        self.Annotation = Annotation
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AnnotationSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AnnotationSection_Type.subclass:
            return AnnotationSection_Type.subclass(*args_, **kwargs_)
        else:
            return AnnotationSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Annotation(self): return self.Annotation
    def set_Annotation(self, Annotation): self.Annotation = Annotation
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Annotation is not None or
            self.anytypeobjs_ or
            super(AnnotationSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='AnnotationSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AnnotationSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AnnotationSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='AnnotationSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='AnnotationSection_Type'):
        super(AnnotationSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AnnotationSection_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='AnnotationSection_Type', fromsubclass_=False, pretty_print=True):
        super(AnnotationSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Annotation is not None:
            self.Annotation.export(outfile, level, namespaceprefix_, name_='Annotation', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AnnotationSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Annotation':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Annotation = obj_
            obj_.original_tagname_ = 'Annotation'
        else:
            obj_ = self.gds_build_any(child_, 'AnnotationSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(AnnotationSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class AnnotationSection_Type


class ProductSection_Type(Section_Type):
    """Product information for a virtual applianceProperties for
    application-level customizationProperty identifier
    prefixProperty identifier suffix"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, class_='', instance='', Product=None, Vendor=None, Version=None, FullVersion=None, ProductUrl=None, VendorUrl=None, AppUrl=None, Icon=None, Category=None, Property=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(ProductSection_Type, self).__init__(required, Info, )
        self.class_ = _cast(None, class_)
        self.instance = _cast(None, instance)
        self.Product = Product
        self.Vendor = Vendor
        self.Version = Version
        self.FullVersion = FullVersion
        self.ProductUrl = ProductUrl
        self.VendorUrl = VendorUrl
        self.AppUrl = AppUrl
        if Icon is None:
            self.Icon = []
        else:
            self.Icon = Icon
        if Category is None:
            self.Category = []
        else:
            self.Category = Category
        if Property is None:
            self.Property = []
        else:
            self.Property = Property
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ProductSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProductSection_Type.subclass:
            return ProductSection_Type.subclass(*args_, **kwargs_)
        else:
            return ProductSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Product(self): return self.Product
    def set_Product(self, Product): self.Product = Product
    def get_Vendor(self): return self.Vendor
    def set_Vendor(self, Vendor): self.Vendor = Vendor
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_FullVersion(self): return self.FullVersion
    def set_FullVersion(self, FullVersion): self.FullVersion = FullVersion
    def get_ProductUrl(self): return self.ProductUrl
    def set_ProductUrl(self, ProductUrl): self.ProductUrl = ProductUrl
    def get_VendorUrl(self): return self.VendorUrl
    def set_VendorUrl(self, VendorUrl): self.VendorUrl = VendorUrl
    def get_AppUrl(self): return self.AppUrl
    def set_AppUrl(self, AppUrl): self.AppUrl = AppUrl
    def get_Icon(self): return self.Icon
    def set_Icon(self, Icon): self.Icon = Icon
    def add_Icon(self, value): self.Icon.append(value)
    def insert_Icon_at(self, index, value): self.Icon.insert(index, value)
    def replace_Icon_at(self, index, value): self.Icon[index] = value
    def get_Category(self): return self.Category
    def set_Category(self, Category): self.Category = Category
    def add_Category(self, value): self.Category.append(value)
    def insert_Category_at(self, index, value): self.Category.insert(index, value)
    def replace_Category_at(self, index, value): self.Category[index] = value
    def get_Property(self): return self.Property
    def set_Property(self, Property): self.Property = Property
    def add_Property(self, value): self.Property.append(value)
    def insert_Property_at(self, index, value): self.Property.insert(index, value)
    def replace_Property_at(self, index, value): self.Property[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_class(self): return self.class_
    def set_class(self, class_): self.class_ = class_
    def get_instance(self): return self.instance
    def set_instance(self, instance): self.instance = instance
    def hasContent_(self):
        if (
            self.Product is not None or
            self.Vendor is not None or
            self.Version is not None or
            self.FullVersion is not None or
            self.ProductUrl is not None or
            self.VendorUrl is not None or
            self.AppUrl is not None or
            self.Icon or
            self.Category or
            self.Property or
            self.anytypeobjs_ or
            super(ProductSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='ProductSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common" ', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ProductSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ProductSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='ProductSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='ProductSection_Type'):
        super(ProductSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ProductSection_Type')
        if self.class_ != "" and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.class_), input_name='class')), ))
        if self.instance != "" and 'instance' not in already_processed:
            already_processed.add('instance')
            outfile.write(' instance=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.instance), input_name='instance')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='ProductSection_Type', fromsubclass_=False, pretty_print=True):
        super(ProductSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Product is not None:
            self.Product.export(outfile, level, namespaceprefix_, name_='Product', pretty_print=pretty_print)
        if self.Vendor is not None:
            self.Vendor.export(outfile, level, namespaceprefix_, name_='Vendor', pretty_print=pretty_print)
        if self.Version is not None:
            self.Version.export(outfile, level, namespaceprefix_, name_='Version', pretty_print=pretty_print)
        if self.FullVersion is not None:
            self.FullVersion.export(outfile, level, namespaceprefix_, name_='FullVersion', pretty_print=pretty_print)
        if self.ProductUrl is not None:
            self.ProductUrl.export(outfile, level, namespaceprefix_, name_='ProductUrl', pretty_print=pretty_print)
        if self.VendorUrl is not None:
            self.VendorUrl.export(outfile, level, namespaceprefix_, name_='VendorUrl', pretty_print=pretty_print)
        if self.AppUrl is not None:
            self.AppUrl.export(outfile, level, namespaceprefix_, name_='AppUrl', pretty_print=pretty_print)
        for Icon_ in self.Icon:
            Icon_.export(outfile, level, namespaceprefix_, name_='Icon', pretty_print=pretty_print)
        for Category_ in self.Category:
            Category_.export(outfile, level, namespaceprefix_, name_='Category', pretty_print=pretty_print)
        for Property_ in self.Property:
            Property_.export(outfile, level, namespaceprefix_, name_='Property', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('instance', node)
        if value is not None and 'instance' not in already_processed:
            already_processed.add('instance')
            self.instance = value
        super(ProductSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Product':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Product = obj_
            obj_.original_tagname_ = 'Product'
        elif nodeName_ == 'Vendor':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Vendor = obj_
            obj_.original_tagname_ = 'Vendor'
        elif nodeName_ == 'Version':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Version = obj_
            obj_.original_tagname_ = 'Version'
        elif nodeName_ == 'FullVersion':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.FullVersion = obj_
            obj_.original_tagname_ = 'FullVersion'
        elif nodeName_ == 'ProductUrl':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ProductUrl = obj_
            obj_.original_tagname_ = 'ProductUrl'
        elif nodeName_ == 'VendorUrl':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VendorUrl = obj_
            obj_.original_tagname_ = 'VendorUrl'
        elif nodeName_ == 'AppUrl':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AppUrl = obj_
            obj_.original_tagname_ = 'AppUrl'
        elif nodeName_ == 'Icon':
            obj_ = IconType.factory()
            obj_.build(child_)
            self.Icon.append(obj_)
            obj_.original_tagname_ = 'Icon'
        elif nodeName_ == 'Category':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Category.append(obj_)
            obj_.original_tagname_ = 'Category'
        elif nodeName_ == 'Property':
            obj_ = PropertyType.factory()
            obj_.build(child_)
            self.Property.append(obj_)
            obj_.original_tagname_ = 'Property'
        else:
            obj_ = self.gds_build_any(child_, 'ProductSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(ProductSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class ProductSection_Type


class PropertyConfigurationValue_Type(GeneratedsSuper):
    """Type for alternative default values for properties when
    DeploymentOptionSection is usedAlternative default property
    valueConfiguration from DeploymentOptionSection in which this
    value is default"""
    subclass = None
    superclass = None
    def __init__(self, value=None, configuration=None, anytypeobjs_=None):
        self.original_tagname_ = None
        self.value = _cast(None, value)
        self.configuration = _cast(None, configuration)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PropertyConfigurationValue_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PropertyConfigurationValue_Type.subclass:
            return PropertyConfigurationValue_Type.subclass(*args_, **kwargs_)
        else:
            return PropertyConfigurationValue_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_configuration(self): return self.configuration
    def set_configuration(self, configuration): self.configuration = configuration
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='PropertyConfigurationValue_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PropertyConfigurationValue_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PropertyConfigurationValue_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='PropertyConfigurationValue_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='PropertyConfigurationValue_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')), ))
        if self.configuration is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            outfile.write(' configuration=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.configuration), input_name='configuration')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='PropertyConfigurationValue_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
        value = find_attr_value_('configuration', node)
        if value is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            self.configuration = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'PropertyConfigurationValue_Type')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class PropertyConfigurationValue_Type


class NetworkSection_Type(Section_Type):
    """Descriptions of logical networks used within the package"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Network=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(NetworkSection_Type, self).__init__(required, Info, )
        if Network is None:
            self.Network = []
        else:
            self.Network = Network
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NetworkSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NetworkSection_Type.subclass:
            return NetworkSection_Type.subclass(*args_, **kwargs_)
        else:
            return NetworkSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Network(self): return self.Network
    def set_Network(self, Network): self.Network = Network
    def add_Network(self, value): self.Network.append(value)
    def insert_Network_at(self, index, value): self.Network.insert(index, value)
    def replace_Network_at(self, index, value): self.Network[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Network or
            self.anytypeobjs_ or
            super(NetworkSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='NetworkSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('NetworkSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='NetworkSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='NetworkSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='NetworkSection_Type'):
        super(NetworkSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='NetworkSection_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='NetworkSection_Type', fromsubclass_=False, pretty_print=True):
        super(NetworkSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Network_ in self.Network:
            Network_.export(outfile, level, namespaceprefix_, name_='Network', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NetworkSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Network':
            obj_ = NetworkType.factory()
            obj_.build(child_)
            self.Network.append(obj_)
            obj_.original_tagname_ = 'Network'
        else:
            obj_ = self.gds_build_any(child_, 'NetworkSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(NetworkSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class NetworkSection_Type


class DiskSection_Type(Section_Type):
    """Descriptions of virtual disks used within the package"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Disk=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(DiskSection_Type, self).__init__(required, Info, )
        if Disk is None:
            self.Disk = []
        else:
            self.Disk = Disk
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DiskSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DiskSection_Type.subclass:
            return DiskSection_Type.subclass(*args_, **kwargs_)
        else:
            return DiskSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Disk(self): return self.Disk
    def set_Disk(self, Disk): self.Disk = Disk
    def add_Disk(self, value): self.Disk.append(value)
    def insert_Disk_at(self, index, value): self.Disk.insert(index, value)
    def replace_Disk_at(self, index, value): self.Disk[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Disk or
            self.anytypeobjs_ or
            super(DiskSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='DiskSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DiskSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DiskSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='DiskSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='DiskSection_Type'):
        super(DiskSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DiskSection_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='DiskSection_Type', fromsubclass_=False, pretty_print=True):
        super(DiskSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Disk_ in self.Disk:
            Disk_.export(outfile, level, namespaceprefix_, name_='Disk', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DiskSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Disk':
            obj_ = VirtualDiskDesc_Type.factory()
            obj_.build(child_)
            self.Disk.append(obj_)
            obj_.original_tagname_ = 'Disk'
        else:
            obj_ = self.gds_build_any(child_, 'DiskSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(DiskSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class DiskSection_Type


class VirtualDiskDesc_Type(GeneratedsSuper):
    """Type for virtual disk descriptorIdentifier for virtual diskReference
    to virtual disk content. If not specified a blank virtual disk
    is created of size given by capacity attributeVirtual disk
    capacity, can be specified as either an xs:long size or as a
    reference to a property using ${property_name}. Unit of
    allocation for ovf:capacity. If not specified default value is
    bytes. Value shall match a recognized value for the UNITS
    qualifier in DSP0004.Format of virtual disk given as a URI that
    identifies the disk typeEstimated populated size of disk in
    bytesReference to potential parent disk"""
    subclass = None
    superclass = None
    def __init__(self, diskId=None, fileRef=None, capacity=None, capacityAllocationUnits='byte', format=None, populatedSize=None, parentRef=None, anytypeobjs_=None):
        self.original_tagname_ = None
        self.diskId = _cast(None, diskId)
        self.fileRef = _cast(None, fileRef)
        self.capacity = _cast(None, capacity)
        self.capacityAllocationUnits = _cast(None, capacityAllocationUnits)
        self.format = _cast(None, format)
        self.populatedSize = _cast(int, populatedSize)
        self.parentRef = _cast(None, parentRef)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VirtualDiskDesc_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VirtualDiskDesc_Type.subclass:
            return VirtualDiskDesc_Type.subclass(*args_, **kwargs_)
        else:
            return VirtualDiskDesc_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_diskId(self): return self.diskId
    def set_diskId(self, diskId): self.diskId = diskId
    def get_fileRef(self): return self.fileRef
    def set_fileRef(self, fileRef): self.fileRef = fileRef
    def get_capacity(self): return self.capacity
    def set_capacity(self, capacity): self.capacity = capacity
    def get_capacityAllocationUnits(self): return self.capacityAllocationUnits
    def set_capacityAllocationUnits(self, capacityAllocationUnits): self.capacityAllocationUnits = capacityAllocationUnits
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_populatedSize(self): return self.populatedSize
    def set_populatedSize(self, populatedSize): self.populatedSize = populatedSize
    def get_parentRef(self): return self.parentRef
    def set_parentRef(self, parentRef): self.parentRef = parentRef
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='VirtualDiskDesc_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VirtualDiskDesc_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VirtualDiskDesc_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='VirtualDiskDesc_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='VirtualDiskDesc_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.diskId is not None and 'diskId' not in already_processed:
            already_processed.add('diskId')
            outfile.write(' diskId=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.diskId), input_name='diskId')), ))
        if self.fileRef is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            outfile.write(' fileRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.fileRef), input_name='fileRef')), ))
        if self.capacity is not None and 'capacity' not in already_processed:
            already_processed.add('capacity')
            outfile.write(' capacity=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.capacity), input_name='capacity')), ))
        if self.capacityAllocationUnits != "byte" and 'capacityAllocationUnits' not in already_processed:
            already_processed.add('capacityAllocationUnits')
            outfile.write(' capacityAllocationUnits=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.capacityAllocationUnits), input_name='capacityAllocationUnits')), ))
        if self.format is not None and 'format' not in already_processed:
            already_processed.add('format')
            outfile.write(' format=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.format), input_name='format')), ))
        if self.populatedSize is not None and 'populatedSize' not in already_processed:
            already_processed.add('populatedSize')
            outfile.write(' populatedSize="%s"' % self.gds_format_integer(self.populatedSize, input_name='populatedSize'))
        if self.parentRef is not None and 'parentRef' not in already_processed:
            already_processed.add('parentRef')
            outfile.write(' parentRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.parentRef), input_name='parentRef')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='VirtualDiskDesc_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('diskId', node)
        if value is not None and 'diskId' not in already_processed:
            already_processed.add('diskId')
            self.diskId = value
        value = find_attr_value_('fileRef', node)
        if value is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            self.fileRef = value
        value = find_attr_value_('capacity', node)
        if value is not None and 'capacity' not in already_processed:
            already_processed.add('capacity')
            self.capacity = value
        value = find_attr_value_('capacityAllocationUnits', node)
        if value is not None and 'capacityAllocationUnits' not in already_processed:
            already_processed.add('capacityAllocationUnits')
            self.capacityAllocationUnits = value
        value = find_attr_value_('format', node)
        if value is not None and 'format' not in already_processed:
            already_processed.add('format')
            self.format = value
        value = find_attr_value_('populatedSize', node)
        if value is not None and 'populatedSize' not in already_processed:
            already_processed.add('populatedSize')
            try:
                self.populatedSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('parentRef', node)
        if value is not None and 'parentRef' not in already_processed:
            already_processed.add('parentRef')
            self.parentRef = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'VirtualDiskDesc_Type')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class VirtualDiskDesc_Type


class OperatingSystemSection_Type(Section_Type):
    """Specification of the operating system installed in the
    guestIdentifier defined by the CIM_OperatingSystem.OsType
    enumerationVersion defined by the CIM_OperatingSystem.Version
    field"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, id=None, version=None, Description=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(OperatingSystemSection_Type, self).__init__(required, Info, )
        self.id = _cast(int, id)
        self.version = _cast(None, version)
        self.Description = Description
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OperatingSystemSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OperatingSystemSection_Type.subclass:
            return OperatingSystemSection_Type.subclass(*args_, **kwargs_)
        else:
            return OperatingSystemSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def hasContent_(self):
        if (
            self.Description is not None or
            self.anytypeobjs_ or
            super(OperatingSystemSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='OperatingSystemSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OperatingSystemSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OperatingSystemSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='OperatingSystemSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='OperatingSystemSection_Type'):
        super(OperatingSystemSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OperatingSystemSection_Type')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='OperatingSystemSection_Type', fromsubclass_=False, pretty_print=True):
        super(OperatingSystemSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, namespaceprefix_, name_='Description', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        super(OperatingSystemSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
        else:
            obj_ = self.gds_build_any(child_, 'OperatingSystemSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(OperatingSystemSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class OperatingSystemSection_Type


class EulaSection_Type(Section_Type):
    """End-User License Agreement"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, License=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(EulaSection_Type, self).__init__(required, Info, )
        self.License = License
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EulaSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EulaSection_Type.subclass:
            return EulaSection_Type.subclass(*args_, **kwargs_)
        else:
            return EulaSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_License(self): return self.License
    def set_License(self, License): self.License = License
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.License is not None or
            self.anytypeobjs_ or
            super(EulaSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='EulaSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EulaSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EulaSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='EulaSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='EulaSection_Type'):
        super(EulaSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EulaSection_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='EulaSection_Type', fromsubclass_=False, pretty_print=True):
        super(EulaSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.License is not None:
            self.License.export(outfile, level, namespaceprefix_, name_='License', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(EulaSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'License':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.License = obj_
            obj_.original_tagname_ = 'License'
        else:
            obj_ = self.gds_build_any(child_, 'EulaSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(EulaSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class EulaSection_Type


class VirtualHardwareSection_Type(Section_Type):
    """Specifies virtual hardware requirements for a virtual machineUnique
    identifier of this VirtualHardwareSection (within a
    VirtualSystem)"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, id='', transport=None, System=None, Item=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(VirtualHardwareSection_Type, self).__init__(required, Info, )
        self.id = _cast(None, id)
        self.transport = _cast(None, transport)
        self.System = System
        if Item is None:
            self.Item = []
        else:
            self.Item = Item
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VirtualHardwareSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VirtualHardwareSection_Type.subclass:
            return VirtualHardwareSection_Type.subclass(*args_, **kwargs_)
        else:
            return VirtualHardwareSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_System(self): return self.System
    def set_System(self, System): self.System = System
    def get_Item(self): return self.Item
    def set_Item(self, Item): self.Item = Item
    def add_Item(self, value): self.Item.append(value)
    def insert_Item_at(self, index, value): self.Item.insert(index, value)
    def replace_Item_at(self, index, value): self.Item[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_transport(self): return self.transport
    def set_transport(self, transport): self.transport = transport
    def hasContent_(self):
        if (
            self.System is not None or
            self.Item or
            self.anytypeobjs_ or
            super(VirtualHardwareSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='VirtualHardwareSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VirtualHardwareSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VirtualHardwareSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='VirtualHardwareSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='VirtualHardwareSection_Type'):
        super(VirtualHardwareSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VirtualHardwareSection_Type')
        if self.id != "" and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.transport is not None and 'transport' not in already_processed:
            already_processed.add('transport')
            outfile.write(' transport=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.transport), input_name='transport')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='VirtualHardwareSection_Type', fromsubclass_=False, pretty_print=True):
        super(VirtualHardwareSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.System is not None:
            self.System.export(outfile, level, namespaceprefix_, name_='System', pretty_print=pretty_print)
        for Item_ in self.Item:
            Item_.export(outfile, level, namespaceprefix_, name_='Item', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('transport', node)
        if value is not None and 'transport' not in already_processed:
            already_processed.add('transport')
            self.transport = value
        super(VirtualHardwareSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'System':
            obj_ = VSSD_Type.factory()
            obj_.build(child_)
            self.System = obj_
            obj_.original_tagname_ = 'System'
        elif nodeName_ == 'Item':
            obj_ = RASD_Type.factory()
            obj_.build(child_)
            self.Item.append(obj_)
            obj_.original_tagname_ = 'Item'
        else:
            obj_ = self.gds_build_any(child_, 'VirtualHardwareSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(VirtualHardwareSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class VirtualHardwareSection_Type


class ResourceAllocationSection_Type(Section_Type):
    """Resource constraints on a VirtualSystemCollection"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Item=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(ResourceAllocationSection_Type, self).__init__(required, Info, )
        if Item is None:
            self.Item = []
        else:
            self.Item = Item
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResourceAllocationSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResourceAllocationSection_Type.subclass:
            return ResourceAllocationSection_Type.subclass(*args_, **kwargs_)
        else:
            return ResourceAllocationSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Item(self): return self.Item
    def set_Item(self, Item): self.Item = Item
    def add_Item(self, value): self.Item.append(value)
    def insert_Item_at(self, index, value): self.Item.insert(index, value)
    def replace_Item_at(self, index, value): self.Item[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Item or
            self.anytypeobjs_ or
            super(ResourceAllocationSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='ResourceAllocationSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResourceAllocationSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResourceAllocationSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='ResourceAllocationSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='ResourceAllocationSection_Type'):
        super(ResourceAllocationSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResourceAllocationSection_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='ResourceAllocationSection_Type', fromsubclass_=False, pretty_print=True):
        super(ResourceAllocationSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Item_ in self.Item:
            Item_.export(outfile, level, namespaceprefix_, name_='Item', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ResourceAllocationSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Item':
            obj_ = RASD_Type.factory()
            obj_.build(child_)
            self.Item.append(obj_)
            obj_.original_tagname_ = 'Item'
        else:
            obj_ = self.gds_build_any(child_, 'ResourceAllocationSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(ResourceAllocationSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class ResourceAllocationSection_Type


class InstallSection_Type(Section_Type):
    """If present indicates that the virtual machine needs to be initially
    booted to install and configure the softwareDelay in seconds to
    wait for power off to complete after initial boot"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, initialBootStopDelay=0, anytypeobjs_=None):
        self.original_tagname_ = None
        super(InstallSection_Type, self).__init__(required, Info, )
        self.initialBootStopDelay = _cast(int, initialBootStopDelay)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InstallSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InstallSection_Type.subclass:
            return InstallSection_Type.subclass(*args_, **kwargs_)
        else:
            return InstallSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_initialBootStopDelay(self): return self.initialBootStopDelay
    def set_initialBootStopDelay(self, initialBootStopDelay): self.initialBootStopDelay = initialBootStopDelay
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(InstallSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='InstallSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InstallSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InstallSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='InstallSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='InstallSection_Type'):
        super(InstallSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InstallSection_Type')
        if self.initialBootStopDelay != 0 and 'initialBootStopDelay' not in already_processed:
            already_processed.add('initialBootStopDelay')
            outfile.write(' initialBootStopDelay="%s"' % self.gds_format_integer(self.initialBootStopDelay, input_name='initialBootStopDelay'))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='InstallSection_Type', fromsubclass_=False, pretty_print=True):
        super(InstallSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('initialBootStopDelay', node)
        if value is not None and 'initialBootStopDelay' not in already_processed:
            already_processed.add('initialBootStopDelay')
            try:
                self.initialBootStopDelay = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(InstallSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'InstallSection_Type')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(InstallSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class InstallSection_Type


class StartupSection_Type(Section_Type):
    """Specifies the order in which entities in a VirtualSystemCollection
    are powered on and shut down"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Item=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(StartupSection_Type, self).__init__(required, Info, )
        if Item is None:
            self.Item = []
        else:
            self.Item = Item
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StartupSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StartupSection_Type.subclass:
            return StartupSection_Type.subclass(*args_, **kwargs_)
        else:
            return StartupSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Item(self): return self.Item
    def set_Item(self, Item): self.Item = Item
    def add_Item(self, value): self.Item.append(value)
    def insert_Item_at(self, index, value): self.Item.insert(index, value)
    def replace_Item_at(self, index, value): self.Item[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Item or
            self.anytypeobjs_ or
            super(StartupSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='StartupSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('StartupSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='StartupSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='StartupSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='StartupSection_Type'):
        super(StartupSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='StartupSection_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='StartupSection_Type', fromsubclass_=False, pretty_print=True):
        super(StartupSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Item_ in self.Item:
            Item_.export(outfile, level, namespaceprefix_, name_='Item', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StartupSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Item':
            obj_ = ItemType.factory()
            obj_.build(child_)
            self.Item.append(obj_)
            obj_.original_tagname_ = 'Item'
        else:
            obj_ = self.gds_build_any(child_, 'StartupSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(StartupSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class StartupSection_Type


class DeploymentOptionSection_Type(Section_Type):
    """Enumeration of discrete deployment options"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Configuration=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(DeploymentOptionSection_Type, self).__init__(required, Info, )
        if Configuration is None:
            self.Configuration = []
        else:
            self.Configuration = Configuration
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DeploymentOptionSection_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DeploymentOptionSection_Type.subclass:
            return DeploymentOptionSection_Type.subclass(*args_, **kwargs_)
        else:
            return DeploymentOptionSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Configuration(self): return self.Configuration
    def set_Configuration(self, Configuration): self.Configuration = Configuration
    def add_Configuration(self, value): self.Configuration.append(value)
    def insert_Configuration_at(self, index, value): self.Configuration.insert(index, value)
    def replace_Configuration_at(self, index, value): self.Configuration[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Configuration or
            self.anytypeobjs_ or
            super(DeploymentOptionSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='DeploymentOptionSection_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DeploymentOptionSection_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeploymentOptionSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='DeploymentOptionSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='DeploymentOptionSection_Type'):
        super(DeploymentOptionSection_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DeploymentOptionSection_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='DeploymentOptionSection_Type', fromsubclass_=False, pretty_print=True):
        super(DeploymentOptionSection_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Configuration_ in self.Configuration:
            Configuration_.export(outfile, level, namespaceprefix_, name_='Configuration', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DeploymentOptionSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Configuration':
            obj_ = ConfigurationType.factory()
            obj_.build(child_)
            self.Configuration.append(obj_)
            obj_.original_tagname_ = 'Configuration'
        else:
            obj_ = self.gds_build_any(child_, 'DeploymentOptionSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(DeploymentOptionSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class DeploymentOptionSection_Type


class cimDateTime(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, CIM_DateTime=None, Interval=None, Date=None, Time=None, Datetime=None):
        self.original_tagname_ = None
        self.CIM_DateTime = CIM_DateTime
        self.Interval = Interval
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%d').date()
        else:
            initvalue_ = Date
        self.Date = initvalue_
        if isinstance(Time, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Time, '%H:%M:%S').time()
        else:
            initvalue_ = Time
        self.Time = initvalue_
        if isinstance(Datetime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Datetime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Datetime
        self.Datetime = initvalue_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimDateTime)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimDateTime.subclass:
            return cimDateTime.subclass(*args_, **kwargs_)
        else:
            return cimDateTime(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CIM_DateTime(self): return self.CIM_DateTime
    def set_CIM_DateTime(self, CIM_DateTime): self.CIM_DateTime = CIM_DateTime
    def get_Interval(self): return self.Interval
    def set_Interval(self, Interval): self.Interval = Interval
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def get_Time(self): return self.Time
    def set_Time(self, Time): self.Time = Time
    def get_Datetime(self): return self.Datetime
    def set_Datetime(self, Datetime): self.Datetime = Datetime
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.CIM_DateTime is not None or
            self.Interval is not None or
            self.Date is not None or
            self.Time is not None or
            self.Datetime is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimDateTime', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimDateTime')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimDateTime')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimDateTime', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimDateTime'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimDateTime', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CIM_DateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cim:CIM_DateTime>%s</cim:CIM_DateTime>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.CIM_DateTime), input_name='CIM_DateTime')), eol_))
        if self.Interval is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cim:Interval>%s</cim:Interval>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.Interval), input_name='Interval')), eol_))
        if self.Date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cim:Date>%s</cim:Date>%s' % (self.gds_format_date(self.Date, input_name='Date'), eol_))
        if self.Time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cim:Time>%s</cim:Time>%s' % (self.gds_format_time(self.Time, input_name='Time'), eol_))
        if self.Datetime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cim:Datetime>%s</cim:Datetime>%s' % (self.gds_format_datetime(self.Datetime, input_name='Datetime'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CIM_DateTime':
            CIM_DateTime_ = child_.text
            CIM_DateTime_ = self.gds_validate_string(CIM_DateTime_, node, 'CIM_DateTime')
            self.CIM_DateTime = CIM_DateTime_
        elif nodeName_ == 'Interval':
            Interval_ = child_.text
            Interval_ = self.gds_validate_string(Interval_, node, 'Interval')
            self.Interval = Interval_
        elif nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.Date = dval_
        elif nodeName_ == 'Time':
            sval_ = child_.text
            dval_ = self.gds_parse_time(sval_)
            self.Time = dval_
        elif nodeName_ == 'Datetime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Datetime = dval_
# end class cimDateTime


class cimUnsignedByte(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimUnsignedByte)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimUnsignedByte.subclass:
            return cimUnsignedByte.subclass(*args_, **kwargs_)
        else:
            return cimUnsignedByte(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimUnsignedByte', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimUnsignedByte')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimUnsignedByte')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimUnsignedByte', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimUnsignedByte'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimUnsignedByte', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimUnsignedByte


class cimByte(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimByte)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimByte.subclass:
            return cimByte.subclass(*args_, **kwargs_)
        else:
            return cimByte(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimByte', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimByte')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimByte')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimByte', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimByte'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimByte', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimByte


class cimUnsignedShort(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimUnsignedShort)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimUnsignedShort.subclass:
            return cimUnsignedShort.subclass(*args_, **kwargs_)
        else:
            return cimUnsignedShort(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimUnsignedShort', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimUnsignedShort')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimUnsignedShort')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimUnsignedShort', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimUnsignedShort'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimUnsignedShort', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimUnsignedShort


class cimShort(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimShort)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimShort.subclass:
            return cimShort.subclass(*args_, **kwargs_)
        else:
            return cimShort(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimShort', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimShort')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimShort')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimShort', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimShort'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimShort', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimShort


class cimUnsignedInt(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimUnsignedInt)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimUnsignedInt.subclass:
            return cimUnsignedInt.subclass(*args_, **kwargs_)
        else:
            return cimUnsignedInt(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimUnsignedInt', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimUnsignedInt')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimUnsignedInt')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimUnsignedInt', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimUnsignedInt'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimUnsignedInt', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimUnsignedInt


class cimInt(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimInt)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimInt.subclass:
            return cimInt.subclass(*args_, **kwargs_)
        else:
            return cimInt(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimInt', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimInt')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimInt')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimInt', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimInt'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimInt', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimInt


class cimUnsignedLong(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimUnsignedLong)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimUnsignedLong.subclass:
            return cimUnsignedLong.subclass(*args_, **kwargs_)
        else:
            return cimUnsignedLong(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimUnsignedLong', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimUnsignedLong')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimUnsignedLong')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimUnsignedLong', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimUnsignedLong'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimUnsignedLong', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimUnsignedLong


class cimLong(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimLong)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimLong.subclass:
            return cimLong.subclass(*args_, **kwargs_)
        else:
            return cimLong(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimLong', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimLong')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimLong')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimLong', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimLong'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimLong', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimLong


class cimString(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimString)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimString.subclass:
            return cimString.subclass(*args_, **kwargs_)
        else:
            return cimString(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimString', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimString')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimString')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimString', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimString'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimString', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimString


class cimBoolean(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimBoolean)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimBoolean.subclass:
            return cimBoolean.subclass(*args_, **kwargs_)
        else:
            return cimBoolean(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimBoolean', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimBoolean')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimBoolean')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimBoolean', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimBoolean'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimBoolean', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimBoolean


class cimFloat(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimFloat)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimFloat.subclass:
            return cimFloat.subclass(*args_, **kwargs_)
        else:
            return cimFloat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimFloat', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimFloat')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimFloat')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimFloat', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimFloat'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimFloat', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimFloat


class cimDouble(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimDouble)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimDouble.subclass:
            return cimDouble.subclass(*args_, **kwargs_)
        else:
            return cimDouble(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimDouble', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimDouble')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimDouble')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimDouble', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimDouble'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimDouble', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimDouble


class cimChar16(cimString):
    subclass = None
    superclass = cimString
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(cimChar16, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimChar16)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimChar16.subclass:
            return cimChar16.subclass(*args_, **kwargs_)
        else:
            return cimChar16(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(cimChar16, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimChar16', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimChar16')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimChar16')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimChar16', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimChar16'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(cimChar16, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimChar16')
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimChar16', fromsubclass_=False, pretty_print=True):
        super(cimChar16, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(cimChar16, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimChar16


class cimBase64Binary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimBase64Binary)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimBase64Binary.subclass:
            return cimBase64Binary.subclass(*args_, **kwargs_)
        else:
            return cimBase64Binary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimBase64Binary', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimBase64Binary')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimBase64Binary')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimBase64Binary', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimBase64Binary'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimBase64Binary', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimBase64Binary


class cimReference(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, anytypeobjs_=None):
        self.original_tagname_ = None
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimReference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimReference.subclass:
            return cimReference.subclass(*args_, **kwargs_)
        else:
            return cimReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimReference', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimReference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimReference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimReference'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimReference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'cimReference')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class cimReference


class cimHexBinary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimHexBinary)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimHexBinary.subclass:
            return cimHexBinary.subclass(*args_, **kwargs_)
        else:
            return cimHexBinary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimHexBinary', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimHexBinary')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimHexBinary')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimHexBinary', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimHexBinary'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimHexBinary', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimHexBinary


class cimAnySimpleType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cimAnySimpleType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cimAnySimpleType.subclass:
            return cimAnySimpleType.subclass(*args_, **kwargs_)
        else:
            return cimAnySimpleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='cimAnySimpleType', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cimAnySimpleType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cimAnySimpleType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='cimAnySimpleType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='cimAnySimpleType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='cimAnySimpleType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimAnySimpleType


class qualifierString(cimString):
    subclass = None
    superclass = cimString
    def __init__(self, qualifier=None, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        super(qualifierString, self).__init__(valueOf_, extensiontype_, )
        self.qualifier = _cast(bool, qualifier)
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, qualifierString)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if qualifierString.subclass:
            return qualifierString.subclass(*args_, **kwargs_)
        else:
            return qualifierString(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(qualifierString, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='qualifierString', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('qualifierString')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierString')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='qualifierString', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='qualifierString'):
        super(qualifierString, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierString')
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            outfile.write(' qualifier="%s"' % self.gds_format_boolean(self.qualifier, input_name='qualifier'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='qualifierString', fromsubclass_=False, pretty_print=True):
        super(qualifierString, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualifier', node)
        if value is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            if value in ('true', '1'):
                self.qualifier = True
            elif value in ('false', '0'):
                self.qualifier = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(qualifierString, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class qualifierString


class qualifierBoolean(cimBoolean):
    subclass = None
    superclass = cimBoolean
    def __init__(self, qualifier=None, valueOf_=None):
        self.original_tagname_ = None
        super(qualifierBoolean, self).__init__(valueOf_, )
        self.qualifier = _cast(bool, qualifier)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, qualifierBoolean)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if qualifierBoolean.subclass:
            return qualifierBoolean.subclass(*args_, **kwargs_)
        else:
            return qualifierBoolean(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(qualifierBoolean, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='qualifierBoolean', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('qualifierBoolean')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierBoolean')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='qualifierBoolean', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='qualifierBoolean'):
        super(qualifierBoolean, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierBoolean')
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            outfile.write(' qualifier="%s"' % self.gds_format_boolean(self.qualifier, input_name='qualifier'))
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='qualifierBoolean', fromsubclass_=False, pretty_print=True):
        super(qualifierBoolean, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualifier', node)
        if value is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            if value in ('true', '1'):
                self.qualifier = True
            elif value in ('false', '0'):
                self.qualifier = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(qualifierBoolean, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class qualifierBoolean


class qualifierUInt32(cimUnsignedInt):
    subclass = None
    superclass = cimUnsignedInt
    def __init__(self, qualifier=None, valueOf_=None):
        self.original_tagname_ = None
        super(qualifierUInt32, self).__init__(valueOf_, )
        self.qualifier = _cast(bool, qualifier)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, qualifierUInt32)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if qualifierUInt32.subclass:
            return qualifierUInt32.subclass(*args_, **kwargs_)
        else:
            return qualifierUInt32(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(qualifierUInt32, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='qualifierUInt32', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('qualifierUInt32')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierUInt32')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='qualifierUInt32', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='qualifierUInt32'):
        super(qualifierUInt32, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierUInt32')
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            outfile.write(' qualifier="%s"' % self.gds_format_boolean(self.qualifier, input_name='qualifier'))
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='qualifierUInt32', fromsubclass_=False, pretty_print=True):
        super(qualifierUInt32, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualifier', node)
        if value is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            if value in ('true', '1'):
                self.qualifier = True
            elif value in ('false', '0'):
                self.qualifier = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(qualifierUInt32, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class qualifierUInt32


class qualifierSInt64(cimLong):
    subclass = None
    superclass = cimLong
    def __init__(self, qualifier=None, valueOf_=None):
        self.original_tagname_ = None
        super(qualifierSInt64, self).__init__(valueOf_, )
        self.qualifier = _cast(bool, qualifier)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, qualifierSInt64)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if qualifierSInt64.subclass:
            return qualifierSInt64.subclass(*args_, **kwargs_)
        else:
            return qualifierSInt64(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(qualifierSInt64, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='qualifierSInt64', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('qualifierSInt64')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierSInt64')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='qualifierSInt64', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='qualifierSInt64'):
        super(qualifierSInt64, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierSInt64')
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            outfile.write(' qualifier="%s"' % self.gds_format_boolean(self.qualifier, input_name='qualifier'))
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='qualifierSInt64', fromsubclass_=False, pretty_print=True):
        super(qualifierSInt64, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualifier', node)
        if value is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            if value in ('true', '1'):
                self.qualifier = True
            elif value in ('false', '0'):
                self.qualifier = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(qualifierSInt64, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class qualifierSInt64


class qualifierSArray(qualifierString):
    subclass = None
    superclass = qualifierString
    def __init__(self, qualifier=None):
        self.original_tagname_ = None
        super(qualifierSArray, self).__init__(qualifier, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, qualifierSArray)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if qualifierSArray.subclass:
            return qualifierSArray.subclass(*args_, **kwargs_)
        else:
            return qualifierSArray(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(qualifierSArray, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='cim:', name_='qualifierSArray', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('qualifierSArray')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierSArray')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='cim:', name_='qualifierSArray', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='cim:', name_='qualifierSArray'):
        super(qualifierSArray, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='qualifierSArray')
    def exportChildren(self, outfile, level, namespaceprefix_='cim:', name_='qualifierSArray', fromsubclass_=False, pretty_print=True):
        super(qualifierSArray, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(qualifierSArray, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(qualifierSArray, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class qualifierSArray


class AutomaticStartupAction(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(AutomaticStartupAction, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AutomaticStartupAction)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AutomaticStartupAction.subclass:
            return AutomaticStartupAction.subclass(*args_, **kwargs_)
        else:
            return AutomaticStartupAction(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(AutomaticStartupAction, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='class:', name_='AutomaticStartupAction', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:class="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AutomaticStartupAction')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AutomaticStartupAction')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='class:', name_='AutomaticStartupAction', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='class:', name_='AutomaticStartupAction'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(AutomaticStartupAction, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AutomaticStartupAction')
    def exportChildren(self, outfile, level, namespaceprefix_='class:', name_='AutomaticStartupAction', fromsubclass_=False, pretty_print=True):
        super(AutomaticStartupAction, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(AutomaticStartupAction, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AutomaticStartupAction


class AutomaticShutdownAction(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(AutomaticShutdownAction, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AutomaticShutdownAction)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AutomaticShutdownAction.subclass:
            return AutomaticShutdownAction.subclass(*args_, **kwargs_)
        else:
            return AutomaticShutdownAction(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(AutomaticShutdownAction, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='class:', name_='AutomaticShutdownAction', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:class="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AutomaticShutdownAction')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AutomaticShutdownAction')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='class:', name_='AutomaticShutdownAction', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='class:', name_='AutomaticShutdownAction'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(AutomaticShutdownAction, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AutomaticShutdownAction')
    def exportChildren(self, outfile, level, namespaceprefix_='class:', name_='AutomaticShutdownAction', fromsubclass_=False, pretty_print=True):
        super(AutomaticShutdownAction, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(AutomaticShutdownAction, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AutomaticShutdownAction


class AutomaticRecoveryAction(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(AutomaticRecoveryAction, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AutomaticRecoveryAction)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AutomaticRecoveryAction.subclass:
            return AutomaticRecoveryAction.subclass(*args_, **kwargs_)
        else:
            return AutomaticRecoveryAction(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(AutomaticRecoveryAction, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='class:', name_='AutomaticRecoveryAction', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:class="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AutomaticRecoveryAction')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AutomaticRecoveryAction')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='class:', name_='AutomaticRecoveryAction', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='class:', name_='AutomaticRecoveryAction'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(AutomaticRecoveryAction, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AutomaticRecoveryAction')
    def exportChildren(self, outfile, level, namespaceprefix_='class:', name_='AutomaticRecoveryAction', fromsubclass_=False, pretty_print=True):
        super(AutomaticRecoveryAction, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(AutomaticRecoveryAction, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AutomaticRecoveryAction


class CIM_VirtualSystemSettingData_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, AutomaticRecoveryAction=None, AutomaticShutdownAction=None, AutomaticStartupAction=None, AutomaticStartupActionDelay=None, AutomaticStartupActionSequenceNumber=None, Caption=None, ConfigurationDataRoot=None, ConfigurationFile=None, ConfigurationID=None, CreationTime=None, Description=None, ElementName=None, InstanceID=None, LogDataRoot=None, Notes=None, RecoveryFile=None, SnapshotDataRoot=None, SuspendDataRoot=None, SwapFileDataRoot=None, VirtualSystemIdentifier=None, VirtualSystemType=None, anytypeobjs_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.AutomaticRecoveryAction = AutomaticRecoveryAction
        self.validate_AutomaticRecoveryAction(self.AutomaticRecoveryAction)
        self.AutomaticShutdownAction = AutomaticShutdownAction
        self.validate_AutomaticShutdownAction(self.AutomaticShutdownAction)
        self.AutomaticStartupAction = AutomaticStartupAction
        self.validate_AutomaticStartupAction(self.AutomaticStartupAction)
        self.AutomaticStartupActionDelay = AutomaticStartupActionDelay
        self.AutomaticStartupActionSequenceNumber = AutomaticStartupActionSequenceNumber
        self.Caption = Caption
        self.ConfigurationDataRoot = ConfigurationDataRoot
        self.ConfigurationFile = ConfigurationFile
        self.ConfigurationID = ConfigurationID
        self.CreationTime = CreationTime
        self.Description = Description
        self.ElementName = ElementName
        self.InstanceID = InstanceID
        self.LogDataRoot = LogDataRoot
        if Notes is None:
            self.Notes = []
        else:
            self.Notes = Notes
        self.RecoveryFile = RecoveryFile
        self.SnapshotDataRoot = SnapshotDataRoot
        self.SuspendDataRoot = SuspendDataRoot
        self.SwapFileDataRoot = SwapFileDataRoot
        self.VirtualSystemIdentifier = VirtualSystemIdentifier
        self.VirtualSystemType = VirtualSystemType
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CIM_VirtualSystemSettingData_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CIM_VirtualSystemSettingData_Type.subclass:
            return CIM_VirtualSystemSettingData_Type.subclass(*args_, **kwargs_)
        else:
            return CIM_VirtualSystemSettingData_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AutomaticRecoveryAction(self): return self.AutomaticRecoveryAction
    def set_AutomaticRecoveryAction(self, AutomaticRecoveryAction): self.AutomaticRecoveryAction = AutomaticRecoveryAction
    def get_AutomaticShutdownAction(self): return self.AutomaticShutdownAction
    def set_AutomaticShutdownAction(self, AutomaticShutdownAction): self.AutomaticShutdownAction = AutomaticShutdownAction
    def get_AutomaticStartupAction(self): return self.AutomaticStartupAction
    def set_AutomaticStartupAction(self, AutomaticStartupAction): self.AutomaticStartupAction = AutomaticStartupAction
    def get_AutomaticStartupActionDelay(self): return self.AutomaticStartupActionDelay
    def set_AutomaticStartupActionDelay(self, AutomaticStartupActionDelay): self.AutomaticStartupActionDelay = AutomaticStartupActionDelay
    def get_AutomaticStartupActionSequenceNumber(self): return self.AutomaticStartupActionSequenceNumber
    def set_AutomaticStartupActionSequenceNumber(self, AutomaticStartupActionSequenceNumber): self.AutomaticStartupActionSequenceNumber = AutomaticStartupActionSequenceNumber
    def get_Caption(self): return self.Caption
    def set_Caption(self, Caption): self.Caption = Caption
    def get_ConfigurationDataRoot(self): return self.ConfigurationDataRoot
    def set_ConfigurationDataRoot(self, ConfigurationDataRoot): self.ConfigurationDataRoot = ConfigurationDataRoot
    def get_ConfigurationFile(self): return self.ConfigurationFile
    def set_ConfigurationFile(self, ConfigurationFile): self.ConfigurationFile = ConfigurationFile
    def get_ConfigurationID(self): return self.ConfigurationID
    def set_ConfigurationID(self, ConfigurationID): self.ConfigurationID = ConfigurationID
    def get_CreationTime(self): return self.CreationTime
    def set_CreationTime(self, CreationTime): self.CreationTime = CreationTime
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_ElementName(self): return self.ElementName
    def set_ElementName(self, ElementName): self.ElementName = ElementName
    def get_InstanceID(self): return self.InstanceID
    def set_InstanceID(self, InstanceID): self.InstanceID = InstanceID
    def get_LogDataRoot(self): return self.LogDataRoot
    def set_LogDataRoot(self, LogDataRoot): self.LogDataRoot = LogDataRoot
    def get_Notes(self): return self.Notes
    def set_Notes(self, Notes): self.Notes = Notes
    def add_Notes(self, value): self.Notes.append(value)
    def insert_Notes_at(self, index, value): self.Notes.insert(index, value)
    def replace_Notes_at(self, index, value): self.Notes[index] = value
    def get_RecoveryFile(self): return self.RecoveryFile
    def set_RecoveryFile(self, RecoveryFile): self.RecoveryFile = RecoveryFile
    def get_SnapshotDataRoot(self): return self.SnapshotDataRoot
    def set_SnapshotDataRoot(self, SnapshotDataRoot): self.SnapshotDataRoot = SnapshotDataRoot
    def get_SuspendDataRoot(self): return self.SuspendDataRoot
    def set_SuspendDataRoot(self, SuspendDataRoot): self.SuspendDataRoot = SuspendDataRoot
    def get_SwapFileDataRoot(self): return self.SwapFileDataRoot
    def set_SwapFileDataRoot(self, SwapFileDataRoot): self.SwapFileDataRoot = SwapFileDataRoot
    def get_VirtualSystemIdentifier(self): return self.VirtualSystemIdentifier
    def set_VirtualSystemIdentifier(self, VirtualSystemIdentifier): self.VirtualSystemIdentifier = VirtualSystemIdentifier
    def get_VirtualSystemType(self): return self.VirtualSystemType
    def set_VirtualSystemType(self, VirtualSystemType): self.VirtualSystemType = VirtualSystemType
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_AutomaticRecoveryAction(self, value):
        # Validate type AutomaticRecoveryAction, a restriction on xs:unsignedShort.
        pass
    def validate_AutomaticShutdownAction(self, value):
        # Validate type AutomaticShutdownAction, a restriction on xs:unsignedShort.
        pass
    def validate_AutomaticStartupAction(self, value):
        # Validate type AutomaticStartupAction, a restriction on xs:unsignedShort.
        pass
    def hasContent_(self):
        if (
            self.AutomaticRecoveryAction is not None or
            self.AutomaticShutdownAction is not None or
            self.AutomaticStartupAction is not None or
            self.AutomaticStartupActionDelay is not None or
            self.AutomaticStartupActionSequenceNumber is not None or
            self.Caption is not None or
            self.ConfigurationDataRoot is not None or
            self.ConfigurationFile is not None or
            self.ConfigurationID is not None or
            self.CreationTime is not None or
            self.Description is not None or
            self.ElementName is not None or
            self.InstanceID is not None or
            self.LogDataRoot is not None or
            self.Notes or
            self.RecoveryFile is not None or
            self.SnapshotDataRoot is not None or
            self.SuspendDataRoot is not None or
            self.SwapFileDataRoot is not None or
            self.VirtualSystemIdentifier is not None or
            self.VirtualSystemType is not None or
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='class:', name_='CIM_VirtualSystemSettingData_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:class="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CIM_VirtualSystemSettingData_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CIM_VirtualSystemSettingData_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='class:', name_='CIM_VirtualSystemSettingData_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='class:', name_='CIM_VirtualSystemSettingData_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='class:', name_='CIM_VirtualSystemSettingData_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AutomaticRecoveryAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<class:AutomaticRecoveryAction>%s</class:AutomaticRecoveryAction>%s' % (self.gds_format_integer(self.AutomaticRecoveryAction, input_name='AutomaticRecoveryAction'), eol_))
        if self.AutomaticShutdownAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<class:AutomaticShutdownAction>%s</class:AutomaticShutdownAction>%s' % (self.gds_format_integer(self.AutomaticShutdownAction, input_name='AutomaticShutdownAction'), eol_))
        if self.AutomaticStartupAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<class:AutomaticStartupAction>%s</class:AutomaticStartupAction>%s' % (self.gds_format_integer(self.AutomaticStartupAction, input_name='AutomaticStartupAction'), eol_))
        if self.AutomaticStartupActionDelay is not None:
            self.AutomaticStartupActionDelay.export(outfile, level, namespaceprefix_='class:', name_='AutomaticStartupActionDelay', pretty_print=pretty_print)
        if self.AutomaticStartupActionSequenceNumber is not None:
            self.AutomaticStartupActionSequenceNumber.export(outfile, level, namespaceprefix_='class:', name_='AutomaticStartupActionSequenceNumber', pretty_print=pretty_print)
        if self.Caption is not None:
            self.Caption.export(outfile, level, namespaceprefix_='class:', name_='Caption', pretty_print=pretty_print)
        if self.ConfigurationDataRoot is not None:
            self.ConfigurationDataRoot.export(outfile, level, namespaceprefix_='class:', name_='ConfigurationDataRoot', pretty_print=pretty_print)
        if self.ConfigurationFile is not None:
            self.ConfigurationFile.export(outfile, level, namespaceprefix_='class:', name_='ConfigurationFile', pretty_print=pretty_print)
        if self.ConfigurationID is not None:
            self.ConfigurationID.export(outfile, level, namespaceprefix_='class:', name_='ConfigurationID', pretty_print=pretty_print)
        if self.CreationTime is not None:
            self.CreationTime.export(outfile, level, namespaceprefix_='class:', name_='CreationTime', pretty_print=pretty_print)
        if self.Description is not None:
            self.Description.export(outfile, level, namespaceprefix_='class:', name_='Description', pretty_print=pretty_print)
        if self.ElementName is not None:
            self.ElementName.export(outfile, level, namespaceprefix_='class:', name_='ElementName', pretty_print=pretty_print)
        if self.InstanceID is not None:
            self.InstanceID.export(outfile, level, namespaceprefix_='class:', name_='InstanceID', pretty_print=pretty_print)
        if self.LogDataRoot is not None:
            self.LogDataRoot.export(outfile, level, namespaceprefix_='class:', name_='LogDataRoot', pretty_print=pretty_print)
        for Notes_ in self.Notes:
            Notes_.export(outfile, level, namespaceprefix_='class:', name_='Notes', pretty_print=pretty_print)
        if self.RecoveryFile is not None:
            self.RecoveryFile.export(outfile, level, namespaceprefix_='class:', name_='RecoveryFile', pretty_print=pretty_print)
        if self.SnapshotDataRoot is not None:
            self.SnapshotDataRoot.export(outfile, level, namespaceprefix_='class:', name_='SnapshotDataRoot', pretty_print=pretty_print)
        if self.SuspendDataRoot is not None:
            self.SuspendDataRoot.export(outfile, level, namespaceprefix_='class:', name_='SuspendDataRoot', pretty_print=pretty_print)
        if self.SwapFileDataRoot is not None:
            self.SwapFileDataRoot.export(outfile, level, namespaceprefix_='class:', name_='SwapFileDataRoot', pretty_print=pretty_print)
        if self.VirtualSystemIdentifier is not None:
            self.VirtualSystemIdentifier.export(outfile, level, namespaceprefix_='class:', name_='VirtualSystemIdentifier', pretty_print=pretty_print)
        if self.VirtualSystemType is not None:
            self.VirtualSystemType.export(outfile, level, namespaceprefix_='class:', name_='VirtualSystemType', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AutomaticRecoveryAction' and child_.text:
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'AutomaticRecoveryAction')
            self.AutomaticRecoveryAction = ival_
            # validate type AutomaticRecoveryAction
            self.validate_AutomaticRecoveryAction(self.AutomaticRecoveryAction)
        elif nodeName_ == 'AutomaticShutdownAction' and child_.text:
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'AutomaticShutdownAction')
            self.AutomaticShutdownAction = ival_
            # validate type AutomaticShutdownAction
            self.validate_AutomaticShutdownAction(self.AutomaticShutdownAction)
        elif nodeName_ == 'AutomaticStartupAction' and child_.text:
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'AutomaticStartupAction')
            self.AutomaticStartupAction = ival_
            # validate type AutomaticStartupAction
            self.validate_AutomaticStartupAction(self.AutomaticStartupAction)
        elif nodeName_ == 'AutomaticStartupActionDelay':
            obj_ = cimDateTime.factory()
            obj_.build(child_)
            self.AutomaticStartupActionDelay = obj_
            obj_.original_tagname_ = 'AutomaticStartupActionDelay'
        elif nodeName_ == 'AutomaticStartupActionSequenceNumber':
            obj_ = cimUnsignedShort.factory()
            obj_.build(child_)
            self.AutomaticStartupActionSequenceNumber = obj_
            obj_.original_tagname_ = 'AutomaticStartupActionSequenceNumber'
        elif nodeName_ == 'Caption':
            obj_ = Caption.factory()
            obj_.build(child_)
            self.Caption = obj_
            obj_.original_tagname_ = 'Caption'
        elif nodeName_ == 'ConfigurationDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ConfigurationDataRoot = obj_
            obj_.original_tagname_ = 'ConfigurationDataRoot'
        elif nodeName_ == 'ConfigurationFile':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ConfigurationFile = obj_
            obj_.original_tagname_ = 'ConfigurationFile'
        elif nodeName_ == 'ConfigurationID':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ConfigurationID = obj_
            obj_.original_tagname_ = 'ConfigurationID'
        elif nodeName_ == 'CreationTime':
            obj_ = cimDateTime.factory()
            obj_.build(child_)
            self.CreationTime = obj_
            obj_.original_tagname_ = 'CreationTime'
        elif nodeName_ == 'Description':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
        elif nodeName_ == 'ElementName':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ElementName = obj_
            obj_.original_tagname_ = 'ElementName'
        elif nodeName_ == 'InstanceID':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.InstanceID = obj_
            obj_.original_tagname_ = 'InstanceID'
        elif nodeName_ == 'LogDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.LogDataRoot = obj_
            obj_.original_tagname_ = 'LogDataRoot'
        elif nodeName_ == 'Notes':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Notes.append(obj_)
            obj_.original_tagname_ = 'Notes'
        elif nodeName_ == 'RecoveryFile':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.RecoveryFile = obj_
            obj_.original_tagname_ = 'RecoveryFile'
        elif nodeName_ == 'SnapshotDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.SnapshotDataRoot = obj_
            obj_.original_tagname_ = 'SnapshotDataRoot'
        elif nodeName_ == 'SuspendDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.SuspendDataRoot = obj_
            obj_.original_tagname_ = 'SuspendDataRoot'
        elif nodeName_ == 'SwapFileDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.SwapFileDataRoot = obj_
            obj_.original_tagname_ = 'SwapFileDataRoot'
        elif nodeName_ == 'VirtualSystemIdentifier':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VirtualSystemIdentifier = obj_
            obj_.original_tagname_ = 'VirtualSystemIdentifier'
        elif nodeName_ == 'VirtualSystemType':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VirtualSystemType = obj_
            obj_.original_tagname_ = 'VirtualSystemType'
        else:
            obj_ = self.gds_build_any(child_, 'CIM_VirtualSystemSettingData_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
# end class CIM_VirtualSystemSettingData_Type


class ResourceType(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(ResourceType, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResourceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResourceType.subclass:
            return ResourceType.subclass(*args_, **kwargs_)
        else:
            return ResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(ResourceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='class:', name_='ResourceType', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:class="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResourceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResourceType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='class:', name_='ResourceType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='class:', name_='ResourceType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(ResourceType, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResourceType')
    def exportChildren(self, outfile, level, namespaceprefix_='class:', name_='ResourceType', fromsubclass_=False, pretty_print=True):
        super(ResourceType, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(ResourceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ResourceType


class ConsumerVisibility(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(ConsumerVisibility, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConsumerVisibility)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConsumerVisibility.subclass:
            return ConsumerVisibility.subclass(*args_, **kwargs_)
        else:
            return ConsumerVisibility(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(ConsumerVisibility, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='class:', name_='ConsumerVisibility', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:class="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ConsumerVisibility')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConsumerVisibility')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='class:', name_='ConsumerVisibility', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='class:', name_='ConsumerVisibility'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(ConsumerVisibility, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConsumerVisibility')
    def exportChildren(self, outfile, level, namespaceprefix_='class:', name_='ConsumerVisibility', fromsubclass_=False, pretty_print=True):
        super(ConsumerVisibility, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(ConsumerVisibility, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ConsumerVisibility


class MappingBehavior(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(MappingBehavior, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MappingBehavior)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MappingBehavior.subclass:
            return MappingBehavior.subclass(*args_, **kwargs_)
        else:
            return MappingBehavior(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(MappingBehavior, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='class:', name_='MappingBehavior', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:class="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MappingBehavior')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MappingBehavior')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='class:', name_='MappingBehavior', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='class:', name_='MappingBehavior'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(MappingBehavior, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MappingBehavior')
    def exportChildren(self, outfile, level, namespaceprefix_='class:', name_='MappingBehavior', fromsubclass_=False, pretty_print=True):
        super(MappingBehavior, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(MappingBehavior, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MappingBehavior


class Caption(cimString):
    subclass = None
    superclass = cimString
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(Caption, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Caption)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Caption.subclass:
            return Caption.subclass(*args_, **kwargs_)
        else:
            return Caption(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(Caption, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='class:', name_='Caption', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:class="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Caption')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Caption')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='class:', name_='Caption', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='class:', name_='Caption'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(Caption, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Caption')
    def exportChildren(self, outfile, level, namespaceprefix_='class:', name_='Caption', fromsubclass_=False, pretty_print=True):
        super(Caption, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(Caption, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Caption


class CIM_ResourceAllocationSettingData_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Address=None, AddressOnParent=None, AllocationUnits=None, AutomaticAllocation=None, AutomaticDeallocation=None, Caption=None, Connection=None, ConsumerVisibility=None, Description=None, ElementName=None, HostResource=None, InstanceID=None, Limit=None, MappingBehavior=None, OtherResourceType=None, Parent=None, PoolID=None, Reservation=None, ResourceSubType=None, ResourceType=None, VirtualQuantity=None, VirtualQuantityUnits=None, Weight=None, anytypeobjs_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.Address = Address
        self.AddressOnParent = AddressOnParent
        self.AllocationUnits = AllocationUnits
        self.AutomaticAllocation = AutomaticAllocation
        self.AutomaticDeallocation = AutomaticDeallocation
        self.Caption = Caption
        if Connection is None:
            self.Connection = []
        else:
            self.Connection = Connection
        self.ConsumerVisibility = ConsumerVisibility
        self.validate_ConsumerVisibility(self.ConsumerVisibility)
        self.Description = Description
        self.ElementName = ElementName
        if HostResource is None:
            self.HostResource = []
        else:
            self.HostResource = HostResource
        self.InstanceID = InstanceID
        self.Limit = Limit
        self.MappingBehavior = MappingBehavior
        self.validate_MappingBehavior(self.MappingBehavior)
        self.OtherResourceType = OtherResourceType
        self.Parent = Parent
        self.PoolID = PoolID
        self.Reservation = Reservation
        self.ResourceSubType = ResourceSubType
        self.ResourceType = ResourceType
        self.validate_ResourceType(self.ResourceType)
        self.VirtualQuantity = VirtualQuantity
        self.VirtualQuantityUnits = VirtualQuantityUnits
        self.Weight = Weight
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CIM_ResourceAllocationSettingData_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CIM_ResourceAllocationSettingData_Type.subclass:
            return CIM_ResourceAllocationSettingData_Type.subclass(*args_, **kwargs_)
        else:
            return CIM_ResourceAllocationSettingData_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def get_AddressOnParent(self): return self.AddressOnParent
    def set_AddressOnParent(self, AddressOnParent): self.AddressOnParent = AddressOnParent
    def get_AllocationUnits(self): return self.AllocationUnits
    def set_AllocationUnits(self, AllocationUnits): self.AllocationUnits = AllocationUnits
    def get_AutomaticAllocation(self): return self.AutomaticAllocation
    def set_AutomaticAllocation(self, AutomaticAllocation): self.AutomaticAllocation = AutomaticAllocation
    def get_AutomaticDeallocation(self): return self.AutomaticDeallocation
    def set_AutomaticDeallocation(self, AutomaticDeallocation): self.AutomaticDeallocation = AutomaticDeallocation
    def get_Caption(self): return self.Caption
    def set_Caption(self, Caption): self.Caption = Caption
    def get_Connection(self): return self.Connection
    def set_Connection(self, Connection): self.Connection = Connection
    def add_Connection(self, value): self.Connection.append(value)
    def insert_Connection_at(self, index, value): self.Connection.insert(index, value)
    def replace_Connection_at(self, index, value): self.Connection[index] = value
    def get_ConsumerVisibility(self): return self.ConsumerVisibility
    def set_ConsumerVisibility(self, ConsumerVisibility): self.ConsumerVisibility = ConsumerVisibility
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_ElementName(self): return self.ElementName
    def set_ElementName(self, ElementName): self.ElementName = ElementName
    def get_HostResource(self): return self.HostResource
    def set_HostResource(self, HostResource): self.HostResource = HostResource
    def add_HostResource(self, value): self.HostResource.append(value)
    def insert_HostResource_at(self, index, value): self.HostResource.insert(index, value)
    def replace_HostResource_at(self, index, value): self.HostResource[index] = value
    def get_InstanceID(self): return self.InstanceID
    def set_InstanceID(self, InstanceID): self.InstanceID = InstanceID
    def get_Limit(self): return self.Limit
    def set_Limit(self, Limit): self.Limit = Limit
    def get_MappingBehavior(self): return self.MappingBehavior
    def set_MappingBehavior(self, MappingBehavior): self.MappingBehavior = MappingBehavior
    def get_OtherResourceType(self): return self.OtherResourceType
    def set_OtherResourceType(self, OtherResourceType): self.OtherResourceType = OtherResourceType
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def get_PoolID(self): return self.PoolID
    def set_PoolID(self, PoolID): self.PoolID = PoolID
    def get_Reservation(self): return self.Reservation
    def set_Reservation(self, Reservation): self.Reservation = Reservation
    def get_ResourceSubType(self): return self.ResourceSubType
    def set_ResourceSubType(self, ResourceSubType): self.ResourceSubType = ResourceSubType
    def get_ResourceType(self): return self.ResourceType
    def set_ResourceType(self, ResourceType): self.ResourceType = ResourceType
    def get_VirtualQuantity(self): return self.VirtualQuantity
    def set_VirtualQuantity(self, VirtualQuantity): self.VirtualQuantity = VirtualQuantity
    def get_VirtualQuantityUnits(self): return self.VirtualQuantityUnits
    def set_VirtualQuantityUnits(self, VirtualQuantityUnits): self.VirtualQuantityUnits = VirtualQuantityUnits
    def get_Weight(self): return self.Weight
    def set_Weight(self, Weight): self.Weight = Weight
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_ConsumerVisibility(self, value):
        # Validate type ConsumerVisibility, a restriction on xs:unsignedShort.
        pass
    def validate_MappingBehavior(self, value):
        # Validate type MappingBehavior, a restriction on xs:unsignedShort.
        pass
    def validate_ResourceType(self, value):
        # Validate type ResourceType, a restriction on xs:unsignedShort.
        pass
    def hasContent_(self):
        if (
            self.Address is not None or
            self.AddressOnParent is not None or
            self.AllocationUnits is not None or
            self.AutomaticAllocation is not None or
            self.AutomaticDeallocation is not None or
            self.Caption is not None or
            self.Connection or
            self.ConsumerVisibility is not None or
            self.Description is not None or
            self.ElementName is not None or
            self.HostResource or
            self.InstanceID is not None or
            self.Limit is not None or
            self.MappingBehavior is not None or
            self.OtherResourceType is not None or
            self.Parent is not None or
            self.PoolID is not None or
            self.Reservation is not None or
            self.ResourceSubType is not None or
            self.ResourceType is not None or
            self.VirtualQuantity is not None or
            self.VirtualQuantityUnits is not None or
            self.Weight is not None or
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='class:', name_='CIM_ResourceAllocationSettingData_Type', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:class="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CIM_ResourceAllocationSettingData_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CIM_ResourceAllocationSettingData_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='class:', name_='CIM_ResourceAllocationSettingData_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='class:', name_='CIM_ResourceAllocationSettingData_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='class:', name_='CIM_ResourceAllocationSettingData_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Address is not None:
            self.Address.export(outfile, level, namespaceprefix_='class:', name_='Address', pretty_print=pretty_print)
        if self.AddressOnParent is not None:
            self.AddressOnParent.export(outfile, level, namespaceprefix_='class:', name_='AddressOnParent', pretty_print=pretty_print)
        if self.AllocationUnits is not None:
            self.AllocationUnits.export(outfile, level, namespaceprefix_='class:', name_='AllocationUnits', pretty_print=pretty_print)
        if self.AutomaticAllocation is not None:
            self.AutomaticAllocation.export(outfile, level, namespaceprefix_='class:', name_='AutomaticAllocation', pretty_print=pretty_print)
        if self.AutomaticDeallocation is not None:
            self.AutomaticDeallocation.export(outfile, level, namespaceprefix_='class:', name_='AutomaticDeallocation', pretty_print=pretty_print)
        if self.Caption is not None:
            self.Caption.export(outfile, level, namespaceprefix_='class:', name_='Caption', pretty_print=pretty_print)
        for Connection_ in self.Connection:
            Connection_.export(outfile, level, namespaceprefix_='class:', name_='Connection', pretty_print=pretty_print)
        if self.ConsumerVisibility is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<class:ConsumerVisibility>%s</class:ConsumerVisibility>%s' % (self.gds_format_integer(self.ConsumerVisibility, input_name='ConsumerVisibility'), eol_))
        if self.Description is not None:
            self.Description.export(outfile, level, namespaceprefix_='class:', name_='Description', pretty_print=pretty_print)
        if self.ElementName is not None:
            self.ElementName.export(outfile, level, namespaceprefix_='class:', name_='ElementName', pretty_print=pretty_print)
        for HostResource_ in self.HostResource:
            HostResource_.export(outfile, level, namespaceprefix_='class:', name_='HostResource', pretty_print=pretty_print)
        if self.InstanceID is not None:
            self.InstanceID.export(outfile, level, namespaceprefix_='class:', name_='InstanceID', pretty_print=pretty_print)
        if self.Limit is not None:
            self.Limit.export(outfile, level, namespaceprefix_='class:', name_='Limit', pretty_print=pretty_print)
        if self.MappingBehavior is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<class:MappingBehavior>%s</class:MappingBehavior>%s' % (self.gds_format_integer(self.MappingBehavior, input_name='MappingBehavior'), eol_))
        if self.OtherResourceType is not None:
            self.OtherResourceType.export(outfile, level, namespaceprefix_='class:', name_='OtherResourceType', pretty_print=pretty_print)
        if self.Parent is not None:
            self.Parent.export(outfile, level, namespaceprefix_='class:', name_='Parent', pretty_print=pretty_print)
        if self.PoolID is not None:
            self.PoolID.export(outfile, level, namespaceprefix_='class:', name_='PoolID', pretty_print=pretty_print)
        if self.Reservation is not None:
            self.Reservation.export(outfile, level, namespaceprefix_='class:', name_='Reservation', pretty_print=pretty_print)
        if self.ResourceSubType is not None:
            self.ResourceSubType.export(outfile, level, namespaceprefix_='class:', name_='ResourceSubType', pretty_print=pretty_print)
        if self.ResourceType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<class:ResourceType>%s</class:ResourceType>%s' % (self.gds_format_integer(self.ResourceType, input_name='ResourceType'), eol_))
        if self.VirtualQuantity is not None:
            self.VirtualQuantity.export(outfile, level, namespaceprefix_='class:', name_='VirtualQuantity', pretty_print=pretty_print)
        if self.VirtualQuantityUnits is not None:
            self.VirtualQuantityUnits.export(outfile, level, namespaceprefix_='class:', name_='VirtualQuantityUnits', pretty_print=pretty_print)
        if self.Weight is not None:
            self.Weight.export(outfile, level, namespaceprefix_='class:', name_='Weight', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespaceprefix_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Address':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Address = obj_
            obj_.original_tagname_ = 'Address'
        elif nodeName_ == 'AddressOnParent':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AddressOnParent = obj_
            obj_.original_tagname_ = 'AddressOnParent'
        elif nodeName_ == 'AllocationUnits':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AllocationUnits = obj_
            obj_.original_tagname_ = 'AllocationUnits'
        elif nodeName_ == 'AutomaticAllocation':
            class_obj_ = self.get_class_obj_(child_, cimBoolean)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AutomaticAllocation = obj_
            obj_.original_tagname_ = 'AutomaticAllocation'
        elif nodeName_ == 'AutomaticDeallocation':
            class_obj_ = self.get_class_obj_(child_, cimBoolean)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AutomaticDeallocation = obj_
            obj_.original_tagname_ = 'AutomaticDeallocation'
        elif nodeName_ == 'Caption':
            obj_ = Caption.factory()
            obj_.build(child_)
            self.Caption = obj_
            obj_.original_tagname_ = 'Caption'
        elif nodeName_ == 'Connection':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Connection.append(obj_)
            obj_.original_tagname_ = 'Connection'
        elif nodeName_ == 'ConsumerVisibility' and child_.text:
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ConsumerVisibility')
            self.ConsumerVisibility = ival_
            # validate type ConsumerVisibility
            self.validate_ConsumerVisibility(self.ConsumerVisibility)
        elif nodeName_ == 'Description':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
        elif nodeName_ == 'ElementName':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ElementName = obj_
            obj_.original_tagname_ = 'ElementName'
        elif nodeName_ == 'HostResource':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.HostResource.append(obj_)
            obj_.original_tagname_ = 'HostResource'
        elif nodeName_ == 'InstanceID':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.InstanceID = obj_
            obj_.original_tagname_ = 'InstanceID'
        elif nodeName_ == 'Limit':
            obj_ = cimUnsignedLong.factory()
            obj_.build(child_)
            self.Limit = obj_
            obj_.original_tagname_ = 'Limit'
        elif nodeName_ == 'MappingBehavior' and child_.text:
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'MappingBehavior')
            self.MappingBehavior = ival_
            # validate type MappingBehavior
            self.validate_MappingBehavior(self.MappingBehavior)
        elif nodeName_ == 'OtherResourceType':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.OtherResourceType = obj_
            obj_.original_tagname_ = 'OtherResourceType'
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        elif nodeName_ == 'PoolID':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.PoolID = obj_
            obj_.original_tagname_ = 'PoolID'
        elif nodeName_ == 'Reservation':
            obj_ = cimUnsignedLong.factory()
            obj_.build(child_)
            self.Reservation = obj_
            obj_.original_tagname_ = 'Reservation'
        elif nodeName_ == 'ResourceSubType':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ResourceSubType = obj_
            obj_.original_tagname_ = 'ResourceSubType'
        elif nodeName_ == 'ResourceType' and child_.text:
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ResourceType')
            self.ResourceType = ival_
            # validate type ResourceType
            self.validate_ResourceType(self.ResourceType)
        elif nodeName_ == 'VirtualQuantity':
            obj_ = cimUnsignedLong.factory()
            obj_.build(child_)
            self.VirtualQuantity = obj_
            obj_.original_tagname_ = 'VirtualQuantity'
        elif nodeName_ == 'VirtualQuantityUnits':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VirtualQuantityUnits = obj_
            obj_.original_tagname_ = 'VirtualQuantityUnits'
        elif nodeName_ == 'Weight':
            class_obj_ = self.get_class_obj_(child_, cimUnsignedInt)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Weight = obj_
            obj_.original_tagname_ = 'Weight'
        else:
            obj_ = self.gds_build_any(child_, 'CIM_ResourceAllocationSettingData_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
# end class CIM_ResourceAllocationSettingData_Type


class MsgType(GeneratedsSuper):
    """String element valueString element identifier"""
    subclass = None
    superclass = None
    def __init__(self, msgid=None, valueOf_=None):
        self.original_tagname_ = None
        self.msgid = _cast(None, msgid)
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MsgType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MsgType.subclass:
            return MsgType.subclass(*args_, **kwargs_)
        else:
            return MsgType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_msgid(self): return self.msgid
    def set_msgid(self, msgid): self.msgid = msgid
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='MsgType', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MsgType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MsgType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='MsgType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='MsgType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.msgid is not None and 'msgid' not in already_processed:
            already_processed.add('msgid')
            outfile.write(' msgid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.msgid), input_name='msgid')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='MsgType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('msgid', node)
        if value is not None and 'msgid' not in already_processed:
            already_processed.add('msgid')
            self.msgid = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MsgType


class IconType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, height=None, width=None, mimeType=None, fileRef=None):
        self.original_tagname_ = None
        self.height = _cast(int, height)
        self.width = _cast(int, width)
        self.mimeType = _cast(None, mimeType)
        self.fileRef = _cast(None, fileRef)
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IconType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IconType.subclass:
            return IconType.subclass(*args_, **kwargs_)
        else:
            return IconType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_height(self): return self.height
    def set_height(self, height): self.height = height
    def get_width(self): return self.width
    def set_width(self, width): self.width = width
    def get_mimeType(self): return self.mimeType
    def set_mimeType(self, mimeType): self.mimeType = mimeType
    def get_fileRef(self): return self.fileRef
    def set_fileRef(self, fileRef): self.fileRef = fileRef
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='IconType', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('IconType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IconType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='IconType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='IconType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.height is not None and 'height' not in already_processed:
            already_processed.add('height')
            outfile.write(' height="%s"' % self.gds_format_integer(self.height, input_name='height'))
        if self.width is not None and 'width' not in already_processed:
            already_processed.add('width')
            outfile.write(' width="%s"' % self.gds_format_integer(self.width, input_name='width'))
        if self.mimeType is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            outfile.write(' mimeType=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.mimeType), input_name='mimeType')), ))
        if self.fileRef is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            outfile.write(' fileRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.fileRef), input_name='fileRef')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='IconType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('height', node)
        if value is not None and 'height' not in already_processed:
            already_processed.add('height')
            try:
                self.height = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('width', node)
        if value is not None and 'width' not in already_processed:
            already_processed.add('width')
            try:
                self.width = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('mimeType', node)
        if value is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            self.mimeType = value
        value = find_attr_value_('fileRef', node)
        if value is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            self.fileRef = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class IconType


class PropertyType(GeneratedsSuper):
    """Property identifierProperty typeA comma-separated set of type
    qualifiersDetermines whether the property value is configurable
    during installationDefault value for propertyDetermines whether
    the property value should be obscured during deployment"""
    subclass = None
    superclass = None
    def __init__(self, key=None, type_=None, qualifiers=None, userConfigurable=False, value='', password=False, Label=None, Description=None, Value=None):
        self.original_tagname_ = None
        self.key = _cast(None, key)
        self.type_ = _cast(None, type_)
        self.qualifiers = _cast(None, qualifiers)
        self.userConfigurable = _cast(bool, userConfigurable)
        self.value = _cast(None, value)
        self.password = _cast(bool, password)
        self.Label = Label
        self.Description = Description
        if Value is None:
            self.Value = []
        else:
            self.Value = Value
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PropertyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PropertyType.subclass:
            return PropertyType.subclass(*args_, **kwargs_)
        else:
            return PropertyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Label(self): return self.Label
    def set_Label(self, Label): self.Label = Label
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def add_Value(self, value): self.Value.append(value)
    def insert_Value_at(self, index, value): self.Value.insert(index, value)
    def replace_Value_at(self, index, value): self.Value[index] = value
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_qualifiers(self): return self.qualifiers
    def set_qualifiers(self, qualifiers): self.qualifiers = qualifiers
    def get_userConfigurable(self): return self.userConfigurable
    def set_userConfigurable(self, userConfigurable): self.userConfigurable = userConfigurable
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.Label is not None or
            self.Description is not None or
            self.Value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='PropertyType', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PropertyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='PropertyType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='PropertyType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.key is not None and 'key' not in already_processed:
            already_processed.add('key')
            outfile.write(' key=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.key), input_name='key')), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
        if self.qualifiers is not None and 'qualifiers' not in already_processed:
            already_processed.add('qualifiers')
            outfile.write(' qualifiers=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.qualifiers), input_name='qualifiers')), ))
        if self.userConfigurable and 'userConfigurable' not in already_processed:
            already_processed.add('userConfigurable')
            outfile.write(' userConfigurable="%s"' % self.gds_format_boolean(self.userConfigurable, input_name='userConfigurable'))
        if self.value != "" and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')), ))
        if self.password and 'password' not in already_processed:
            already_processed.add('password')
            outfile.write(' password="%s"' % self.gds_format_boolean(self.password, input_name='password'))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='PropertyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Label is not None:
            self.Label.export(outfile, level, namespaceprefix_, name_='Label', pretty_print=pretty_print)
        if self.Description is not None:
            self.Description.export(outfile, level, namespaceprefix_, name_='Description', pretty_print=pretty_print)
        for Value_ in self.Value:
            Value_.export(outfile, level, namespaceprefix_, name_='Value', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('key', node)
        if value is not None and 'key' not in already_processed:
            already_processed.add('key')
            self.key = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('qualifiers', node)
        if value is not None and 'qualifiers' not in already_processed:
            already_processed.add('qualifiers')
            self.qualifiers = value
        value = find_attr_value_('userConfigurable', node)
        if value is not None and 'userConfigurable' not in already_processed:
            already_processed.add('userConfigurable')
            if value in ('true', '1'):
                self.userConfigurable = True
            elif value in ('false', '0'):
                self.userConfigurable = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
        value = find_attr_value_('password', node)
        if value is not None and 'password' not in already_processed:
            already_processed.add('password')
            if value in ('true', '1'):
                self.password = True
            elif value in ('false', '0'):
                self.password = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Label':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Label = obj_
            obj_.original_tagname_ = 'Label'
        elif nodeName_ == 'Description':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
        elif nodeName_ == 'Value':
            obj_ = PropertyConfigurationValue_Type.factory()
            obj_.build(child_)
            self.Value.append(obj_)
            obj_.original_tagname_ = 'Value'
# end class PropertyType


class NetworkType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, Description=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.Description = Description
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NetworkType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NetworkType.subclass:
            return NetworkType.subclass(*args_, **kwargs_)
        else:
            return NetworkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.Description is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='NetworkType', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('NetworkType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='NetworkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='NetworkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='NetworkType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='NetworkType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, namespaceprefix_, name_='Description', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
# end class NetworkType


class ItemType(GeneratedsSuper):
    """Unique identifier of the content (within a VirtualSystemCollection)
    Startup order. Entities are started up starting with lower-
    numbers first, starting from 0. Items with same order identifier
    may be started up concurrently or in any order. The order is
    reversed for shutdown.Delay in seconds to wait for power on to
    completeResumes power-on sequence if guest software reports
    okDelay in seconds to wait for power off to completeStart action
    to use, valid values are: 'powerOn', 'none' Stop action to use,
    valid values are: ''powerOff' , 'guestShutdown', 'none'"""
    subclass = None
    superclass = None
    def __init__(self, id=None, order=None, startDelay=0, waitingForGuest=False, stopDelay=0, startAction='powerOn', stopAction='powerOff'):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.order = _cast(int, order)
        self.startDelay = _cast(int, startDelay)
        self.waitingForGuest = _cast(bool, waitingForGuest)
        self.stopDelay = _cast(int, stopDelay)
        self.startAction = _cast(None, startAction)
        self.stopAction = _cast(None, stopAction)
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ItemType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ItemType.subclass:
            return ItemType.subclass(*args_, **kwargs_)
        else:
            return ItemType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_order(self): return self.order
    def set_order(self, order): self.order = order
    def get_startDelay(self): return self.startDelay
    def set_startDelay(self, startDelay): self.startDelay = startDelay
    def get_waitingForGuest(self): return self.waitingForGuest
    def set_waitingForGuest(self, waitingForGuest): self.waitingForGuest = waitingForGuest
    def get_stopDelay(self): return self.stopDelay
    def set_stopDelay(self, stopDelay): self.stopDelay = stopDelay
    def get_startAction(self): return self.startAction
    def set_startAction(self, startAction): self.startAction = startAction
    def get_stopAction(self): return self.stopAction
    def set_stopAction(self, stopAction): self.stopAction = stopAction
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='ItemType', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ItemType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ItemType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='ItemType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='ItemType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(' order="%s"' % self.gds_format_integer(self.order, input_name='order'))
        if self.startDelay != 0 and 'startDelay' not in already_processed:
            already_processed.add('startDelay')
            outfile.write(' startDelay="%s"' % self.gds_format_integer(self.startDelay, input_name='startDelay'))
        if self.waitingForGuest and 'waitingForGuest' not in already_processed:
            already_processed.add('waitingForGuest')
            outfile.write(' waitingForGuest="%s"' % self.gds_format_boolean(self.waitingForGuest, input_name='waitingForGuest'))
        if self.stopDelay != 0 and 'stopDelay' not in already_processed:
            already_processed.add('stopDelay')
            outfile.write(' stopDelay="%s"' % self.gds_format_integer(self.stopDelay, input_name='stopDelay'))
        if self.startAction != "powerOn" and 'startAction' not in already_processed:
            already_processed.add('startAction')
            outfile.write(' startAction=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.startAction), input_name='startAction')), ))
        if self.stopAction != "powerOff" and 'stopAction' not in already_processed:
            already_processed.add('stopAction')
            outfile.write(' stopAction=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.stopAction), input_name='stopAction')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='ItemType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            try:
                self.order = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('startDelay', node)
        if value is not None and 'startDelay' not in already_processed:
            already_processed.add('startDelay')
            try:
                self.startDelay = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('waitingForGuest', node)
        if value is not None and 'waitingForGuest' not in already_processed:
            already_processed.add('waitingForGuest')
            if value in ('true', '1'):
                self.waitingForGuest = True
            elif value in ('false', '0'):
                self.waitingForGuest = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('stopDelay', node)
        if value is not None and 'stopDelay' not in already_processed:
            already_processed.add('stopDelay')
            try:
                self.stopDelay = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('startAction', node)
        if value is not None and 'startAction' not in already_processed:
            already_processed.add('startAction')
            self.startAction = value
        value = find_attr_value_('stopAction', node)
        if value is not None and 'stopAction' not in already_processed:
            already_processed.add('stopAction')
            self.stopAction = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ItemType


class ConfigurationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, default=False, Label=None, Description=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.default = _cast(bool, default)
        self.Label = Label
        self.Description = Description
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConfigurationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConfigurationType.subclass:
            return ConfigurationType.subclass(*args_, **kwargs_)
        else:
            return ConfigurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Label(self): return self.Label
    def set_Label(self, Label): self.Label = Label
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_default(self): return self.default
    def set_default(self, default): self.default = default
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.Label is not None or
            self.Description is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='ConfigurationType', namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ConfigurationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConfigurationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='ConfigurationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='ConfigurationType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.default and 'default' not in already_processed:
            already_processed.add('default')
            outfile.write(' default="%s"' % self.gds_format_boolean(self.default, input_name='default'))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='ConfigurationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Label is not None:
            self.Label.export(outfile, level, namespaceprefix_, name_='Label', pretty_print=pretty_print)
        if self.Description is not None:
            self.Description.export(outfile, level, namespaceprefix_, name_='Description', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('default', node)
        if value is not None and 'default' not in already_processed:
            already_processed.add('default')
            if value in ('true', '1'):
                self.default = True
            elif value in ('false', '0'):
                self.default = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Label':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Label = obj_
            obj_.original_tagname_ = 'Label'
        elif nodeName_ == 'Description':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
# end class ConfigurationType


class RASD_Type(CIM_ResourceAllocationSettingData_Type):
    """Wrapper for CIM_ResourceAllocationSettingData_TypeDetermines whether
    import should fail if entry is not understoodConfiguration from
    DeploymentOptionSection this entry is valid forStates that this
    entry is a range marker"""
    subclass = None
    superclass = CIM_ResourceAllocationSettingData_Type
    def __init__(self, Address=None, AddressOnParent=None, AllocationUnits=None, AutomaticAllocation=None, AutomaticDeallocation=None, Caption=None, Connection=None, ConsumerVisibility=None, Description=None, ElementName=None, HostResource=None, InstanceID=None, Limit=None, MappingBehavior=None, OtherResourceType=None, Parent=None, PoolID=None, Reservation=None, ResourceSubType=None, ResourceType=None, VirtualQuantity=None, VirtualQuantityUnits=None, Weight=None, anytypeobjs_=None, required=True, configuration=None, bound=None):
        self.original_tagname_ = None
        super(RASD_Type, self).__init__(Address, AddressOnParent, AllocationUnits, AutomaticAllocation, AutomaticDeallocation, Caption, Connection, ConsumerVisibility, Description, ElementName, HostResource, InstanceID, Limit, MappingBehavior, OtherResourceType, Parent, PoolID, Reservation, ResourceSubType, ResourceType, VirtualQuantity, VirtualQuantityUnits, Weight, anytypeobjs_, )
        self.required = _cast(bool, required)
        self.configuration = _cast(None, configuration)
        self.bound = _cast(None, bound)
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RASD_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RASD_Type.subclass:
            return RASD_Type.subclass(*args_, **kwargs_)
        else:
            return RASD_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_configuration(self): return self.configuration
    def set_configuration(self, configuration): self.configuration = configuration
    def get_bound(self): return self.bound
    def set_bound(self, bound): self.bound = bound
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            super(RASD_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='RASD_Type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RASD_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RASD_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='RASD_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='RASD_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(RASD_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RASD_Type')
        if not self.required and 'required' not in already_processed:
            already_processed.add('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.required, input_name='required'))
        if self.configuration is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            outfile.write(' configuration=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.configuration), input_name='configuration')), ))
        if self.bound is not None and 'bound' not in already_processed:
            already_processed.add('bound')
            outfile.write(' bound=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.bound), input_name='bound')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='RASD_Type', fromsubclass_=False, pretty_print=True):
        super(RASD_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.add('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('configuration', node)
        if value is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            self.configuration = value
        value = find_attr_value_('bound', node)
        if value is not None and 'bound' not in already_processed:
            already_processed.add('bound')
            self.bound = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(RASD_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(RASD_Type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class RASD_Type


class VSSD_Type(CIM_VirtualSystemSettingData_Type):
    """Wrapper for CIM_VirtualSystemSettingData_Type"""
    subclass = None
    superclass = CIM_VirtualSystemSettingData_Type
    def __init__(self, AutomaticRecoveryAction=None, AutomaticShutdownAction=None, AutomaticStartupAction=None, AutomaticStartupActionDelay=None, AutomaticStartupActionSequenceNumber=None, Caption=None, ConfigurationDataRoot=None, ConfigurationFile=None, ConfigurationID=None, CreationTime=None, Description=None, ElementName=None, InstanceID=None, LogDataRoot=None, Notes=None, RecoveryFile=None, SnapshotDataRoot=None, SuspendDataRoot=None, SwapFileDataRoot=None, VirtualSystemIdentifier=None, VirtualSystemType=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(VSSD_Type, self).__init__(AutomaticRecoveryAction, AutomaticShutdownAction, AutomaticStartupAction, AutomaticStartupActionDelay, AutomaticStartupActionSequenceNumber, Caption, ConfigurationDataRoot, ConfigurationFile, ConfigurationID, CreationTime, Description, ElementName, InstanceID, LogDataRoot, Notes, RecoveryFile, SnapshotDataRoot, SuspendDataRoot, SwapFileDataRoot, VirtualSystemIdentifier, VirtualSystemType, anytypeobjs_, )
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VSSD_Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VSSD_Type.subclass:
            return VSSD_Type.subclass(*args_, **kwargs_)
        else:
            return VSSD_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            super(VSSD_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ovf:', name_='VSSD_Type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VSSD_Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VSSD_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_='ovf:', name_='VSSD_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ovf:', name_='VSSD_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(VSSD_Type, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VSSD_Type')
    def exportChildren(self, outfile, level, namespaceprefix_='ovf:', name_='VSSD_Type', fromsubclass_=False, pretty_print=True):
        super(VSSD_Type, self).exportChildren(outfile, level, namespaceprefix_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(VSSD_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(VSSD_Type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class VSSD_Type


GDSClassesMapping = {
    'Address': cimString,
    'AddressOnParent': cimString,
    'AllocationUnits': cimString,
    'AnnotationSection': AnnotationSection_Type,
    'AutomaticAllocation': cimBoolean,
    'AutomaticDeallocation': cimBoolean,
    'AutomaticStartupActionDelay': cimDateTime,
    'AutomaticStartupActionSequenceNumber': cimUnsignedShort,
    'CIM_ResourceAllocationSettingData': CIM_ResourceAllocationSettingData_Type,
    'CIM_VirtualSystemSettingData': CIM_VirtualSystemSettingData_Type,
    'ConfigurationDataRoot': cimString,
    'ConfigurationFile': cimString,
    'ConfigurationID': cimString,
    'Connection': cimString,
    'Content': Content_Type,
    'CreationTime': cimDateTime,
    'DeploymentOptionSection': DeploymentOptionSection_Type,
    'Description': cimString,
    'Description': cimString,
    'DiskSection': DiskSection_Type,
    'ElementName': cimString,
    'ElementName': cimString,
    'Envelope': EnvelopeType,
    'EulaSection': EulaSection_Type,
    'HostResource': cimString,
    'InstallSection': InstallSection_Type,
    'InstanceID': cimString,
    'InstanceID': cimString,
    'Limit': cimUnsignedLong,
    'LogDataRoot': cimString,
    'NetworkSection': NetworkSection_Type,
    'Notes': cimString,
    'OperatingSystemSection': OperatingSystemSection_Type,
    'OtherResourceType': cimString,
    'Parent': cimString,
    'PoolID': cimString,
    'ProductSection': ProductSection_Type,
    'RecoveryFile': cimString,
    'Reservation': cimUnsignedLong,
    'ResourceAllocationSection': ResourceAllocationSection_Type,
    'ResourceSubType': cimString,
    'Section': Section_Type,
    'SnapshotDataRoot': cimString,
    'StartupSection': StartupSection_Type,
    'Strings': Strings_Type,
    'SuspendDataRoot': cimString,
    'SwapFileDataRoot': cimString,
    'VirtualHardwareSection': VirtualHardwareSection_Type,
    'VirtualQuantity': cimUnsignedLong,
    'VirtualQuantityUnits': cimString,
    'VirtualSystem': VirtualSystem_Type,
    'VirtualSystemCollection': VirtualSystemCollection_Type,
    'VirtualSystemIdentifier': cimString,
    'VirtualSystemType': cimString,
    'Weight': cimUnsignedInt,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'EnvelopeType'
        rootClass = EnvelopeType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'EnvelopeType'
        rootClass = EnvelopeType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    '''Parse a string, create the object tree, and export it.

    Arguments:
    - inString -- A string.  This XML fragment should not start
      with an XML declaration containing an encoding.
    - silence -- A boolean.  If False, export the object.
    Returns -- The root object in the tree.
    '''
    parser = None
    rootNode= parsexmlstring_(inString, parser)
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'EnvelopeType'
        rootClass = EnvelopeType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1"')
    return rootObj


def parseLiteral(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'EnvelopeType'
        rootClass = EnvelopeType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from ovfenvelope import *\n\n')
        sys.stdout.write('import ovfenvelope as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "AnnotationSection_Type",
    "AutomaticRecoveryAction",
    "AutomaticShutdownAction",
    "AutomaticStartupAction",
    "CIM_ResourceAllocationSettingData_Type",
    "CIM_VirtualSystemSettingData_Type",
    "Caption",
    "ConfigurationType",
    "ConsumerVisibility",
    "Content_Type",
    "DeploymentOptionSection_Type",
    "DiskSection_Type",
    "EnvelopeType",
    "EulaSection_Type",
    "File_Type",
    "IconType",
    "InstallSection_Type",
    "ItemType",
    "MappingBehavior",
    "MsgType",
    "Msg_Type",
    "NetworkSection_Type",
    "NetworkType",
    "OperatingSystemSection_Type",
    "ProductSection_Type",
    "PropertyConfigurationValue_Type",
    "PropertyType",
    "RASD_Type",
    "References_Type",
    "ResourceAllocationSection_Type",
    "ResourceType",
    "Section_Type",
    "StartupSection_Type",
    "Strings_Type",
    "VSSD_Type",
    "VirtualDiskDesc_Type",
    "VirtualHardwareSection_Type",
    "VirtualSystemCollection_Type",
    "VirtualSystem_Type",
    "cimAnySimpleType",
    "cimBase64Binary",
    "cimBoolean",
    "cimByte",
    "cimChar16",
    "cimDateTime",
    "cimDouble",
    "cimFloat",
    "cimHexBinary",
    "cimInt",
    "cimLong",
    "cimReference",
    "cimShort",
    "cimString",
    "cimUnsignedByte",
    "cimUnsignedInt",
    "cimUnsignedLong",
    "cimUnsignedShort",
    "qualifierBoolean",
    "qualifierSArray",
    "qualifierSInt64",
    "qualifierString",
    "qualifierUInt32"
]
