#
# ovirt-hosted-engine-ha -- ovirt hosted engine high availability
# Copyright (C) 2013 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

"""Constants."""

METADATA_FEATURE_VERSION = 1
METADATA_PARSE_VERSION = 1

MAX_HOST_ID_SCAN = 64
HOST_SEGMENT_BYTES = 4096
METADATA_BLOCK_BYTES = 512
SERVICE_TYPE = 'hosted-engine'
HOST_ALIVE_TIMEOUT_SECS = 60

# See http://www.gnu.org/software/automake/manual/html_node/Scripts.html
BROKER_SOCKET_FILE = '/var/run/ovirt-hosted-engine-ha/broker.socket'

ENGINE_SETUP_CONF_FILE = '/etc/ovirt-hosted-engine/hosted-engine.conf'
VM_CONF_FILE = '/etc/ovirt-hosted-engine/vm.conf'
HA_AGENT_CONF_FILE = '/var/lib/ovirt-hosted-engine-ha/ha.conf'

SD_MOUNT_PARENT = '/rhev/data-center/mnt'
SD_METADATA_DIR = 'ha_agent'

VDS_CLIENT_DIR = '/usr/share/vdsm'
VDS_CLIENT_SSL = True
VDS_CLIENT_MAX_RETRY = 3
