/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.CpuTopology;

public class CpuTopologyContainer extends Container implements CpuTopology {
    private BigInteger cores;
    private BigInteger sockets;
    private BigInteger threads;
    
    public BigInteger cores() {
        return cores;
    }
    
    public Byte coresAsByte() {
        return asByte("CpuTopology", "cores", cores);
    }
    
    public Short coresAsShort() {
        return asShort("CpuTopology", "cores", cores);
    }
    
    public Integer coresAsInteger() {
        return asInteger("CpuTopology", "cores", cores);
    }
    
    public Long coresAsLong() {
        return asLong("CpuTopology", "cores", cores);
    }
    
    public void cores(BigInteger newCores) {
        cores = newCores;
    }
    
    public boolean coresPresent() {
        return cores != null;
    }
    
    public BigInteger sockets() {
        return sockets;
    }
    
    public Byte socketsAsByte() {
        return asByte("CpuTopology", "sockets", sockets);
    }
    
    public Short socketsAsShort() {
        return asShort("CpuTopology", "sockets", sockets);
    }
    
    public Integer socketsAsInteger() {
        return asInteger("CpuTopology", "sockets", sockets);
    }
    
    public Long socketsAsLong() {
        return asLong("CpuTopology", "sockets", sockets);
    }
    
    public void sockets(BigInteger newSockets) {
        sockets = newSockets;
    }
    
    public boolean socketsPresent() {
        return sockets != null;
    }
    
    public BigInteger threads() {
        return threads;
    }
    
    public Byte threadsAsByte() {
        return asByte("CpuTopology", "threads", threads);
    }
    
    public Short threadsAsShort() {
        return asShort("CpuTopology", "threads", threads);
    }
    
    public Integer threadsAsInteger() {
        return asInteger("CpuTopology", "threads", threads);
    }
    
    public Long threadsAsLong() {
        return asLong("CpuTopology", "threads", threads);
    }
    
    public void threads(BigInteger newThreads) {
        threads = newThreads;
    }
    
    public boolean threadsPresent() {
        return threads != null;
    }
    
}
