/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComboBoxDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.EditableComponentFixture;
import org.fest.swing.fixture.ItemGroupFixture;
import org.fest.swing.fixture.JComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JComboBoxFixture
extends ComponentFixture<JComboBox>
implements CommonComponentFixture,
EditableComponentFixture,
ItemGroupFixture,
JComponentFixture,
JPopupMenuInvokerFixture {
    private JComboBoxDriver driver;

    public JComboBoxFixture(Robot robot, JComboBox target) {
        super(robot, target);
        this.createDriver();
    }

    public JComboBoxFixture(Robot robot, String comboBoxName) {
        super(robot, comboBoxName, JComboBox.class);
        this.createDriver();
    }

    private void createDriver() {
        this.driver(new JComboBoxDriver(this.robot));
    }

    protected final void driver(JComboBoxDriver newDriver) {
        JComboBoxFixture.validateNotNull(newDriver);
        this.driver = newDriver;
    }

    @Override
    public JComboBoxFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JComboBoxFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JComboBoxFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JComboBoxFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JComboBoxFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public String[] contents() {
        return this.driver.contentsOf((JComboBox)this.target);
    }

    public JComboBoxFixture replaceText(String text) {
        this.driver.replaceText((JComboBox)this.target, text);
        return this;
    }

    public JComboBoxFixture selectAllText() {
        this.driver.selectAllText((JComboBox)this.target);
        return this;
    }

    public JComboBoxFixture enterText(String text) {
        this.driver.enterText((JComboBox)this.target, text);
        return this;
    }

    @Override
    public JComboBoxFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    public JList list() {
        return this.driver.dropDownList();
    }

    @Override
    public JComboBoxFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JComboBoxFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys((JComboBox)this.target, keyCodes);
        return this;
    }

    @Override
    public JComboBoxFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JComboBoxFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JComboBoxFixture clearSelection() {
        this.driver.clearSelection((JComboBox)this.target);
        return this;
    }

    @Override
    public JComboBoxFixture selectItem(int index) {
        this.driver.selectItem((JComboBox)this.target, index);
        return this;
    }

    @Override
    public JComboBoxFixture selectItem(String text) {
        this.driver.selectItem((JComboBox)this.target, text);
        return this;
    }

    @Override
    public JComboBoxFixture selectItem(Pattern pattern) {
        this.driver.selectItem((JComboBox)this.target, pattern);
        return this;
    }

    @Override
    public String valueAt(int index) {
        return this.driver.value((JComboBox)this.target, index);
    }

    @Override
    public JComboBoxFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JComboBoxFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JComboBoxFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JComboBoxFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JComboBoxFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JComboBoxFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JComboBoxFixture requireEditable() {
        this.driver.requireEditable((JComboBox)this.target);
        return this;
    }

    @Override
    public JComboBoxFixture requireNotEditable() {
        this.driver.requireNotEditable((JComboBox)this.target);
        return this;
    }

    @Override
    public JComboBoxFixture requireSelection(String value) {
        this.driver.requireSelection((JComboBox)this.target, value);
        return this;
    }

    @Override
    public JComboBoxFixture requireItemCount(int expected) {
        this.driver.requireItemCount((JComboBox)this.target, expected);
        return this;
    }

    @Override
    public JComboBoxFixture requireSelection(Pattern pattern) {
        this.driver.requireSelection((JComboBox)this.target, pattern);
        return this;
    }

    @Override
    public JComboBoxFixture requireSelection(int index) {
        this.driver.requireSelection((JComboBox)this.target, index);
        return this;
    }

    @Override
    public JComboBoxFixture requireNoSelection() {
        this.driver.requireNoSelection((JComboBox)this.target);
        return this;
    }

    @Override
    public JComboBoxFixture requireToolTip(String expected) {
        this.driver.requireToolTip((JComponent)this.target, expected);
        return this;
    }

    @Override
    public JComboBoxFixture requireToolTip(Pattern pattern) {
        this.driver.requireToolTip((JComponent)this.target, pattern);
        return this;
    }

    @Override
    public Object clientProperty(Object key) {
        return this.driver.clientProperty((JComponent)this.target, key);
    }

    @Override
    public JPopupMenuFixture showPopupMenu() {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target));
    }

    @Override
    public JPopupMenuFixture showPopupMenuAt(Point p) {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target, p));
    }

    public JComboBoxFixture cellReader(JComboBoxCellReader cellReader) {
        this.driver.cellReader(cellReader);
        return this;
    }
}

