#!/usr/bin/perl -w
# XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: xracer-mkcraft.pl,v 1.1 2000/01/03 22:42:43 rich Exp $

use strict;

use Getopt::Long;

use lib '../../XRacer/blib/lib'; # So you can run this without installing it.
use XRacer::BVRML;

# Read command line arguments.
my $outputfilename;
my $verbose;
my $help;

GetOptions ("output=s" => \$outputfilename,
	    "verbose" => \$verbose,
	    "help|?" => \$help);

if ($help)
  {
    print STDERR "$0 [--output OUTPUTFILE] [--verbose] [INPUTFILE]\n";
    print STDERR "where: OUTPUTFILE is the C file to write\n";
    print STDERR "       INPUTFILE is the input Blender VRML (.wrl) file\n";
    exit 1;
  }

# Parse the input file.
my $world = undef;
my $filename;

foreach $filename (@ARGV)
  {
    $world = XRacer::BVRML->parse ($filename, $world)
      or die "cannot parse input file: $filename: $!";
  }

# Print some info about this object.
if ($verbose)
  {
    print "number of vertices: ", $world->nr_vertices, "\n";
    print "number of faces:    ", $world->nr_faces, "\n";
    print "bounding box:       ", join (", ", $world->bbox), "\n";
  }

# Generate the C output file.
if ($outputfilename)
  {
    open C, ">$outputfilename"
      or die "$outputfilename: $!";

    print C "/* This file describes the shape of a craft.\n * It is automatically generated.\n */\n\n#include \"common.h\"\n\n";

    $world->write_display_function ( name => "display_craft",
				     filehandle => \*C
				   );

    print C "/* EOF */\n";

    close C;
  }

exit 0;

