/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.Zirkel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ConstantExpression;
import rene.zirkel.expression.ConstructionExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.FindObjectExpression;
import rene.zirkel.expression.FunctionExpression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.expression.ValidExpression;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.UserFunctionObject;

class ObjectExpression
extends BasicExpression {
    ConstructionObject O;
    String Var = null;

    public ObjectExpression(ConstructionObject constructionObject) {
        this.O = constructionObject;
    }

    public double getValue() throws ConstructionException {
        if (!this.O.valid()) {
            throw new InvalidException("");
        }
        if (this.Var != null && this.O instanceof FunctionObject) {
            return ((FunctionObject)this.O).getValue(this.Var);
        }
        if (this.Var != null && this.O instanceof UserFunctionObject) {
            return ((UserFunctionObject)this.O).getValue(this.Var);
        }
        return this.O.getValue();
    }

    public ConstructionObject getObject() {
        return this.O;
    }

    public static BasicExpression scan(ExpressionText expressionText, boolean bl) throws ConstructionException {
        char c2;
        if (!bl && expressionText.next() == '\"') {
            expressionText.advance();
            BasicExpression basicExpression = ObjectExpression.scan(expressionText, true);
            if (expressionText.next() != '\"') {
                throw new ConstructionException(Zirkel.name("exception.quotes"));
            }
            expressionText.advance();
            return basicExpression;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isLetterOrDigit(c2 = expressionText.next(bl)) || c2 == '\\' || c2 == '\'' || bl && c2 != '\"' && c2 != '\u0000' || bl && c2 == ' ') {
            stringBuffer.append(c2);
            expressionText.advance(bl);
        }
        if (!bl && expressionText.next() == '(') {
            return FunctionExpression.scan(expressionText, stringBuffer.toString());
        }
        String string = stringBuffer.toString();
        if (string.equals("pi")) {
            return new ConstantExpression("pi", Math.PI);
        }
        if (string.equals("valid")) {
            return new ValidExpression(true);
        }
        if (string.equals("invalid")) {
            return new ValidExpression(false);
        }
        if (string.equals("this")) {
            expressionText.getDepList().add(expressionText.getObject());
            return new ObjectExpression(expressionText.getObject());
        }
        if (string.equals("windoww")) {
            return new ConstructionExpression(expressionText.getConstruction(), 2);
        }
        if (string.equals("windowh")) {
            return new ConstructionExpression(expressionText.getConstruction(), 3);
        }
        if (string.equals("windowcx")) {
            return new ConstructionExpression(expressionText.getConstruction(), 0);
        }
        if (string.equals("windowcy")) {
            return new ConstructionExpression(expressionText.getConstruction(), 1);
        }
        if (string.equals("pixel")) {
            return new ConstructionExpression(expressionText.getConstruction(), 4);
        }
        if (expressionText.isVar(string)) {
            ObjectExpression objectExpression = new ObjectExpression(expressionText.getObject());
            objectExpression.Var = string;
            return objectExpression;
        }
        ConstructionObject constructionObject = expressionText.getConstruction().findInclusive(string, expressionText.getObject());
        if (constructionObject == null) {
            constructionObject = expressionText.getConstruction().find(string);
            if (constructionObject == null) {
                if (expressionText.getConstruction().loading()) {
                    return new FindObjectExpression(string, expressionText.getConstruction());
                }
                throw new ConstructionException(Zirkel.name("exception.notfound") + " (" + string + ")");
            }
            if (expressionText.getConstruction().dependsOn(constructionObject, expressionText.getObject())) {
                if (expressionText.nocircles()) {
                    throw new ConstructionException(ConstructionObject.text1(Zirkel.name("exception.depends"), string));
                }
                return new FindObjectExpression(string, expressionText.getConstruction());
            }
            expressionText.getConstruction().needsOrdering();
        }
        expressionText.getDepList().add(constructionObject);
        return new ObjectExpression(constructionObject);
    }

    public static BasicExpression scan(ExpressionText expressionText) throws ConstructionException {
        if (expressionText.next() == '@') {
            expressionText.advance();
            return FindObjectExpression.scan(expressionText);
        }
        return ObjectExpression.scan(expressionText, false);
    }

    public void translate() {
        this.O = this.O.getTranslation();
    }

    public String toString() {
        if (this.Var != null) {
            return this.Var;
        }
        return ObjectExpression.quote(this.O.getName());
    }

    public static String quote(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            bl = true;
            break;
        }
        if (bl) {
            return "\"" + string + "\"";
        }
        return string;
    }
}

