/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.Serializable;

public class FontInfo
implements Serializable {
    public static int getLineThickness(Component component, Font font) {
        Graphics graphics = component.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth("-");
        Image image = component.createImage(1, n);
        graphics = image.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 1, n);
        graphics.setColor(Color.black);
        graphics.setFont(font);
        graphics.drawString("-", -n2 / 2, fontMetrics.getAscent());
        int[] nArray = new int[n];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, n, nArray, 0, 1);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return -1;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return -1;
        }
        int n3 = nArray[0];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == n3) {
                if (n4 != 0) break;
                continue;
            }
            ++n4;
        }
        return n4 > 0 ? n4 : 1;
    }

    public static int getStringWidth(Component component, Font font, String string) {
        Graphics graphics = component.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        return fontMetrics.stringWidth(string);
    }

    public static int getMinusAlignment(Component component, Font font) {
        Graphics graphics = component.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth("-");
        Image image = component.createImage(1, n);
        graphics = image.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 1, n);
        graphics.setColor(Color.black);
        graphics.setFont(font);
        graphics.drawString("-", -n2 / 2, fontMetrics.getAscent());
        int[] nArray = new int[n];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, n, nArray, 0, 1);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return -1;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return -1;
        }
        int n3 = nArray[0];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == n3) {
                if (n4 != 0) break;
                ++n5;
                continue;
            }
            ++n4;
        }
        n4 = (n4 /= 2) > 0 ? n4 : 1;
        return n5 + n4;
    }

    public static int getPlusAlignment(Component component, Font font) {
        Graphics graphics = component.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth("+");
        Image image = component.createImage(1, n);
        graphics = image.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 1, n);
        graphics.setColor(Color.black);
        graphics.setFont(font);
        graphics.drawString("+", -n2 / 2, fontMetrics.getAscent());
        int[] nArray = new int[n];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, n, nArray, 0, 1);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return -1;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return -1;
        }
        int n3 = nArray[0];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == n3) {
                if (n4 != 0) break;
                ++n5;
                continue;
            }
            ++n4;
        }
        n4 = (n4 /= 2) > 0 ? n4 : 1;
        return n5 + n4;
    }
}

