# -*- coding: utf-8 -*-
# @author:  Mike Reinhardt
# @email:   mreinhardt@gmail.com
# @license: BSD
"""Convert emoji aliases to unicode emoji.

Primarily intended to support Slack chat over IRC or XMPP. Contains many extra
aliases found in other programs as well.

See http://www.emoji-cheat-sheet.com/ for supported sites and emoji chart.
"""

import re

import weechat


weechat.register(
    "emoji_aliases",   # name
    "Mike Reinhardt",  # author
    "1.0.4",           # version
    "BSD",             # license
    "Convert emoji aliases to unicode emoji.",  # description
    "",                # shutdown function
    "utf-8")           # charset


EMOJI_ALIASES = {
    u':+1:': u'\U0001F44D',
    u':-1:': u'\U0001F44E',
    u':100:': u'\U0001F4AF',
    u':1234:': u'\U0001F522',
    u':8ball:': u'\U0001F3B1',
    u':a:': u'\U0001F170',
    u':ab:': u'\U0001F18E',
    u':abc:': u'\U0001F524',
    u':abcd:': u'\U0001F521',
    u':accept:': u'\U0001F251',
    u':admission_tickets:': u'\U0001F39F',
    u':aerial_tramway:': u'\U0001F6A1',
    u':airplane:': u'\U00002708',
    u':airplane_arriving:': u'\U0001F6EC',
    u':airplane_departure:': u'\U0001F6EB',
    u':alarm_clock:': u'\U000023F0',
    u':alembic:': u'\U00002697',
    u':alien:': u'\U0001F47D',
    u':alien_monster:': u'\U0001F47E',
    u':ambulance:': u'\U0001F691',
    u':american_football:': u'\U0001F3C8',
    u':amphora:': u'\U0001F3FA',
    u':anchor:': u'\U00002693',
    u':angel:': u'\U0001F47C',
    u':anger:': u'\U0001F4A2',
    u':anger_symbol:': u'\U0001F4A2',
    u':angry:': u'\U0001F620',
    u':angry_face:': u'\U0001F620',
    u':anguished:': u'\U0001F627',
    u':anguished_face:': u'\U0001F627',
    u':ant:': u'\U0001F41C',
    u':antenna_with_bars:': u'\U0001F4F6',
    u':apple:': u'\U0001F34E',
    u':aquarius:': u'\U00002652',
    u':aries:': u'\U00002648',
    u':arrow_backward:': u'\U000025C0',
    u':arrow_double_down:': u'\U000023EC',
    u':arrow_double_up:': u'\U000023EB',
    u':arrow_down:': u'\U00002B07',
    u':arrow_down_small:': u'\U0001F53D',
    u':arrow_forward:': u'\U000025B6',
    u':arrow_heading_down:': u'\U00002935',
    u':arrow_heading_up:': u'\U00002934',
    u':arrow_left:': u'\U00002B05',
    u':arrow_lower_left:': u'\U00002199',
    u':arrow_lower_right:': u'\U00002198',
    u':arrow_right:': u'\U000027A1',
    u':arrow_right_hook:': u'\U000021AA',
    u':arrow_up:': u'\U00002B06',
    u':arrow_up_down:': u'\U00002195',
    u':arrow_up_small:': u'\U0001F53C',
    u':arrow_upper_left:': u'\U00002196',
    u':arrow_upper_right:': u'\U00002197',
    u':arrows_clockwise:': u'\U0001F503',
    u':arrows_counterclockwise:': u'\U0001F504',
    u':art:': u'\U0001F3A8',
    u':articulated_lorry:': u'\U0001F69B',
    u':artist_palette:': u'\U0001F3A8',
    u':astonished:': u'\U0001F632',
    u':astonished_face:': u'\U0001F632',
    u':athletic_shoe:': u'\U0001F45F',
    u':atm:': u'\U0001F3E7',
    u':atom_symbol:': u'\U0000269B',
    u':aubergine:': u'\U0001F346',
    u':automated_teller_machine:': u'\U0001F3E7',
    u':automobile:': u'\U0001F697',
    u':b:': u'\U0001F171',
    u':baby:': u'\U0001F476',
    u':baby_angel:': u'\U0001F47C',
    u':baby_bottle:': u'\U0001F37C',
    u':baby_chick:': u'\U0001F424',
    u':baby_symbol:': u'\U0001F6BC',
    u':back:': u'\U0001F519',
    u':back_with_leftwards_arrow_above:': u'\U0001F519',
    u':bactrian_camel:': u'\U0001F42B',
    u':badminton_racquet_and_shuttlecock:': u'\U0001F3F8',
    u':baggage_claim:': u'\U0001F6C4',
    u':balloon:': u'\U0001F388',
    u':ballot_box_with_ballot:': u'\U0001F5F3',
    u':ballot_box_with_check:': u'\U00002611',
    u':bamboo:': u'\U0001F38D',
    u':banana:': u'\U0001F34C',
    u':bangbang:': u'\U0000203C',
    u':bank:': u'\U0001F3E6',
    u':banknote_with_dollar_sign:': u'\U0001F4B5',
    u':banknote_with_euro_sign:': u'\U0001F4B6',
    u':banknote_with_pound_sign:': u'\U0001F4B7',
    u':banknote_with_yen_sign:': u'\U0001F4B4',
    u':bar_chart:': u'\U0001F4CA',
    u':barber:': u'\U0001F488',
    u':barber_pole:': u'\U0001F488',
    u':barely_sunny:': u'\U0001F325',
    u':baseball:': u'\U000026BE',
    u':basketball:': u'\U0001F3C0',
    u':basketball_and_hoop:': u'\U0001F3C0',
    u':bath:': u'\U0001F6C0',
    u':bathtub:': u'\U0001F6C1',
    u':battery:': u'\U0001F50B',
    u':beach_with_umbrella:': u'\U0001F3D6',
    u':bear:': u'\U0001F43B',
    u':bear_face:': u'\U0001F43B',
    u':beating_heart:': u'\U0001F493',
    u':bed:': u'\U0001F6CF',
    u':bee:': u'\U0001F41D',
    u':beer:': u'\U0001F37A',
    u':beer_mug:': u'\U0001F37A',
    u':beers:': u'\U0001F37B',
    u':beetle:': u'\U0001F41E',
    u':beginner:': u'\U0001F530',
    u':bell:': u'\U0001F514',
    u':bell_with_cancellation_stroke:': u'\U0001F515',
    u':bellhop_bell:': u'\U0001F6CE',
    u':bento:': u'\U0001F371',
    u':bento_box:': u'\U0001F371',
    u':bicycle:': u'\U0001F6B2',
    u':bicyclist:': u'\U0001F6B4',
    u':bike:': u'\U0001F6B2',
    u':bikini:': u'\U0001F459',
    u':billiards:': u'\U0001F3B1',
    u':biohazard_sign:': u'\U00002623',
    u':bird:': u'\U0001F426',
    u':birthday:': u'\U0001F382',
    u':birthday_cake:': u'\U0001F382',
    u':black_circle:': u'\U000026AB',
    u':black_circle_for_record:': u'\U000023FA',
    u':black_club_suit:': u'\U00002663',
    u':black_diamond_suit:': u'\U00002666',
    u':black_down-pointing_double_triangle:': u'\U000023EC',
    u':black_heart_suit:': u'\U00002665',
    u':black_joker:': u'\U0001F0CF',
    u':black_large_square:': u'\U00002B1B',
    u':black_left-pointing_double_triangle:': u'\U000023EA',
    u':black_left-pointing_triangle:': u'\U000025C0',
    u':black_medium_small_square:': u'\U000025FE',
    u':black_medium_square:': u'\U000025FC',
    u':black_nib:': u'\U00002712',
    u':black_question_mark_ornament:': u'\U00002753',
    u':black_right-pointing_double_triangle:': u'\U000023E9',
    u':black_right-pointing_triangle:': u'\U000025B6',
    u':black_rightwards_arrow:': u'\U000027A1',
    u':black_scissors:': u'\U00002702',
    u':black_small_square:': u'\U000025AA',
    u':black_spade_suit:': u'\U00002660',
    u':black_square_button:': u'\U0001F532',
    u':black_square_for_stop:': u'\U000023F9',
    u':black_sun_with_rays:': u'\U00002600',
    u':black_telephone:': u'\U0000260E',
    u':black_universal_recycling_symbol:': u'\U0000267B',
    u':black_up-pointing_double_triangle:': u'\U000023EB',
    u':blossom:': u'\U0001F33C',
    u':blowfish:': u'\U0001F421',
    u':blue_book:': u'\U0001F4D8',
    u':blue_car:': u'\U0001F699',
    u':blue_heart:': u'\U0001F499',
    u':blush:': u'\U0001F60A',
    u':boar:': u'\U0001F417',
    u':boat:': u'\U000026F5',
    u':bomb:': u'\U0001F4A3',
    u':book:': u'\U0001F4D6',
    u':bookmark:': u'\U0001F516',
    u':bookmark_tabs:': u'\U0001F4D1',
    u':books:': u'\U0001F4DA',
    u':boom:': u'\U0001F4A5',
    u':boot:': u'\U0001F462',
    u':bottle_with_popping_cork:': u'\U0001F37E',
    u':bouquet:': u'\U0001F490',
    u':bow:': u'\U0001F647',
    u':bow_and_arrow:': u'\U0001F3F9',
    u':bowling:': u'\U0001F3B3',
    u':boy:': u'\U0001F466',
    u':bread:': u'\U0001F35E',
    u':bride_with_veil:': u'\U0001F470',
    u':bridge_at_night:': u'\U0001F309',
    u':briefcase:': u'\U0001F4BC',
    u':broken_heart:': u'\U0001F494',
    u':bug:': u'\U0001F41B',
    u':building_construction:': u'\U0001F3D7',
    u':bulb:': u'\U0001F4A1',
    u':bullettrain_front:': u'\U0001F685',
    u':bullettrain_side:': u'\U0001F684',
    u':burrito:': u'\U0001F32F',
    u':bus:': u'\U0001F68C',
    u':bus_stop:': u'\U0001F68F',
    u':busstop:': u'\U0001F68F',
    u':bust_in_silhouette:': u'\U0001F464',
    u':busts_in_silhouette:': u'\U0001F465',
    u':cactus:': u'\U0001F335',
    u':cake:': u'\U0001F370',
    u':calendar:': u'\U0001F4C5',
    u':calendar:': u'\U0001F4C6',
    u':calling:': u'\U0001F4F2',
    u':camel:': u'\U0001F42B',
    u':camera:': u'\U0001F4F7',
    u':camera_with_flash:': u'\U0001F4F8',
    u':camping:': u'\U0001F3D5',
    u':cancer:': u'\U0000264B',
    u':candle:': u'\U0001F56F',
    u':candy:': u'\U0001F36C',
    u':capital_abcd:': u'\U0001F520',
    u':capricorn:': u'\U00002651',
    u':car:': u'\U0001F697',
    u':card_file_box:': u'\U0001F5C3',
    u':card_index:': u'\U0001F4C7',
    u':card_index_dividers:': u'\U0001F5C2',
    u':carousel_horse:': u'\U0001F3A0',
    u':carp_streamer:': u'\U0001F38F',
    u':cat2:': u'\U0001F408',
    u':cat:': u'\U0001F408',
    u':cat:': u'\U0001F431',
    u':cat_face:': u'\U0001F431',
    u':cat_face_with_tears_of_joy:': u'\U0001F639',
    u':cat_face_with_wry_smile:': u'\U0001F63C',
    u':cd:': u'\U0001F4BF',
    u':chains:': u'\U000026D3',
    u':champagne:': u'\U0001F37E',
    u':chart:': u'\U0001F4B9',
    u':chart_with_downwards_trend:': u'\U0001F4C9',
    u':chart_with_upwards_trend:': u'\U0001F4C8',
    u':chart_with_upwards_trend_and_yen_sign:': u'\U0001F4B9',
    u':checkered_flag:': u'\U0001F3C1',
    u':cheering_megaphone:': u'\U0001F4E3',
    u':cheese_wedge:': u'\U0001F9C0',
    u':chequered_flag:': u'\U0001F3C1',
    u':cherries:': u'\U0001F352',
    u':cherry_blossom:': u'\U0001F338',
    u':chestnut:': u'\U0001F330',
    u':chicken:': u'\U0001F414',
    u':children_crossing:': u'\U0001F6B8',
    u':chipmunk:': u'\U0001F43F',
    u':chocolate_bar:': u'\U0001F36B',
    u':christmas_tree:': u'\U0001F384',
    u':church:': u'\U000026EA',
    u':cinema:': u'\U0001F3A6',
    u':circled_ideograph_accept:': u'\U0001F251',
    u':circled_ideograph_advantage:': u'\U0001F250',
    u':circled_ideograph_congratulation:': u'\U00003297',
    u':circled_ideograph_secret:': u'\U00003299',
    u':circled_latin_capital_letter_m:': u'\U000024C2',
    u':circus_tent:': u'\U0001F3AA',
    u':city_sunrise:': u'\U0001F307',
    u':city_sunset:': u'\U0001F306',
    u':cityscape:': u'\U0001F3D9',
    u':cityscape_at_dusk:': u'\U0001F306',
    u':cl:': u'\U0001F191',
    u':clap:': u'\U0001F44F',
    u':clapper:': u'\U0001F3AC',
    u':clapper_board:': u'\U0001F3AC',
    u':clapping_hands_sign:': u'\U0001F44F',
    u':classical_building:': u'\U0001F3DB',
    u':clinking_beer_mugs:': u'\U0001F37B',
    u':clipboard:': u'\U0001F4CB',
    u':clock1030:': u'\U0001F565',
    u':clock10:': u'\U0001F559',
    u':clock1130:': u'\U0001F566',
    u':clock11:': u'\U0001F55A',
    u':clock1230:': u'\U0001F567',
    u':clock12:': u'\U0001F55B',
    u':clock130:': u'\U0001F55C',
    u':clock1:': u'\U0001F550',
    u':clock230:': u'\U0001F55D',
    u':clock2:': u'\U0001F551',
    u':clock330:': u'\U0001F55E',
    u':clock3:': u'\U0001F552',
    u':clock430:': u'\U0001F55F',
    u':clock4:': u'\U0001F553',
    u':clock530:': u'\U0001F560',
    u':clock5:': u'\U0001F554',
    u':clock630:': u'\U0001F561',
    u':clock6:': u'\U0001F555',
    u':clock730:': u'\U0001F562',
    u':clock7:': u'\U0001F556',
    u':clock830:': u'\U0001F563',
    u':clock8:': u'\U0001F557',
    u':clock930:': u'\U0001F564',
    u':clock9:': u'\U0001F558',
    u':clock_face_eight-thirty:': u'\U0001F563',
    u':clock_face_eight_oclock:': u'\U0001F557',
    u':clock_face_eleven-thirty:': u'\U0001F566',
    u':clock_face_eleven_oclock:': u'\U0001F55A',
    u':clock_face_five-thirty:': u'\U0001F560',
    u':clock_face_five_oclock:': u'\U0001F554',
    u':clock_face_four-thirty:': u'\U0001F55F',
    u':clock_face_four_oclock:': u'\U0001F553',
    u':clock_face_nine-thirty:': u'\U0001F564',
    u':clock_face_nine_oclock:': u'\U0001F558',
    u':clock_face_one-thirty:': u'\U0001F55C',
    u':clock_face_one_oclock:': u'\U0001F550',
    u':clock_face_seven-thirty:': u'\U0001F562',
    u':clock_face_seven_oclock:': u'\U0001F556',
    u':clock_face_six-thirty:': u'\U0001F561',
    u':clock_face_six_oclock:': u'\U0001F555',
    u':clock_face_ten-thirty:': u'\U0001F565',
    u':clock_face_ten_oclock:': u'\U0001F559',
    u':clock_face_three-thirty:': u'\U0001F55E',
    u':clock_face_three_oclock:': u'\U0001F552',
    u':clock_face_twelve-thirty:': u'\U0001F567',
    u':clock_face_twelve_oclock:': u'\U0001F55B',
    u':clock_face_two-thirty:': u'\U0001F55D',
    u':clock_face_two_oclock:': u'\U0001F551',
    u':closed_book:': u'\U0001F4D5',
    u':closed_lock_with_key:': u'\U0001F510',
    u':closed_mailbox_with_lowered_flag:': u'\U0001F4EA',
    u':closed_mailbox_with_raised_flag:': u'\U0001F4EB',
    u':closed_umbrella:': u'\U0001F302',
    u':cloud:': u'\U00002601',
    u':cloud_with_lightning:': u'\U0001F329',
    u':cloud_with_rain:': u'\U0001F327',
    u':cloud_with_snow:': u'\U0001F328',
    u':cloud_with_tornado:': u'\U0001F32A',
    u':clubs:': u'\U00002663',
    u':cocktail:': u'\U0001F378',
    u':cocktail_glass:': u'\U0001F378',
    u':coffee:': u'\U00002615',
    u':coffin:': u'\U000026B0',
    u':cold_sweat:': u'\U0001F630',
    u':collision:': u'\U0001F4A5',
    u':collision_symbol:': u'\U0001F4A5',
    u':comet:': u'\U00002604',
    u':compression:': u'\U0001F5DC',
    u':computer:': u'\U0001F4BB',
    u':confetti_ball:': u'\U0001F38A',
    u':confounded:': u'\U0001F616',
    u':confounded_face:': u'\U0001F616',
    u':confused:': u'\U0001F615',
    u':confused_face:': u'\U0001F615',
    u':congratulations:': u'\U00003297',
    u':construction:': u'\U0001F6A7',
    u':construction_sign:': u'\U0001F6A7',
    u':construction_worker:': u'\U0001F477',
    u':control_knobs:': u'\U0001F39B',
    u':convenience_store:': u'\U0001F3EA',
    u':cooked_rice:': u'\U0001F35A',
    u':cookie:': u'\U0001F36A',
    u':cooking:': u'\U0001F373',
    u':cool:': u'\U0001F192',
    u':cop:': u'\U0001F46E',
    u':copyright:': u'\U000000A9',
    u':copyright_sign:': u'\U000000A9',
    u':corn:': u'\U0001F33D',
    u':couch_and_lamp:': u'\U0001F6CB',
    u':couple:': u'\U0001F46B',
    u':couple_with_heart:': u'\U0001F491',
    u':couplekiss:': u'\U0001F48F',
    u':cow2:': u'\U0001F404',
    u':cow:': u'\U0001F404',
    u':cow:': u'\U0001F42E',
    u':cow_face:': u'\U0001F42E',
    u':crab:': u'\U0001F980',
    u':credit_card:': u'\U0001F4B3',
    u':crescent_moon:': u'\U0001F319',
    u':cricket_bat_and_ball:': u'\U0001F3CF',
    u':crocodile:': u'\U0001F40A',
    u':cross_mark:': u'\U0000274C',
    u':crossed_flags:': u'\U0001F38C',
    u':crossed_swords:': u'\U00002694',
    u':crown:': u'\U0001F451',
    u':cry:': u'\U0001F622',
    u':crying_cat_face:': u'\U0001F63F',
    u':crying_face:': u'\U0001F622',
    u':crystal_ball:': u'\U0001F52E',
    u':cupid:': u'\U0001F498',
    u':curly_loop:': u'\U000027B0',
    u':currency_exchange:': u'\U0001F4B1',
    u':curry:': u'\U0001F35B',
    u':curry_and_rice:': u'\U0001F35B',
    u':custard:': u'\U0001F36E',
    u':customs:': u'\U0001F6C3',
    u':cyclone:': u'\U0001F300',
    u':dagger_knife:': u'\U0001F5E1',
    u':dancer:': u'\U0001F483',
    u':dancers:': u'\U0001F46F',
    u':dango:': u'\U0001F361',
    u':dark_sunglasses:': u'\U0001F576',
    u':dart:': u'\U0001F3AF',
    u':dash:': u'\U0001F4A8',
    u':dash_symbol:': u'\U0001F4A8',
    u':date:': u'\U0001F4C5',
    u':deciduous_tree:': u'\U0001F333',
    u':delivery_truck:': u'\U0001F69A',
    u':department_store:': u'\U0001F3EC',
    u':derelict_house_building:': u'\U0001F3DA',
    u':desert:': u'\U0001F3DC',
    u':desert_island:': u'\U0001F3DD',
    u':desktop_computer:': u'\U0001F5A5',
    u':diamond_shape_with_a_dot_inside:': u'\U0001F4A0',
    u':diamonds:': u'\U00002666',
    u':direct_hit:': u'\U0001F3AF',
    u':disappointed:': u'\U0001F61E',
    u':disappointed_but_relieved_face:': u'\U0001F625',
    u':disappointed_face:': u'\U0001F61E',
    u':disappointed_relieved:': u'\U0001F625',
    u':dizzy:': u'\U0001F4AB',
    u':dizzy_face:': u'\U0001F635',
    u':dizzy_symbol:': u'\U0001F4AB',
    u':do_not_litter:': u'\U0001F6AF',
    u':do_not_litter_symbol:': u'\U0001F6AF',
    u':dog2:': u'\U0001F415',
    u':dog:': u'\U0001F415',
    u':dog:': u'\U0001F436',
    u':dog_face:': u'\U0001F436',
    u':dollar:': u'\U0001F4B5',
    u':dolls:': u'\U0001F38E',
    u':dolphin:': u'\U0001F42C',
    u':door:': u'\U0001F6AA',
    u':double_curly_loop:': u'\U000027BF',
    u':double_exclamation_mark:': u'\U0000203C',
    u':double_vertical_bar:': u'\U000023F8',
    u':doughnut:': u'\U0001F369',
    u':dove_of_peace:': u'\U0001F54A',
    u':down-pointing_red_triangle:': u'\U0001F53B',
    u':down-pointing_small_red_triangle:': u'\U0001F53D',
    u':downwards_black_arrow:': u'\U00002B07',
    u':dragon:': u'\U0001F409',
    u':dragon_face:': u'\U0001F432',
    u':dress:': u'\U0001F457',
    u':dromedary_camel:': u'\U0001F42A',
    u':droplet:': u'\U0001F4A7',
    u':dvd:': u'\U0001F4C0',
    u':e-mail:': u'\U0001F4E7',
    u':e-mail_symbol:': u'\U0001F4E7',
    u':ear:': u'\U0001F442',
    u':ear_of_maize:': u'\U0001F33D',
    u':ear_of_rice:': u'\U0001F33E',
    u':earth_africa:': u'\U0001F30D',
    u':earth_americas:': u'\U0001F30E',
    u':earth_asia:': u'\U0001F30F',
    u':earth_globe_americas:': u'\U0001F30E',
    u':earth_globe_asia-australia:': u'\U0001F30F',
    u':earth_globe_europe-africa:': u'\U0001F30D',
    u':egg:': u'\U0001F373',
    u':eggplant:': u'\U0001F346',
    u':eight_pointed_black_star:': u'\U00002734',
    u':eight_spoked_asterisk:': u'\U00002733',
    u':eject_symbol:': u'\U000023CF',
    u':electric_light_bulb:': u'\U0001F4A1',
    u':electric_plug:': u'\U0001F50C',
    u':electric_torch:': u'\U0001F526',
    u':elephant:': u'\U0001F418',
    u':email:': u'\U00002709',
    u':emoji_modifier_fitzpatrick_type-1-2:': u'\U0001F3FB',
    u':emoji_modifier_fitzpatrick_type-3:': u'\U0001F3FC',
    u':emoji_modifier_fitzpatrick_type-4:': u'\U0001F3FD',
    u':emoji_modifier_fitzpatrick_type-5:': u'\U0001F3FE',
    u':emoji_modifier_fitzpatrick_type-6:': u'\U0001F3FF',
    u':end:': u'\U0001F51A',
    u':end_with_leftwards_arrow_above:': u'\U0001F51A',
    u':envelope:': u'\U00002709',
    u':envelope_with_arrow:': u'\U0001F4E9',
    u':envelope_with_downwards_arrow_above:': u'\U0001F4E9',
    u':euro:': u'\U0001F4B6',
    u':european_castle:': u'\U0001F3F0',
    u':european_post_office:': u'\U0001F3E4',
    u':evergreen_tree:': u'\U0001F332',
    u':exclamation:': u'\U00002757',
    u':exclamation_question_mark:': u'\U00002049',
    u':expressionless:': u'\U0001F611',
    u':expressionless_face:': u'\U0001F611',
    u':extraterrestrial_alien:': u'\U0001F47D',
    u':eye:': u'\U0001F441',
    u':eyeglasses:': u'\U0001F453',
    u':eyes:': u'\U0001F440',
    u':face_massage:': u'\U0001F486',
    u':face_savouring_delicious_food:': u'\U0001F60B',
    u':face_screaming_in_fear:': u'\U0001F631',
    u':face_throwing_a_kiss:': u'\U0001F618',
    u':face_with_cold_sweat:': u'\U0001F613',
    u':face_with_head-bandage:': u'\U0001F915',
    u':face_with_head_bandage:': u'\U0001F915',
    u':face_with_look_of_triumph:': u'\U0001F624',
    u':face_with_medical_mask:': u'\U0001F637',
    u':face_with_no_good_gesture:': u'\U0001F645',
    u':face_with_ok_gesture:': u'\U0001F646',
    u':face_with_open_mouth:': u'\U0001F62E',
    u':face_with_open_mouth_and_cold_sweat:': u'\U0001F630',
    u':face_with_rolling_eyes:': u'\U0001F644',
    u':face_with_stuck-out_tongue:': u'\U0001F61B',
    u':face_with_tears_of_joy:': u'\U0001F602',
    u':face_with_thermometer:': u'\U0001F912',
    u':face_without_mouth:': u'\U0001F636',
    u':facepunch:': u'\U0001F44A',
    u':factory:': u'\U0001F3ED',
    u':fallen_leaf:': u'\U0001F342',
    u':family:': u'\U0001F46A',
    u':fast_forward:': u'\U000023E9',
    u':father_christmas:': u'\U0001F385',
    u':fax:': u'\U0001F4E0',
    u':fax_machine:': u'\U0001F4E0',
    u':fearful:': u'\U0001F628',
    u':fearful_face:': u'\U0001F628',
    u':feet:': u'\U0001F43E',
    u':ferris_wheel:': u'\U0001F3A1',
    u':ferry:': u'\U000026F4',
    u':field_hockey_stick_and_ball:': u'\U0001F3D1',
    u':file_cabinet:': u'\U0001F5C4',
    u':file_folder:': u'\U0001F4C1',
    u':film_frames:': u'\U0001F39E',
    u':film_projector:': u'\U0001F4FD',
    u':fire:': u'\U0001F525',
    u':fire_engine:': u'\U0001F692',
    u':firework_sparkler:': u'\U0001F387',
    u':fireworks:': u'\U0001F386',
    u':first_quarter_moon:': u'\U0001F313',
    u':first_quarter_moon_symbol:': u'\U0001F313',
    u':first_quarter_moon_with_face:': u'\U0001F31B',
    u':fish:': u'\U0001F41F',
    u':fish_cake:': u'\U0001F365',
    u':fish_cake_with_swirl_design:': u'\U0001F365',
    u':fishing_pole_and_fish:': u'\U0001F3A3',
    u':fist:': u'\U0000270A',
    u':fisted_hand_sign:': u'\U0001F44A',
    u':flag_in_hole:': u'\U000026F3',
    u':flags:': u'\U0001F38F',
    u':flashlight:': u'\U0001F526',
    u':fleur-de-lis:': u'\U0000269C',
    u':fleur_de_lis:': u'\U0000269C',
    u':flexed_biceps:': u'\U0001F4AA',
    u':flipper:': u'\U0001F42C',
    u':floppy_disk:': u'\U0001F4BE',
    u':flower_playing_cards:': u'\U0001F3B4',
    u':flushed:': u'\U0001F633',
    u':flushed_face:': u'\U0001F633',
    u':fog:': u'\U0001F32B',
    u':foggy:': u'\U0001F301',
    u':football:': u'\U0001F3C8',
    u':footprints:': u'\U0001F463',
    u':fork_and_knife:': u'\U0001F374',
    u':fork_and_knife_with_plate:': u'\U0001F37D',
    u':fountain:': u'\U000026F2',
    u':four_leaf_clover:': u'\U0001F340',
    u':frame_with_picture:': u'\U0001F5BC',
    u':free:': u'\U0001F193',
    u':french_fries:': u'\U0001F35F',
    u':fried_shrimp:': u'\U0001F364',
    u':fries:': u'\U0001F35F',
    u':frog:': u'\U0001F438',
    u':frog_face:': u'\U0001F438',
    u':front-facing_baby_chick:': u'\U0001F425',
    u':frowning:': u'\U0001F626',
    u':frowning_face_with_open_mouth:': u'\U0001F626',
    u':fuel_pump:': u'\U000026FD',
    u':fuelpump:': u'\U000026FD',
    u':full_moon:': u'\U0001F315',
    u':full_moon_symbol:': u'\U0001F315',
    u':full_moon_with_face:': u'\U0001F31D',
    u':funeral_urn:': u'\U000026B1',
    u':game_die:': u'\U0001F3B2',
    u':gear:': u'\U00002699',
    u':gem:': u'\U0001F48E',
    u':gem_stone:': u'\U0001F48E',
    u':gemini:': u'\U0000264A',
    u':ghost:': u'\U0001F47B',
    u':gift:': u'\U0001F381',
    u':gift_heart:': u'\U0001F49D',
    u':girl:': u'\U0001F467',
    u':globe_with_meridians:': u'\U0001F310',
    u':glowing_star:': u'\U0001F31F',
    u':goat:': u'\U0001F410',
    u':golf:': u'\U000026F3',
    u':golfer:': u'\U0001F3CC',
    u':graduation_cap:': u'\U0001F393',
    u':grapes:': u'\U0001F347',
    u':green_apple:': u'\U0001F34F',
    u':green_book:': u'\U0001F4D7',
    u':green_heart:': u'\U0001F49A',
    u':grey_exclamation:': u'\U00002755',
    u':grey_question:': u'\U00002754',
    u':grimacing:': u'\U0001F62C',
    u':grimacing_face:': u'\U0001F62C',
    u':grin:': u'\U0001F601',
    u':grinning:': u'\U0001F600',
    u':grinning_cat_face_with_smiling_eyes:': u'\U0001F638',
    u':grinning_face:': u'\U0001F600',
    u':grinning_face_with_smiling_eyes:': u'\U0001F601',
    u':growing_heart:': u'\U0001F497',
    u':guardsman:': u'\U0001F482',
    u':guitar:': u'\U0001F3B8',
    u':gun:': u'\U0001F52B',
    u':haircut:': u'\U0001F487',
    u':hamburger:': u'\U0001F354',
    u':hammer:': u'\U0001F528',
    u':hammer_and_pick:': u'\U00002692',
    u':hammer_and_wrench:': u'\U0001F6E0',
    u':hamster:': u'\U0001F439',
    u':hamster_face:': u'\U0001F439',
    u':hand:': u'\U0000270B',
    u':handbag:': u'\U0001F45C',
    u':hankey:': u'\U0001F4A9',
    u':happy_person_raising_one_hand:': u'\U0001F64B',
    u':hatched_chick:': u'\U0001F425',
    u':hatching_chick:': u'\U0001F423',
    u':headphone:': u'\U0001F3A7',
    u':headphones:': u'\U0001F3A7',
    u':hear-no-evil_monkey:': u'\U0001F649',
    u':hear_no_evil:': u'\U0001F649',
    u':heart:': u'\U00002764',
    u':heart_decoration:': u'\U0001F49F',
    u':heart_eyes:': u'\U0001F60D',
    u':heart_eyes_cat:': u'\U0001F63B',
    u':heart_with_arrow:': u'\U0001F498',
    u':heart_with_ribbon:': u'\U0001F49D',
    u':heartbeat:': u'\U0001F493',
    u':heartpulse:': u'\U0001F497',
    u':hearts:': u'\U00002665',
    u':heavy_black_heart:': u'\U00002764',
    u':heavy_check_mark:': u'\U00002714',
    u':heavy_division_sign:': u'\U00002797',
    u':heavy_dollar_sign:': u'\U0001F4B2',
    u':heavy_exclamation_mark:': u'\U00002757',
    u':heavy_exclamation_mark_symbol:': u'\U00002757',
    u':heavy_heart_exclamation_mark_ornament:': u'\U00002763',
    u':heavy_large_circle:': u'\U00002B55',
    u':heavy_minus_sign:': u'\U00002796',
    u':heavy_multiplication_x:': u'\U00002716',
    u':heavy_plus_sign:': u'\U00002795',
    u':helicopter:': u'\U0001F681',
    u':helm_symbol:': u'\U00002388',
    u':helmet_with_white_cross:': u'\U000026D1',
    u':herb:': u'\U0001F33F',
    u':hibiscus:': u'\U0001F33A',
    u':high-heeled_shoe:': u'\U0001F460',
    u':high-speed_train:': u'\U0001F684',
    u':high-speed_train_with_bullet_nose:': u'\U0001F685',
    u':high_brightness:': u'\U0001F506',
    u':high_brightness_symbol:': u'\U0001F506',
    u':high_heel:': u'\U0001F460',
    u':high_voltage_sign:': u'\U000026A1',
    u':hocho:': u'\U0001F52A',
    u':hole:': u'\U0001F573',
    u':honey_pot:': u'\U0001F36F',
    u':honeybee:': u'\U0001F41D',
    u':horizontal_traffic_light:': u'\U0001F6A5',
    u':horse:': u'\U0001F40E',
    u':horse:': u'\U0001F434',
    u':horse_face:': u'\U0001F434',
    u':horse_racing:': u'\U0001F3C7',
    u':hospital:': u'\U0001F3E5',
    u':hot_beverage:': u'\U00002615',
    u':hot_dog:': u'\U0001F32D',
    u':hot_pepper:': u'\U0001F336',
    u':hot_springs:': u'\U00002668',
    u':hotdog:': u'\U0001F32D',
    u':hotel:': u'\U0001F3E8',
    u':hotsprings:': u'\U00002668',
    u':hourglass:': u'\U0000231B',
    u':hourglass_flowing_sand:': u'\U000023F3',
    u':hourglass_with_flowing_sand:': u'\U000023F3',
    u':house:': u'\U0001F3E0',
    u':house_building:': u'\U0001F3E0',
    u':house_buildings:': u'\U0001F3D8',
    u':house_with_garden:': u'\U0001F3E1',
    u':hugging_face:': u'\U0001F917',
    u':hundred_points_symbol:': u'\U0001F4AF',
    u':hushed:': u'\U0001F62F',
    u':hushed_face:': u'\U0001F62F',
    u':ice_cream:': u'\U0001F368',
    u':ice_hockey_stick_and_puck:': u'\U0001F3D2',
    u':ice_skate:': u'\U000026F8',
    u':icecream:': u'\U0001F366',
    u':id:': u'\U0001F194',
    u':ideograph_advantage:': u'\U0001F250',
    u':imp:': u'\U0001F47F',
    u':inbox_tray:': u'\U0001F4E5',
    u':incoming_envelope:': u'\U0001F4E8',
    u':information_desk_person:': u'\U0001F481',
    u':information_source:': u'\U00002139',
    u':innocent:': u'\U0001F607',
    u':input_symbol_for_latin_capital_letters:': u'\U0001F520',
    u':input_symbol_for_latin_letters:': u'\U0001F524',
    u':input_symbol_for_latin_small_letters:': u'\U0001F521',
    u':input_symbol_for_numbers:': u'\U0001F522',
    u':input_symbol_for_symbols:': u'\U0001F523',
    u':interrobang:': u'\U00002049',
    u':iphone:': u'\U0001F4F1',
    u':izakaya_lantern:': u'\U0001F3EE',
    u':jack-o-lantern:': u'\U0001F383',
    u':jack_o_lantern:': u'\U0001F383',
    u':japan:': u'\U0001F5FE',
    u':japanese_castle:': u'\U0001F3EF',
    u':japanese_dolls:': u'\U0001F38E',
    u':japanese_goblin:': u'\U0001F47A',
    u':japanese_ogre:': u'\U0001F479',
    u':japanese_post_office:': u'\U0001F3E3',
    u':japanese_symbol_for_beginner:': u'\U0001F530',
    u':jeans:': u'\U0001F456',
    u':joy:': u'\U0001F602',
    u':joy_cat:': u'\U0001F639',
    u':joystick:': u'\U0001F579',
    u':kaaba:': u'\U0001F54B',
    u':key:': u'\U0001F511',
    u':keyboard:': u'\U00002328',
    u':keycap_ten:': u'\U0001F51F',
    u':kimono:': u'\U0001F458',
    u':kiss:': u'\U0001F48B',
    u':kiss:': u'\U0001F48F',
    u':kiss_mark:': u'\U0001F48B',
    u':kissing:': u'\U0001F617',
    u':kissing_cat:': u'\U0001F63D',
    u':kissing_cat_face_with_closed_eyes:': u'\U0001F63D',
    u':kissing_closed_eyes:': u'\U0001F61A',
    u':kissing_face:': u'\U0001F617',
    u':kissing_face_with_closed_eyes:': u'\U0001F61A',
    u':kissing_face_with_smiling_eyes:': u'\U0001F619',
    u':kissing_heart:': u'\U0001F618',
    u':kissing_smiling_eyes:': u'\U0001F619',
    u':knife:': u'\U0001F52A',
    u':knife_fork_plate:': u'\U0001F37D',
    u':koala:': u'\U0001F428',
    u':koko:': u'\U0001F201',
    u':label:': u'\U0001F3F7',
    u':lady_beetle:': u'\U0001F41E',
    u':lantern:': u'\U0001F3EE',
    u':large_blue_circle:': u'\U0001F535',
    u':large_blue_diamond:': u'\U0001F537',
    u':large_orange_diamond:': u'\U0001F536',
    u':large_red_circle:': u'\U0001F534',
    u':last_quarter_moon:': u'\U0001F317',
    u':last_quarter_moon_symbol:': u'\U0001F317',
    u':last_quarter_moon_with_face:': u'\U0001F31C',
    u':latin_cross:': u'\U0000271D',
    u':laughing:': u'\U0001F606',
    u':leaf_fluttering_in_wind:': u'\U0001F343',
    u':leaves:': u'\U0001F343',
    u':ledger:': u'\U0001F4D2',
    u':left-pointing_magnifying_glass:': u'\U0001F50D',
    u':left_luggage:': u'\U0001F6C5',
    u':left_right_arrow:': u'\U00002194',
    u':left_speech_bubble:': u'\U0001F4AC',
    u':leftwards_arrow_with_hook:': u'\U000021A9',
    u':leftwards_black_arrow:': u'\U00002B05',
    u':lemon:': u'\U0001F34B',
    u':leo:': u'\U0000264C',
    u':leopard:': u'\U0001F406',
    u':level_slider:': u'\U0001F39A',
    u':libra:': u'\U0000264E',
    u':light_rail:': u'\U0001F688',
    u':lightning:': u'\U0001F329',
    u':link:': u'\U0001F517',
    u':link_symbol:': u'\U0001F517',
    u':linked_paperclips:': u'\U0001F587',
    u':lion_face:': u'\U0001F981',
    u':lips:': u'\U0001F444',
    u':lipstick:': u'\U0001F484',
    u':lock:': u'\U0001F512',
    u':lock_with_ink_pen:': u'\U0001F50F',
    u':lollipop:': u'\U0001F36D',
    u':loop:': u'\U000027BF',
    u':loud_sound:': u'\U0001F50A',
    u':loudly_crying_face:': u'\U0001F62D',
    u':loudspeaker:': u'\U0001F4E2',
    u':love_hotel:': u'\U0001F3E9',
    u':love_letter:': u'\U0001F48C',
    u':low_brightness:': u'\U0001F505',
    u':low_brightness_symbol:': u'\U0001F505',
    u':lower_left_ballpoint_pen:': u'\U0001F58A',
    u':lower_left_crayon:': u'\U0001F58D',
    u':lower_left_fountain_pen:': u'\U0001F58B',
    u':lower_left_paintbrush:': u'\U0001F58C',
    u':m:': u'\U000024C2',
    u':mag:': u'\U0001F50D',
    u':mag_right:': u'\U0001F50E',
    u':mahjong:': u'\U0001F004',
    u':mahjong_tile_red_dragon:': u'\U0001F004',
    u':mailbox:': u'\U0001F4EB',
    u':mailbox_closed:': u'\U0001F4EA',
    u':mailbox_with_mail:': u'\U0001F4EC',
    u':mailbox_with_no_mail:': u'\U0001F4ED',
    u':man:': u'\U0001F468',
    u':man_and_woman_holding_hands:': u'\U0001F46B',
    u':man_in_business_suit_levitating:': u'\U0001F574',
    u':man_with_gua_pi_mao:': u'\U0001F472',
    u':man_with_turban:': u'\U0001F473',
    u':mans_shoe:': u'\U0001F45E',
    u':mantelpiece_clock:': u'\U0001F570',
    u':maple_leaf:': u'\U0001F341',
    u':mask:': u'\U0001F637',
    u':massage:': u'\U0001F486',
    u':meat_on_bone:': u'\U0001F356',
    u':medal:': u'\U0001F3C5',
    u':medium_black_circle:': u'\U000026AB',
    u':medium_white_circle:': u'\U000026AA',
    u':mega:': u'\U0001F4E3',
    u':melon:': u'\U0001F348',
    u':memo:': u'\U0001F4DD',
    u':menorah_with_nine_branches:': u'\U0001F54E',
    u':mens:': u'\U0001F6B9',
    u':mens_symbol:': u'\U0001F6B9',
    u':metro:': u'\U0001F687',
    u':microphone:': u'\U0001F3A4',
    u':microscope:': u'\U0001F52C',
    u':middle_finger:': u'\U0001F595',
    u':military_medal:': u'\U0001F396',
    u':milky_way:': u'\U0001F30C',
    u':minibus:': u'\U0001F690',
    u':minidisc:': u'\U0001F4BD',
    u':mobile_phone:': u'\U0001F4F1',
    u':mobile_phone_off:': u'\U0001F4F4',
    u':money-mouth_face:': u'\U0001F911',
    u':money_bag:': u'\U0001F4B0',
    u':money_mouth_face:': u'\U0001F911',
    u':money_with_wings:': u'\U0001F4B8',
    u':moneybag:': u'\U0001F4B0',
    u':monkey:': u'\U0001F412',
    u':monkey_face:': u'\U0001F435',
    u':monorail:': u'\U0001F69D',
    u':moon:': u'\U0001F314',
    u':moon_viewing_ceremony:': u'\U0001F391',
    u':mortar_board:': u'\U0001F393',
    u':mosque:': u'\U0001F54C',
    u':mostly_sunny:': u'\U0001F324',
    u':motor_boat:': u'\U0001F6E5',
    u':motorway:': u'\U0001F6E3',
    u':mount_fuji:': u'\U0001F5FB',
    u':mountain:': u'\U000026F0',
    u':mountain_bicyclist:': u'\U0001F6B5',
    u':mountain_cableway:': u'\U0001F6A0',
    u':mountain_railway:': u'\U0001F69E',
    u':mouse2:': u'\U0001F401',
    u':mouse:': u'\U0001F401',
    u':mouse:': u'\U0001F42D',
    u':mouse_face:': u'\U0001F42D',
    u':mouth:': u'\U0001F444',
    u':movie_camera:': u'\U0001F3A5',
    u':moyai:': u'\U0001F5FF',
    u':multiple_musical_notes:': u'\U0001F3B6',
    u':muscle:': u'\U0001F4AA',
    u':mushroom:': u'\U0001F344',
    u':musical_keyboard:': u'\U0001F3B9',
    u':musical_note:': u'\U0001F3B5',
    u':musical_score:': u'\U0001F3BC',
    u':mute:': u'\U0001F507',
    u':nail_care:': u'\U0001F485',
    u':nail_polish:': u'\U0001F485',
    u':name_badge:': u'\U0001F4DB',
    u':national_park:': u'\U0001F3DE',
    u':necktie:': u'\U0001F454',
    u':negative_squared_ab:': u'\U0001F18E',
    u':negative_squared_cross_mark:': u'\U0000274E',
    u':nerd_face:': u'\U0001F913',
    u':neutral_face:': u'\U0001F610',
    u':new:': u'\U0001F195',
    u':new_moon:': u'\U0001F311',
    u':new_moon_symbol:': u'\U0001F311',
    u':new_moon_with_face:': u'\U0001F31A',
    u':newspaper:': u'\U0001F4F0',
    u':ng:': u'\U0001F196',
    u':night_with_stars:': u'\U0001F303',
    u':no_bell:': u'\U0001F515',
    u':no_bicycles:': u'\U0001F6B3',
    u':no_entry:': u'\U000026D4',
    u':no_entry_sign:': u'\U0001F6AB',
    u':no_good:': u'\U0001F645',
    u':no_mobile_phones:': u'\U0001F4F5',
    u':no_mouth:': u'\U0001F636',
    u':no_one_under_eighteen_symbol:': u'\U0001F51E',
    u':no_pedestrians:': u'\U0001F6B7',
    u':no_smoking:': u'\U0001F6AD',
    u':no_smoking_symbol:': u'\U0001F6AD',
    u':non-potable_water:': u'\U0001F6B1',
    u':non-potable_water_symbol:': u'\U0001F6B1',
    u':north_east_arrow:': u'\U00002197',
    u':north_west_arrow:': u'\U00002196',
    u':nose:': u'\U0001F443',
    u':notebook:': u'\U0001F4D3',
    u':notebook_with_decorative_cover:': u'\U0001F4D4',
    u':notes:': u'\U0001F3B6',
    u':nut_and_bolt:': u'\U0001F529',
    u':o2:': u'\U0001F17E',
    u':o:': u'\U00002B55',
    u':ocean:': u'\U0001F30A',
    u':octopus:': u'\U0001F419',
    u':oden:': u'\U0001F362',
    u':office:': u'\U0001F3E2',
    u':office_building:': u'\U0001F3E2',
    u':oil_drum:': u'\U0001F6E2',
    u':ok:': u'\U0001F197',
    u':ok_hand:': u'\U0001F44C',
    u':ok_hand_sign:': u'\U0001F44C',
    u':ok_woman:': u'\U0001F646',
    u':old_key:': u'\U0001F5DD',
    u':older_man:': u'\U0001F474',
    u':older_woman:': u'\U0001F475',
    u':om_symbol:': u'\U0001F549',
    u':on:': u'\U0001F51B',
    u':oncoming_automobile:': u'\U0001F698',
    u':oncoming_bus:': u'\U0001F68D',
    u':oncoming_police_car:': u'\U0001F694',
    u':oncoming_taxi:': u'\U0001F696',
    u':open_book:': u'\U0001F4D6',
    u':open_file_folder:': u'\U0001F4C2',
    u':open_hands:': u'\U0001F450',
    u':open_hands_sign:': u'\U0001F450',
    u':open_lock:': u'\U0001F513',
    u':open_mailbox_with_lowered_flag:': u'\U0001F4ED',
    u':open_mailbox_with_raised_flag:': u'\U0001F4EC',
    u':open_mouth:': u'\U0001F62E',
    u':ophiuchus:': u'\U000026CE',
    u':optical_disc:': u'\U0001F4BF',
    u':orange_book:': u'\U0001F4D9',
    u':orthodox_cross:': u'\U00002626',
    u':outbox_tray:': u'\U0001F4E4',
    u':ox:': u'\U0001F402',
    u':package:': u'\U0001F4E6',
    u':page_facing_up:': u'\U0001F4C4',
    u':page_with_curl:': u'\U0001F4C3',
    u':pager:': u'\U0001F4DF',
    u':palm_tree:': u'\U0001F334',
    u':panda_face:': u'\U0001F43C',
    u':paperclip:': u'\U0001F4CE',
    u':parking:': u'\U0001F17F',
    u':part_alternation_mark:': u'\U0000303D',
    u':partly_sunny:': u'\U000026C5',
    u':partly_sunny_rain:': u'\U0001F326',
    u':party_popper:': u'\U0001F389',
    u':passenger_ship:': u'\U0001F6F3',
    u':passport_control:': u'\U0001F6C2',
    u':paw_prints:': u'\U0001F43E',
    u':peace_symbol:': u'\U0000262E',
    u':peach:': u'\U0001F351',
    u':pear:': u'\U0001F350',
    u':pedestrian:': u'\U0001F6B6',
    u':pencil2:': u'\U0000270F',
    u':pencil:': u'\U0000270F',
    u':pencil:': u'\U0001F4DD',
    u':penguin:': u'\U0001F427',
    u':pensive:': u'\U0001F614',
    u':pensive_face:': u'\U0001F614',
    u':performing_arts:': u'\U0001F3AD',
    u':persevere:': u'\U0001F623',
    u':persevering_face:': u'\U0001F623',
    u':person_bowing_deeply:': u'\U0001F647',
    u':person_frowning:': u'\U0001F64D',
    u':person_with_ball:': u'\U000026F9',
    u':person_with_blond_hair:': u'\U0001F471',
    u':person_with_folded_hands:': u'\U0001F64F',
    u':person_with_pouting_face:': u'\U0001F64E',
    u':personal_computer:': u'\U0001F4BB',
    u':phone:': u'\U0000260E',
    u':pick:': u'\U000026CF',
    u':pig2:': u'\U0001F416',
    u':pig:': u'\U0001F416',
    u':pig:': u'\U0001F437',
    u':pig_face:': u'\U0001F437',
    u':pig_nose:': u'\U0001F43D',
    u':pile_of_poo:': u'\U0001F4A9',
    u':pill:': u'\U0001F48A',
    u':pine_decoration:': u'\U0001F38D',
    u':pineapple:': u'\U0001F34D',
    u':pisces:': u'\U00002653',
    u':pistol:': u'\U0001F52B',
    u':pizza:': u'\U0001F355',
    u':place_of_worship:': u'\U0001F6D0',
    u':playing_card_black_joker:': u'\U0001F0CF',
    u':point_down:': u'\U0001F447',
    u':point_left:': u'\U0001F448',
    u':point_right:': u'\U0001F449',
    u':point_up:': u'\U0000261D',
    u':point_up_2:': u'\U0001F446',
    u':police_car:': u'\U0001F693',
    u':police_cars_revolving_light:': u'\U0001F6A8',
    u':police_officer:': u'\U0001F46E',
    u':poodle:': u'\U0001F429',
    u':poop:': u'\U0001F4A9',
    u':popcorn:': u'\U0001F37F',
    u':post_office:': u'\U0001F3E3',
    u':postal_horn:': u'\U0001F4EF',
    u':postbox:': u'\U0001F4EE',
    u':pot_of_food:': u'\U0001F372',
    u':potable_water:': u'\U0001F6B0',
    u':potable_water_symbol:': u'\U0001F6B0',
    u':pouch:': u'\U0001F45D',
    u':poultry_leg:': u'\U0001F357',
    u':pound:': u'\U0001F4B7',
    u':pouting_cat:': u'\U0001F63E',
    u':pouting_cat_face:': u'\U0001F63E',
    u':pouting_face:': u'\U0001F621',
    u':pray:': u'\U0001F64F',
    u':prayer_beads:': u'\U0001F4FF',
    u':princess:': u'\U0001F478',
    u':printer:': u'\U0001F5A8',
    u':public_address_loudspeaker:': u'\U0001F4E2',
    u':punch:': u'\U0001F44A',
    u':purple_heart:': u'\U0001F49C',
    u':purse:': u'\U0001F45B',
    u':pushpin:': u'\U0001F4CC',
    u':put_litter_in_its_place:': u'\U0001F6AE',
    u':put_litter_in_its_place_symbol:': u'\U0001F6AE',
    u':question:': u'\U00002753',
    u':rabbit2:': u'\U0001F407',
    u':rabbit:': u'\U0001F407',
    u':rabbit:': u'\U0001F430',
    u':rabbit_face:': u'\U0001F430',
    u':racehorse:': u'\U0001F40E',
    u':racing_car:': u'\U0001F3CE',
    u':racing_motorcycle:': u'\U0001F3CD',
    u':radio:': u'\U0001F4FB',
    u':radio_button:': u'\U0001F518',
    u':radioactive_sign:': u'\U00002622',
    u':rage:': u'\U0001F621',
    u':railway_car:': u'\U0001F683',
    u':railway_track:': u'\U0001F6E4',
    u':rain_cloud:': u'\U0001F327',
    u':rainbow:': u'\U0001F308',
    u':raised_fist:': u'\U0000270A',
    u':raised_hand:': u'\U0000270B',
    u':raised_hand_with_fingers_splayed:': u'\U0001F590',
    u':raised_hands:': u'\U0001F64C',
    u':raising_hand:': u'\U0001F64B',
    u':ram:': u'\U0001F40F',
    u':ramen:': u'\U0001F35C',
    u':rat:': u'\U0001F400',
    u':recreational_vehicle:': u'\U0001F699',
    u':recycle:': u'\U0000267B',
    u':red_apple:': u'\U0001F34E',
    u':red_car:': u'\U0001F697',
    u':red_circle:': u'\U0001F534',
    u':registered:': u'\U000000AE',
    u':registered_sign:': u'\U000000AE',
    u':relaxed:': u'\U0000263A',
    u':relieved:': u'\U0001F60C',
    u':relieved_face:': u'\U0001F60C',
    u':reminder_ribbon:': u'\U0001F397',
    u':repeat:': u'\U0001F501',
    u':repeat_one:': u'\U0001F502',
    u':restroom:': u'\U0001F6BB',
    u':revolving_hearts:': u'\U0001F49E',
    u':rewind:': u'\U000023EA',
    u':ribbon:': u'\U0001F380',
    u':rice:': u'\U0001F35A',
    u':rice_ball:': u'\U0001F359',
    u':rice_cracker:': u'\U0001F358',
    u':rice_scene:': u'\U0001F391',
    u':right-pointing_magnifying_glass:': u'\U0001F50E',
    u':right_anger_bubble:': u'\U0001F5EF',
    u':rightwards_arrow_with_hook:': u'\U000021AA',
    u':ring:': u'\U0001F48D',
    u':roasted_sweet_potato:': u'\U0001F360',
    u':robot_face:': u'\U0001F916',
    u':rocket:': u'\U0001F680',
    u':rolled-up_newspaper:': u'\U0001F5DE',
    u':rolled_up_newspaper:': u'\U0001F5DE',
    u':roller_coaster:': u'\U0001F3A2',
    u':rooster:': u'\U0001F413',
    u':rose:': u'\U0001F339',
    u':rosette:': u'\U0001F3F5',
    u':rotating_light:': u'\U0001F6A8',
    u':round_pushpin:': u'\U0001F4CD',
    u':rowboat:': u'\U0001F6A3',
    u':rugby_football:': u'\U0001F3C9',
    u':runner:': u'\U0001F3C3',
    u':running:': u'\U0001F3C3',
    u':running_shirt_with_sash:': u'\U0001F3BD',
    u':sa:': u'\U0001F202',
    u':sagittarius:': u'\U00002650',
    u':sailboat:': u'\U000026F5',
    u':sake:': u'\U0001F376',
    u':sake_bottle_and_cup:': u'\U0001F376',
    u':sandal:': u'\U0001F461',
    u':santa:': u'\U0001F385',
    u':satellite:': u'\U0001F4E1',
    u':satellite:': u'\U0001F6F0',
    u':satellite_antenna:': u'\U0001F4E1',
    u':satisfied:': u'\U0001F606',
    u':saxophone:': u'\U0001F3B7',
    u':scales:': u'\U00002696',
    u':school:': u'\U0001F3EB',
    u':school_satchel:': u'\U0001F392',
    u':scissors:': u'\U00002702',
    u':scorpion:': u'\U0001F982',
    u':scorpius:': u'\U0000264F',
    u':scream:': u'\U0001F631',
    u':scream_cat:': u'\U0001F640',
    u':scroll:': u'\U0001F4DC',
    u':seat:': u'\U0001F4BA',
    u':secret:': u'\U00003299',
    u':see-no-evil_monkey:': u'\U0001F648',
    u':see_no_evil:': u'\U0001F648',
    u':seedling:': u'\U0001F331',
    u':shamrock:': u'\U00002618',
    u':shaved_ice:': u'\U0001F367',
    u':sheep:': u'\U0001F411',
    u':shell:': u'\U0001F41A',
    u':shield:': u'\U0001F6E1',
    u':shinto_shrine:': u'\U000026E9',
    u':ship:': u'\U0001F6A2',
    u':shirt:': u'\U0001F455',
    u':shit:': u'\U0001F4A9',
    u':shoe:': u'\U0001F45E',
    u':shooting_star:': u'\U0001F320',
    u':shopping_bags:': u'\U0001F6CD',
    u':shortcake:': u'\U0001F370',
    u':shower:': u'\U0001F6BF',
    u':sign_of_the_horns:': u'\U0001F918',
    u':signal_strength:': u'\U0001F4F6',
    u':silhouette_of_japan:': u'\U0001F5FE',
    u':simple_smile:': u'\U0001F642',
    u':six_pointed_star:': u'\U0001F52F',
    u':ski:': u'\U0001F3BF',
    u':ski_and_ski_boot:': u'\U0001F3BF',
    u':skier:': u'\U000026F7',
    u':skull:': u'\U0001F480',
    u':skull_and_crossbones:': u'\U00002620',
    u':sleeping:': u'\U0001F634',
    u':sleeping_accommodation:': u'\U0001F6CC',
    u':sleeping_face:': u'\U0001F634',
    u':sleeping_symbol:': u'\U0001F4A4',
    u':sleepy:': u'\U0001F62A',
    u':sleepy_face:': u'\U0001F62A',
    u':sleuth_or_spy:': u'\U0001F575',
    u':slice_of_pizza:': u'\U0001F355',
    u':slightly_frowning_face:': u'\U0001F641',
    u':slightly_smiling_face:': u'\U0001F642',
    u':slot_machine:': u'\U0001F3B0',
    u':small_airplane:': u'\U0001F6E9',
    u':small_blue_diamond:': u'\U0001F539',
    u':small_orange_diamond:': u'\U0001F538',
    u':small_red_triangle:': u'\U0001F53A',
    u':small_red_triangle_down:': u'\U0001F53B',
    u':smile:': u'\U0001F604',
    u':smile_cat:': u'\U0001F638',
    u':smiley:': u'\U0001F603',
    u':smiley_cat:': u'\U0001F63A',
    u':smiling_cat_face_with_heart-shaped_eyes:': u'\U0001F63B',
    u':smiling_cat_face_with_open_mouth:': u'\U0001F63A',
    u':smiling_face_with_halo:': u'\U0001F607',
    u':smiling_face_with_heart-shaped_eyes:': u'\U0001F60D',
    u':smiling_face_with_horns:': u'\U0001F608',
    u':smiling_face_with_open_mouth:': u'\U0001F603',
    u':smiling_face_with_open_mouth_and_cold_sweat:': u'\U0001F605',
    u':smiling_face_with_open_mouth_and_smiling_eyes:': u'\U0001F604',
    u':smiling_face_with_open_mouth_and_tightly-closed_eyes:': u'\U0001F606',
    u':smiling_face_with_smiling_eyes:': u'\U0001F60A',
    u':smiling_face_with_sunglasses:': u'\U0001F60E',
    u':smiling_imp:': u'\U0001F608',
    u':smirk:': u'\U0001F60F',
    u':smirk_cat:': u'\U0001F63C',
    u':smirking_face:': u'\U0001F60F',
    u':smoking:': u'\U0001F6AC',
    u':smoking_symbol:': u'\U0001F6AC',
    u':snail:': u'\U0001F40C',
    u':snake:': u'\U0001F40D',
    u':snow_capped_mountain:': u'\U0001F3D4',
    u':snow_cloud:': u'\U0001F328',
    u':snowboarder:': u'\U0001F3C2',
    u':snowflake:': u'\U00002744',
    u':snowman:': u'\U00002603',
    u':snowman_without_snow:': u'\U000026C4',
    u':sob:': u'\U0001F62D',
    u':soccer:': u'\U000026BD',
    u':soccer_ball:': u'\U000026BD',
    u':soft_ice_cream:': u'\U0001F366',
    u':soon:': u'\U0001F51C',
    u':soon_with_rightwards_arrow_above:': u'\U0001F51C',
    u':sos:': u'\U0001F198',
    u':sound:': u'\U0001F509',
    u':south_east_arrow:': u'\U00002198',
    u':south_west_arrow:': u'\U00002199',
    u':space_invader:': u'\U0001F47E',
    u':spades:': u'\U00002660',
    u':spaghetti:': u'\U0001F35D',
    u':sparkle:': u'\U00002747',
    u':sparkler:': u'\U0001F387',
    u':sparkles:': u'\U00002728',
    u':sparkling_heart:': u'\U0001F496',
    u':speak-no-evil_monkey:': u'\U0001F64A',
    u':speak_no_evil:': u'\U0001F64A',
    u':speaker:': u'\U0001F508',
    u':speaker_with_cancellation_stroke:': u'\U0001F507',
    u':speaker_with_one_sound_wave:': u'\U0001F509',
    u':speaker_with_three_sound_waves:': u'\U0001F50A',
    u':speaking_head_in_silhouette:': u'\U0001F5E3',
    u':speech_balloon:': u'\U0001F4AC',
    u':speedboat:': u'\U0001F6A4',
    u':spider:': u'\U0001F577',
    u':spider_web:': u'\U0001F578',
    u':spiral_calendar_pad:': u'\U0001F5D3',
    u':spiral_note_pad:': u'\U0001F5D2',
    u':spiral_shell:': u'\U0001F41A',
    u':splashing_sweat_symbol:': u'\U0001F4A6',
    u':spock-hand:': u'\U0001F596',
    u':spock_hand:': u'\U0001F596',
    u':sports_medal:': u'\U0001F3C5',
    u':spouting_whale:': u'\U0001F433',
    u':squared_cl:': u'\U0001F191',
    u':squared_cool:': u'\U0001F192',
    u':squared_free:': u'\U0001F193',
    u':squared_id:': u'\U0001F194',
    u':squared_katakana_koko:': u'\U0001F201',
    u':squared_katakana_sa:': u'\U0001F202',
    u':squared_new:': u'\U0001F195',
    u':squared_ng:': u'\U0001F196',
    u':squared_ok:': u'\U0001F197',
    u':squared_sos:': u'\U0001F198',
    u':squared_up_with_exclamation_mark:': u'\U0001F199',
    u':squared_vs:': u'\U0001F19A',
    u':stadium:': u'\U0001F3DF',
    u':star2:': u'\U0001F31F',
    u':star:': u'\U00002B50',
    u':star_and_crescent:': u'\U0000262A',
    u':star_of_david:': u'\U00002721',
    u':stars:': u'\U0001F320',
    u':station:': u'\U0001F689',
    u':statue_of_liberty:': u'\U0001F5FD',
    u':steam_locomotive:': u'\U0001F682',
    u':steaming_bowl:': u'\U0001F35C',
    u':stew:': u'\U0001F372',
    u':stopwatch:': u'\U000023F1',
    u':straight_ruler:': u'\U0001F4CF',
    u':strawberry:': u'\U0001F353',
    u':stuck_out_tongue:': u'\U0001F61B',
    u':stuck_out_tongue_closed_eyes:': u'\U0001F61D',
    u':stuck_out_tongue_winking_eye:': u'\U0001F61C',
    u':studio_microphone:': u'\U0001F399',
    u':sun_behind_cloud:': u'\U000026C5',
    u':sun_with_face:': u'\U0001F31E',
    u':sunflower:': u'\U0001F33B',
    u':sunglasses:': u'\U0001F60E',
    u':sunny:': u'\U00002600',
    u':sunrise:': u'\U0001F305',
    u':sunrise_over_mountains:': u'\U0001F304',
    u':sunset_over_buildings:': u'\U0001F307',
    u':surfer:': u'\U0001F3C4',
    u':sushi:': u'\U0001F363',
    u':suspension_railway:': u'\U0001F69F',
    u':sweat:': u'\U0001F613',
    u':sweat_drops:': u'\U0001F4A6',
    u':sweat_smile:': u'\U0001F605',
    u':sweet_potato:': u'\U0001F360',
    u':swimmer:': u'\U0001F3CA',
    u':symbols:': u'\U0001F523',
    u':synagogue:': u'\U0001F54D',
    u':syringe:': u'\U0001F489',
    u':t-shirt:': u'\U0001F455',
    u':table_tennis_paddle_and_ball:': u'\U0001F3D3',
    u':taco:': u'\U0001F32E',
    u':tada:': u'\U0001F389',
    u':tanabata_tree:': u'\U0001F38B',
    u':tangerine:': u'\U0001F34A',
    u':taurus:': u'\U00002649',
    u':taxi:': u'\U0001F695',
    u':tea:': u'\U0001F375',
    u':teacup_without_handle:': u'\U0001F375',
    u':tear-off_calendar:': u'\U0001F4C6',
    u':telephone:': u'\U0000260E',
    u':telephone_receiver:': u'\U0001F4DE',
    u':telescope:': u'\U0001F52D',
    u':television:': u'\U0001F4FA',
    u':ten:': u'\U0001F51F',
    u':tennis:': u'\U0001F3BE',
    u':tennis_racquet_and_ball:': u'\U0001F3BE',
    u':tent:': u'\U000026FA',
    u':the_horns:': u'\U0001F918',
    u':thermometer:': u'\U0001F321',
    u':thinking_face:': u'\U0001F914',
    u':thought_balloon:': u'\U0001F4AD',
    u':three_button_mouse:': u'\U0001F5B1',
    u':thumbs_down_sign:': u'\U0001F44E',
    u':thumbs_up_sign:': u'\U0001F44D',
    u':thumbsdown:': u'\U0001F44E',
    u':thumbsup:': u'\U0001F44D',
    u':thunder_cloud_and_rain:': u'\U000026C8',
    u':ticket:': u'\U0001F3AB',
    u':tiger2:': u'\U0001F405',
    u':tiger:': u'\U0001F405',
    u':tiger:': u'\U0001F42F',
    u':tiger_face:': u'\U0001F42F',
    u':timer_clock:': u'\U000023F2',
    u':tired_face:': u'\U0001F62B',
    u':tm:': u'\U00002122',
    u':toilet:': u'\U0001F6BD',
    u':tokyo_tower:': u'\U0001F5FC',
    u':tomato:': u'\U0001F345',
    u':tongue:': u'\U0001F445',
    u':top:': u'\U0001F51D',
    u':top_hat:': u'\U0001F3A9',
    u':top_with_upwards_arrow_above:': u'\U0001F51D',
    u':tophat:': u'\U0001F3A9',
    u':tornado:': u'\U0001F32A',
    u':trackball:': u'\U0001F5B2',
    u':tractor:': u'\U0001F69C',
    u':trade_mark_sign:': u'\U00002122',
    u':traffic_light:': u'\U0001F6A5',
    u':train2:': u'\U0001F686',
    u':train:': u'\U0001F686',
    u':train:': u'\U0001F68B',
    u':tram:': u'\U0001F68A',
    u':tram_car:': u'\U0001F68B',
    u':triangular_flag_on_post:': u'\U0001F6A9',
    u':triangular_ruler:': u'\U0001F4D0',
    u':trident:': u'\U0001F531',
    u':trident_emblem:': u'\U0001F531',
    u':triumph:': u'\U0001F624',
    u':trolleybus:': u'\U0001F68E',
    u':trophy:': u'\U0001F3C6',
    u':tropical_drink:': u'\U0001F379',
    u':tropical_fish:': u'\U0001F420',
    u':truck:': u'\U0001F69A',
    u':trumpet:': u'\U0001F3BA',
    u':tshirt:': u'\U0001F455',
    u':tulip:': u'\U0001F337',
    u':turkey:': u'\U0001F983',
    u':turtle:': u'\U0001F422',
    u':tv:': u'\U0001F4FA',
    u':twisted_rightwards_arrows:': u'\U0001F500',
    u':two_hearts:': u'\U0001F495',
    u':two_men_holding_hands:': u'\U0001F46C',
    u':two_women_holding_hands:': u'\U0001F46D',
    u':umbrella:': u'\U00002602',
    u':umbrella_on_ground:': u'\U000026F1',
    u':umbrella_with_rain_drops:': u'\U00002614',
    u':unamused:': u'\U0001F612',
    u':unamused_face:': u'\U0001F612',
    u':underage:': u'\U0001F51E',
    u':unicorn_face:': u'\U0001F984',
    u':unlock:': u'\U0001F513',
    u':up-pointing_red_triangle:': u'\U0001F53A',
    u':up-pointing_small_red_triangle:': u'\U0001F53C',
    u':up:': u'\U0001F199',
    u':up_down_arrow:': u'\U00002195',
    u':upside-down_face:': u'\U0001F643',
    u':upside_down_face:': u'\U0001F643',
    u':upwards_black_arrow:': u'\U00002B06',
    u':v:': u'\U0000270C',
    u':vertical_traffic_light:': u'\U0001F6A6',
    u':vhs:': u'\U0001F4FC',
    u':vibration_mode:': u'\U0001F4F3',
    u':victory_hand:': u'\U0000270C',
    u':video_camera:': u'\U0001F4F9',
    u':video_game:': u'\U0001F3AE',
    u':videocassette:': u'\U0001F4FC',
    u':violin:': u'\U0001F3BB',
    u':virgo:': u'\U0000264D',
    u':volcano:': u'\U0001F30B',
    u':volleyball:': u'\U0001F3D0',
    u':vs:': u'\U0001F19A',
    u':walking:': u'\U0001F6B6',
    u':waning_crescent_moon:': u'\U0001F318',
    u':waning_crescent_moon_symbol:': u'\U0001F318',
    u':waning_gibbous_moon:': u'\U0001F316',
    u':waning_gibbous_moon_symbol:': u'\U0001F316',
    u':warning:': u'\U000026A0',
    u':warning_sign:': u'\U000026A0',
    u':wastebasket:': u'\U0001F5D1',
    u':watch:': u'\U0000231A',
    u':water_buffalo:': u'\U0001F403',
    u':water_closet:': u'\U0001F6BE',
    u':water_wave:': u'\U0001F30A',
    u':watermelon:': u'\U0001F349',
    u':wave:': u'\U0001F44B',
    u':waving_black_flag:': u'\U0001F3F4',
    u':waving_hand_sign:': u'\U0001F44B',
    u':waving_white_flag:': u'\U0001F3F3',
    u':wavy_dash:': u'\U00003030',
    u':waxing_crescent_moon:': u'\U0001F312',
    u':waxing_crescent_moon_symbol:': u'\U0001F312',
    u':waxing_gibbous_moon:': u'\U0001F314',
    u':waxing_gibbous_moon_symbol:': u'\U0001F314',
    u':wc:': u'\U0001F6BE',
    u':weary:': u'\U0001F629',
    u':weary_cat_face:': u'\U0001F640',
    u':weary_face:': u'\U0001F629',
    u':wedding:': u'\U0001F492',
    u':weight_lifter:': u'\U0001F3CB',
    u':whale2:': u'\U0001F40B',
    u':whale:': u'\U0001F40B',
    u':whale:': u'\U0001F433',
    u':wheel_of_dharma:': u'\U00002638',
    u':wheelchair:': u'\U0000267F',
    u':wheelchair_symbol:': u'\U0000267F',
    u':white_check_mark:': u'\U00002705',
    u':white_circle:': u'\U000026AA',
    u':white_down_pointing_backhand_index:': u'\U0001F447',
    u':white_exclamation_mark_ornament:': u'\U00002755',
    u':white_flower:': u'\U0001F4AE',
    u':white_frowning_face:': u'\U00002639',
    u':white_heavy_check_mark:': u'\U00002705',
    u':white_large_square:': u'\U00002B1C',
    u':white_left_pointing_backhand_index:': u'\U0001F448',
    u':white_medium_small_square:': u'\U000025FD',
    u':white_medium_square:': u'\U000025FB',
    u':white_medium_star:': u'\U00002B50',
    u':white_question_mark_ornament:': u'\U00002754',
    u':white_right_pointing_backhand_index:': u'\U0001F449',
    u':white_small_square:': u'\U000025AB',
    u':white_smiling_face:': u'\U0000263A',
    u':white_square_button:': u'\U0001F533',
    u':white_sun_behind_cloud:': u'\U0001F325',
    u':white_sun_behind_cloud_with_rain:': u'\U0001F326',
    u':white_sun_with_small_cloud:': u'\U0001F324',
    u':white_up_pointing_backhand_index:': u'\U0001F446',
    u':white_up_pointing_index:': u'\U0000261D',
    u':wind_blowing_face:': u'\U0001F32C',
    u':wind_chime:': u'\U0001F390',
    u':wine_glass:': u'\U0001F377',
    u':wink:': u'\U0001F609',
    u':winking_face:': u'\U0001F609',
    u':wolf:': u'\U0001F43A',
    u':wolf_face:': u'\U0001F43A',
    u':woman:': u'\U0001F469',
    u':woman_with_bunny_ears:': u'\U0001F46F',
    u':womans_boots:': u'\U0001F462',
    u':womans_clothes:': u'\U0001F45A',
    u':womans_hat:': u'\U0001F452',
    u':womans_sandal:': u'\U0001F461',
    u':womens:': u'\U0001F6BA',
    u':womens_symbol:': u'\U0001F6BA',
    u':world_map:': u'\U0001F5FA',
    u':worried:': u'\U0001F61F',
    u':worried_face:': u'\U0001F61F',
    u':wrapped_present:': u'\U0001F381',
    u':wrench:': u'\U0001F527',
    u':writing_hand:': u'\U0000270D',
    u':x:': u'\U0000274C',
    u':yellow_heart:': u'\U0001F49B',
    u':yen:': u'\U0001F4B4',
    u':yin_yang:': u'\U0000262F',
    u':yum:': u'\U0001F60B',
    u':zap:': u'\U000026A1',
    u':zipper-mouth_face:': u'\U0001F910',
    u':zipper_mouth_face:': u'\U0001F910',
    u':zzz:': u'\U0001F4A4',
}
ALIAS_RE = re.compile(r':[+-]?[\w-]+:', flags=re.DOTALL)
NEEDSPLIT = ('irc_in_PRIVMSG', 'irc_in_NOTICE', 'irc_in_PART', 'irc_in_QUIT', 'irc_in_KNOCK', 'irc_in_AWAY')

HOOKS = (
    "away",
    "cnotice",
    "cprivmsg",
    "kick",
    "knock",
    "notice",
    "part",
    "privmsg",
    "quit",
    "wallops",
)


def convert_aliases_to_emoji(data, modifier, modifier_data, string):
    # `unmodified` is text not to have replacements done on it
    unmodified, modifiable = "", string

    if modifier in NEEDSPLIT:
        # if " :" exists in a raw IRC string (once tags have been removed) it
        # will be the start of the final (trailing) parameter

        # optionally put IRCv3 tags (and space) in to `unmodified`
        if string[0] == "@":
            tags, sep, string = string.partition(" ")
            unmodified += tags+sep

        # optionally put :source (and space) in to `unmodified`
        if string[0] == ":":
            source, sep, string = string.partition(" ")
            unmodified += source+sep

        # split at the first instance of " :"
        # (`trailing` will be empty string if not found)
        string, trailing_sep, trailing = string.partition(" :")

        # put COMMAND (and space) in to `unmodified`
        command, sep, string = string.partition(" ")
        unmodified += command+sep

        if not trailing and string:
            # we've not got a :trailing param; let's use the last arg instead
            string, sep, modifiable = string.rpartition(" ")
            # put all other args (and space) in to `unmodified`
            unmodified += string+sep
        else:
            # we've got a :trailing param.
            # put all the other args (and " :") in to `unmodified`
            unmodified += string+trailing_sep
            modifiable = trailing

    for alias in ALIAS_RE.findall(modifiable):
        if alias in EMOJI_ALIASES:
            modifiable = modifiable.replace(alias, '{} '.format(EMOJI_ALIASES[alias]))

    return unmodified+modifiable

for hook in HOOKS:
    weechat.hook_modifier(
        "irc_in_{0}".format(hook), "convert_aliases_to_emoji", "")
weechat.hook_modifier("input_text_for_buffer", "convert_aliases_to_emoji", "")
