// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SABAL_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SABAL_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_sabal_8H[] = {
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0022, 0x0029, 0x0003, 0x0011, 0x017c, 0x007f, 0x0080, 0x3334,
  0x004a, 0x002a, 0x0004, 0x010e, 0x017b, 0x0080, 0x0081, 0x335b,
  0x004b, 0x002b, 0x00ff, 0x010d, 0x017a, 0x0081, 0x00a8, 0x337d,
  0x004c, 0x00d6, 0x00fe, 0x010c, 0x0179, 0x00a8, 0x00ca, 0x33a9,
  0x00b3, 0x00d5, 0x00fd, 0x010b, 0x0152, 0x00ca, 0x00f6, 0x33ae,
  0x00b2, 0x00d4, 0x00fc, 0x00e4, 0x0130, 0x00f6, 0x00fb, 0x33af,
  0x00b1, 0x00d3, 0x00d5, 0x00c2, 0x0104, 0x00fb, 0x00fc, 0x33b0,
  0x00b0, 0x00ac, 0x00b3, 0x0096, 0x00ff, 0x00fc, 0x00fd, 0x33b1,
  0x0089, 0x008a, 0x0087, 0x0091, 0x00fe, 0x00fd, 0x00fe, 0x33b2,
  0x0067, 0x005e, 0x0082, 0x0090, 0x00fd, 0x00fe, 0x00ff, 0x33b3,
  0x003b, 0x0059, 0x0081, 0x008f, 0x00fc, 0x00ff, 0x0100, 0x33b9,
  0x0036, 0x0058, 0x0080, 0x008e, 0x00fb, 0x0100, 0x0106, 0x33e4,
  0x0035, 0x0057, 0x007f, 0x008d, 0x00fa, 0x0106, 0x0131, 0x3406,
  0x0034, 0x0056, 0x007e, 0x008c, 0x00f4, 0x0131, 0x0153, 0x342e,
  0x0033, 0x0055, 0x007d, 0x0086, 0x00c9, 0x0153, 0x017b, 0x342f,
  0x0032, 0x0054, 0x0077, 0x005b, 0x00a7, 0x017b, 0x017c, 0x3430,
  0x0031, 0x004e, 0x004c, 0x0039, 0x007f, 0x017c, 0x017d, 0x3335,
  0x002b, 0x0023, 0x002a, 0x0011, 0x007e, 0x017d, 0x0080, 0x3334,
  0x0022, 0x0029, 0x0003, 0x0011, 0x017c, 0x007f, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0028, 0x0002, 0x0003, 0x010f, 0x007e, 0x007f, 0x0080, 0x335a,
  0x0029, 0x0003, 0x0100, 0x010e, 0x007f, 0x0080, 0x00a7, 0x337c,
  0x002a, 0x00fe, 0x00ff, 0x010d, 0x0080, 0x00a7, 0x00c9, 0x33a8,
  0x00d5, 0x00fd, 0x00fe, 0x010c, 0x00a7, 0x00c9, 0x00f5, 0x33ad,
  0x00d4, 0x00fc, 0x00fd, 0x00e5, 0x00c9, 0x00f5, 0x00fa, 0x33ae,
  0x00d3, 0x00fb, 0x00d6, 0x00c3, 0x00f5, 0x00fa, 0x00fb, 0x33af,
  0x00d2, 0x00d4, 0x00b4, 0x0097, 0x00fa, 0x00fb, 0x00fc, 0x33b0,
  0x00ab, 0x00b2, 0x0088, 0x0092, 0x00fb, 0x00fc, 0x00fd, 0x33b1,
  0x0089, 0x0086, 0x0083, 0x0091, 0x00fc, 0x00fd, 0x00fe, 0x33b2,
  0x005d, 0x0081, 0x0082, 0x0090, 0x00fd, 0x00fe, 0x00ff, 0x33b8,
  0x0058, 0x0080, 0x0081, 0x008f, 0x00fe, 0x00ff, 0x0105, 0x33e3,
  0x0057, 0x007f, 0x0080, 0x008e, 0x00ff, 0x0105, 0x0130, 0x3405,
  0x0056, 0x007e, 0x007f, 0x008d, 0x0105, 0x0130, 0x0152, 0x342d,
  0x0055, 0x007d, 0x007e, 0x0087, 0x0130, 0x0152, 0x017a, 0x342e,
  0x0054, 0x007c, 0x0078, 0x005c, 0x0152, 0x017a, 0x017b, 0x342f,
  0x0053, 0x0076, 0x004d, 0x003a, 0x017a, 0x017b, 0x017c, 0x3336,
  0x004d, 0x004b, 0x002b, 0x0012, 0x017b, 0x017c, 0x0081, 0x3335,
  0x004a, 0x002a, 0x0004, 0x010e, 0x017b, 0x0080, 0x0081, 0x335b,
  0x0028, 0x0002, 0x0003, 0x010f, 0x007e, 0x007f, 0x0080, 0x335a,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0101, 0x0011, 0x007e, 0x007f, 0x00a6, 0x3355,
  0x0002, 0x00ff, 0x0100, 0x0012, 0x007f, 0x00a6, 0x00c8, 0x3381,
  0x00fd, 0x00fe, 0x00ff, 0x0013, 0x00a6, 0x00c8, 0x00f4, 0x3386,
  0x00fc, 0x00fd, 0x00fe, 0x003a, 0x00c8, 0x00f4, 0x00f9, 0x3387,
  0x00fb, 0x00fc, 0x00d7, 0x005c, 0x00f4, 0x00f9, 0x00fa, 0x3388,
  0x00fa, 0x00d5, 0x00b5, 0x0088, 0x00f9, 0x00fa, 0x00fb, 0x3389,
  0x00d3, 0x00b3, 0x0089, 0x008d, 0x00fa, 0x00fb, 0x00fc, 0x338a,
  0x00b1, 0x0087, 0x0084, 0x008e, 0x00fb, 0x00fc, 0x00fd, 0x338b,
  0x0085, 0x0082, 0x0083, 0x008f, 0x00fc, 0x00fd, 0x00fe, 0x3391,
  0x0080, 0x0081, 0x0082, 0x0090, 0x00fd, 0x00fe, 0x0104, 0x33bc,
  0x007f, 0x0080, 0x0081, 0x0091, 0x00fe, 0x0104, 0x012f, 0x33de,
  0x007e, 0x007f, 0x0080, 0x0092, 0x0104, 0x012f, 0x0151, 0x3406,
  0x007d, 0x007e, 0x007f, 0x0098, 0x012f, 0x0151, 0x0179, 0x3407,
  0x007c, 0x007d, 0x0079, 0x00c3, 0x0151, 0x0179, 0x017a, 0x3408,
  0x007b, 0x0077, 0x004e, 0x00e5, 0x0179, 0x017a, 0x017b, 0x335d,
  0x0075, 0x004c, 0x002c, 0x010d, 0x017a, 0x017b, 0x0082, 0x335c,
  0x004b, 0x002b, 0x00ff, 0x010d, 0x017a, 0x0081, 0x00a8, 0x337d,
  0x0029, 0x0003, 0x0100, 0x010e, 0x007f, 0x0080, 0x00a7, 0x337c,
  0x0001, 0x0002, 0x0101, 0x0011, 0x007e, 0x007f, 0x00a6, 0x3355,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0100, 0x0003, 0x0011, 0x007e, 0x00a5, 0x00a1, 0x335f,
  0x00fe, 0x00ff, 0x0004, 0x0012, 0x00a5, 0x00c7, 0x00cd, 0x3364,
  0x00fd, 0x00fe, 0x0005, 0x0039, 0x00c7, 0x00f3, 0x00d2, 0x3365,
  0x00fc, 0x00fd, 0x002c, 0x005b, 0x00f3, 0x00f8, 0x00d3, 0x3366,
  0x00fb, 0x00d6, 0x004e, 0x0087, 0x00f8, 0x00f9, 0x00d4, 0x3367,
  0x00d4, 0x00b4, 0x007a, 0x008c, 0x00f9, 0x00fa, 0x00d5, 0x3368,
  0x00b2, 0x0088, 0x007f, 0x008d, 0x00fa, 0x00fb, 0x00d6, 0x3369,
  0x0086, 0x0083, 0x0080, 0x008e, 0x00fb, 0x00fc, 0x00d7, 0x336f,
  0x0081, 0x0082, 0x0081, 0x008f, 0x00fc, 0x00fd, 0x00dd, 0x339a,
  0x0080, 0x0081, 0x0082, 0x0090, 0x00fd, 0x0103, 0x0108, 0x33bc,
  0x007f, 0x0080, 0x0083, 0x0091, 0x0103, 0x012e, 0x012a, 0x33e4,
  0x007e, 0x007f, 0x0084, 0x0097, 0x012e, 0x0150, 0x0152, 0x33e5,
  0x007d, 0x007e, 0x008a, 0x00c2, 0x0150, 0x0178, 0x0153, 0x33e6,
  0x007c, 0x0078, 0x00b5, 0x00e4, 0x0178, 0x0179, 0x0154, 0x337f,
  0x0076, 0x004d, 0x00d7, 0x010c, 0x0179, 0x017a, 0x00a9, 0x337e,
  0x004c, 0x00d6, 0x00fe, 0x010c, 0x0179, 0x00a8, 0x00ca, 0x33a9,
  0x002a, 0x00fe, 0x00ff, 0x010d, 0x0080, 0x00a7, 0x00c9, 0x33a8,
  0x0002, 0x00ff, 0x0100, 0x0012, 0x007f, 0x00a6, 0x00c8, 0x3381,
  0x0001, 0x0100, 0x0003, 0x0011, 0x007e, 0x00a5, 0x00a1, 0x335f,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x00ff, 0x0002, 0x0003, 0x0011, 0x00a4, 0x00a0, 0x00ab, 0x3338,
  0x00fe, 0x0003, 0x0004, 0x0038, 0x00c6, 0x00cc, 0x00b0, 0x3339,
  0x00fd, 0x0004, 0x002b, 0x005a, 0x00f2, 0x00d1, 0x00b1, 0x333a,
  0x00fc, 0x002b, 0x004d, 0x0086, 0x00f7, 0x00d2, 0x00b2, 0x333b,
  0x00d5, 0x004d, 0x0079, 0x008b, 0x00f8, 0x00d3, 0x00b3, 0x333c,
  0x00b3, 0x0079, 0x007e, 0x008c, 0x00f9, 0x00d4, 0x00b4, 0x333d,
  0x0087, 0x007e, 0x007f, 0x008d, 0x00fa, 0x00d5, 0x00b5, 0x3343,
  0x0082, 0x007f, 0x0080, 0x008e, 0x00fb, 0x00d6, 0x00bb, 0x336e,
  0x0081, 0x0080, 0x0081, 0x008f, 0x00fc, 0x00dc, 0x00e6, 0x3390,
  0x0080, 0x0081, 0x0082, 0x0090, 0x0102, 0x0107, 0x0108, 0x33b8,
  0x007f, 0x0082, 0x0083, 0x0096, 0x012d, 0x0129, 0x0130, 0x33b9,
  0x007e, 0x0083, 0x0089, 0x00c1, 0x014f, 0x0151, 0x0131, 0x33ba,
  0x007d, 0x0089, 0x00b4, 0x00e3, 0x0177, 0x0152, 0x0132, 0x33ab,
  0x0077, 0x00b4, 0x00d6, 0x010b, 0x0178, 0x0153, 0x00cb, 0x33aa,
  0x00b3, 0x00d5, 0x00fd, 0x010b, 0x0152, 0x00ca, 0x00f6, 0x33ae,
  0x00d5, 0x00fd, 0x00fe, 0x010c, 0x00a7, 0x00c9, 0x00f5, 0x33ad,
  0x00fd, 0x00fe, 0x00ff, 0x0013, 0x00a6, 0x00c8, 0x00f4, 0x3386,
  0x00fe, 0x00ff, 0x0004, 0x0012, 0x00a5, 0x00c7, 0x00cd, 0x3364,
  0x00ff, 0x0002, 0x0003, 0x0011, 0x00a4, 0x00a0, 0x00ab, 0x3338,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0003, 0x0037, 0x009f, 0x00aa, 0x0084, 0x3334,
  0x0002, 0x0003, 0x002a, 0x0059, 0x00cb, 0x00af, 0x0085, 0x3335,
  0x0003, 0x002a, 0x004c, 0x0085, 0x00d0, 0x00b0, 0x0086, 0x3336,
  0x002a, 0x004c, 0x0078, 0x008a, 0x00d1, 0x00b1, 0x0087, 0x3337,
  0x004c, 0x0078, 0x007d, 0x008b, 0x00d2, 0x00b2, 0x0088, 0x3338,
  0x0078, 0x007d, 0x007e, 0x008c, 0x00d3, 0x00b3, 0x0089, 0x333e,
  0x007d, 0x007e, 0x007f, 0x008d, 0x00d4, 0x00b4, 0x008f, 0x3369,
  0x007e, 0x007f, 0x0080, 0x008e, 0x00d5, 0x00ba, 0x00ba, 0x338b,
  0x007f, 0x0080, 0x0081, 0x008f, 0x00db, 0x00e5, 0x00dc, 0x33b3,
  0x0080, 0x0081, 0x0082, 0x0095, 0x0106, 0x0107, 0x0104, 0x33b4,
  0x0081, 0x0082, 0x0088, 0x00c0, 0x0128, 0x012f, 0x0105, 0x33b5,
  0x0082, 0x0088, 0x00b3, 0x00e2, 0x0150, 0x0130, 0x0106, 0x33b0,
  0x0088, 0x00b3, 0x00d5, 0x010a, 0x0151, 0x0131, 0x00f7, 0x33af,
  0x00b2, 0x00d4, 0x00fc, 0x00e4, 0x0130, 0x00f6, 0x00fb, 0x33af,
  0x00d4, 0x00fc, 0x00fd, 0x00e5, 0x00c9, 0x00f5, 0x00fa, 0x33ae,
  0x00fc, 0x00fd, 0x00fe, 0x003a, 0x00c8, 0x00f4, 0x00f9, 0x3387,
  0x00fd, 0x00fe, 0x0005, 0x0039, 0x00c7, 0x00f3, 0x00d2, 0x3365,
  0x00fe, 0x0003, 0x0004, 0x0038, 0x00c6, 0x00cc, 0x00b0, 0x3339,
  0x0001, 0x0002, 0x0003, 0x0037, 0x009f, 0x00aa, 0x0084, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0029, 0x0032, 0x00a9, 0x0083, 0x0080, 0x3334,
  0x0002, 0x0029, 0x004b, 0x005e, 0x00ae, 0x0084, 0x0081, 0x3335,
  0x0029, 0x004b, 0x0077, 0x0063, 0x00af, 0x0085, 0x0082, 0x3336,
  0x004b, 0x0077, 0x007c, 0x0064, 0x00b0, 0x0086, 0x0083, 0x3337,
  0x0077, 0x007c, 0x007d, 0x0065, 0x00b1, 0x0087, 0x0084, 0x333d,
  0x007c, 0x007d, 0x007e, 0x0066, 0x00b2, 0x0088, 0x008a, 0x3368,
  0x007d, 0x007e, 0x007f, 0x0067, 0x00b3, 0x008e, 0x00b5, 0x338a,
  0x007e, 0x007f, 0x0080, 0x0068, 0x00b9, 0x00b9, 0x00d7, 0x33b2,
  0x007f, 0x0080, 0x0081, 0x006e, 0x00e4, 0x00db, 0x00ff, 0x33b3,
  0x0080, 0x0081, 0x0087, 0x0099, 0x0106, 0x0103, 0x0100, 0x33b4,
  0x0081, 0x0087, 0x00b2, 0x00bb, 0x012e, 0x0104, 0x0101, 0x33b1,
  0x0087, 0x00b2, 0x00d4, 0x00e3, 0x012f, 0x0105, 0x00fc, 0x33b0,
  0x00b1, 0x00d3, 0x00d5, 0x00c2, 0x0104, 0x00fb, 0x00fc, 0x33b0,
  0x00d3, 0x00fb, 0x00d6, 0x00c3, 0x00f5, 0x00fa, 0x00fb, 0x33af,
  0x00fb, 0x00fc, 0x00d7, 0x005c, 0x00f4, 0x00f9, 0x00fa, 0x3388,
  0x00fc, 0x00fd, 0x002c, 0x005b, 0x00f3, 0x00f8, 0x00d3, 0x3366,
  0x00fd, 0x0004, 0x002b, 0x005a, 0x00f2, 0x00d1, 0x00b1, 0x333a,
  0x0002, 0x0003, 0x002a, 0x0059, 0x00cb, 0x00af, 0x0085, 0x3335,
  0x0001, 0x0002, 0x0029, 0x0032, 0x00a9, 0x0083, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0028, 0x0024, 0x003c, 0x0082, 0x007f, 0x0080, 0x3334,
  0x0028, 0x004a, 0x0050, 0x0041, 0x0083, 0x0080, 0x0081, 0x3335,
  0x004a, 0x0076, 0x0055, 0x0042, 0x0084, 0x0081, 0x0082, 0x3336,
  0x0076, 0x007b, 0x0056, 0x0043, 0x0085, 0x0082, 0x0083, 0x333c,
  0x007b, 0x007c, 0x0057, 0x0044, 0x0086, 0x0083, 0x0089, 0x3367,
  0x007c, 0x007d, 0x0058, 0x0045, 0x0087, 0x0089, 0x00b4, 0x3389,
  0x007d, 0x007e, 0x0059, 0x0046, 0x008d, 0x00b4, 0x00d6, 0x33b1,
  0x007e, 0x007f, 0x005a, 0x004c, 0x00b8, 0x00d6, 0x00fe, 0x33b2,
  0x007f, 0x0080, 0x0060, 0x0077, 0x00da, 0x00fe, 0x00ff, 0x33b3,
  0x0080, 0x0086, 0x008b, 0x0099, 0x0102, 0x00ff, 0x0100, 0x33b2,
  0x0086, 0x00b1, 0x00ad, 0x00c1, 0x0103, 0x0100, 0x00fd, 0x33b1,
  0x00b0, 0x00ac, 0x00b3, 0x0096, 0x00ff, 0x00fc, 0x00fd, 0x33b1,
  0x00d2, 0x00d4, 0x00b4, 0x0097, 0x00fa, 0x00fb, 0x00fc, 0x33b0,
  0x00fa, 0x00d5, 0x00b5, 0x0088, 0x00f9, 0x00fa, 0x00fb, 0x3389,
  0x00fb, 0x00d6, 0x004e, 0x0087, 0x00f8, 0x00f9, 0x00d4, 0x3367,
  0x00fc, 0x002b, 0x004d, 0x0086, 0x00f7, 0x00d2, 0x00b2, 0x333b,
  0x0003, 0x002a, 0x004c, 0x0085, 0x00d0, 0x00b0, 0x0086, 0x3336,
  0x0002, 0x0029, 0x004b, 0x005e, 0x00ae, 0x0084, 0x0081, 0x3335,
  0x0001, 0x0028, 0x0024, 0x003c, 0x0082, 0x007f, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0027, 0x0023, 0x002e, 0x0015, 0x007e, 0x007f, 0x0080, 0x3334,
  0x0049, 0x004f, 0x0033, 0x0016, 0x007f, 0x0080, 0x0081, 0x3335,
  0x0075, 0x0054, 0x0034, 0x0017, 0x0080, 0x0081, 0x0082, 0x333b,
  0x007a, 0x0055, 0x0035, 0x0018, 0x0081, 0x0082, 0x0088, 0x3366,
  0x007b, 0x0056, 0x0036, 0x0019, 0x0082, 0x0088, 0x00b3, 0x3388,
  0x007c, 0x0057, 0x0037, 0x001a, 0x0088, 0x00b3, 0x00d5, 0x33b0,
  0x007d, 0x0058, 0x0038, 0x0020, 0x00b3, 0x00d5, 0x00fd, 0x33b1,
  0x007e, 0x0059, 0x003e, 0x004b, 0x00d5, 0x00fd, 0x00fe, 0x33b2,
  0x007f, 0x005f, 0x0069, 0x006d, 0x00fd, 0x00fe, 0x00ff, 0x33b3,
  0x0085, 0x008a, 0x008b, 0x0095, 0x00fe, 0x00ff, 0x00fe, 0x33b2,
  0x0089, 0x008a, 0x0087, 0x0091, 0x00fe, 0x00fd, 0x00fe, 0x33b2,
  0x00ab, 0x00b2, 0x0088, 0x0092, 0x00fb, 0x00fc, 0x00fd, 0x33b1,
  0x00d3, 0x00b3, 0x0089, 0x008d, 0x00fa, 0x00fb, 0x00fc, 0x338a,
  0x00d4, 0x00b4, 0x007a, 0x008c, 0x00f9, 0x00fa, 0x00d5, 0x3368,
  0x00d5, 0x004d, 0x0079, 0x008b, 0x00f8, 0x00d3, 0x00b3, 0x333c,
  0x002a, 0x004c, 0x0078, 0x008a, 0x00d1, 0x00b1, 0x0087, 0x3337,
  0x0029, 0x004b, 0x0077, 0x0063, 0x00af, 0x0085, 0x0082, 0x3336,
  0x0028, 0x004a, 0x0050, 0x0041, 0x0083, 0x0080, 0x0081, 0x3335,
  0x0027, 0x0023, 0x002e, 0x0015, 0x007e, 0x007f, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0022, 0x002d, 0x0007, 0x0011, 0x007e, 0x007f, 0x0080, 0x3334,
  0x004e, 0x0032, 0x0008, 0x0012, 0x007f, 0x0080, 0x0081, 0x333a,
  0x0053, 0x0033, 0x0009, 0x0013, 0x0080, 0x0081, 0x0087, 0x3365,
  0x0054, 0x0034, 0x000a, 0x0014, 0x0081, 0x0087, 0x00b2, 0x3387,
  0x0055, 0x0035, 0x000b, 0x0015, 0x0087, 0x00b2, 0x00d4, 0x33af,
  0x0056, 0x0036, 0x000c, 0x001b, 0x00b2, 0x00d4, 0x00fc, 0x33b0,
  0x0057, 0x0037, 0x0012, 0x0046, 0x00d4, 0x00fc, 0x00fd, 0x33b1,
  0x0058, 0x003d, 0x003d, 0x0068, 0x00fc, 0x00fd, 0x00fe, 0x33b4,
  0x005e, 0x0068, 0x005f, 0x0090, 0x00fd, 0x00fe, 0x00ff, 0x33b3,
  0x0067, 0x005e, 0x0082, 0x0090, 0x00fd, 0x00fe, 0x00ff, 0x33b3,
  0x0089, 0x0086, 0x0083, 0x0091, 0x00fc, 0x00fd, 0x00fe, 0x33b2,
  0x00b1, 0x0087, 0x0084, 0x008e, 0x00fb, 0x00fc, 0x00fd, 0x338b,
  0x00b2, 0x0088, 0x007f, 0x008d, 0x00fa, 0x00fb, 0x00d6, 0x3369,
  0x00b3, 0x0079, 0x007e, 0x008c, 0x00f9, 0x00d4, 0x00b4, 0x333d,
  0x004c, 0x0078, 0x007d, 0x008b, 0x00d2, 0x00b2, 0x0088, 0x3338,
  0x004b, 0x0077, 0x007c, 0x0064, 0x00b0, 0x0086, 0x0083, 0x3337,
  0x004a, 0x0076, 0x0055, 0x0042, 0x0084, 0x0081, 0x0082, 0x3336,
  0x0049, 0x004f, 0x0033, 0x0016, 0x007f, 0x0080, 0x0081, 0x3335,
  0x0022, 0x002d, 0x0007, 0x0011, 0x007e, 0x007f, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x002c, 0x0006, 0x0003, 0x0011, 0x007e, 0x007f, 0x0080, 0x3339,
  0x0031, 0x0007, 0x0004, 0x0012, 0x007f, 0x0080, 0x0086, 0x3364,
  0x0032, 0x0008, 0x0005, 0x0013, 0x0080, 0x0086, 0x00b1, 0x3386,
  0x0033, 0x0009, 0x0006, 0x0014, 0x0086, 0x00b1, 0x00d3, 0x33ae,
  0x0034, 0x000a, 0x0007, 0x001a, 0x00b1, 0x00d3, 0x00fb, 0x33af,
  0x0035, 0x000b, 0x000d, 0x0045, 0x00d3, 0x00fb, 0x00fc, 0x33b0,
  0x0036, 0x0011, 0x0038, 0x0067, 0x00fb, 0x00fc, 0x00fd, 0x33b5,
  0x003c, 0x003c, 0x005a, 0x008f, 0x00fc, 0x00fd, 0x0100, 0x33b4,
  0x003b, 0x0059, 0x0081, 0x008f, 0x00fc, 0x00ff, 0x0100, 0x33b9,
  0x005d, 0x0081, 0x0082, 0x0090, 0x00fd, 0x00fe, 0x00ff, 0x33b8,
  0x0085, 0x0082, 0x0083, 0x008f, 0x00fc, 0x00fd, 0x00fe, 0x3391,
  0x0086, 0x0083, 0x0080, 0x008e, 0x00fb, 0x00fc, 0x00d7, 0x336f,
  0x0087, 0x007e, 0x007f, 0x008d, 0x00fa, 0x00d5, 0x00b5, 0x3343,
  0x0078, 0x007d, 0x007e, 0x008c, 0x00d3, 0x00b3, 0x0089, 0x333e,
  0x0077, 0x007c, 0x007d, 0x0065, 0x00b1, 0x0087, 0x0084, 0x333d,
  0x0076, 0x007b, 0x0056, 0x0043, 0x0085, 0x0082, 0x0083, 0x333c,
  0x0075, 0x0054, 0x0034, 0x0017, 0x0080, 0x0081, 0x0082, 0x333b,
  0x004e, 0x0032, 0x0008, 0x0012, 0x007f, 0x0080, 0x0081, 0x333a,
  0x002c, 0x0006, 0x0003, 0x0011, 0x007e, 0x007f, 0x0080, 0x3339,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0005, 0x0002, 0x0003, 0x0011, 0x007e, 0x007f, 0x0085, 0x335e,
  0x0006, 0x0003, 0x0004, 0x0012, 0x007f, 0x0085, 0x00b0, 0x3380,
  0x0007, 0x0004, 0x0005, 0x0013, 0x0085, 0x00b0, 0x00d2, 0x33a8,
  0x0008, 0x0005, 0x0006, 0x0019, 0x00b0, 0x00d2, 0x00fa, 0x33a9,
  0x0009, 0x0006, 0x000c, 0x0044, 0x00d2, 0x00fa, 0x00fb, 0x33aa,
  0x000a, 0x000c, 0x0037, 0x0066, 0x00fa, 0x00fb, 0x00fc, 0x33bb,
  0x0010, 0x0037, 0x0059, 0x008e, 0x00fb, 0x00fc, 0x0101, 0x33ba,
  0x0036, 0x0058, 0x0080, 0x008e, 0x00fb, 0x0100, 0x0106, 0x33e4,
  0x0058, 0x0080, 0x0081, 0x008f, 0x00fe, 0x00ff, 0x0105, 0x33e3,
  0x0080, 0x0081, 0x0082, 0x0090, 0x00fd, 0x00fe, 0x0104, 0x33bc,
  0x0081, 0x0082, 0x0081, 0x008f, 0x00fc, 0x00fd, 0x00dd, 0x339a,
  0x0082, 0x007f, 0x0080, 0x008e, 0x00fb, 0x00d6, 0x00bb, 0x336e,
  0x007d, 0x007e, 0x007f, 0x008d, 0x00d4, 0x00b4, 0x008f, 0x3369,
  0x007c, 0x007d, 0x007e, 0x0066, 0x00b2, 0x0088, 0x008a, 0x3368,
  0x007b, 0x007c, 0x0057, 0x0044, 0x0086, 0x0083, 0x0089, 0x3367,
  0x007a, 0x0055, 0x0035, 0x0018, 0x0081, 0x0082, 0x0088, 0x3366,
  0x0053, 0x0033, 0x0009, 0x0013, 0x0080, 0x0081, 0x0087, 0x3365,
  0x0031, 0x0007, 0x0004, 0x0012, 0x007f, 0x0080, 0x0086, 0x3364,
  0x0005, 0x0002, 0x0003, 0x0011, 0x007e, 0x007f, 0x0085, 0x335e,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0003, 0x0011, 0x007e, 0x0084, 0x00aa, 0x3355,
  0x0002, 0x0003, 0x0004, 0x0012, 0x0084, 0x00af, 0x00cc, 0x337d,
  0x0003, 0x0004, 0x0005, 0x0018, 0x00af, 0x00d1, 0x00f4, 0x337e,
  0x0004, 0x0005, 0x000b, 0x0043, 0x00d1, 0x00f9, 0x00f5, 0x337f,
  0x0005, 0x000b, 0x0036, 0x0065, 0x00f9, 0x00fa, 0x00f6, 0x33e6,
  0x000b, 0x0036, 0x0058, 0x008d, 0x00fa, 0x00fb, 0x0107, 0x33e5,
  0x0035, 0x0057, 0x007f, 0x008d, 0x00fa, 0x0106, 0x0131, 0x3406,
  0x0057, 0x007f, 0x0080, 0x008e, 0x00ff, 0x0105, 0x0130, 0x3405,
  0x007f, 0x0080, 0x0081, 0x0091, 0x00fe, 0x0104, 0x012f, 0x33de,
  0x0080, 0x0081, 0x0082, 0x0090, 0x00fd, 0x0103, 0x0108, 0x33bc,
  0x0081, 0x0080, 0x0081, 0x008f, 0x00fc, 0x00dc, 0x00e6, 0x3390,
  0x007e, 0x007f, 0x0080, 0x008e, 0x00d5, 0x00ba, 0x00ba, 0x338b,
  0x007d, 0x007e, 0x007f, 0x0067, 0x00b3, 0x008e, 0x00b5, 0x338a,
  0x007c, 0x007d, 0x0058, 0x0045, 0x0087, 0x0089, 0x00b4, 0x3389,
  0x007b, 0x0056, 0x0036, 0x0019, 0x0082, 0x0088, 0x00b3, 0x3388,
  0x0054, 0x0034, 0x000a, 0x0014, 0x0081, 0x0087, 0x00b2, 0x3387,
  0x0032, 0x0008, 0x0005, 0x0013, 0x0080, 0x0086, 0x00b1, 0x3386,
  0x0006, 0x0003, 0x0004, 0x0012, 0x007f, 0x0085, 0x00b0, 0x3380,
  0x0001, 0x0002, 0x0003, 0x0011, 0x007e, 0x0084, 0x00aa, 0x3355,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0003, 0x0011, 0x0083, 0x00a9, 0x00a1, 0x335b,
  0x0002, 0x0003, 0x0004, 0x0017, 0x00ae, 0x00cb, 0x00c9, 0x335c,
  0x0003, 0x0004, 0x000a, 0x0042, 0x00d0, 0x00f3, 0x00ca, 0x335d,
  0x0004, 0x000a, 0x0035, 0x0064, 0x00f8, 0x00f4, 0x00cb, 0x3408,
  0x000a, 0x0035, 0x0057, 0x008c, 0x00f9, 0x00f5, 0x0132, 0x3407,
  0x0034, 0x0056, 0x007e, 0x008c, 0x00f4, 0x0131, 0x0153, 0x342e,
  0x0056, 0x007e, 0x007f, 0x008d, 0x0105, 0x0130, 0x0152, 0x342d,
  0x007e, 0x007f, 0x0080, 0x0092, 0x0104, 0x012f, 0x0151, 0x3406,
  0x007f, 0x0080, 0x0083, 0x0091, 0x0103, 0x012e, 0x012a, 0x33e4,
  0x0080, 0x0081, 0x0082, 0x0090, 0x0102, 0x0107, 0x0108, 0x33b8,
  0x007f, 0x0080, 0x0081, 0x008f, 0x00db, 0x00e5, 0x00dc, 0x33b3,
  0x007e, 0x007f, 0x0080, 0x0068, 0x00b9, 0x00b9, 0x00d7, 0x33b2,
  0x007d, 0x007e, 0x0059, 0x0046, 0x008d, 0x00b4, 0x00d6, 0x33b1,
  0x007c, 0x0057, 0x0037, 0x001a, 0x0088, 0x00b3, 0x00d5, 0x33b0,
  0x0055, 0x0035, 0x000b, 0x0015, 0x0087, 0x00b2, 0x00d4, 0x33af,
  0x0033, 0x0009, 0x0006, 0x0014, 0x0086, 0x00b1, 0x00d3, 0x33ae,
  0x0007, 0x0004, 0x0005, 0x0013, 0x0085, 0x00b0, 0x00d2, 0x33a8,
  0x0002, 0x0003, 0x0004, 0x0012, 0x0084, 0x00af, 0x00cc, 0x337d,
  0x0001, 0x0002, 0x0003, 0x0011, 0x0083, 0x00a9, 0x00a1, 0x335b,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0003, 0x0016, 0x00a8, 0x00a0, 0x00a7, 0x3334,
  0x0002, 0x0003, 0x0009, 0x0041, 0x00ca, 0x00c8, 0x00a8, 0x3335,
  0x0003, 0x0009, 0x0034, 0x0063, 0x00f2, 0x00c9, 0x00a9, 0x3430,
  0x0009, 0x0034, 0x0056, 0x008b, 0x00f3, 0x00ca, 0x0154, 0x342f,
  0x0033, 0x0055, 0x007d, 0x0086, 0x00c9, 0x0153, 0x017b, 0x342f,
  0x0055, 0x007d, 0x007e, 0x0087, 0x0130, 0x0152, 0x017a, 0x342e,
  0x007d, 0x007e, 0x007f, 0x0098, 0x012f, 0x0151, 0x0179, 0x3407,
  0x007e, 0x007f, 0x0084, 0x0097, 0x012e, 0x0150, 0x0152, 0x33e5,
  0x007f, 0x0082, 0x0083, 0x0096, 0x012d, 0x0129, 0x0130, 0x33b9,
  0x0080, 0x0081, 0x0082, 0x0095, 0x0106, 0x0107, 0x0104, 0x33b4,
  0x007f, 0x0080, 0x0081, 0x006e, 0x00e4, 0x00db, 0x00ff, 0x33b3,
  0x007e, 0x007f, 0x005a, 0x004c, 0x00b8, 0x00d6, 0x00fe, 0x33b2,
  0x007d, 0x0058, 0x0038, 0x0020, 0x00b3, 0x00d5, 0x00fd, 0x33b1,
  0x0056, 0x0036, 0x000c, 0x001b, 0x00b2, 0x00d4, 0x00fc, 0x33b0,
  0x0034, 0x000a, 0x0007, 0x001a, 0x00b1, 0x00d3, 0x00fb, 0x33af,
  0x0008, 0x0005, 0x0006, 0x0019, 0x00b0, 0x00d2, 0x00fa, 0x33a9,
  0x0003, 0x0004, 0x0005, 0x0018, 0x00af, 0x00d1, 0x00f4, 0x337e,
  0x0002, 0x0003, 0x0004, 0x0017, 0x00ae, 0x00cb, 0x00c9, 0x335c,
  0x0001, 0x0002, 0x0003, 0x0016, 0x00a8, 0x00a0, 0x00a7, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0008, 0x003b, 0x009f, 0x00a6, 0x0080, 0x3334,
  0x0002, 0x0008, 0x0033, 0x005d, 0x00c7, 0x00a7, 0x0081, 0x3431,
  0x0008, 0x0033, 0x0055, 0x0085, 0x00c8, 0x00a8, 0x017c, 0x3430,
  0x0032, 0x0054, 0x0077, 0x005b, 0x00a7, 0x017b, 0x017c, 0x3430,
  0x0054, 0x007c, 0x0078, 0x005c, 0x0152, 0x017a, 0x017b, 0x342f,
  0x007c, 0x007d, 0x0079, 0x00c3, 0x0151, 0x0179, 0x017a, 0x3408,
  0x007d, 0x007e, 0x008a, 0x00c2, 0x0150, 0x0178, 0x0153, 0x33e6,
  0x007e, 0x0083, 0x0089, 0x00c1, 0x014f, 0x0151, 0x0131, 0x33ba,
  0x0081, 0x0082, 0x0088, 0x00c0, 0x0128, 0x012f, 0x0105, 0x33b5,
  0x0080, 0x0081, 0x0087, 0x0099, 0x0106, 0x0103, 0x0100, 0x33b4,
  0x007f, 0x0080, 0x0060, 0x0077, 0x00da, 0x00fe, 0x00ff, 0x33b3,
  0x007e, 0x0059, 0x003e, 0x004b, 0x00d5, 0x00fd, 0x00fe, 0x33b2,
  0x0057, 0x0037, 0x0012, 0x0046, 0x00d4, 0x00fc, 0x00fd, 0x33b1,
  0x0035, 0x000b, 0x000d, 0x0045, 0x00d3, 0x00fb, 0x00fc, 0x33b0,
  0x0009, 0x0006, 0x000c, 0x0044, 0x00d2, 0x00fa, 0x00fb, 0x33aa,
  0x0004, 0x0005, 0x000b, 0x0043, 0x00d1, 0x00f9, 0x00f5, 0x337f,
  0x0003, 0x0004, 0x000a, 0x0042, 0x00d0, 0x00f3, 0x00ca, 0x335d,
  0x0002, 0x0003, 0x0009, 0x0041, 0x00ca, 0x00c8, 0x00a8, 0x3335,
  0x0001, 0x0002, 0x0008, 0x003b, 0x009f, 0x00a6, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0007, 0x002d, 0x0032, 0x00a5, 0x007f, 0x0080, 0x3432,
  0x0007, 0x0032, 0x004f, 0x005a, 0x00a6, 0x0080, 0x017d, 0x3431,
  0x0031, 0x004e, 0x004c, 0x0039, 0x007f, 0x017c, 0x017d, 0x3335,
  0x0053, 0x0076, 0x004d, 0x003a, 0x017a, 0x017b, 0x017c, 0x3336,
  0x007b, 0x0077, 0x004e, 0x00e5, 0x0179, 0x017a, 0x017b, 0x335d,
  0x007c, 0x0078, 0x00b5, 0x00e4, 0x0178, 0x0179, 0x0154, 0x337f,
  0x007d, 0x0089, 0x00b4, 0x00e3, 0x0177, 0x0152, 0x0132, 0x33ab,
  0x0082, 0x0088, 0x00b3, 0x00e2, 0x0150, 0x0130, 0x0106, 0x33b0,
  0x0081, 0x0087, 0x00b2, 0x00bb, 0x012e, 0x0104, 0x0101, 0x33b1,
  0x0080, 0x0086, 0x008b, 0x0099, 0x0102, 0x00ff, 0x0100, 0x33b2,
  0x007f, 0x005f, 0x0069, 0x006d, 0x00fd, 0x00fe, 0x00ff, 0x33b3,
  0x0058, 0x003d, 0x003d, 0x0068, 0x00fc, 0x00fd, 0x00fe, 0x33b4,
  0x0036, 0x0011, 0x0038, 0x0067, 0x00fb, 0x00fc, 0x00fd, 0x33b5,
  0x000a, 0x000c, 0x0037, 0x0066, 0x00fa, 0x00fb, 0x00fc, 0x33bb,
  0x0005, 0x000b, 0x0036, 0x0065, 0x00f9, 0x00fa, 0x00f6, 0x33e6,
  0x0004, 0x000a, 0x0035, 0x0064, 0x00f8, 0x00f4, 0x00cb, 0x3408,
  0x0003, 0x0009, 0x0034, 0x0063, 0x00f2, 0x00c9, 0x00a9, 0x3430,
  0x0002, 0x0008, 0x0033, 0x005d, 0x00c7, 0x00a7, 0x0081, 0x3431,
  0x0001, 0x0007, 0x002d, 0x0032, 0x00a5, 0x007f, 0x0080, 0x3432,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0006, 0x002c, 0x0024, 0x0038, 0x007e, 0x007f, 0x017e, 0x3334,
  0x002b, 0x0023, 0x002a, 0x0011, 0x007e, 0x017d, 0x0080, 0x3334,
  0x004d, 0x004b, 0x002b, 0x0012, 0x017b, 0x017c, 0x0081, 0x3335,
  0x0075, 0x004c, 0x002c, 0x010d, 0x017a, 0x017b, 0x0082, 0x335c,
  0x0076, 0x004d, 0x00d7, 0x010c, 0x0179, 0x017a, 0x00a9, 0x337e,
  0x0077, 0x00b4, 0x00d6, 0x010b, 0x0178, 0x0153, 0x00cb, 0x33aa,
  0x0088, 0x00b3, 0x00d5, 0x010a, 0x0151, 0x0131, 0x00f7, 0x33af,
  0x0087, 0x00b2, 0x00d4, 0x00e3, 0x012f, 0x0105, 0x00fc, 0x33b0,
  0x0086, 0x00b1, 0x00ad, 0x00c1, 0x0103, 0x0100, 0x00fd, 0x33b1,
  0x0085, 0x008a, 0x008b, 0x0095, 0x00fe, 0x00ff, 0x00fe, 0x33b2,
  0x005e, 0x0068, 0x005f, 0x0090, 0x00fd, 0x00fe, 0x00ff, 0x33b3,
  0x003c, 0x003c, 0x005a, 0x008f, 0x00fc, 0x00fd, 0x0100, 0x33b4,
  0x0010, 0x0037, 0x0059, 0x008e, 0x00fb, 0x00fc, 0x0101, 0x33ba,
  0x000b, 0x0036, 0x0058, 0x008d, 0x00fa, 0x00fb, 0x0107, 0x33e5,
  0x000a, 0x0035, 0x0057, 0x008c, 0x00f9, 0x00f5, 0x0132, 0x3407,
  0x0009, 0x0034, 0x0056, 0x008b, 0x00f3, 0x00ca, 0x0154, 0x342f,
  0x0008, 0x0033, 0x0055, 0x0085, 0x00c8, 0x00a8, 0x017c, 0x3430,
  0x0007, 0x0032, 0x004f, 0x005a, 0x00a6, 0x0080, 0x017d, 0x3431,
  0x0006, 0x002c, 0x0024, 0x0038, 0x007e, 0x007f, 0x017e, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
};
const unsigned kExpectedCount_NEON_sabal_8H = 361;

#endif  // VIXL_SIM_SABAL_8H_TRACE_AARCH64_H_
