'\"
'\" Generated from file 'rtcore\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "fileutil::magic::rt" n 2\&.0 tcllib "file utilities"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
fileutil::magic::rt \- Runtime core for file type recognition engines written in pure Tcl
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBfileutil::magic::rt  ?2\&.0?\fR
.sp
\fB::fileutil::magic::rt::>\fR
.sp
\fB::fileutil::magic::rt::<\fR
.sp
\fB::fileutil::magic::rt::open\fR \fIfilename\fR
.sp
\fB::fileutil::magic::rt::close\fR
.sp
\fB::fileutil::magic::rt::file_start\fR \fIname\fR
.sp
\fB::fileutil::magic::rt::result\fR ?\fImsg\fR?
.sp
\fB::fileutil::magic::rt::resultv\fR ?\fImsg\fR?
.sp
\fB::fileutil::magic::rt::emit\fR \fImsg\fR
.sp
\fB::fileutil::magic::rt::offset\fR \fIwhere\fR
.sp
\fB::fileutil::magic::rt::Nv\fR \fItype\fR \fIoffset\fR ?\fIqual\fR?
.sp
\fB::fileutil::magic::rt::N\fR \fItype\fR \fIoffset\fR \fIcomp\fR \fIval\fR ?\fIqual\fR?
.sp
\fB::fileutil::magic::rt::Nvx\fR \fItype\fR \fIoffset\fR ?\fIqual\fR?
.sp
\fB::fileutil::magic::rt::Nx\fR \fItype\fR \fIoffset\fR \fIcomp\fR \fIval\fR ?\fIqual\fR?
.sp
\fB::fileutil::magic::rt::S\fR \fIoffset\fR \fIcomp\fR \fIval\fR ?\fIqual\fR?
.sp
\fB::fileutil::magic::rt::Sx\fR \fIoffset\fR \fIcomp\fR \fIval\fR ?\fIqual\fR?
.sp
\fB::fileutil::magic::rt::L\fR \fInewlevel\fR
.sp
\fB::fileutil::magic::rt::I\fR \fIbase\fR \fItype\fR \fIdelta\fR
.sp
\fB::fileutil::magic::rt::R\fR \fIoffset\fR
.sp
\fB::fileutil::magic::rt::U\fR \fIfileindex\fR \fIname\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides the runtime core for file type recognition
engines written in pure Tcl and is thus used by all other packages in
this module, i\&.e\&. the two frontend packages
\fBfileutil::magic::mimetypes\fR and
\fBfileutil::magic::filetypes\fR, and the two engine compiler
packages \fBfileutil::magic::cgen\fR and
\fBfileutil::magic::cfront\fR\&.
.SH COMMANDS
.TP
\fB::fileutil::magic::rt::>\fR
Shorthand for \fBincr level\fR\&.
.TP
\fB::fileutil::magic::rt::<\fR
Shorthand for \fBincr level -1\fR\&.
.TP
\fB::fileutil::magic::rt::open\fR \fIfilename\fR
This command initializes the runtime and prepares the file
\fIfilename\fR for use by the system\&.
This command has to be invoked first, before any other command of this
package\&.
.sp
The command returns the channel handle of the opened file as its
result\&.
.TP
\fB::fileutil::magic::rt::close\fR
This command closes the last file opened via
\fB::fileutil::magic::rt::open\fR and shuts the runtime down\&.
This command has to be invoked last, after the file has been dealt
with completely\&.
Afterward another invokation of \fB::fileutil::magic::rt::open\fR  is
required to process another file\&.
.sp
This command returns the empty string as its result\&.
.TP
\fB::fileutil::magic::rt::file_start\fR \fIname\fR
This command marks the start of a magic file when debugging\&. It
returns the empty string as its result\&.
.TP
\fB::fileutil::magic::rt::result\fR ?\fImsg\fR?
This command returns the current result and stops processing\&.
.sp
If \fImsg\fR is specified its text is added to the result before it is
returned\&. See \fB::fileutil::magic::rt::emit\fR for the allowed
special character sequences\&.
.TP
\fB::fileutil::magic::rt::resultv\fR ?\fImsg\fR?
This command returns the current result\&.
In contrast to \fB::fileutil::magic::rt::result\fR processing
continues\&.
.sp
If \fImsg\fR is specified its text is added to the result before it is
returned\&. See \fB::fileutil::magic::rt::emit\fR for the allowed
special character sequences\&.
.TP
\fB::fileutil::magic::rt::emit\fR \fImsg\fR
This command adds the text \fImsg\fR to the result buffer\&. The
message may contain the following special character sequences\&. They
will be replaced with buffered values before the message is added to
the result\&. The command returns the empty string as its result\&.
.RS
.TP
\fB\\b\fR
This sequence is removed
.TP
\fB%s\fR
Replaced with the last buffered string value\&.
.TP
\fB%ld\fR
Replaced with the last buffered numeric value\&.
.TP
\fB%d\fR
See above\&.
.RE
.TP
\fB::fileutil::magic::rt::Nv\fR \fItype\fR \fIoffset\fR ?\fIqual\fR?
This command fetches the numeric value with \fItype\fR from the
absolute location \fIoffset\fR and returns it as its result\&. The
fetched value is further stored in the numeric buffer\&.
.sp
If \fIqual\fR is specified it is considered to be a mask and applied
to the fetched value before it is stored and returned\&. It has to have
the form of a partial Tcl bit-wise expression, i\&.e\&.
.CS


	& number

.CE
.IP
For example:
.CS


	Nv lelong 0 &0x8080ffff

.CE
.IP
For the possible types see section \fBNUMERIC TYPES\fR\&.
.TP
\fB::fileutil::magic::rt::N\fR \fItype\fR \fIoffset\fR \fIcomp\fR \fIval\fR ?\fIqual\fR?
This command behaves mostly like \fB::fileutil::magic::rt::Nv\fR,
except that it compares the fetched and masked value against \fIval\fR
as specified with \fIcomp\fR and returns the result of that
comparison\&.
.sp
The argument \fIcomp\fR has to contain one of Tcl's comparison
operators, and the comparison made will be
.CS


	<val> <comp> <fetched-and-masked-value>

.CE
.sp
The special comparison operator \fBx\fR signals that no comparison
should be done, or, in other words, that the fetched value will always
match \fIval\fR\&.
.TP
\fB::fileutil::magic::rt::Nvx\fR \fItype\fR \fIoffset\fR ?\fIqual\fR?
This command behaves like \fB::fileutil::magic::rt::Nv\fR, except that
it additionally remembers the location in the file after the fetch in
the calling context, for the current level, for later use by
\fB::fileutil::magic::rt::R\fR\&.
.TP
\fB::fileutil::magic::rt::Nx\fR \fItype\fR \fIoffset\fR \fIcomp\fR \fIval\fR ?\fIqual\fR?
This command behaves like \fB::fileutil::magic::rt::N\fR, except that
it additionally remembers the location in the file after the fetch in
the calling context, for the current, for later use by
\fB::fileutil::magic::rt::R\fR\&.
.TP
\fB::fileutil::magic::rt::S\fR \fIoffset\fR \fIcomp\fR \fIval\fR ?\fIqual\fR?
This command behaves like \fB::fileutil::magic::rt::N\fR, except that
it fetches and compares strings, not numeric data\&. The fetched value
is also stored in the internal string buffer instead of the numeric
buffer\&.
.TP
\fB::fileutil::magic::rt::Sx\fR \fIoffset\fR \fIcomp\fR \fIval\fR ?\fIqual\fR?
This command behaves like \fB::fileutil::magic::rt::S\fR, except that
it additionally remembers the location in the file after the fetch in
the calling context, for the current level, for later use by
\fB::fileutil::magic::rt::R\fR\&.
.TP
\fB::fileutil::magic::rt::L\fR \fInewlevel\fR
This command sets the current level in the calling context to
\fInewlevel\fR\&. The command returns the empty string as its result\&.
.TP
\fB::fileutil::magic::rt::I\fR \fIbase\fR \fItype\fR \fIdelta\fR
This command handles base locations specified indirectly through the
contents of the inspected file\&. It returns the sum of \fIdelta\fR and
the value of numeric \fItype\fR fetched from the absolute location
\fIbase\fR\&.
.sp
For the possible types see section \fBNUMERIC TYPES\fR\&.
.TP
\fB::fileutil::magic::rt::R\fR \fIoffset\fR
This command handles base locations specified relative to the end of
the last field one level above\&.
.sp
In other words, the command computes an absolute location in the file
based on the relative \fIoffset\fR and returns it as its result\&. The
base the offset is added to is the last location remembered for the
level in the calling context\&.
.TP
\fB::fileutil::magic::rt::U\fR \fIfileindex\fR \fIname\fR
Use a named test script at the current level\&.
.PP
.SH "NUMERIC TYPES"
.TP
\fBbyte\fR
8-bit integer
.TP
\fBshort\fR
16-bit integer, stored in native endianess
.TP
\fBbeshort\fR
see above, stored in big endian
.TP
\fBleshort\fR
see above, stored in small/little endian
.TP
\fBlong\fR
32-bit integer, stored in native endianess
.TP
\fBbelong\fR
see above, stored in big endian
.TP
\fBlelong\fR
see above, stored in small/little endian
.PP
All of the types above exit in an unsigned form as well\&. The type
names are the same, with the character "u" added as prefix\&.
.TP
\fBdate\fR
32-bit integer timestamp, stored in native endianess
.TP
\fBbedate\fR
see above, stored in big endian
.TP
\fBledate\fR
see above, stored in small/little endian
.TP
\fBldate\fR
32-bit integer timestamp, stored in native endianess
.TP
\fBbeldate\fR
see above, stored in big endian
.TP
\fBleldate\fR
see above, stored in small/little endian
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIfileutil :: magic\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH "SEE ALSO"
file(1), fileutil, magic(5)
.SH KEYWORDS
file recognition, file type, file utilities, mime, type
.SH CATEGORY
Programming tools
