; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=armv7-none-eabi -mcpu=cortex-a8 | FileCheck %s -check-prefix=CHECK-ARM
; RUN: llc < %s -mtriple=armv7-none-eabi -mcpu=cortex-a9 | FileCheck %s -check-prefix=CHECK-ARM
; RUN: llc < %s -mtriple=thumbv7m-none-eabi | FileCheck %s -check-prefix=CHECK-THUMB
; rdar://8576755


define i32 @test1(i32 %X, i32 %Y, i8 %sh) {
; CHECK-ARM-LABEL: test1:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    uxtb r2, r2
; CHECK-ARM-NEXT:    add r0, r0, r1, lsl r2
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test1:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    uxtb r2, r2
; CHECK-THUMB-NEXT:    lsls r1, r2
; CHECK-THUMB-NEXT:    add r0, r1
; CHECK-THUMB-NEXT:    bx lr
        %shift.upgrd.1 = zext i8 %sh to i32
        %A = shl i32 %Y, %shift.upgrd.1
        %B = add i32 %X, %A
        ret i32 %B
}

define i32 @test2(i32 %X, i32 %Y, i8 %sh) {
; CHECK-ARM-LABEL: test2:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    uxtb r2, r2
; CHECK-ARM-NEXT:    bic r0, r0, r1, asr r2
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test2:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    uxtb r2, r2
; CHECK-THUMB-NEXT:    asrs r1, r2
; CHECK-THUMB-NEXT:    bics r0, r1
; CHECK-THUMB-NEXT:    bx lr
        %shift.upgrd.2 = zext i8 %sh to i32
        %A = ashr i32 %Y, %shift.upgrd.2
        %B = xor i32 %A, -1
        %C = and i32 %X, %B
        ret i32 %C
}

define i32 @test3(i32 %base, i32 %base2, i32 %offset) {
; CHECK-ARM-LABEL: test3:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    ldr r0, [r0, r2, lsl #2]
; CHECK-ARM-NEXT:    ldr r1, [r1, r2, lsl #2]
; CHECK-ARM-NEXT:    add r0, r1, r0
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test3:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    ldr.w r0, [r0, r2, lsl #2]
; CHECK-THUMB-NEXT:    ldr.w r1, [r1, r2, lsl #2]
; CHECK-THUMB-NEXT:    add r0, r1
; CHECK-THUMB-NEXT:    bx lr
entry:
        %tmp1 = shl i32 %offset, 2
        %tmp2 = add i32 %base, %tmp1
        %tmp3 = inttoptr i32 %tmp2 to ptr
        %tmp4 = add i32 %base2, %tmp1
        %tmp5 = inttoptr i32 %tmp4 to ptr
        %tmp6 = load i32, ptr %tmp3
        %tmp7 = load i32, ptr %tmp5
        %tmp8 = add i32 %tmp7, %tmp6
        ret i32 %tmp8
}

declare ptr @malloc(...)

define fastcc void @test4(i16 %addr) nounwind {
; CHECK-ARM-LABEL: test4:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    .save {r4, lr}
; CHECK-ARM-NEXT:    push {r4, lr}
; CHECK-ARM-NEXT:    mov r4, r0
; CHECK-ARM-NEXT:    bl malloc
; CHECK-ARM-NEXT:    sxth r1, r4
; CHECK-ARM-NEXT:    ldr r2, [r0, r1, lsl #2]
; CHECK-ARM-NEXT:    add r2, r2, #1
; CHECK-ARM-NEXT:    str r2, [r0, r1, lsl #2]
; CHECK-ARM-NEXT:    pop {r4, pc}
;
; CHECK-THUMB-LABEL: test4:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    .save {r4, lr}
; CHECK-THUMB-NEXT:    push {r4, lr}
; CHECK-THUMB-NEXT:    mov r4, r0
; CHECK-THUMB-NEXT:    bl malloc
; CHECK-THUMB-NEXT:    sxth r1, r4
; CHECK-THUMB-NEXT:    ldr.w r2, [r0, r1, lsl #2]
; CHECK-THUMB-NEXT:    adds r2, #1
; CHECK-THUMB-NEXT:    str.w r2, [r0, r1, lsl #2]
; CHECK-THUMB-NEXT:    pop {r4, pc}
entry:
  %0 = tail call ptr (...) @malloc(i32 undef) nounwind
  %1 = sext i16 %addr to i32
  %2 = getelementptr inbounds i32, ptr %0, i32 %1
  %3 = load i32, ptr %2, align 4
  %4 = add nsw i32 %3, 1
  store i32 %4, ptr %2, align 4
  ret void
}

define i32 @test_orr_extract_from_mul_1(i32 %x, i32 %y) {
; CHECK-ARM-LABEL: test_orr_extract_from_mul_1:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    orr r0, r1, r0
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_orr_extract_from_mul_1:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    orrs r0, r1
; CHECK-THUMB-NEXT:    bx lr
entry:
; CHECk-THUMB: orrs r0, r1
  %mul = mul i32 %y, 63767
  %or = or i32 %mul, %x
  ret i32 %or
}

define i32 @test_orr_extract_from_mul_2(i32 %x, i32 %y) {
; CHECK-ARM-LABEL: test_orr_extract_from_mul_2:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    orr r0, r0, r1, lsl #1
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_orr_extract_from_mul_2:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    orr.w r0, r0, r1, lsl #1
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul1 = mul i32 %y, 127534
  %or = or i32 %mul1, %x
  ret i32 %or
}

define i32 @test_orr_extract_from_mul_3(i32 %x, i32 %y) {
; CHECK-ARM-LABEL: test_orr_extract_from_mul_3:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    orr r0, r0, r1, lsl #2
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_orr_extract_from_mul_3:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    orr.w r0, r0, r1, lsl #2
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul1 = mul i32 %y, 255068
  %or = or i32 %mul1, %x
  ret i32 %or
}

define i32 @test_orr_extract_from_mul_4(i32 %x, i32 %y) {
; CHECK-ARM-LABEL: test_orr_extract_from_mul_4:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    orr r0, r0, r1, lsl #3
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_orr_extract_from_mul_4:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    orr.w r0, r0, r1, lsl #3
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul1 = mul i32 %y, 510136
  %or = or i32 %mul1, %x
  ret i32 %or
}

define i32 @test_orr_extract_from_mul_5(i32 %x, i32 %y) {
; CHECK-ARM-LABEL: test_orr_extract_from_mul_5:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    orr r0, r0, r1, lsl #4
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_orr_extract_from_mul_5:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    orr.w r0, r0, r1, lsl #4
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul1 = mul i32 %y, 1020272
  %or = or i32 %mul1, %x
  ret i32 %or
}

define i32 @test_orr_extract_from_mul_6(i32 %x, i32 %y) {
; CHECK-ARM-LABEL: test_orr_extract_from_mul_6:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    orr r0, r0, r1, lsl #16
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_orr_extract_from_mul_6:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    orr.w r0, r0, r1, lsl #16
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul = mul i32 %y, -115933184
  %or = or i32 %mul, %x
  ret i32 %or
}

define i32 @test_load_extract_from_mul_1(ptr %x, i32 %y) {
; CHECK-ARM-LABEL: test_load_extract_from_mul_1:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    ldrb r0, [r0, r1]
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_load_extract_from_mul_1:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    ldrb r0, [r0, r1]
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul = mul i32 %y, 63767
  %arrayidx = getelementptr inbounds i8, ptr %x, i32 %mul
  %0 = load i8, ptr %arrayidx, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

define i32 @test_load_extract_from_mul_2(ptr %x, i32 %y) {
; CHECK-ARM-LABEL: test_load_extract_from_mul_2:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    ldrb r0, [r0, r1, lsl #1]
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_load_extract_from_mul_2:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    ldrb.w r0, [r0, r1, lsl #1]
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul1 = mul i32 %y, 127534
  %arrayidx = getelementptr inbounds i8, ptr %x, i32 %mul1
  %0 = load i8, ptr %arrayidx, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

define i32 @test_load_extract_from_mul_3(ptr %x, i32 %y) {
; CHECK-ARM-LABEL: test_load_extract_from_mul_3:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    ldrb r0, [r0, r1, lsl #2]
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_load_extract_from_mul_3:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    ldrb.w r0, [r0, r1, lsl #2]
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul1 = mul i32 %y, 255068
  %arrayidx = getelementptr inbounds i8, ptr %x, i32 %mul1
  %0 = load i8, ptr %arrayidx, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

define i32 @test_load_extract_from_mul_4(ptr %x, i32 %y) {
; CHECK-ARM-LABEL: test_load_extract_from_mul_4:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    ldrb r0, [r0, r1, lsl #3]
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_load_extract_from_mul_4:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    ldrb.w r0, [r0, r1, lsl #3]
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul1 = mul i32 %y, 510136
  %arrayidx = getelementptr inbounds i8, ptr %x, i32 %mul1
  %0 = load i8, ptr %arrayidx, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

define i32 @test_load_extract_from_mul_5(ptr %x, i32 %y) {
; CHECK-ARM-LABEL: test_load_extract_from_mul_5:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    ldrb r0, [r0, r1, lsl #4]
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_load_extract_from_mul_5:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #37232
; CHECK-THUMB-NEXT:    movt r2, #15
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    ldrb r0, [r0, r1]
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul1 = mul i32 %y, 1020272
  %arrayidx = getelementptr inbounds i8, ptr %x, i32 %mul1
  %0 = load i8, ptr %arrayidx, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

define i32 @test_load_extract_from_mul_6(ptr %x, i32 %y) {
; CHECK-ARM-LABEL: test_load_extract_from_mul_6:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #63767
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    ldrb r0, [r0, r1, lsl #16]
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_load_extract_from_mul_6:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movs r2, #0
; CHECK-THUMB-NEXT:    movt r2, #63767
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    ldrb r0, [r0, r1]
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul = mul i32 %y, -115933184
  %arrayidx = getelementptr inbounds i8, ptr %x, i32 %mul
  %0 = load i8, ptr %arrayidx, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}


define void @test_well_formed_dag(i32 %in1, i32 %in2, ptr %addr) {
; CHECK-ARM-LABEL: test_well_formed_dag:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    movw r3, #675
; CHECK-ARM-NEXT:    mul r0, r0, r3
; CHECK-ARM-NEXT:    add r0, r1, r0, lsl #7
; CHECK-ARM-NEXT:    str r0, [r2]
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_well_formed_dag:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    movw r3, #675
; CHECK-THUMB-NEXT:    muls r0, r3, r0
; CHECK-THUMB-NEXT:    add.w r0, r1, r0, lsl #7
; CHECK-THUMB-NEXT:    str r0, [r2]
; CHECK-THUMB-NEXT:    bx lr

  %mul.small = mul i32 %in1, 675
  store i32 %mul.small, ptr %addr
  %mul.big = mul i32 %in1, 86400
  %add = add i32 %in2, %mul.big
  store i32 %add, ptr %addr
  ret void
}

define { i32, i32 } @test_multi_use_add(i32 %base, i32 %offset) {
; CHECK-ARM-LABEL: test_multi_use_add:
; CHECK-ARM:       @ %bb.0:
; CHECK-ARM-NEXT:    movw r2, #28
; CHECK-ARM-NEXT:    movt r2, #1
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    ldr r1, [r0, r1]!
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_multi_use_add:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    movs r3, #28
; CHECK-THUMB-NEXT:    movt r3, #1
; CHECK-THUMB-NEXT:    mla r2, r1, r3, r0
; CHECK-THUMB-NEXT:    muls r1, r3, r1
; CHECK-THUMB-NEXT:    ldr r1, [r0, r1]
; CHECK-THUMB-NEXT:    mov r0, r2
; CHECK-THUMB-NEXT:    bx lr

  %prod = mul i32 %offset, 65564
  %sum = add i32 %base, %prod

  %ptr = inttoptr i32 %sum to ptr
  %loaded = load i32, ptr %ptr

  %ret.tmp = insertvalue { i32, i32 } undef, i32 %sum, 0
  %ret = insertvalue { i32, i32 } %ret.tmp, i32 %loaded, 1

  ret { i32, i32 } %ret
}

define i32 @test_new(i32 %x, i32 %y) {
; CHECK-ARM-LABEL: test_new:
; CHECK-ARM:       @ %bb.0: @ %entry
; CHECK-ARM-NEXT:    movw r2, #48047
; CHECK-ARM-NEXT:    mul r1, r1, r2
; CHECK-ARM-NEXT:    add r0, r0, r1, lsl #1
; CHECK-ARM-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_new:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    movw r2, #48047
; CHECK-THUMB-NEXT:    muls r1, r2, r1
; CHECK-THUMB-NEXT:    add.w r0, r0, r1, lsl #1
; CHECK-THUMB-NEXT:    bx lr
entry:
  %mul = mul i32 %y, 96094
  %conv = add i32 %mul, %x
  ret i32 %conv
}

; This test was hitting issues with deleted nodes because ComplexPatternFuncMutatesDAG
; was not defined.
@arr_9 = external dso_local local_unnamed_addr global [15 x [25 x [18 x i8]]], align 1
define void @test_mutateddag(i32 %b, i32 %c, i32 %d, i1 %cc) {
; CHECK-THUMB-LABEL: test_mutateddag:
; CHECK-THUMB:       @ %bb.0: @ %entry
; CHECK-THUMB-NEXT:    .save {r4, r5, r7, lr}
; CHECK-THUMB-NEXT:    push {r4, r5, r7, lr}
; CHECK-THUMB-NEXT:    movw r12, #50608
; CHECK-THUMB-NEXT:    movw r4, #51512
; CHECK-THUMB-NEXT:    movt r12, #17917
; CHECK-THUMB-NEXT:    movt r4, #52
; CHECK-THUMB-NEXT:    mla r12, r1, r4, r12
; CHECK-THUMB-NEXT:    mov.w r4, #450
; CHECK-THUMB-NEXT:    movw r5, :lower16:arr_9
; CHECK-THUMB-NEXT:    mul lr, r0, r4
; CHECK-THUMB-NEXT:    movw r0, #12878
; CHECK-THUMB-NEXT:    movt r0, #13
; CHECK-THUMB-NEXT:    muls r0, r1, r0
; CHECK-THUMB-NEXT:    add.w r4, r2, r2, lsl #3
; CHECK-THUMB-NEXT:    movw r2, #60920
; CHECK-THUMB-NEXT:    movt r5, :upper16:arr_9
; CHECK-THUMB-NEXT:    movt r2, #64028
; CHECK-THUMB-NEXT:    lsls r3, r3, #31
; CHECK-THUMB-NEXT:    add.w r0, r0, r4, lsl #1
; CHECK-THUMB-NEXT:    add r0, r5
; CHECK-THUMB-NEXT:    add r2, r0
; CHECK-THUMB-NEXT:    movw r0, #25756
; CHECK-THUMB-NEXT:    movt r0, #26
; CHECK-THUMB-NEXT:    muls r0, r1, r0
; CHECK-THUMB-NEXT:    movw r1, #24420
; CHECK-THUMB-NEXT:    movt r1, #19356
; CHECK-THUMB-NEXT:    add.w r0, r0, r4, lsl #1
; CHECK-THUMB-NEXT:    add r0, r5
; CHECK-THUMB-NEXT:    add r1, r0
; CHECK-THUMB-NEXT:    movs r0, #0
; CHECK-THUMB-NEXT:    b .LBB19_2
; CHECK-THUMB-NEXT:  .LBB19_1: @ %for.cond1.for.cond.cleanup_crit_edge
; CHECK-THUMB-NEXT:    @ in Loop: Header=BB19_2 Depth=1
; CHECK-THUMB-NEXT:    add r2, lr
; CHECK-THUMB-NEXT:    add r1, lr
; CHECK-THUMB-NEXT:  .LBB19_2: @ %for.cond
; CHECK-THUMB-NEXT:    @ =>This Loop Header: Depth=1
; CHECK-THUMB-NEXT:    @ Child Loop BB19_3 Depth 2
; CHECK-THUMB-NEXT:    movs r4, #0
; CHECK-THUMB-NEXT:  .LBB19_3: @ %for.cond2.preheader
; CHECK-THUMB-NEXT:    @ Parent Loop BB19_2 Depth=1
; CHECK-THUMB-NEXT:    @ => This Inner Loop Header: Depth=2
; CHECK-THUMB-NEXT:    cmp r3, #0
; CHECK-THUMB-NEXT:    str r0, [r2, r4]
; CHECK-THUMB-NEXT:    bne .LBB19_1
; CHECK-THUMB-NEXT:  @ %bb.4: @ %for.cond2.preheader.2
; CHECK-THUMB-NEXT:    @ in Loop: Header=BB19_3 Depth=2
; CHECK-THUMB-NEXT:    str r0, [r1, r4]
; CHECK-THUMB-NEXT:    add r4, r12
; CHECK-THUMB-NEXT:    b .LBB19_3
entry:
  %0 = add i32 %d, -4
  %1 = mul i32 %c, 864846
  %2 = add i32 %1, 1367306604
  br label %for.cond

for.cond:                                         ; preds = %for.cond1.for.cond.cleanup_crit_edge, %for.cond.preheader
  %indvar = phi i32 [ 0, %entry ], [ %indvar.next, %for.cond1.for.cond.cleanup_crit_edge ]
  %3 = mul i32 %indvar, %b
  %4 = add i32 %3, -2
  br label %for.cond2.preheader

for.cond2.preheader:                              ; preds = %for.cond2.preheader.2, %for.cond
  %indvar24 = phi i32 [ 0, %for.cond ], [ %indvar.next25.3, %for.cond2.preheader.2 ]
  %indvar.next25 = or i32 %indvar24, 1
  %l5 = mul i32 %2, %indvar.next25
  %scevgep.1 = getelementptr [15 x [25 x [18 x i8]]], ptr @arr_9, i32 -217196, i32 %4, i32 %0, i32 %l5
  store i32 0, ptr %scevgep.1, align 1
  br i1 %cc, label %for.cond1.for.cond.cleanup_crit_edge, label %for.cond2.preheader.2

for.cond2.preheader.2:                            ; preds = %for.cond2.preheader
  %indvar.next25.1 = or i32 %indvar24, 2
  %l8 = mul i32 %2, %indvar.next25.1
  %scevgep.2 = getelementptr [15 x [25 x [18 x i8]]], ptr @arr_9, i32 -217196, i32 %4, i32 %0, i32 %l8
  store i32 0, ptr %scevgep.2, align 1
  %indvar.next25.3 = add i32 %indvar24, 4
  br label %for.cond2.preheader

for.cond1.for.cond.cleanup_crit_edge:             ; preds = %for.cond2.preheader
  %indvar.next = add i32 %indvar, 1
  br label %for.cond
}
