/* Copyright (C) 2010 Atsushi Togo */
/* All rights reserved. */

/* This file is part of spglib. */

/* Redistribution and use in source and binary forms, with or without */
/* modification, are permitted provided that the following conditions */
/* are met: */

/* * Redistributions of source code must retain the above copyright */
/*   notice, this list of conditions and the following disclaimer. */

/* * Redistributions in binary form must reproduce the above copyright */
/*   notice, this list of conditions and the following disclaimer in */
/*   the documentation and/or other materials provided with the */
/*   distribution. */

/* * Neither the name of the spglib project nor the names of its */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission. */

/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE */
/* COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, */
/* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, */
/* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; */
/* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER */
/* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT */
/* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN */
/* ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE */
/* POSSIBILITY OF SUCH DAMAGE. */

#include "msg_database.h"
#include "mathfunc.h"
#include "spg_database.h"
#include "debug.h"

#include <stdlib.h>

static int get_hall_number_offset(const int uni_number, const int hall_number);

/* { UNI number, Litvin number, BNS number, OG number, Number of maximal space
 * subgroup, type } */
static const MagneticSpacegroupType magnetic_spacegroup_types[] = {
    {0, 0, "", "", 0, 0},                           /* Error */
    {1, 1, "1.1", "1.1.1", 1, 1},                   /*    1 */
    {2, 2, "1.2", "1.2.2", 1, 2},                   /*    2 */
    {3, 3, "1.3", "1.3.3", 1, 4},                   /*    3 */
    {4, 4, "2.4", "2.1.4", 2, 1},                   /*    4 */
    {5, 5, "2.5", "2.2.5", 2, 2},                   /*    5 */
    {6, 6, "2.6", "2.3.6", 2, 3},                   /*    6 */
    {7, 7, "2.7", "2.4.7", 2, 4},                   /*    7 */
    {8, 8, "3.1", "3.1.8", 3, 1},                   /*    8 */
    {9, 9, "3.2", "3.2.9", 3, 2},                   /*    9 */
    {10, 10, "3.3", "3.3.10", 3, 3},                /*   10 */
    {11, 11, "3.4", "3.4.11", 3, 4},                /*   11 */
    {12, 12, "3.5", "3.5.12", 3, 4},                /*   12 */
    {13, 23, "3.6", "5.5.23", 3, 4},                /*   13 */
    {14, 15, "4.7", "4.1.15", 4, 1},                /*   14 */
    {15, 16, "4.8", "4.2.16", 4, 2},                /*   15 */
    {16, 17, "4.9", "4.3.17", 4, 3},                /*   16 */
    {17, 18, "4.10", "4.4.18", 4, 4},               /*   17 */
    {18, 14, "4.11", "3.7.14", 4, 4},               /*   18 */
    {19, 24, "4.12", "5.6.24", 4, 4},               /*   19 */
    {20, 19, "5.13", "5.1.19", 5, 1},               /*   20 */
    {21, 20, "5.14", "5.2.20", 5, 2},               /*   21 */
    {22, 21, "5.15", "5.3.21", 5, 3},               /*   22 */
    {23, 22, "5.16", "5.4.22", 5, 4},               /*   23 */
    {24, 13, "5.17", "3.6.13", 5, 4},               /*   24 */
    {25, 25, "6.18", "6.1.25", 6, 1},               /*   25 */
    {26, 26, "6.19", "6.2.26", 6, 2},               /*   26 */
    {27, 27, "6.20", "6.3.27", 6, 3},               /*   27 */
    {28, 28, "6.21", "6.4.28", 6, 4},               /*   28 */
    {29, 29, "6.22", "6.5.29", 6, 4},               /*   29 */
    {30, 42, "6.23", "8.5.42", 6, 4},               /*   30 */
    {31, 32, "7.24", "7.1.32", 7, 1},               /*   31 */
    {32, 33, "7.25", "7.2.33", 7, 2},               /*   32 */
    {33, 34, "7.26", "7.3.34", 7, 3},               /*   33 */
    {34, 35, "7.27", "7.4.35", 7, 4},               /*   34 */
    {35, 31, "7.28", "6.7.31", 7, 4},               /*   35 */
    {36, 36, "7.29", "7.5.36", 7, 4},               /*   36 */
    {37, 48, "7.30", "9.4.48", 7, 4},               /*   37 */
    {38, 44, "7.31", "8.7.44", 7, 4},               /*   38 */
    {39, 38, "8.32", "8.1.38", 8, 1},               /*   39 */
    {40, 39, "8.33", "8.2.39", 8, 2},               /*   40 */
    {41, 40, "8.34", "8.3.40", 8, 3},               /*   41 */
    {42, 41, "8.35", "8.4.41", 8, 4},               /*   42 */
    {43, 30, "8.36", "6.6.30", 8, 4},               /*   43 */
    {44, 45, "9.37", "9.1.45", 9, 1},               /*   44 */
    {45, 46, "9.38", "9.2.46", 9, 2},               /*   45 */
    {46, 47, "9.39", "9.3.47", 9, 3},               /*   46 */
    {47, 43, "9.40", "8.6.43", 9, 4},               /*   47 */
    {48, 37, "9.41", "7.6.37", 9, 4},               /*   48 */
    {49, 49, "10.42", "10.1.49", 10, 1},            /*   49 */
    {50, 50, "10.43", "10.2.50", 10, 2},            /*   50 */
    {51, 51, "10.44", "10.3.51", 10, 3},            /*   51 */
    {52, 52, "10.45", "10.4.52", 10, 3},            /*   52 */
    {53, 53, "10.46", "10.5.53", 10, 3},            /*   53 */
    {54, 54, "10.47", "10.6.54", 10, 4},            /*   54 */
    {55, 55, "10.48", "10.7.55", 10, 4},            /*   55 */
    {56, 72, "10.49", "12.7.72", 10, 4},            /*   56 */
    {57, 59, "11.50", "11.1.59", 11, 1},            /*   57 */
    {58, 60, "11.51", "11.2.60", 11, 2},            /*   58 */
    {59, 61, "11.52", "11.3.61", 11, 3},            /*   59 */
    {60, 62, "11.53", "11.4.62", 11, 3},            /*   60 */
    {61, 63, "11.54", "11.5.63", 11, 3},            /*   61 */
    {62, 64, "11.55", "11.6.64", 11, 4},            /*   62 */
    {63, 57, "11.56", "10.9.57", 11, 4},            /*   63 */
    {64, 74, "11.57", "12.9.74", 11, 4},            /*   64 */
    {65, 66, "12.58", "12.1.66", 12, 1},            /*   65 */
    {66, 67, "12.59", "12.2.67", 12, 2},            /*   66 */
    {67, 68, "12.60", "12.3.68", 12, 3},            /*   67 */
    {68, 69, "12.61", "12.4.69", 12, 3},            /*   68 */
    {69, 70, "12.62", "12.5.70", 12, 3},            /*   69 */
    {70, 71, "12.63", "12.6.71", 12, 4},            /*   70 */
    {71, 56, "12.64", "10.8.56", 12, 4},            /*   71 */
    {72, 77, "13.65", "13.1.77", 13, 1},            /*   72 */
    {73, 78, "13.66", "13.2.78", 13, 2},            /*   73 */
    {74, 79, "13.67", "13.3.79", 13, 3},            /*   74 */
    {75, 80, "13.68", "13.4.80", 13, 3},            /*   75 */
    {76, 81, "13.69", "13.5.81", 13, 3},            /*   76 */
    {77, 82, "13.70", "13.6.82", 13, 4},            /*   77 */
    {78, 83, "13.71", "13.7.83", 13, 4},            /*   78 */
    {79, 58, "13.72", "10.10.58", 13, 4},           /*   79 */
    {80, 75, "13.73", "12.10.75", 13, 4},           /*   80 */
    {81, 97, "13.74", "15.6.97", 13, 4},            /*   81 */
    {82, 86, "14.75", "14.1.86", 14, 1},            /*   82 */
    {83, 87, "14.76", "14.2.87", 14, 2},            /*   83 */
    {84, 88, "14.77", "14.3.88", 14, 3},            /*   84 */
    {85, 89, "14.78", "14.4.89", 14, 3},            /*   85 */
    {86, 90, "14.79", "14.5.90", 14, 3},            /*   86 */
    {87, 91, "14.80", "14.6.91", 14, 4},            /*   87 */
    {88, 85, "14.81", "13.9.85", 14, 4},            /*   88 */
    {89, 65, "14.82", "11.7.65", 14, 4},            /*   89 */
    {90, 76, "14.83", "12.11.76", 14, 4},           /*   90 */
    {91, 98, "14.84", "15.7.98", 14, 4},            /*   91 */
    {92, 92, "15.85", "15.1.92", 15, 1},            /*   92 */
    {93, 93, "15.86", "15.2.93", 15, 2},            /*   93 */
    {94, 94, "15.87", "15.3.94", 15, 3},            /*   94 */
    {95, 95, "15.88", "15.4.95", 15, 3},            /*   95 */
    {96, 96, "15.89", "15.5.96", 15, 3},            /*   96 */
    {97, 73, "15.90", "12.8.73", 15, 4},            /*   97 */
    {98, 84, "15.91", "13.8.84", 15, 4},            /*   98 */
    {99, 99, "16.1", "16.1.99", 16, 1},             /*   99 */
    {100, 100, "16.2", "16.2.100", 16, 2},          /*  100 */
    {101, 101, "16.3", "16.3.101", 16, 3},          /*  101 */
    {102, 102, "16.4", "16.4.102", 16, 4},          /*  102 */
    {103, 134, "16.5", "21.6.134", 16, 4},          /*  103 */
    {104, 148, "16.6", "23.4.148", 16, 4},          /*  104 */
    {105, 106, "17.7", "17.1.106", 17, 1},          /*  105 */
    {106, 107, "17.8", "17.2.107", 17, 2},          /*  106 */
    {107, 108, "17.9", "17.3.108", 17, 3},          /*  107 */
    {108, 109, "17.10", "17.4.109", 17, 3},         /*  108 */
    {109, 110, "17.11", "17.5.110", 17, 4},         /*  109 */
    {110, 105, "17.12", "16.7.105", 17, 4},         /*  110 */
    {111, 138, "17.13", "21.10.138", 17, 4},        /*  111 */
    {112, 126, "17.14", "20.5.126", 17, 4},         /*  112 */
    {113, 154, "17.15", "24.5.154", 17, 4},         /*  113 */
    {114, 113, "18.16", "18.1.113", 18, 1},         /*  114 */
    {115, 114, "18.17", "18.2.114", 18, 2},         /*  115 */
    {116, 115, "18.18", "18.3.115", 18, 3},         /*  116 */
    {117, 116, "18.19", "18.4.116", 18, 3},         /*  117 */
    {118, 112, "18.20", "17.7.112", 18, 4},         /*  118 */
    {119, 117, "18.21", "18.5.117", 18, 4},         /*  119 */
    {120, 128, "18.22", "20.7.128", 18, 4},         /*  120 */
    {121, 137, "18.23", "21.9.137", 18, 4},         /*  121 */
    {122, 149, "18.24", "23.5.149", 18, 4},         /*  122 */
    {123, 119, "19.25", "19.1.119", 19, 1},         /*  123 */
    {124, 120, "19.26", "19.2.120", 19, 2},         /*  124 */
    {125, 121, "19.27", "19.3.121", 19, 3},         /*  125 */
    {126, 118, "19.28", "18.6.118", 19, 4},         /*  126 */
    {127, 127, "19.29", "20.6.127", 19, 4},         /*  127 */
    {128, 153, "19.30", "24.4.153", 19, 4},         /*  128 */
    {129, 122, "20.31", "20.1.122", 20, 1},         /*  129 */
    {130, 123, "20.32", "20.2.123", 20, 2},         /*  130 */
    {131, 124, "20.33", "20.3.124", 20, 3},         /*  131 */
    {132, 125, "20.34", "20.4.125", 20, 3},         /*  132 */
    {133, 136, "20.35", "21.8.136", 20, 4},         /*  133 */
    {134, 111, "20.36", "17.6.111", 20, 4},         /*  134 */
    {135, 144, "20.37", "22.5.144", 20, 4},         /*  135 */
    {136, 129, "21.38", "21.1.129", 21, 1},         /*  136 */
    {137, 130, "21.39", "21.2.130", 21, 2},         /*  137 */
    {138, 131, "21.40", "21.3.131", 21, 3},         /*  138 */
    {139, 132, "21.41", "21.4.132", 21, 3},         /*  139 */
    {140, 133, "21.42", "21.5.133", 21, 4},         /*  140 */
    {141, 103, "21.43", "16.5.103", 21, 4},         /*  141 */
    {142, 143, "21.44", "22.4.143", 21, 4},         /*  142 */
    {143, 140, "22.45", "22.1.140", 22, 1},         /*  143 */
    {144, 141, "22.46", "22.2.141", 22, 2},         /*  144 */
    {145, 142, "22.47", "22.3.142", 22, 3},         /*  145 */
    {146, 104, "22.48", "16.6.104", 22, 4},         /*  146 */
    {147, 145, "23.49", "23.1.145", 23, 1},         /*  147 */
    {148, 146, "23.50", "23.2.146", 23, 2},         /*  148 */
    {149, 147, "23.51", "23.3.147", 23, 3},         /*  149 */
    {150, 135, "23.52", "21.7.135", 23, 4},         /*  150 */
    {151, 150, "24.53", "24.1.150", 24, 1},         /*  151 */
    {152, 151, "24.54", "24.2.151", 24, 2},         /*  152 */
    {153, 152, "24.55", "24.3.152", 24, 3},         /*  153 */
    {154, 139, "24.56", "21.11.139", 24, 4},        /*  154 */
    {155, 155, "25.57", "25.1.155", 25, 1},         /*  155 */
    {156, 156, "25.58", "25.2.156", 25, 2},         /*  156 */
    {157, 157, "25.59", "25.3.157", 25, 3},         /*  157 */
    {158, 158, "25.60", "25.4.158", 25, 3},         /*  158 */
    {159, 159, "25.61", "25.5.159", 25, 4},         /*  159 */
    {160, 160, "25.62", "25.6.160", 25, 4},         /*  160 */
    {161, 241, "25.63", "35.6.241", 25, 4},         /*  161 */
    {162, 271, "25.64", "38.7.271", 25, 4},         /*  162 */
    {163, 328, "25.65", "44.5.328", 25, 4},         /*  163 */
    {164, 168, "26.66", "26.1.168", 26, 1},         /*  164 */
    {165, 169, "26.67", "26.2.169", 26, 2},         /*  165 */
    {166, 170, "26.68", "26.3.170", 26, 3},         /*  166 */
    {167, 171, "26.69", "26.4.171", 26, 3},         /*  167 */
    {168, 172, "26.70", "26.5.172", 26, 3},         /*  168 */
    {169, 173, "26.71", "26.6.173", 26, 4},         /*  169 */
    {170, 174, "26.72", "26.7.174", 26, 4},         /*  170 */
    {171, 164, "26.73", "25.10.164", 26, 4},        /*  171 */
    {172, 275, "26.74", "38.11.275", 26, 4},        /*  172 */
    {173, 287, "26.75", "39.10.287", 26, 4},        /*  173 */
    {174, 254, "26.76", "36.6.254", 26, 4},         /*  174 */
    {175, 345, "26.77", "46.8.345", 26, 4},         /*  175 */
    {176, 178, "27.78", "27.1.178", 27, 1},         /*  176 */
    {177, 179, "27.79", "27.2.179", 27, 2},         /*  177 */
    {178, 180, "27.80", "27.3.180", 27, 3},         /*  178 */
    {179, 181, "27.81", "27.4.181", 27, 3},         /*  179 */
    {180, 165, "27.82", "25.11.165", 27, 4},        /*  180 */
    {181, 182, "27.83", "27.5.182", 27, 4},         /*  181 */
    {182, 262, "27.84", "37.5.262", 27, 4},         /*  182 */
    {183, 289, "27.85", "39.12.289", 27, 4},        /*  183 */
    {184, 335, "27.86", "45.5.335", 27, 4},         /*  184 */
    {185, 185, "28.87", "28.1.185", 28, 1},         /*  185 */
    {186, 186, "28.88", "28.2.186", 28, 2},         /*  186 */
    {187, 187, "28.89", "28.3.187", 28, 3},         /*  187 */
    {188, 188, "28.90", "28.4.188", 28, 3},         /*  188 */
    {189, 189, "28.91", "28.5.189", 28, 3},         /*  189 */
    {190, 166, "28.92", "25.12.166", 28, 4},        /*  190 */
    {191, 190, "28.93", "28.6.190", 28, 4},         /*  191 */
    {192, 191, "28.94", "28.7.191", 28, 4},         /*  192 */
    {193, 296, "28.95", "40.6.296", 28, 4},         /*  193 */
    {194, 284, "28.96", "39.7.284", 28, 4},         /*  194 */
    {195, 245, "28.97", "35.10.245", 28, 4},        /*  195 */
    {196, 343, "28.98", "46.6.343", 28, 4},         /*  196 */
    {197, 198, "29.99", "29.1.198", 29, 1},         /*  197 */
    {198, 199, "29.100", "29.2.199", 29, 2},        /*  198 */
    {199, 200, "29.101", "29.3.200", 29, 3},        /*  199 */
    {200, 201, "29.102", "29.4.201", 29, 3},        /*  200 */
    {201, 202, "29.103", "29.5.202", 29, 3},        /*  201 */
    {202, 177, "29.104", "26.10.177", 29, 4},       /*  202 */
    {203, 203, "29.105", "29.6.203", 29, 4},        /*  203 */
    {204, 194, "29.106", "28.10.194", 29, 4},       /*  204 */
    {205, 306, "29.107", "41.7.306", 29, 4},        /*  205 */
    {206, 288, "29.108", "39.11.288", 29, 4},       /*  206 */
    {207, 255, "29.109", "36.7.255", 29, 4},        /*  207 */
    {208, 336, "29.110", "45.6.336", 29, 4},        /*  208 */
    {209, 205, "30.111", "30.1.205", 30, 1},        /*  209 */
    {210, 206, "30.112", "30.2.206", 30, 2},        /*  210 */
    {211, 207, "30.113", "30.3.207", 30, 3},        /*  211 */
    {212, 208, "30.114", "30.4.208", 30, 3},        /*  212 */
    {213, 209, "30.115", "30.5.209", 30, 3},        /*  213 */
    {214, 210, "30.116", "30.6.210", 30, 4},        /*  214 */
    {215, 184, "30.117", "27.7.184", 30, 4},        /*  215 */
    {216, 196, "30.118", "28.12.196", 30, 4},       /*  216 */
    {217, 276, "30.119", "38.12.276", 30, 4},       /*  217 */
    {218, 308, "30.120", "41.9.308", 30, 4},        /*  218 */
    {219, 263, "30.121", "37.6.263", 30, 4},        /*  219 */
    {220, 346, "30.122", "46.9.346", 30, 4},        /*  220 */
    {221, 212, "31.123", "31.1.212", 31, 1},        /*  221 */
    {222, 213, "31.124", "31.2.213", 31, 2},        /*  222 */
    {223, 214, "31.125", "31.3.214", 31, 3},        /*  223 */
    {224, 215, "31.126", "31.4.215", 31, 3},        /*  224 */
    {225, 216, "31.127", "31.5.216", 31, 3},        /*  225 */
    {226, 176, "31.128", "26.9.176", 31, 4},        /*  226 */
    {227, 217, "31.129", "31.6.217", 31, 4},        /*  227 */
    {228, 195, "31.130", "28.11.195", 31, 4},       /*  228 */
    {229, 298, "31.131", "40.8.298", 31, 4},        /*  229 */
    {230, 274, "31.132", "38.10.274", 31, 4},       /*  230 */
    {231, 256, "31.133", "36.8.256", 31, 4},        /*  231 */
    {232, 329, "31.134", "44.6.329", 31, 4},        /*  232 */
    {233, 219, "32.135", "32.1.219", 32, 1},        /*  233 */
    {234, 220, "32.136", "32.2.220", 32, 2},        /*  234 */
    {235, 221, "32.137", "32.3.221", 32, 3},        /*  235 */
    {236, 222, "32.138", "32.4.222", 32, 3},        /*  236 */
    {237, 223, "32.139", "32.5.223", 32, 4},        /*  237 */
    {238, 193, "32.140", "28.9.193", 32, 4},        /*  238 */
    {239, 246, "32.141", "35.11.246", 32, 4},       /*  239 */
    {240, 305, "32.142", "41.6.305", 32, 4},        /*  240 */
    {241, 337, "32.143", "45.7.337", 32, 4},        /*  241 */
    {242, 226, "33.144", "33.1.226", 33, 1},        /*  242 */
    {243, 227, "33.145", "33.2.227", 33, 2},        /*  243 */
    {244, 228, "33.146", "33.3.228", 33, 3},        /*  244 */
    {245, 229, "33.147", "33.4.229", 33, 3},        /*  245 */
    {246, 230, "33.148", "33.5.230", 33, 3},        /*  246 */
    {247, 218, "33.149", "31.7.218", 33, 4},        /*  247 */
    {248, 204, "33.150", "29.7.204", 33, 4},        /*  248 */
    {249, 224, "33.151", "32.6.224", 33, 4},        /*  249 */
    {250, 297, "33.152", "40.7.297", 33, 4},        /*  250 */
    {251, 307, "33.153", "41.8.307", 33, 4},        /*  251 */
    {252, 257, "33.154", "36.9.257", 33, 4},        /*  252 */
    {253, 344, "33.155", "46.7.344", 33, 4},        /*  253 */
    {254, 231, "34.156", "34.1.231", 34, 1},        /*  254 */
    {255, 232, "34.157", "34.2.232", 34, 2},        /*  255 */
    {256, 233, "34.158", "34.3.233", 34, 3},        /*  256 */
    {257, 234, "34.159", "34.4.234", 34, 3},        /*  257 */
    {258, 211, "34.160", "30.7.211", 34, 4},        /*  258 */
    {259, 225, "34.161", "32.7.225", 34, 4},        /*  259 */
    {260, 299, "34.162", "40.9.299", 34, 4},        /*  260 */
    {261, 264, "34.163", "37.7.264", 34, 4},        /*  261 */
    {262, 330, "34.164", "44.7.330", 34, 4},        /*  262 */
    {263, 236, "35.165", "35.1.236", 35, 1},        /*  263 */
    {264, 237, "35.166", "35.2.237", 35, 2},        /*  264 */
    {265, 238, "35.167", "35.3.238", 35, 3},        /*  265 */
    {266, 239, "35.168", "35.4.239", 35, 3},        /*  266 */
    {267, 240, "35.169", "35.5.240", 35, 4},        /*  267 */
    {268, 161, "35.170", "25.7.161", 35, 4},        /*  268 */
    {269, 313, "35.171", "42.5.313", 35, 4},        /*  269 */
    {270, 249, "36.172", "36.1.249", 36, 1},        /*  270 */
    {271, 250, "36.173", "36.2.250", 36, 2},        /*  271 */
    {272, 251, "36.174", "36.3.251", 36, 3},        /*  272 */
    {273, 252, "36.175", "36.4.252", 36, 3},        /*  273 */
    {274, 253, "36.176", "36.5.253", 36, 3},        /*  274 */
    {275, 243, "36.177", "35.8.243", 36, 4},        /*  275 */
    {276, 175, "36.178", "26.8.175", 36, 4},        /*  276 */
    {277, 315, "36.179", "42.7.315", 36, 4},        /*  277 */
    {278, 258, "37.180", "37.1.258", 37, 1},        /*  278 */
    {279, 259, "37.181", "37.2.259", 37, 2},        /*  279 */
    {280, 260, "37.182", "37.3.260", 37, 3},        /*  280 */
    {281, 261, "37.183", "37.4.261", 37, 3},        /*  281 */
    {282, 244, "37.184", "35.9.244", 37, 4},        /*  282 */
    {283, 183, "37.185", "27.6.183", 37, 4},        /*  283 */
    {284, 316, "37.186", "42.8.316", 37, 4},        /*  284 */
    {285, 265, "38.187", "38.1.265", 38, 1},        /*  285 */
    {286, 266, "38.188", "38.2.266", 38, 2},        /*  286 */
    {287, 267, "38.189", "38.3.267", 38, 3},        /*  287 */
    {288, 268, "38.190", "38.4.268", 38, 3},        /*  288 */
    {289, 269, "38.191", "38.5.269", 38, 3},        /*  289 */
    {290, 270, "38.192", "38.6.270", 38, 4},        /*  290 */
    {291, 162, "38.193", "25.8.162", 38, 4},        /*  291 */
    {292, 314, "38.194", "42.6.314", 38, 4},        /*  292 */
    {293, 278, "39.195", "39.1.278", 39, 1},        /*  293 */
    {294, 279, "39.196", "39.2.279", 39, 2},        /*  294 */
    {295, 280, "39.197", "39.3.280", 39, 3},        /*  295 */
    {296, 281, "39.198", "39.4.281", 39, 3},        /*  296 */
    {297, 282, "39.199", "39.5.282", 39, 3},        /*  297 */
    {298, 283, "39.200", "39.6.283", 39, 4},        /*  298 */
    {299, 167, "39.201", "25.13.167", 39, 4},       /*  299 */
    {300, 317, "39.202", "42.9.317", 39, 4},        /*  300 */
    {301, 291, "40.203", "40.1.291", 40, 1},        /*  301 */
    {302, 292, "40.204", "40.2.292", 40, 2},        /*  302 */
    {303, 293, "40.205", "40.3.293", 40, 3},        /*  303 */
    {304, 294, "40.206", "40.4.294", 40, 3},        /*  304 */
    {305, 295, "40.207", "40.5.295", 40, 3},        /*  305 */
    {306, 273, "40.208", "38.9.273", 40, 4},        /*  306 */
    {307, 192, "40.209", "28.8.192", 40, 4},        /*  307 */
    {308, 318, "40.210", "42.10.318", 40, 4},       /*  308 */
    {309, 300, "41.211", "41.1.300", 41, 1},        /*  309 */
    {310, 301, "41.212", "41.2.301", 41, 2},        /*  310 */
    {311, 302, "41.213", "41.3.302", 41, 3},        /*  311 */
    {312, 303, "41.214", "41.4.303", 41, 3},        /*  312 */
    {313, 304, "41.215", "41.5.304", 41, 3},        /*  313 */
    {314, 286, "41.216", "39.9.286", 41, 4},        /*  314 */
    {315, 197, "41.217", "28.13.197", 41, 4},       /*  315 */
    {316, 319, "41.218", "42.11.319", 41, 4},       /*  316 */
    {317, 309, "42.219", "42.1.309", 42, 1},        /*  317 */
    {318, 310, "42.220", "42.2.310", 42, 2},        /*  318 */
    {319, 311, "42.221", "42.3.311", 42, 3},        /*  319 */
    {320, 312, "42.222", "42.4.312", 42, 3},        /*  320 */
    {321, 163, "42.223", "25.9.163", 42, 4},        /*  321 */
    {322, 320, "43.224", "43.1.320", 43, 1},        /*  322 */
    {323, 321, "43.225", "43.2.321", 43, 2},        /*  323 */
    {324, 322, "43.226", "43.3.322", 43, 3},        /*  324 */
    {325, 323, "43.227", "43.4.323", 43, 3},        /*  325 */
    {326, 235, "43.228", "34.5.235", 43, 4},        /*  326 */
    {327, 324, "44.229", "44.1.324", 44, 1},        /*  327 */
    {328, 325, "44.230", "44.2.325", 44, 2},        /*  328 */
    {329, 326, "44.231", "44.3.326", 44, 3},        /*  329 */
    {330, 327, "44.232", "44.4.327", 44, 3},        /*  330 */
    {331, 242, "44.233", "35.7.242", 44, 4},        /*  331 */
    {332, 272, "44.234", "38.8.272", 44, 4},        /*  332 */
    {333, 331, "45.235", "45.1.331", 45, 1},        /*  333 */
    {334, 332, "45.236", "45.2.332", 45, 2},        /*  334 */
    {335, 333, "45.237", "45.3.333", 45, 3},        /*  335 */
    {336, 334, "45.238", "45.4.334", 45, 3},        /*  336 */
    {337, 248, "45.239", "35.13.248", 45, 4},       /*  337 */
    {338, 290, "45.240", "39.13.290", 45, 4},       /*  338 */
    {339, 338, "46.241", "46.1.338", 46, 1},        /*  339 */
    {340, 339, "46.242", "46.2.339", 46, 2},        /*  340 */
    {341, 340, "46.243", "46.3.340", 46, 3},        /*  341 */
    {342, 341, "46.244", "46.4.341", 46, 3},        /*  342 */
    {343, 342, "46.245", "46.5.342", 46, 3},        /*  343 */
    {344, 247, "46.246", "35.12.247", 46, 4},       /*  344 */
    {345, 277, "46.247", "38.13.277", 46, 4},       /*  345 */
    {346, 285, "46.248", "39.8.285", 46, 4},        /*  346 */
    {347, 347, "47.249", "47.1.347", 47, 1},        /*  347 */
    {348, 348, "47.250", "47.2.348", 47, 2},        /*  348 */
    {349, 349, "47.251", "47.3.349", 47, 3},        /*  349 */
    {350, 350, "47.252", "47.4.350", 47, 3},        /*  350 */
    {351, 351, "47.253", "47.5.351", 47, 3},        /*  351 */
    {352, 352, "47.254", "47.6.352", 47, 4},        /*  352 */
    {353, 553, "47.255", "65.9.553", 47, 4},        /*  353 */
    {354, 626, "47.256", "71.6.626", 47, 4},        /*  354 */
    {355, 358, "48.257", "48.1.358", 48, 1},        /*  355 */
    {356, 359, "48.258", "48.2.359", 48, 2},        /*  356 */
    {357, 360, "48.259", "48.3.360", 48, 3},        /*  357 */
    {358, 361, "48.260", "48.4.361", 48, 3},        /*  358 */
    {359, 362, "48.261", "48.5.362", 48, 3},        /*  359 */
    {360, 386, "48.262", "50.10.386", 48, 4},       /*  360 */
    {361, 576, "48.263", "66.13.576", 48, 4},       /*  361 */
    {362, 629, "48.264", "71.9.629", 48, 4},        /*  362 */
    {363, 364, "49.265", "49.1.364", 49, 1},        /*  363 */
    {364, 365, "49.266", "49.2.365", 49, 2},        /*  364 */
    {365, 366, "49.267", "49.3.366", 49, 3},        /*  365 */
    {366, 367, "49.268", "49.4.367", 49, 3},        /*  366 */
    {367, 368, "49.269", "49.5.368", 49, 3},        /*  367 */
    {368, 369, "49.270", "49.6.369", 49, 3},        /*  368 */
    {369, 370, "49.271", "49.7.370", 49, 3},        /*  369 */
    {370, 371, "49.272", "49.8.371", 49, 4},        /*  370 */
    {371, 356, "49.273", "47.10.356", 49, 4},       /*  371 */
    {372, 585, "49.274", "67.9.585", 49, 4},        /*  372 */
    {373, 571, "49.275", "66.8.571", 49, 4},        /*  373 */
    {374, 637, "49.276", "72.8.637", 49, 4},        /*  374 */
    {375, 377, "50.277", "50.1.377", 50, 1},        /*  375 */
    {376, 378, "50.278", "50.2.378", 50, 2},        /*  376 */
    {377, 379, "50.279", "50.3.379", 50, 3},        /*  377 */
    {378, 380, "50.280", "50.4.380", 50, 3},        /*  378 */
    {379, 381, "50.281", "50.5.381", 50, 3},        /*  379 */
    {380, 382, "50.282", "50.6.382", 50, 3},        /*  380 */
    {381, 383, "50.283", "50.7.383", 50, 3},        /*  381 */
    {382, 375, "50.284", "49.12.375", 50, 4},       /*  382 */
    {383, 384, "50.285", "50.8.384", 50, 4},        /*  383 */
    {384, 601, "50.286", "68.8.601", 50, 4},        /*  384 */
    {385, 561, "50.287", "65.17.561", 50, 4},       /*  385 */
    {386, 642, "50.288", "72.13.642", 50, 4},       /*  386 */
    {387, 387, "51.289", "51.1.387", 51, 1},        /*  387 */
    {388, 388, "51.290", "51.2.388", 51, 2},        /*  388 */
    {389, 389, "51.291", "51.3.389", 51, 3},        /*  389 */
    {390, 390, "51.292", "51.4.390", 51, 3},        /*  390 */
    {391, 391, "51.293", "51.5.391", 51, 3},        /*  391 */
    {392, 392, "51.294", "51.6.392", 51, 3},        /*  392 */
    {393, 393, "51.295", "51.7.393", 51, 3},        /*  393 */
    {394, 394, "51.296", "51.8.394", 51, 3},        /*  394 */
    {395, 395, "51.297", "51.9.395", 51, 3},        /*  395 */
    {396, 355, "51.298", "47.9.355", 51, 4},        /*  396 */
    {397, 396, "51.299", "51.10.396", 51, 4},       /*  397 */
    {398, 397, "51.300", "51.11.397", 51, 4},       /*  398 */
    {399, 520, "51.301", "63.10.520", 51, 4},       /*  399 */
    {400, 557, "51.302", "65.13.557", 51, 4},       /*  400 */
    {401, 590, "51.303", "67.14.590", 51, 4},       /*  401 */
    {402, 657, "51.304", "74.8.657", 51, 4},        /*  402 */
    {403, 406, "52.305", "52.1.406", 52, 1},        /*  403 */
    {404, 407, "52.306", "52.2.407", 52, 2},        /*  404 */
    {405, 408, "52.307", "52.3.408", 52, 3},        /*  405 */
    {406, 409, "52.308", "52.4.409", 52, 3},        /*  406 */
    {407, 410, "52.309", "52.5.410", 52, 3},        /*  407 */
    {408, 411, "52.310", "52.6.411", 52, 3},        /*  408 */
    {409, 412, "52.311", "52.7.412", 52, 3},        /*  409 */
    {410, 413, "52.312", "52.8.413", 52, 3},        /*  410 */
    {411, 414, "52.313", "52.9.414", 52, 3},        /*  411 */
    {412, 427, "52.314", "53.13.427", 52, 4},       /*  412 */
    {413, 385, "52.315", "50.9.385", 52, 4},        /*  413 */
    {414, 440, "52.316", "54.13.440", 52, 4},       /*  414 */
    {415, 575, "52.317", "66.12.575", 52, 4},       /*  415 */
    {416, 527, "52.318", "63.17.527", 52, 4},       /*  416 */
    {417, 604, "52.319", "68.11.604", 52, 4},       /*  417 */
    {418, 658, "52.320", "74.9.658", 52, 4},        /*  418 */
    {419, 415, "53.321", "53.1.415", 53, 1},        /*  419 */
    {420, 416, "53.322", "53.2.416", 53, 2},        /*  420 */
    {421, 417, "53.323", "53.3.417", 53, 3},        /*  421 */
    {422, 418, "53.324", "53.4.418", 53, 3},        /*  422 */
    {423, 419, "53.325", "53.5.419", 53, 3},        /*  423 */
    {424, 420, "53.326", "53.6.420", 53, 3},        /*  424 */
    {425, 421, "53.327", "53.7.421", 53, 3},        /*  425 */
    {426, 422, "53.328", "53.8.422", 53, 3},        /*  426 */
    {427, 423, "53.329", "53.9.423", 53, 3},        /*  427 */
    {428, 401, "53.330", "51.15.401", 53, 4},       /*  428 */
    {429, 424, "53.331", "53.10.424", 53, 4},       /*  429 */
    {430, 374, "53.332", "49.11.374", 53, 4},       /*  430 */
    {431, 572, "53.333", "66.9.572", 53, 4},        /*  431 */
    {432, 560, "53.334", "65.16.560", 53, 4},       /*  432 */
    {433, 542, "53.335", "64.15.542", 53, 4},       /*  433 */
    {434, 659, "53.336", "74.10.659", 53, 4},       /*  434 */
    {435, 428, "54.337", "54.1.428", 54, 1},        /*  435 */
    {436, 429, "54.338", "54.2.429", 54, 2},        /*  436 */
    {437, 430, "54.339", "54.3.430", 54, 3},        /*  437 */
    {438, 431, "54.340", "54.4.431", 54, 3},        /*  438 */
    {439, 432, "54.341", "54.5.432", 54, 3},        /*  439 */
    {440, 433, "54.342", "54.6.433", 54, 3},        /*  440 */
    {441, 434, "54.343", "54.7.434", 54, 3},        /*  441 */
    {442, 435, "54.344", "54.8.435", 54, 3},        /*  442 */
    {443, 436, "54.345", "54.9.436", 54, 3},        /*  443 */
    {444, 373, "54.346", "49.10.373", 54, 4},       /*  444 */
    {445, 437, "54.347", "54.10.437", 54, 4},       /*  445 */
    {446, 404, "54.348", "51.18.404", 54, 4},       /*  446 */
    {447, 538, "54.349", "64.11.538", 54, 4},       /*  447 */
    {448, 589, "54.350", "67.13.589", 54, 4},       /*  448 */
    {449, 602, "54.351", "68.9.602", 54, 4},        /*  449 */
    {450, 649, "54.352", "73.7.649", 54, 4},        /*  450 */
    {451, 441, "55.353", "55.1.441", 55, 1},        /*  451 */
    {452, 442, "55.354", "55.2.442", 55, 2},        /*  452 */
    {453, 443, "55.355", "55.3.443", 55, 3},        /*  453 */
    {454, 444, "55.356", "55.4.444", 55, 3},        /*  454 */
    {455, 445, "55.357", "55.5.445", 55, 3},        /*  455 */
    {456, 446, "55.358", "55.6.446", 55, 3},        /*  456 */
    {457, 447, "55.359", "55.7.447", 55, 3},        /*  457 */
    {458, 402, "55.360", "51.16.402", 55, 4},       /*  458 */
    {459, 448, "55.361", "55.8.448", 55, 4},        /*  459 */
    {460, 537, "55.362", "64.10.537", 55, 4},       /*  460 */
    {461, 559, "55.363", "65.15.559", 55, 4},       /*  461 */
    {462, 640, "55.364", "72.11.640", 55, 4},       /*  462 */
    {463, 451, "56.365", "56.1.451", 56, 1},        /*  463 */
    {464, 452, "56.366", "56.2.452", 56, 2},        /*  464 */
    {465, 453, "56.367", "56.3.453", 56, 3},        /*  465 */
    {466, 454, "56.368", "56.4.454", 56, 3},        /*  466 */
    {467, 455, "56.369", "56.5.455", 56, 3},        /*  467 */
    {468, 456, "56.370", "56.6.456", 56, 3},        /*  468 */
    {469, 457, "56.371", "56.7.457", 56, 3},        /*  469 */
    {470, 439, "56.372", "54.12.439", 56, 4},       /*  470 */
    {471, 487, "56.373", "59.10.487", 56, 4},       /*  471 */
    {472, 541, "56.374", "64.14.541", 56, 4},       /*  472 */
    {473, 573, "56.375", "66.10.573", 56, 4},       /*  473 */
    {474, 639, "56.376", "72.10.639", 56, 4},       /*  474 */
    {475, 458, "57.377", "57.1.458", 57, 1},        /*  475 */
    {476, 459, "57.378", "57.2.459", 57, 2},        /*  476 */
    {477, 460, "57.379", "57.3.460", 57, 3},        /*  477 */
    {478, 461, "57.380", "57.4.461", 57, 3},        /*  478 */
    {479, 462, "57.381", "57.5.462", 57, 3},        /*  479 */
    {480, 463, "57.382", "57.6.463", 57, 3},        /*  480 */
    {481, 464, "57.383", "57.7.464", 57, 3},        /*  481 */
    {482, 465, "57.384", "57.8.465", 57, 3},        /*  482 */
    {483, 466, "57.385", "57.9.466", 57, 3},        /*  483 */
    {484, 467, "57.386", "57.10.467", 57, 4},       /*  484 */
    {485, 403, "57.387", "51.17.403", 57, 4},       /*  485 */
    {486, 399, "57.388", "51.13.399", 57, 4},       /*  486 */
    {487, 591, "57.389", "67.15.591", 57, 4},       /*  487 */
    {488, 540, "57.390", "64.13.540", 57, 4},       /*  488 */
    {489, 521, "57.391", "63.11.521", 57, 4},       /*  489 */
    {490, 638, "57.392", "72.9.638", 57, 4},        /*  490 */
    {491, 471, "58.393", "58.1.471", 58, 1},        /*  491 */
    {492, 472, "58.394", "58.2.472", 58, 2},        /*  492 */
    {493, 473, "58.395", "58.3.473", 58, 3},        /*  493 */
    {494, 474, "58.396", "58.4.474", 58, 3},        /*  494 */
    {495, 475, "58.397", "58.5.475", 58, 3},        /*  495 */
    {496, 476, "58.398", "58.6.476", 58, 3},        /*  496 */
    {497, 477, "58.399", "58.7.477", 58, 3},        /*  497 */
    {498, 426, "58.400", "53.12.426", 58, 4},       /*  498 */
    {499, 450, "58.401", "55.10.450", 58, 4},       /*  499 */
    {500, 525, "58.402", "63.15.525", 58, 4},       /*  500 */
    {501, 574, "58.403", "66.11.574", 58, 4},       /*  501 */
    {502, 628, "58.404", "71.8.628", 58, 4},        /*  502 */
    {503, 478, "59.405", "59.1.478", 59, 1},        /*  503 */
    {504, 479, "59.406", "59.2.479", 59, 2},        /*  504 */
    {505, 480, "59.407", "59.3.480", 59, 3},        /*  505 */
    {506, 481, "59.408", "59.4.481", 59, 3},        /*  506 */
    {507, 482, "59.409", "59.5.482", 59, 3},        /*  507 */
    {508, 483, "59.410", "59.6.483", 59, 3},        /*  508 */
    {509, 484, "59.411", "59.7.484", 59, 3},        /*  509 */
    {510, 400, "59.412", "51.14.400", 59, 4},       /*  510 */
    {511, 485, "59.413", "59.8.485", 59, 4},        /*  511 */
    {512, 522, "59.414", "63.12.522", 59, 4},       /*  512 */
    {513, 558, "59.415", "65.14.558", 59, 4},       /*  513 */
    {514, 627, "59.416", "71.7.627", 59, 4},        /*  514 */
    {515, 488, "60.417", "60.1.488", 60, 1},        /*  515 */
    {516, 489, "60.418", "60.2.489", 60, 2},        /*  516 */
    {517, 490, "60.419", "60.3.490", 60, 3},        /*  517 */
    {518, 491, "60.420", "60.4.491", 60, 3},        /*  518 */
    {519, 492, "60.421", "60.5.492", 60, 3},        /*  519 */
    {520, 493, "60.422", "60.6.493", 60, 3},        /*  520 */
    {521, 494, "60.423", "60.7.494", 60, 3},        /*  521 */
    {522, 495, "60.424", "60.8.495", 60, 3},        /*  522 */
    {523, 496, "60.425", "60.9.496", 60, 3},        /*  523 */
    {524, 438, "60.426", "54.11.438", 60, 4},       /*  524 */
    {525, 470, "60.427", "57.13.470", 60, 4},       /*  525 */
    {526, 425, "60.428", "53.11.425", 60, 4},       /*  526 */
    {527, 544, "60.429", "64.17.544", 60, 4},       /*  527 */
    {528, 603, "60.430", "68.10.603", 60, 4},       /*  528 */
    {529, 526, "60.431", "63.16.526", 60, 4},       /*  529 */
    {530, 641, "60.432", "72.12.641", 60, 4},       /*  530 */
    {531, 497, "61.433", "61.1.497", 61, 1},        /*  531 */
    {532, 498, "61.434", "61.2.498", 61, 2},        /*  532 */
    {533, 499, "61.435", "61.3.499", 61, 3},        /*  533 */
    {534, 500, "61.436", "61.4.500", 61, 3},        /*  534 */
    {535, 501, "61.437", "61.5.501", 61, 3},        /*  535 */
    {536, 469, "61.438", "57.12.469", 61, 4},       /*  536 */
    {537, 543, "61.439", "64.16.543", 61, 4},       /*  537 */
    {538, 648, "61.440", "73.6.648", 61, 4},        /*  538 */
    {539, 502, "62.441", "62.1.502", 62, 1},        /*  539 */
    {540, 503, "62.442", "62.2.503", 62, 2},        /*  540 */
    {541, 504, "62.443", "62.3.504", 62, 3},        /*  541 */
    {542, 505, "62.444", "62.4.505", 62, 3},        /*  542 */
    {543, 506, "62.445", "62.5.506", 62, 3},        /*  543 */
    {544, 507, "62.446", "62.6.507", 62, 3},        /*  544 */
    {545, 508, "62.447", "62.7.508", 62, 3},        /*  545 */
    {546, 509, "62.448", "62.8.509", 62, 3},        /*  546 */
    {547, 510, "62.449", "62.9.510", 62, 3},        /*  547 */
    {548, 486, "62.450", "59.9.486", 62, 4},        /*  548 */
    {549, 449, "62.451", "55.9.449", 62, 4},        /*  549 */
    {550, 468, "62.452", "57.11.468", 62, 4},       /*  550 */
    {551, 523, "62.453", "63.13.523", 62, 4},       /*  551 */
    {552, 524, "62.454", "63.14.524", 62, 4},       /*  552 */
    {553, 539, "62.455", "64.12.539", 62, 4},       /*  553 */
    {554, 660, "62.456", "74.11.660", 62, 4},       /*  554 */
    {555, 511, "63.457", "63.1.511", 63, 1},        /*  555 */
    {556, 512, "63.458", "63.2.512", 63, 2},        /*  556 */
    {557, 513, "63.459", "63.3.513", 63, 3},        /*  557 */
    {558, 514, "63.460", "63.4.514", 63, 3},        /*  558 */
    {559, 515, "63.461", "63.5.515", 63, 3},        /*  559 */
    {560, 516, "63.462", "63.6.516", 63, 3},        /*  560 */
    {561, 517, "63.463", "63.7.517", 63, 3},        /*  561 */
    {562, 518, "63.464", "63.8.518", 63, 3},        /*  562 */
    {563, 519, "63.465", "63.9.519", 63, 3},        /*  563 */
    {564, 556, "63.466", "65.12.556", 63, 4},       /*  564 */
    {565, 398, "63.467", "51.12.398", 63, 4},       /*  565 */
    {566, 611, "63.468", "69.7.611", 63, 4},        /*  566 */
    {567, 528, "64.469", "64.1.528", 64, 1},        /*  567 */
    {568, 529, "64.470", "64.2.529", 64, 2},        /*  568 */
    {569, 530, "64.471", "64.3.530", 64, 3},        /*  569 */
    {570, 531, "64.472", "64.4.531", 64, 3},        /*  570 */
    {571, 532, "64.473", "64.5.532", 64, 3},        /*  571 */
    {572, 533, "64.474", "64.6.533", 64, 3},        /*  572 */
    {573, 534, "64.475", "64.7.534", 64, 3},        /*  573 */
    {574, 535, "64.476", "64.8.535", 64, 3},        /*  574 */
    {575, 536, "64.477", "64.9.536", 64, 3},        /*  575 */
    {576, 587, "64.478", "67.11.587", 64, 4},       /*  576 */
    {577, 405, "64.479", "51.19.405", 64, 4},       /*  577 */
    {578, 614, "64.480", "69.10.614", 64, 4},       /*  578 */
    {579, 545, "65.481", "65.1.545", 65, 1},        /*  579 */
    {580, 546, "65.482", "65.2.546", 65, 2},        /*  580 */
    {581, 547, "65.483", "65.3.547", 65, 3},        /*  581 */
    {582, 548, "65.484", "65.4.548", 65, 3},        /*  582 */
    {583, 549, "65.485", "65.5.549", 65, 3},        /*  583 */
    {584, 550, "65.486", "65.6.550", 65, 3},        /*  584 */
    {585, 551, "65.487", "65.7.551", 65, 3},        /*  585 */
    {586, 552, "65.488", "65.8.552", 65, 4},        /*  586 */
    {587, 353, "65.489", "47.7.353", 65, 4},        /*  587 */
    {588, 610, "65.490", "69.6.610", 65, 4},        /*  588 */
    {589, 564, "66.491", "66.1.564", 66, 1},        /*  589 */
    {590, 565, "66.492", "66.2.565", 66, 2},        /*  590 */
    {591, 566, "66.493", "66.3.566", 66, 3},        /*  591 */
    {592, 567, "66.494", "66.4.567", 66, 3},        /*  592 */
    {593, 568, "66.495", "66.5.568", 66, 3},        /*  593 */
    {594, 569, "66.496", "66.6.569", 66, 3},        /*  594 */
    {595, 570, "66.497", "66.7.570", 66, 3},        /*  595 */
    {596, 555, "66.498", "65.11.555", 66, 4},       /*  596 */
    {597, 372, "66.499", "49.9.372", 66, 4},        /*  597 */
    {598, 613, "66.500", "69.9.613", 66, 4},        /*  598 */
    {599, 577, "67.501", "67.1.577", 67, 1},        /*  599 */
    {600, 578, "67.502", "67.2.578", 67, 2},        /*  600 */
    {601, 579, "67.503", "67.3.579", 67, 3},        /*  601 */
    {602, 580, "67.504", "67.4.580", 67, 3},        /*  602 */
    {603, 581, "67.505", "67.5.581", 67, 3},        /*  603 */
    {604, 582, "67.506", "67.6.582", 67, 3},        /*  604 */
    {605, 583, "67.507", "67.7.583", 67, 3},        /*  605 */
    {606, 584, "67.508", "67.8.584", 67, 4},        /*  606 */
    {607, 357, "67.509", "47.11.357", 67, 4},       /*  607 */
    {608, 612, "67.510", "69.8.612", 67, 4},        /*  608 */
    {609, 594, "68.511", "68.1.594", 68, 1},        /*  609 */
    {610, 595, "68.512", "68.2.595", 68, 2},        /*  610 */
    {611, 596, "68.513", "68.3.596", 68, 3},        /*  611 */
    {612, 597, "68.514", "68.4.597", 68, 3},        /*  612 */
    {613, 598, "68.515", "68.5.598", 68, 3},        /*  613 */
    {614, 599, "68.516", "68.6.599", 68, 3},        /*  614 */
    {615, 600, "68.517", "68.7.600", 68, 3},        /*  615 */
    {616, 588, "68.518", "67.12.588", 68, 4},       /*  616 */
    {617, 376, "68.519", "49.13.376", 68, 4},       /*  617 */
    {618, 615, "68.520", "69.11.615", 68, 4},       /*  618 */
    {619, 605, "69.521", "69.1.605", 69, 1},        /*  619 */
    {620, 606, "69.522", "69.2.606", 69, 2},        /*  620 */
    {621, 607, "69.523", "69.3.607", 69, 3},        /*  621 */
    {622, 608, "69.524", "69.4.608", 69, 3},        /*  622 */
    {623, 609, "69.525", "69.5.609", 69, 3},        /*  623 */
    {624, 354, "69.526", "47.8.354", 69, 4},        /*  624 */
    {625, 616, "70.527", "70.1.616", 70, 1},        /*  625 */
    {626, 617, "70.528", "70.2.617", 70, 2},        /*  626 */
    {627, 618, "70.529", "70.3.618", 70, 3},        /*  627 */
    {628, 619, "70.530", "70.4.619", 70, 3},        /*  628 */
    {629, 620, "70.531", "70.5.620", 70, 3},        /*  629 */
    {630, 363, "70.532", "48.6.363", 70, 4},        /*  630 */
    {631, 621, "71.533", "71.1.621", 71, 1},        /*  631 */
    {632, 622, "71.534", "71.2.622", 71, 2},        /*  632 */
    {633, 623, "71.535", "71.3.623", 71, 3},        /*  633 */
    {634, 624, "71.536", "71.4.624", 71, 3},        /*  634 */
    {635, 625, "71.537", "71.5.625", 71, 3},        /*  635 */
    {636, 554, "71.538", "65.10.554", 71, 4},       /*  636 */
    {637, 630, "72.539", "72.1.630", 72, 1},        /*  637 */
    {638, 631, "72.540", "72.2.631", 72, 2},        /*  638 */
    {639, 632, "72.541", "72.3.632", 72, 3},        /*  639 */
    {640, 633, "72.542", "72.4.633", 72, 3},        /*  640 */
    {641, 634, "72.543", "72.5.634", 72, 3},        /*  641 */
    {642, 635, "72.544", "72.6.635", 72, 3},        /*  642 */
    {643, 636, "72.545", "72.7.636", 72, 3},        /*  643 */
    {644, 563, "72.546", "65.19.563", 72, 4},       /*  644 */
    {645, 586, "72.547", "67.10.586", 72, 4},       /*  645 */
    {646, 643, "73.548", "73.1.643", 73, 1},        /*  646 */
    {647, 644, "73.549", "73.2.644", 73, 2},        /*  647 */
    {648, 645, "73.550", "73.3.645", 73, 3},        /*  648 */
    {649, 646, "73.551", "73.4.646", 73, 3},        /*  649 */
    {650, 647, "73.552", "73.5.647", 73, 3},        /*  650 */
    {651, 593, "73.553", "67.17.593", 73, 4},       /*  651 */
    {652, 650, "74.554", "74.1.650", 74, 1},        /*  652 */
    {653, 651, "74.555", "74.2.651", 74, 2},        /*  653 */
    {654, 652, "74.556", "74.3.652", 74, 3},        /*  654 */
    {655, 653, "74.557", "74.4.653", 74, 3},        /*  655 */
    {656, 654, "74.558", "74.5.654", 74, 3},        /*  656 */
    {657, 655, "74.559", "74.6.655", 74, 3},        /*  657 */
    {658, 656, "74.560", "74.7.656", 74, 3},        /*  658 */
    {659, 592, "74.561", "67.16.592", 74, 4},       /*  659 */
    {660, 562, "74.562", "65.18.562", 74, 4},       /*  660 */
    {661, 661, "75.1", "75.1.661", 75, 1},          /*  661 */
    {662, 662, "75.2", "75.2.662", 75, 2},          /*  662 */
    {663, 663, "75.3", "75.3.663", 75, 3},          /*  663 */
    {664, 664, "75.4", "75.4.664", 75, 4},          /*  664 */
    {665, 665, "75.5", "75.5.665", 75, 4},          /*  665 */
    {666, 686, "75.6", "79.4.686", 75, 4},          /*  666 */
    {667, 668, "76.7", "76.1.668", 76, 1},          /*  667 */
    {668, 669, "76.8", "76.2.669", 76, 2},          /*  668 */
    {669, 670, "76.9", "76.3.670", 76, 3},          /*  669 */
    {670, 675, "76.10", "77.4.675", 76, 4},         /*  670 */
    {671, 671, "76.11", "76.4.671", 76, 4},         /*  671 */
    {672, 691, "76.12", "80.4.691", 76, 4},         /*  672 */
    {673, 672, "77.13", "77.1.672", 77, 1},         /*  673 */
    {674, 673, "77.14", "77.2.673", 77, 2},         /*  674 */
    {675, 674, "77.15", "77.3.674", 77, 3},         /*  675 */
    {676, 667, "77.16", "75.7.667", 77, 4},         /*  676 */
    {677, 676, "77.17", "77.5.676", 77, 4},         /*  677 */
    {678, 687, "77.18", "79.5.687", 77, 4},         /*  678 */
    {679, 679, "78.19", "78.1.679", 78, 1},         /*  679 */
    {680, 680, "78.20", "78.2.680", 78, 2},         /*  680 */
    {681, 681, "78.21", "78.3.681", 78, 3},         /*  681 */
    {682, 678, "78.22", "77.7.678", 78, 4},         /*  682 */
    {683, 682, "78.23", "78.4.682", 78, 4},         /*  683 */
    {684, 692, "78.24", "80.5.692", 78, 4},         /*  684 */
    {685, 683, "79.25", "79.1.683", 79, 1},         /*  685 */
    {686, 684, "79.26", "79.2.684", 79, 2},         /*  686 */
    {687, 685, "79.27", "79.3.685", 79, 3},         /*  687 */
    {688, 666, "79.28", "75.6.666", 79, 4},         /*  688 */
    {689, 688, "80.29", "80.1.688", 80, 1},         /*  689 */
    {690, 689, "80.30", "80.2.689", 80, 2},         /*  690 */
    {691, 690, "80.31", "80.3.690", 80, 3},         /*  691 */
    {692, 677, "80.32", "77.6.677", 80, 4},         /*  692 */
    {693, 693, "81.33", "81.1.693", 81, 1},         /*  693 */
    {694, 694, "81.34", "81.2.694", 81, 2},         /*  694 */
    {695, 695, "81.35", "81.3.695", 81, 3},         /*  695 */
    {696, 696, "81.36", "81.4.696", 81, 4},         /*  696 */
    {697, 697, "81.37", "81.5.697", 81, 4},         /*  697 */
    {698, 702, "81.38", "82.4.702", 81, 4},         /*  698 */
    {699, 699, "82.39", "82.1.699", 82, 1},         /*  699 */
    {700, 700, "82.40", "82.2.700", 82, 2},         /*  700 */
    {701, 701, "82.41", "82.3.701", 82, 3},         /*  701 */
    {702, 698, "82.42", "81.6.698", 82, 4},         /*  702 */
    {703, 703, "83.43", "83.1.703", 83, 1},         /*  703 */
    {704, 704, "83.44", "83.2.704", 83, 2},         /*  704 */
    {705, 705, "83.45", "83.3.705", 83, 3},         /*  705 */
    {706, 706, "83.46", "83.4.706", 83, 3},         /*  706 */
    {707, 707, "83.47", "83.5.707", 83, 3},         /*  707 */
    {708, 708, "83.48", "83.6.708", 83, 4},         /*  708 */
    {709, 709, "83.49", "83.7.709", 83, 4},         /*  709 */
    {710, 738, "83.50", "87.6.738", 83, 4},         /*  710 */
    {711, 713, "84.51", "84.1.713", 84, 1},         /*  711 */
    {712, 714, "84.52", "84.2.714", 84, 2},         /*  712 */
    {713, 715, "84.53", "84.3.715", 84, 3},         /*  713 */
    {714, 716, "84.54", "84.4.716", 84, 3},         /*  714 */
    {715, 717, "84.55", "84.5.717", 84, 3},         /*  715 */
    {716, 711, "84.56", "83.9.711", 84, 4},         /*  716 */
    {717, 718, "84.57", "84.6.718", 84, 4},         /*  717 */
    {718, 739, "84.58", "87.7.739", 84, 4},         /*  718 */
    {719, 720, "85.59", "85.1.720", 85, 1},         /*  719 */
    {720, 721, "85.60", "85.2.721", 85, 2},         /*  720 */
    {721, 722, "85.61", "85.3.722", 85, 3},         /*  721 */
    {722, 723, "85.62", "85.4.723", 85, 3},         /*  722 */
    {723, 724, "85.63", "85.5.724", 85, 3},         /*  723 */
    {724, 725, "85.64", "85.6.725", 85, 4},         /*  724 */
    {725, 712, "85.65", "83.10.712", 85, 4},        /*  725 */
    {726, 740, "85.66", "87.8.740", 85, 4},         /*  726 */
    {727, 727, "86.67", "86.1.727", 86, 1},         /*  727 */
    {728, 728, "86.68", "86.2.728", 86, 2},         /*  728 */
    {729, 729, "86.69", "86.3.729", 86, 3},         /*  729 */
    {730, 730, "86.70", "86.4.730", 86, 3},         /*  730 */
    {731, 731, "86.71", "86.5.731", 86, 3},         /*  731 */
    {732, 726, "86.72", "85.7.726", 86, 4},         /*  732 */
    {733, 719, "86.73", "84.7.719", 86, 4},         /*  733 */
    {734, 741, "86.74", "87.9.741", 86, 4},         /*  734 */
    {735, 733, "87.75", "87.1.733", 87, 1},         /*  735 */
    {736, 734, "87.76", "87.2.734", 87, 2},         /*  736 */
    {737, 735, "87.77", "87.3.735", 87, 3},         /*  737 */
    {738, 736, "87.78", "87.4.736", 87, 3},         /*  738 */
    {739, 737, "87.79", "87.5.737", 87, 3},         /*  739 */
    {740, 710, "87.80", "83.8.710", 87, 4},         /*  740 */
    {741, 742, "88.81", "88.1.742", 88, 1},         /*  741 */
    {742, 743, "88.82", "88.2.743", 88, 2},         /*  742 */
    {743, 744, "88.83", "88.3.744", 88, 3},         /*  743 */
    {744, 745, "88.84", "88.4.745", 88, 3},         /*  744 */
    {745, 746, "88.85", "88.5.746", 88, 3},         /*  745 */
    {746, 732, "88.86", "86.6.732", 88, 4},         /*  746 */
    {747, 747, "89.87", "89.1.747", 89, 1},         /*  747 */
    {748, 748, "89.88", "89.2.748", 89, 2},         /*  748 */
    {749, 749, "89.89", "89.3.749", 89, 3},         /*  749 */
    {750, 750, "89.90", "89.4.750", 89, 3},         /*  750 */
    {751, 751, "89.91", "89.5.751", 89, 3},         /*  751 */
    {752, 752, "89.92", "89.6.752", 89, 4},         /*  752 */
    {753, 753, "89.93", "89.7.753", 89, 4},         /*  753 */
    {754, 810, "89.94", "97.6.810", 89, 4},         /*  754 */
    {755, 757, "90.95", "90.1.757", 90, 1},         /*  755 */
    {756, 758, "90.96", "90.2.758", 90, 2},         /*  756 */
    {757, 759, "90.97", "90.3.759", 90, 3},         /*  757 */
    {758, 760, "90.98", "90.4.760", 90, 3},         /*  758 */
    {759, 761, "90.99", "90.5.761", 90, 3},         /*  759 */
    {760, 762, "90.100", "90.6.762", 90, 4},        /*  760 */
    {761, 756, "90.101", "89.10.756", 90, 4},       /*  761 */
    {762, 812, "90.102", "97.8.812", 90, 4},        /*  762 */
    {763, 764, "91.103", "91.1.764", 91, 1},        /*  763 */
    {764, 765, "91.104", "91.2.765", 91, 2},        /*  764 */
    {765, 766, "91.105", "91.3.766", 91, 3},        /*  765 */
    {766, 767, "91.106", "91.4.767", 91, 3},        /*  766 */
    {767, 768, "91.107", "91.5.768", 91, 3},        /*  767 */
    {768, 781, "91.108", "93.6.781", 91, 4},        /*  768 */
    {769, 769, "91.109", "91.6.769", 91, 4},        /*  769 */
    {770, 819, "91.110", "98.6.819", 91, 4},        /*  770 */
    {771, 771, "92.111", "92.1.771", 92, 1},        /*  771 */
    {772, 772, "92.112", "92.2.772", 92, 2},        /*  772 */
    {773, 773, "92.113", "92.3.773", 92, 3},        /*  773 */
    {774, 774, "92.114", "92.4.774", 92, 3},        /*  774 */
    {775, 775, "92.115", "92.5.775", 92, 3},        /*  775 */
    {776, 791, "92.116", "94.6.791", 92, 4},        /*  776 */
    {777, 770, "92.117", "91.7.770", 92, 4},        /*  777 */
    {778, 821, "92.118", "98.8.821", 92, 4},        /*  778 */
    {779, 776, "93.119", "93.1.776", 93, 1},        /*  779 */
    {780, 777, "93.120", "93.2.777", 93, 2},        /*  780 */
    {781, 778, "93.121", "93.3.778", 93, 3},        /*  781 */
    {782, 779, "93.122", "93.4.779", 93, 3},        /*  782 */
    {783, 780, "93.123", "93.5.780", 93, 3},        /*  783 */
    {784, 755, "93.124", "89.9.755", 93, 4},        /*  784 */
    {785, 782, "93.125", "93.7.782", 93, 4},        /*  785 */
    {786, 811, "93.126", "97.7.811", 93, 4},        /*  786 */
    {787, 786, "94.127", "94.1.786", 94, 1},        /*  787 */
    {788, 787, "94.128", "94.2.787", 94, 2},        /*  788 */
    {789, 788, "94.129", "94.3.788", 94, 3},        /*  789 */
    {790, 789, "94.130", "94.4.789", 94, 3},        /*  790 */
    {791, 790, "94.131", "94.5.790", 94, 3},        /*  791 */
    {792, 763, "94.132", "90.7.763", 94, 4},        /*  792 */
    {793, 785, "94.133", "93.10.785", 94, 4},       /*  793 */
    {794, 813, "94.134", "97.9.813", 94, 4},        /*  794 */
    {795, 793, "95.135", "95.1.793", 95, 1},        /*  795 */
    {796, 794, "95.136", "95.2.794", 95, 2},        /*  796 */
    {797, 795, "95.137", "95.3.795", 95, 3},        /*  797 */
    {798, 796, "95.138", "95.4.796", 95, 3},        /*  798 */
    {799, 797, "95.139", "95.5.797", 95, 3},        /*  799 */
    {800, 784, "95.140", "93.9.784", 95, 4},        /*  800 */
    {801, 798, "95.141", "95.6.798", 95, 4},        /*  801 */
    {802, 820, "95.142", "98.7.820", 95, 4},        /*  802 */
    {803, 800, "96.143", "96.1.800", 96, 1},        /*  803 */
    {804, 801, "96.144", "96.2.801", 96, 2},        /*  804 */
    {805, 802, "96.145", "96.3.802", 96, 3},        /*  805 */
    {806, 803, "96.146", "96.4.803", 96, 3},        /*  806 */
    {807, 804, "96.147", "96.5.804", 96, 3},        /*  807 */
    {808, 792, "96.148", "94.7.792", 96, 4},        /*  808 */
    {809, 799, "96.149", "95.7.799", 96, 4},        /*  809 */
    {810, 822, "96.150", "98.9.822", 96, 4},        /*  810 */
    {811, 805, "97.151", "97.1.805", 97, 1},        /*  811 */
    {812, 806, "97.152", "97.2.806", 97, 2},        /*  812 */
    {813, 807, "97.153", "97.3.807", 97, 3},        /*  813 */
    {814, 808, "97.154", "97.4.808", 97, 3},        /*  814 */
    {815, 809, "97.155", "97.5.809", 97, 3},        /*  815 */
    {816, 754, "97.156", "89.8.754", 97, 4},        /*  816 */
    {817, 814, "98.157", "98.1.814", 98, 1},        /*  817 */
    {818, 815, "98.158", "98.2.815", 98, 2},        /*  818 */
    {819, 816, "98.159", "98.3.816", 98, 3},        /*  819 */
    {820, 817, "98.160", "98.4.817", 98, 3},        /*  820 */
    {821, 818, "98.161", "98.5.818", 98, 3},        /*  821 */
    {822, 783, "98.162", "93.8.783", 98, 4},        /*  822 */
    {823, 823, "99.163", "99.1.823", 99, 1},        /*  823 */
    {824, 824, "99.164", "99.2.824", 99, 2},        /*  824 */
    {825, 825, "99.165", "99.3.825", 99, 3},        /*  825 */
    {826, 826, "99.166", "99.4.826", 99, 3},        /*  826 */
    {827, 827, "99.167", "99.5.827", 99, 3},        /*  827 */
    {828, 828, "99.168", "99.6.828", 99, 4},        /*  828 */
    {829, 829, "99.169", "99.7.829", 99, 4},        /*  829 */
    {830, 888, "99.170", "107.6.888", 99, 4},       /*  830 */
    {831, 836, "100.171", "100.1.836", 100, 1},     /*  831 */
    {832, 837, "100.172", "100.2.837", 100, 2},     /*  832 */
    {833, 838, "100.173", "100.3.838", 100, 3},     /*  833 */
    {834, 839, "100.174", "100.4.839", 100, 3},     /*  834 */
    {835, 840, "100.175", "100.5.840", 100, 3},     /*  835 */
    {836, 841, "100.176", "100.6.841", 100, 4},     /*  836 */
    {837, 834, "100.177", "99.12.834", 100, 4},     /*  837 */
    {838, 897, "100.178", "108.6.897", 100, 4},     /*  838 */
    {839, 845, "101.179", "101.1.845", 101, 1},     /*  839 */
    {840, 846, "101.180", "101.2.846", 101, 2},     /*  840 */
    {841, 847, "101.181", "101.3.847", 101, 3},     /*  841 */
    {842, 848, "101.182", "101.4.848", 101, 3},     /*  842 */
    {843, 849, "101.183", "101.5.849", 101, 3},     /*  843 */
    {844, 831, "101.184", "99.9.831", 101, 4},      /*  844 */
    {845, 876, "101.185", "105.6.876", 101, 4},     /*  845 */
    {846, 898, "101.186", "108.7.898", 101, 4},     /*  846 */
    {847, 852, "102.187", "102.1.852", 102, 1},     /*  847 */
    {848, 853, "102.188", "102.2.853", 102, 2},     /*  848 */
    {849, 854, "102.189", "102.3.854", 102, 3},     /*  849 */
    {850, 855, "102.190", "102.4.855", 102, 3},     /*  850 */
    {851, 856, "102.191", "102.5.856", 102, 3},     /*  851 */
    {852, 842, "102.192", "100.7.842", 102, 4},     /*  852 */
    {853, 877, "102.193", "105.7.877", 102, 4},     /*  853 */
    {854, 889, "102.194", "107.7.889", 102, 4},     /*  854 */
    {855, 859, "103.195", "103.1.859", 103, 1},     /*  855 */
    {856, 860, "103.196", "103.2.860", 103, 2},     /*  856 */
    {857, 861, "103.197", "103.3.861", 103, 3},     /*  857 */
    {858, 862, "103.198", "103.4.862", 103, 3},     /*  858 */
    {859, 863, "103.199", "103.5.863", 103, 3},     /*  859 */
    {860, 833, "103.200", "99.11.833", 103, 4},     /*  860 */
    {861, 864, "103.201", "103.6.864", 103, 4},     /*  861 */
    {862, 900, "103.202", "108.9.900", 103, 4},     /*  862 */
    {863, 866, "104.203", "104.1.866", 104, 1},     /*  863 */
    {864, 867, "104.204", "104.2.867", 104, 2},     /*  864 */
    {865, 868, "104.205", "104.3.868", 104, 3},     /*  865 */
    {866, 869, "104.206", "104.4.869", 104, 3},     /*  866 */
    {867, 870, "104.207", "104.5.870", 104, 3},     /*  867 */
    {868, 844, "104.208", "100.9.844", 104, 4},     /*  868 */
    {869, 865, "104.209", "103.7.865", 104, 4},     /*  869 */
    {870, 891, "104.210", "107.9.891", 104, 4},     /*  870 */
    {871, 871, "105.211", "105.1.871", 105, 1},     /*  871 */
    {872, 872, "105.212", "105.2.872", 105, 2},     /*  872 */
    {873, 873, "105.213", "105.3.873", 105, 3},     /*  873 */
    {874, 874, "105.214", "105.4.874", 105, 3},     /*  874 */
    {875, 875, "105.215", "105.5.875", 105, 3},     /*  875 */
    {876, 832, "105.216", "99.10.832", 105, 4},     /*  876 */
    {877, 850, "105.217", "101.6.850", 105, 4},     /*  877 */
    {878, 890, "105.218", "107.8.890", 105, 4},     /*  878 */
    {879, 878, "106.219", "106.1.878", 106, 1},     /*  879 */
    {880, 879, "106.220", "106.2.879", 106, 2},     /*  880 */
    {881, 880, "106.221", "106.3.880", 106, 3},     /*  881 */
    {882, 881, "106.222", "106.4.881", 106, 3},     /*  882 */
    {883, 882, "106.223", "106.5.882", 106, 3},     /*  883 */
    {884, 843, "106.224", "100.8.843", 106, 4},     /*  884 */
    {885, 851, "106.225", "101.7.851", 106, 4},     /*  885 */
    {886, 899, "106.226", "108.8.899", 106, 4},     /*  886 */
    {887, 883, "107.227", "107.1.883", 107, 1},     /*  887 */
    {888, 884, "107.228", "107.2.884", 107, 2},     /*  888 */
    {889, 885, "107.229", "107.3.885", 107, 3},     /*  889 */
    {890, 886, "107.230", "107.4.886", 107, 3},     /*  890 */
    {891, 887, "107.231", "107.5.887", 107, 3},     /*  891 */
    {892, 830, "107.232", "99.8.830", 107, 4},      /*  892 */
    {893, 892, "108.233", "108.1.892", 108, 1},     /*  893 */
    {894, 893, "108.234", "108.2.893", 108, 2},     /*  894 */
    {895, 894, "108.235", "108.3.894", 108, 3},     /*  895 */
    {896, 895, "108.236", "108.4.895", 108, 3},     /*  896 */
    {897, 896, "108.237", "108.5.896", 108, 3},     /*  897 */
    {898, 835, "108.238", "99.13.835", 108, 4},     /*  898 */
    {899, 901, "109.239", "109.1.901", 109, 1},     /*  899 */
    {900, 902, "109.240", "109.2.902", 109, 2},     /*  900 */
    {901, 903, "109.241", "109.3.903", 109, 3},     /*  901 */
    {902, 904, "109.242", "109.4.904", 109, 3},     /*  902 */
    {903, 905, "109.243", "109.5.905", 109, 3},     /*  903 */
    {904, 857, "109.244", "102.6.857", 109, 4},     /*  904 */
    {905, 906, "110.245", "110.1.906", 110, 1},     /*  905 */
    {906, 907, "110.246", "110.2.907", 110, 2},     /*  906 */
    {907, 908, "110.247", "110.3.908", 110, 3},     /*  907 */
    {908, 909, "110.248", "110.4.909", 110, 3},     /*  908 */
    {909, 910, "110.249", "110.5.910", 110, 3},     /*  909 */
    {910, 858, "110.250", "102.7.858", 110, 4},     /*  910 */
    {911, 911, "111.251", "111.1.911", 111, 1},     /*  911 */
    {912, 912, "111.252", "111.2.912", 111, 2},     /*  912 */
    {913, 913, "111.253", "111.3.913", 111, 3},     /*  913 */
    {914, 914, "111.254", "111.4.914", 111, 3},     /*  914 */
    {915, 915, "111.255", "111.5.915", 111, 3},     /*  915 */
    {916, 916, "111.256", "111.6.916", 111, 4},     /*  916 */
    {917, 947, "111.257", "115.7.947", 111, 4},     /*  917 */
    {918, 990, "111.258", "121.6.990", 111, 4},     /*  918 */
    {919, 922, "112.259", "112.1.922", 112, 1},     /*  919 */
    {920, 923, "112.260", "112.2.923", 112, 2},     /*  920 */
    {921, 924, "112.261", "112.3.924", 112, 3},     /*  921 */
    {922, 925, "112.262", "112.4.925", 112, 3},     /*  922 */
    {923, 926, "112.263", "112.5.926", 112, 3},     /*  923 */
    {924, 919, "112.264", "111.9.919", 112, 4},     /*  924 */
    {925, 956, "112.265", "116.6.956", 112, 4},     /*  925 */
    {926, 992, "112.266", "121.8.992", 112, 4},     /*  926 */
    {927, 929, "113.267", "113.1.929", 113, 1},     /*  927 */
    {928, 930, "113.268", "113.2.930", 113, 2},     /*  928 */
    {929, 931, "113.269", "113.3.931", 113, 3},     /*  929 */
    {930, 932, "113.270", "113.4.932", 113, 3},     /*  930 */
    {931, 933, "113.271", "113.5.933", 113, 3},     /*  931 */
    {932, 934, "113.272", "113.6.934", 113, 4},     /*  932 */
    {933, 950, "113.273", "115.10.950", 113, 4},    /*  933 */
    {934, 991, "113.274", "121.7.991", 113, 4},     /*  934 */
    {935, 936, "114.275", "114.1.936", 114, 1},     /*  935 */
    {936, 937, "114.276", "114.2.937", 114, 2},     /*  936 */
    {937, 938, "114.277", "114.3.938", 114, 3},     /*  937 */
    {938, 939, "114.278", "114.4.939", 114, 3},     /*  938 */
    {939, 940, "114.279", "114.5.940", 114, 3},     /*  939 */
    {940, 935, "114.280", "113.7.935", 114, 4},     /*  940 */
    {941, 957, "114.281", "116.7.957", 114, 4},     /*  941 */
    {942, 993, "114.282", "121.9.993", 114, 4},     /*  942 */
    {943, 941, "115.283", "115.1.941", 115, 1},     /*  943 */
    {944, 942, "115.284", "115.2.942", 115, 2},     /*  944 */
    {945, 943, "115.285", "115.3.943", 115, 3},     /*  945 */
    {946, 944, "115.286", "115.4.944", 115, 3},     /*  946 */
    {947, 945, "115.287", "115.5.945", 115, 3},     /*  947 */
    {948, 946, "115.288", "115.6.946", 115, 4},     /*  948 */
    {949, 917, "115.289", "111.7.917", 115, 4},     /*  949 */
    {950, 976, "115.290", "119.6.976", 115, 4},     /*  950 */
    {951, 951, "116.291", "116.1.951", 116, 1},     /*  951 */
    {952, 952, "116.292", "116.2.952", 116, 2},     /*  952 */
    {953, 953, "116.293", "116.3.953", 116, 3},     /*  953 */
    {954, 954, "116.294", "116.4.954", 116, 3},     /*  954 */
    {955, 955, "116.295", "116.5.955", 116, 3},     /*  955 */
    {956, 949, "116.296", "115.9.949", 116, 4},     /*  956 */
    {957, 927, "116.297", "112.6.927", 116, 4},     /*  957 */
    {958, 983, "116.298", "120.6.983", 116, 4},     /*  958 */
    {959, 958, "117.299", "117.1.958", 117, 1},     /*  959 */
    {960, 959, "117.300", "117.2.959", 117, 2},     /*  960 */
    {961, 960, "117.301", "117.3.960", 117, 3},     /*  961 */
    {962, 961, "117.302", "117.4.961", 117, 3},     /*  962 */
    {963, 962, "117.303", "117.5.962", 117, 3},     /*  963 */
    {964, 963, "117.304", "117.6.963", 117, 4},     /*  964 */
    {965, 920, "117.305", "111.10.920", 117, 4},    /*  965 */
    {966, 984, "117.306", "120.7.984", 117, 4},     /*  966 */
    {967, 965, "118.307", "118.1.965", 118, 1},     /*  967 */
    {968, 966, "118.308", "118.2.966", 118, 2},     /*  968 */
    {969, 967, "118.309", "118.3.967", 118, 3},     /*  969 */
    {970, 968, "118.310", "118.4.968", 118, 3},     /*  970 */
    {971, 969, "118.311", "118.5.969", 118, 3},     /*  971 */
    {972, 964, "118.312", "117.7.964", 118, 4},     /*  972 */
    {973, 928, "118.313", "112.7.928", 118, 4},     /*  973 */
    {974, 977, "118.314", "119.7.977", 118, 4},     /*  974 */
    {975, 971, "119.315", "119.1.971", 119, 1},     /*  975 */
    {976, 972, "119.316", "119.2.972", 119, 2},     /*  976 */
    {977, 973, "119.317", "119.3.973", 119, 3},     /*  977 */
    {978, 974, "119.318", "119.4.974", 119, 3},     /*  978 */
    {979, 975, "119.319", "119.5.975", 119, 3},     /*  979 */
    {980, 918, "119.320", "111.8.918", 119, 4},     /*  980 */
    {981, 978, "120.321", "120.1.978", 120, 1},     /*  981 */
    {982, 979, "120.322", "120.2.979", 120, 2},     /*  982 */
    {983, 980, "120.323", "120.3.980", 120, 3},     /*  983 */
    {984, 981, "120.324", "120.4.981", 120, 3},     /*  984 */
    {985, 982, "120.325", "120.5.982", 120, 3},     /*  985 */
    {986, 921, "120.326", "111.11.921", 120, 4},    /*  986 */
    {987, 985, "121.327", "121.1.985", 121, 1},     /*  987 */
    {988, 986, "121.328", "121.2.986", 121, 2},     /*  988 */
    {989, 987, "121.329", "121.3.987", 121, 3},     /*  989 */
    {990, 988, "121.330", "121.4.988", 121, 3},     /*  990 */
    {991, 989, "121.331", "121.5.989", 121, 3},     /*  991 */
    {992, 948, "121.332", "115.8.948", 121, 4},     /*  992 */
    {993, 994, "122.333", "122.1.994", 122, 1},     /*  993 */
    {994, 995, "122.334", "122.2.995", 122, 2},     /*  994 */
    {995, 996, "122.335", "122.3.996", 122, 3},     /*  995 */
    {996, 997, "122.336", "122.4.997", 122, 3},     /*  996 */
    {997, 998, "122.337", "122.5.998", 122, 3},     /*  997 */
    {998, 970, "122.338", "118.6.970", 122, 4},     /*  998 */
    {999, 999, "123.339", "123.1.999", 123, 1},     /*  999 */
    {1000, 1000, "123.340", "123.2.1000", 123, 2},  /* 1000 */
    {1001, 1001, "123.341", "123.3.1001", 123, 3},  /* 1001 */
    {1002, 1002, "123.342", "123.4.1002", 123, 3},  /* 1002 */
    {1003, 1003, "123.343", "123.5.1003", 123, 3},  /* 1003 */
    {1004, 1004, "123.344", "123.6.1004", 123, 3},  /* 1004 */
    {1005, 1005, "123.345", "123.7.1005", 123, 3},  /* 1005 */
    {1006, 1006, "123.346", "123.8.1006", 123, 3},  /* 1006 */
    {1007, 1007, "123.347", "123.9.1007", 123, 3},  /* 1007 */
    {1008, 1008, "123.348", "123.10.1008", 123, 4}, /* 1008 */
    {1009, 1009, "123.349", "123.11.1009", 123, 4}, /* 1009 */
    {1010, 1188, "123.350", "139.10.1188", 123, 4}, /* 1010 */
    {1011, 1018, "124.351", "124.1.1018", 124, 1},  /* 1011 */
    {1012, 1019, "124.352", "124.2.1019", 124, 2},  /* 1012 */
    {1013, 1020, "124.353", "124.3.1020", 124, 3},  /* 1013 */
    {1014, 1021, "124.354", "124.4.1021", 124, 3},  /* 1014 */
    {1015, 1022, "124.355", "124.5.1022", 124, 3},  /* 1015 */
    {1016, 1023, "124.356", "124.6.1023", 124, 3},  /* 1016 */
    {1017, 1024, "124.357", "124.7.1024", 124, 3},  /* 1017 */
    {1018, 1025, "124.358", "124.8.1025", 124, 3},  /* 1018 */
    {1019, 1026, "124.359", "124.9.1026", 124, 3},  /* 1019 */
    {1020, 1013, "124.360", "123.15.1013", 124, 4}, /* 1020 */
    {1021, 1027, "124.361", "124.10.1027", 124, 4}, /* 1021 */
    {1022, 1205, "124.362", "140.10.1205", 124, 4}, /* 1022 */
    {1023, 1031, "125.363", "125.1.1031", 125, 1},  /* 1023 */
    {1024, 1032, "125.364", "125.2.1032", 125, 2},  /* 1024 */
    {1025, 1033, "125.365", "125.3.1033", 125, 3},  /* 1025 */
    {1026, 1034, "125.366", "125.4.1034", 125, 3},  /* 1026 */
    {1027, 1035, "125.367", "125.5.1035", 125, 3},  /* 1027 */
    {1028, 1036, "125.368", "125.6.1036", 125, 3},  /* 1028 */
    {1029, 1037, "125.369", "125.7.1037", 125, 3},  /* 1029 */
    {1030, 1038, "125.370", "125.8.1038", 125, 3},  /* 1030 */
    {1031, 1039, "125.371", "125.9.1039", 125, 3},  /* 1031 */
    {1032, 1040, "125.372", "125.10.1040", 125, 4}, /* 1032 */
    {1033, 1016, "125.373", "123.18.1016", 125, 4}, /* 1033 */
    {1034, 1212, "125.374", "140.17.1212", 125, 4}, /* 1034 */
    {1035, 1044, "126.375", "126.1.1044", 126, 1},  /* 1035 */
    {1036, 1045, "126.376", "126.2.1045", 126, 2},  /* 1036 */
    {1037, 1046, "126.377", "126.3.1046", 126, 3},  /* 1037 */
    {1038, 1047, "126.378", "126.4.1047", 126, 3},  /* 1038 */
    {1039, 1048, "126.379", "126.5.1048", 126, 3},  /* 1039 */
    {1040, 1049, "126.380", "126.6.1049", 126, 3},  /* 1040 */
    {1041, 1050, "126.381", "126.7.1050", 126, 3},  /* 1041 */
    {1042, 1051, "126.382", "126.8.1051", 126, 3},  /* 1042 */
    {1043, 1052, "126.383", "126.9.1052", 126, 3},  /* 1043 */
    {1044, 1043, "126.384", "125.13.1043", 126, 4}, /* 1044 */
    {1045, 1030, "126.385", "124.13.1030", 126, 4}, /* 1045 */
    {1046, 1195, "126.386", "139.17.1195", 126, 4}, /* 1046 */
    {1047, 1053, "127.387", "127.1.1053", 127, 1},  /* 1047 */
    {1048, 1054, "127.388", "127.2.1054", 127, 2},  /* 1048 */
    {1049, 1055, "127.389", "127.3.1055", 127, 3},  /* 1049 */
    {1050, 1056, "127.390", "127.4.1056", 127, 3},  /* 1050 */
    {1051, 1057, "127.391", "127.5.1057", 127, 3},  /* 1051 */
    {1052, 1058, "127.392", "127.6.1058", 127, 3},  /* 1052 */
    {1053, 1059, "127.393", "127.7.1059", 127, 3},  /* 1053 */
    {1054, 1060, "127.394", "127.8.1060", 127, 3},  /* 1054 */
    {1055, 1061, "127.395", "127.9.1061", 127, 3},  /* 1055 */
    {1056, 1062, "127.396", "127.10.1062", 127, 4}, /* 1056 */
    {1057, 1015, "127.397", "123.17.1015", 127, 4}, /* 1057 */
    {1058, 1210, "127.398", "140.15.1210", 127, 4}, /* 1058 */
    {1059, 1066, "128.399", "128.1.1066", 128, 1},  /* 1059 */
    {1060, 1067, "128.400", "128.2.1067", 128, 2},  /* 1060 */
    {1061, 1068, "128.401", "128.3.1068", 128, 3},  /* 1061 */
    {1062, 1069, "128.402", "128.4.1069", 128, 3},  /* 1062 */
    {1063, 1070, "128.403", "128.5.1070", 128, 3},  /* 1063 */
    {1064, 1071, "128.404", "128.6.1071", 128, 3},  /* 1064 */
    {1065, 1072, "128.405", "128.7.1072", 128, 3},  /* 1065 */
    {1066, 1073, "128.406", "128.8.1073", 128, 3},  /* 1066 */
    {1067, 1074, "128.407", "128.9.1074", 128, 3},  /* 1067 */
    {1068, 1065, "128.408", "127.13.1065", 128, 4}, /* 1068 */
    {1069, 1029, "128.409", "124.12.1029", 128, 4}, /* 1069 */
    {1070, 1193, "128.410", "139.15.1193", 128, 4}, /* 1070 */
    {1071, 1075, "129.411", "129.1.1075", 129, 1},  /* 1071 */
    {1072, 1076, "129.412", "129.2.1076", 129, 2},  /* 1072 */
    {1073, 1077, "129.413", "129.3.1077", 129, 3},  /* 1073 */
    {1074, 1078, "129.414", "129.4.1078", 129, 3},  /* 1074 */
    {1075, 1079, "129.415", "129.5.1079", 129, 3},  /* 1075 */
    {1076, 1080, "129.416", "129.6.1080", 129, 3},  /* 1076 */
    {1077, 1081, "129.417", "129.7.1081", 129, 3},  /* 1077 */
    {1078, 1082, "129.418", "129.8.1082", 129, 3},  /* 1078 */
    {1079, 1083, "129.419", "129.9.1083", 129, 3},  /* 1079 */
    {1080, 1084, "129.420", "129.10.1084", 129, 4}, /* 1080 */
    {1081, 1014, "129.421", "123.16.1014", 129, 4}, /* 1081 */
    {1082, 1189, "129.422", "139.11.1189", 129, 4}, /* 1082 */
    {1083, 1088, "130.423", "130.1.1088", 130, 1},  /* 1083 */
    {1084, 1089, "130.424", "130.2.1089", 130, 2},  /* 1084 */
    {1085, 1090, "130.425", "130.3.1090", 130, 3},  /* 1085 */
    {1086, 1091, "130.426", "130.4.1091", 130, 3},  /* 1086 */
    {1087, 1092, "130.427", "130.5.1092", 130, 3},  /* 1087 */
    {1088, 1093, "130.428", "130.6.1093", 130, 3},  /* 1088 */
    {1089, 1094, "130.429", "130.7.1094", 130, 3},  /* 1089 */
    {1090, 1095, "130.430", "130.8.1095", 130, 3},  /* 1090 */
    {1091, 1096, "130.431", "130.9.1096", 130, 3},  /* 1091 */
    {1092, 1087, "130.432", "129.13.1087", 130, 4}, /* 1092 */
    {1093, 1028, "130.433", "124.11.1028", 130, 4}, /* 1093 */
    {1094, 1206, "130.434", "140.11.1206", 130, 4}, /* 1094 */
    {1095, 1097, "131.435", "131.1.1097", 131, 1},  /* 1095 */
    {1096, 1098, "131.436", "131.2.1098", 131, 2},  /* 1096 */
    {1097, 1099, "131.437", "131.3.1099", 131, 3},  /* 1097 */
    {1098, 1100, "131.438", "131.4.1100", 131, 3},  /* 1098 */
    {1099, 1101, "131.439", "131.5.1101", 131, 3},  /* 1099 */
    {1100, 1102, "131.440", "131.6.1102", 131, 3},  /* 1100 */
    {1101, 1103, "131.441", "131.7.1103", 131, 3},  /* 1101 */
    {1102, 1104, "131.442", "131.8.1104", 131, 3},  /* 1102 */
    {1103, 1105, "131.443", "131.9.1105", 131, 3},  /* 1103 */
    {1104, 1012, "131.444", "123.14.1012", 131, 4}, /* 1104 */
    {1105, 1119, "131.445", "132.10.1119", 131, 4}, /* 1105 */
    {1106, 1191, "131.446", "139.13.1191", 131, 4}, /* 1106 */
    {1107, 1110, "132.447", "132.1.1110", 132, 1},  /* 1107 */
    {1108, 1111, "132.448", "132.2.1111", 132, 2},  /* 1108 */
    {1109, 1112, "132.449", "132.3.1112", 132, 3},  /* 1109 */
    {1110, 1113, "132.450", "132.4.1113", 132, 3},  /* 1110 */
    {1111, 1114, "132.451", "132.5.1114", 132, 3},  /* 1111 */
    {1112, 1115, "132.452", "132.6.1115", 132, 3},  /* 1112 */
    {1113, 1116, "132.453", "132.7.1116", 132, 3},  /* 1113 */
    {1114, 1117, "132.454", "132.8.1117", 132, 3},  /* 1114 */
    {1115, 1118, "132.455", "132.9.1118", 132, 3},  /* 1115 */
    {1116, 1011, "132.456", "123.13.1011", 132, 4}, /* 1116 */
    {1117, 1106, "132.457", "131.10.1106", 132, 4}, /* 1117 */
    {1118, 1208, "132.458", "140.13.1208", 132, 4}, /* 1118 */
    {1119, 1123, "133.459", "133.1.1123", 133, 1},  /* 1119 */
    {1120, 1124, "133.460", "133.2.1124", 133, 2},  /* 1120 */
    {1121, 1125, "133.461", "133.3.1125", 133, 3},  /* 1121 */
    {1122, 1126, "133.462", "133.4.1126", 133, 3},  /* 1122 */
    {1123, 1127, "133.463", "133.5.1127", 133, 3},  /* 1123 */
    {1124, 1128, "133.464", "133.6.1128", 133, 3},  /* 1124 */
    {1125, 1129, "133.465", "133.7.1129", 133, 3},  /* 1125 */
    {1126, 1130, "133.466", "133.8.1130", 133, 3},  /* 1126 */
    {1127, 1131, "133.467", "133.9.1131", 133, 3},  /* 1127 */
    {1128, 1042, "133.468", "125.12.1042", 133, 4}, /* 1128 */
    {1129, 1122, "133.469", "132.13.1122", 133, 4}, /* 1129 */
    {1130, 1209, "133.470", "140.14.1209", 133, 4}, /* 1130 */
    {1131, 1132, "134.471", "134.1.1132", 134, 1},  /* 1131 */
    {1132, 1133, "134.472", "134.2.1133", 134, 2},  /* 1132 */
    {1133, 1134, "134.473", "134.3.1134", 134, 3},  /* 1133 */
    {1134, 1135, "134.474", "134.4.1135", 134, 3},  /* 1134 */
    {1135, 1136, "134.475", "134.5.1136", 134, 3},  /* 1135 */
    {1136, 1137, "134.476", "134.6.1137", 134, 3},  /* 1136 */
    {1137, 1138, "134.477", "134.7.1138", 134, 3},  /* 1137 */
    {1138, 1139, "134.478", "134.8.1139", 134, 3},  /* 1138 */
    {1139, 1140, "134.479", "134.9.1140", 134, 3},  /* 1139 */
    {1140, 1041, "134.480", "125.11.1041", 134, 4}, /* 1140 */
    {1141, 1109, "134.481", "131.13.1109", 134, 4}, /* 1141 */
    {1142, 1192, "134.482", "139.14.1192", 134, 4}, /* 1142 */
    {1143, 1143, "135.483", "135.1.1143", 135, 1},  /* 1143 */
    {1144, 1144, "135.484", "135.2.1144", 135, 2},  /* 1144 */
    {1145, 1145, "135.485", "135.3.1145", 135, 3},  /* 1145 */
    {1146, 1146, "135.486", "135.4.1146", 135, 3},  /* 1146 */
    {1147, 1147, "135.487", "135.5.1147", 135, 3},  /* 1147 */
    {1148, 1148, "135.488", "135.6.1148", 135, 3},  /* 1148 */
    {1149, 1149, "135.489", "135.7.1149", 135, 3},  /* 1149 */
    {1150, 1150, "135.490", "135.8.1150", 135, 3},  /* 1150 */
    {1151, 1151, "135.491", "135.9.1151", 135, 3},  /* 1151 */
    {1152, 1064, "135.492", "127.12.1064", 135, 4}, /* 1152 */
    {1153, 1121, "135.493", "132.12.1121", 135, 4}, /* 1153 */
    {1154, 1207, "135.494", "140.12.1207", 135, 4}, /* 1154 */
    {1155, 1152, "136.495", "136.1.1152", 136, 1},  /* 1155 */
    {1156, 1153, "136.496", "136.2.1153", 136, 2},  /* 1156 */
    {1157, 1154, "136.497", "136.3.1154", 136, 3},  /* 1157 */
    {1158, 1155, "136.498", "136.4.1155", 136, 3},  /* 1158 */
    {1159, 1156, "136.499", "136.5.1156", 136, 3},  /* 1159 */
    {1160, 1157, "136.500", "136.6.1157", 136, 3},  /* 1160 */
    {1161, 1158, "136.501", "136.7.1158", 136, 3},  /* 1161 */
    {1162, 1159, "136.502", "136.8.1159", 136, 3},  /* 1162 */
    {1163, 1160, "136.503", "136.9.1160", 136, 3},  /* 1163 */
    {1164, 1063, "136.504", "127.11.1063", 136, 4}, /* 1164 */
    {1165, 1108, "136.505", "131.12.1108", 136, 4}, /* 1165 */
    {1166, 1190, "136.506", "139.12.1190", 136, 4}, /* 1166 */
    {1167, 1161, "137.507", "137.1.1161", 137, 1},  /* 1167 */
    {1168, 1162, "137.508", "137.2.1162", 137, 2},  /* 1168 */
    {1169, 1163, "137.509", "137.3.1163", 137, 3},  /* 1169 */
    {1170, 1164, "137.510", "137.4.1164", 137, 3},  /* 1170 */
    {1171, 1165, "137.511", "137.5.1165", 137, 3},  /* 1171 */
    {1172, 1166, "137.512", "137.6.1166", 137, 3},  /* 1172 */
    {1173, 1167, "137.513", "137.7.1167", 137, 3},  /* 1173 */
    {1174, 1168, "137.514", "137.8.1168", 137, 3},  /* 1174 */
    {1175, 1169, "137.515", "137.9.1169", 137, 3},  /* 1175 */
    {1176, 1086, "137.516", "129.12.1086", 137, 4}, /* 1176 */
    {1177, 1120, "137.517", "132.11.1120", 137, 4}, /* 1177 */
    {1178, 1194, "137.518", "139.16.1194", 137, 4}, /* 1178 */
    {1179, 1170, "138.519", "138.1.1170", 138, 1},  /* 1179 */
    {1180, 1171, "138.520", "138.2.1171", 138, 2},  /* 1180 */
    {1181, 1172, "138.521", "138.3.1172", 138, 3},  /* 1181 */
    {1182, 1173, "138.522", "138.4.1173", 138, 3},  /* 1182 */
    {1183, 1174, "138.523", "138.5.1174", 138, 3},  /* 1183 */
    {1184, 1175, "138.524", "138.6.1175", 138, 3},  /* 1184 */
    {1185, 1176, "138.525", "138.7.1176", 138, 3},  /* 1185 */
    {1186, 1177, "138.526", "138.8.1177", 138, 3},  /* 1186 */
    {1187, 1178, "138.527", "138.9.1178", 138, 3},  /* 1187 */
    {1188, 1085, "138.528", "129.11.1085", 138, 4}, /* 1188 */
    {1189, 1107, "138.529", "131.11.1107", 138, 4}, /* 1189 */
    {1190, 1211, "138.530", "140.16.1211", 138, 4}, /* 1190 */
    {1191, 1179, "139.531", "139.1.1179", 139, 1},  /* 1191 */
    {1192, 1180, "139.532", "139.2.1180", 139, 2},  /* 1192 */
    {1193, 1181, "139.533", "139.3.1181", 139, 3},  /* 1193 */
    {1194, 1182, "139.534", "139.4.1182", 139, 3},  /* 1194 */
    {1195, 1183, "139.535", "139.5.1183", 139, 3},  /* 1195 */
    {1196, 1184, "139.536", "139.6.1184", 139, 3},  /* 1196 */
    {1197, 1185, "139.537", "139.7.1185", 139, 3},  /* 1197 */
    {1198, 1186, "139.538", "139.8.1186", 139, 3},  /* 1198 */
    {1199, 1187, "139.539", "139.9.1187", 139, 3},  /* 1199 */
    {1200, 1010, "139.540", "123.12.1010", 139, 4}, /* 1200 */
    {1201, 1196, "140.541", "140.1.1196", 140, 1},  /* 1201 */
    {1202, 1197, "140.542", "140.2.1197", 140, 2},  /* 1202 */
    {1203, 1198, "140.543", "140.3.1198", 140, 3},  /* 1203 */
    {1204, 1199, "140.544", "140.4.1199", 140, 3},  /* 1204 */
    {1205, 1200, "140.545", "140.5.1200", 140, 3},  /* 1205 */
    {1206, 1201, "140.546", "140.6.1201", 140, 3},  /* 1206 */
    {1207, 1202, "140.547", "140.7.1202", 140, 3},  /* 1207 */
    {1208, 1203, "140.548", "140.8.1203", 140, 3},  /* 1208 */
    {1209, 1204, "140.549", "140.9.1204", 140, 3},  /* 1209 */
    {1210, 1017, "140.550", "123.19.1017", 140, 4}, /* 1210 */
    {1211, 1213, "141.551", "141.1.1213", 141, 1},  /* 1211 */
    {1212, 1214, "141.552", "141.2.1214", 141, 2},  /* 1212 */
    {1213, 1215, "141.553", "141.3.1215", 141, 3},  /* 1213 */
    {1214, 1216, "141.554", "141.4.1216", 141, 3},  /* 1214 */
    {1215, 1217, "141.555", "141.5.1217", 141, 3},  /* 1215 */
    {1216, 1218, "141.556", "141.6.1218", 141, 3},  /* 1216 */
    {1217, 1219, "141.557", "141.7.1219", 141, 3},  /* 1217 */
    {1218, 1220, "141.558", "141.8.1220", 141, 3},  /* 1218 */
    {1219, 1221, "141.559", "141.9.1221", 141, 3},  /* 1219 */
    {1220, 1141, "141.560", "134.10.1141", 141, 4}, /* 1220 */
    {1221, 1222, "142.561", "142.1.1222", 142, 1},  /* 1221 */
    {1222, 1223, "142.562", "142.2.1223", 142, 2},  /* 1222 */
    {1223, 1224, "142.563", "142.3.1224", 142, 3},  /* 1223 */
    {1224, 1225, "142.564", "142.4.1225", 142, 3},  /* 1224 */
    {1225, 1226, "142.565", "142.5.1226", 142, 3},  /* 1225 */
    {1226, 1227, "142.566", "142.6.1227", 142, 3},  /* 1226 */
    {1227, 1228, "142.567", "142.7.1228", 142, 3},  /* 1227 */
    {1228, 1229, "142.568", "142.8.1229", 142, 3},  /* 1228 */
    {1229, 1230, "142.569", "142.9.1230", 142, 3},  /* 1229 */
    {1230, 1142, "142.570", "134.11.1142", 142, 4}, /* 1230 */
    {1231, 1231, "143.1", "143.1.1231", 143, 1},    /* 1231 */
    {1232, 1232, "143.2", "143.2.1232", 143, 2},    /* 1232 */
    {1233, 1233, "143.3", "143.3.1233", 143, 4},    /* 1233 */
    {1234, 1234, "144.4", "144.1.1234", 144, 1},    /* 1234 */
    {1235, 1235, "144.5", "144.2.1235", 144, 2},    /* 1235 */
    {1236, 1239, "144.6", "145.3.1239", 144, 4},    /* 1236 */
    {1237, 1237, "145.7", "145.1.1237", 145, 1},    /* 1237 */
    {1238, 1238, "145.8", "145.2.1238", 145, 2},    /* 1238 */
    {1239, 1236, "145.9", "144.3.1236", 145, 4},    /* 1239 */
    {1240, 1240, "146.10", "146.1.1240", 146, 1},   /* 1240 */
    {1241, 1241, "146.11", "146.2.1241", 146, 2},   /* 1241 */
    {1242, 1242, "146.12", "146.3.1242", 146, 4},   /* 1242 */
    {1243, 1243, "147.13", "147.1.1243", 147, 1},   /* 1243 */
    {1244, 1244, "147.14", "147.2.1244", 147, 2},   /* 1244 */
    {1245, 1245, "147.15", "147.3.1245", 147, 3},   /* 1245 */
    {1246, 1246, "147.16", "147.4.1246", 147, 4},   /* 1246 */
    {1247, 1247, "148.17", "148.1.1247", 148, 1},   /* 1247 */
    {1248, 1248, "148.18", "148.2.1248", 148, 2},   /* 1248 */
    {1249, 1249, "148.19", "148.3.1249", 148, 3},   /* 1249 */
    {1250, 1250, "148.20", "148.4.1250", 148, 4},   /* 1250 */
    {1251, 1251, "149.21", "149.1.1251", 149, 1},   /* 1251 */
    {1252, 1252, "149.22", "149.2.1252", 149, 2},   /* 1252 */
    {1253, 1253, "149.23", "149.3.1253", 149, 3},   /* 1253 */
    {1254, 1254, "149.24", "149.4.1254", 149, 4},   /* 1254 */
    {1255, 1255, "150.25", "150.1.1255", 150, 1},   /* 1255 */
    {1256, 1256, "150.26", "150.2.1256", 150, 2},   /* 1256 */
    {1257, 1257, "150.27", "150.3.1257", 150, 3},   /* 1257 */
    {1258, 1258, "150.28", "150.4.1258", 150, 4},   /* 1258 */
    {1259, 1259, "151.29", "151.1.1259", 151, 1},   /* 1259 */
    {1260, 1260, "151.30", "151.2.1260", 151, 2},   /* 1260 */
    {1261, 1261, "151.31", "151.3.1261", 151, 3},   /* 1261 */
    {1262, 1270, "151.32", "153.4.1270", 151, 4},   /* 1262 */
    {1263, 1263, "152.33", "152.1.1263", 152, 1},   /* 1263 */
    {1264, 1264, "152.34", "152.2.1264", 152, 2},   /* 1264 */
    {1265, 1265, "152.35", "152.3.1265", 152, 3},   /* 1265 */
    {1266, 1274, "152.36", "154.4.1274", 152, 4},   /* 1266 */
    {1267, 1267, "153.37", "153.1.1267", 153, 1},   /* 1267 */
    {1268, 1268, "153.38", "153.2.1268", 153, 2},   /* 1268 */
    {1269, 1269, "153.39", "153.3.1269", 153, 3},   /* 1269 */
    {1270, 1262, "153.40", "151.4.1262", 153, 4},   /* 1270 */
    {1271, 1271, "154.41", "154.1.1271", 154, 1},   /* 1271 */
    {1272, 1272, "154.42", "154.2.1272", 154, 2},   /* 1272 */
    {1273, 1273, "154.43", "154.3.1273", 154, 3},   /* 1273 */
    {1274, 1266, "154.44", "152.4.1266", 154, 4},   /* 1274 */
    {1275, 1275, "155.45", "155.1.1275", 155, 1},   /* 1275 */
    {1276, 1276, "155.46", "155.2.1276", 155, 2},   /* 1276 */
    {1277, 1277, "155.47", "155.3.1277", 155, 3},   /* 1277 */
    {1278, 1278, "155.48", "155.4.1278", 155, 4},   /* 1278 */
    {1279, 1279, "156.49", "156.1.1279", 156, 1},   /* 1279 */
    {1280, 1280, "156.50", "156.2.1280", 156, 2},   /* 1280 */
    {1281, 1281, "156.51", "156.3.1281", 156, 3},   /* 1281 */
    {1282, 1282, "156.52", "156.4.1282", 156, 4},   /* 1282 */
    {1283, 1284, "157.53", "157.1.1284", 157, 1},   /* 1283 */
    {1284, 1285, "157.54", "157.2.1285", 157, 2},   /* 1284 */
    {1285, 1286, "157.55", "157.3.1286", 157, 3},   /* 1285 */
    {1286, 1287, "157.56", "157.4.1287", 157, 4},   /* 1286 */
    {1287, 1289, "158.57", "158.1.1289", 158, 1},   /* 1287 */
    {1288, 1290, "158.58", "158.2.1290", 158, 2},   /* 1288 */
    {1289, 1291, "158.59", "158.3.1291", 158, 3},   /* 1289 */
    {1290, 1283, "158.60", "156.5.1283", 158, 4},   /* 1290 */
    {1291, 1292, "159.61", "159.1.1292", 159, 1},   /* 1291 */
    {1292, 1293, "159.62", "159.2.1293", 159, 2},   /* 1292 */
    {1293, 1294, "159.63", "159.3.1294", 159, 3},   /* 1293 */
    {1294, 1288, "159.64", "157.5.1288", 159, 4},   /* 1294 */
    {1295, 1295, "160.65", "160.1.1295", 160, 1},   /* 1295 */
    {1296, 1296, "160.66", "160.2.1296", 160, 2},   /* 1296 */
    {1297, 1297, "160.67", "160.3.1297", 160, 3},   /* 1297 */
    {1298, 1298, "160.68", "160.4.1298", 160, 4},   /* 1298 */
    {1299, 1300, "161.69", "161.1.1300", 161, 1},   /* 1299 */
    {1300, 1301, "161.70", "161.2.1301", 161, 2},   /* 1300 */
    {1301, 1302, "161.71", "161.3.1302", 161, 3},   /* 1301 */
    {1302, 1299, "161.72", "160.5.1299", 161, 4},   /* 1302 */
    {1303, 1303, "162.73", "162.1.1303", 162, 1},   /* 1303 */
    {1304, 1304, "162.74", "162.2.1304", 162, 2},   /* 1304 */
    {1305, 1305, "162.75", "162.3.1305", 162, 3},   /* 1305 */
    {1306, 1306, "162.76", "162.4.1306", 162, 3},   /* 1306 */
    {1307, 1307, "162.77", "162.5.1307", 162, 3},   /* 1307 */
    {1308, 1308, "162.78", "162.6.1308", 162, 4},   /* 1308 */
    {1309, 1310, "163.79", "163.1.1310", 163, 1},   /* 1309 */
    {1310, 1311, "163.80", "163.2.1311", 163, 2},   /* 1310 */
    {1311, 1312, "163.81", "163.3.1312", 163, 3},   /* 1311 */
    {1312, 1313, "163.82", "163.4.1313", 163, 3},   /* 1312 */
    {1313, 1314, "163.83", "163.5.1314", 163, 3},   /* 1313 */
    {1314, 1309, "163.84", "162.7.1309", 163, 4},   /* 1314 */
    {1315, 1315, "164.85", "164.1.1315", 164, 1},   /* 1315 */
    {1316, 1316, "164.86", "164.2.1316", 164, 2},   /* 1316 */
    {1317, 1317, "164.87", "164.3.1317", 164, 3},   /* 1317 */
    {1318, 1318, "164.88", "164.4.1318", 164, 3},   /* 1318 */
    {1319, 1319, "164.89", "164.5.1319", 164, 3},   /* 1319 */
    {1320, 1320, "164.90", "164.6.1320", 164, 4},   /* 1320 */
    {1321, 1322, "165.91", "165.1.1322", 165, 1},   /* 1321 */
    {1322, 1323, "165.92", "165.2.1323", 165, 2},   /* 1322 */
    {1323, 1324, "165.93", "165.3.1324", 165, 3},   /* 1323 */
    {1324, 1325, "165.94", "165.4.1325", 165, 3},   /* 1324 */
    {1325, 1326, "165.95", "165.5.1326", 165, 3},   /* 1325 */
    {1326, 1321, "165.96", "164.7.1321", 165, 4},   /* 1326 */
    {1327, 1327, "166.97", "166.1.1327", 166, 1},   /* 1327 */
    {1328, 1328, "166.98", "166.2.1328", 166, 2},   /* 1328 */
    {1329, 1329, "166.99", "166.3.1329", 166, 3},   /* 1329 */
    {1330, 1330, "166.100", "166.4.1330", 166, 3},  /* 1330 */
    {1331, 1331, "166.101", "166.5.1331", 166, 3},  /* 1331 */
    {1332, 1332, "166.102", "166.6.1332", 166, 4},  /* 1332 */
    {1333, 1334, "167.103", "167.1.1334", 167, 1},  /* 1333 */
    {1334, 1335, "167.104", "167.2.1335", 167, 2},  /* 1334 */
    {1335, 1336, "167.105", "167.3.1336", 167, 3},  /* 1335 */
    {1336, 1337, "167.106", "167.4.1337", 167, 3},  /* 1336 */
    {1337, 1338, "167.107", "167.5.1338", 167, 3},  /* 1337 */
    {1338, 1333, "167.108", "166.7.1333", 167, 4},  /* 1338 */
    {1339, 1339, "168.109", "168.1.1339", 168, 1},  /* 1339 */
    {1340, 1340, "168.110", "168.2.1340", 168, 2},  /* 1340 */
    {1341, 1341, "168.111", "168.3.1341", 168, 3},  /* 1341 */
    {1342, 1342, "168.112", "168.4.1342", 168, 4},  /* 1342 */
    {1343, 1344, "169.113", "169.1.1344", 169, 1},  /* 1343 */
    {1344, 1345, "169.114", "169.2.1345", 169, 2},  /* 1344 */
    {1345, 1346, "169.115", "169.3.1346", 169, 3},  /* 1345 */
    {1346, 1353, "169.116", "171.4.1353", 169, 4},  /* 1346 */
    {1347, 1347, "170.117", "170.1.1347", 170, 1},  /* 1347 */
    {1348, 1348, "170.118", "170.2.1348", 170, 2},  /* 1348 */
    {1349, 1349, "170.119", "170.3.1349", 170, 3},  /* 1349 */
    {1350, 1359, "170.120", "172.5.1359", 170, 4},  /* 1350 */
    {1351, 1350, "171.121", "171.1.1350", 171, 1},  /* 1351 */
    {1352, 1351, "171.122", "171.2.1351", 171, 2},  /* 1352 */
    {1353, 1352, "171.123", "171.3.1352", 171, 3},  /* 1353 */
    {1354, 1358, "171.124", "172.4.1358", 171, 4},  /* 1354 */
    {1355, 1355, "172.125", "172.1.1355", 172, 1},  /* 1355 */
    {1356, 1356, "172.126", "172.2.1356", 172, 2},  /* 1356 */
    {1357, 1357, "172.127", "172.3.1357", 172, 3},  /* 1357 */
    {1358, 1354, "172.128", "171.5.1354", 172, 4},  /* 1358 */
    {1359, 1360, "173.129", "173.1.1360", 173, 1},  /* 1359 */
    {1360, 1361, "173.130", "173.2.1361", 173, 2},  /* 1360 */
    {1361, 1362, "173.131", "173.3.1362", 173, 3},  /* 1361 */
    {1362, 1343, "173.132", "168.5.1343", 173, 4},  /* 1362 */
    {1363, 1363, "174.133", "174.1.1363", 174, 1},  /* 1363 */
    {1364, 1364, "174.134", "174.2.1364", 174, 2},  /* 1364 */
    {1365, 1365, "174.135", "174.3.1365", 174, 3},  /* 1365 */
    {1366, 1366, "174.136", "174.4.1366", 174, 4},  /* 1366 */
    {1367, 1367, "175.137", "175.1.1367", 175, 1},  /* 1367 */
    {1368, 1368, "175.138", "175.2.1368", 175, 2},  /* 1368 */
    {1369, 1369, "175.139", "175.3.1369", 175, 3},  /* 1369 */
    {1370, 1370, "175.140", "175.4.1370", 175, 3},  /* 1370 */
    {1371, 1371, "175.141", "175.5.1371", 175, 3},  /* 1371 */
    {1372, 1372, "175.142", "175.6.1372", 175, 4},  /* 1372 */
    {1373, 1374, "176.143", "176.1.1374", 176, 1},  /* 1373 */
    {1374, 1375, "176.144", "176.2.1375", 176, 2},  /* 1374 */
    {1375, 1376, "176.145", "176.3.1376", 176, 3},  /* 1375 */
    {1376, 1377, "176.146", "176.4.1377", 176, 3},  /* 1376 */
    {1377, 1378, "176.147", "176.5.1378", 176, 3},  /* 1377 */
    {1378, 1373, "176.148", "175.7.1373", 176, 4},  /* 1378 */
    {1379, 1379, "177.149", "177.1.1379", 177, 1},  /* 1379 */
    {1380, 1380, "177.150", "177.2.1380", 177, 2},  /* 1380 */
    {1381, 1381, "177.151", "177.3.1381", 177, 3},  /* 1381 */
    {1382, 1382, "177.152", "177.4.1382", 177, 3},  /* 1382 */
    {1383, 1383, "177.153", "177.5.1383", 177, 3},  /* 1383 */
    {1384, 1384, "177.154", "177.6.1384", 177, 4},  /* 1384 */
    {1385, 1386, "178.155", "178.1.1386", 178, 1},  /* 1385 */
    {1386, 1387, "178.156", "178.2.1387", 178, 2},  /* 1386 */
    {1387, 1388, "178.157", "178.3.1388", 178, 3},  /* 1387 */
    {1388, 1389, "178.158", "178.4.1389", 178, 3},  /* 1388 */
    {1389, 1390, "178.159", "178.5.1390", 178, 3},  /* 1389 */
    {1390, 1401, "178.160", "180.6.1401", 178, 4},  /* 1390 */
    {1391, 1391, "179.161", "179.1.1391", 179, 1},  /* 1391 */
    {1392, 1392, "179.162", "179.2.1392", 179, 2},  /* 1392 */
    {1393, 1393, "179.163", "179.3.1393", 179, 3},  /* 1393 */
    {1394, 1394, "179.164", "179.4.1394", 179, 3},  /* 1394 */
    {1395, 1395, "179.165", "179.5.1395", 179, 3},  /* 1395 */
    {1396, 1409, "179.166", "181.7.1409", 179, 4},  /* 1396 */
    {1397, 1396, "180.167", "180.1.1396", 180, 1},  /* 1397 */
    {1398, 1397, "180.168", "180.2.1397", 180, 2},  /* 1398 */
    {1399, 1398, "180.169", "180.3.1398", 180, 3},  /* 1399 */
    {1400, 1399, "180.170", "180.4.1399", 180, 3},  /* 1400 */
    {1401, 1400, "180.171", "180.5.1400", 180, 3},  /* 1401 */
    {1402, 1408, "180.172", "181.6.1408", 180, 4},  /* 1402 */
    {1403, 1403, "181.173", "181.1.1403", 181, 1},  /* 1403 */
    {1404, 1404, "181.174", "181.2.1404", 181, 2},  /* 1404 */
    {1405, 1405, "181.175", "181.3.1405", 181, 3},  /* 1405 */
    {1406, 1406, "181.176", "181.4.1406", 181, 3},  /* 1406 */
    {1407, 1407, "181.177", "181.5.1407", 181, 3},  /* 1407 */
    {1408, 1402, "181.178", "180.7.1402", 181, 4},  /* 1408 */
    {1409, 1410, "182.179", "182.1.1410", 182, 1},  /* 1409 */
    {1410, 1411, "182.180", "182.2.1411", 182, 2},  /* 1410 */
    {1411, 1412, "182.181", "182.3.1412", 182, 3},  /* 1411 */
    {1412, 1413, "182.182", "182.4.1413", 182, 3},  /* 1412 */
    {1413, 1414, "182.183", "182.5.1414", 182, 3},  /* 1413 */
    {1414, 1385, "182.184", "177.7.1385", 182, 4},  /* 1414 */
    {1415, 1415, "183.185", "183.1.1415", 183, 1},  /* 1415 */
    {1416, 1416, "183.186", "183.2.1416", 183, 2},  /* 1416 */
    {1417, 1417, "183.187", "183.3.1417", 183, 3},  /* 1417 */
    {1418, 1418, "183.188", "183.4.1418", 183, 3},  /* 1418 */
    {1419, 1419, "183.189", "183.5.1419", 183, 3},  /* 1419 */
    {1420, 1420, "183.190", "183.6.1420", 183, 4},  /* 1420 */
    {1421, 1424, "184.191", "184.1.1424", 184, 1},  /* 1421 */
    {1422, 1425, "184.192", "184.2.1425", 184, 2},  /* 1422 */
    {1423, 1426, "184.193", "184.3.1426", 184, 3},  /* 1423 */
    {1424, 1427, "184.194", "184.4.1427", 184, 3},  /* 1424 */
    {1425, 1428, "184.195", "184.5.1428", 184, 3},  /* 1425 */
    {1426, 1423, "184.196", "183.9.1423", 184, 4},  /* 1426 */
    {1427, 1429, "185.197", "185.1.1429", 185, 1},  /* 1427 */
    {1428, 1430, "185.198", "185.2.1430", 185, 2},  /* 1428 */
    {1429, 1431, "185.199", "185.3.1431", 185, 3},  /* 1429 */
    {1430, 1432, "185.200", "185.4.1432", 185, 3},  /* 1430 */
    {1431, 1433, "185.201", "185.5.1433", 185, 3},  /* 1431 */
    {1432, 1421, "185.202", "183.7.1421", 185, 4},  /* 1432 */
    {1433, 1434, "186.203", "186.1.1434", 186, 1},  /* 1433 */
    {1434, 1435, "186.204", "186.2.1435", 186, 2},  /* 1434 */
    {1435, 1436, "186.205", "186.3.1436", 186, 3},  /* 1435 */
    {1436, 1437, "186.206", "186.4.1437", 186, 3},  /* 1436 */
    {1437, 1438, "186.207", "186.5.1438", 186, 3},  /* 1437 */
    {1438, 1422, "186.208", "183.8.1422", 186, 4},  /* 1438 */
    {1439, 1439, "187.209", "187.1.1439", 187, 1},  /* 1439 */
    {1440, 1440, "187.210", "187.2.1440", 187, 2},  /* 1440 */
    {1441, 1441, "187.211", "187.3.1441", 187, 3},  /* 1441 */
    {1442, 1442, "187.212", "187.4.1442", 187, 3},  /* 1442 */
    {1443, 1443, "187.213", "187.5.1443", 187, 3},  /* 1443 */
    {1444, 1444, "187.214", "187.6.1444", 187, 4},  /* 1444 */
    {1445, 1446, "188.215", "188.1.1446", 188, 1},  /* 1445 */
    {1446, 1447, "188.216", "188.2.1447", 188, 2},  /* 1446 */
    {1447, 1448, "188.217", "188.3.1448", 188, 3},  /* 1447 */
    {1448, 1449, "188.218", "188.4.1449", 188, 3},  /* 1448 */
    {1449, 1450, "188.219", "188.5.1450", 188, 3},  /* 1449 */
    {1450, 1445, "188.220", "187.7.1445", 188, 4},  /* 1450 */
    {1451, 1451, "189.221", "189.1.1451", 189, 1},  /* 1451 */
    {1452, 1452, "189.222", "189.2.1452", 189, 2},  /* 1452 */
    {1453, 1453, "189.223", "189.3.1453", 189, 3},  /* 1453 */
    {1454, 1454, "189.224", "189.4.1454", 189, 3},  /* 1454 */
    {1455, 1455, "189.225", "189.5.1455", 189, 3},  /* 1455 */
    {1456, 1456, "189.226", "189.6.1456", 189, 4},  /* 1456 */
    {1457, 1458, "190.227", "190.1.1458", 190, 1},  /* 1457 */
    {1458, 1459, "190.228", "190.2.1459", 190, 2},  /* 1458 */
    {1459, 1460, "190.229", "190.3.1460", 190, 3},  /* 1459 */
    {1460, 1461, "190.230", "190.4.1461", 190, 3},  /* 1460 */
    {1461, 1462, "190.231", "190.5.1462", 190, 3},  /* 1461 */
    {1462, 1457, "190.232", "189.7.1457", 190, 4},  /* 1462 */
    {1463, 1463, "191.233", "191.1.1463", 191, 1},  /* 1463 */
    {1464, 1464, "191.234", "191.2.1464", 191, 2},  /* 1464 */
    {1465, 1465, "191.235", "191.3.1465", 191, 3},  /* 1465 */
    {1466, 1466, "191.236", "191.4.1466", 191, 3},  /* 1466 */
    {1467, 1467, "191.237", "191.5.1467", 191, 3},  /* 1467 */
    {1468, 1468, "191.238", "191.6.1468", 191, 3},  /* 1468 */
    {1469, 1469, "191.239", "191.7.1469", 191, 3},  /* 1469 */
    {1470, 1470, "191.240", "191.8.1470", 191, 3},  /* 1470 */
    {1471, 1471, "191.241", "191.9.1471", 191, 3},  /* 1471 */
    {1472, 1472, "191.242", "191.10.1472", 191, 4}, /* 1472 */
    {1473, 1476, "192.243", "192.1.1476", 192, 1},  /* 1473 */
    {1474, 1477, "192.244", "192.2.1477", 192, 2},  /* 1474 */
    {1475, 1478, "192.245", "192.3.1478", 192, 3},  /* 1475 */
    {1476, 1479, "192.246", "192.4.1479", 192, 3},  /* 1476 */
    {1477, 1480, "192.247", "192.5.1480", 192, 3},  /* 1477 */
    {1478, 1481, "192.248", "192.6.1481", 192, 3},  /* 1478 */
    {1479, 1482, "192.249", "192.7.1482", 192, 3},  /* 1479 */
    {1480, 1483, "192.250", "192.8.1483", 192, 3},  /* 1480 */
    {1481, 1484, "192.251", "192.9.1484", 192, 3},  /* 1481 */
    {1482, 1475, "192.252", "191.13.1475", 192, 4}, /* 1482 */
    {1483, 1485, "193.253", "193.1.1485", 193, 1},  /* 1483 */
    {1484, 1486, "193.254", "193.2.1486", 193, 2},  /* 1484 */
    {1485, 1487, "193.255", "193.3.1487", 193, 3},  /* 1485 */
    {1486, 1488, "193.256", "193.4.1488", 193, 3},  /* 1486 */
    {1487, 1489, "193.257", "193.5.1489", 193, 3},  /* 1487 */
    {1488, 1490, "193.258", "193.6.1490", 193, 3},  /* 1488 */
    {1489, 1491, "193.259", "193.7.1491", 193, 3},  /* 1489 */
    {1490, 1492, "193.260", "193.8.1492", 193, 3},  /* 1490 */
    {1491, 1493, "193.261", "193.9.1493", 193, 3},  /* 1491 */
    {1492, 1473, "193.262", "191.11.1473", 193, 4}, /* 1492 */
    {1493, 1494, "194.263", "194.1.1494", 194, 1},  /* 1493 */
    {1494, 1495, "194.264", "194.2.1495", 194, 2},  /* 1494 */
    {1495, 1496, "194.265", "194.3.1496", 194, 3},  /* 1495 */
    {1496, 1497, "194.266", "194.4.1497", 194, 3},  /* 1496 */
    {1497, 1498, "194.267", "194.5.1498", 194, 3},  /* 1497 */
    {1498, 1499, "194.268", "194.6.1499", 194, 3},  /* 1498 */
    {1499, 1500, "194.269", "194.7.1500", 194, 3},  /* 1499 */
    {1500, 1501, "194.270", "194.8.1501", 194, 3},  /* 1500 */
    {1501, 1502, "194.271", "194.9.1502", 194, 3},  /* 1501 */
    {1502, 1474, "194.272", "191.12.1474", 194, 4}, /* 1502 */
    {1503, 1503, "195.1", "195.1.1503", 195, 1},    /* 1503 */
    {1504, 1504, "195.2", "195.2.1504", 195, 2},    /* 1504 */
    {1505, 1510, "195.3", "197.3.1510", 195, 4},    /* 1505 */
    {1506, 1506, "196.4", "196.1.1506", 196, 1},    /* 1506 */
    {1507, 1507, "196.5", "196.2.1507", 196, 2},    /* 1507 */
    {1508, 1505, "196.6", "195.3.1505", 196, 4},    /* 1508 */
    {1509, 1508, "197.7", "197.1.1508", 197, 1},    /* 1509 */
    {1510, 1509, "197.8", "197.2.1509", 197, 2},    /* 1510 */
    {1511, 1511, "198.9", "198.1.1511", 198, 1},    /* 1511 */
    {1512, 1512, "198.10", "198.2.1512", 198, 2},   /* 1512 */
    {1513, 1515, "198.11", "199.3.1515", 198, 4},   /* 1513 */
    {1514, 1513, "199.12", "199.1.1513", 199, 1},   /* 1514 */
    {1515, 1514, "199.13", "199.2.1514", 199, 2},   /* 1515 */
    {1516, 1516, "200.14", "200.1.1516", 200, 1},   /* 1516 */
    {1517, 1517, "200.15", "200.2.1517", 200, 2},   /* 1517 */
    {1518, 1518, "200.16", "200.3.1518", 200, 3},   /* 1518 */
    {1519, 1533, "200.17", "204.4.1533", 200, 4},   /* 1519 */
    {1520, 1520, "201.18", "201.1.1520", 201, 1},   /* 1520 */
    {1521, 1521, "201.19", "201.2.1521", 201, 2},   /* 1521 */
    {1522, 1522, "201.20", "201.3.1522", 201, 3},   /* 1522 */
    {1523, 1534, "201.21", "204.5.1534", 201, 4},   /* 1523 */
    {1524, 1524, "202.22", "202.1.1524", 202, 1},   /* 1524 */
    {1525, 1525, "202.23", "202.2.1525", 202, 2},   /* 1525 */
    {1526, 1526, "202.24", "202.3.1526", 202, 3},   /* 1526 */
    {1527, 1519, "202.25", "200.4.1519", 202, 4},   /* 1527 */
    {1528, 1527, "203.26", "203.1.1527", 203, 1},   /* 1528 */
    {1529, 1528, "203.27", "203.2.1528", 203, 2},   /* 1529 */
    {1530, 1529, "203.28", "203.3.1529", 203, 3},   /* 1530 */
    {1531, 1523, "203.29", "201.4.1523", 203, 4},   /* 1531 */
    {1532, 1530, "204.30", "204.1.1530", 204, 1},   /* 1532 */
    {1533, 1531, "204.31", "204.2.1531", 204, 2},   /* 1533 */
    {1534, 1532, "204.32", "204.3.1532", 204, 3},   /* 1534 */
    {1535, 1535, "205.33", "205.1.1535", 205, 1},   /* 1535 */
    {1536, 1536, "205.34", "205.2.1536", 205, 2},   /* 1536 */
    {1537, 1537, "205.35", "205.3.1537", 205, 3},   /* 1537 */
    {1538, 1541, "205.36", "206.4.1541", 205, 4},   /* 1538 */
    {1539, 1538, "206.37", "206.1.1538", 206, 1},   /* 1539 */
    {1540, 1539, "206.38", "206.2.1539", 206, 2},   /* 1540 */
    {1541, 1540, "206.39", "206.3.1540", 206, 3},   /* 1541 */
    {1542, 1542, "207.40", "207.1.1542", 207, 1},   /* 1542 */
    {1543, 1543, "207.41", "207.2.1543", 207, 2},   /* 1543 */
    {1544, 1544, "207.42", "207.3.1544", 207, 3},   /* 1544 */
    {1545, 1559, "207.43", "211.4.1559", 207, 4},   /* 1545 */
    {1546, 1546, "208.44", "208.1.1546", 208, 1},   /* 1546 */
    {1547, 1547, "208.45", "208.2.1547", 208, 2},   /* 1547 */
    {1548, 1548, "208.46", "208.3.1548", 208, 3},   /* 1548 */
    {1549, 1560, "208.47", "211.5.1560", 208, 4},   /* 1549 */
    {1550, 1550, "209.48", "209.1.1550", 209, 1},   /* 1550 */
    {1551, 1551, "209.49", "209.2.1551", 209, 2},   /* 1551 */
    {1552, 1552, "209.50", "209.3.1552", 209, 3},   /* 1552 */
    {1553, 1545, "209.51", "207.4.1545", 209, 4},   /* 1553 */
    {1554, 1553, "210.52", "210.1.1553", 210, 1},   /* 1554 */
    {1555, 1554, "210.53", "210.2.1554", 210, 2},   /* 1555 */
    {1556, 1555, "210.54", "210.3.1555", 210, 3},   /* 1556 */
    {1557, 1549, "210.55", "208.4.1549", 210, 4},   /* 1557 */
    {1558, 1556, "211.56", "211.1.1556", 211, 1},   /* 1558 */
    {1559, 1557, "211.57", "211.2.1557", 211, 2},   /* 1559 */
    {1560, 1558, "211.58", "211.3.1558", 211, 3},   /* 1560 */
    {1561, 1561, "212.59", "212.1.1561", 212, 1},   /* 1561 */
    {1562, 1562, "212.60", "212.2.1562", 212, 2},   /* 1562 */
    {1563, 1563, "212.61", "212.3.1563", 212, 3},   /* 1563 */
    {1564, 1570, "212.62", "214.4.1570", 212, 4},   /* 1564 */
    {1565, 1564, "213.63", "213.1.1564", 213, 1},   /* 1565 */
    {1566, 1565, "213.64", "213.2.1565", 213, 2},   /* 1566 */
    {1567, 1566, "213.65", "213.3.1566", 213, 3},   /* 1567 */
    {1568, 1571, "213.66", "214.5.1571", 213, 4},   /* 1568 */
    {1569, 1567, "214.67", "214.1.1567", 214, 1},   /* 1569 */
    {1570, 1568, "214.68", "214.2.1568", 214, 2},   /* 1570 */
    {1571, 1569, "214.69", "214.3.1569", 214, 3},   /* 1571 */
    {1572, 1572, "215.70", "215.1.1572", 215, 1},   /* 1572 */
    {1573, 1573, "215.71", "215.2.1573", 215, 2},   /* 1573 */
    {1574, 1574, "215.72", "215.3.1574", 215, 3},   /* 1574 */
    {1575, 1583, "215.73", "217.4.1583", 215, 4},   /* 1575 */
    {1576, 1577, "216.74", "216.1.1577", 216, 1},   /* 1576 */
    {1577, 1578, "216.75", "216.2.1578", 216, 2},   /* 1577 */
    {1578, 1579, "216.76", "216.3.1579", 216, 3},   /* 1578 */
    {1579, 1575, "216.77", "215.4.1575", 216, 4},   /* 1579 */
    {1580, 1580, "217.78", "217.1.1580", 217, 1},   /* 1580 */
    {1581, 1581, "217.79", "217.2.1581", 217, 2},   /* 1581 */
    {1582, 1582, "217.80", "217.3.1582", 217, 3},   /* 1582 */
    {1583, 1585, "218.81", "218.1.1585", 218, 1},   /* 1583 */
    {1584, 1586, "218.82", "218.2.1586", 218, 2},   /* 1584 */
    {1585, 1587, "218.83", "218.3.1587", 218, 3},   /* 1585 */
    {1586, 1584, "218.84", "217.5.1584", 218, 4},   /* 1586 */
    {1587, 1588, "219.85", "219.1.1588", 219, 1},   /* 1587 */
    {1588, 1589, "219.86", "219.2.1589", 219, 2},   /* 1588 */
    {1589, 1590, "219.87", "219.3.1590", 219, 3},   /* 1589 */
    {1590, 1576, "219.88", "215.5.1576", 219, 4},   /* 1590 */
    {1591, 1591, "220.89", "220.1.1591", 220, 1},   /* 1591 */
    {1592, 1592, "220.90", "220.2.1592", 220, 2},   /* 1592 */
    {1593, 1593, "220.91", "220.3.1593", 220, 3},   /* 1593 */
    {1594, 1594, "221.92", "221.1.1594", 221, 1},   /* 1594 */
    {1595, 1595, "221.93", "221.2.1595", 221, 2},   /* 1595 */
    {1596, 1596, "221.94", "221.3.1596", 221, 3},   /* 1596 */
    {1597, 1597, "221.95", "221.4.1597", 221, 3},   /* 1597 */
    {1598, 1598, "221.96", "221.5.1598", 221, 3},   /* 1598 */
    {1599, 1643, "221.97", "229.6.1643", 221, 4},   /* 1599 */
    {1600, 1601, "222.98", "222.1.1601", 222, 1},   /* 1600 */
    {1601, 1602, "222.99", "222.2.1602", 222, 2},   /* 1601 */
    {1602, 1603, "222.100", "222.3.1603", 222, 3},  /* 1602 */
    {1603, 1604, "222.101", "222.4.1604", 222, 3},  /* 1603 */
    {1604, 1605, "222.102", "222.5.1605", 222, 3},  /* 1604 */
    {1605, 1646, "222.103", "229.9.1646", 222, 4},  /* 1605 */
    {1606, 1606, "223.104", "223.1.1606", 223, 1},  /* 1606 */
    {1607, 1607, "223.105", "223.2.1607", 223, 2},  /* 1607 */
    {1608, 1608, "223.106", "223.3.1608", 223, 3},  /* 1608 */
    {1609, 1609, "223.107", "223.4.1609", 223, 3},  /* 1609 */
    {1610, 1610, "223.108", "223.5.1610", 223, 3},  /* 1610 */
    {1611, 1645, "223.109", "229.8.1645", 223, 4},  /* 1611 */
    {1612, 1611, "224.110", "224.1.1611", 224, 1},  /* 1612 */
    {1613, 1612, "224.111", "224.2.1612", 224, 2},  /* 1613 */
    {1614, 1613, "224.112", "224.3.1613", 224, 3},  /* 1614 */
    {1615, 1614, "224.113", "224.4.1614", 224, 3},  /* 1615 */
    {1616, 1615, "224.114", "224.5.1615", 224, 3},  /* 1616 */
    {1617, 1644, "224.115", "229.7.1644", 224, 4},  /* 1617 */
    {1618, 1618, "225.116", "225.1.1618", 225, 1},  /* 1618 */
    {1619, 1619, "225.117", "225.2.1619", 225, 2},  /* 1619 */
    {1620, 1620, "225.118", "225.3.1620", 225, 3},  /* 1620 */
    {1621, 1621, "225.119", "225.4.1621", 225, 3},  /* 1621 */
    {1622, 1622, "225.120", "225.5.1622", 225, 3},  /* 1622 */
    {1623, 1599, "225.121", "221.6.1599", 225, 4},  /* 1623 */
    {1624, 1623, "226.122", "226.1.1623", 226, 1},  /* 1624 */
    {1625, 1624, "226.123", "226.2.1624", 226, 2},  /* 1625 */
    {1626, 1625, "226.124", "226.3.1625", 226, 3},  /* 1626 */
    {1627, 1626, "226.125", "226.4.1626", 226, 3},  /* 1627 */
    {1628, 1627, "226.126", "226.5.1627", 226, 3},  /* 1628 */
    {1629, 1600, "226.127", "221.7.1600", 226, 4},  /* 1629 */
    {1630, 1628, "227.128", "227.1.1628", 227, 1},  /* 1630 */
    {1631, 1629, "227.129", "227.2.1629", 227, 2},  /* 1631 */
    {1632, 1630, "227.130", "227.3.1630", 227, 3},  /* 1632 */
    {1633, 1631, "227.131", "227.4.1631", 227, 3},  /* 1633 */
    {1634, 1632, "227.132", "227.5.1632", 227, 3},  /* 1634 */
    {1635, 1616, "227.133", "224.6.1616", 227, 4},  /* 1635 */
    {1636, 1633, "228.134", "228.1.1633", 228, 1},  /* 1636 */
    {1637, 1634, "228.135", "228.2.1634", 228, 2},  /* 1637 */
    {1638, 1635, "228.136", "228.3.1635", 228, 3},  /* 1638 */
    {1639, 1636, "228.137", "228.4.1636", 228, 3},  /* 1639 */
    {1640, 1637, "228.138", "228.5.1637", 228, 3},  /* 1640 */
    {1641, 1617, "228.139", "224.7.1617", 228, 4},  /* 1641 */
    {1642, 1638, "229.140", "229.1.1638", 229, 1},  /* 1642 */
    {1643, 1639, "229.141", "229.2.1639", 229, 2},  /* 1643 */
    {1644, 1640, "229.142", "229.3.1640", 229, 3},  /* 1644 */
    {1645, 1641, "229.143", "229.4.1641", 229, 3},  /* 1645 */
    {1646, 1642, "229.144", "229.5.1642", 229, 3},  /* 1646 */
    {1647, 1647, "230.145", "230.1.1647", 230, 1},  /* 1647 */
    {1648, 1648, "230.146", "230.2.1648", 230, 2},  /* 1648 */
    {1649, 1649, "230.147", "230.3.1649", 230, 3},  /* 1649 */
    {1650, 1650, "230.148", "230.4.1650", 230, 3},  /* 1650 */
    {1651, 1651, "230.149", "230.5.1651", 230, 3},  /* 1651 */
};

/* {smallest UNI number, largest UNI number} for each Hall number */
static const int magnetic_spacegroup_hall_mapping[][2] = {
    {    0,    0 }, /* dummy */
    {    1,    3 }, /*   1 */
    {    4,    7 }, /*   2 */
    {    8,   13 }, /*   3 */
    {    8,   13 }, /*   4 */
    {    8,   13 }, /*   5 */
    {   14,   19 }, /*   6 */
    {   14,   19 }, /*   7 */
    {   14,   19 }, /*   8 */
    {   20,   24 }, /*   9 */
    {   20,   24 }, /*  10 */
    {   20,   24 }, /*  11 */
    {   20,   24 }, /*  12 */
    {   20,   24 }, /*  13 */
    {   20,   24 }, /*  14 */
    {   20,   24 }, /*  15 */
    {   20,   24 }, /*  16 */
    {   20,   24 }, /*  17 */
    {   25,   30 }, /*  18 */
    {   25,   30 }, /*  19 */
    {   25,   30 }, /*  20 */
    {   31,   38 }, /*  21 */
    {   31,   38 }, /*  22 */
    {   31,   38 }, /*  23 */
    {   31,   38 }, /*  24 */
    {   31,   38 }, /*  25 */
    {   31,   38 }, /*  26 */
    {   31,   38 }, /*  27 */
    {   31,   38 }, /*  28 */
    {   31,   38 }, /*  29 */
    {   39,   43 }, /*  30 */
    {   39,   43 }, /*  31 */
    {   39,   43 }, /*  32 */
    {   39,   43 }, /*  33 */
    {   39,   43 }, /*  34 */
    {   39,   43 }, /*  35 */
    {   39,   43 }, /*  36 */
    {   39,   43 }, /*  37 */
    {   39,   43 }, /*  38 */
    {   44,   48 }, /*  39 */
    {   44,   48 }, /*  40 */
    {   44,   48 }, /*  41 */
    {   44,   48 }, /*  42 */
    {   44,   48 }, /*  43 */
    {   44,   48 }, /*  44 */
    {   44,   48 }, /*  45 */
    {   44,   48 }, /*  46 */
    {   44,   48 }, /*  47 */
    {   44,   48 }, /*  48 */
    {   44,   48 }, /*  49 */
    {   44,   48 }, /*  50 */
    {   44,   48 }, /*  51 */
    {   44,   48 }, /*  52 */
    {   44,   48 }, /*  53 */
    {   44,   48 }, /*  54 */
    {   44,   48 }, /*  55 */
    {   44,   48 }, /*  56 */
    {   49,   56 }, /*  57 */
    {   49,   56 }, /*  58 */
    {   49,   56 }, /*  59 */
    {   57,   64 }, /*  60 */
    {   57,   64 }, /*  61 */
    {   57,   64 }, /*  62 */
    {   65,   71 }, /*  63 */
    {   65,   71 }, /*  64 */
    {   65,   71 }, /*  65 */
    {   65,   71 }, /*  66 */
    {   65,   71 }, /*  67 */
    {   65,   71 }, /*  68 */
    {   65,   71 }, /*  69 */
    {   65,   71 }, /*  70 */
    {   65,   71 }, /*  71 */
    {   72,   81 }, /*  72 */
    {   72,   81 }, /*  73 */
    {   72,   81 }, /*  74 */
    {   72,   81 }, /*  75 */
    {   72,   81 }, /*  76 */
    {   72,   81 }, /*  77 */
    {   72,   81 }, /*  78 */
    {   72,   81 }, /*  79 */
    {   72,   81 }, /*  80 */
    {   82,   91 }, /*  81 */
    {   82,   91 }, /*  82 */
    {   82,   91 }, /*  83 */
    {   82,   91 }, /*  84 */
    {   82,   91 }, /*  85 */
    {   82,   91 }, /*  86 */
    {   82,   91 }, /*  87 */
    {   82,   91 }, /*  88 */
    {   82,   91 }, /*  89 */
    {   92,   98 }, /*  90 */
    {   92,   98 }, /*  91 */
    {   92,   98 }, /*  92 */
    {   92,   98 }, /*  93 */
    {   92,   98 }, /*  94 */
    {   92,   98 }, /*  95 */
    {   92,   98 }, /*  96 */
    {   92,   98 }, /*  97 */
    {   92,   98 }, /*  98 */
    {   92,   98 }, /*  99 */
    {   92,   98 }, /* 100 */
    {   92,   98 }, /* 101 */
    {   92,   98 }, /* 102 */
    {   92,   98 }, /* 103 */
    {   92,   98 }, /* 104 */
    {   92,   98 }, /* 105 */
    {   92,   98 }, /* 106 */
    {   92,   98 }, /* 107 */
    {   99,  104 }, /* 108 */
    {  105,  113 }, /* 109 */
    {  105,  113 }, /* 110 */
    {  105,  113 }, /* 111 */
    {  114,  122 }, /* 112 */
    {  114,  122 }, /* 113 */
    {  114,  122 }, /* 114 */
    {  123,  128 }, /* 115 */
    {  129,  135 }, /* 116 */
    {  129,  135 }, /* 117 */
    {  129,  135 }, /* 118 */
    {  136,  142 }, /* 119 */
    {  136,  142 }, /* 120 */
    {  136,  142 }, /* 121 */
    {  143,  146 }, /* 122 */
    {  147,  150 }, /* 123 */
    {  151,  154 }, /* 124 */
    {  155,  163 }, /* 125 */
    {  155,  163 }, /* 126 */
    {  155,  163 }, /* 127 */
    {  164,  175 }, /* 128 */
    {  164,  175 }, /* 129 */
    {  164,  175 }, /* 130 */
    {  164,  175 }, /* 131 */
    {  164,  175 }, /* 132 */
    {  164,  175 }, /* 133 */
    {  176,  184 }, /* 134 */
    {  176,  184 }, /* 135 */
    {  176,  184 }, /* 136 */
    {  185,  196 }, /* 137 */
    {  185,  196 }, /* 138 */
    {  185,  196 }, /* 139 */
    {  185,  196 }, /* 140 */
    {  185,  196 }, /* 141 */
    {  185,  196 }, /* 142 */
    {  197,  208 }, /* 143 */
    {  197,  208 }, /* 144 */
    {  197,  208 }, /* 145 */
    {  197,  208 }, /* 146 */
    {  197,  208 }, /* 147 */
    {  197,  208 }, /* 148 */
    {  209,  220 }, /* 149 */
    {  209,  220 }, /* 150 */
    {  209,  220 }, /* 151 */
    {  209,  220 }, /* 152 */
    {  209,  220 }, /* 153 */
    {  209,  220 }, /* 154 */
    {  221,  232 }, /* 155 */
    {  221,  232 }, /* 156 */
    {  221,  232 }, /* 157 */
    {  221,  232 }, /* 158 */
    {  221,  232 }, /* 159 */
    {  221,  232 }, /* 160 */
    {  233,  241 }, /* 161 */
    {  233,  241 }, /* 162 */
    {  233,  241 }, /* 163 */
    {  242,  253 }, /* 164 */
    {  242,  253 }, /* 165 */
    {  242,  253 }, /* 166 */
    {  242,  253 }, /* 167 */
    {  242,  253 }, /* 168 */
    {  242,  253 }, /* 169 */
    {  254,  262 }, /* 170 */
    {  254,  262 }, /* 171 */
    {  254,  262 }, /* 172 */
    {  263,  269 }, /* 173 */
    {  263,  269 }, /* 174 */
    {  263,  269 }, /* 175 */
    {  270,  277 }, /* 176 */
    {  270,  277 }, /* 177 */
    {  270,  277 }, /* 178 */
    {  270,  277 }, /* 179 */
    {  270,  277 }, /* 180 */
    {  270,  277 }, /* 181 */
    {  278,  284 }, /* 182 */
    {  278,  284 }, /* 183 */
    {  278,  284 }, /* 184 */
    {  285,  292 }, /* 185 */
    {  285,  292 }, /* 186 */
    {  285,  292 }, /* 187 */
    {  285,  292 }, /* 188 */
    {  285,  292 }, /* 189 */
    {  285,  292 }, /* 190 */
    {  293,  300 }, /* 191 */
    {  293,  300 }, /* 192 */
    {  293,  300 }, /* 193 */
    {  293,  300 }, /* 194 */
    {  293,  300 }, /* 195 */
    {  293,  300 }, /* 196 */
    {  301,  308 }, /* 197 */
    {  301,  308 }, /* 198 */
    {  301,  308 }, /* 199 */
    {  301,  308 }, /* 200 */
    {  301,  308 }, /* 201 */
    {  301,  308 }, /* 202 */
    {  309,  316 }, /* 203 */
    {  309,  316 }, /* 204 */
    {  309,  316 }, /* 205 */
    {  309,  316 }, /* 206 */
    {  309,  316 }, /* 207 */
    {  309,  316 }, /* 208 */
    {  317,  321 }, /* 209 */
    {  317,  321 }, /* 210 */
    {  317,  321 }, /* 211 */
    {  322,  326 }, /* 212 */
    {  322,  326 }, /* 213 */
    {  322,  326 }, /* 214 */
    {  327,  332 }, /* 215 */
    {  327,  332 }, /* 216 */
    {  327,  332 }, /* 217 */
    {  333,  338 }, /* 218 */
    {  333,  338 }, /* 219 */
    {  333,  338 }, /* 220 */
    {  339,  346 }, /* 221 */
    {  339,  346 }, /* 222 */
    {  339,  346 }, /* 223 */
    {  339,  346 }, /* 224 */
    {  339,  346 }, /* 225 */
    {  339,  346 }, /* 226 */
    {  347,  354 }, /* 227 */
    {  355,  362 }, /* 228 */
    {  355,  362 }, /* 229 */
    {  363,  374 }, /* 230 */
    {  363,  374 }, /* 231 */
    {  363,  374 }, /* 232 */
    {  375,  386 }, /* 233 */
    {  375,  386 }, /* 234 */
    {  375,  386 }, /* 235 */
    {  375,  386 }, /* 236 */
    {  375,  386 }, /* 237 */
    {  375,  386 }, /* 238 */
    {  387,  402 }, /* 239 */
    {  387,  402 }, /* 240 */
    {  387,  402 }, /* 241 */
    {  387,  402 }, /* 242 */
    {  387,  402 }, /* 243 */
    {  387,  402 }, /* 244 */
    {  403,  418 }, /* 245 */
    {  403,  418 }, /* 246 */
    {  403,  418 }, /* 247 */
    {  403,  418 }, /* 248 */
    {  403,  418 }, /* 249 */
    {  403,  418 }, /* 250 */
    {  419,  434 }, /* 251 */
    {  419,  434 }, /* 252 */
    {  419,  434 }, /* 253 */
    {  419,  434 }, /* 254 */
    {  419,  434 }, /* 255 */
    {  419,  434 }, /* 256 */
    {  435,  450 }, /* 257 */
    {  435,  450 }, /* 258 */
    {  435,  450 }, /* 259 */
    {  435,  450 }, /* 260 */
    {  435,  450 }, /* 261 */
    {  435,  450 }, /* 262 */
    {  451,  462 }, /* 263 */
    {  451,  462 }, /* 264 */
    {  451,  462 }, /* 265 */
    {  463,  474 }, /* 266 */
    {  463,  474 }, /* 267 */
    {  463,  474 }, /* 268 */
    {  475,  490 }, /* 269 */
    {  475,  490 }, /* 270 */
    {  475,  490 }, /* 271 */
    {  475,  490 }, /* 272 */
    {  475,  490 }, /* 273 */
    {  475,  490 }, /* 274 */
    {  491,  502 }, /* 275 */
    {  491,  502 }, /* 276 */
    {  491,  502 }, /* 277 */
    {  503,  514 }, /* 278 */
    {  503,  514 }, /* 279 */
    {  503,  514 }, /* 280 */
    {  503,  514 }, /* 281 */
    {  503,  514 }, /* 282 */
    {  503,  514 }, /* 283 */
    {  515,  530 }, /* 284 */
    {  515,  530 }, /* 285 */
    {  515,  530 }, /* 286 */
    {  515,  530 }, /* 287 */
    {  515,  530 }, /* 288 */
    {  515,  530 }, /* 289 */
    {  531,  538 }, /* 290 */
    {  531,  538 }, /* 291 */
    {  539,  554 }, /* 292 */
    {  539,  554 }, /* 293 */
    {  539,  554 }, /* 294 */
    {  539,  554 }, /* 295 */
    {  539,  554 }, /* 296 */
    {  539,  554 }, /* 297 */
    {  555,  566 }, /* 298 */
    {  555,  566 }, /* 299 */
    {  555,  566 }, /* 300 */
    {  555,  566 }, /* 301 */
    {  555,  566 }, /* 302 */
    {  555,  566 }, /* 303 */
    {  567,  578 }, /* 304 */
    {  567,  578 }, /* 305 */
    {  567,  578 }, /* 306 */
    {  567,  578 }, /* 307 */
    {  567,  578 }, /* 308 */
    {  567,  578 }, /* 309 */
    {  579,  588 }, /* 310 */
    {  579,  588 }, /* 311 */
    {  579,  588 }, /* 312 */
    {  589,  598 }, /* 313 */
    {  589,  598 }, /* 314 */
    {  589,  598 }, /* 315 */
    {  599,  608 }, /* 316 */
    {  599,  608 }, /* 317 */
    {  599,  608 }, /* 318 */
    {  599,  608 }, /* 319 */
    {  599,  608 }, /* 320 */
    {  599,  608 }, /* 321 */
    {  609,  618 }, /* 322 */
    {  609,  618 }, /* 323 */
    {  609,  618 }, /* 324 */
    {  609,  618 }, /* 325 */
    {  609,  618 }, /* 326 */
    {  609,  618 }, /* 327 */
    {  609,  618 }, /* 328 */
    {  609,  618 }, /* 329 */
    {  609,  618 }, /* 330 */
    {  609,  618 }, /* 331 */
    {  609,  618 }, /* 332 */
    {  609,  618 }, /* 333 */
    {  619,  624 }, /* 334 */
    {  625,  630 }, /* 335 */
    {  625,  630 }, /* 336 */
    {  631,  636 }, /* 337 */
    {  637,  645 }, /* 338 */
    {  637,  645 }, /* 339 */
    {  637,  645 }, /* 340 */
    {  646,  651 }, /* 341 */
    {  646,  651 }, /* 342 */
    {  652,  660 }, /* 343 */
    {  652,  660 }, /* 344 */
    {  652,  660 }, /* 345 */
    {  652,  660 }, /* 346 */
    {  652,  660 }, /* 347 */
    {  652,  660 }, /* 348 */
    {  661,  666 }, /* 349 */
    {  667,  672 }, /* 350 */
    {  673,  678 }, /* 351 */
    {  679,  684 }, /* 352 */
    {  685,  688 }, /* 353 */
    {  689,  692 }, /* 354 */
    {  693,  698 }, /* 355 */
    {  699,  702 }, /* 356 */
    {  703,  710 }, /* 357 */
    {  711,  718 }, /* 358 */
    {  719,  726 }, /* 359 */
    {  719,  726 }, /* 360 */
    {  727,  734 }, /* 361 */
    {  727,  734 }, /* 362 */
    {  735,  740 }, /* 363 */
    {  741,  746 }, /* 364 */
    {  741,  746 }, /* 365 */
    {  747,  754 }, /* 366 */
    {  755,  762 }, /* 367 */
    {  763,  770 }, /* 368 */
    {  771,  778 }, /* 369 */
    {  779,  786 }, /* 370 */
    {  787,  794 }, /* 371 */
    {  795,  802 }, /* 372 */
    {  803,  810 }, /* 373 */
    {  811,  816 }, /* 374 */
    {  817,  822 }, /* 375 */
    {  823,  830 }, /* 376 */
    {  831,  838 }, /* 377 */
    {  839,  846 }, /* 378 */
    {  847,  854 }, /* 379 */
    {  855,  862 }, /* 380 */
    {  863,  870 }, /* 381 */
    {  871,  878 }, /* 382 */
    {  879,  886 }, /* 383 */
    {  887,  892 }, /* 384 */
    {  893,  898 }, /* 385 */
    {  899,  904 }, /* 386 */
    {  905,  910 }, /* 387 */
    {  911,  918 }, /* 388 */
    {  919,  926 }, /* 389 */
    {  927,  934 }, /* 390 */
    {  935,  942 }, /* 391 */
    {  943,  950 }, /* 392 */
    {  951,  958 }, /* 393 */
    {  959,  966 }, /* 394 */
    {  967,  974 }, /* 395 */
    {  975,  980 }, /* 396 */
    {  981,  986 }, /* 397 */
    {  987,  992 }, /* 398 */
    {  993,  998 }, /* 399 */
    {  999, 1010 }, /* 400 */
    { 1011, 1022 }, /* 401 */
    { 1023, 1034 }, /* 402 */
    { 1023, 1034 }, /* 403 */
    { 1035, 1046 }, /* 404 */
    { 1035, 1046 }, /* 405 */
    { 1047, 1058 }, /* 406 */
    { 1059, 1070 }, /* 407 */
    { 1071, 1082 }, /* 408 */
    { 1071, 1082 }, /* 409 */
    { 1083, 1094 }, /* 410 */
    { 1083, 1094 }, /* 411 */
    { 1095, 1106 }, /* 412 */
    { 1107, 1118 }, /* 413 */
    { 1119, 1130 }, /* 414 */
    { 1119, 1130 }, /* 415 */
    { 1131, 1142 }, /* 416 */
    { 1131, 1142 }, /* 417 */
    { 1143, 1154 }, /* 418 */
    { 1155, 1166 }, /* 419 */
    { 1167, 1178 }, /* 420 */
    { 1167, 1178 }, /* 421 */
    { 1179, 1190 }, /* 422 */
    { 1179, 1190 }, /* 423 */
    { 1191, 1200 }, /* 424 */
    { 1201, 1210 }, /* 425 */
    { 1211, 1220 }, /* 426 */
    { 1211, 1220 }, /* 427 */
    { 1221, 1230 }, /* 428 */
    { 1221, 1230 }, /* 429 */
    { 1231, 1233 }, /* 430 */
    { 1234, 1236 }, /* 431 */
    { 1237, 1239 }, /* 432 */
    { 1240, 1242 }, /* 433 */
    { 1240, 1242 }, /* 434 */
    { 1243, 1246 }, /* 435 */
    { 1247, 1250 }, /* 436 */
    { 1247, 1250 }, /* 437 */
    { 1251, 1254 }, /* 438 */
    { 1255, 1258 }, /* 439 */
    { 1259, 1262 }, /* 440 */
    { 1263, 1266 }, /* 441 */
    { 1267, 1270 }, /* 442 */
    { 1271, 1274 }, /* 443 */
    { 1275, 1278 }, /* 444 */
    { 1275, 1278 }, /* 445 */
    { 1279, 1282 }, /* 446 */
    { 1283, 1286 }, /* 447 */
    { 1287, 1290 }, /* 448 */
    { 1291, 1294 }, /* 449 */
    { 1295, 1298 }, /* 450 */
    { 1295, 1298 }, /* 451 */
    { 1299, 1302 }, /* 452 */
    { 1299, 1302 }, /* 453 */
    { 1303, 1308 }, /* 454 */
    { 1309, 1314 }, /* 455 */
    { 1315, 1320 }, /* 456 */
    { 1321, 1326 }, /* 457 */
    { 1327, 1332 }, /* 458 */
    { 1327, 1332 }, /* 459 */
    { 1333, 1338 }, /* 460 */
    { 1333, 1338 }, /* 461 */
    { 1339, 1342 }, /* 462 */
    { 1343, 1346 }, /* 463 */
    { 1347, 1350 }, /* 464 */
    { 1351, 1354 }, /* 465 */
    { 1355, 1358 }, /* 466 */
    { 1359, 1362 }, /* 467 */
    { 1363, 1366 }, /* 468 */
    { 1367, 1372 }, /* 469 */
    { 1373, 1378 }, /* 470 */
    { 1379, 1384 }, /* 471 */
    { 1385, 1390 }, /* 472 */
    { 1391, 1396 }, /* 473 */
    { 1397, 1402 }, /* 474 */
    { 1403, 1408 }, /* 475 */
    { 1409, 1414 }, /* 476 */
    { 1415, 1420 }, /* 477 */
    { 1421, 1426 }, /* 478 */
    { 1427, 1432 }, /* 479 */
    { 1433, 1438 }, /* 480 */
    { 1439, 1444 }, /* 481 */
    { 1445, 1450 }, /* 482 */
    { 1451, 1456 }, /* 483 */
    { 1457, 1462 }, /* 484 */
    { 1463, 1472 }, /* 485 */
    { 1473, 1482 }, /* 486 */
    { 1483, 1492 }, /* 487 */
    { 1493, 1502 }, /* 488 */
    { 1503, 1505 }, /* 489 */
    { 1506, 1508 }, /* 490 */
    { 1509, 1510 }, /* 491 */
    { 1511, 1513 }, /* 492 */
    { 1514, 1515 }, /* 493 */
    { 1516, 1519 }, /* 494 */
    { 1520, 1523 }, /* 495 */
    { 1520, 1523 }, /* 496 */
    { 1524, 1527 }, /* 497 */
    { 1528, 1531 }, /* 498 */
    { 1528, 1531 }, /* 499 */
    { 1532, 1534 }, /* 500 */
    { 1535, 1538 }, /* 501 */
    { 1539, 1541 }, /* 502 */
    { 1542, 1545 }, /* 503 */
    { 1546, 1549 }, /* 504 */
    { 1550, 1553 }, /* 505 */
    { 1554, 1557 }, /* 506 */
    { 1558, 1560 }, /* 507 */
    { 1561, 1564 }, /* 508 */
    { 1565, 1568 }, /* 509 */
    { 1569, 1571 }, /* 510 */
    { 1572, 1575 }, /* 511 */
    { 1576, 1579 }, /* 512 */
    { 1580, 1582 }, /* 513 */
    { 1583, 1586 }, /* 514 */
    { 1587, 1590 }, /* 515 */
    { 1591, 1593 }, /* 516 */
    { 1594, 1599 }, /* 517 */
    { 1600, 1605 }, /* 518 */
    { 1600, 1605 }, /* 519 */
    { 1606, 1611 }, /* 520 */
    { 1612, 1617 }, /* 521 */
    { 1612, 1617 }, /* 522 */
    { 1618, 1623 }, /* 523 */
    { 1624, 1629 }, /* 524 */
    { 1630, 1635 }, /* 525 */
    { 1630, 1635 }, /* 526 */
    { 1636, 1641 }, /* 527 */
    { 1636, 1641 }, /* 528 */
    { 1642, 1646 }, /* 529 */
    { 1647, 1651 }, /* 530 */
};

MagneticSpacegroupType msgdb_get_magnetic_spacegroup_type(
    const int uni_number) {
    MagneticSpacegroupType msgtype;

    if (uni_number > 0 && uni_number <= 1651) {
        msgtype = magnetic_spacegroup_types[uni_number];
    } else {
        /* out of range */
        msgtype = magnetic_spacegroup_types[0];
    }

    return msgtype;
}

/* Return smallest and largest UNI numbers for Hall number */
void msgdb_get_uni_candidates(int uni_number_range[2], const int hall_number) {
   uni_number_range[0] = magnetic_spacegroup_hall_mapping[hall_number][0];
   uni_number_range[1] = magnetic_spacegroup_hall_mapping[hall_number][1];
}

/* {number of Hall symbols, the smallest Hall number} for each UNI number */
static const int magnetic_spacegroup_uni_mapping[][2] = {
    {0, 0},    /* dummy */
    {1, 1},    /* 1 */
    {1, 1},    /* 2 */
    {1, 1},    /* 3 */
    {1, 2},    /* 4 */
    {1, 2},    /* 5 */
    {1, 2},    /* 6 */
    {1, 2},    /* 7 */
    {3, 3},    /* 8 */
    {3, 3},    /* 9 */
    {3, 3},    /* 10 */
    {3, 3},    /* 11 */
    {3, 3},    /* 12 */
    {3, 3},    /* 13 */
    {3, 6},    /* 14 */
    {3, 6},    /* 15 */
    {3, 6},    /* 16 */
    {3, 6},    /* 17 */
    {3, 6},    /* 18 */
    {3, 6},    /* 19 */
    {9, 9},    /* 20 */
    {9, 9},    /* 21 */
    {9, 9},    /* 22 */
    {9, 9},    /* 23 */
    {9, 9},    /* 24 */
    {3, 18},   /* 25 */
    {3, 18},   /* 26 */
    {3, 18},   /* 27 */
    {3, 18},   /* 28 */
    {3, 18},   /* 29 */
    {3, 18},   /* 30 */
    {9, 21},   /* 31 */
    {9, 21},   /* 32 */
    {9, 21},   /* 33 */
    {9, 21},   /* 34 */
    {9, 21},   /* 35 */
    {9, 21},   /* 36 */
    {9, 21},   /* 37 */
    {9, 21},   /* 38 */
    {9, 30},   /* 39 */
    {9, 30},   /* 40 */
    {9, 30},   /* 41 */
    {9, 30},   /* 42 */
    {9, 30},   /* 43 */
    {18, 39},  /* 44 */
    {18, 39},  /* 45 */
    {18, 39},  /* 46 */
    {18, 39},  /* 47 */
    {18, 39},  /* 48 */
    {3, 57},   /* 49 */
    {3, 57},   /* 50 */
    {3, 57},   /* 51 */
    {3, 57},   /* 52 */
    {3, 57},   /* 53 */
    {3, 57},   /* 54 */
    {3, 57},   /* 55 */
    {3, 57},   /* 56 */
    {3, 60},   /* 57 */
    {3, 60},   /* 58 */
    {3, 60},   /* 59 */
    {3, 60},   /* 60 */
    {3, 60},   /* 61 */
    {3, 60},   /* 62 */
    {3, 60},   /* 63 */
    {3, 60},   /* 64 */
    {9, 63},   /* 65 */
    {9, 63},   /* 66 */
    {9, 63},   /* 67 */
    {9, 63},   /* 68 */
    {9, 63},   /* 69 */
    {9, 63},   /* 70 */
    {9, 63},   /* 71 */
    {9, 72},   /* 72 */
    {9, 72},   /* 73 */
    {9, 72},   /* 74 */
    {9, 72},   /* 75 */
    {9, 72},   /* 76 */
    {9, 72},   /* 77 */
    {9, 72},   /* 78 */
    {9, 72},   /* 79 */
    {9, 72},   /* 80 */
    {9, 72},   /* 81 */
    {9, 81},   /* 82 */
    {9, 81},   /* 83 */
    {9, 81},   /* 84 */
    {9, 81},   /* 85 */
    {9, 81},   /* 86 */
    {9, 81},   /* 87 */
    {9, 81},   /* 88 */
    {9, 81},   /* 89 */
    {9, 81},   /* 90 */
    {9, 81},   /* 91 */
    {18, 90},  /* 92 */
    {18, 90},  /* 93 */
    {18, 90},  /* 94 */
    {18, 90},  /* 95 */
    {18, 90},  /* 96 */
    {18, 90},  /* 97 */
    {18, 90},  /* 98 */
    {1, 108},  /* 99 */
    {1, 108},  /* 100 */
    {1, 108},  /* 101 */
    {1, 108},  /* 102 */
    {1, 108},  /* 103 */
    {1, 108},  /* 104 */
    {3, 109},  /* 105 */
    {3, 109},  /* 106 */
    {3, 109},  /* 107 */
    {3, 109},  /* 108 */
    {3, 109},  /* 109 */
    {3, 109},  /* 110 */
    {3, 109},  /* 111 */
    {3, 109},  /* 112 */
    {3, 109},  /* 113 */
    {3, 112},  /* 114 */
    {3, 112},  /* 115 */
    {3, 112},  /* 116 */
    {3, 112},  /* 117 */
    {3, 112},  /* 118 */
    {3, 112},  /* 119 */
    {3, 112},  /* 120 */
    {3, 112},  /* 121 */
    {3, 112},  /* 122 */
    {1, 115},  /* 123 */
    {1, 115},  /* 124 */
    {1, 115},  /* 125 */
    {1, 115},  /* 126 */
    {1, 115},  /* 127 */
    {1, 115},  /* 128 */
    {3, 116},  /* 129 */
    {3, 116},  /* 130 */
    {3, 116},  /* 131 */
    {3, 116},  /* 132 */
    {3, 116},  /* 133 */
    {3, 116},  /* 134 */
    {3, 116},  /* 135 */
    {3, 119},  /* 136 */
    {3, 119},  /* 137 */
    {3, 119},  /* 138 */
    {3, 119},  /* 139 */
    {3, 119},  /* 140 */
    {3, 119},  /* 141 */
    {3, 119},  /* 142 */
    {1, 122},  /* 143 */
    {1, 122},  /* 144 */
    {1, 122},  /* 145 */
    {1, 122},  /* 146 */
    {1, 123},  /* 147 */
    {1, 123},  /* 148 */
    {1, 123},  /* 149 */
    {1, 123},  /* 150 */
    {1, 124},  /* 151 */
    {1, 124},  /* 152 */
    {1, 124},  /* 153 */
    {1, 124},  /* 154 */
    {3, 125},  /* 155 */
    {3, 125},  /* 156 */
    {3, 125},  /* 157 */
    {3, 125},  /* 158 */
    {3, 125},  /* 159 */
    {3, 125},  /* 160 */
    {3, 125},  /* 161 */
    {3, 125},  /* 162 */
    {3, 125},  /* 163 */
    {6, 128},  /* 164 */
    {6, 128},  /* 165 */
    {6, 128},  /* 166 */
    {6, 128},  /* 167 */
    {6, 128},  /* 168 */
    {6, 128},  /* 169 */
    {6, 128},  /* 170 */
    {6, 128},  /* 171 */
    {6, 128},  /* 172 */
    {6, 128},  /* 173 */
    {6, 128},  /* 174 */
    {6, 128},  /* 175 */
    {3, 134},  /* 176 */
    {3, 134},  /* 177 */
    {3, 134},  /* 178 */
    {3, 134},  /* 179 */
    {3, 134},  /* 180 */
    {3, 134},  /* 181 */
    {3, 134},  /* 182 */
    {3, 134},  /* 183 */
    {3, 134},  /* 184 */
    {6, 137},  /* 185 */
    {6, 137},  /* 186 */
    {6, 137},  /* 187 */
    {6, 137},  /* 188 */
    {6, 137},  /* 189 */
    {6, 137},  /* 190 */
    {6, 137},  /* 191 */
    {6, 137},  /* 192 */
    {6, 137},  /* 193 */
    {6, 137},  /* 194 */
    {6, 137},  /* 195 */
    {6, 137},  /* 196 */
    {6, 143},  /* 197 */
    {6, 143},  /* 198 */
    {6, 143},  /* 199 */
    {6, 143},  /* 200 */
    {6, 143},  /* 201 */
    {6, 143},  /* 202 */
    {6, 143},  /* 203 */
    {6, 143},  /* 204 */
    {6, 143},  /* 205 */
    {6, 143},  /* 206 */
    {6, 143},  /* 207 */
    {6, 143},  /* 208 */
    {6, 149},  /* 209 */
    {6, 149},  /* 210 */
    {6, 149},  /* 211 */
    {6, 149},  /* 212 */
    {6, 149},  /* 213 */
    {6, 149},  /* 214 */
    {6, 149},  /* 215 */
    {6, 149},  /* 216 */
    {6, 149},  /* 217 */
    {6, 149},  /* 218 */
    {6, 149},  /* 219 */
    {6, 149},  /* 220 */
    {6, 155},  /* 221 */
    {6, 155},  /* 222 */
    {6, 155},  /* 223 */
    {6, 155},  /* 224 */
    {6, 155},  /* 225 */
    {6, 155},  /* 226 */
    {6, 155},  /* 227 */
    {6, 155},  /* 228 */
    {6, 155},  /* 229 */
    {6, 155},  /* 230 */
    {6, 155},  /* 231 */
    {6, 155},  /* 232 */
    {3, 161},  /* 233 */
    {3, 161},  /* 234 */
    {3, 161},  /* 235 */
    {3, 161},  /* 236 */
    {3, 161},  /* 237 */
    {3, 161},  /* 238 */
    {3, 161},  /* 239 */
    {3, 161},  /* 240 */
    {3, 161},  /* 241 */
    {6, 164},  /* 242 */
    {6, 164},  /* 243 */
    {6, 164},  /* 244 */
    {6, 164},  /* 245 */
    {6, 164},  /* 246 */
    {6, 164},  /* 247 */
    {6, 164},  /* 248 */
    {6, 164},  /* 249 */
    {6, 164},  /* 250 */
    {6, 164},  /* 251 */
    {6, 164},  /* 252 */
    {6, 164},  /* 253 */
    {3, 170},  /* 254 */
    {3, 170},  /* 255 */
    {3, 170},  /* 256 */
    {3, 170},  /* 257 */
    {3, 170},  /* 258 */
    {3, 170},  /* 259 */
    {3, 170},  /* 260 */
    {3, 170},  /* 261 */
    {3, 170},  /* 262 */
    {3, 173},  /* 263 */
    {3, 173},  /* 264 */
    {3, 173},  /* 265 */
    {3, 173},  /* 266 */
    {3, 173},  /* 267 */
    {3, 173},  /* 268 */
    {3, 173},  /* 269 */
    {6, 176},  /* 270 */
    {6, 176},  /* 271 */
    {6, 176},  /* 272 */
    {6, 176},  /* 273 */
    {6, 176},  /* 274 */
    {6, 176},  /* 275 */
    {6, 176},  /* 276 */
    {6, 176},  /* 277 */
    {3, 182},  /* 278 */
    {3, 182},  /* 279 */
    {3, 182},  /* 280 */
    {3, 182},  /* 281 */
    {3, 182},  /* 282 */
    {3, 182},  /* 283 */
    {3, 182},  /* 284 */
    {6, 185},  /* 285 */
    {6, 185},  /* 286 */
    {6, 185},  /* 287 */
    {6, 185},  /* 288 */
    {6, 185},  /* 289 */
    {6, 185},  /* 290 */
    {6, 185},  /* 291 */
    {6, 185},  /* 292 */
    {6, 191},  /* 293 */
    {6, 191},  /* 294 */
    {6, 191},  /* 295 */
    {6, 191},  /* 296 */
    {6, 191},  /* 297 */
    {6, 191},  /* 298 */
    {6, 191},  /* 299 */
    {6, 191},  /* 300 */
    {6, 197},  /* 301 */
    {6, 197},  /* 302 */
    {6, 197},  /* 303 */
    {6, 197},  /* 304 */
    {6, 197},  /* 305 */
    {6, 197},  /* 306 */
    {6, 197},  /* 307 */
    {6, 197},  /* 308 */
    {6, 203},  /* 309 */
    {6, 203},  /* 310 */
    {6, 203},  /* 311 */
    {6, 203},  /* 312 */
    {6, 203},  /* 313 */
    {6, 203},  /* 314 */
    {6, 203},  /* 315 */
    {6, 203},  /* 316 */
    {3, 209},  /* 317 */
    {3, 209},  /* 318 */
    {3, 209},  /* 319 */
    {3, 209},  /* 320 */
    {3, 209},  /* 321 */
    {3, 212},  /* 322 */
    {3, 212},  /* 323 */
    {3, 212},  /* 324 */
    {3, 212},  /* 325 */
    {3, 212},  /* 326 */
    {3, 215},  /* 327 */
    {3, 215},  /* 328 */
    {3, 215},  /* 329 */
    {3, 215},  /* 330 */
    {3, 215},  /* 331 */
    {3, 215},  /* 332 */
    {3, 218},  /* 333 */
    {3, 218},  /* 334 */
    {3, 218},  /* 335 */
    {3, 218},  /* 336 */
    {3, 218},  /* 337 */
    {3, 218},  /* 338 */
    {6, 221},  /* 339 */
    {6, 221},  /* 340 */
    {6, 221},  /* 341 */
    {6, 221},  /* 342 */
    {6, 221},  /* 343 */
    {6, 221},  /* 344 */
    {6, 221},  /* 345 */
    {6, 221},  /* 346 */
    {1, 227},  /* 347 */
    {1, 227},  /* 348 */
    {1, 227},  /* 349 */
    {1, 227},  /* 350 */
    {1, 227},  /* 351 */
    {1, 227},  /* 352 */
    {1, 227},  /* 353 */
    {1, 227},  /* 354 */
    {2, 228},  /* 355 */
    {2, 228},  /* 356 */
    {2, 228},  /* 357 */
    {2, 228},  /* 358 */
    {2, 228},  /* 359 */
    {2, 228},  /* 360 */
    {2, 228},  /* 361 */
    {2, 228},  /* 362 */
    {3, 230},  /* 363 */
    {3, 230},  /* 364 */
    {3, 230},  /* 365 */
    {3, 230},  /* 366 */
    {3, 230},  /* 367 */
    {3, 230},  /* 368 */
    {3, 230},  /* 369 */
    {3, 230},  /* 370 */
    {3, 230},  /* 371 */
    {3, 230},  /* 372 */
    {3, 230},  /* 373 */
    {3, 230},  /* 374 */
    {6, 233},  /* 375 */
    {6, 233},  /* 376 */
    {6, 233},  /* 377 */
    {6, 233},  /* 378 */
    {6, 233},  /* 379 */
    {6, 233},  /* 380 */
    {6, 233},  /* 381 */
    {6, 233},  /* 382 */
    {6, 233},  /* 383 */
    {6, 233},  /* 384 */
    {6, 233},  /* 385 */
    {6, 233},  /* 386 */
    {6, 239},  /* 387 */
    {6, 239},  /* 388 */
    {6, 239},  /* 389 */
    {6, 239},  /* 390 */
    {6, 239},  /* 391 */
    {6, 239},  /* 392 */
    {6, 239},  /* 393 */
    {6, 239},  /* 394 */
    {6, 239},  /* 395 */
    {6, 239},  /* 396 */
    {6, 239},  /* 397 */
    {6, 239},  /* 398 */
    {6, 239},  /* 399 */
    {6, 239},  /* 400 */
    {6, 239},  /* 401 */
    {6, 239},  /* 402 */
    {6, 245},  /* 403 */
    {6, 245},  /* 404 */
    {6, 245},  /* 405 */
    {6, 245},  /* 406 */
    {6, 245},  /* 407 */
    {6, 245},  /* 408 */
    {6, 245},  /* 409 */
    {6, 245},  /* 410 */
    {6, 245},  /* 411 */
    {6, 245},  /* 412 */
    {6, 245},  /* 413 */
    {6, 245},  /* 414 */
    {6, 245},  /* 415 */
    {6, 245},  /* 416 */
    {6, 245},  /* 417 */
    {6, 245},  /* 418 */
    {6, 251},  /* 419 */
    {6, 251},  /* 420 */
    {6, 251},  /* 421 */
    {6, 251},  /* 422 */
    {6, 251},  /* 423 */
    {6, 251},  /* 424 */
    {6, 251},  /* 425 */
    {6, 251},  /* 426 */
    {6, 251},  /* 427 */
    {6, 251},  /* 428 */
    {6, 251},  /* 429 */
    {6, 251},  /* 430 */
    {6, 251},  /* 431 */
    {6, 251},  /* 432 */
    {6, 251},  /* 433 */
    {6, 251},  /* 434 */
    {6, 257},  /* 435 */
    {6, 257},  /* 436 */
    {6, 257},  /* 437 */
    {6, 257},  /* 438 */
    {6, 257},  /* 439 */
    {6, 257},  /* 440 */
    {6, 257},  /* 441 */
    {6, 257},  /* 442 */
    {6, 257},  /* 443 */
    {6, 257},  /* 444 */
    {6, 257},  /* 445 */
    {6, 257},  /* 446 */
    {6, 257},  /* 447 */
    {6, 257},  /* 448 */
    {6, 257},  /* 449 */
    {6, 257},  /* 450 */
    {3, 263},  /* 451 */
    {3, 263},  /* 452 */
    {3, 263},  /* 453 */
    {3, 263},  /* 454 */
    {3, 263},  /* 455 */
    {3, 263},  /* 456 */
    {3, 263},  /* 457 */
    {3, 263},  /* 458 */
    {3, 263},  /* 459 */
    {3, 263},  /* 460 */
    {3, 263},  /* 461 */
    {3, 263},  /* 462 */
    {3, 266},  /* 463 */
    {3, 266},  /* 464 */
    {3, 266},  /* 465 */
    {3, 266},  /* 466 */
    {3, 266},  /* 467 */
    {3, 266},  /* 468 */
    {3, 266},  /* 469 */
    {3, 266},  /* 470 */
    {3, 266},  /* 471 */
    {3, 266},  /* 472 */
    {3, 266},  /* 473 */
    {3, 266},  /* 474 */
    {6, 269},  /* 475 */
    {6, 269},  /* 476 */
    {6, 269},  /* 477 */
    {6, 269},  /* 478 */
    {6, 269},  /* 479 */
    {6, 269},  /* 480 */
    {6, 269},  /* 481 */
    {6, 269},  /* 482 */
    {6, 269},  /* 483 */
    {6, 269},  /* 484 */
    {6, 269},  /* 485 */
    {6, 269},  /* 486 */
    {6, 269},  /* 487 */
    {6, 269},  /* 488 */
    {6, 269},  /* 489 */
    {6, 269},  /* 490 */
    {3, 275},  /* 491 */
    {3, 275},  /* 492 */
    {3, 275},  /* 493 */
    {3, 275},  /* 494 */
    {3, 275},  /* 495 */
    {3, 275},  /* 496 */
    {3, 275},  /* 497 */
    {3, 275},  /* 498 */
    {3, 275},  /* 499 */
    {3, 275},  /* 500 */
    {3, 275},  /* 501 */
    {3, 275},  /* 502 */
    {6, 278},  /* 503 */
    {6, 278},  /* 504 */
    {6, 278},  /* 505 */
    {6, 278},  /* 506 */
    {6, 278},  /* 507 */
    {6, 278},  /* 508 */
    {6, 278},  /* 509 */
    {6, 278},  /* 510 */
    {6, 278},  /* 511 */
    {6, 278},  /* 512 */
    {6, 278},  /* 513 */
    {6, 278},  /* 514 */
    {6, 284},  /* 515 */
    {6, 284},  /* 516 */
    {6, 284},  /* 517 */
    {6, 284},  /* 518 */
    {6, 284},  /* 519 */
    {6, 284},  /* 520 */
    {6, 284},  /* 521 */
    {6, 284},  /* 522 */
    {6, 284},  /* 523 */
    {6, 284},  /* 524 */
    {6, 284},  /* 525 */
    {6, 284},  /* 526 */
    {6, 284},  /* 527 */
    {6, 284},  /* 528 */
    {6, 284},  /* 529 */
    {6, 284},  /* 530 */
    {2, 290},  /* 531 */
    {2, 290},  /* 532 */
    {2, 290},  /* 533 */
    {2, 290},  /* 534 */
    {2, 290},  /* 535 */
    {2, 290},  /* 536 */
    {2, 290},  /* 537 */
    {2, 290},  /* 538 */
    {6, 292},  /* 539 */
    {6, 292},  /* 540 */
    {6, 292},  /* 541 */
    {6, 292},  /* 542 */
    {6, 292},  /* 543 */
    {6, 292},  /* 544 */
    {6, 292},  /* 545 */
    {6, 292},  /* 546 */
    {6, 292},  /* 547 */
    {6, 292},  /* 548 */
    {6, 292},  /* 549 */
    {6, 292},  /* 550 */
    {6, 292},  /* 551 */
    {6, 292},  /* 552 */
    {6, 292},  /* 553 */
    {6, 292},  /* 554 */
    {6, 298},  /* 555 */
    {6, 298},  /* 556 */
    {6, 298},  /* 557 */
    {6, 298},  /* 558 */
    {6, 298},  /* 559 */
    {6, 298},  /* 560 */
    {6, 298},  /* 561 */
    {6, 298},  /* 562 */
    {6, 298},  /* 563 */
    {6, 298},  /* 564 */
    {6, 298},  /* 565 */
    {6, 298},  /* 566 */
    {6, 304},  /* 567 */
    {6, 304},  /* 568 */
    {6, 304},  /* 569 */
    {6, 304},  /* 570 */
    {6, 304},  /* 571 */
    {6, 304},  /* 572 */
    {6, 304},  /* 573 */
    {6, 304},  /* 574 */
    {6, 304},  /* 575 */
    {6, 304},  /* 576 */
    {6, 304},  /* 577 */
    {6, 304},  /* 578 */
    {3, 310},  /* 579 */
    {3, 310},  /* 580 */
    {3, 310},  /* 581 */
    {3, 310},  /* 582 */
    {3, 310},  /* 583 */
    {3, 310},  /* 584 */
    {3, 310},  /* 585 */
    {3, 310},  /* 586 */
    {3, 310},  /* 587 */
    {3, 310},  /* 588 */
    {3, 313},  /* 589 */
    {3, 313},  /* 590 */
    {3, 313},  /* 591 */
    {3, 313},  /* 592 */
    {3, 313},  /* 593 */
    {3, 313},  /* 594 */
    {3, 313},  /* 595 */
    {3, 313},  /* 596 */
    {3, 313},  /* 597 */
    {3, 313},  /* 598 */
    {6, 316},  /* 599 */
    {6, 316},  /* 600 */
    {6, 316},  /* 601 */
    {6, 316},  /* 602 */
    {6, 316},  /* 603 */
    {6, 316},  /* 604 */
    {6, 316},  /* 605 */
    {6, 316},  /* 606 */
    {6, 316},  /* 607 */
    {6, 316},  /* 608 */
    {12, 322}, /* 609 */
    {12, 322}, /* 610 */
    {12, 322}, /* 611 */
    {12, 322}, /* 612 */
    {12, 322}, /* 613 */
    {12, 322}, /* 614 */
    {12, 322}, /* 615 */
    {12, 322}, /* 616 */
    {12, 322}, /* 617 */
    {12, 322}, /* 618 */
    {1, 334},  /* 619 */
    {1, 334},  /* 620 */
    {1, 334},  /* 621 */
    {1, 334},  /* 622 */
    {1, 334},  /* 623 */
    {1, 334},  /* 624 */
    {2, 335},  /* 625 */
    {2, 335},  /* 626 */
    {2, 335},  /* 627 */
    {2, 335},  /* 628 */
    {2, 335},  /* 629 */
    {2, 335},  /* 630 */
    {1, 337},  /* 631 */
    {1, 337},  /* 632 */
    {1, 337},  /* 633 */
    {1, 337},  /* 634 */
    {1, 337},  /* 635 */
    {1, 337},  /* 636 */
    {3, 338},  /* 637 */
    {3, 338},  /* 638 */
    {3, 338},  /* 639 */
    {3, 338},  /* 640 */
    {3, 338},  /* 641 */
    {3, 338},  /* 642 */
    {3, 338},  /* 643 */
    {3, 338},  /* 644 */
    {3, 338},  /* 645 */
    {2, 341},  /* 646 */
    {2, 341},  /* 647 */
    {2, 341},  /* 648 */
    {2, 341},  /* 649 */
    {2, 341},  /* 650 */
    {2, 341},  /* 651 */
    {6, 343},  /* 652 */
    {6, 343},  /* 653 */
    {6, 343},  /* 654 */
    {6, 343},  /* 655 */
    {6, 343},  /* 656 */
    {6, 343},  /* 657 */
    {6, 343},  /* 658 */
    {6, 343},  /* 659 */
    {6, 343},  /* 660 */
    {1, 349},  /* 661 */
    {1, 349},  /* 662 */
    {1, 349},  /* 663 */
    {1, 349},  /* 664 */
    {1, 349},  /* 665 */
    {1, 349},  /* 666 */
    {1, 350},  /* 667 */
    {1, 350},  /* 668 */
    {1, 350},  /* 669 */
    {1, 350},  /* 670 */
    {1, 350},  /* 671 */
    {1, 350},  /* 672 */
    {1, 351},  /* 673 */
    {1, 351},  /* 674 */
    {1, 351},  /* 675 */
    {1, 351},  /* 676 */
    {1, 351},  /* 677 */
    {1, 351},  /* 678 */
    {1, 352},  /* 679 */
    {1, 352},  /* 680 */
    {1, 352},  /* 681 */
    {1, 352},  /* 682 */
    {1, 352},  /* 683 */
    {1, 352},  /* 684 */
    {1, 353},  /* 685 */
    {1, 353},  /* 686 */
    {1, 353},  /* 687 */
    {1, 353},  /* 688 */
    {1, 354},  /* 689 */
    {1, 354},  /* 690 */
    {1, 354},  /* 691 */
    {1, 354},  /* 692 */
    {1, 355},  /* 693 */
    {1, 355},  /* 694 */
    {1, 355},  /* 695 */
    {1, 355},  /* 696 */
    {1, 355},  /* 697 */
    {1, 355},  /* 698 */
    {1, 356},  /* 699 */
    {1, 356},  /* 700 */
    {1, 356},  /* 701 */
    {1, 356},  /* 702 */
    {1, 357},  /* 703 */
    {1, 357},  /* 704 */
    {1, 357},  /* 705 */
    {1, 357},  /* 706 */
    {1, 357},  /* 707 */
    {1, 357},  /* 708 */
    {1, 357},  /* 709 */
    {1, 357},  /* 710 */
    {1, 358},  /* 711 */
    {1, 358},  /* 712 */
    {1, 358},  /* 713 */
    {1, 358},  /* 714 */
    {1, 358},  /* 715 */
    {1, 358},  /* 716 */
    {1, 358},  /* 717 */
    {1, 358},  /* 718 */
    {2, 359},  /* 719 */
    {2, 359},  /* 720 */
    {2, 359},  /* 721 */
    {2, 359},  /* 722 */
    {2, 359},  /* 723 */
    {2, 359},  /* 724 */
    {2, 359},  /* 725 */
    {2, 359},  /* 726 */
    {2, 361},  /* 727 */
    {2, 361},  /* 728 */
    {2, 361},  /* 729 */
    {2, 361},  /* 730 */
    {2, 361},  /* 731 */
    {2, 361},  /* 732 */
    {2, 361},  /* 733 */
    {2, 361},  /* 734 */
    {1, 363},  /* 735 */
    {1, 363},  /* 736 */
    {1, 363},  /* 737 */
    {1, 363},  /* 738 */
    {1, 363},  /* 739 */
    {1, 363},  /* 740 */
    {2, 364},  /* 741 */
    {2, 364},  /* 742 */
    {2, 364},  /* 743 */
    {2, 364},  /* 744 */
    {2, 364},  /* 745 */
    {2, 364},  /* 746 */
    {1, 366},  /* 747 */
    {1, 366},  /* 748 */
    {1, 366},  /* 749 */
    {1, 366},  /* 750 */
    {1, 366},  /* 751 */
    {1, 366},  /* 752 */
    {1, 366},  /* 753 */
    {1, 366},  /* 754 */
    {1, 367},  /* 755 */
    {1, 367},  /* 756 */
    {1, 367},  /* 757 */
    {1, 367},  /* 758 */
    {1, 367},  /* 759 */
    {1, 367},  /* 760 */
    {1, 367},  /* 761 */
    {1, 367},  /* 762 */
    {1, 368},  /* 763 */
    {1, 368},  /* 764 */
    {1, 368},  /* 765 */
    {1, 368},  /* 766 */
    {1, 368},  /* 767 */
    {1, 368},  /* 768 */
    {1, 368},  /* 769 */
    {1, 368},  /* 770 */
    {1, 369},  /* 771 */
    {1, 369},  /* 772 */
    {1, 369},  /* 773 */
    {1, 369},  /* 774 */
    {1, 369},  /* 775 */
    {1, 369},  /* 776 */
    {1, 369},  /* 777 */
    {1, 369},  /* 778 */
    {1, 370},  /* 779 */
    {1, 370},  /* 780 */
    {1, 370},  /* 781 */
    {1, 370},  /* 782 */
    {1, 370},  /* 783 */
    {1, 370},  /* 784 */
    {1, 370},  /* 785 */
    {1, 370},  /* 786 */
    {1, 371},  /* 787 */
    {1, 371},  /* 788 */
    {1, 371},  /* 789 */
    {1, 371},  /* 790 */
    {1, 371},  /* 791 */
    {1, 371},  /* 792 */
    {1, 371},  /* 793 */
    {1, 371},  /* 794 */
    {1, 372},  /* 795 */
    {1, 372},  /* 796 */
    {1, 372},  /* 797 */
    {1, 372},  /* 798 */
    {1, 372},  /* 799 */
    {1, 372},  /* 800 */
    {1, 372},  /* 801 */
    {1, 372},  /* 802 */
    {1, 373},  /* 803 */
    {1, 373},  /* 804 */
    {1, 373},  /* 805 */
    {1, 373},  /* 806 */
    {1, 373},  /* 807 */
    {1, 373},  /* 808 */
    {1, 373},  /* 809 */
    {1, 373},  /* 810 */
    {1, 374},  /* 811 */
    {1, 374},  /* 812 */
    {1, 374},  /* 813 */
    {1, 374},  /* 814 */
    {1, 374},  /* 815 */
    {1, 374},  /* 816 */
    {1, 375},  /* 817 */
    {1, 375},  /* 818 */
    {1, 375},  /* 819 */
    {1, 375},  /* 820 */
    {1, 375},  /* 821 */
    {1, 375},  /* 822 */
    {1, 376},  /* 823 */
    {1, 376},  /* 824 */
    {1, 376},  /* 825 */
    {1, 376},  /* 826 */
    {1, 376},  /* 827 */
    {1, 376},  /* 828 */
    {1, 376},  /* 829 */
    {1, 376},  /* 830 */
    {1, 377},  /* 831 */
    {1, 377},  /* 832 */
    {1, 377},  /* 833 */
    {1, 377},  /* 834 */
    {1, 377},  /* 835 */
    {1, 377},  /* 836 */
    {1, 377},  /* 837 */
    {1, 377},  /* 838 */
    {1, 378},  /* 839 */
    {1, 378},  /* 840 */
    {1, 378},  /* 841 */
    {1, 378},  /* 842 */
    {1, 378},  /* 843 */
    {1, 378},  /* 844 */
    {1, 378},  /* 845 */
    {1, 378},  /* 846 */
    {1, 379},  /* 847 */
    {1, 379},  /* 848 */
    {1, 379},  /* 849 */
    {1, 379},  /* 850 */
    {1, 379},  /* 851 */
    {1, 379},  /* 852 */
    {1, 379},  /* 853 */
    {1, 379},  /* 854 */
    {1, 380},  /* 855 */
    {1, 380},  /* 856 */
    {1, 380},  /* 857 */
    {1, 380},  /* 858 */
    {1, 380},  /* 859 */
    {1, 380},  /* 860 */
    {1, 380},  /* 861 */
    {1, 380},  /* 862 */
    {1, 381},  /* 863 */
    {1, 381},  /* 864 */
    {1, 381},  /* 865 */
    {1, 381},  /* 866 */
    {1, 381},  /* 867 */
    {1, 381},  /* 868 */
    {1, 381},  /* 869 */
    {1, 381},  /* 870 */
    {1, 382},  /* 871 */
    {1, 382},  /* 872 */
    {1, 382},  /* 873 */
    {1, 382},  /* 874 */
    {1, 382},  /* 875 */
    {1, 382},  /* 876 */
    {1, 382},  /* 877 */
    {1, 382},  /* 878 */
    {1, 383},  /* 879 */
    {1, 383},  /* 880 */
    {1, 383},  /* 881 */
    {1, 383},  /* 882 */
    {1, 383},  /* 883 */
    {1, 383},  /* 884 */
    {1, 383},  /* 885 */
    {1, 383},  /* 886 */
    {1, 384},  /* 887 */
    {1, 384},  /* 888 */
    {1, 384},  /* 889 */
    {1, 384},  /* 890 */
    {1, 384},  /* 891 */
    {1, 384},  /* 892 */
    {1, 385},  /* 893 */
    {1, 385},  /* 894 */
    {1, 385},  /* 895 */
    {1, 385},  /* 896 */
    {1, 385},  /* 897 */
    {1, 385},  /* 898 */
    {1, 386},  /* 899 */
    {1, 386},  /* 900 */
    {1, 386},  /* 901 */
    {1, 386},  /* 902 */
    {1, 386},  /* 903 */
    {1, 386},  /* 904 */
    {1, 387},  /* 905 */
    {1, 387},  /* 906 */
    {1, 387},  /* 907 */
    {1, 387},  /* 908 */
    {1, 387},  /* 909 */
    {1, 387},  /* 910 */
    {1, 388},  /* 911 */
    {1, 388},  /* 912 */
    {1, 388},  /* 913 */
    {1, 388},  /* 914 */
    {1, 388},  /* 915 */
    {1, 388},  /* 916 */
    {1, 388},  /* 917 */
    {1, 388},  /* 918 */
    {1, 389},  /* 919 */
    {1, 389},  /* 920 */
    {1, 389},  /* 921 */
    {1, 389},  /* 922 */
    {1, 389},  /* 923 */
    {1, 389},  /* 924 */
    {1, 389},  /* 925 */
    {1, 389},  /* 926 */
    {1, 390},  /* 927 */
    {1, 390},  /* 928 */
    {1, 390},  /* 929 */
    {1, 390},  /* 930 */
    {1, 390},  /* 931 */
    {1, 390},  /* 932 */
    {1, 390},  /* 933 */
    {1, 390},  /* 934 */
    {1, 391},  /* 935 */
    {1, 391},  /* 936 */
    {1, 391},  /* 937 */
    {1, 391},  /* 938 */
    {1, 391},  /* 939 */
    {1, 391},  /* 940 */
    {1, 391},  /* 941 */
    {1, 391},  /* 942 */
    {1, 392},  /* 943 */
    {1, 392},  /* 944 */
    {1, 392},  /* 945 */
    {1, 392},  /* 946 */
    {1, 392},  /* 947 */
    {1, 392},  /* 948 */
    {1, 392},  /* 949 */
    {1, 392},  /* 950 */
    {1, 393},  /* 951 */
    {1, 393},  /* 952 */
    {1, 393},  /* 953 */
    {1, 393},  /* 954 */
    {1, 393},  /* 955 */
    {1, 393},  /* 956 */
    {1, 393},  /* 957 */
    {1, 393},  /* 958 */
    {1, 394},  /* 959 */
    {1, 394},  /* 960 */
    {1, 394},  /* 961 */
    {1, 394},  /* 962 */
    {1, 394},  /* 963 */
    {1, 394},  /* 964 */
    {1, 394},  /* 965 */
    {1, 394},  /* 966 */
    {1, 395},  /* 967 */
    {1, 395},  /* 968 */
    {1, 395},  /* 969 */
    {1, 395},  /* 970 */
    {1, 395},  /* 971 */
    {1, 395},  /* 972 */
    {1, 395},  /* 973 */
    {1, 395},  /* 974 */
    {1, 396},  /* 975 */
    {1, 396},  /* 976 */
    {1, 396},  /* 977 */
    {1, 396},  /* 978 */
    {1, 396},  /* 979 */
    {1, 396},  /* 980 */
    {1, 397},  /* 981 */
    {1, 397},  /* 982 */
    {1, 397},  /* 983 */
    {1, 397},  /* 984 */
    {1, 397},  /* 985 */
    {1, 397},  /* 986 */
    {1, 398},  /* 987 */
    {1, 398},  /* 988 */
    {1, 398},  /* 989 */
    {1, 398},  /* 990 */
    {1, 398},  /* 991 */
    {1, 398},  /* 992 */
    {1, 399},  /* 993 */
    {1, 399},  /* 994 */
    {1, 399},  /* 995 */
    {1, 399},  /* 996 */
    {1, 399},  /* 997 */
    {1, 399},  /* 998 */
    {1, 400},  /* 999 */
    {1, 400},  /* 1000 */
    {1, 400},  /* 1001 */
    {1, 400},  /* 1002 */
    {1, 400},  /* 1003 */
    {1, 400},  /* 1004 */
    {1, 400},  /* 1005 */
    {1, 400},  /* 1006 */
    {1, 400},  /* 1007 */
    {1, 400},  /* 1008 */
    {1, 400},  /* 1009 */
    {1, 400},  /* 1010 */
    {1, 401},  /* 1011 */
    {1, 401},  /* 1012 */
    {1, 401},  /* 1013 */
    {1, 401},  /* 1014 */
    {1, 401},  /* 1015 */
    {1, 401},  /* 1016 */
    {1, 401},  /* 1017 */
    {1, 401},  /* 1018 */
    {1, 401},  /* 1019 */
    {1, 401},  /* 1020 */
    {1, 401},  /* 1021 */
    {1, 401},  /* 1022 */
    {2, 402},  /* 1023 */
    {2, 402},  /* 1024 */
    {2, 402},  /* 1025 */
    {2, 402},  /* 1026 */
    {2, 402},  /* 1027 */
    {2, 402},  /* 1028 */
    {2, 402},  /* 1029 */
    {2, 402},  /* 1030 */
    {2, 402},  /* 1031 */
    {2, 402},  /* 1032 */
    {2, 402},  /* 1033 */
    {2, 402},  /* 1034 */
    {2, 404},  /* 1035 */
    {2, 404},  /* 1036 */
    {2, 404},  /* 1037 */
    {2, 404},  /* 1038 */
    {2, 404},  /* 1039 */
    {2, 404},  /* 1040 */
    {2, 404},  /* 1041 */
    {2, 404},  /* 1042 */
    {2, 404},  /* 1043 */
    {2, 404},  /* 1044 */
    {2, 404},  /* 1045 */
    {2, 404},  /* 1046 */
    {1, 406},  /* 1047 */
    {1, 406},  /* 1048 */
    {1, 406},  /* 1049 */
    {1, 406},  /* 1050 */
    {1, 406},  /* 1051 */
    {1, 406},  /* 1052 */
    {1, 406},  /* 1053 */
    {1, 406},  /* 1054 */
    {1, 406},  /* 1055 */
    {1, 406},  /* 1056 */
    {1, 406},  /* 1057 */
    {1, 406},  /* 1058 */
    {1, 407},  /* 1059 */
    {1, 407},  /* 1060 */
    {1, 407},  /* 1061 */
    {1, 407},  /* 1062 */
    {1, 407},  /* 1063 */
    {1, 407},  /* 1064 */
    {1, 407},  /* 1065 */
    {1, 407},  /* 1066 */
    {1, 407},  /* 1067 */
    {1, 407},  /* 1068 */
    {1, 407},  /* 1069 */
    {1, 407},  /* 1070 */
    {2, 408},  /* 1071 */
    {2, 408},  /* 1072 */
    {2, 408},  /* 1073 */
    {2, 408},  /* 1074 */
    {2, 408},  /* 1075 */
    {2, 408},  /* 1076 */
    {2, 408},  /* 1077 */
    {2, 408},  /* 1078 */
    {2, 408},  /* 1079 */
    {2, 408},  /* 1080 */
    {2, 408},  /* 1081 */
    {2, 408},  /* 1082 */
    {2, 410},  /* 1083 */
    {2, 410},  /* 1084 */
    {2, 410},  /* 1085 */
    {2, 410},  /* 1086 */
    {2, 410},  /* 1087 */
    {2, 410},  /* 1088 */
    {2, 410},  /* 1089 */
    {2, 410},  /* 1090 */
    {2, 410},  /* 1091 */
    {2, 410},  /* 1092 */
    {2, 410},  /* 1093 */
    {2, 410},  /* 1094 */
    {1, 412},  /* 1095 */
    {1, 412},  /* 1096 */
    {1, 412},  /* 1097 */
    {1, 412},  /* 1098 */
    {1, 412},  /* 1099 */
    {1, 412},  /* 1100 */
    {1, 412},  /* 1101 */
    {1, 412},  /* 1102 */
    {1, 412},  /* 1103 */
    {1, 412},  /* 1104 */
    {1, 412},  /* 1105 */
    {1, 412},  /* 1106 */
    {1, 413},  /* 1107 */
    {1, 413},  /* 1108 */
    {1, 413},  /* 1109 */
    {1, 413},  /* 1110 */
    {1, 413},  /* 1111 */
    {1, 413},  /* 1112 */
    {1, 413},  /* 1113 */
    {1, 413},  /* 1114 */
    {1, 413},  /* 1115 */
    {1, 413},  /* 1116 */
    {1, 413},  /* 1117 */
    {1, 413},  /* 1118 */
    {2, 414},  /* 1119 */
    {2, 414},  /* 1120 */
    {2, 414},  /* 1121 */
    {2, 414},  /* 1122 */
    {2, 414},  /* 1123 */
    {2, 414},  /* 1124 */
    {2, 414},  /* 1125 */
    {2, 414},  /* 1126 */
    {2, 414},  /* 1127 */
    {2, 414},  /* 1128 */
    {2, 414},  /* 1129 */
    {2, 414},  /* 1130 */
    {2, 416},  /* 1131 */
    {2, 416},  /* 1132 */
    {2, 416},  /* 1133 */
    {2, 416},  /* 1134 */
    {2, 416},  /* 1135 */
    {2, 416},  /* 1136 */
    {2, 416},  /* 1137 */
    {2, 416},  /* 1138 */
    {2, 416},  /* 1139 */
    {2, 416},  /* 1140 */
    {2, 416},  /* 1141 */
    {2, 416},  /* 1142 */
    {1, 418},  /* 1143 */
    {1, 418},  /* 1144 */
    {1, 418},  /* 1145 */
    {1, 418},  /* 1146 */
    {1, 418},  /* 1147 */
    {1, 418},  /* 1148 */
    {1, 418},  /* 1149 */
    {1, 418},  /* 1150 */
    {1, 418},  /* 1151 */
    {1, 418},  /* 1152 */
    {1, 418},  /* 1153 */
    {1, 418},  /* 1154 */
    {1, 419},  /* 1155 */
    {1, 419},  /* 1156 */
    {1, 419},  /* 1157 */
    {1, 419},  /* 1158 */
    {1, 419},  /* 1159 */
    {1, 419},  /* 1160 */
    {1, 419},  /* 1161 */
    {1, 419},  /* 1162 */
    {1, 419},  /* 1163 */
    {1, 419},  /* 1164 */
    {1, 419},  /* 1165 */
    {1, 419},  /* 1166 */
    {2, 420},  /* 1167 */
    {2, 420},  /* 1168 */
    {2, 420},  /* 1169 */
    {2, 420},  /* 1170 */
    {2, 420},  /* 1171 */
    {2, 420},  /* 1172 */
    {2, 420},  /* 1173 */
    {2, 420},  /* 1174 */
    {2, 420},  /* 1175 */
    {2, 420},  /* 1176 */
    {2, 420},  /* 1177 */
    {2, 420},  /* 1178 */
    {2, 422},  /* 1179 */
    {2, 422},  /* 1180 */
    {2, 422},  /* 1181 */
    {2, 422},  /* 1182 */
    {2, 422},  /* 1183 */
    {2, 422},  /* 1184 */
    {2, 422},  /* 1185 */
    {2, 422},  /* 1186 */
    {2, 422},  /* 1187 */
    {2, 422},  /* 1188 */
    {2, 422},  /* 1189 */
    {2, 422},  /* 1190 */
    {1, 424},  /* 1191 */
    {1, 424},  /* 1192 */
    {1, 424},  /* 1193 */
    {1, 424},  /* 1194 */
    {1, 424},  /* 1195 */
    {1, 424},  /* 1196 */
    {1, 424},  /* 1197 */
    {1, 424},  /* 1198 */
    {1, 424},  /* 1199 */
    {1, 424},  /* 1200 */
    {1, 425},  /* 1201 */
    {1, 425},  /* 1202 */
    {1, 425},  /* 1203 */
    {1, 425},  /* 1204 */
    {1, 425},  /* 1205 */
    {1, 425},  /* 1206 */
    {1, 425},  /* 1207 */
    {1, 425},  /* 1208 */
    {1, 425},  /* 1209 */
    {1, 425},  /* 1210 */
    {2, 426},  /* 1211 */
    {2, 426},  /* 1212 */
    {2, 426},  /* 1213 */
    {2, 426},  /* 1214 */
    {2, 426},  /* 1215 */
    {2, 426},  /* 1216 */
    {2, 426},  /* 1217 */
    {2, 426},  /* 1218 */
    {2, 426},  /* 1219 */
    {2, 426},  /* 1220 */
    {2, 428},  /* 1221 */
    {2, 428},  /* 1222 */
    {2, 428},  /* 1223 */
    {2, 428},  /* 1224 */
    {2, 428},  /* 1225 */
    {2, 428},  /* 1226 */
    {2, 428},  /* 1227 */
    {2, 428},  /* 1228 */
    {2, 428},  /* 1229 */
    {2, 428},  /* 1230 */
    {1, 430},  /* 1231 */
    {1, 430},  /* 1232 */
    {1, 430},  /* 1233 */
    {1, 431},  /* 1234 */
    {1, 431},  /* 1235 */
    {1, 431},  /* 1236 */
    {1, 432},  /* 1237 */
    {1, 432},  /* 1238 */
    {1, 432},  /* 1239 */
    {2, 433},  /* 1240 */
    {2, 433},  /* 1241 */
    {2, 433},  /* 1242 */
    {1, 435},  /* 1243 */
    {1, 435},  /* 1244 */
    {1, 435},  /* 1245 */
    {1, 435},  /* 1246 */
    {2, 436},  /* 1247 */
    {2, 436},  /* 1248 */
    {2, 436},  /* 1249 */
    {2, 436},  /* 1250 */
    {1, 438},  /* 1251 */
    {1, 438},  /* 1252 */
    {1, 438},  /* 1253 */
    {1, 438},  /* 1254 */
    {1, 439},  /* 1255 */
    {1, 439},  /* 1256 */
    {1, 439},  /* 1257 */
    {1, 439},  /* 1258 */
    {1, 440},  /* 1259 */
    {1, 440},  /* 1260 */
    {1, 440},  /* 1261 */
    {1, 440},  /* 1262 */
    {1, 441},  /* 1263 */
    {1, 441},  /* 1264 */
    {1, 441},  /* 1265 */
    {1, 441},  /* 1266 */
    {1, 442},  /* 1267 */
    {1, 442},  /* 1268 */
    {1, 442},  /* 1269 */
    {1, 442},  /* 1270 */
    {1, 443},  /* 1271 */
    {1, 443},  /* 1272 */
    {1, 443},  /* 1273 */
    {1, 443},  /* 1274 */
    {2, 444},  /* 1275 */
    {2, 444},  /* 1276 */
    {2, 444},  /* 1277 */
    {2, 444},  /* 1278 */
    {1, 446},  /* 1279 */
    {1, 446},  /* 1280 */
    {1, 446},  /* 1281 */
    {1, 446},  /* 1282 */
    {1, 447},  /* 1283 */
    {1, 447},  /* 1284 */
    {1, 447},  /* 1285 */
    {1, 447},  /* 1286 */
    {1, 448},  /* 1287 */
    {1, 448},  /* 1288 */
    {1, 448},  /* 1289 */
    {1, 448},  /* 1290 */
    {1, 449},  /* 1291 */
    {1, 449},  /* 1292 */
    {1, 449},  /* 1293 */
    {1, 449},  /* 1294 */
    {2, 450},  /* 1295 */
    {2, 450},  /* 1296 */
    {2, 450},  /* 1297 */
    {2, 450},  /* 1298 */
    {2, 452},  /* 1299 */
    {2, 452},  /* 1300 */
    {2, 452},  /* 1301 */
    {2, 452},  /* 1302 */
    {1, 454},  /* 1303 */
    {1, 454},  /* 1304 */
    {1, 454},  /* 1305 */
    {1, 454},  /* 1306 */
    {1, 454},  /* 1307 */
    {1, 454},  /* 1308 */
    {1, 455},  /* 1309 */
    {1, 455},  /* 1310 */
    {1, 455},  /* 1311 */
    {1, 455},  /* 1312 */
    {1, 455},  /* 1313 */
    {1, 455},  /* 1314 */
    {1, 456},  /* 1315 */
    {1, 456},  /* 1316 */
    {1, 456},  /* 1317 */
    {1, 456},  /* 1318 */
    {1, 456},  /* 1319 */
    {1, 456},  /* 1320 */
    {1, 457},  /* 1321 */
    {1, 457},  /* 1322 */
    {1, 457},  /* 1323 */
    {1, 457},  /* 1324 */
    {1, 457},  /* 1325 */
    {1, 457},  /* 1326 */
    {2, 458},  /* 1327 */
    {2, 458},  /* 1328 */
    {2, 458},  /* 1329 */
    {2, 458},  /* 1330 */
    {2, 458},  /* 1331 */
    {2, 458},  /* 1332 */
    {2, 460},  /* 1333 */
    {2, 460},  /* 1334 */
    {2, 460},  /* 1335 */
    {2, 460},  /* 1336 */
    {2, 460},  /* 1337 */
    {2, 460},  /* 1338 */
    {1, 462},  /* 1339 */
    {1, 462},  /* 1340 */
    {1, 462},  /* 1341 */
    {1, 462},  /* 1342 */
    {1, 463},  /* 1343 */
    {1, 463},  /* 1344 */
    {1, 463},  /* 1345 */
    {1, 463},  /* 1346 */
    {1, 464},  /* 1347 */
    {1, 464},  /* 1348 */
    {1, 464},  /* 1349 */
    {1, 464},  /* 1350 */
    {1, 465},  /* 1351 */
    {1, 465},  /* 1352 */
    {1, 465},  /* 1353 */
    {1, 465},  /* 1354 */
    {1, 466},  /* 1355 */
    {1, 466},  /* 1356 */
    {1, 466},  /* 1357 */
    {1, 466},  /* 1358 */
    {1, 467},  /* 1359 */
    {1, 467},  /* 1360 */
    {1, 467},  /* 1361 */
    {1, 467},  /* 1362 */
    {1, 468},  /* 1363 */
    {1, 468},  /* 1364 */
    {1, 468},  /* 1365 */
    {1, 468},  /* 1366 */
    {1, 469},  /* 1367 */
    {1, 469},  /* 1368 */
    {1, 469},  /* 1369 */
    {1, 469},  /* 1370 */
    {1, 469},  /* 1371 */
    {1, 469},  /* 1372 */
    {1, 470},  /* 1373 */
    {1, 470},  /* 1374 */
    {1, 470},  /* 1375 */
    {1, 470},  /* 1376 */
    {1, 470},  /* 1377 */
    {1, 470},  /* 1378 */
    {1, 471},  /* 1379 */
    {1, 471},  /* 1380 */
    {1, 471},  /* 1381 */
    {1, 471},  /* 1382 */
    {1, 471},  /* 1383 */
    {1, 471},  /* 1384 */
    {1, 472},  /* 1385 */
    {1, 472},  /* 1386 */
    {1, 472},  /* 1387 */
    {1, 472},  /* 1388 */
    {1, 472},  /* 1389 */
    {1, 472},  /* 1390 */
    {1, 473},  /* 1391 */
    {1, 473},  /* 1392 */
    {1, 473},  /* 1393 */
    {1, 473},  /* 1394 */
    {1, 473},  /* 1395 */
    {1, 473},  /* 1396 */
    {1, 474},  /* 1397 */
    {1, 474},  /* 1398 */
    {1, 474},  /* 1399 */
    {1, 474},  /* 1400 */
    {1, 474},  /* 1401 */
    {1, 474},  /* 1402 */
    {1, 475},  /* 1403 */
    {1, 475},  /* 1404 */
    {1, 475},  /* 1405 */
    {1, 475},  /* 1406 */
    {1, 475},  /* 1407 */
    {1, 475},  /* 1408 */
    {1, 476},  /* 1409 */
    {1, 476},  /* 1410 */
    {1, 476},  /* 1411 */
    {1, 476},  /* 1412 */
    {1, 476},  /* 1413 */
    {1, 476},  /* 1414 */
    {1, 477},  /* 1415 */
    {1, 477},  /* 1416 */
    {1, 477},  /* 1417 */
    {1, 477},  /* 1418 */
    {1, 477},  /* 1419 */
    {1, 477},  /* 1420 */
    {1, 478},  /* 1421 */
    {1, 478},  /* 1422 */
    {1, 478},  /* 1423 */
    {1, 478},  /* 1424 */
    {1, 478},  /* 1425 */
    {1, 478},  /* 1426 */
    {1, 479},  /* 1427 */
    {1, 479},  /* 1428 */
    {1, 479},  /* 1429 */
    {1, 479},  /* 1430 */
    {1, 479},  /* 1431 */
    {1, 479},  /* 1432 */
    {1, 480},  /* 1433 */
    {1, 480},  /* 1434 */
    {1, 480},  /* 1435 */
    {1, 480},  /* 1436 */
    {1, 480},  /* 1437 */
    {1, 480},  /* 1438 */
    {1, 481},  /* 1439 */
    {1, 481},  /* 1440 */
    {1, 481},  /* 1441 */
    {1, 481},  /* 1442 */
    {1, 481},  /* 1443 */
    {1, 481},  /* 1444 */
    {1, 482},  /* 1445 */
    {1, 482},  /* 1446 */
    {1, 482},  /* 1447 */
    {1, 482},  /* 1448 */
    {1, 482},  /* 1449 */
    {1, 482},  /* 1450 */
    {1, 483},  /* 1451 */
    {1, 483},  /* 1452 */
    {1, 483},  /* 1453 */
    {1, 483},  /* 1454 */
    {1, 483},  /* 1455 */
    {1, 483},  /* 1456 */
    {1, 484},  /* 1457 */
    {1, 484},  /* 1458 */
    {1, 484},  /* 1459 */
    {1, 484},  /* 1460 */
    {1, 484},  /* 1461 */
    {1, 484},  /* 1462 */
    {1, 485},  /* 1463 */
    {1, 485},  /* 1464 */
    {1, 485},  /* 1465 */
    {1, 485},  /* 1466 */
    {1, 485},  /* 1467 */
    {1, 485},  /* 1468 */
    {1, 485},  /* 1469 */
    {1, 485},  /* 1470 */
    {1, 485},  /* 1471 */
    {1, 485},  /* 1472 */
    {1, 486},  /* 1473 */
    {1, 486},  /* 1474 */
    {1, 486},  /* 1475 */
    {1, 486},  /* 1476 */
    {1, 486},  /* 1477 */
    {1, 486},  /* 1478 */
    {1, 486},  /* 1479 */
    {1, 486},  /* 1480 */
    {1, 486},  /* 1481 */
    {1, 486},  /* 1482 */
    {1, 487},  /* 1483 */
    {1, 487},  /* 1484 */
    {1, 487},  /* 1485 */
    {1, 487},  /* 1486 */
    {1, 487},  /* 1487 */
    {1, 487},  /* 1488 */
    {1, 487},  /* 1489 */
    {1, 487},  /* 1490 */
    {1, 487},  /* 1491 */
    {1, 487},  /* 1492 */
    {1, 488},  /* 1493 */
    {1, 488},  /* 1494 */
    {1, 488},  /* 1495 */
    {1, 488},  /* 1496 */
    {1, 488},  /* 1497 */
    {1, 488},  /* 1498 */
    {1, 488},  /* 1499 */
    {1, 488},  /* 1500 */
    {1, 488},  /* 1501 */
    {1, 488},  /* 1502 */
    {1, 489},  /* 1503 */
    {1, 489},  /* 1504 */
    {1, 489},  /* 1505 */
    {1, 490},  /* 1506 */
    {1, 490},  /* 1507 */
    {1, 490},  /* 1508 */
    {1, 491},  /* 1509 */
    {1, 491},  /* 1510 */
    {1, 492},  /* 1511 */
    {1, 492},  /* 1512 */
    {1, 492},  /* 1513 */
    {1, 493},  /* 1514 */
    {1, 493},  /* 1515 */
    {1, 494},  /* 1516 */
    {1, 494},  /* 1517 */
    {1, 494},  /* 1518 */
    {1, 494},  /* 1519 */
    {2, 495},  /* 1520 */
    {2, 495},  /* 1521 */
    {2, 495},  /* 1522 */
    {2, 495},  /* 1523 */
    {1, 497},  /* 1524 */
    {1, 497},  /* 1525 */
    {1, 497},  /* 1526 */
    {1, 497},  /* 1527 */
    {2, 498},  /* 1528 */
    {2, 498},  /* 1529 */
    {2, 498},  /* 1530 */
    {2, 498},  /* 1531 */
    {1, 500},  /* 1532 */
    {1, 500},  /* 1533 */
    {1, 500},  /* 1534 */
    {1, 501},  /* 1535 */
    {1, 501},  /* 1536 */
    {1, 501},  /* 1537 */
    {1, 501},  /* 1538 */
    {1, 502},  /* 1539 */
    {1, 502},  /* 1540 */
    {1, 502},  /* 1541 */
    {1, 503},  /* 1542 */
    {1, 503},  /* 1543 */
    {1, 503},  /* 1544 */
    {1, 503},  /* 1545 */
    {1, 504},  /* 1546 */
    {1, 504},  /* 1547 */
    {1, 504},  /* 1548 */
    {1, 504},  /* 1549 */
    {1, 505},  /* 1550 */
    {1, 505},  /* 1551 */
    {1, 505},  /* 1552 */
    {1, 505},  /* 1553 */
    {1, 506},  /* 1554 */
    {1, 506},  /* 1555 */
    {1, 506},  /* 1556 */
    {1, 506},  /* 1557 */
    {1, 507},  /* 1558 */
    {1, 507},  /* 1559 */
    {1, 507},  /* 1560 */
    {1, 508},  /* 1561 */
    {1, 508},  /* 1562 */
    {1, 508},  /* 1563 */
    {1, 508},  /* 1564 */
    {1, 509},  /* 1565 */
    {1, 509},  /* 1566 */
    {1, 509},  /* 1567 */
    {1, 509},  /* 1568 */
    {1, 510},  /* 1569 */
    {1, 510},  /* 1570 */
    {1, 510},  /* 1571 */
    {1, 511},  /* 1572 */
    {1, 511},  /* 1573 */
    {1, 511},  /* 1574 */
    {1, 511},  /* 1575 */
    {1, 512},  /* 1576 */
    {1, 512},  /* 1577 */
    {1, 512},  /* 1578 */
    {1, 512},  /* 1579 */
    {1, 513},  /* 1580 */
    {1, 513},  /* 1581 */
    {1, 513},  /* 1582 */
    {1, 514},  /* 1583 */
    {1, 514},  /* 1584 */
    {1, 514},  /* 1585 */
    {1, 514},  /* 1586 */
    {1, 515},  /* 1587 */
    {1, 515},  /* 1588 */
    {1, 515},  /* 1589 */
    {1, 515},  /* 1590 */
    {1, 516},  /* 1591 */
    {1, 516},  /* 1592 */
    {1, 516},  /* 1593 */
    {1, 517},  /* 1594 */
    {1, 517},  /* 1595 */
    {1, 517},  /* 1596 */
    {1, 517},  /* 1597 */
    {1, 517},  /* 1598 */
    {1, 517},  /* 1599 */
    {2, 518},  /* 1600 */
    {2, 518},  /* 1601 */
    {2, 518},  /* 1602 */
    {2, 518},  /* 1603 */
    {2, 518},  /* 1604 */
    {2, 518},  /* 1605 */
    {1, 520},  /* 1606 */
    {1, 520},  /* 1607 */
    {1, 520},  /* 1608 */
    {1, 520},  /* 1609 */
    {1, 520},  /* 1610 */
    {1, 520},  /* 1611 */
    {2, 521},  /* 1612 */
    {2, 521},  /* 1613 */
    {2, 521},  /* 1614 */
    {2, 521},  /* 1615 */
    {2, 521},  /* 1616 */
    {2, 521},  /* 1617 */
    {1, 523},  /* 1618 */
    {1, 523},  /* 1619 */
    {1, 523},  /* 1620 */
    {1, 523},  /* 1621 */
    {1, 523},  /* 1622 */
    {1, 523},  /* 1623 */
    {1, 524},  /* 1624 */
    {1, 524},  /* 1625 */
    {1, 524},  /* 1626 */
    {1, 524},  /* 1627 */
    {1, 524},  /* 1628 */
    {1, 524},  /* 1629 */
    {2, 525},  /* 1630 */
    {2, 525},  /* 1631 */
    {2, 525},  /* 1632 */
    {2, 525},  /* 1633 */
    {2, 525},  /* 1634 */
    {2, 525},  /* 1635 */
    {2, 527},  /* 1636 */
    {2, 527},  /* 1637 */
    {2, 527},  /* 1638 */
    {2, 527},  /* 1639 */
    {2, 527},  /* 1640 */
    {2, 527},  /* 1641 */
    {1, 529},  /* 1642 */
    {1, 529},  /* 1643 */
    {1, 529},  /* 1644 */
    {1, 529},  /* 1645 */
    {1, 529},  /* 1646 */
    {1, 530},  /* 1647 */
    {1, 530},  /* 1648 */
    {1, 530},  /* 1649 */
    {1, 530},  /* 1650 */
    {1, 530},  /* 1651 */
};

/* { order, offset in `magnetic_symmetry_operations` } for each pair of UNI
 * number and Hall number */
static const int magnetic_spacegroup_operation_index[][18][2] = {
    { {0, 0} }, /* dummy */
    { { 1, 1 } }, /* 1 */
    { { 2, 2 } }, /* 2 */
    { { 2, 4 } }, /* 3 */
    { { 2, 6 } }, /* 4 */
    { { 4, 8 } }, /* 5 */
    { { 2, 12 } }, /* 6 */
    { { 4, 14 } }, /* 7 */
    { { 2, 18 }, { 2, 38 }, { 2, 58 } }, /* 8 */
    { { 4, 20 }, { 4, 40 }, { 4, 60 } }, /* 9 */
    { { 2, 24 }, { 2, 44 }, { 2, 64 } }, /* 10 */
    { { 4, 26 }, { 4, 46 }, { 4, 66 } }, /* 11 */
    { { 4, 30 }, { 4, 50 }, { 4, 70 } }, /* 12 */
    { { 4, 34 }, { 4, 54 }, { 4, 74 } }, /* 13 */
    { { 2, 78 }, { 2, 98 }, { 2, 118 } }, /* 14 */
    { { 4, 80 }, { 4, 100 }, { 4, 120 } }, /* 15 */
    { { 2, 84 }, { 2, 104 }, { 2, 124 } }, /* 16 */
    { { 4, 86 }, { 4, 106 }, { 4, 126 } }, /* 17 */
    { { 4, 90 }, { 4, 110 }, { 4, 130 } }, /* 18 */
    { { 4, 94 }, { 4, 114 }, { 4, 134 } }, /* 19 */
    { { 4, 138 }, { 4, 170 }, { 4, 202 }, { 4, 234 }, { 4, 266 }, { 4, 298 }, { 4, 330 }, { 4, 362 }, { 4, 394 } }, /* 20 */
    { { 8, 142 }, { 8, 174 }, { 8, 206 }, { 8, 238 }, { 8, 270 }, { 8, 302 }, { 8, 334 }, { 8, 366 }, { 8, 398 } }, /* 21 */
    { { 4, 150 }, { 4, 182 }, { 4, 214 }, { 4, 246 }, { 4, 278 }, { 4, 310 }, { 4, 342 }, { 4, 374 }, { 4, 406 } }, /* 22 */
    { { 8, 154 }, { 8, 186 }, { 8, 218 }, { 8, 250 }, { 8, 282 }, { 8, 314 }, { 8, 346 }, { 8, 378 }, { 8, 410 } }, /* 23 */
    { { 8, 162 }, { 8, 194 }, { 8, 226 }, { 8, 258 }, { 8, 290 }, { 8, 322 }, { 8, 354 }, { 8, 386 }, { 8, 418 } }, /* 24 */
    { { 2, 426 }, { 2, 446 }, { 2, 466 } }, /* 25 */
    { { 4, 428 }, { 4, 448 }, { 4, 468 } }, /* 26 */
    { { 2, 432 }, { 2, 452 }, { 2, 472 } }, /* 27 */
    { { 4, 434 }, { 4, 454 }, { 4, 474 } }, /* 28 */
    { { 4, 438 }, { 4, 458 }, { 4, 478 } }, /* 29 */
    { { 4, 442 }, { 4, 462 }, { 4, 482 } }, /* 30 */
    { { 2, 486 }, { 2, 514 }, { 2, 542 }, { 2, 570 }, { 2, 598 }, { 2, 626 }, { 2, 654 }, { 2, 682 }, { 2, 710 } }, /* 31 */
    { { 4, 488 }, { 4, 516 }, { 4, 544 }, { 4, 572 }, { 4, 600 }, { 4, 628 }, { 4, 656 }, { 4, 684 }, { 4, 712 } }, /* 32 */
    { { 2, 492 }, { 2, 520 }, { 2, 548 }, { 2, 576 }, { 2, 604 }, { 2, 632 }, { 2, 660 }, { 2, 688 }, { 2, 716 } }, /* 33 */
    { { 4, 494 }, { 4, 522 }, { 4, 550 }, { 4, 578 }, { 4, 606 }, { 4, 634 }, { 4, 662 }, { 4, 690 }, { 4, 718 } }, /* 34 */
    { { 4, 498 }, { 4, 526 }, { 4, 554 }, { 4, 582 }, { 4, 610 }, { 4, 638 }, { 4, 666 }, { 4, 694 }, { 4, 722 } }, /* 35 */
    { { 4, 502 }, { 4, 530 }, { 4, 558 }, { 4, 586 }, { 4, 614 }, { 4, 642 }, { 4, 670 }, { 4, 698 }, { 4, 726 } }, /* 36 */
    { { 4, 506 }, { 4, 534 }, { 4, 562 }, { 4, 590 }, { 4, 618 }, { 4, 646 }, { 4, 674 }, { 4, 702 }, { 4, 730 } }, /* 37 */
    { { 4, 510 }, { 4, 538 }, { 4, 566 }, { 4, 594 }, { 4, 622 }, { 4, 650 }, { 4, 678 }, { 4, 706 }, { 4, 734 } }, /* 38 */
    { { 4, 738 }, { 4, 770 }, { 4, 802 }, { 4, 834 }, { 4, 866 }, { 4, 898 }, { 4, 930 }, { 4, 962 }, { 4, 994 } }, /* 39 */
    { { 8, 742 }, { 8, 774 }, { 8, 806 }, { 8, 838 }, { 8, 870 }, { 8, 902 }, { 8, 934 }, { 8, 966 }, { 8, 998 } }, /* 40 */
    { { 4, 750 }, { 4, 782 }, { 4, 814 }, { 4, 846 }, { 4, 878 }, { 4, 910 }, { 4, 942 }, { 4, 974 }, { 4, 1006 } }, /* 41 */
    { { 8, 754 }, { 8, 786 }, { 8, 818 }, { 8, 850 }, { 8, 882 }, { 8, 914 }, { 8, 946 }, { 8, 978 }, { 8, 1010 } }, /* 42 */
    { { 8, 762 }, { 8, 794 }, { 8, 826 }, { 8, 858 }, { 8, 890 }, { 8, 922 }, { 8, 954 }, { 8, 986 }, { 8, 1018 } }, /* 43 */
    { { 4, 1026 }, { 4, 1058 }, { 4, 1090 }, { 4, 1122 }, { 4, 1154 }, { 4, 1186 }, { 4, 1218 }, { 4, 1250 }, { 4, 1282 }, { 4, 1314 }, { 4, 1346 }, { 4, 1378 }, { 4, 1410 }, { 4, 1442 }, { 4, 1474 }, { 4, 1506 }, { 4, 1538 }, { 4, 1570 } }, /* 44 */
    { { 8, 1030 }, { 8, 1062 }, { 8, 1094 }, { 8, 1126 }, { 8, 1158 }, { 8, 1190 }, { 8, 1222 }, { 8, 1254 }, { 8, 1286 }, { 8, 1318 }, { 8, 1350 }, { 8, 1382 }, { 8, 1414 }, { 8, 1446 }, { 8, 1478 }, { 8, 1510 }, { 8, 1542 }, { 8, 1574 } }, /* 45 */
    { { 4, 1038 }, { 4, 1070 }, { 4, 1102 }, { 4, 1134 }, { 4, 1166 }, { 4, 1198 }, { 4, 1230 }, { 4, 1262 }, { 4, 1294 }, { 4, 1326 }, { 4, 1358 }, { 4, 1390 }, { 4, 1422 }, { 4, 1454 }, { 4, 1486 }, { 4, 1518 }, { 4, 1550 }, { 4, 1582 } }, /* 46 */
    { { 8, 1042 }, { 8, 1074 }, { 8, 1106 }, { 8, 1138 }, { 8, 1170 }, { 8, 1202 }, { 8, 1234 }, { 8, 1266 }, { 8, 1298 }, { 8, 1330 }, { 8, 1362 }, { 8, 1394 }, { 8, 1426 }, { 8, 1458 }, { 8, 1490 }, { 8, 1522 }, { 8, 1554 }, { 8, 1586 } }, /* 47 */
    { { 8, 1050 }, { 8, 1082 }, { 8, 1114 }, { 8, 1146 }, { 8, 1178 }, { 8, 1210 }, { 8, 1242 }, { 8, 1274 }, { 8, 1306 }, { 8, 1338 }, { 8, 1370 }, { 8, 1402 }, { 8, 1434 }, { 8, 1466 }, { 8, 1498 }, { 8, 1530 }, { 8, 1562 }, { 8, 1594 } }, /* 48 */
    { { 4, 1602 }, { 4, 1650 }, { 4, 1698 } }, /* 49 */
    { { 8, 1606 }, { 8, 1654 }, { 8, 1702 } }, /* 50 */
    { { 4, 1614 }, { 4, 1662 }, { 4, 1710 } }, /* 51 */
    { { 4, 1618 }, { 4, 1666 }, { 4, 1714 } }, /* 52 */
    { { 4, 1622 }, { 4, 1670 }, { 4, 1718 } }, /* 53 */
    { { 8, 1626 }, { 8, 1674 }, { 8, 1722 } }, /* 54 */
    { { 8, 1634 }, { 8, 1682 }, { 8, 1730 } }, /* 55 */
    { { 8, 1642 }, { 8, 1690 }, { 8, 1738 } }, /* 56 */
    { { 4, 1746 }, { 4, 1794 }, { 4, 1842 } }, /* 57 */
    { { 8, 1750 }, { 8, 1798 }, { 8, 1846 } }, /* 58 */
    { { 4, 1758 }, { 4, 1806 }, { 4, 1854 } }, /* 59 */
    { { 4, 1762 }, { 4, 1810 }, { 4, 1858 } }, /* 60 */
    { { 4, 1766 }, { 4, 1814 }, { 4, 1862 } }, /* 61 */
    { { 8, 1770 }, { 8, 1818 }, { 8, 1866 } }, /* 62 */
    { { 8, 1778 }, { 8, 1826 }, { 8, 1874 } }, /* 63 */
    { { 8, 1786 }, { 8, 1834 }, { 8, 1882 } }, /* 64 */
    { { 8, 1890 }, { 8, 1970 }, { 8, 2050 }, { 8, 2130 }, { 8, 2210 }, { 8, 2290 }, { 8, 2370 }, { 8, 2450 }, { 8, 2530 } }, /* 65 */
    { { 16, 1898 }, { 16, 1978 }, { 16, 2058 }, { 16, 2138 }, { 16, 2218 }, { 16, 2298 }, { 16, 2378 }, { 16, 2458 }, { 16, 2538 } }, /* 66 */
    { { 8, 1914 }, { 8, 1994 }, { 8, 2074 }, { 8, 2154 }, { 8, 2234 }, { 8, 2314 }, { 8, 2394 }, { 8, 2474 }, { 8, 2554 } }, /* 67 */
    { { 8, 1922 }, { 8, 2002 }, { 8, 2082 }, { 8, 2162 }, { 8, 2242 }, { 8, 2322 }, { 8, 2402 }, { 8, 2482 }, { 8, 2562 } }, /* 68 */
    { { 8, 1930 }, { 8, 2010 }, { 8, 2090 }, { 8, 2170 }, { 8, 2250 }, { 8, 2330 }, { 8, 2410 }, { 8, 2490 }, { 8, 2570 } }, /* 69 */
    { { 16, 1938 }, { 16, 2018 }, { 16, 2098 }, { 16, 2178 }, { 16, 2258 }, { 16, 2338 }, { 16, 2418 }, { 16, 2498 }, { 16, 2578 } }, /* 70 */
    { { 16, 1954 }, { 16, 2034 }, { 16, 2114 }, { 16, 2194 }, { 16, 2274 }, { 16, 2354 }, { 16, 2434 }, { 16, 2514 }, { 16, 2594 } }, /* 71 */
    { { 4, 2610 }, { 4, 2674 }, { 4, 2738 }, { 4, 2802 }, { 4, 2866 }, { 4, 2930 }, { 4, 2994 }, { 4, 3058 }, { 4, 3122 } }, /* 72 */
    { { 8, 2614 }, { 8, 2678 }, { 8, 2742 }, { 8, 2806 }, { 8, 2870 }, { 8, 2934 }, { 8, 2998 }, { 8, 3062 }, { 8, 3126 } }, /* 73 */
    { { 4, 2622 }, { 4, 2686 }, { 4, 2750 }, { 4, 2814 }, { 4, 2878 }, { 4, 2942 }, { 4, 3006 }, { 4, 3070 }, { 4, 3134 } }, /* 74 */
    { { 4, 2626 }, { 4, 2690 }, { 4, 2754 }, { 4, 2818 }, { 4, 2882 }, { 4, 2946 }, { 4, 3010 }, { 4, 3074 }, { 4, 3138 } }, /* 75 */
    { { 4, 2630 }, { 4, 2694 }, { 4, 2758 }, { 4, 2822 }, { 4, 2886 }, { 4, 2950 }, { 4, 3014 }, { 4, 3078 }, { 4, 3142 } }, /* 76 */
    { { 8, 2634 }, { 8, 2698 }, { 8, 2762 }, { 8, 2826 }, { 8, 2890 }, { 8, 2954 }, { 8, 3018 }, { 8, 3082 }, { 8, 3146 } }, /* 77 */
    { { 8, 2642 }, { 8, 2706 }, { 8, 2770 }, { 8, 2834 }, { 8, 2898 }, { 8, 2962 }, { 8, 3026 }, { 8, 3090 }, { 8, 3154 } }, /* 78 */
    { { 8, 2650 }, { 8, 2714 }, { 8, 2778 }, { 8, 2842 }, { 8, 2906 }, { 8, 2970 }, { 8, 3034 }, { 8, 3098 }, { 8, 3162 } }, /* 79 */
    { { 8, 2658 }, { 8, 2722 }, { 8, 2786 }, { 8, 2850 }, { 8, 2914 }, { 8, 2978 }, { 8, 3042 }, { 8, 3106 }, { 8, 3170 } }, /* 80 */
    { { 8, 2666 }, { 8, 2730 }, { 8, 2794 }, { 8, 2858 }, { 8, 2922 }, { 8, 2986 }, { 8, 3050 }, { 8, 3114 }, { 8, 3178 } }, /* 81 */
    { { 4, 3186 }, { 4, 3250 }, { 4, 3314 }, { 4, 3378 }, { 4, 3442 }, { 4, 3506 }, { 4, 3570 }, { 4, 3634 }, { 4, 3698 } }, /* 82 */
    { { 8, 3190 }, { 8, 3254 }, { 8, 3318 }, { 8, 3382 }, { 8, 3446 }, { 8, 3510 }, { 8, 3574 }, { 8, 3638 }, { 8, 3702 } }, /* 83 */
    { { 4, 3198 }, { 4, 3262 }, { 4, 3326 }, { 4, 3390 }, { 4, 3454 }, { 4, 3518 }, { 4, 3582 }, { 4, 3646 }, { 4, 3710 } }, /* 84 */
    { { 4, 3202 }, { 4, 3266 }, { 4, 3330 }, { 4, 3394 }, { 4, 3458 }, { 4, 3522 }, { 4, 3586 }, { 4, 3650 }, { 4, 3714 } }, /* 85 */
    { { 4, 3206 }, { 4, 3270 }, { 4, 3334 }, { 4, 3398 }, { 4, 3462 }, { 4, 3526 }, { 4, 3590 }, { 4, 3654 }, { 4, 3718 } }, /* 86 */
    { { 8, 3210 }, { 8, 3274 }, { 8, 3338 }, { 8, 3402 }, { 8, 3466 }, { 8, 3530 }, { 8, 3594 }, { 8, 3658 }, { 8, 3722 } }, /* 87 */
    { { 8, 3218 }, { 8, 3282 }, { 8, 3346 }, { 8, 3410 }, { 8, 3474 }, { 8, 3538 }, { 8, 3602 }, { 8, 3666 }, { 8, 3730 } }, /* 88 */
    { { 8, 3226 }, { 8, 3290 }, { 8, 3354 }, { 8, 3418 }, { 8, 3482 }, { 8, 3546 }, { 8, 3610 }, { 8, 3674 }, { 8, 3738 } }, /* 89 */
    { { 8, 3234 }, { 8, 3298 }, { 8, 3362 }, { 8, 3426 }, { 8, 3490 }, { 8, 3554 }, { 8, 3618 }, { 8, 3682 }, { 8, 3746 } }, /* 90 */
    { { 8, 3242 }, { 8, 3306 }, { 8, 3370 }, { 8, 3434 }, { 8, 3498 }, { 8, 3562 }, { 8, 3626 }, { 8, 3690 }, { 8, 3754 } }, /* 91 */
    { { 8, 3762 }, { 8, 3842 }, { 8, 3922 }, { 8, 4002 }, { 8, 4082 }, { 8, 4162 }, { 8, 4242 }, { 8, 4322 }, { 8, 4402 }, { 8, 4482 }, { 8, 4562 }, { 8, 4642 }, { 8, 4722 }, { 8, 4802 }, { 8, 4882 }, { 8, 4962 }, { 8, 5042 }, { 8, 5122 } }, /* 92 */
    { { 16, 3770 }, { 16, 3850 }, { 16, 3930 }, { 16, 4010 }, { 16, 4090 }, { 16, 4170 }, { 16, 4250 }, { 16, 4330 }, { 16, 4410 }, { 16, 4490 }, { 16, 4570 }, { 16, 4650 }, { 16, 4730 }, { 16, 4810 }, { 16, 4890 }, { 16, 4970 }, { 16, 5050 }, { 16, 5130 } }, /* 93 */
    { { 8, 3786 }, { 8, 3866 }, { 8, 3946 }, { 8, 4026 }, { 8, 4106 }, { 8, 4186 }, { 8, 4266 }, { 8, 4346 }, { 8, 4426 }, { 8, 4506 }, { 8, 4586 }, { 8, 4666 }, { 8, 4746 }, { 8, 4826 }, { 8, 4906 }, { 8, 4986 }, { 8, 5066 }, { 8, 5146 } }, /* 94 */
    { { 8, 3794 }, { 8, 3874 }, { 8, 3954 }, { 8, 4034 }, { 8, 4114 }, { 8, 4194 }, { 8, 4274 }, { 8, 4354 }, { 8, 4434 }, { 8, 4514 }, { 8, 4594 }, { 8, 4674 }, { 8, 4754 }, { 8, 4834 }, { 8, 4914 }, { 8, 4994 }, { 8, 5074 }, { 8, 5154 } }, /* 95 */
    { { 8, 3802 }, { 8, 3882 }, { 8, 3962 }, { 8, 4042 }, { 8, 4122 }, { 8, 4202 }, { 8, 4282 }, { 8, 4362 }, { 8, 4442 }, { 8, 4522 }, { 8, 4602 }, { 8, 4682 }, { 8, 4762 }, { 8, 4842 }, { 8, 4922 }, { 8, 5002 }, { 8, 5082 }, { 8, 5162 } }, /* 96 */
    { { 16, 3810 }, { 16, 3890 }, { 16, 3970 }, { 16, 4050 }, { 16, 4130 }, { 16, 4210 }, { 16, 4290 }, { 16, 4370 }, { 16, 4450 }, { 16, 4530 }, { 16, 4610 }, { 16, 4690 }, { 16, 4770 }, { 16, 4850 }, { 16, 4930 }, { 16, 5010 }, { 16, 5090 }, { 16, 5170 } }, /* 97 */
    { { 16, 3826 }, { 16, 3906 }, { 16, 3986 }, { 16, 4066 }, { 16, 4146 }, { 16, 4226 }, { 16, 4306 }, { 16, 4386 }, { 16, 4466 }, { 16, 4546 }, { 16, 4626 }, { 16, 4706 }, { 16, 4786 }, { 16, 4866 }, { 16, 4946 }, { 16, 5026 }, { 16, 5106 }, { 16, 5186 } }, /* 98 */
    { { 4, 5202 } }, /* 99 */
    { { 8, 5206 } }, /* 100 */
    { { 4, 5214 } }, /* 101 */
    { { 8, 5218 } }, /* 102 */
    { { 8, 5226 } }, /* 103 */
    { { 8, 5234 } }, /* 104 */
    { { 4, 5242 }, { 4, 5302 }, { 4, 5362 } }, /* 105 */
    { { 8, 5246 }, { 8, 5306 }, { 8, 5366 } }, /* 106 */
    { { 4, 5254 }, { 4, 5314 }, { 4, 5374 } }, /* 107 */
    { { 4, 5258 }, { 4, 5318 }, { 4, 5378 } }, /* 108 */
    { { 8, 5262 }, { 8, 5322 }, { 8, 5382 } }, /* 109 */
    { { 8, 5270 }, { 8, 5330 }, { 8, 5390 } }, /* 110 */
    { { 8, 5278 }, { 8, 5338 }, { 8, 5398 } }, /* 111 */
    { { 8, 5286 }, { 8, 5346 }, { 8, 5406 } }, /* 112 */
    { { 8, 5294 }, { 8, 5354 }, { 8, 5414 } }, /* 113 */
    { { 4, 5422 }, { 4, 5482 }, { 4, 5542 } }, /* 114 */
    { { 8, 5426 }, { 8, 5486 }, { 8, 5546 } }, /* 115 */
    { { 4, 5434 }, { 4, 5494 }, { 4, 5554 } }, /* 116 */
    { { 4, 5438 }, { 4, 5498 }, { 4, 5558 } }, /* 117 */
    { { 8, 5442 }, { 8, 5502 }, { 8, 5562 } }, /* 118 */
    { { 8, 5450 }, { 8, 5510 }, { 8, 5570 } }, /* 119 */
    { { 8, 5458 }, { 8, 5518 }, { 8, 5578 } }, /* 120 */
    { { 8, 5466 }, { 8, 5526 }, { 8, 5586 } }, /* 121 */
    { { 8, 5474 }, { 8, 5534 }, { 8, 5594 } }, /* 122 */
    { { 4, 5602 } }, /* 123 */
    { { 8, 5606 } }, /* 124 */
    { { 4, 5614 } }, /* 125 */
    { { 8, 5618 } }, /* 126 */
    { { 8, 5626 } }, /* 127 */
    { { 8, 5634 } }, /* 128 */
    { { 8, 5642 }, { 8, 5730 }, { 8, 5818 } }, /* 129 */
    { { 16, 5650 }, { 16, 5738 }, { 16, 5826 } }, /* 130 */
    { { 8, 5666 }, { 8, 5754 }, { 8, 5842 } }, /* 131 */
    { { 8, 5674 }, { 8, 5762 }, { 8, 5850 } }, /* 132 */
    { { 16, 5682 }, { 16, 5770 }, { 16, 5858 } }, /* 133 */
    { { 16, 5698 }, { 16, 5786 }, { 16, 5874 } }, /* 134 */
    { { 16, 5714 }, { 16, 5802 }, { 16, 5890 } }, /* 135 */
    { { 8, 5906 }, { 8, 5994 }, { 8, 6082 } }, /* 136 */
    { { 16, 5914 }, { 16, 6002 }, { 16, 6090 } }, /* 137 */
    { { 8, 5930 }, { 8, 6018 }, { 8, 6106 } }, /* 138 */
    { { 8, 5938 }, { 8, 6026 }, { 8, 6114 } }, /* 139 */
    { { 16, 5946 }, { 16, 6034 }, { 16, 6122 } }, /* 140 */
    { { 16, 5962 }, { 16, 6050 }, { 16, 6138 } }, /* 141 */
    { { 16, 5978 }, { 16, 6066 }, { 16, 6154 } }, /* 142 */
    { { 16, 6170 } }, /* 143 */
    { { 32, 6186 } }, /* 144 */
    { { 16, 6218 } }, /* 145 */
    { { 32, 6234 } }, /* 146 */
    { { 8, 6266 } }, /* 147 */
    { { 16, 6274 } }, /* 148 */
    { { 8, 6290 } }, /* 149 */
    { { 16, 6298 } }, /* 150 */
    { { 8, 6314 } }, /* 151 */
    { { 16, 6322 } }, /* 152 */
    { { 8, 6338 } }, /* 153 */
    { { 16, 6346 } }, /* 154 */
    { { 4, 6362 }, { 4, 6422 }, { 4, 6482 } }, /* 155 */
    { { 8, 6366 }, { 8, 6426 }, { 8, 6486 } }, /* 156 */
    { { 4, 6374 }, { 4, 6434 }, { 4, 6494 } }, /* 157 */
    { { 4, 6378 }, { 4, 6438 }, { 4, 6498 } }, /* 158 */
    { { 8, 6382 }, { 8, 6442 }, { 8, 6502 } }, /* 159 */
    { { 8, 6390 }, { 8, 6450 }, { 8, 6510 } }, /* 160 */
    { { 8, 6398 }, { 8, 6458 }, { 8, 6518 } }, /* 161 */
    { { 8, 6406 }, { 8, 6466 }, { 8, 6526 } }, /* 162 */
    { { 8, 6414 }, { 8, 6474 }, { 8, 6534 } }, /* 163 */
    { { 4, 6542 }, { 4, 6622 }, { 4, 6702 }, { 4, 6782 }, { 4, 6862 }, { 4, 6942 } }, /* 164 */
    { { 8, 6546 }, { 8, 6626 }, { 8, 6706 }, { 8, 6786 }, { 8, 6866 }, { 8, 6946 } }, /* 165 */
    { { 4, 6554 }, { 4, 6634 }, { 4, 6714 }, { 4, 6794 }, { 4, 6874 }, { 4, 6954 } }, /* 166 */
    { { 4, 6558 }, { 4, 6638 }, { 4, 6718 }, { 4, 6798 }, { 4, 6878 }, { 4, 6958 } }, /* 167 */
    { { 4, 6562 }, { 4, 6642 }, { 4, 6722 }, { 4, 6802 }, { 4, 6882 }, { 4, 6962 } }, /* 168 */
    { { 8, 6566 }, { 8, 6646 }, { 8, 6726 }, { 8, 6806 }, { 8, 6886 }, { 8, 6966 } }, /* 169 */
    { { 8, 6574 }, { 8, 6654 }, { 8, 6734 }, { 8, 6814 }, { 8, 6894 }, { 8, 6974 } }, /* 170 */
    { { 8, 6582 }, { 8, 6662 }, { 8, 6742 }, { 8, 6822 }, { 8, 6902 }, { 8, 6982 } }, /* 171 */
    { { 8, 6590 }, { 8, 6670 }, { 8, 6750 }, { 8, 6830 }, { 8, 6910 }, { 8, 6990 } }, /* 172 */
    { { 8, 6598 }, { 8, 6678 }, { 8, 6758 }, { 8, 6838 }, { 8, 6918 }, { 8, 6998 } }, /* 173 */
    { { 8, 6606 }, { 8, 6686 }, { 8, 6766 }, { 8, 6846 }, { 8, 6926 }, { 8, 7006 } }, /* 174 */
    { { 8, 6614 }, { 8, 6694 }, { 8, 6774 }, { 8, 6854 }, { 8, 6934 }, { 8, 7014 } }, /* 175 */
    { { 4, 7022 }, { 4, 7082 }, { 4, 7142 } }, /* 176 */
    { { 8, 7026 }, { 8, 7086 }, { 8, 7146 } }, /* 177 */
    { { 4, 7034 }, { 4, 7094 }, { 4, 7154 } }, /* 178 */
    { { 4, 7038 }, { 4, 7098 }, { 4, 7158 } }, /* 179 */
    { { 8, 7042 }, { 8, 7102 }, { 8, 7162 } }, /* 180 */
    { { 8, 7050 }, { 8, 7110 }, { 8, 7170 } }, /* 181 */
    { { 8, 7058 }, { 8, 7118 }, { 8, 7178 } }, /* 182 */
    { { 8, 7066 }, { 8, 7126 }, { 8, 7186 } }, /* 183 */
    { { 8, 7074 }, { 8, 7134 }, { 8, 7194 } }, /* 184 */
    { { 4, 7202 }, { 4, 7282 }, { 4, 7362 }, { 4, 7442 }, { 4, 7522 }, { 4, 7602 } }, /* 185 */
    { { 8, 7206 }, { 8, 7286 }, { 8, 7366 }, { 8, 7446 }, { 8, 7526 }, { 8, 7606 } }, /* 186 */
    { { 4, 7214 }, { 4, 7294 }, { 4, 7374 }, { 4, 7454 }, { 4, 7534 }, { 4, 7614 } }, /* 187 */
    { { 4, 7218 }, { 4, 7298 }, { 4, 7378 }, { 4, 7458 }, { 4, 7538 }, { 4, 7618 } }, /* 188 */
    { { 4, 7222 }, { 4, 7302 }, { 4, 7382 }, { 4, 7462 }, { 4, 7542 }, { 4, 7622 } }, /* 189 */
    { { 8, 7226 }, { 8, 7306 }, { 8, 7386 }, { 8, 7466 }, { 8, 7546 }, { 8, 7626 } }, /* 190 */
    { { 8, 7234 }, { 8, 7314 }, { 8, 7394 }, { 8, 7474 }, { 8, 7554 }, { 8, 7634 } }, /* 191 */
    { { 8, 7242 }, { 8, 7322 }, { 8, 7402 }, { 8, 7482 }, { 8, 7562 }, { 8, 7642 } }, /* 192 */
    { { 8, 7250 }, { 8, 7330 }, { 8, 7410 }, { 8, 7490 }, { 8, 7570 }, { 8, 7650 } }, /* 193 */
    { { 8, 7258 }, { 8, 7338 }, { 8, 7418 }, { 8, 7498 }, { 8, 7578 }, { 8, 7658 } }, /* 194 */
    { { 8, 7266 }, { 8, 7346 }, { 8, 7426 }, { 8, 7506 }, { 8, 7586 }, { 8, 7666 } }, /* 195 */
    { { 8, 7274 }, { 8, 7354 }, { 8, 7434 }, { 8, 7514 }, { 8, 7594 }, { 8, 7674 } }, /* 196 */
    { { 4, 7682 }, { 4, 7762 }, { 4, 7842 }, { 4, 7922 }, { 4, 8002 }, { 4, 8082 } }, /* 197 */
    { { 8, 7686 }, { 8, 7766 }, { 8, 7846 }, { 8, 7926 }, { 8, 8006 }, { 8, 8086 } }, /* 198 */
    { { 4, 7694 }, { 4, 7774 }, { 4, 7854 }, { 4, 7934 }, { 4, 8014 }, { 4, 8094 } }, /* 199 */
    { { 4, 7698 }, { 4, 7778 }, { 4, 7858 }, { 4, 7938 }, { 4, 8018 }, { 4, 8098 } }, /* 200 */
    { { 4, 7702 }, { 4, 7782 }, { 4, 7862 }, { 4, 7942 }, { 4, 8022 }, { 4, 8102 } }, /* 201 */
    { { 8, 7706 }, { 8, 7786 }, { 8, 7866 }, { 8, 7946 }, { 8, 8026 }, { 8, 8106 } }, /* 202 */
    { { 8, 7714 }, { 8, 7794 }, { 8, 7874 }, { 8, 7954 }, { 8, 8034 }, { 8, 8114 } }, /* 203 */
    { { 8, 7722 }, { 8, 7802 }, { 8, 7882 }, { 8, 7962 }, { 8, 8042 }, { 8, 8122 } }, /* 204 */
    { { 8, 7730 }, { 8, 7810 }, { 8, 7890 }, { 8, 7970 }, { 8, 8050 }, { 8, 8130 } }, /* 205 */
    { { 8, 7738 }, { 8, 7818 }, { 8, 7898 }, { 8, 7978 }, { 8, 8058 }, { 8, 8138 } }, /* 206 */
    { { 8, 7746 }, { 8, 7826 }, { 8, 7906 }, { 8, 7986 }, { 8, 8066 }, { 8, 8146 } }, /* 207 */
    { { 8, 7754 }, { 8, 7834 }, { 8, 7914 }, { 8, 7994 }, { 8, 8074 }, { 8, 8154 } }, /* 208 */
    { { 4, 8162 }, { 4, 8242 }, { 4, 8322 }, { 4, 8402 }, { 4, 8482 }, { 4, 8562 } }, /* 209 */
    { { 8, 8166 }, { 8, 8246 }, { 8, 8326 }, { 8, 8406 }, { 8, 8486 }, { 8, 8566 } }, /* 210 */
    { { 4, 8174 }, { 4, 8254 }, { 4, 8334 }, { 4, 8414 }, { 4, 8494 }, { 4, 8574 } }, /* 211 */
    { { 4, 8178 }, { 4, 8258 }, { 4, 8338 }, { 4, 8418 }, { 4, 8498 }, { 4, 8578 } }, /* 212 */
    { { 4, 8182 }, { 4, 8262 }, { 4, 8342 }, { 4, 8422 }, { 4, 8502 }, { 4, 8582 } }, /* 213 */
    { { 8, 8186 }, { 8, 8266 }, { 8, 8346 }, { 8, 8426 }, { 8, 8506 }, { 8, 8586 } }, /* 214 */
    { { 8, 8194 }, { 8, 8274 }, { 8, 8354 }, { 8, 8434 }, { 8, 8514 }, { 8, 8594 } }, /* 215 */
    { { 8, 8202 }, { 8, 8282 }, { 8, 8362 }, { 8, 8442 }, { 8, 8522 }, { 8, 8602 } }, /* 216 */
    { { 8, 8210 }, { 8, 8290 }, { 8, 8370 }, { 8, 8450 }, { 8, 8530 }, { 8, 8610 } }, /* 217 */
    { { 8, 8218 }, { 8, 8298 }, { 8, 8378 }, { 8, 8458 }, { 8, 8538 }, { 8, 8618 } }, /* 218 */
    { { 8, 8226 }, { 8, 8306 }, { 8, 8386 }, { 8, 8466 }, { 8, 8546 }, { 8, 8626 } }, /* 219 */
    { { 8, 8234 }, { 8, 8314 }, { 8, 8394 }, { 8, 8474 }, { 8, 8554 }, { 8, 8634 } }, /* 220 */
    { { 4, 8642 }, { 4, 8722 }, { 4, 8802 }, { 4, 8882 }, { 4, 8962 }, { 4, 9042 } }, /* 221 */
    { { 8, 8646 }, { 8, 8726 }, { 8, 8806 }, { 8, 8886 }, { 8, 8966 }, { 8, 9046 } }, /* 222 */
    { { 4, 8654 }, { 4, 8734 }, { 4, 8814 }, { 4, 8894 }, { 4, 8974 }, { 4, 9054 } }, /* 223 */
    { { 4, 8658 }, { 4, 8738 }, { 4, 8818 }, { 4, 8898 }, { 4, 8978 }, { 4, 9058 } }, /* 224 */
    { { 4, 8662 }, { 4, 8742 }, { 4, 8822 }, { 4, 8902 }, { 4, 8982 }, { 4, 9062 } }, /* 225 */
    { { 8, 8666 }, { 8, 8746 }, { 8, 8826 }, { 8, 8906 }, { 8, 8986 }, { 8, 9066 } }, /* 226 */
    { { 8, 8674 }, { 8, 8754 }, { 8, 8834 }, { 8, 8914 }, { 8, 8994 }, { 8, 9074 } }, /* 227 */
    { { 8, 8682 }, { 8, 8762 }, { 8, 8842 }, { 8, 8922 }, { 8, 9002 }, { 8, 9082 } }, /* 228 */
    { { 8, 8690 }, { 8, 8770 }, { 8, 8850 }, { 8, 8930 }, { 8, 9010 }, { 8, 9090 } }, /* 229 */
    { { 8, 8698 }, { 8, 8778 }, { 8, 8858 }, { 8, 8938 }, { 8, 9018 }, { 8, 9098 } }, /* 230 */
    { { 8, 8706 }, { 8, 8786 }, { 8, 8866 }, { 8, 8946 }, { 8, 9026 }, { 8, 9106 } }, /* 231 */
    { { 8, 8714 }, { 8, 8794 }, { 8, 8874 }, { 8, 8954 }, { 8, 9034 }, { 8, 9114 } }, /* 232 */
    { { 4, 9122 }, { 4, 9182 }, { 4, 9242 } }, /* 233 */
    { { 8, 9126 }, { 8, 9186 }, { 8, 9246 } }, /* 234 */
    { { 4, 9134 }, { 4, 9194 }, { 4, 9254 } }, /* 235 */
    { { 4, 9138 }, { 4, 9198 }, { 4, 9258 } }, /* 236 */
    { { 8, 9142 }, { 8, 9202 }, { 8, 9262 } }, /* 237 */
    { { 8, 9150 }, { 8, 9210 }, { 8, 9270 } }, /* 238 */
    { { 8, 9158 }, { 8, 9218 }, { 8, 9278 } }, /* 239 */
    { { 8, 9166 }, { 8, 9226 }, { 8, 9286 } }, /* 240 */
    { { 8, 9174 }, { 8, 9234 }, { 8, 9294 } }, /* 241 */
    { { 4, 9302 }, { 4, 9382 }, { 4, 9462 }, { 4, 9542 }, { 4, 9622 }, { 4, 9702 } }, /* 242 */
    { { 8, 9306 }, { 8, 9386 }, { 8, 9466 }, { 8, 9546 }, { 8, 9626 }, { 8, 9706 } }, /* 243 */
    { { 4, 9314 }, { 4, 9394 }, { 4, 9474 }, { 4, 9554 }, { 4, 9634 }, { 4, 9714 } }, /* 244 */
    { { 4, 9318 }, { 4, 9398 }, { 4, 9478 }, { 4, 9558 }, { 4, 9638 }, { 4, 9718 } }, /* 245 */
    { { 4, 9322 }, { 4, 9402 }, { 4, 9482 }, { 4, 9562 }, { 4, 9642 }, { 4, 9722 } }, /* 246 */
    { { 8, 9326 }, { 8, 9406 }, { 8, 9486 }, { 8, 9566 }, { 8, 9646 }, { 8, 9726 } }, /* 247 */
    { { 8, 9334 }, { 8, 9414 }, { 8, 9494 }, { 8, 9574 }, { 8, 9654 }, { 8, 9734 } }, /* 248 */
    { { 8, 9342 }, { 8, 9422 }, { 8, 9502 }, { 8, 9582 }, { 8, 9662 }, { 8, 9742 } }, /* 249 */
    { { 8, 9350 }, { 8, 9430 }, { 8, 9510 }, { 8, 9590 }, { 8, 9670 }, { 8, 9750 } }, /* 250 */
    { { 8, 9358 }, { 8, 9438 }, { 8, 9518 }, { 8, 9598 }, { 8, 9678 }, { 8, 9758 } }, /* 251 */
    { { 8, 9366 }, { 8, 9446 }, { 8, 9526 }, { 8, 9606 }, { 8, 9686 }, { 8, 9766 } }, /* 252 */
    { { 8, 9374 }, { 8, 9454 }, { 8, 9534 }, { 8, 9614 }, { 8, 9694 }, { 8, 9774 } }, /* 253 */
    { { 4, 9782 }, { 4, 9842 }, { 4, 9902 } }, /* 254 */
    { { 8, 9786 }, { 8, 9846 }, { 8, 9906 } }, /* 255 */
    { { 4, 9794 }, { 4, 9854 }, { 4, 9914 } }, /* 256 */
    { { 4, 9798 }, { 4, 9858 }, { 4, 9918 } }, /* 257 */
    { { 8, 9802 }, { 8, 9862 }, { 8, 9922 } }, /* 258 */
    { { 8, 9810 }, { 8, 9870 }, { 8, 9930 } }, /* 259 */
    { { 8, 9818 }, { 8, 9878 }, { 8, 9938 } }, /* 260 */
    { { 8, 9826 }, { 8, 9886 }, { 8, 9946 } }, /* 261 */
    { { 8, 9834 }, { 8, 9894 }, { 8, 9954 } }, /* 262 */
    { { 8, 9962 }, { 8, 10050 }, { 8, 10138 } }, /* 263 */
    { { 16, 9970 }, { 16, 10058 }, { 16, 10146 } }, /* 264 */
    { { 8, 9986 }, { 8, 10074 }, { 8, 10162 } }, /* 265 */
    { { 8, 9994 }, { 8, 10082 }, { 8, 10170 } }, /* 266 */
    { { 16, 10002 }, { 16, 10090 }, { 16, 10178 } }, /* 267 */
    { { 16, 10018 }, { 16, 10106 }, { 16, 10194 } }, /* 268 */
    { { 16, 10034 }, { 16, 10122 }, { 16, 10210 } }, /* 269 */
    { { 8, 10226 }, { 8, 10322 }, { 8, 10418 }, { 8, 10514 }, { 8, 10610 }, { 8, 10706 } }, /* 270 */
    { { 16, 10234 }, { 16, 10330 }, { 16, 10426 }, { 16, 10522 }, { 16, 10618 }, { 16, 10714 } }, /* 271 */
    { { 8, 10250 }, { 8, 10346 }, { 8, 10442 }, { 8, 10538 }, { 8, 10634 }, { 8, 10730 } }, /* 272 */
    { { 8, 10258 }, { 8, 10354 }, { 8, 10450 }, { 8, 10546 }, { 8, 10642 }, { 8, 10738 } }, /* 273 */
    { { 8, 10266 }, { 8, 10362 }, { 8, 10458 }, { 8, 10554 }, { 8, 10650 }, { 8, 10746 } }, /* 274 */
    { { 16, 10274 }, { 16, 10370 }, { 16, 10466 }, { 16, 10562 }, { 16, 10658 }, { 16, 10754 } }, /* 275 */
    { { 16, 10290 }, { 16, 10386 }, { 16, 10482 }, { 16, 10578 }, { 16, 10674 }, { 16, 10770 } }, /* 276 */
    { { 16, 10306 }, { 16, 10402 }, { 16, 10498 }, { 16, 10594 }, { 16, 10690 }, { 16, 10786 } }, /* 277 */
    { { 8, 10802 }, { 8, 10890 }, { 8, 10978 } }, /* 278 */
    { { 16, 10810 }, { 16, 10898 }, { 16, 10986 } }, /* 279 */
    { { 8, 10826 }, { 8, 10914 }, { 8, 11002 } }, /* 280 */
    { { 8, 10834 }, { 8, 10922 }, { 8, 11010 } }, /* 281 */
    { { 16, 10842 }, { 16, 10930 }, { 16, 11018 } }, /* 282 */
    { { 16, 10858 }, { 16, 10946 }, { 16, 11034 } }, /* 283 */
    { { 16, 10874 }, { 16, 10962 }, { 16, 11050 } }, /* 284 */
    { { 8, 11066 }, { 8, 11162 }, { 8, 11258 }, { 8, 11354 }, { 8, 11450 }, { 8, 11546 } }, /* 285 */
    { { 16, 11074 }, { 16, 11170 }, { 16, 11266 }, { 16, 11362 }, { 16, 11458 }, { 16, 11554 } }, /* 286 */
    { { 8, 11090 }, { 8, 11186 }, { 8, 11282 }, { 8, 11378 }, { 8, 11474 }, { 8, 11570 } }, /* 287 */
    { { 8, 11098 }, { 8, 11194 }, { 8, 11290 }, { 8, 11386 }, { 8, 11482 }, { 8, 11578 } }, /* 288 */
    { { 8, 11106 }, { 8, 11202 }, { 8, 11298 }, { 8, 11394 }, { 8, 11490 }, { 8, 11586 } }, /* 289 */
    { { 16, 11114 }, { 16, 11210 }, { 16, 11306 }, { 16, 11402 }, { 16, 11498 }, { 16, 11594 } }, /* 290 */
    { { 16, 11130 }, { 16, 11226 }, { 16, 11322 }, { 16, 11418 }, { 16, 11514 }, { 16, 11610 } }, /* 291 */
    { { 16, 11146 }, { 16, 11242 }, { 16, 11338 }, { 16, 11434 }, { 16, 11530 }, { 16, 11626 } }, /* 292 */
    { { 8, 11642 }, { 8, 11738 }, { 8, 11834 }, { 8, 11930 }, { 8, 12026 }, { 8, 12122 } }, /* 293 */
    { { 16, 11650 }, { 16, 11746 }, { 16, 11842 }, { 16, 11938 }, { 16, 12034 }, { 16, 12130 } }, /* 294 */
    { { 8, 11666 }, { 8, 11762 }, { 8, 11858 }, { 8, 11954 }, { 8, 12050 }, { 8, 12146 } }, /* 295 */
    { { 8, 11674 }, { 8, 11770 }, { 8, 11866 }, { 8, 11962 }, { 8, 12058 }, { 8, 12154 } }, /* 296 */
    { { 8, 11682 }, { 8, 11778 }, { 8, 11874 }, { 8, 11970 }, { 8, 12066 }, { 8, 12162 } }, /* 297 */
    { { 16, 11690 }, { 16, 11786 }, { 16, 11882 }, { 16, 11978 }, { 16, 12074 }, { 16, 12170 } }, /* 298 */
    { { 16, 11706 }, { 16, 11802 }, { 16, 11898 }, { 16, 11994 }, { 16, 12090 }, { 16, 12186 } }, /* 299 */
    { { 16, 11722 }, { 16, 11818 }, { 16, 11914 }, { 16, 12010 }, { 16, 12106 }, { 16, 12202 } }, /* 300 */
    { { 8, 12218 }, { 8, 12314 }, { 8, 12410 }, { 8, 12506 }, { 8, 12602 }, { 8, 12698 } }, /* 301 */
    { { 16, 12226 }, { 16, 12322 }, { 16, 12418 }, { 16, 12514 }, { 16, 12610 }, { 16, 12706 } }, /* 302 */
    { { 8, 12242 }, { 8, 12338 }, { 8, 12434 }, { 8, 12530 }, { 8, 12626 }, { 8, 12722 } }, /* 303 */
    { { 8, 12250 }, { 8, 12346 }, { 8, 12442 }, { 8, 12538 }, { 8, 12634 }, { 8, 12730 } }, /* 304 */
    { { 8, 12258 }, { 8, 12354 }, { 8, 12450 }, { 8, 12546 }, { 8, 12642 }, { 8, 12738 } }, /* 305 */
    { { 16, 12266 }, { 16, 12362 }, { 16, 12458 }, { 16, 12554 }, { 16, 12650 }, { 16, 12746 } }, /* 306 */
    { { 16, 12282 }, { 16, 12378 }, { 16, 12474 }, { 16, 12570 }, { 16, 12666 }, { 16, 12762 } }, /* 307 */
    { { 16, 12298 }, { 16, 12394 }, { 16, 12490 }, { 16, 12586 }, { 16, 12682 }, { 16, 12778 } }, /* 308 */
    { { 8, 12794 }, { 8, 12890 }, { 8, 12986 }, { 8, 13082 }, { 8, 13178 }, { 8, 13274 } }, /* 309 */
    { { 16, 12802 }, { 16, 12898 }, { 16, 12994 }, { 16, 13090 }, { 16, 13186 }, { 16, 13282 } }, /* 310 */
    { { 8, 12818 }, { 8, 12914 }, { 8, 13010 }, { 8, 13106 }, { 8, 13202 }, { 8, 13298 } }, /* 311 */
    { { 8, 12826 }, { 8, 12922 }, { 8, 13018 }, { 8, 13114 }, { 8, 13210 }, { 8, 13306 } }, /* 312 */
    { { 8, 12834 }, { 8, 12930 }, { 8, 13026 }, { 8, 13122 }, { 8, 13218 }, { 8, 13314 } }, /* 313 */
    { { 16, 12842 }, { 16, 12938 }, { 16, 13034 }, { 16, 13130 }, { 16, 13226 }, { 16, 13322 } }, /* 314 */
    { { 16, 12858 }, { 16, 12954 }, { 16, 13050 }, { 16, 13146 }, { 16, 13242 }, { 16, 13338 } }, /* 315 */
    { { 16, 12874 }, { 16, 12970 }, { 16, 13066 }, { 16, 13162 }, { 16, 13258 }, { 16, 13354 } }, /* 316 */
    { { 16, 13370 }, { 16, 13482 }, { 16, 13594 } }, /* 317 */
    { { 32, 13386 }, { 32, 13498 }, { 32, 13610 } }, /* 318 */
    { { 16, 13418 }, { 16, 13530 }, { 16, 13642 } }, /* 319 */
    { { 16, 13434 }, { 16, 13546 }, { 16, 13658 } }, /* 320 */
    { { 32, 13450 }, { 32, 13562 }, { 32, 13674 } }, /* 321 */
    { { 16, 13706 }, { 16, 13818 }, { 16, 13930 } }, /* 322 */
    { { 32, 13722 }, { 32, 13834 }, { 32, 13946 } }, /* 323 */
    { { 16, 13754 }, { 16, 13866 }, { 16, 13978 } }, /* 324 */
    { { 16, 13770 }, { 16, 13882 }, { 16, 13994 } }, /* 325 */
    { { 32, 13786 }, { 32, 13898 }, { 32, 14010 } }, /* 326 */
    { { 8, 14042 }, { 8, 14114 }, { 8, 14186 } }, /* 327 */
    { { 16, 14050 }, { 16, 14122 }, { 16, 14194 } }, /* 328 */
    { { 8, 14066 }, { 8, 14138 }, { 8, 14210 } }, /* 329 */
    { { 8, 14074 }, { 8, 14146 }, { 8, 14218 } }, /* 330 */
    { { 16, 14082 }, { 16, 14154 }, { 16, 14226 } }, /* 331 */
    { { 16, 14098 }, { 16, 14170 }, { 16, 14242 } }, /* 332 */
    { { 8, 14258 }, { 8, 14330 }, { 8, 14402 } }, /* 333 */
    { { 16, 14266 }, { 16, 14338 }, { 16, 14410 } }, /* 334 */
    { { 8, 14282 }, { 8, 14354 }, { 8, 14426 } }, /* 335 */
    { { 8, 14290 }, { 8, 14362 }, { 8, 14434 } }, /* 336 */
    { { 16, 14298 }, { 16, 14370 }, { 16, 14442 } }, /* 337 */
    { { 16, 14314 }, { 16, 14386 }, { 16, 14458 } }, /* 338 */
    { { 8, 14474 }, { 8, 14570 }, { 8, 14666 }, { 8, 14762 }, { 8, 14858 }, { 8, 14954 } }, /* 339 */
    { { 16, 14482 }, { 16, 14578 }, { 16, 14674 }, { 16, 14770 }, { 16, 14866 }, { 16, 14962 } }, /* 340 */
    { { 8, 14498 }, { 8, 14594 }, { 8, 14690 }, { 8, 14786 }, { 8, 14882 }, { 8, 14978 } }, /* 341 */
    { { 8, 14506 }, { 8, 14602 }, { 8, 14698 }, { 8, 14794 }, { 8, 14890 }, { 8, 14986 } }, /* 342 */
    { { 8, 14514 }, { 8, 14610 }, { 8, 14706 }, { 8, 14802 }, { 8, 14898 }, { 8, 14994 } }, /* 343 */
    { { 16, 14522 }, { 16, 14618 }, { 16, 14714 }, { 16, 14810 }, { 16, 14906 }, { 16, 15002 } }, /* 344 */
    { { 16, 14538 }, { 16, 14634 }, { 16, 14730 }, { 16, 14826 }, { 16, 14922 }, { 16, 15018 } }, /* 345 */
    { { 16, 14554 }, { 16, 14650 }, { 16, 14746 }, { 16, 14842 }, { 16, 14938 }, { 16, 15034 } }, /* 346 */
    { { 8, 15050 } }, /* 347 */
    { { 16, 15058 } }, /* 348 */
    { { 8, 15074 } }, /* 349 */
    { { 8, 15082 } }, /* 350 */
    { { 8, 15090 } }, /* 351 */
    { { 16, 15098 } }, /* 352 */
    { { 16, 15114 } }, /* 353 */
    { { 16, 15130 } }, /* 354 */
    { { 8, 15146 }, { 8, 15242 } }, /* 355 */
    { { 16, 15154 }, { 16, 15250 } }, /* 356 */
    { { 8, 15170 }, { 8, 15266 } }, /* 357 */
    { { 8, 15178 }, { 8, 15274 } }, /* 358 */
    { { 8, 15186 }, { 8, 15282 } }, /* 359 */
    { { 16, 15194 }, { 16, 15290 } }, /* 360 */
    { { 16, 15210 }, { 16, 15306 } }, /* 361 */
    { { 16, 15226 }, { 16, 15322 } }, /* 362 */
    { { 8, 15338 }, { 8, 15482 }, { 8, 15626 } }, /* 363 */
    { { 16, 15346 }, { 16, 15490 }, { 16, 15634 } }, /* 364 */
    { { 8, 15362 }, { 8, 15506 }, { 8, 15650 } }, /* 365 */
    { { 8, 15370 }, { 8, 15514 }, { 8, 15658 } }, /* 366 */
    { { 8, 15378 }, { 8, 15522 }, { 8, 15666 } }, /* 367 */
    { { 8, 15386 }, { 8, 15530 }, { 8, 15674 } }, /* 368 */
    { { 8, 15394 }, { 8, 15538 }, { 8, 15682 } }, /* 369 */
    { { 16, 15402 }, { 16, 15546 }, { 16, 15690 } }, /* 370 */
    { { 16, 15418 }, { 16, 15562 }, { 16, 15706 } }, /* 371 */
    { { 16, 15434 }, { 16, 15578 }, { 16, 15722 } }, /* 372 */
    { { 16, 15450 }, { 16, 15594 }, { 16, 15738 } }, /* 373 */
    { { 16, 15466 }, { 16, 15610 }, { 16, 15754 } }, /* 374 */
    { { 8, 15770 }, { 8, 15914 }, { 8, 16058 }, { 8, 16202 }, { 8, 16346 }, { 8, 16490 } }, /* 375 */
    { { 16, 15778 }, { 16, 15922 }, { 16, 16066 }, { 16, 16210 }, { 16, 16354 }, { 16, 16498 } }, /* 376 */
    { { 8, 15794 }, { 8, 15938 }, { 8, 16082 }, { 8, 16226 }, { 8, 16370 }, { 8, 16514 } }, /* 377 */
    { { 8, 15802 }, { 8, 15946 }, { 8, 16090 }, { 8, 16234 }, { 8, 16378 }, { 8, 16522 } }, /* 378 */
    { { 8, 15810 }, { 8, 15954 }, { 8, 16098 }, { 8, 16242 }, { 8, 16386 }, { 8, 16530 } }, /* 379 */
    { { 8, 15818 }, { 8, 15962 }, { 8, 16106 }, { 8, 16250 }, { 8, 16394 }, { 8, 16538 } }, /* 380 */
    { { 8, 15826 }, { 8, 15970 }, { 8, 16114 }, { 8, 16258 }, { 8, 16402 }, { 8, 16546 } }, /* 381 */
    { { 16, 15834 }, { 16, 15978 }, { 16, 16122 }, { 16, 16266 }, { 16, 16410 }, { 16, 16554 } }, /* 382 */
    { { 16, 15850 }, { 16, 15994 }, { 16, 16138 }, { 16, 16282 }, { 16, 16426 }, { 16, 16570 } }, /* 383 */
    { { 16, 15866 }, { 16, 16010 }, { 16, 16154 }, { 16, 16298 }, { 16, 16442 }, { 16, 16586 } }, /* 384 */
    { { 16, 15882 }, { 16, 16026 }, { 16, 16170 }, { 16, 16314 }, { 16, 16458 }, { 16, 16602 } }, /* 385 */
    { { 16, 15898 }, { 16, 16042 }, { 16, 16186 }, { 16, 16330 }, { 16, 16474 }, { 16, 16618 } }, /* 386 */
    { { 8, 16634 }, { 8, 16826 }, { 8, 17018 }, { 8, 17210 }, { 8, 17402 }, { 8, 17594 } }, /* 387 */
    { { 16, 16642 }, { 16, 16834 }, { 16, 17026 }, { 16, 17218 }, { 16, 17410 }, { 16, 17602 } }, /* 388 */
    { { 8, 16658 }, { 8, 16850 }, { 8, 17042 }, { 8, 17234 }, { 8, 17426 }, { 8, 17618 } }, /* 389 */
    { { 8, 16666 }, { 8, 16858 }, { 8, 17050 }, { 8, 17242 }, { 8, 17434 }, { 8, 17626 } }, /* 390 */
    { { 8, 16674 }, { 8, 16866 }, { 8, 17058 }, { 8, 17250 }, { 8, 17442 }, { 8, 17634 } }, /* 391 */
    { { 8, 16682 }, { 8, 16874 }, { 8, 17066 }, { 8, 17258 }, { 8, 17450 }, { 8, 17642 } }, /* 392 */
    { { 8, 16690 }, { 8, 16882 }, { 8, 17074 }, { 8, 17266 }, { 8, 17458 }, { 8, 17650 } }, /* 393 */
    { { 8, 16698 }, { 8, 16890 }, { 8, 17082 }, { 8, 17274 }, { 8, 17466 }, { 8, 17658 } }, /* 394 */
    { { 8, 16706 }, { 8, 16898 }, { 8, 17090 }, { 8, 17282 }, { 8, 17474 }, { 8, 17666 } }, /* 395 */
    { { 16, 16714 }, { 16, 16906 }, { 16, 17098 }, { 16, 17290 }, { 16, 17482 }, { 16, 17674 } }, /* 396 */
    { { 16, 16730 }, { 16, 16922 }, { 16, 17114 }, { 16, 17306 }, { 16, 17498 }, { 16, 17690 } }, /* 397 */
    { { 16, 16746 }, { 16, 16938 }, { 16, 17130 }, { 16, 17322 }, { 16, 17514 }, { 16, 17706 } }, /* 398 */
    { { 16, 16762 }, { 16, 16954 }, { 16, 17146 }, { 16, 17338 }, { 16, 17530 }, { 16, 17722 } }, /* 399 */
    { { 16, 16778 }, { 16, 16970 }, { 16, 17162 }, { 16, 17354 }, { 16, 17546 }, { 16, 17738 } }, /* 400 */
    { { 16, 16794 }, { 16, 16986 }, { 16, 17178 }, { 16, 17370 }, { 16, 17562 }, { 16, 17754 } }, /* 401 */
    { { 16, 16810 }, { 16, 17002 }, { 16, 17194 }, { 16, 17386 }, { 16, 17578 }, { 16, 17770 } }, /* 402 */
    { { 8, 17786 }, { 8, 17978 }, { 8, 18170 }, { 8, 18362 }, { 8, 18554 }, { 8, 18746 } }, /* 403 */
    { { 16, 17794 }, { 16, 17986 }, { 16, 18178 }, { 16, 18370 }, { 16, 18562 }, { 16, 18754 } }, /* 404 */
    { { 8, 17810 }, { 8, 18002 }, { 8, 18194 }, { 8, 18386 }, { 8, 18578 }, { 8, 18770 } }, /* 405 */
    { { 8, 17818 }, { 8, 18010 }, { 8, 18202 }, { 8, 18394 }, { 8, 18586 }, { 8, 18778 } }, /* 406 */
    { { 8, 17826 }, { 8, 18018 }, { 8, 18210 }, { 8, 18402 }, { 8, 18594 }, { 8, 18786 } }, /* 407 */
    { { 8, 17834 }, { 8, 18026 }, { 8, 18218 }, { 8, 18410 }, { 8, 18602 }, { 8, 18794 } }, /* 408 */
    { { 8, 17842 }, { 8, 18034 }, { 8, 18226 }, { 8, 18418 }, { 8, 18610 }, { 8, 18802 } }, /* 409 */
    { { 8, 17850 }, { 8, 18042 }, { 8, 18234 }, { 8, 18426 }, { 8, 18618 }, { 8, 18810 } }, /* 410 */
    { { 8, 17858 }, { 8, 18050 }, { 8, 18242 }, { 8, 18434 }, { 8, 18626 }, { 8, 18818 } }, /* 411 */
    { { 16, 17866 }, { 16, 18058 }, { 16, 18250 }, { 16, 18442 }, { 16, 18634 }, { 16, 18826 } }, /* 412 */
    { { 16, 17882 }, { 16, 18074 }, { 16, 18266 }, { 16, 18458 }, { 16, 18650 }, { 16, 18842 } }, /* 413 */
    { { 16, 17898 }, { 16, 18090 }, { 16, 18282 }, { 16, 18474 }, { 16, 18666 }, { 16, 18858 } }, /* 414 */
    { { 16, 17914 }, { 16, 18106 }, { 16, 18298 }, { 16, 18490 }, { 16, 18682 }, { 16, 18874 } }, /* 415 */
    { { 16, 17930 }, { 16, 18122 }, { 16, 18314 }, { 16, 18506 }, { 16, 18698 }, { 16, 18890 } }, /* 416 */
    { { 16, 17946 }, { 16, 18138 }, { 16, 18330 }, { 16, 18522 }, { 16, 18714 }, { 16, 18906 } }, /* 417 */
    { { 16, 17962 }, { 16, 18154 }, { 16, 18346 }, { 16, 18538 }, { 16, 18730 }, { 16, 18922 } }, /* 418 */
    { { 8, 18938 }, { 8, 19130 }, { 8, 19322 }, { 8, 19514 }, { 8, 19706 }, { 8, 19898 } }, /* 419 */
    { { 16, 18946 }, { 16, 19138 }, { 16, 19330 }, { 16, 19522 }, { 16, 19714 }, { 16, 19906 } }, /* 420 */
    { { 8, 18962 }, { 8, 19154 }, { 8, 19346 }, { 8, 19538 }, { 8, 19730 }, { 8, 19922 } }, /* 421 */
    { { 8, 18970 }, { 8, 19162 }, { 8, 19354 }, { 8, 19546 }, { 8, 19738 }, { 8, 19930 } }, /* 422 */
    { { 8, 18978 }, { 8, 19170 }, { 8, 19362 }, { 8, 19554 }, { 8, 19746 }, { 8, 19938 } }, /* 423 */
    { { 8, 18986 }, { 8, 19178 }, { 8, 19370 }, { 8, 19562 }, { 8, 19754 }, { 8, 19946 } }, /* 424 */
    { { 8, 18994 }, { 8, 19186 }, { 8, 19378 }, { 8, 19570 }, { 8, 19762 }, { 8, 19954 } }, /* 425 */
    { { 8, 19002 }, { 8, 19194 }, { 8, 19386 }, { 8, 19578 }, { 8, 19770 }, { 8, 19962 } }, /* 426 */
    { { 8, 19010 }, { 8, 19202 }, { 8, 19394 }, { 8, 19586 }, { 8, 19778 }, { 8, 19970 } }, /* 427 */
    { { 16, 19018 }, { 16, 19210 }, { 16, 19402 }, { 16, 19594 }, { 16, 19786 }, { 16, 19978 } }, /* 428 */
    { { 16, 19034 }, { 16, 19226 }, { 16, 19418 }, { 16, 19610 }, { 16, 19802 }, { 16, 19994 } }, /* 429 */
    { { 16, 19050 }, { 16, 19242 }, { 16, 19434 }, { 16, 19626 }, { 16, 19818 }, { 16, 20010 } }, /* 430 */
    { { 16, 19066 }, { 16, 19258 }, { 16, 19450 }, { 16, 19642 }, { 16, 19834 }, { 16, 20026 } }, /* 431 */
    { { 16, 19082 }, { 16, 19274 }, { 16, 19466 }, { 16, 19658 }, { 16, 19850 }, { 16, 20042 } }, /* 432 */
    { { 16, 19098 }, { 16, 19290 }, { 16, 19482 }, { 16, 19674 }, { 16, 19866 }, { 16, 20058 } }, /* 433 */
    { { 16, 19114 }, { 16, 19306 }, { 16, 19498 }, { 16, 19690 }, { 16, 19882 }, { 16, 20074 } }, /* 434 */
    { { 8, 20090 }, { 8, 20282 }, { 8, 20474 }, { 8, 20666 }, { 8, 20858 }, { 8, 21050 } }, /* 435 */
    { { 16, 20098 }, { 16, 20290 }, { 16, 20482 }, { 16, 20674 }, { 16, 20866 }, { 16, 21058 } }, /* 436 */
    { { 8, 20114 }, { 8, 20306 }, { 8, 20498 }, { 8, 20690 }, { 8, 20882 }, { 8, 21074 } }, /* 437 */
    { { 8, 20122 }, { 8, 20314 }, { 8, 20506 }, { 8, 20698 }, { 8, 20890 }, { 8, 21082 } }, /* 438 */
    { { 8, 20130 }, { 8, 20322 }, { 8, 20514 }, { 8, 20706 }, { 8, 20898 }, { 8, 21090 } }, /* 439 */
    { { 8, 20138 }, { 8, 20330 }, { 8, 20522 }, { 8, 20714 }, { 8, 20906 }, { 8, 21098 } }, /* 440 */
    { { 8, 20146 }, { 8, 20338 }, { 8, 20530 }, { 8, 20722 }, { 8, 20914 }, { 8, 21106 } }, /* 441 */
    { { 8, 20154 }, { 8, 20346 }, { 8, 20538 }, { 8, 20730 }, { 8, 20922 }, { 8, 21114 } }, /* 442 */
    { { 8, 20162 }, { 8, 20354 }, { 8, 20546 }, { 8, 20738 }, { 8, 20930 }, { 8, 21122 } }, /* 443 */
    { { 16, 20170 }, { 16, 20362 }, { 16, 20554 }, { 16, 20746 }, { 16, 20938 }, { 16, 21130 } }, /* 444 */
    { { 16, 20186 }, { 16, 20378 }, { 16, 20570 }, { 16, 20762 }, { 16, 20954 }, { 16, 21146 } }, /* 445 */
    { { 16, 20202 }, { 16, 20394 }, { 16, 20586 }, { 16, 20778 }, { 16, 20970 }, { 16, 21162 } }, /* 446 */
    { { 16, 20218 }, { 16, 20410 }, { 16, 20602 }, { 16, 20794 }, { 16, 20986 }, { 16, 21178 } }, /* 447 */
    { { 16, 20234 }, { 16, 20426 }, { 16, 20618 }, { 16, 20810 }, { 16, 21002 }, { 16, 21194 } }, /* 448 */
    { { 16, 20250 }, { 16, 20442 }, { 16, 20634 }, { 16, 20826 }, { 16, 21018 }, { 16, 21210 } }, /* 449 */
    { { 16, 20266 }, { 16, 20458 }, { 16, 20650 }, { 16, 20842 }, { 16, 21034 }, { 16, 21226 } }, /* 450 */
    { { 8, 21242 }, { 8, 21386 }, { 8, 21530 } }, /* 451 */
    { { 16, 21250 }, { 16, 21394 }, { 16, 21538 } }, /* 452 */
    { { 8, 21266 }, { 8, 21410 }, { 8, 21554 } }, /* 453 */
    { { 8, 21274 }, { 8, 21418 }, { 8, 21562 } }, /* 454 */
    { { 8, 21282 }, { 8, 21426 }, { 8, 21570 } }, /* 455 */
    { { 8, 21290 }, { 8, 21434 }, { 8, 21578 } }, /* 456 */
    { { 8, 21298 }, { 8, 21442 }, { 8, 21586 } }, /* 457 */
    { { 16, 21306 }, { 16, 21450 }, { 16, 21594 } }, /* 458 */
    { { 16, 21322 }, { 16, 21466 }, { 16, 21610 } }, /* 459 */
    { { 16, 21338 }, { 16, 21482 }, { 16, 21626 } }, /* 460 */
    { { 16, 21354 }, { 16, 21498 }, { 16, 21642 } }, /* 461 */
    { { 16, 21370 }, { 16, 21514 }, { 16, 21658 } }, /* 462 */
    { { 8, 21674 }, { 8, 21818 }, { 8, 21962 } }, /* 463 */
    { { 16, 21682 }, { 16, 21826 }, { 16, 21970 } }, /* 464 */
    { { 8, 21698 }, { 8, 21842 }, { 8, 21986 } }, /* 465 */
    { { 8, 21706 }, { 8, 21850 }, { 8, 21994 } }, /* 466 */
    { { 8, 21714 }, { 8, 21858 }, { 8, 22002 } }, /* 467 */
    { { 8, 21722 }, { 8, 21866 }, { 8, 22010 } }, /* 468 */
    { { 8, 21730 }, { 8, 21874 }, { 8, 22018 } }, /* 469 */
    { { 16, 21738 }, { 16, 21882 }, { 16, 22026 } }, /* 470 */
    { { 16, 21754 }, { 16, 21898 }, { 16, 22042 } }, /* 471 */
    { { 16, 21770 }, { 16, 21914 }, { 16, 22058 } }, /* 472 */
    { { 16, 21786 }, { 16, 21930 }, { 16, 22074 } }, /* 473 */
    { { 16, 21802 }, { 16, 21946 }, { 16, 22090 } }, /* 474 */
    { { 8, 22106 }, { 8, 22298 }, { 8, 22490 }, { 8, 22682 }, { 8, 22874 }, { 8, 23066 } }, /* 475 */
    { { 16, 22114 }, { 16, 22306 }, { 16, 22498 }, { 16, 22690 }, { 16, 22882 }, { 16, 23074 } }, /* 476 */
    { { 8, 22130 }, { 8, 22322 }, { 8, 22514 }, { 8, 22706 }, { 8, 22898 }, { 8, 23090 } }, /* 477 */
    { { 8, 22138 }, { 8, 22330 }, { 8, 22522 }, { 8, 22714 }, { 8, 22906 }, { 8, 23098 } }, /* 478 */
    { { 8, 22146 }, { 8, 22338 }, { 8, 22530 }, { 8, 22722 }, { 8, 22914 }, { 8, 23106 } }, /* 479 */
    { { 8, 22154 }, { 8, 22346 }, { 8, 22538 }, { 8, 22730 }, { 8, 22922 }, { 8, 23114 } }, /* 480 */
    { { 8, 22162 }, { 8, 22354 }, { 8, 22546 }, { 8, 22738 }, { 8, 22930 }, { 8, 23122 } }, /* 481 */
    { { 8, 22170 }, { 8, 22362 }, { 8, 22554 }, { 8, 22746 }, { 8, 22938 }, { 8, 23130 } }, /* 482 */
    { { 8, 22178 }, { 8, 22370 }, { 8, 22562 }, { 8, 22754 }, { 8, 22946 }, { 8, 23138 } }, /* 483 */
    { { 16, 22186 }, { 16, 22378 }, { 16, 22570 }, { 16, 22762 }, { 16, 22954 }, { 16, 23146 } }, /* 484 */
    { { 16, 22202 }, { 16, 22394 }, { 16, 22586 }, { 16, 22778 }, { 16, 22970 }, { 16, 23162 } }, /* 485 */
    { { 16, 22218 }, { 16, 22410 }, { 16, 22602 }, { 16, 22794 }, { 16, 22986 }, { 16, 23178 } }, /* 486 */
    { { 16, 22234 }, { 16, 22426 }, { 16, 22618 }, { 16, 22810 }, { 16, 23002 }, { 16, 23194 } }, /* 487 */
    { { 16, 22250 }, { 16, 22442 }, { 16, 22634 }, { 16, 22826 }, { 16, 23018 }, { 16, 23210 } }, /* 488 */
    { { 16, 22266 }, { 16, 22458 }, { 16, 22650 }, { 16, 22842 }, { 16, 23034 }, { 16, 23226 } }, /* 489 */
    { { 16, 22282 }, { 16, 22474 }, { 16, 22666 }, { 16, 22858 }, { 16, 23050 }, { 16, 23242 } }, /* 490 */
    { { 8, 23258 }, { 8, 23402 }, { 8, 23546 } }, /* 491 */
    { { 16, 23266 }, { 16, 23410 }, { 16, 23554 } }, /* 492 */
    { { 8, 23282 }, { 8, 23426 }, { 8, 23570 } }, /* 493 */
    { { 8, 23290 }, { 8, 23434 }, { 8, 23578 } }, /* 494 */
    { { 8, 23298 }, { 8, 23442 }, { 8, 23586 } }, /* 495 */
    { { 8, 23306 }, { 8, 23450 }, { 8, 23594 } }, /* 496 */
    { { 8, 23314 }, { 8, 23458 }, { 8, 23602 } }, /* 497 */
    { { 16, 23322 }, { 16, 23466 }, { 16, 23610 } }, /* 498 */
    { { 16, 23338 }, { 16, 23482 }, { 16, 23626 } }, /* 499 */
    { { 16, 23354 }, { 16, 23498 }, { 16, 23642 } }, /* 500 */
    { { 16, 23370 }, { 16, 23514 }, { 16, 23658 } }, /* 501 */
    { { 16, 23386 }, { 16, 23530 }, { 16, 23674 } }, /* 502 */
    { { 8, 23690 }, { 8, 23834 }, { 8, 23978 }, { 8, 24122 }, { 8, 24266 }, { 8, 24410 } }, /* 503 */
    { { 16, 23698 }, { 16, 23842 }, { 16, 23986 }, { 16, 24130 }, { 16, 24274 }, { 16, 24418 } }, /* 504 */
    { { 8, 23714 }, { 8, 23858 }, { 8, 24002 }, { 8, 24146 }, { 8, 24290 }, { 8, 24434 } }, /* 505 */
    { { 8, 23722 }, { 8, 23866 }, { 8, 24010 }, { 8, 24154 }, { 8, 24298 }, { 8, 24442 } }, /* 506 */
    { { 8, 23730 }, { 8, 23874 }, { 8, 24018 }, { 8, 24162 }, { 8, 24306 }, { 8, 24450 } }, /* 507 */
    { { 8, 23738 }, { 8, 23882 }, { 8, 24026 }, { 8, 24170 }, { 8, 24314 }, { 8, 24458 } }, /* 508 */
    { { 8, 23746 }, { 8, 23890 }, { 8, 24034 }, { 8, 24178 }, { 8, 24322 }, { 8, 24466 } }, /* 509 */
    { { 16, 23754 }, { 16, 23898 }, { 16, 24042 }, { 16, 24186 }, { 16, 24330 }, { 16, 24474 } }, /* 510 */
    { { 16, 23770 }, { 16, 23914 }, { 16, 24058 }, { 16, 24202 }, { 16, 24346 }, { 16, 24490 } }, /* 511 */
    { { 16, 23786 }, { 16, 23930 }, { 16, 24074 }, { 16, 24218 }, { 16, 24362 }, { 16, 24506 } }, /* 512 */
    { { 16, 23802 }, { 16, 23946 }, { 16, 24090 }, { 16, 24234 }, { 16, 24378 }, { 16, 24522 } }, /* 513 */
    { { 16, 23818 }, { 16, 23962 }, { 16, 24106 }, { 16, 24250 }, { 16, 24394 }, { 16, 24538 } }, /* 514 */
    { { 8, 24554 }, { 8, 24746 }, { 8, 24938 }, { 8, 25130 }, { 8, 25322 }, { 8, 25514 } }, /* 515 */
    { { 16, 24562 }, { 16, 24754 }, { 16, 24946 }, { 16, 25138 }, { 16, 25330 }, { 16, 25522 } }, /* 516 */
    { { 8, 24578 }, { 8, 24770 }, { 8, 24962 }, { 8, 25154 }, { 8, 25346 }, { 8, 25538 } }, /* 517 */
    { { 8, 24586 }, { 8, 24778 }, { 8, 24970 }, { 8, 25162 }, { 8, 25354 }, { 8, 25546 } }, /* 518 */
    { { 8, 24594 }, { 8, 24786 }, { 8, 24978 }, { 8, 25170 }, { 8, 25362 }, { 8, 25554 } }, /* 519 */
    { { 8, 24602 }, { 8, 24794 }, { 8, 24986 }, { 8, 25178 }, { 8, 25370 }, { 8, 25562 } }, /* 520 */
    { { 8, 24610 }, { 8, 24802 }, { 8, 24994 }, { 8, 25186 }, { 8, 25378 }, { 8, 25570 } }, /* 521 */
    { { 8, 24618 }, { 8, 24810 }, { 8, 25002 }, { 8, 25194 }, { 8, 25386 }, { 8, 25578 } }, /* 522 */
    { { 8, 24626 }, { 8, 24818 }, { 8, 25010 }, { 8, 25202 }, { 8, 25394 }, { 8, 25586 } }, /* 523 */
    { { 16, 24634 }, { 16, 24826 }, { 16, 25018 }, { 16, 25210 }, { 16, 25402 }, { 16, 25594 } }, /* 524 */
    { { 16, 24650 }, { 16, 24842 }, { 16, 25034 }, { 16, 25226 }, { 16, 25418 }, { 16, 25610 } }, /* 525 */
    { { 16, 24666 }, { 16, 24858 }, { 16, 25050 }, { 16, 25242 }, { 16, 25434 }, { 16, 25626 } }, /* 526 */
    { { 16, 24682 }, { 16, 24874 }, { 16, 25066 }, { 16, 25258 }, { 16, 25450 }, { 16, 25642 } }, /* 527 */
    { { 16, 24698 }, { 16, 24890 }, { 16, 25082 }, { 16, 25274 }, { 16, 25466 }, { 16, 25658 } }, /* 528 */
    { { 16, 24714 }, { 16, 24906 }, { 16, 25098 }, { 16, 25290 }, { 16, 25482 }, { 16, 25674 } }, /* 529 */
    { { 16, 24730 }, { 16, 24922 }, { 16, 25114 }, { 16, 25306 }, { 16, 25498 }, { 16, 25690 } }, /* 530 */
    { { 8, 25706 }, { 8, 25802 } }, /* 531 */
    { { 16, 25714 }, { 16, 25810 } }, /* 532 */
    { { 8, 25730 }, { 8, 25826 } }, /* 533 */
    { { 8, 25738 }, { 8, 25834 } }, /* 534 */
    { { 8, 25746 }, { 8, 25842 } }, /* 535 */
    { { 16, 25754 }, { 16, 25850 } }, /* 536 */
    { { 16, 25770 }, { 16, 25866 } }, /* 537 */
    { { 16, 25786 }, { 16, 25882 } }, /* 538 */
    { { 8, 25898 }, { 8, 26090 }, { 8, 26282 }, { 8, 26474 }, { 8, 26666 }, { 8, 26858 } }, /* 539 */
    { { 16, 25906 }, { 16, 26098 }, { 16, 26290 }, { 16, 26482 }, { 16, 26674 }, { 16, 26866 } }, /* 540 */
    { { 8, 25922 }, { 8, 26114 }, { 8, 26306 }, { 8, 26498 }, { 8, 26690 }, { 8, 26882 } }, /* 541 */
    { { 8, 25930 }, { 8, 26122 }, { 8, 26314 }, { 8, 26506 }, { 8, 26698 }, { 8, 26890 } }, /* 542 */
    { { 8, 25938 }, { 8, 26130 }, { 8, 26322 }, { 8, 26514 }, { 8, 26706 }, { 8, 26898 } }, /* 543 */
    { { 8, 25946 }, { 8, 26138 }, { 8, 26330 }, { 8, 26522 }, { 8, 26714 }, { 8, 26906 } }, /* 544 */
    { { 8, 25954 }, { 8, 26146 }, { 8, 26338 }, { 8, 26530 }, { 8, 26722 }, { 8, 26914 } }, /* 545 */
    { { 8, 25962 }, { 8, 26154 }, { 8, 26346 }, { 8, 26538 }, { 8, 26730 }, { 8, 26922 } }, /* 546 */
    { { 8, 25970 }, { 8, 26162 }, { 8, 26354 }, { 8, 26546 }, { 8, 26738 }, { 8, 26930 } }, /* 547 */
    { { 16, 25978 }, { 16, 26170 }, { 16, 26362 }, { 16, 26554 }, { 16, 26746 }, { 16, 26938 } }, /* 548 */
    { { 16, 25994 }, { 16, 26186 }, { 16, 26378 }, { 16, 26570 }, { 16, 26762 }, { 16, 26954 } }, /* 549 */
    { { 16, 26010 }, { 16, 26202 }, { 16, 26394 }, { 16, 26586 }, { 16, 26778 }, { 16, 26970 } }, /* 550 */
    { { 16, 26026 }, { 16, 26218 }, { 16, 26410 }, { 16, 26602 }, { 16, 26794 }, { 16, 26986 } }, /* 551 */
    { { 16, 26042 }, { 16, 26234 }, { 16, 26426 }, { 16, 26618 }, { 16, 26810 }, { 16, 27002 } }, /* 552 */
    { { 16, 26058 }, { 16, 26250 }, { 16, 26442 }, { 16, 26634 }, { 16, 26826 }, { 16, 27018 } }, /* 553 */
    { { 16, 26074 }, { 16, 26266 }, { 16, 26458 }, { 16, 26650 }, { 16, 26842 }, { 16, 27034 } }, /* 554 */
    { { 16, 27050 }, { 16, 27306 }, { 16, 27562 }, { 16, 27818 }, { 16, 28074 }, { 16, 28330 } }, /* 555 */
    { { 32, 27066 }, { 32, 27322 }, { 32, 27578 }, { 32, 27834 }, { 32, 28090 }, { 32, 28346 } }, /* 556 */
    { { 16, 27098 }, { 16, 27354 }, { 16, 27610 }, { 16, 27866 }, { 16, 28122 }, { 16, 28378 } }, /* 557 */
    { { 16, 27114 }, { 16, 27370 }, { 16, 27626 }, { 16, 27882 }, { 16, 28138 }, { 16, 28394 } }, /* 558 */
    { { 16, 27130 }, { 16, 27386 }, { 16, 27642 }, { 16, 27898 }, { 16, 28154 }, { 16, 28410 } }, /* 559 */
    { { 16, 27146 }, { 16, 27402 }, { 16, 27658 }, { 16, 27914 }, { 16, 28170 }, { 16, 28426 } }, /* 560 */
    { { 16, 27162 }, { 16, 27418 }, { 16, 27674 }, { 16, 27930 }, { 16, 28186 }, { 16, 28442 } }, /* 561 */
    { { 16, 27178 }, { 16, 27434 }, { 16, 27690 }, { 16, 27946 }, { 16, 28202 }, { 16, 28458 } }, /* 562 */
    { { 16, 27194 }, { 16, 27450 }, { 16, 27706 }, { 16, 27962 }, { 16, 28218 }, { 16, 28474 } }, /* 563 */
    { { 32, 27210 }, { 32, 27466 }, { 32, 27722 }, { 32, 27978 }, { 32, 28234 }, { 32, 28490 } }, /* 564 */
    { { 32, 27242 }, { 32, 27498 }, { 32, 27754 }, { 32, 28010 }, { 32, 28266 }, { 32, 28522 } }, /* 565 */
    { { 32, 27274 }, { 32, 27530 }, { 32, 27786 }, { 32, 28042 }, { 32, 28298 }, { 32, 28554 } }, /* 566 */
    { { 16, 28586 }, { 16, 28842 }, { 16, 29098 }, { 16, 29354 }, { 16, 29610 }, { 16, 29866 } }, /* 567 */
    { { 32, 28602 }, { 32, 28858 }, { 32, 29114 }, { 32, 29370 }, { 32, 29626 }, { 32, 29882 } }, /* 568 */
    { { 16, 28634 }, { 16, 28890 }, { 16, 29146 }, { 16, 29402 }, { 16, 29658 }, { 16, 29914 } }, /* 569 */
    { { 16, 28650 }, { 16, 28906 }, { 16, 29162 }, { 16, 29418 }, { 16, 29674 }, { 16, 29930 } }, /* 570 */
    { { 16, 28666 }, { 16, 28922 }, { 16, 29178 }, { 16, 29434 }, { 16, 29690 }, { 16, 29946 } }, /* 571 */
    { { 16, 28682 }, { 16, 28938 }, { 16, 29194 }, { 16, 29450 }, { 16, 29706 }, { 16, 29962 } }, /* 572 */
    { { 16, 28698 }, { 16, 28954 }, { 16, 29210 }, { 16, 29466 }, { 16, 29722 }, { 16, 29978 } }, /* 573 */
    { { 16, 28714 }, { 16, 28970 }, { 16, 29226 }, { 16, 29482 }, { 16, 29738 }, { 16, 29994 } }, /* 574 */
    { { 16, 28730 }, { 16, 28986 }, { 16, 29242 }, { 16, 29498 }, { 16, 29754 }, { 16, 30010 } }, /* 575 */
    { { 32, 28746 }, { 32, 29002 }, { 32, 29258 }, { 32, 29514 }, { 32, 29770 }, { 32, 30026 } }, /* 576 */
    { { 32, 28778 }, { 32, 29034 }, { 32, 29290 }, { 32, 29546 }, { 32, 29802 }, { 32, 30058 } }, /* 577 */
    { { 32, 28810 }, { 32, 29066 }, { 32, 29322 }, { 32, 29578 }, { 32, 29834 }, { 32, 30090 } }, /* 578 */
    { { 16, 30122 }, { 16, 30346 }, { 16, 30570 } }, /* 579 */
    { { 32, 30138 }, { 32, 30362 }, { 32, 30586 } }, /* 580 */
    { { 16, 30170 }, { 16, 30394 }, { 16, 30618 } }, /* 581 */
    { { 16, 30186 }, { 16, 30410 }, { 16, 30634 } }, /* 582 */
    { { 16, 30202 }, { 16, 30426 }, { 16, 30650 } }, /* 583 */
    { { 16, 30218 }, { 16, 30442 }, { 16, 30666 } }, /* 584 */
    { { 16, 30234 }, { 16, 30458 }, { 16, 30682 } }, /* 585 */
    { { 32, 30250 }, { 32, 30474 }, { 32, 30698 } }, /* 586 */
    { { 32, 30282 }, { 32, 30506 }, { 32, 30730 } }, /* 587 */
    { { 32, 30314 }, { 32, 30538 }, { 32, 30762 } }, /* 588 */
    { { 16, 30794 }, { 16, 31018 }, { 16, 31242 } }, /* 589 */
    { { 32, 30810 }, { 32, 31034 }, { 32, 31258 } }, /* 590 */
    { { 16, 30842 }, { 16, 31066 }, { 16, 31290 } }, /* 591 */
    { { 16, 30858 }, { 16, 31082 }, { 16, 31306 } }, /* 592 */
    { { 16, 30874 }, { 16, 31098 }, { 16, 31322 } }, /* 593 */
    { { 16, 30890 }, { 16, 31114 }, { 16, 31338 } }, /* 594 */
    { { 16, 30906 }, { 16, 31130 }, { 16, 31354 } }, /* 595 */
    { { 32, 30922 }, { 32, 31146 }, { 32, 31370 } }, /* 596 */
    { { 32, 30954 }, { 32, 31178 }, { 32, 31402 } }, /* 597 */
    { { 32, 30986 }, { 32, 31210 }, { 32, 31434 } }, /* 598 */
    { { 16, 31466 }, { 16, 31690 }, { 16, 31914 }, { 16, 32138 }, { 16, 32362 }, { 16, 32586 } }, /* 599 */
    { { 32, 31482 }, { 32, 31706 }, { 32, 31930 }, { 32, 32154 }, { 32, 32378 }, { 32, 32602 } }, /* 600 */
    { { 16, 31514 }, { 16, 31738 }, { 16, 31962 }, { 16, 32186 }, { 16, 32410 }, { 16, 32634 } }, /* 601 */
    { { 16, 31530 }, { 16, 31754 }, { 16, 31978 }, { 16, 32202 }, { 16, 32426 }, { 16, 32650 } }, /* 602 */
    { { 16, 31546 }, { 16, 31770 }, { 16, 31994 }, { 16, 32218 }, { 16, 32442 }, { 16, 32666 } }, /* 603 */
    { { 16, 31562 }, { 16, 31786 }, { 16, 32010 }, { 16, 32234 }, { 16, 32458 }, { 16, 32682 } }, /* 604 */
    { { 16, 31578 }, { 16, 31802 }, { 16, 32026 }, { 16, 32250 }, { 16, 32474 }, { 16, 32698 } }, /* 605 */
    { { 32, 31594 }, { 32, 31818 }, { 32, 32042 }, { 32, 32266 }, { 32, 32490 }, { 32, 32714 } }, /* 606 */
    { { 32, 31626 }, { 32, 31850 }, { 32, 32074 }, { 32, 32298 }, { 32, 32522 }, { 32, 32746 } }, /* 607 */
    { { 32, 31658 }, { 32, 31882 }, { 32, 32106 }, { 32, 32330 }, { 32, 32554 }, { 32, 32778 } }, /* 608 */
    { { 16, 32810 }, { 16, 33034 }, { 16, 33258 }, { 16, 33482 }, { 16, 33706 }, { 16, 33930 }, { 16, 34154 }, { 16, 34378 }, { 16, 34602 }, { 16, 34826 }, { 16, 35050 }, { 16, 35274 } }, /* 609 */
    { { 32, 32826 }, { 32, 33050 }, { 32, 33274 }, { 32, 33498 }, { 32, 33722 }, { 32, 33946 }, { 32, 34170 }, { 32, 34394 }, { 32, 34618 }, { 32, 34842 }, { 32, 35066 }, { 32, 35290 } }, /* 610 */
    { { 16, 32858 }, { 16, 33082 }, { 16, 33306 }, { 16, 33530 }, { 16, 33754 }, { 16, 33978 }, { 16, 34202 }, { 16, 34426 }, { 16, 34650 }, { 16, 34874 }, { 16, 35098 }, { 16, 35322 } }, /* 611 */
    { { 16, 32874 }, { 16, 33098 }, { 16, 33322 }, { 16, 33546 }, { 16, 33770 }, { 16, 33994 }, { 16, 34218 }, { 16, 34442 }, { 16, 34666 }, { 16, 34890 }, { 16, 35114 }, { 16, 35338 } }, /* 612 */
    { { 16, 32890 }, { 16, 33114 }, { 16, 33338 }, { 16, 33562 }, { 16, 33786 }, { 16, 34010 }, { 16, 34234 }, { 16, 34458 }, { 16, 34682 }, { 16, 34906 }, { 16, 35130 }, { 16, 35354 } }, /* 613 */
    { { 16, 32906 }, { 16, 33130 }, { 16, 33354 }, { 16, 33578 }, { 16, 33802 }, { 16, 34026 }, { 16, 34250 }, { 16, 34474 }, { 16, 34698 }, { 16, 34922 }, { 16, 35146 }, { 16, 35370 } }, /* 614 */
    { { 16, 32922 }, { 16, 33146 }, { 16, 33370 }, { 16, 33594 }, { 16, 33818 }, { 16, 34042 }, { 16, 34266 }, { 16, 34490 }, { 16, 34714 }, { 16, 34938 }, { 16, 35162 }, { 16, 35386 } }, /* 615 */
    { { 32, 32938 }, { 32, 33162 }, { 32, 33386 }, { 32, 33610 }, { 32, 33834 }, { 32, 34058 }, { 32, 34282 }, { 32, 34506 }, { 32, 34730 }, { 32, 34954 }, { 32, 35178 }, { 32, 35402 } }, /* 616 */
    { { 32, 32970 }, { 32, 33194 }, { 32, 33418 }, { 32, 33642 }, { 32, 33866 }, { 32, 34090 }, { 32, 34314 }, { 32, 34538 }, { 32, 34762 }, { 32, 34986 }, { 32, 35210 }, { 32, 35434 } }, /* 617 */
    { { 32, 33002 }, { 32, 33226 }, { 32, 33450 }, { 32, 33674 }, { 32, 33898 }, { 32, 34122 }, { 32, 34346 }, { 32, 34570 }, { 32, 34794 }, { 32, 35018 }, { 32, 35242 }, { 32, 35466 } }, /* 618 */
    { { 32, 35498 } }, /* 619 */
    { { 64, 35530 } }, /* 620 */
    { { 32, 35594 } }, /* 621 */
    { { 32, 35626 } }, /* 622 */
    { { 32, 35658 } }, /* 623 */
    { { 64, 35690 } }, /* 624 */
    { { 32, 35754 }, { 32, 36010 } }, /* 625 */
    { { 64, 35786 }, { 64, 36042 } }, /* 626 */
    { { 32, 35850 }, { 32, 36106 } }, /* 627 */
    { { 32, 35882 }, { 32, 36138 } }, /* 628 */
    { { 32, 35914 }, { 32, 36170 } }, /* 629 */
    { { 64, 35946 }, { 64, 36202 } }, /* 630 */
    { { 16, 36266 } }, /* 631 */
    { { 32, 36282 } }, /* 632 */
    { { 16, 36314 } }, /* 633 */
    { { 16, 36330 } }, /* 634 */
    { { 16, 36346 } }, /* 635 */
    { { 32, 36362 } }, /* 636 */
    { { 16, 36394 }, { 16, 36586 }, { 16, 36778 } }, /* 637 */
    { { 32, 36410 }, { 32, 36602 }, { 32, 36794 } }, /* 638 */
    { { 16, 36442 }, { 16, 36634 }, { 16, 36826 } }, /* 639 */
    { { 16, 36458 }, { 16, 36650 }, { 16, 36842 } }, /* 640 */
    { { 16, 36474 }, { 16, 36666 }, { 16, 36858 } }, /* 641 */
    { { 16, 36490 }, { 16, 36682 }, { 16, 36874 } }, /* 642 */
    { { 16, 36506 }, { 16, 36698 }, { 16, 36890 } }, /* 643 */
    { { 32, 36522 }, { 32, 36714 }, { 32, 36906 } }, /* 644 */
    { { 32, 36554 }, { 32, 36746 }, { 32, 36938 } }, /* 645 */
    { { 16, 36970 }, { 16, 37098 } }, /* 646 */
    { { 32, 36986 }, { 32, 37114 } }, /* 647 */
    { { 16, 37018 }, { 16, 37146 } }, /* 648 */
    { { 16, 37034 }, { 16, 37162 } }, /* 649 */
    { { 16, 37050 }, { 16, 37178 } }, /* 650 */
    { { 32, 37066 }, { 32, 37194 } }, /* 651 */
    { { 16, 37226 }, { 16, 37418 }, { 16, 37610 }, { 16, 37802 }, { 16, 37994 }, { 16, 38186 } }, /* 652 */
    { { 32, 37242 }, { 32, 37434 }, { 32, 37626 }, { 32, 37818 }, { 32, 38010 }, { 32, 38202 } }, /* 653 */
    { { 16, 37274 }, { 16, 37466 }, { 16, 37658 }, { 16, 37850 }, { 16, 38042 }, { 16, 38234 } }, /* 654 */
    { { 16, 37290 }, { 16, 37482 }, { 16, 37674 }, { 16, 37866 }, { 16, 38058 }, { 16, 38250 } }, /* 655 */
    { { 16, 37306 }, { 16, 37498 }, { 16, 37690 }, { 16, 37882 }, { 16, 38074 }, { 16, 38266 } }, /* 656 */
    { { 16, 37322 }, { 16, 37514 }, { 16, 37706 }, { 16, 37898 }, { 16, 38090 }, { 16, 38282 } }, /* 657 */
    { { 16, 37338 }, { 16, 37530 }, { 16, 37722 }, { 16, 37914 }, { 16, 38106 }, { 16, 38298 } }, /* 658 */
    { { 32, 37354 }, { 32, 37546 }, { 32, 37738 }, { 32, 37930 }, { 32, 38122 }, { 32, 38314 } }, /* 659 */
    { { 32, 37386 }, { 32, 37578 }, { 32, 37770 }, { 32, 37962 }, { 32, 38154 }, { 32, 38346 } }, /* 660 */
    { { 4, 38378 } }, /* 661 */
    { { 8, 38382 } }, /* 662 */
    { { 4, 38390 } }, /* 663 */
    { { 8, 38394 } }, /* 664 */
    { { 8, 38402 } }, /* 665 */
    { { 8, 38410 } }, /* 666 */
    { { 4, 38418 } }, /* 667 */
    { { 8, 38422 } }, /* 668 */
    { { 4, 38430 } }, /* 669 */
    { { 8, 38434 } }, /* 670 */
    { { 8, 38442 } }, /* 671 */
    { { 8, 38450 } }, /* 672 */
    { { 4, 38458 } }, /* 673 */
    { { 8, 38462 } }, /* 674 */
    { { 4, 38470 } }, /* 675 */
    { { 8, 38474 } }, /* 676 */
    { { 8, 38482 } }, /* 677 */
    { { 8, 38490 } }, /* 678 */
    { { 4, 38498 } }, /* 679 */
    { { 8, 38502 } }, /* 680 */
    { { 4, 38510 } }, /* 681 */
    { { 8, 38514 } }, /* 682 */
    { { 8, 38522 } }, /* 683 */
    { { 8, 38530 } }, /* 684 */
    { { 8, 38538 } }, /* 685 */
    { { 16, 38546 } }, /* 686 */
    { { 8, 38562 } }, /* 687 */
    { { 16, 38570 } }, /* 688 */
    { { 8, 38586 } }, /* 689 */
    { { 16, 38594 } }, /* 690 */
    { { 8, 38610 } }, /* 691 */
    { { 16, 38618 } }, /* 692 */
    { { 4, 38634 } }, /* 693 */
    { { 8, 38638 } }, /* 694 */
    { { 4, 38646 } }, /* 695 */
    { { 8, 38650 } }, /* 696 */
    { { 8, 38658 } }, /* 697 */
    { { 8, 38666 } }, /* 698 */
    { { 8, 38674 } }, /* 699 */
    { { 16, 38682 } }, /* 700 */
    { { 8, 38698 } }, /* 701 */
    { { 16, 38706 } }, /* 702 */
    { { 8, 38722 } }, /* 703 */
    { { 16, 38730 } }, /* 704 */
    { { 8, 38746 } }, /* 705 */
    { { 8, 38754 } }, /* 706 */
    { { 8, 38762 } }, /* 707 */
    { { 16, 38770 } }, /* 708 */
    { { 16, 38786 } }, /* 709 */
    { { 16, 38802 } }, /* 710 */
    { { 8, 38818 } }, /* 711 */
    { { 16, 38826 } }, /* 712 */
    { { 8, 38842 } }, /* 713 */
    { { 8, 38850 } }, /* 714 */
    { { 8, 38858 } }, /* 715 */
    { { 16, 38866 } }, /* 716 */
    { { 16, 38882 } }, /* 717 */
    { { 16, 38898 } }, /* 718 */
    { { 8, 38914 }, { 8, 39010 } }, /* 719 */
    { { 16, 38922 }, { 16, 39018 } }, /* 720 */
    { { 8, 38938 }, { 8, 39034 } }, /* 721 */
    { { 8, 38946 }, { 8, 39042 } }, /* 722 */
    { { 8, 38954 }, { 8, 39050 } }, /* 723 */
    { { 16, 38962 }, { 16, 39058 } }, /* 724 */
    { { 16, 38978 }, { 16, 39074 } }, /* 725 */
    { { 16, 38994 }, { 16, 39090 } }, /* 726 */
    { { 8, 39106 }, { 8, 39202 } }, /* 727 */
    { { 16, 39114 }, { 16, 39210 } }, /* 728 */
    { { 8, 39130 }, { 8, 39226 } }, /* 729 */
    { { 8, 39138 }, { 8, 39234 } }, /* 730 */
    { { 8, 39146 }, { 8, 39242 } }, /* 731 */
    { { 16, 39154 }, { 16, 39250 } }, /* 732 */
    { { 16, 39170 }, { 16, 39266 } }, /* 733 */
    { { 16, 39186 }, { 16, 39282 } }, /* 734 */
    { { 16, 39298 } }, /* 735 */
    { { 32, 39314 } }, /* 736 */
    { { 16, 39346 } }, /* 737 */
    { { 16, 39362 } }, /* 738 */
    { { 16, 39378 } }, /* 739 */
    { { 32, 39394 } }, /* 740 */
    { { 16, 39426 }, { 16, 39554 } }, /* 741 */
    { { 32, 39442 }, { 32, 39570 } }, /* 742 */
    { { 16, 39474 }, { 16, 39602 } }, /* 743 */
    { { 16, 39490 }, { 16, 39618 } }, /* 744 */
    { { 16, 39506 }, { 16, 39634 } }, /* 745 */
    { { 32, 39522 }, { 32, 39650 } }, /* 746 */
    { { 8, 39682 } }, /* 747 */
    { { 16, 39690 } }, /* 748 */
    { { 8, 39706 } }, /* 749 */
    { { 8, 39714 } }, /* 750 */
    { { 8, 39722 } }, /* 751 */
    { { 16, 39730 } }, /* 752 */
    { { 16, 39746 } }, /* 753 */
    { { 16, 39762 } }, /* 754 */
    { { 8, 39778 } }, /* 755 */
    { { 16, 39786 } }, /* 756 */
    { { 8, 39802 } }, /* 757 */
    { { 8, 39810 } }, /* 758 */
    { { 8, 39818 } }, /* 759 */
    { { 16, 39826 } }, /* 760 */
    { { 16, 39842 } }, /* 761 */
    { { 16, 39858 } }, /* 762 */
    { { 8, 39874 } }, /* 763 */
    { { 16, 39882 } }, /* 764 */
    { { 8, 39898 } }, /* 765 */
    { { 8, 39906 } }, /* 766 */
    { { 8, 39914 } }, /* 767 */
    { { 16, 39922 } }, /* 768 */
    { { 16, 39938 } }, /* 769 */
    { { 16, 39954 } }, /* 770 */
    { { 8, 39970 } }, /* 771 */
    { { 16, 39978 } }, /* 772 */
    { { 8, 39994 } }, /* 773 */
    { { 8, 40002 } }, /* 774 */
    { { 8, 40010 } }, /* 775 */
    { { 16, 40018 } }, /* 776 */
    { { 16, 40034 } }, /* 777 */
    { { 16, 40050 } }, /* 778 */
    { { 8, 40066 } }, /* 779 */
    { { 16, 40074 } }, /* 780 */
    { { 8, 40090 } }, /* 781 */
    { { 8, 40098 } }, /* 782 */
    { { 8, 40106 } }, /* 783 */
    { { 16, 40114 } }, /* 784 */
    { { 16, 40130 } }, /* 785 */
    { { 16, 40146 } }, /* 786 */
    { { 8, 40162 } }, /* 787 */
    { { 16, 40170 } }, /* 788 */
    { { 8, 40186 } }, /* 789 */
    { { 8, 40194 } }, /* 790 */
    { { 8, 40202 } }, /* 791 */
    { { 16, 40210 } }, /* 792 */
    { { 16, 40226 } }, /* 793 */
    { { 16, 40242 } }, /* 794 */
    { { 8, 40258 } }, /* 795 */
    { { 16, 40266 } }, /* 796 */
    { { 8, 40282 } }, /* 797 */
    { { 8, 40290 } }, /* 798 */
    { { 8, 40298 } }, /* 799 */
    { { 16, 40306 } }, /* 800 */
    { { 16, 40322 } }, /* 801 */
    { { 16, 40338 } }, /* 802 */
    { { 8, 40354 } }, /* 803 */
    { { 16, 40362 } }, /* 804 */
    { { 8, 40378 } }, /* 805 */
    { { 8, 40386 } }, /* 806 */
    { { 8, 40394 } }, /* 807 */
    { { 16, 40402 } }, /* 808 */
    { { 16, 40418 } }, /* 809 */
    { { 16, 40434 } }, /* 810 */
    { { 16, 40450 } }, /* 811 */
    { { 32, 40466 } }, /* 812 */
    { { 16, 40498 } }, /* 813 */
    { { 16, 40514 } }, /* 814 */
    { { 16, 40530 } }, /* 815 */
    { { 32, 40546 } }, /* 816 */
    { { 16, 40578 } }, /* 817 */
    { { 32, 40594 } }, /* 818 */
    { { 16, 40626 } }, /* 819 */
    { { 16, 40642 } }, /* 820 */
    { { 16, 40658 } }, /* 821 */
    { { 32, 40674 } }, /* 822 */
    { { 8, 40706 } }, /* 823 */
    { { 16, 40714 } }, /* 824 */
    { { 8, 40730 } }, /* 825 */
    { { 8, 40738 } }, /* 826 */
    { { 8, 40746 } }, /* 827 */
    { { 16, 40754 } }, /* 828 */
    { { 16, 40770 } }, /* 829 */
    { { 16, 40786 } }, /* 830 */
    { { 8, 40802 } }, /* 831 */
    { { 16, 40810 } }, /* 832 */
    { { 8, 40826 } }, /* 833 */
    { { 8, 40834 } }, /* 834 */
    { { 8, 40842 } }, /* 835 */
    { { 16, 40850 } }, /* 836 */
    { { 16, 40866 } }, /* 837 */
    { { 16, 40882 } }, /* 838 */
    { { 8, 40898 } }, /* 839 */
    { { 16, 40906 } }, /* 840 */
    { { 8, 40922 } }, /* 841 */
    { { 8, 40930 } }, /* 842 */
    { { 8, 40938 } }, /* 843 */
    { { 16, 40946 } }, /* 844 */
    { { 16, 40962 } }, /* 845 */
    { { 16, 40978 } }, /* 846 */
    { { 8, 40994 } }, /* 847 */
    { { 16, 41002 } }, /* 848 */
    { { 8, 41018 } }, /* 849 */
    { { 8, 41026 } }, /* 850 */
    { { 8, 41034 } }, /* 851 */
    { { 16, 41042 } }, /* 852 */
    { { 16, 41058 } }, /* 853 */
    { { 16, 41074 } }, /* 854 */
    { { 8, 41090 } }, /* 855 */
    { { 16, 41098 } }, /* 856 */
    { { 8, 41114 } }, /* 857 */
    { { 8, 41122 } }, /* 858 */
    { { 8, 41130 } }, /* 859 */
    { { 16, 41138 } }, /* 860 */
    { { 16, 41154 } }, /* 861 */
    { { 16, 41170 } }, /* 862 */
    { { 8, 41186 } }, /* 863 */
    { { 16, 41194 } }, /* 864 */
    { { 8, 41210 } }, /* 865 */
    { { 8, 41218 } }, /* 866 */
    { { 8, 41226 } }, /* 867 */
    { { 16, 41234 } }, /* 868 */
    { { 16, 41250 } }, /* 869 */
    { { 16, 41266 } }, /* 870 */
    { { 8, 41282 } }, /* 871 */
    { { 16, 41290 } }, /* 872 */
    { { 8, 41306 } }, /* 873 */
    { { 8, 41314 } }, /* 874 */
    { { 8, 41322 } }, /* 875 */
    { { 16, 41330 } }, /* 876 */
    { { 16, 41346 } }, /* 877 */
    { { 16, 41362 } }, /* 878 */
    { { 8, 41378 } }, /* 879 */
    { { 16, 41386 } }, /* 880 */
    { { 8, 41402 } }, /* 881 */
    { { 8, 41410 } }, /* 882 */
    { { 8, 41418 } }, /* 883 */
    { { 16, 41426 } }, /* 884 */
    { { 16, 41442 } }, /* 885 */
    { { 16, 41458 } }, /* 886 */
    { { 16, 41474 } }, /* 887 */
    { { 32, 41490 } }, /* 888 */
    { { 16, 41522 } }, /* 889 */
    { { 16, 41538 } }, /* 890 */
    { { 16, 41554 } }, /* 891 */
    { { 32, 41570 } }, /* 892 */
    { { 16, 41602 } }, /* 893 */
    { { 32, 41618 } }, /* 894 */
    { { 16, 41650 } }, /* 895 */
    { { 16, 41666 } }, /* 896 */
    { { 16, 41682 } }, /* 897 */
    { { 32, 41698 } }, /* 898 */
    { { 16, 41730 } }, /* 899 */
    { { 32, 41746 } }, /* 900 */
    { { 16, 41778 } }, /* 901 */
    { { 16, 41794 } }, /* 902 */
    { { 16, 41810 } }, /* 903 */
    { { 32, 41826 } }, /* 904 */
    { { 16, 41858 } }, /* 905 */
    { { 32, 41874 } }, /* 906 */
    { { 16, 41906 } }, /* 907 */
    { { 16, 41922 } }, /* 908 */
    { { 16, 41938 } }, /* 909 */
    { { 32, 41954 } }, /* 910 */
    { { 8, 41986 } }, /* 911 */
    { { 16, 41994 } }, /* 912 */
    { { 8, 42010 } }, /* 913 */
    { { 8, 42018 } }, /* 914 */
    { { 8, 42026 } }, /* 915 */
    { { 16, 42034 } }, /* 916 */
    { { 16, 42050 } }, /* 917 */
    { { 16, 42066 } }, /* 918 */
    { { 8, 42082 } }, /* 919 */
    { { 16, 42090 } }, /* 920 */
    { { 8, 42106 } }, /* 921 */
    { { 8, 42114 } }, /* 922 */
    { { 8, 42122 } }, /* 923 */
    { { 16, 42130 } }, /* 924 */
    { { 16, 42146 } }, /* 925 */
    { { 16, 42162 } }, /* 926 */
    { { 8, 42178 } }, /* 927 */
    { { 16, 42186 } }, /* 928 */
    { { 8, 42202 } }, /* 929 */
    { { 8, 42210 } }, /* 930 */
    { { 8, 42218 } }, /* 931 */
    { { 16, 42226 } }, /* 932 */
    { { 16, 42242 } }, /* 933 */
    { { 16, 42258 } }, /* 934 */
    { { 8, 42274 } }, /* 935 */
    { { 16, 42282 } }, /* 936 */
    { { 8, 42298 } }, /* 937 */
    { { 8, 42306 } }, /* 938 */
    { { 8, 42314 } }, /* 939 */
    { { 16, 42322 } }, /* 940 */
    { { 16, 42338 } }, /* 941 */
    { { 16, 42354 } }, /* 942 */
    { { 8, 42370 } }, /* 943 */
    { { 16, 42378 } }, /* 944 */
    { { 8, 42394 } }, /* 945 */
    { { 8, 42402 } }, /* 946 */
    { { 8, 42410 } }, /* 947 */
    { { 16, 42418 } }, /* 948 */
    { { 16, 42434 } }, /* 949 */
    { { 16, 42450 } }, /* 950 */
    { { 8, 42466 } }, /* 951 */
    { { 16, 42474 } }, /* 952 */
    { { 8, 42490 } }, /* 953 */
    { { 8, 42498 } }, /* 954 */
    { { 8, 42506 } }, /* 955 */
    { { 16, 42514 } }, /* 956 */
    { { 16, 42530 } }, /* 957 */
    { { 16, 42546 } }, /* 958 */
    { { 8, 42562 } }, /* 959 */
    { { 16, 42570 } }, /* 960 */
    { { 8, 42586 } }, /* 961 */
    { { 8, 42594 } }, /* 962 */
    { { 8, 42602 } }, /* 963 */
    { { 16, 42610 } }, /* 964 */
    { { 16, 42626 } }, /* 965 */
    { { 16, 42642 } }, /* 966 */
    { { 8, 42658 } }, /* 967 */
    { { 16, 42666 } }, /* 968 */
    { { 8, 42682 } }, /* 969 */
    { { 8, 42690 } }, /* 970 */
    { { 8, 42698 } }, /* 971 */
    { { 16, 42706 } }, /* 972 */
    { { 16, 42722 } }, /* 973 */
    { { 16, 42738 } }, /* 974 */
    { { 16, 42754 } }, /* 975 */
    { { 32, 42770 } }, /* 976 */
    { { 16, 42802 } }, /* 977 */
    { { 16, 42818 } }, /* 978 */
    { { 16, 42834 } }, /* 979 */
    { { 32, 42850 } }, /* 980 */
    { { 16, 42882 } }, /* 981 */
    { { 32, 42898 } }, /* 982 */
    { { 16, 42930 } }, /* 983 */
    { { 16, 42946 } }, /* 984 */
    { { 16, 42962 } }, /* 985 */
    { { 32, 42978 } }, /* 986 */
    { { 16, 43010 } }, /* 987 */
    { { 32, 43026 } }, /* 988 */
    { { 16, 43058 } }, /* 989 */
    { { 16, 43074 } }, /* 990 */
    { { 16, 43090 } }, /* 991 */
    { { 32, 43106 } }, /* 992 */
    { { 16, 43138 } }, /* 993 */
    { { 32, 43154 } }, /* 994 */
    { { 16, 43186 } }, /* 995 */
    { { 16, 43202 } }, /* 996 */
    { { 16, 43218 } }, /* 997 */
    { { 32, 43234 } }, /* 998 */
    { { 16, 43266 } }, /* 999 */
    { { 32, 43282 } }, /* 1000 */
    { { 16, 43314 } }, /* 1001 */
    { { 16, 43330 } }, /* 1002 */
    { { 16, 43346 } }, /* 1003 */
    { { 16, 43362 } }, /* 1004 */
    { { 16, 43378 } }, /* 1005 */
    { { 16, 43394 } }, /* 1006 */
    { { 16, 43410 } }, /* 1007 */
    { { 32, 43426 } }, /* 1008 */
    { { 32, 43458 } }, /* 1009 */
    { { 32, 43490 } }, /* 1010 */
    { { 16, 43522 } }, /* 1011 */
    { { 32, 43538 } }, /* 1012 */
    { { 16, 43570 } }, /* 1013 */
    { { 16, 43586 } }, /* 1014 */
    { { 16, 43602 } }, /* 1015 */
    { { 16, 43618 } }, /* 1016 */
    { { 16, 43634 } }, /* 1017 */
    { { 16, 43650 } }, /* 1018 */
    { { 16, 43666 } }, /* 1019 */
    { { 32, 43682 } }, /* 1020 */
    { { 32, 43714 } }, /* 1021 */
    { { 32, 43746 } }, /* 1022 */
    { { 16, 43778 }, { 16, 44034 } }, /* 1023 */
    { { 32, 43794 }, { 32, 44050 } }, /* 1024 */
    { { 16, 43826 }, { 16, 44082 } }, /* 1025 */
    { { 16, 43842 }, { 16, 44098 } }, /* 1026 */
    { { 16, 43858 }, { 16, 44114 } }, /* 1027 */
    { { 16, 43874 }, { 16, 44130 } }, /* 1028 */
    { { 16, 43890 }, { 16, 44146 } }, /* 1029 */
    { { 16, 43906 }, { 16, 44162 } }, /* 1030 */
    { { 16, 43922 }, { 16, 44178 } }, /* 1031 */
    { { 32, 43938 }, { 32, 44194 } }, /* 1032 */
    { { 32, 43970 }, { 32, 44226 } }, /* 1033 */
    { { 32, 44002 }, { 32, 44258 } }, /* 1034 */
    { { 16, 44290 }, { 16, 44546 } }, /* 1035 */
    { { 32, 44306 }, { 32, 44562 } }, /* 1036 */
    { { 16, 44338 }, { 16, 44594 } }, /* 1037 */
    { { 16, 44354 }, { 16, 44610 } }, /* 1038 */
    { { 16, 44370 }, { 16, 44626 } }, /* 1039 */
    { { 16, 44386 }, { 16, 44642 } }, /* 1040 */
    { { 16, 44402 }, { 16, 44658 } }, /* 1041 */
    { { 16, 44418 }, { 16, 44674 } }, /* 1042 */
    { { 16, 44434 }, { 16, 44690 } }, /* 1043 */
    { { 32, 44450 }, { 32, 44706 } }, /* 1044 */
    { { 32, 44482 }, { 32, 44738 } }, /* 1045 */
    { { 32, 44514 }, { 32, 44770 } }, /* 1046 */
    { { 16, 44802 } }, /* 1047 */
    { { 32, 44818 } }, /* 1048 */
    { { 16, 44850 } }, /* 1049 */
    { { 16, 44866 } }, /* 1050 */
    { { 16, 44882 } }, /* 1051 */
    { { 16, 44898 } }, /* 1052 */
    { { 16, 44914 } }, /* 1053 */
    { { 16, 44930 } }, /* 1054 */
    { { 16, 44946 } }, /* 1055 */
    { { 32, 44962 } }, /* 1056 */
    { { 32, 44994 } }, /* 1057 */
    { { 32, 45026 } }, /* 1058 */
    { { 16, 45058 } }, /* 1059 */
    { { 32, 45074 } }, /* 1060 */
    { { 16, 45106 } }, /* 1061 */
    { { 16, 45122 } }, /* 1062 */
    { { 16, 45138 } }, /* 1063 */
    { { 16, 45154 } }, /* 1064 */
    { { 16, 45170 } }, /* 1065 */
    { { 16, 45186 } }, /* 1066 */
    { { 16, 45202 } }, /* 1067 */
    { { 32, 45218 } }, /* 1068 */
    { { 32, 45250 } }, /* 1069 */
    { { 32, 45282 } }, /* 1070 */
    { { 16, 45314 }, { 16, 45570 } }, /* 1071 */
    { { 32, 45330 }, { 32, 45586 } }, /* 1072 */
    { { 16, 45362 }, { 16, 45618 } }, /* 1073 */
    { { 16, 45378 }, { 16, 45634 } }, /* 1074 */
    { { 16, 45394 }, { 16, 45650 } }, /* 1075 */
    { { 16, 45410 }, { 16, 45666 } }, /* 1076 */
    { { 16, 45426 }, { 16, 45682 } }, /* 1077 */
    { { 16, 45442 }, { 16, 45698 } }, /* 1078 */
    { { 16, 45458 }, { 16, 45714 } }, /* 1079 */
    { { 32, 45474 }, { 32, 45730 } }, /* 1080 */
    { { 32, 45506 }, { 32, 45762 } }, /* 1081 */
    { { 32, 45538 }, { 32, 45794 } }, /* 1082 */
    { { 16, 45826 }, { 16, 46082 } }, /* 1083 */
    { { 32, 45842 }, { 32, 46098 } }, /* 1084 */
    { { 16, 45874 }, { 16, 46130 } }, /* 1085 */
    { { 16, 45890 }, { 16, 46146 } }, /* 1086 */
    { { 16, 45906 }, { 16, 46162 } }, /* 1087 */
    { { 16, 45922 }, { 16, 46178 } }, /* 1088 */
    { { 16, 45938 }, { 16, 46194 } }, /* 1089 */
    { { 16, 45954 }, { 16, 46210 } }, /* 1090 */
    { { 16, 45970 }, { 16, 46226 } }, /* 1091 */
    { { 32, 45986 }, { 32, 46242 } }, /* 1092 */
    { { 32, 46018 }, { 32, 46274 } }, /* 1093 */
    { { 32, 46050 }, { 32, 46306 } }, /* 1094 */
    { { 16, 46338 } }, /* 1095 */
    { { 32, 46354 } }, /* 1096 */
    { { 16, 46386 } }, /* 1097 */
    { { 16, 46402 } }, /* 1098 */
    { { 16, 46418 } }, /* 1099 */
    { { 16, 46434 } }, /* 1100 */
    { { 16, 46450 } }, /* 1101 */
    { { 16, 46466 } }, /* 1102 */
    { { 16, 46482 } }, /* 1103 */
    { { 32, 46498 } }, /* 1104 */
    { { 32, 46530 } }, /* 1105 */
    { { 32, 46562 } }, /* 1106 */
    { { 16, 46594 } }, /* 1107 */
    { { 32, 46610 } }, /* 1108 */
    { { 16, 46642 } }, /* 1109 */
    { { 16, 46658 } }, /* 1110 */
    { { 16, 46674 } }, /* 1111 */
    { { 16, 46690 } }, /* 1112 */
    { { 16, 46706 } }, /* 1113 */
    { { 16, 46722 } }, /* 1114 */
    { { 16, 46738 } }, /* 1115 */
    { { 32, 46754 } }, /* 1116 */
    { { 32, 46786 } }, /* 1117 */
    { { 32, 46818 } }, /* 1118 */
    { { 16, 46850 }, { 16, 47106 } }, /* 1119 */
    { { 32, 46866 }, { 32, 47122 } }, /* 1120 */
    { { 16, 46898 }, { 16, 47154 } }, /* 1121 */
    { { 16, 46914 }, { 16, 47170 } }, /* 1122 */
    { { 16, 46930 }, { 16, 47186 } }, /* 1123 */
    { { 16, 46946 }, { 16, 47202 } }, /* 1124 */
    { { 16, 46962 }, { 16, 47218 } }, /* 1125 */
    { { 16, 46978 }, { 16, 47234 } }, /* 1126 */
    { { 16, 46994 }, { 16, 47250 } }, /* 1127 */
    { { 32, 47010 }, { 32, 47266 } }, /* 1128 */
    { { 32, 47042 }, { 32, 47298 } }, /* 1129 */
    { { 32, 47074 }, { 32, 47330 } }, /* 1130 */
    { { 16, 47362 }, { 16, 47618 } }, /* 1131 */
    { { 32, 47378 }, { 32, 47634 } }, /* 1132 */
    { { 16, 47410 }, { 16, 47666 } }, /* 1133 */
    { { 16, 47426 }, { 16, 47682 } }, /* 1134 */
    { { 16, 47442 }, { 16, 47698 } }, /* 1135 */
    { { 16, 47458 }, { 16, 47714 } }, /* 1136 */
    { { 16, 47474 }, { 16, 47730 } }, /* 1137 */
    { { 16, 47490 }, { 16, 47746 } }, /* 1138 */
    { { 16, 47506 }, { 16, 47762 } }, /* 1139 */
    { { 32, 47522 }, { 32, 47778 } }, /* 1140 */
    { { 32, 47554 }, { 32, 47810 } }, /* 1141 */
    { { 32, 47586 }, { 32, 47842 } }, /* 1142 */
    { { 16, 47874 } }, /* 1143 */
    { { 32, 47890 } }, /* 1144 */
    { { 16, 47922 } }, /* 1145 */
    { { 16, 47938 } }, /* 1146 */
    { { 16, 47954 } }, /* 1147 */
    { { 16, 47970 } }, /* 1148 */
    { { 16, 47986 } }, /* 1149 */
    { { 16, 48002 } }, /* 1150 */
    { { 16, 48018 } }, /* 1151 */
    { { 32, 48034 } }, /* 1152 */
    { { 32, 48066 } }, /* 1153 */
    { { 32, 48098 } }, /* 1154 */
    { { 16, 48130 } }, /* 1155 */
    { { 32, 48146 } }, /* 1156 */
    { { 16, 48178 } }, /* 1157 */
    { { 16, 48194 } }, /* 1158 */
    { { 16, 48210 } }, /* 1159 */
    { { 16, 48226 } }, /* 1160 */
    { { 16, 48242 } }, /* 1161 */
    { { 16, 48258 } }, /* 1162 */
    { { 16, 48274 } }, /* 1163 */
    { { 32, 48290 } }, /* 1164 */
    { { 32, 48322 } }, /* 1165 */
    { { 32, 48354 } }, /* 1166 */
    { { 16, 48386 }, { 16, 48642 } }, /* 1167 */
    { { 32, 48402 }, { 32, 48658 } }, /* 1168 */
    { { 16, 48434 }, { 16, 48690 } }, /* 1169 */
    { { 16, 48450 }, { 16, 48706 } }, /* 1170 */
    { { 16, 48466 }, { 16, 48722 } }, /* 1171 */
    { { 16, 48482 }, { 16, 48738 } }, /* 1172 */
    { { 16, 48498 }, { 16, 48754 } }, /* 1173 */
    { { 16, 48514 }, { 16, 48770 } }, /* 1174 */
    { { 16, 48530 }, { 16, 48786 } }, /* 1175 */
    { { 32, 48546 }, { 32, 48802 } }, /* 1176 */
    { { 32, 48578 }, { 32, 48834 } }, /* 1177 */
    { { 32, 48610 }, { 32, 48866 } }, /* 1178 */
    { { 16, 48898 }, { 16, 49154 } }, /* 1179 */
    { { 32, 48914 }, { 32, 49170 } }, /* 1180 */
    { { 16, 48946 }, { 16, 49202 } }, /* 1181 */
    { { 16, 48962 }, { 16, 49218 } }, /* 1182 */
    { { 16, 48978 }, { 16, 49234 } }, /* 1183 */
    { { 16, 48994 }, { 16, 49250 } }, /* 1184 */
    { { 16, 49010 }, { 16, 49266 } }, /* 1185 */
    { { 16, 49026 }, { 16, 49282 } }, /* 1186 */
    { { 16, 49042 }, { 16, 49298 } }, /* 1187 */
    { { 32, 49058 }, { 32, 49314 } }, /* 1188 */
    { { 32, 49090 }, { 32, 49346 } }, /* 1189 */
    { { 32, 49122 }, { 32, 49378 } }, /* 1190 */
    { { 32, 49410 } }, /* 1191 */
    { { 64, 49442 } }, /* 1192 */
    { { 32, 49506 } }, /* 1193 */
    { { 32, 49538 } }, /* 1194 */
    { { 32, 49570 } }, /* 1195 */
    { { 32, 49602 } }, /* 1196 */
    { { 32, 49634 } }, /* 1197 */
    { { 32, 49666 } }, /* 1198 */
    { { 32, 49698 } }, /* 1199 */
    { { 64, 49730 } }, /* 1200 */
    { { 32, 49794 } }, /* 1201 */
    { { 64, 49826 } }, /* 1202 */
    { { 32, 49890 } }, /* 1203 */
    { { 32, 49922 } }, /* 1204 */
    { { 32, 49954 } }, /* 1205 */
    { { 32, 49986 } }, /* 1206 */
    { { 32, 50018 } }, /* 1207 */
    { { 32, 50050 } }, /* 1208 */
    { { 32, 50082 } }, /* 1209 */
    { { 64, 50114 } }, /* 1210 */
    { { 32, 50178 }, { 32, 50562 } }, /* 1211 */
    { { 64, 50210 }, { 64, 50594 } }, /* 1212 */
    { { 32, 50274 }, { 32, 50658 } }, /* 1213 */
    { { 32, 50306 }, { 32, 50690 } }, /* 1214 */
    { { 32, 50338 }, { 32, 50722 } }, /* 1215 */
    { { 32, 50370 }, { 32, 50754 } }, /* 1216 */
    { { 32, 50402 }, { 32, 50786 } }, /* 1217 */
    { { 32, 50434 }, { 32, 50818 } }, /* 1218 */
    { { 32, 50466 }, { 32, 50850 } }, /* 1219 */
    { { 64, 50498 }, { 64, 50882 } }, /* 1220 */
    { { 32, 50946 }, { 32, 51330 } }, /* 1221 */
    { { 64, 50978 }, { 64, 51362 } }, /* 1222 */
    { { 32, 51042 }, { 32, 51426 } }, /* 1223 */
    { { 32, 51074 }, { 32, 51458 } }, /* 1224 */
    { { 32, 51106 }, { 32, 51490 } }, /* 1225 */
    { { 32, 51138 }, { 32, 51522 } }, /* 1226 */
    { { 32, 51170 }, { 32, 51554 } }, /* 1227 */
    { { 32, 51202 }, { 32, 51586 } }, /* 1228 */
    { { 32, 51234 }, { 32, 51618 } }, /* 1229 */
    { { 64, 51266 }, { 64, 51650 } }, /* 1230 */
    { { 3, 51714 } }, /* 1231 */
    { { 6, 51717 } }, /* 1232 */
    { { 6, 51723 } }, /* 1233 */
    { { 3, 51729 } }, /* 1234 */
    { { 6, 51732 } }, /* 1235 */
    { { 6, 51738 } }, /* 1236 */
    { { 3, 51744 } }, /* 1237 */
    { { 6, 51747 } }, /* 1238 */
    { { 6, 51753 } }, /* 1239 */
    { { 9, 51759 }, { 3, 51804 } }, /* 1240 */
    { { 18, 51768 }, { 6, 51807 } }, /* 1241 */
    { { 18, 51786 }, { 6, 51813 } }, /* 1242 */
    { { 6, 51819 } }, /* 1243 */
    { { 12, 51825 } }, /* 1244 */
    { { 6, 51837 } }, /* 1245 */
    { { 12, 51843 } }, /* 1246 */
    { { 18, 51855 }, { 6, 51963 } }, /* 1247 */
    { { 36, 51873 }, { 12, 51969 } }, /* 1248 */
    { { 18, 51909 }, { 6, 51981 } }, /* 1249 */
    { { 36, 51927 }, { 12, 51987 } }, /* 1250 */
    { { 6, 51999 } }, /* 1251 */
    { { 12, 52005 } }, /* 1252 */
    { { 6, 52017 } }, /* 1253 */
    { { 12, 52023 } }, /* 1254 */
    { { 6, 52035 } }, /* 1255 */
    { { 12, 52041 } }, /* 1256 */
    { { 6, 52053 } }, /* 1257 */
    { { 12, 52059 } }, /* 1258 */
    { { 6, 52071 } }, /* 1259 */
    { { 12, 52077 } }, /* 1260 */
    { { 6, 52089 } }, /* 1261 */
    { { 12, 52095 } }, /* 1262 */
    { { 6, 52107 } }, /* 1263 */
    { { 12, 52113 } }, /* 1264 */
    { { 6, 52125 } }, /* 1265 */
    { { 12, 52131 } }, /* 1266 */
    { { 6, 52143 } }, /* 1267 */
    { { 12, 52149 } }, /* 1268 */
    { { 6, 52161 } }, /* 1269 */
    { { 12, 52167 } }, /* 1270 */
    { { 6, 52179 } }, /* 1271 */
    { { 12, 52185 } }, /* 1272 */
    { { 6, 52197 } }, /* 1273 */
    { { 12, 52203 } }, /* 1274 */
    { { 18, 52215 }, { 6, 52323 } }, /* 1275 */
    { { 36, 52233 }, { 12, 52329 } }, /* 1276 */
    { { 18, 52269 }, { 6, 52341 } }, /* 1277 */
    { { 36, 52287 }, { 12, 52347 } }, /* 1278 */
    { { 6, 52359 } }, /* 1279 */
    { { 12, 52365 } }, /* 1280 */
    { { 6, 52377 } }, /* 1281 */
    { { 12, 52383 } }, /* 1282 */
    { { 6, 52395 } }, /* 1283 */
    { { 12, 52401 } }, /* 1284 */
    { { 6, 52413 } }, /* 1285 */
    { { 12, 52419 } }, /* 1286 */
    { { 6, 52431 } }, /* 1287 */
    { { 12, 52437 } }, /* 1288 */
    { { 6, 52449 } }, /* 1289 */
    { { 12, 52455 } }, /* 1290 */
    { { 6, 52467 } }, /* 1291 */
    { { 12, 52473 } }, /* 1292 */
    { { 6, 52485 } }, /* 1293 */
    { { 12, 52491 } }, /* 1294 */
    { { 18, 52503 }, { 6, 52611 } }, /* 1295 */
    { { 36, 52521 }, { 12, 52617 } }, /* 1296 */
    { { 18, 52557 }, { 6, 52629 } }, /* 1297 */
    { { 36, 52575 }, { 12, 52635 } }, /* 1298 */
    { { 18, 52647 }, { 6, 52755 } }, /* 1299 */
    { { 36, 52665 }, { 12, 52761 } }, /* 1300 */
    { { 18, 52701 }, { 6, 52773 } }, /* 1301 */
    { { 36, 52719 }, { 12, 52779 } }, /* 1302 */
    { { 12, 52791 } }, /* 1303 */
    { { 24, 52803 } }, /* 1304 */
    { { 12, 52827 } }, /* 1305 */
    { { 12, 52839 } }, /* 1306 */
    { { 12, 52851 } }, /* 1307 */
    { { 24, 52863 } }, /* 1308 */
    { { 12, 52887 } }, /* 1309 */
    { { 24, 52899 } }, /* 1310 */
    { { 12, 52923 } }, /* 1311 */
    { { 12, 52935 } }, /* 1312 */
    { { 12, 52947 } }, /* 1313 */
    { { 24, 52959 } }, /* 1314 */
    { { 12, 52983 } }, /* 1315 */
    { { 24, 52995 } }, /* 1316 */
    { { 12, 53019 } }, /* 1317 */
    { { 12, 53031 } }, /* 1318 */
    { { 12, 53043 } }, /* 1319 */
    { { 24, 53055 } }, /* 1320 */
    { { 12, 53079 } }, /* 1321 */
    { { 24, 53091 } }, /* 1322 */
    { { 12, 53115 } }, /* 1323 */
    { { 12, 53127 } }, /* 1324 */
    { { 12, 53139 } }, /* 1325 */
    { { 24, 53151 } }, /* 1326 */
    { { 36, 53175 }, { 12, 53463 } }, /* 1327 */
    { { 72, 53211 }, { 24, 53475 } }, /* 1328 */
    { { 36, 53283 }, { 12, 53499 } }, /* 1329 */
    { { 36, 53319 }, { 12, 53511 } }, /* 1330 */
    { { 36, 53355 }, { 12, 53523 } }, /* 1331 */
    { { 72, 53391 }, { 24, 53535 } }, /* 1332 */
    { { 36, 53559 }, { 12, 53847 } }, /* 1333 */
    { { 72, 53595 }, { 24, 53859 } }, /* 1334 */
    { { 36, 53667 }, { 12, 53883 } }, /* 1335 */
    { { 36, 53703 }, { 12, 53895 } }, /* 1336 */
    { { 36, 53739 }, { 12, 53907 } }, /* 1337 */
    { { 72, 53775 }, { 24, 53919 } }, /* 1338 */
    { { 6, 53943 } }, /* 1339 */
    { { 12, 53949 } }, /* 1340 */
    { { 6, 53961 } }, /* 1341 */
    { { 12, 53967 } }, /* 1342 */
    { { 6, 53979 } }, /* 1343 */
    { { 12, 53985 } }, /* 1344 */
    { { 6, 53997 } }, /* 1345 */
    { { 12, 54003 } }, /* 1346 */
    { { 6, 54015 } }, /* 1347 */
    { { 12, 54021 } }, /* 1348 */
    { { 6, 54033 } }, /* 1349 */
    { { 12, 54039 } }, /* 1350 */
    { { 6, 54051 } }, /* 1351 */
    { { 12, 54057 } }, /* 1352 */
    { { 6, 54069 } }, /* 1353 */
    { { 12, 54075 } }, /* 1354 */
    { { 6, 54087 } }, /* 1355 */
    { { 12, 54093 } }, /* 1356 */
    { { 6, 54105 } }, /* 1357 */
    { { 12, 54111 } }, /* 1358 */
    { { 6, 54123 } }, /* 1359 */
    { { 12, 54129 } }, /* 1360 */
    { { 6, 54141 } }, /* 1361 */
    { { 12, 54147 } }, /* 1362 */
    { { 6, 54159 } }, /* 1363 */
    { { 12, 54165 } }, /* 1364 */
    { { 6, 54177 } }, /* 1365 */
    { { 12, 54183 } }, /* 1366 */
    { { 12, 54195 } }, /* 1367 */
    { { 24, 54207 } }, /* 1368 */
    { { 12, 54231 } }, /* 1369 */
    { { 12, 54243 } }, /* 1370 */
    { { 12, 54255 } }, /* 1371 */
    { { 24, 54267 } }, /* 1372 */
    { { 12, 54291 } }, /* 1373 */
    { { 24, 54303 } }, /* 1374 */
    { { 12, 54327 } }, /* 1375 */
    { { 12, 54339 } }, /* 1376 */
    { { 12, 54351 } }, /* 1377 */
    { { 24, 54363 } }, /* 1378 */
    { { 12, 54387 } }, /* 1379 */
    { { 24, 54399 } }, /* 1380 */
    { { 12, 54423 } }, /* 1381 */
    { { 12, 54435 } }, /* 1382 */
    { { 12, 54447 } }, /* 1383 */
    { { 24, 54459 } }, /* 1384 */
    { { 12, 54483 } }, /* 1385 */
    { { 24, 54495 } }, /* 1386 */
    { { 12, 54519 } }, /* 1387 */
    { { 12, 54531 } }, /* 1388 */
    { { 12, 54543 } }, /* 1389 */
    { { 24, 54555 } }, /* 1390 */
    { { 12, 54579 } }, /* 1391 */
    { { 24, 54591 } }, /* 1392 */
    { { 12, 54615 } }, /* 1393 */
    { { 12, 54627 } }, /* 1394 */
    { { 12, 54639 } }, /* 1395 */
    { { 24, 54651 } }, /* 1396 */
    { { 12, 54675 } }, /* 1397 */
    { { 24, 54687 } }, /* 1398 */
    { { 12, 54711 } }, /* 1399 */
    { { 12, 54723 } }, /* 1400 */
    { { 12, 54735 } }, /* 1401 */
    { { 24, 54747 } }, /* 1402 */
    { { 12, 54771 } }, /* 1403 */
    { { 24, 54783 } }, /* 1404 */
    { { 12, 54807 } }, /* 1405 */
    { { 12, 54819 } }, /* 1406 */
    { { 12, 54831 } }, /* 1407 */
    { { 24, 54843 } }, /* 1408 */
    { { 12, 54867 } }, /* 1409 */
    { { 24, 54879 } }, /* 1410 */
    { { 12, 54903 } }, /* 1411 */
    { { 12, 54915 } }, /* 1412 */
    { { 12, 54927 } }, /* 1413 */
    { { 24, 54939 } }, /* 1414 */
    { { 12, 54963 } }, /* 1415 */
    { { 24, 54975 } }, /* 1416 */
    { { 12, 54999 } }, /* 1417 */
    { { 12, 55011 } }, /* 1418 */
    { { 12, 55023 } }, /* 1419 */
    { { 24, 55035 } }, /* 1420 */
    { { 12, 55059 } }, /* 1421 */
    { { 24, 55071 } }, /* 1422 */
    { { 12, 55095 } }, /* 1423 */
    { { 12, 55107 } }, /* 1424 */
    { { 12, 55119 } }, /* 1425 */
    { { 24, 55131 } }, /* 1426 */
    { { 12, 55155 } }, /* 1427 */
    { { 24, 55167 } }, /* 1428 */
    { { 12, 55191 } }, /* 1429 */
    { { 12, 55203 } }, /* 1430 */
    { { 12, 55215 } }, /* 1431 */
    { { 24, 55227 } }, /* 1432 */
    { { 12, 55251 } }, /* 1433 */
    { { 24, 55263 } }, /* 1434 */
    { { 12, 55287 } }, /* 1435 */
    { { 12, 55299 } }, /* 1436 */
    { { 12, 55311 } }, /* 1437 */
    { { 24, 55323 } }, /* 1438 */
    { { 12, 55347 } }, /* 1439 */
    { { 24, 55359 } }, /* 1440 */
    { { 12, 55383 } }, /* 1441 */
    { { 12, 55395 } }, /* 1442 */
    { { 12, 55407 } }, /* 1443 */
    { { 24, 55419 } }, /* 1444 */
    { { 12, 55443 } }, /* 1445 */
    { { 24, 55455 } }, /* 1446 */
    { { 12, 55479 } }, /* 1447 */
    { { 12, 55491 } }, /* 1448 */
    { { 12, 55503 } }, /* 1449 */
    { { 24, 55515 } }, /* 1450 */
    { { 12, 55539 } }, /* 1451 */
    { { 24, 55551 } }, /* 1452 */
    { { 12, 55575 } }, /* 1453 */
    { { 12, 55587 } }, /* 1454 */
    { { 12, 55599 } }, /* 1455 */
    { { 24, 55611 } }, /* 1456 */
    { { 12, 55635 } }, /* 1457 */
    { { 24, 55647 } }, /* 1458 */
    { { 12, 55671 } }, /* 1459 */
    { { 12, 55683 } }, /* 1460 */
    { { 12, 55695 } }, /* 1461 */
    { { 24, 55707 } }, /* 1462 */
    { { 24, 55731 } }, /* 1463 */
    { { 48, 55755 } }, /* 1464 */
    { { 24, 55803 } }, /* 1465 */
    { { 24, 55827 } }, /* 1466 */
    { { 24, 55851 } }, /* 1467 */
    { { 24, 55875 } }, /* 1468 */
    { { 24, 55899 } }, /* 1469 */
    { { 24, 55923 } }, /* 1470 */
    { { 24, 55947 } }, /* 1471 */
    { { 48, 55971 } }, /* 1472 */
    { { 24, 56019 } }, /* 1473 */
    { { 48, 56043 } }, /* 1474 */
    { { 24, 56091 } }, /* 1475 */
    { { 24, 56115 } }, /* 1476 */
    { { 24, 56139 } }, /* 1477 */
    { { 24, 56163 } }, /* 1478 */
    { { 24, 56187 } }, /* 1479 */
    { { 24, 56211 } }, /* 1480 */
    { { 24, 56235 } }, /* 1481 */
    { { 48, 56259 } }, /* 1482 */
    { { 24, 56307 } }, /* 1483 */
    { { 48, 56331 } }, /* 1484 */
    { { 24, 56379 } }, /* 1485 */
    { { 24, 56403 } }, /* 1486 */
    { { 24, 56427 } }, /* 1487 */
    { { 24, 56451 } }, /* 1488 */
    { { 24, 56475 } }, /* 1489 */
    { { 24, 56499 } }, /* 1490 */
    { { 24, 56523 } }, /* 1491 */
    { { 48, 56547 } }, /* 1492 */
    { { 24, 56595 } }, /* 1493 */
    { { 48, 56619 } }, /* 1494 */
    { { 24, 56667 } }, /* 1495 */
    { { 24, 56691 } }, /* 1496 */
    { { 24, 56715 } }, /* 1497 */
    { { 24, 56739 } }, /* 1498 */
    { { 24, 56763 } }, /* 1499 */
    { { 24, 56787 } }, /* 1500 */
    { { 24, 56811 } }, /* 1501 */
    { { 48, 56835 } }, /* 1502 */
    { { 12, 56883 } }, /* 1503 */
    { { 24, 56895 } }, /* 1504 */
    { { 24, 56919 } }, /* 1505 */
    { { 48, 56943 } }, /* 1506 */
    { { 96, 56991 } }, /* 1507 */
    { { 96, 57087 } }, /* 1508 */
    { { 24, 57183 } }, /* 1509 */
    { { 48, 57207 } }, /* 1510 */
    { { 12, 57255 } }, /* 1511 */
    { { 24, 57267 } }, /* 1512 */
    { { 24, 57291 } }, /* 1513 */
    { { 24, 57315 } }, /* 1514 */
    { { 48, 57339 } }, /* 1515 */
    { { 24, 57387 } }, /* 1516 */
    { { 48, 57411 } }, /* 1517 */
    { { 24, 57459 } }, /* 1518 */
    { { 48, 57483 } }, /* 1519 */
    { { 24, 57531 }, { 24, 57675 } }, /* 1520 */
    { { 48, 57555 }, { 48, 57699 } }, /* 1521 */
    { { 24, 57603 }, { 24, 57747 } }, /* 1522 */
    { { 48, 57627 }, { 48, 57771 } }, /* 1523 */
    { { 96, 57819 } }, /* 1524 */
    { { 192, 57915 } }, /* 1525 */
    { { 96, 58107 } }, /* 1526 */
    { { 192, 58203 } }, /* 1527 */
    { { 96, 58395 }, { 96, 58971 } }, /* 1528 */
    { { 192, 58491 }, { 192, 59067 } }, /* 1529 */
    { { 96, 58683 }, { 96, 59259 } }, /* 1530 */
    { { 192, 58779 }, { 192, 59355 } }, /* 1531 */
    { { 48, 59547 } }, /* 1532 */
    { { 96, 59595 } }, /* 1533 */
    { { 48, 59691 } }, /* 1534 */
    { { 24, 59739 } }, /* 1535 */
    { { 48, 59763 } }, /* 1536 */
    { { 24, 59811 } }, /* 1537 */
    { { 48, 59835 } }, /* 1538 */
    { { 48, 59883 } }, /* 1539 */
    { { 96, 59931 } }, /* 1540 */
    { { 48, 60027 } }, /* 1541 */
    { { 24, 60075 } }, /* 1542 */
    { { 48, 60099 } }, /* 1543 */
    { { 24, 60147 } }, /* 1544 */
    { { 48, 60171 } }, /* 1545 */
    { { 24, 60219 } }, /* 1546 */
    { { 48, 60243 } }, /* 1547 */
    { { 24, 60291 } }, /* 1548 */
    { { 48, 60315 } }, /* 1549 */
    { { 96, 60363 } }, /* 1550 */
    { { 192, 60459 } }, /* 1551 */
    { { 96, 60651 } }, /* 1552 */
    { { 192, 60747 } }, /* 1553 */
    { { 96, 60939 } }, /* 1554 */
    { { 192, 61035 } }, /* 1555 */
    { { 96, 61227 } }, /* 1556 */
    { { 192, 61323 } }, /* 1557 */
    { { 48, 61515 } }, /* 1558 */
    { { 96, 61563 } }, /* 1559 */
    { { 48, 61659 } }, /* 1560 */
    { { 24, 61707 } }, /* 1561 */
    { { 48, 61731 } }, /* 1562 */
    { { 24, 61779 } }, /* 1563 */
    { { 48, 61803 } }, /* 1564 */
    { { 24, 61851 } }, /* 1565 */
    { { 48, 61875 } }, /* 1566 */
    { { 24, 61923 } }, /* 1567 */
    { { 48, 61947 } }, /* 1568 */
    { { 48, 61995 } }, /* 1569 */
    { { 96, 62043 } }, /* 1570 */
    { { 48, 62139 } }, /* 1571 */
    { { 24, 62187 } }, /* 1572 */
    { { 48, 62211 } }, /* 1573 */
    { { 24, 62259 } }, /* 1574 */
    { { 48, 62283 } }, /* 1575 */
    { { 96, 62331 } }, /* 1576 */
    { { 192, 62427 } }, /* 1577 */
    { { 96, 62619 } }, /* 1578 */
    { { 192, 62715 } }, /* 1579 */
    { { 48, 62907 } }, /* 1580 */
    { { 96, 62955 } }, /* 1581 */
    { { 48, 63051 } }, /* 1582 */
    { { 24, 63099 } }, /* 1583 */
    { { 48, 63123 } }, /* 1584 */
    { { 24, 63171 } }, /* 1585 */
    { { 48, 63195 } }, /* 1586 */
    { { 96, 63243 } }, /* 1587 */
    { { 192, 63339 } }, /* 1588 */
    { { 96, 63531 } }, /* 1589 */
    { { 192, 63627 } }, /* 1590 */
    { { 48, 63819 } }, /* 1591 */
    { { 96, 63867 } }, /* 1592 */
    { { 48, 63963 } }, /* 1593 */
    { { 48, 64011 } }, /* 1594 */
    { { 96, 64059 } }, /* 1595 */
    { { 48, 64155 } }, /* 1596 */
    { { 48, 64203 } }, /* 1597 */
    { { 48, 64251 } }, /* 1598 */
    { { 96, 64299 } }, /* 1599 */
    { { 48, 64395 }, { 48, 64779 } }, /* 1600 */
    { { 96, 64443 }, { 96, 64827 } }, /* 1601 */
    { { 48, 64539 }, { 48, 64923 } }, /* 1602 */
    { { 48, 64587 }, { 48, 64971 } }, /* 1603 */
    { { 48, 64635 }, { 48, 65019 } }, /* 1604 */
    { { 96, 64683 }, { 96, 65067 } }, /* 1605 */
    { { 48, 65163 } }, /* 1606 */
    { { 96, 65211 } }, /* 1607 */
    { { 48, 65307 } }, /* 1608 */
    { { 48, 65355 } }, /* 1609 */
    { { 48, 65403 } }, /* 1610 */
    { { 96, 65451 } }, /* 1611 */
    { { 48, 65547 }, { 48, 65931 } }, /* 1612 */
    { { 96, 65595 }, { 96, 65979 } }, /* 1613 */
    { { 48, 65691 }, { 48, 66075 } }, /* 1614 */
    { { 48, 65739 }, { 48, 66123 } }, /* 1615 */
    { { 48, 65787 }, { 48, 66171 } }, /* 1616 */
    { { 96, 65835 }, { 96, 66219 } }, /* 1617 */
    { { 192, 66315 } }, /* 1618 */
    { { 384, 66507 } }, /* 1619 */
    { { 192, 66891 } }, /* 1620 */
    { { 192, 67083 } }, /* 1621 */
    { { 192, 67275 } }, /* 1622 */
    { { 384, 67467 } }, /* 1623 */
    { { 192, 67851 } }, /* 1624 */
    { { 384, 68043 } }, /* 1625 */
    { { 192, 68427 } }, /* 1626 */
    { { 192, 68619 } }, /* 1627 */
    { { 192, 68811 } }, /* 1628 */
    { { 384, 69003 } }, /* 1629 */
    { { 192, 69387 }, { 192, 70923 } }, /* 1630 */
    { { 384, 69579 }, { 384, 71115 } }, /* 1631 */
    { { 192, 69963 }, { 192, 71499 } }, /* 1632 */
    { { 192, 70155 }, { 192, 71691 } }, /* 1633 */
    { { 192, 70347 }, { 192, 71883 } }, /* 1634 */
    { { 384, 70539 }, { 384, 72075 } }, /* 1635 */
    { { 192, 72459 }, { 192, 73995 } }, /* 1636 */
    { { 384, 72651 }, { 384, 74187 } }, /* 1637 */
    { { 192, 73035 }, { 192, 74571 } }, /* 1638 */
    { { 192, 73227 }, { 192, 74763 } }, /* 1639 */
    { { 192, 73419 }, { 192, 74955 } }, /* 1640 */
    { { 384, 73611 }, { 384, 75147 } }, /* 1641 */
    { { 96, 75531 } }, /* 1642 */
    { { 192, 75627 } }, /* 1643 */
    { { 96, 75819 } }, /* 1644 */
    { { 96, 75915 } }, /* 1645 */
    { { 96, 76011 } }, /* 1646 */
    { { 96, 76107 } }, /* 1647 */
    { { 192, 76203 } }, /* 1648 */
    { { 96, 76395 } }, /* 1649 */
    { { 96, 76491 } }, /* 1650 */
    { { 96, 76587 } }, /* 1651 */
};

/* clang-format off */
static const int magnetic_symmetry_operations[] = {
           0, /*dummy*/
       16484, /*     1 (   1) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*     2 (   2) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*     3 (   2) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*     4 (   3) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*     5 (   3) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*     6 (   4) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*     7 (   4) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*     8 (   5) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*     9 (   5) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3198, /*    10 (   5) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015422, /*    11 (   5) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*    12 (   6) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*    13 (   6) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*    14 (   7) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*    15 (   7) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*    16 (   7) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*    17 (   7) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*    18 (   8) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*    19 (   8) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*    20 (   9) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*    21 (   9) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*    22 (   9) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015584, /*    23 (   9) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*    24 (  10) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*    25 (  10) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*    26 (  11) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*    27 (  11) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*    28 (  11) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*    29 (  11) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*    30 (  12) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*    31 (  12) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432760, /*    32 (  12) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445884, /*    33 (  12) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*    34 (  13) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*    35 (  13) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*    36 (  13) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*    37 (  13) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*    38 (   8) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*    39 (   8) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*    40 (   9) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*    41 (   9) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*    42 (   9) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015424, /*    43 (   9) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*    44 (  10) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*    45 (  10) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*    46 (  11) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*    47 (  11) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*    48 (  11) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432600, /*    49 (  11) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*    50 (  12) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*    51 (  12) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*    52 (  12) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146806, /*    53 (  12) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*    54 (  13) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*    55 (  13) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550698, /*    56 (  13) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563982, /*    57 (  13) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*    58 (   8) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*    59 (   8) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*    60 (   9) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*    61 (   9) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*    62 (   9) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028544, /*    63 (   9) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*    64 (  10) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*    65 (  10) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*    66 (  11) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*    67 (  11) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*    68 (  11) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146642, /*    69 (  11) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*    70 (  12) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*    71 (  12) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034656, /*    72 (  12) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034820, /*    73 (  12) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*    74 (  13) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*    75 (  13) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152754, /*    76 (  13) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152918, /*    77 (  13) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*    78 (  14) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*    79 (  14) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*    80 (  15) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*    81 (  15) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1420536, /*    82 (  15) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35432760, /*    83 (  15) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*    84 (  16) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*    85 (  16) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*    86 (  17) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*    87 (  17) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52438872, /*    88 (  17) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1420536, /*    89 (  17) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*    90 (  18) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*    91 (  18) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1420536, /*    92 (  18) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445884, /*    93 (  18) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*    94 (  19) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021696, /*    95 (  19) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1420536, /*    96 (  19) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52451996, /*    97 (  19) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*    98 (  14) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*    99 (  14) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*   100 (  15) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*   101 (  15) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      121298, /*   102 (  15) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133522, /*   103 (  15) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   104 (  16) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*   105 (  16) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   106 (  17) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*   107 (  17) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35550698, /*   108 (  17) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      121298, /*   109 (  17) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*   110 (  18) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*   111 (  18) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      121298, /*   112 (  18) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*   113 (  18) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   114 (  19) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432600, /*   115 (  19) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      121298, /*   116 (  19) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35563982, /*   117 (  19) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   118 (  14) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022432, /*   119 (  14) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*   120 (  15) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*   121 (  15) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17022432, /*   122 (  15) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034656, /*   123 (  15) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*   124 (  16) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*   125 (  16) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*   126 (  17) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*   127 (  17) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152754, /*   128 (  17) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17022432, /*   129 (  17) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*   130 (  18) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*   131 (  18) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17022432, /*   132 (  18) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034820, /*   133 (  18) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*   134 (  19) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146642, /*   135 (  19) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17022432, /*   136 (  19) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51152918, /*   137 (  19) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   138 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*   139 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*   140 (  20) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18426648, /*   141 (  20) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*   142 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*   143 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34015584, /*   144 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438872, /*   145 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*   146 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439772, /*   147 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*   148 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*   149 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   150 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*   151 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52438872, /*   152 (  22) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34015584, /*   153 (  22) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*   154 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*   155 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34146806, /*   156 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556970, /*   157 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*   158 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*   159 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*   160 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570094, /*   161 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   162 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*   163 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51034820, /*   164 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*   165 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35432760, /*   166 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445884, /*   167 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18439772, /*   168 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*   169 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   170 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*   171 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3360, /*   172 (  20) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1538634, /*   173 (  20) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*   174 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538634, /*   175 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34015584, /*   176 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550858, /*   177 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35563982, /*   178 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551758, /*   179 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3360, /*   180 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*   181 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   182 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*   183 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550858, /*   184 (  22) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34015584, /*   185 (  22) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*   186 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538634, /*   187 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51152918, /*   188 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52438872, /*   189 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51139794, /*   190 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1551758, /*   191 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3360, /*   192 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*   193 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   194 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538634, /*   195 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34146806, /*   196 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133682, /*   197 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35432760, /*   198 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445884, /*   199 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1551758, /*   200 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3360, /*   201 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   202 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   203 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*   204 (  20) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18544746, /*   205 (  20) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*   206 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544746, /*   207 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34015584, /*   208 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556970, /*   209 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52570094, /*   210 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*   211 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*   212 (  21) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*   213 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   214 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   215 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556970, /*   216 (  22) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34015584, /*   217 (  22) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*   218 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544746, /*   219 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51034820, /*   220 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35550858, /*   221 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51021696, /*   222 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18557870, /*   223 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*   224 (  23) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563982, /*   225 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   226 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544746, /*   227 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51152918, /*   228 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139794, /*   229 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35432760, /*   230 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445884, /*   231 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*   232 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*   233 (  24) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   234 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*   235 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*   236 (  20) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*   237 (  20) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*   238 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*   239 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34015424, /*   240 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35550698, /*   241 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563982, /*   242 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551758, /*   243 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*   244 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*   245 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   246 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*   247 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550698, /*   248 (  22) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34015424, /*   249 (  22) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   250 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*   251 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51034820, /*   252 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52556810, /*   253 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*   254 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*   255 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*   256 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570094, /*   257 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   258 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*   259 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35445884, /*   260 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432600, /*   261 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34133522, /*   262 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146806, /*   263 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1551758, /*   264 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*   265 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   266 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*   267 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*   268 (  20) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127410, /*   269 (  20) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*   270 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127410, /*   271 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34015424, /*   272 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51139634, /*   273 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51152918, /*   274 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140694, /*   275 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*   276 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*   277 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   278 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*   279 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51139634, /*   280 (  22) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015424, /*   281 (  22) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   282 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127410, /*   283 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451996, /*   284 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35550698, /*   285 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438712, /*   286 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140694, /*   287 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*   288 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563982, /*   289 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   290 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127410, /*   291 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51034820, /*   292 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021536, /*   293 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34133522, /*   294 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146806, /*   295 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17140694, /*   296 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*   297 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   298 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   299 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*   300 (  20) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544586, /*   301 (  20) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*   302 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544586, /*   303 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34015424, /*   304 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52556810, /*   305 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52570094, /*   306 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*   307 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*   308 (  21) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*   309 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   310 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   311 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556810, /*   312 (  22) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015424, /*   313 (  22) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   314 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544586, /*   315 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35445884, /*   316 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139634, /*   317 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35432600, /*   318 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*   319 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*   320 (  23) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152918, /*   321 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   322 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544586, /*   323 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52451996, /*   324 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438712, /*   325 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34133522, /*   326 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146806, /*   327 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18557870, /*   328 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*   329 (  24) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   330 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*   331 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*   332 (  20) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140530, /*   333 (  20) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*   334 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*   335 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34028544, /*   336 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51152754, /*   337 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152918, /*   338 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140694, /*   339 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*   340 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*   341 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   342 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*   343 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152754, /*   344 (  22) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028544, /*   345 (  22) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*   346 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*   347 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35445884, /*   348 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52569930, /*   349 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445720, /*   350 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17140694, /*   351 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*   352 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570094, /*   353 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   354 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*   355 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34146806, /*   356 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146642, /*   357 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51034656, /*   358 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034820, /*   359 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17140694, /*   360 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*   361 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   362 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*   363 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*   364 (  20) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439608, /*   365 (  20) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*   366 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*   367 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34028544, /*   368 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451832, /*   369 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*   370 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439772, /*   371 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*   372 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*   373 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   374 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*   375 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451832, /*   376 (  22) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34028544, /*   377 (  22) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*   378 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*   379 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35563982, /*   380 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51152754, /*   381 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35563818, /*   382 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18439772, /*   383 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*   384 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152918, /*   385 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   386 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*   387 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35445884, /*   388 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445720, /*   389 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51034656, /*   390 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034820, /*   391 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439772, /*   392 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*   393 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   394 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   395 (  20) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16320, /*   396 (  20) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557706, /*   397 (  20) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*   398 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557706, /*   399 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34028544, /*   400 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52569930, /*   401 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52570094, /*   402 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*   403 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16320, /*   404 (  21) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*   405 (  21) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   406 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   407 (  22) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52569930, /*   408 (  22) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028544, /*   409 (  22) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*   410 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557706, /*   411 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34146806, /*   412 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52451832, /*   413 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146642, /*   414 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*   415 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16320, /*   416 (  23) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*   417 (  23) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   418 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557706, /*   419 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35563982, /*   420 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563818, /*   421 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034656, /*   422 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034820, /*   423 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*   424 (  24) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16320, /*   425 (  24) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   426 (  25) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*   427 (  25) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   428 (  26) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*   429 (  26) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028708, /*   430 (  26) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*   431 (  26) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   432 (  27) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*   433 (  27) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   434 (  28) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*   435 (  28) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034658, /*   436 (  28) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16322, /*   437 (  28) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   438 (  29) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445722, /*   439 (  29) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*   440 (  29) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16322, /*   441 (  29) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   442 (  30) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*   443 (  30) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52451996, /*   444 (  30) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16322, /*   445 (  30) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   446 (  25) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*   447 (  25) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   448 (  26) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*   449 (  26) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*   450 (  26) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*   451 (  26) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   452 (  27) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*   453 (  27) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*   454 (  28) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*   455 (  28) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445882, /*   456 (  28) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16482, /*   457 (  28) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   458 (  29) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146804, /*   459 (  29) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*   460 (  29) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16482, /*   461 (  29) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   462 (  30) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*   463 (  30) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35563982, /*   464 (  30) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16482, /*   465 (  30) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   466 (  25) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*   467 (  25) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   468 (  26) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*   469 (  26) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028708, /*   470 (  26) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*   471 (  26) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   472 (  27) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*   473 (  27) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*   474 (  28) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*   475 (  28) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133684, /*   476 (  28) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3362, /*   477 (  28) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   478 (  29) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021698, /*   479 (  29) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*   480 (  29) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3362, /*   481 (  29) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   482 (  30) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*   483 (  30) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51152918, /*   484 (  30) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3362, /*   485 (  30) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   486 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*   487 (  31) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*   488 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*   489 (  32) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028708, /*   490 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34146644, /*   491 (  32) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   492 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*   493 (  33) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   494 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*   495 (  34) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034820, /*   496 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51152756, /*   497 (  34) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   498 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*   499 (  35) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028546, /*   500 (  35) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34146806, /*   501 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   502 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*   503 (  36) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445884, /*   504 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35563820, /*   505 (  36) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   506 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*   507 (  37) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52569932, /*   508 (  37) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52451996, /*   509 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   510 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*   511 (  38) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445722, /*   512 (  38) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35563982, /*   513 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   514 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*   515 (  31) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*   516 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*   517 (  32) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028708, /*   518 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51152756, /*   519 (  32) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   520 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*   521 (  33) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   522 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*   523 (  34) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34146806, /*   524 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51034658, /*   525 (  34) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*   526 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*   527 (  35) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028546, /*   528 (  35) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51152918, /*   529 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   530 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*   531 (  36) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35445884, /*   532 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52569932, /*   533 (  36) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   534 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*   535 (  37) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451834, /*   536 (  37) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35563982, /*   537 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   538 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*   539 (  38) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35445722, /*   540 (  38) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52570094, /*   541 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   542 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*   543 (  31) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*   544 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*   545 (  32) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34028708, /*   546 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51034658, /*   547 (  32) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*   548 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*   549 (  33) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*   550 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*   551 (  34) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51152918, /*   552 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146644, /*   553 (  34) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   554 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*   555 (  35) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34028546, /*   556 (  35) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51034820, /*   557 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*   558 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*   559 (  36) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35445884, /*   560 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52451834, /*   561 (  36) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   562 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*   563 (  37) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35563820, /*   564 (  37) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52570094, /*   565 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   566 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*   567 (  38) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35445722, /*   568 (  38) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52451996, /*   569 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   570 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*   571 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*   572 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*   573 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34028708, /*   574 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51034818, /*   575 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*   576 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*   577 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*   578 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*   579 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35445884, /*   580 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52451994, /*   581 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*   582 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*   583 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34028706, /*   584 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51034820, /*   585 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*   586 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*   587 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146806, /*   588 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152916, /*   589 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*   590 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*   591 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52570092, /*   592 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35563982, /*   593 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   594 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*   595 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146804, /*   596 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51152918, /*   597 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   598 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439770, /*   599 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*   600 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439770, /*   601 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34028708, /*   602 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52451994, /*   603 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*   604 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*   605 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*   606 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439770, /*   607 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51034820, /*   608 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35445882, /*   609 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*   610 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439770, /*   611 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34028706, /*   612 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451996, /*   613 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   614 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439770, /*   615 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34146806, /*   616 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52570092, /*   617 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*   618 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439770, /*   619 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35563980, /*   620 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51152918, /*   621 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   622 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439770, /*   623 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34146804, /*   624 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    52570094, /*   625 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   626 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*   627 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*   628 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*   629 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34028708, /*   630 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35445882, /*   631 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*   632 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*   633 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*   634 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*   635 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52451996, /*   636 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51034818, /*   637 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*   638 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*   639 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34028706, /*   640 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35445884, /*   641 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*   642 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*   643 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146806, /*   644 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35563980, /*   645 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*   646 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*   647 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152916, /*   648 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52570094, /*   649 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   650 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*   651 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146804, /*   652 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35563982, /*   653 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   654 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*   655 (  31) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*   656 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*   657 (  32) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34028708, /*   658 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35432762, /*   659 (  32) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*   660 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*   661 (  33) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*   662 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*   663 (  34) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34146806, /*   664 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35550860, /*   665 (  34) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   666 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*   667 (  35) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015586, /*   668 (  35) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35445884, /*   669 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*   670 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*   671 (  36) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51034820, /*   672 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52438874, /*   673 (  36) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   674 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*   675 (  37) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52556972, /*   676 (  37) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51152918, /*   677 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   678 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*   679 (  38) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51021698, /*   680 (  38) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52451996, /*   681 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   682 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*   683 (  31) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*   684 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*   685 (  32) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028708, /*   686 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35550860, /*   687 (  32) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   688 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*   689 (  33) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   690 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*   691 (  34) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35445884, /*   692 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34133684, /*   693 (  34) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   694 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*   695 (  35) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34015586, /*   696 (  35) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35563982, /*   697 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   698 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*   699 (  36) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51034820, /*   700 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52556972, /*   701 (  36) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   702 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*   703 (  37) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51139796, /*   704 (  37) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451996, /*   705 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   706 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*   707 (  38) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51021698, /*   708 (  38) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52570094, /*   709 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   710 (  31) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*   711 (  31) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*   712 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*   713 (  32) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028708, /*   714 (  32) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34133684, /*   715 (  32) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   716 (  33) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*   717 (  33) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   718 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*   719 (  34) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35563982, /*   720 (  34) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35432762, /*   721 (  34) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*   722 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*   723 (  35) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34015586, /*   724 (  35) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34146806, /*   725 (  35) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*   726 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*   727 (  36) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034820, /*   728 (  36) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51139796, /*   729 (  36) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   730 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*   731 (  37) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52438874, /*   732 (  37) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52570094, /*   733 (  37) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   734 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*   735 (  38) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51021698, /*   736 (  38) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51152918, /*   737 (  38) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   738 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*   739 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439610, /*   740 (  39) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16322, /*   741 (  39) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   742 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*   743 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34028546, /*   744 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18439610, /*   745 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*   746 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439772, /*   747 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*   748 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*   749 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   750 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*   751 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028546, /*   752 (  41) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52451834, /*   753 (  41) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   754 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439610, /*   755 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34146644, /*   756 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52569932, /*   757 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34146806, /*   758 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18439772, /*   759 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52570094, /*   760 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16322, /*   761 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   762 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439610, /*   763 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51034820, /*   764 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034658, /*   765 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35445722, /*   766 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*   767 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18439772, /*   768 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16322, /*   769 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   770 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*   771 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1551596, /*   772 (  39) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16322, /*   773 (  39) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   774 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*   775 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028546, /*   776 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551596, /*   777 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563982, /*   778 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551758, /*   779 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028708, /*   780 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*   781 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   782 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*   783 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028546, /*   784 (  41) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35563820, /*   785 (  41) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*   786 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551596, /*   787 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51152756, /*   788 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451834, /*   789 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51152918, /*   790 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1551758, /*   791 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52451996, /*   792 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16322, /*   793 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   794 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551596, /*   795 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34146806, /*   796 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146644, /*   797 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35445722, /*   798 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*   799 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1551758, /*   800 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16322, /*   801 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   802 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   803 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557708, /*   804 (  39) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16322, /*   805 (  39) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   806 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*   807 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34028546, /*   808 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18557708, /*   809 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*   810 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*   811 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*   812 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*   813 (  40) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   814 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   815 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028546, /*   816 (  41) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52569932, /*   817 (  41) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*   818 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557708, /*   819 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51034658, /*   820 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563820, /*   821 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51034820, /*   822 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*   823 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35563982, /*   824 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16322, /*   825 (  42) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   826 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557708, /*   827 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51152918, /*   828 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51152756, /*   829 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35445722, /*   830 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*   831 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*   832 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16322, /*   833 (  43) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   834 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*   835 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1551756, /*   836 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16482, /*   837 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   838 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*   839 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028706, /*   840 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551756, /*   841 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35563982, /*   842 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551758, /*   843 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028708, /*   844 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*   845 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   846 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*   847 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028706, /*   848 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35563980, /*   849 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*   850 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551756, /*   851 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51034818, /*   852 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570092, /*   853 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51034820, /*   854 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*   855 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52570094, /*   856 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16482, /*   857 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   858 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551756, /*   859 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35445884, /*   860 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445882, /*   861 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34146804, /*   862 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*   863 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1551758, /*   864 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16482, /*   865 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   866 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*   867 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140692, /*   868 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16482, /*   869 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   870 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*   871 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028706, /*   872 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17140692, /*   873 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51152918, /*   874 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140694, /*   875 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028708, /*   876 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*   877 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   878 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*   879 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028706, /*   880 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51152916, /*   881 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*   882 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140692, /*   883 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52451994, /*   884 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563980, /*   885 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52451996, /*   886 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140694, /*   887 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35563982, /*   888 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16482, /*   889 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   890 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140692, /*   891 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51034820, /*   892 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034818, /*   893 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34146804, /*   894 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*   895 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17140694, /*   896 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16482, /*   897 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   898 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   899 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557868, /*   900 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16482, /*   901 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   902 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570092, /*   903 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028706, /*   904 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18557868, /*   905 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*   906 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*   907 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*   908 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*   909 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   910 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   911 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028706, /*   912 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52570092, /*   913 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*   914 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557868, /*   915 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35445882, /*   916 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51152916, /*   917 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445884, /*   918 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*   919 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51152918, /*   920 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16482, /*   921 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   922 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557868, /*   923 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52451996, /*   924 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52451994, /*   925 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146804, /*   926 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*   927 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18557870, /*   928 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16482, /*   929 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*   930 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*   931 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17127572, /*   932 (  39) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3362, /*   933 (  39) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   934 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*   935 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015586, /*   936 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127572, /*   937 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152918, /*   938 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140694, /*   939 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028708, /*   940 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*   941 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   942 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*   943 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34015586, /*   944 (  41) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51139796, /*   945 (  41) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*   946 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127572, /*   947 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35432762, /*   948 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52556972, /*   949 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35445884, /*   950 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*   951 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52570094, /*   952 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3362, /*   953 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   954 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127572, /*   955 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34146806, /*   956 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133684, /*   957 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51021698, /*   958 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*   959 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17140694, /*   960 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3362, /*   961 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   962 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*   963 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426650, /*   964 (  39) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3362, /*   965 (  39) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   966 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*   967 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34015586, /*   968 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18426650, /*   969 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*   970 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439772, /*   971 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*   972 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*   973 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   974 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*   975 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015586, /*   976 (  41) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52438874, /*   977 (  41) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*   978 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426650, /*   979 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35550860, /*   980 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51139796, /*   981 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563982, /*   982 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18439772, /*   983 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51152918, /*   984 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3362, /*   985 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   986 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426650, /*   987 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35445884, /*   988 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432762, /*   989 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51021698, /*   990 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*   991 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439772, /*   992 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3362, /*   993 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   994 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*   995 (  39) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18544748, /*   996 (  39) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3362, /*   997 (  39) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*   998 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556972, /*   999 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015586, /*  1000 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544748, /*  1001 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  1002 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*  1003 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*  1004 (  40) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*  1005 (  40) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1006 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1007 (  41) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34015586, /*  1008 (  41) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52556972, /*  1009 (  41) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1010 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544748, /*  1011 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34133684, /*  1012 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438874, /*  1013 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34146806, /*  1014 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18557870, /*  1015 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52451996, /*  1016 (  42) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3362, /*  1017 (  42) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1018 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544748, /*  1019 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35563982, /*  1020 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35550860, /*  1021 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51021698, /*  1022 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*  1023 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  1024 (  43) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3362, /*  1025 (  43) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1026 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*  1027 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557708, /*  1028 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
      134420, /*  1029 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  1030 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  1031 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52569932, /*  1032 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
      134420, /*  1033 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  1034 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439772, /*  1035 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557708, /*  1036 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*  1037 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1038 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*  1039 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34146644, /*  1040 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52569932, /*  1041 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1042 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  1043 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34028546, /*  1044 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      134420, /*  1045 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  1046 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18439772, /*  1047 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557708, /*  1048 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  1049 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1050 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  1051 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51034820, /*  1052 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      134420, /*  1053 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445884, /*  1054 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18439772, /*  1055 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557708, /*  1056 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35563820, /*  1057 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  1058 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*  1059 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439610, /*  1060 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17140532, /*  1061 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  1062 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  1063 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451834, /*  1064 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140532, /*  1065 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35563982, /*  1066 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551758, /*  1067 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439610, /*  1068 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*  1069 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1070 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*  1071 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51152756, /*  1072 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451834, /*  1073 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1074 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  1075 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028546, /*  1076 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140532, /*  1077 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152918, /*  1078 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1551758, /*  1079 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439610, /*  1080 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*  1081 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1082 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  1083 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34146806, /*  1084 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17140532, /*  1085 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35445884, /*  1086 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1551758, /*  1087 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439610, /*  1088 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52569932, /*  1089 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1090 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1091 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551596, /*  1092 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17022434, /*  1093 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  1094 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  1095 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563820, /*  1096 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17022434, /*  1097 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52570094, /*  1098 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*  1099 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551596, /*  1100 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028708, /*  1101 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1102 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1103 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51034658, /*  1104 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563820, /*  1105 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  1106 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  1107 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34028546, /*  1108 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17022434, /*  1109 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51034820, /*  1110 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  1111 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551596, /*  1112 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563982, /*  1113 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  1114 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  1115 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152918, /*  1116 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17022434, /*  1117 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35445884, /*  1118 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  1119 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551596, /*  1120 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52451834, /*  1121 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1122 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*  1123 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557708, /*  1124 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17022434, /*  1125 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  1126 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  1127 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52569932, /*  1128 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17022434, /*  1129 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35563982, /*  1130 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551758, /*  1131 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557708, /*  1132 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*  1133 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1134 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*  1135 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51034658, /*  1136 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52569932, /*  1137 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1138 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  1139 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028546, /*  1140 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17022434, /*  1141 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51034820, /*  1142 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  1143 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557708, /*  1144 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  1145 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1146 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  1147 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146806, /*  1148 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17022434, /*  1149 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35445884, /*  1150 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1551758, /*  1151 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557708, /*  1152 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52451834, /*  1153 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1154 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*  1155 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1551596, /*  1156 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140532, /*  1157 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  1158 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  1159 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563820, /*  1160 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17140532, /*  1161 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451996, /*  1162 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439772, /*  1163 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1551596, /*  1164 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028708, /*  1165 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1166 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*  1167 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51152756, /*  1168 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563820, /*  1169 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  1170 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  1171 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34028546, /*  1172 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140532, /*  1173 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152918, /*  1174 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18439772, /*  1175 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1551596, /*  1176 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563982, /*  1177 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  1178 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  1179 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51034820, /*  1180 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17140532, /*  1181 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35445884, /*  1182 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18439772, /*  1183 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1551596, /*  1184 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52569932, /*  1185 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1186 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1187 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439610, /*  1188 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
      134420, /*  1189 (  44) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  1190 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  1191 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52451834, /*  1192 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
      134420, /*  1193 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52570094, /*  1194 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*  1195 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439610, /*  1196 (  45) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*  1197 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1198 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1199 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34146644, /*  1200 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52451834, /*  1201 (  46) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1202 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  1203 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34028546, /*  1204 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      134420, /*  1205 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  1206 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18557870, /*  1207 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439610, /*  1208 (  47) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*  1209 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1210 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  1211 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51152918, /*  1212 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      134420, /*  1213 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445884, /*  1214 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  1215 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439610, /*  1216 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35563820, /*  1217 (  48) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  1218 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*  1219 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557868, /*  1220 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17022594, /*  1221 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  1222 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  1223 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570092, /*  1224 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17022594, /*  1225 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563982, /*  1226 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551758, /*  1227 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557868, /*  1228 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34028708, /*  1229 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1230 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*  1231 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51034818, /*  1232 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570092, /*  1233 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  1234 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  1235 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028706, /*  1236 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17022594, /*  1237 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034820, /*  1238 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  1239 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557868, /*  1240 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  1241 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1242 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  1243 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35445884, /*  1244 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17022594, /*  1245 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146806, /*  1246 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1551758, /*  1247 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557868, /*  1248 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51152916, /*  1249 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  1250 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  1251 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551756, /*  1252 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    18439770, /*  1253 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  1254 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  1255 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563980, /*  1256 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18439770, /*  1257 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51152918, /*  1258 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140694, /*  1259 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551756, /*  1260 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34028708, /*  1261 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1262 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  1263 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451994, /*  1264 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563980, /*  1265 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  1266 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  1267 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028706, /*  1268 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439770, /*  1269 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52451996, /*  1270 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140694, /*  1271 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551756, /*  1272 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35563982, /*  1273 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  1274 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  1275 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51034820, /*  1276 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439770, /*  1277 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34146806, /*  1278 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17140694, /*  1279 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551756, /*  1280 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52570092, /*  1281 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  1282 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1283 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140692, /*  1284 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1433658, /*  1285 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  1286 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  1287 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51152916, /*  1288 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1433658, /*  1289 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52570094, /*  1290 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*  1291 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140692, /*  1292 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34028708, /*  1293 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1294 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1295 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35445882, /*  1296 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51152916, /*  1297 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  1298 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570092, /*  1299 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028706, /*  1300 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1433658, /*  1301 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445884, /*  1302 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  1303 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140692, /*  1304 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51152918, /*  1305 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  1306 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  1307 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52451996, /*  1308 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1433658, /*  1309 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146806, /*  1310 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18557870, /*  1311 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140692, /*  1312 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35563980, /*  1313 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  1314 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  1315 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557868, /*  1316 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1433658, /*  1317 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  1318 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  1319 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52570092, /*  1320 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1433658, /*  1321 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152918, /*  1322 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140694, /*  1323 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557868, /*  1324 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34028708, /*  1325 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1326 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  1327 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35445882, /*  1328 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52570092, /*  1329 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  1330 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  1331 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028706, /*  1332 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1433658, /*  1333 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445884, /*  1334 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*  1335 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557868, /*  1336 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  1337 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1338 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  1339 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51034820, /*  1340 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1433658, /*  1341 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146806, /*  1342 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17140694, /*  1343 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557868, /*  1344 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35563980, /*  1345 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  1346 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*  1347 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140692, /*  1348 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    18439770, /*  1349 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  1350 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  1351 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152916, /*  1352 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439770, /*  1353 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35563982, /*  1354 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551758, /*  1355 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140692, /*  1356 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34028708, /*  1357 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1358 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551758, /*  1359 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52451994, /*  1360 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152916, /*  1361 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  1362 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  1363 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028706, /*  1364 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439770, /*  1365 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52451996, /*  1366 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1551758, /*  1367 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140692, /*  1368 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51152918, /*  1369 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  1370 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  1371 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35445884, /*  1372 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18439770, /*  1373 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34146806, /*  1374 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1551758, /*  1375 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140692, /*  1376 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52570092, /*  1377 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  1378 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1379 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551756, /*  1380 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17022594, /*  1381 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  1382 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  1383 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35563980, /*  1384 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17022594, /*  1385 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52570094, /*  1386 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*  1387 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551756, /*  1388 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34028708, /*  1389 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1390 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1391 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51034818, /*  1392 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35563980, /*  1393 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  1394 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570092, /*  1395 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028706, /*  1396 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17022594, /*  1397 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034820, /*  1398 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  1399 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551756, /*  1400 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35563982, /*  1401 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  1402 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  1403 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52451996, /*  1404 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17022594, /*  1405 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146806, /*  1406 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18557870, /*  1407 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551756, /*  1408 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51152916, /*  1409 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  1410 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  1411 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544748, /*  1412 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1420538, /*  1413 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  1414 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  1415 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52556972, /*  1416 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1420538, /*  1417 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51152918, /*  1418 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140694, /*  1419 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544748, /*  1420 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*  1421 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1422 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  1423 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35432762, /*  1424 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52556972, /*  1425 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1426 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  1427 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015586, /*  1428 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1420538, /*  1429 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35445884, /*  1430 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*  1431 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544748, /*  1432 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  1433 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1434 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  1435 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146806, /*  1436 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1420538, /*  1437 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51034820, /*  1438 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17140694, /*  1439 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544748, /*  1440 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52438874, /*  1441 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1442 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*  1443 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127572, /*  1444 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1538636, /*  1445 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  1446 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  1447 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51139796, /*  1448 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1538636, /*  1449 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52451996, /*  1450 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439772, /*  1451 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127572, /*  1452 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028708, /*  1453 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1454 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*  1455 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35550860, /*  1456 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51139796, /*  1457 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  1458 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  1459 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34015586, /*  1460 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538636, /*  1461 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563982, /*  1462 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18439772, /*  1463 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127572, /*  1464 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152918, /*  1465 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  1466 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  1467 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35445884, /*  1468 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1538636, /*  1469 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51034820, /*  1470 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439772, /*  1471 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127572, /*  1472 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52556972, /*  1473 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1474 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1475 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426650, /*  1476 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
      121460, /*  1477 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  1478 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  1479 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438874, /*  1480 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
      121460, /*  1481 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52570094, /*  1482 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*  1483 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426650, /*  1484 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*  1485 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1486 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1487 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34133684, /*  1488 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438874, /*  1489 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1490 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556972, /*  1491 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015586, /*  1492 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      121460, /*  1493 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  1494 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18557870, /*  1495 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426650, /*  1496 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*  1497 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1498 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  1499 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35563982, /*  1500 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      121460, /*  1501 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034820, /*  1502 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  1503 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426650, /*  1504 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51139796, /*  1505 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  1506 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*  1507 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544748, /*  1508 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
      121460, /*  1509 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  1510 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  1511 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556972, /*  1512 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
      121460, /*  1513 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  1514 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439772, /*  1515 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544748, /*  1516 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*  1517 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1518 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439772, /*  1519 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34133684, /*  1520 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556972, /*  1521 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1522 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  1523 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34015586, /*  1524 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      121460, /*  1525 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  1526 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18439772, /*  1527 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544748, /*  1528 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  1529 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1530 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  1531 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35445884, /*  1532 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      121460, /*  1533 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034820, /*  1534 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439772, /*  1535 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544748, /*  1536 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51139796, /*  1537 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  1538 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  1539 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18426650, /*  1540 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1538636, /*  1541 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  1542 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  1543 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438874, /*  1544 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1538636, /*  1545 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51152918, /*  1546 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140694, /*  1547 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18426650, /*  1548 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*  1549 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1550 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  1551 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35550860, /*  1552 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438874, /*  1553 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1554 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  1555 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015586, /*  1556 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538636, /*  1557 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563982, /*  1558 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17140694, /*  1559 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18426650, /*  1560 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*  1561 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1562 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  1563 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34146806, /*  1564 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1538636, /*  1565 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51034820, /*  1566 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17140694, /*  1567 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18426650, /*  1568 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52556972, /*  1569 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  1570 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1571 (  44) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127572, /*  1572 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1420538, /*  1573 (  44) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  1574 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  1575 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139796, /*  1576 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1420538, /*  1577 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52570094, /*  1578 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557870, /*  1579 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127572, /*  1580 (  45) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028708, /*  1581 (  45) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1582 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  1583 (  46) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35432762, /*  1584 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139796, /*  1585 (  46) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  1586 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556972, /*  1587 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015586, /*  1588 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1420538, /*  1589 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35445884, /*  1590 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  1591 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127572, /*  1592 (  47) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152918, /*  1593 (  47) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  1594 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  1595 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35563982, /*  1596 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1420538, /*  1597 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51034820, /*  1598 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  1599 (  48) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127572, /*  1600 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52438874, /*  1601 (  48) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  1602 (  49) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  1603 (  49) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3198, /*  1604 (  49) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  1605 (  49) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1606 (  50) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1607 (  50) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015584, /*  1608 (  50) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3198, /*  1609 (  50) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028546, /*  1610 (  50) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3360, /*  1611 (  50) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  1612 (  50) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*  1613 (  50) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1614 (  51) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  1615 (  51) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015422, /*  1616 (  51) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16322, /*  1617 (  51) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1618 (  52) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  1619 (  52) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028546, /*  1620 (  52) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  1621 (  52) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  1622 (  53) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  1623 (  53) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3198, /*  1624 (  53) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015584, /*  1625 (  53) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  1626 (  54) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  1627 (  54) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*  1628 (  54) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034658, /*  1629 (  54) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3198, /*  1630 (  54) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  1631 (  54) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3360, /*  1632 (  54) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  1633 (  54) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1634 (  55) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  1635 (  55) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  1636 (  55) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  1637 (  55) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*  1638 (  55) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  1639 (  55) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3360, /*  1640 (  55) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  1641 (  55) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1642 (  56) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  1643 (  56) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438710, /*  1644 (  56) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*  1645 (  56) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  1646 (  56) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3360, /*  1647 (  56) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*  1648 (  56) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16322, /*  1649 (  56) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1650 (  49) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  1651 (  49) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  1652 (  49) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16482, /*  1653 (  49) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  1654 (  50) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1655 (  50) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015424, /*  1656 (  50) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3198, /*  1657 (  50) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028706, /*  1658 (  50) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3200, /*  1659 (  50) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*  1660 (  50) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*  1661 (  50) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  1662 (  51) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  1663 (  51) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  1664 (  51) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16482, /*  1665 (  51) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  1666 (  52) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  1667 (  52) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  1668 (  52) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015422, /*  1669 (  52) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  1670 (  53) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  1671 (  53) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3198, /*  1672 (  53) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015424, /*  1673 (  53) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1674 (  54) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  1675 (  54) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432600, /*  1676 (  54) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445882, /*  1677 (  54) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  1678 (  54) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  1679 (  54) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3200, /*  1680 (  54) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  1681 (  54) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  1682 (  55) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  1683 (  55) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  1684 (  55) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  1685 (  55) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*  1686 (  55) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  1687 (  55) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3200, /*  1688 (  55) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  1689 (  55) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  1690 (  56) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  1691 (  56) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35550696, /*  1692 (  56) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35563982, /*  1693 (  56) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  1694 (  56) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3200, /*  1695 (  56) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550698, /*  1696 (  56) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16482, /*  1697 (  56) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  1698 (  49) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  1699 (  49) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3198, /*  1700 (  49) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  1701 (  49) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1702 (  50) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1703 (  50) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028544, /*  1704 (  50) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3198, /*  1705 (  50) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015586, /*  1706 (  50) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16320, /*  1707 (  50) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  1708 (  50) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*  1709 (  50) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1710 (  51) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  1711 (  51) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015422, /*  1712 (  51) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3362, /*  1713 (  51) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1714 (  52) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  1715 (  52) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015586, /*  1716 (  52) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  1717 (  52) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  1718 (  53) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  1719 (  53) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3198, /*  1720 (  53) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028544, /*  1721 (  53) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  1722 (  54) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*  1723 (  54) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146642, /*  1724 (  54) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34133684, /*  1725 (  54) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  1726 (  54) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  1727 (  54) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16320, /*  1728 (  54) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  1729 (  54) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1730 (  55) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  1731 (  55) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  1732 (  55) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  1733 (  55) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*  1734 (  55) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  1735 (  55) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16320, /*  1736 (  55) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  1737 (  55) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1738 (  56) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  1739 (  56) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139632, /*  1740 (  56) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152918, /*  1741 (  56) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  1742 (  56) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16320, /*  1743 (  56) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152754, /*  1744 (  56) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3362, /*  1745 (  56) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1746 (  57) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  1747 (  57) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1420536, /*  1748 (  57) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433498, /*  1749 (  57) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  1750 (  58) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1751 (  58) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35432760, /*  1752 (  58) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1433498, /*  1753 (  58) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
        3198, /*  1754 (  58) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  1755 (  58) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420536, /*  1756 (  58) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34028708, /*  1757 (  58) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1758 (  59) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433498, /*  1759 (  59) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015422, /*  1760 (  59) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35432760, /*  1761 (  59) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  1762 (  60) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1763 (  60) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35445722, /*  1764 (  60) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420536, /*  1765 (  60) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  1766 (  61) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  1767 (  61) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  1768 (  61) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432760, /*  1769 (  61) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  1770 (  62) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  1771 (  62) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51034820, /*  1772 (  62) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52438872, /*  1773 (  62) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  1774 (  62) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  1775 (  62) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1420536, /*  1776 (  62) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433498, /*  1777 (  62) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  1778 (  63) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  1779 (  63) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015584, /*  1780 (  63) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3198, /*  1781 (  63) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1420536, /*  1782 (  63) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445884, /*  1783 (  63) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  1784 (  63) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1433498, /*  1785 (  63) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  1786 (  64) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438710, /*  1787 (  64) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*  1788 (  64) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  1789 (  64) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1420536, /*  1790 (  64) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51021696, /*  1791 (  64) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1433498, /*  1792 (  64) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51034658, /*  1793 (  64) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  1794 (  57) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  1795 (  57) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  1796 (  57) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  1797 (  57) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  1798 (  58) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1799 (  58) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34133522, /*  1800 (  58) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      134580, /*  1801 (  58) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
        3198, /*  1802 (  58) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  1803 (  58) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
      121298, /*  1804 (  58) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028708, /*  1805 (  58) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1806 (  59) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134580, /*  1807 (  59) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015422, /*  1808 (  59) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34133522, /*  1809 (  59) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  1810 (  60) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1811 (  60) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34146804, /*  1812 (  60) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
      121298, /*  1813 (  60) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  1814 (  61) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  1815 (  61) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  1816 (  61) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34133522, /*  1817 (  61) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  1818 (  62) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  1819 (  62) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35445884, /*  1820 (  62) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35550698, /*  1821 (  62) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  1822 (  62) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  1823 (  62) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
      121298, /*  1824 (  62) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  1825 (  62) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  1826 (  63) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  1827 (  63) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015424, /*  1828 (  63) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3198, /*  1829 (  63) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  1830 (  63) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  1831 (  63) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  1832 (  63) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
      134580, /*  1833 (  63) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  1834 (  64) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550696, /*  1835 (  64) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35563982, /*  1836 (  64) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  1837 (  64) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  1838 (  64) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35432600, /*  1839 (  64) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      134580, /*  1840 (  64) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    35445882, /*  1841 (  64) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  1842 (  57) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  1843 (  57) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  1844 (  57) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17009474, /*  1845 (  57) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  1846 (  58) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1847 (  58) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51034656, /*  1848 (  58) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17009474, /*  1849 (  58) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3198, /*  1850 (  58) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  1851 (  58) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022432, /*  1852 (  58) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34028708, /*  1853 (  58) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  1854 (  59) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009474, /*  1855 (  59) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015422, /*  1856 (  59) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51034656, /*  1857 (  59) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  1858 (  60) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1859 (  60) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51021698, /*  1860 (  60) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022432, /*  1861 (  60) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  1862 (  61) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  1863 (  61) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  1864 (  61) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034656, /*  1865 (  61) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  1866 (  62) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  1867 (  62) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146806, /*  1868 (  62) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152754, /*  1869 (  62) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3198, /*  1870 (  62) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  1871 (  62) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17022432, /*  1872 (  62) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17009474, /*  1873 (  62) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  1874 (  63) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  1875 (  63) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028544, /*  1876 (  63) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3198, /*  1877 (  63) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  1878 (  63) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034820, /*  1879 (  63) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  1880 (  63) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17009474, /*  1881 (  63) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  1882 (  64) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139632, /*  1883 (  64) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152918, /*  1884 (  64) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  1885 (  64) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  1886 (  64) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146642, /*  1887 (  64) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17009474, /*  1888 (  64) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34133684, /*  1889 (  64) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  1890 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  1891 (  65) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439610, /*  1892 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426486, /*  1893 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  1894 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  1895 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  1896 (  65) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  1897 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1898 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  1899 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18426648, /*  1900 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34028546, /*  1901 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  1902 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  1903 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18439610, /*  1904 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015584, /*  1905 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426486, /*  1906 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52438872, /*  1907 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*  1908 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  1909 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  1910 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  1911 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  1912 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*  1913 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1914 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1915 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  1916 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18439610, /*  1917 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015584, /*  1918 (  67) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439772, /*  1919 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52438872, /*  1920 (  67) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16322, /*  1921 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1922 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  1923 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18426648, /*  1924 (  68) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34028546, /*  1925 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  1926 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  1927 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18439772, /*  1928 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  1929 (  68) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  1930 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  1931 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34028546, /*  1932 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015584, /*  1933 (  69) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426486, /*  1934 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  1935 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  1936 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52438872, /*  1937 (  69) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  1938 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  1939 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439610, /*  1940 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34146644, /*  1941 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52569932, /*  1942 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18426486, /*  1943 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34133520, /*  1944 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  1945 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556808, /*  1946 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146806, /*  1947 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556970, /*  1948 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  1949 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  1950 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  1951 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570094, /*  1952 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16322, /*  1953 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1954 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  1955 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439610, /*  1956 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51034820, /*  1957 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*  1958 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18426486, /*  1959 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35432760, /*  1960 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51034658, /*  1961 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3198, /*  1962 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  1963 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35445722, /*  1964 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*  1965 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  1966 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18439772, /*  1967 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  1968 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  1969 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1970 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538634, /*  1971 (  65) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1551596, /*  1972 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538472, /*  1973 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  1974 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  1975 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3360, /*  1976 (  65) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  1977 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1978 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  1979 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538634, /*  1980 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34028546, /*  1981 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  1982 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  1983 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1551596, /*  1984 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34015584, /*  1985 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1538472, /*  1986 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35550858, /*  1987 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35563982, /*  1988 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  1989 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  1990 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3360, /*  1991 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  1992 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*  1993 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  1994 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  1995 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  1996 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1551596, /*  1997 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34015584, /*  1998 (  67) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551758, /*  1999 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550858, /*  2000 (  67) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16322, /*  2001 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2002 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  2003 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538634, /*  2004 (  68) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34028546, /*  2005 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  2006 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  2007 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1551758, /*  2008 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3360, /*  2009 (  68) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2010 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  2011 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028546, /*  2012 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015584, /*  2013 (  69) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1538472, /*  2014 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  2015 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  2016 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550858, /*  2017 (  69) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  2018 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538634, /*  2019 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1551596, /*  2020 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51152756, /*  2021 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451834, /*  2022 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1538472, /*  2023 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51139632, /*  2024 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3198, /*  2025 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438710, /*  2026 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152918, /*  2027 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52438872, /*  2028 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51139794, /*  2029 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1551758, /*  2030 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3360, /*  2031 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*  2032 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16322, /*  2033 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2034 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538634, /*  2035 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1551596, /*  2036 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34146806, /*  2037 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133682, /*  2038 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1538472, /*  2039 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35432760, /*  2040 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34146644, /*  2041 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  2042 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  2043 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35445722, /*  2044 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*  2045 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  2046 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1551758, /*  2047 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3360, /*  2048 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  2049 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2050 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544746, /*  2051 (  65) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18557708, /*  2052 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18544584, /*  2053 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  2054 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  2055 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*  2056 (  65) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  2057 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2058 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  2059 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18544746, /*  2060 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34028546, /*  2061 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  2062 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  2063 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18557708, /*  2064 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34015584, /*  2065 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544584, /*  2066 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52556970, /*  2067 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52570094, /*  2068 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  2069 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  2070 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*  2071 (  66) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  2072 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*  2073 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2074 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  2075 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  2076 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18557708, /*  2077 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34015584, /*  2078 (  67) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18557870, /*  2079 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556970, /*  2080 (  67) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16322, /*  2081 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2082 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  2083 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18544746, /*  2084 (  68) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34028546, /*  2085 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  2086 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  2087 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18557870, /*  2088 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*  2089 (  68) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2090 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  2091 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34028546, /*  2092 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015584, /*  2093 (  69) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544584, /*  2094 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  2095 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  2096 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556970, /*  2097 (  69) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  2098 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544746, /*  2099 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18557708, /*  2100 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51034658, /*  2101 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563820, /*  2102 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18544584, /*  2103 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51021534, /*  2104 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  2105 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550696, /*  2106 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034820, /*  2107 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35550858, /*  2108 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51021696, /*  2109 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18557870, /*  2110 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*  2111 (  70) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563982, /*  2112 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16322, /*  2113 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2114 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544746, /*  2115 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18557708, /*  2116 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51152918, /*  2117 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139794, /*  2118 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18544584, /*  2119 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35432760, /*  2120 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51152756, /*  2121 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  2122 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139632, /*  2123 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445722, /*  2124 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*  2125 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  2126 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18557870, /*  2127 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*  2128 (  71) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  2129 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2130 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  2131 (  65) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1551756, /*  2132 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538472, /*  2133 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  2134 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  2135 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  2136 (  65) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  2137 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2138 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  2139 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1538474, /*  2140 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028706, /*  2141 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015422, /*  2142 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  2143 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1551756, /*  2144 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34015424, /*  2145 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538472, /*  2146 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35550698, /*  2147 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563982, /*  2148 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  2149 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  2150 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  2151 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*  2152 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*  2153 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2154 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  2155 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  2156 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1551756, /*  2157 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34015424, /*  2158 (  67) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551758, /*  2159 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550698, /*  2160 (  67) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16482, /*  2161 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2162 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  2163 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1538474, /*  2164 (  68) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028706, /*  2165 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015422, /*  2166 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  2167 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1551758, /*  2168 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  2169 (  68) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2170 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  2171 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028706, /*  2172 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015424, /*  2173 (  69) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538472, /*  2174 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  2175 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  2176 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550698, /*  2177 (  69) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  2178 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  2179 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1551756, /*  2180 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51034818, /*  2181 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570092, /*  2182 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1538472, /*  2183 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51021534, /*  2184 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  2185 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556808, /*  2186 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51034820, /*  2187 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52556810, /*  2188 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  2189 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  2190 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  2191 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570094, /*  2192 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16482, /*  2193 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2194 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  2195 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1551756, /*  2196 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35445884, /*  2197 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432600, /*  2198 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1538472, /*  2199 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34133522, /*  2200 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35445882, /*  2201 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  2202 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  2203 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34146804, /*  2204 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*  2205 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  2206 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1551758, /*  2207 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  2208 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  2209 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2210 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127410, /*  2211 (  65) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140692, /*  2212 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127408, /*  2213 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  2214 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  2215 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  2216 (  65) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  2217 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2218 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  2219 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127410, /*  2220 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028706, /*  2221 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015422, /*  2222 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  2223 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17140692, /*  2224 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015424, /*  2225 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127408, /*  2226 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51139634, /*  2227 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51152918, /*  2228 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  2229 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  2230 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  2231 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*  2232 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*  2233 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2234 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  2235 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  2236 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17140692, /*  2237 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015424, /*  2238 (  67) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140694, /*  2239 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51139634, /*  2240 (  67) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16482, /*  2241 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2242 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  2243 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127410, /*  2244 (  68) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028706, /*  2245 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015422, /*  2246 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  2247 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17140694, /*  2248 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  2249 (  68) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2250 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  2251 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028706, /*  2252 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015424, /*  2253 (  69) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127408, /*  2254 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  2255 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  2256 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51139634, /*  2257 (  69) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  2258 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127410, /*  2259 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140692, /*  2260 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52451994, /*  2261 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563980, /*  2262 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17127408, /*  2263 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52438710, /*  2264 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  2265 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550696, /*  2266 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52451996, /*  2267 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35550698, /*  2268 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438712, /*  2269 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140694, /*  2270 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  2271 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563982, /*  2272 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16482, /*  2273 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2274 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127410, /*  2275 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140692, /*  2276 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51034820, /*  2277 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021536, /*  2278 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17127408, /*  2279 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34133522, /*  2280 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51034818, /*  2281 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  2282 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  2283 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34146804, /*  2284 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*  2285 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  2286 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17140694, /*  2287 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  2288 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  2289 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2290 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544586, /*  2291 (  65) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557868, /*  2292 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18544584, /*  2293 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  2294 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  2295 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*  2296 (  65) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  2297 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2298 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570092, /*  2299 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18544586, /*  2300 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028706, /*  2301 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015422, /*  2302 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  2303 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18557868, /*  2304 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34015424, /*  2305 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544584, /*  2306 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52556810, /*  2307 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52570094, /*  2308 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  2309 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  2310 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*  2311 (  66) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*  2312 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*  2313 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2314 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  2315 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  2316 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18557868, /*  2317 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34015424, /*  2318 (  67) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18557870, /*  2319 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556810, /*  2320 (  67) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16482, /*  2321 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2322 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570092, /*  2323 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18544586, /*  2324 (  68) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028706, /*  2325 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015422, /*  2326 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  2327 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18557870, /*  2328 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*  2329 (  68) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2330 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570092, /*  2331 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028706, /*  2332 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015424, /*  2333 (  69) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544584, /*  2334 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  2335 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  2336 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556810, /*  2337 (  69) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  2338 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544586, /*  2339 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557868, /*  2340 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35445882, /*  2341 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51152916, /*  2342 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18544584, /*  2343 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35432598, /*  2344 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  2345 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139632, /*  2346 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445884, /*  2347 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139634, /*  2348 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35432600, /*  2349 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  2350 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*  2351 (  70) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152918, /*  2352 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16482, /*  2353 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2354 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544586, /*  2355 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557868, /*  2356 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52451996, /*  2357 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438712, /*  2358 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18544584, /*  2359 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34133522, /*  2360 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52451994, /*  2361 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  2362 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438710, /*  2363 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146804, /*  2364 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*  2365 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  2366 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  2367 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*  2368 (  71) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  2369 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2370 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  2371 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127572, /*  2372 (  65) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17127408, /*  2373 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  2374 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  2375 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  2376 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  2377 (  65) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2378 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  2379 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140530, /*  2380 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015586, /*  2381 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  2382 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  2383 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127572, /*  2384 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028544, /*  2385 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127408, /*  2386 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51152754, /*  2387 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152918, /*  2388 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  2389 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  2390 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  2391 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  2392 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*  2393 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2394 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  2395 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  2396 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127572, /*  2397 (  67) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028544, /*  2398 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17140694, /*  2399 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152754, /*  2400 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3362, /*  2401 (  67) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2402 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  2403 (  68) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140530, /*  2404 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015586, /*  2405 (  68) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  2406 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  2407 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17140694, /*  2408 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  2409 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2410 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  2411 (  69) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015586, /*  2412 (  69) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028544, /*  2413 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127408, /*  2414 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  2415 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  2416 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152754, /*  2417 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  2418 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  2419 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127572, /*  2420 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35432762, /*  2421 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52556972, /*  2422 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17127408, /*  2423 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35432598, /*  2424 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  2425 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556808, /*  2426 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445884, /*  2427 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52569930, /*  2428 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445720, /*  2429 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17140694, /*  2430 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  2431 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570094, /*  2432 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3362, /*  2433 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2434 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  2435 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127572, /*  2436 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34146806, /*  2437 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146642, /*  2438 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17127408, /*  2439 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51034656, /*  2440 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34133684, /*  2441 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  2442 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  2443 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51021698, /*  2444 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*  2445 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  2446 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17140694, /*  2447 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  2448 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  2449 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2450 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*  2451 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18426650, /*  2452 (  65) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426486, /*  2453 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  2454 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  2455 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*  2456 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  2457 (  65) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2458 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  2459 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439608, /*  2460 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34015586, /*  2461 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  2462 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  2463 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18426650, /*  2464 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028544, /*  2465 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426486, /*  2466 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52451832, /*  2467 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*  2468 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  2469 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  2470 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*  2471 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  2472 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*  2473 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2474 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  2475 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  2476 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18426650, /*  2477 (  67) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028544, /*  2478 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439772, /*  2479 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451832, /*  2480 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3362, /*  2481 (  67) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2482 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  2483 (  68) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439608, /*  2484 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34015586, /*  2485 (  68) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  2486 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  2487 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18439772, /*  2488 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*  2489 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2490 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  2491 (  69) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34015586, /*  2492 (  69) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028544, /*  2493 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426486, /*  2494 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  2495 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  2496 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451832, /*  2497 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  2498 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*  2499 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18426650, /*  2500 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35550860, /*  2501 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51139796, /*  2502 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18426486, /*  2503 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35550696, /*  2504 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
        3198, /*  2505 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139632, /*  2506 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35563982, /*  2507 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51152754, /*  2508 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35563818, /*  2509 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18439772, /*  2510 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*  2511 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152918, /*  2512 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3362, /*  2513 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2514 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*  2515 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18426650, /*  2516 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35445884, /*  2517 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445720, /*  2518 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18426486, /*  2519 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51034656, /*  2520 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35432762, /*  2521 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
        3198, /*  2522 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  2523 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51021698, /*  2524 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*  2525 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  2526 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18439772, /*  2527 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*  2528 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  2529 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2530 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557706, /*  2531 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18544748, /*  2532 (  65) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18544584, /*  2533 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  2534 (  65) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  2535 (  65) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16320, /*  2536 (  65) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  2537 (  65) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2538 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556972, /*  2539 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557706, /*  2540 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34015586, /*  2541 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  2542 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  2543 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18544748, /*  2544 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028544, /*  2545 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544584, /*  2546 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52569930, /*  2547 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52570094, /*  2548 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  2549 (  66) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  2550 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16320, /*  2551 (  66) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  2552 (  66) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*  2553 (  66) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2554 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  2555 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  2556 (  67) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18544748, /*  2557 (  67) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028544, /*  2558 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18557870, /*  2559 (  67) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52569930, /*  2560 (  67) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3362, /*  2561 (  67) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2562 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556972, /*  2563 (  68) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557706, /*  2564 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34015586, /*  2565 (  68) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015422, /*  2566 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  2567 (  68) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18557870, /*  2568 (  68) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16320, /*  2569 (  68) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  2570 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556972, /*  2571 (  69) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015586, /*  2572 (  69) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028544, /*  2573 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544584, /*  2574 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  2575 (  69) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  2576 (  69) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52569930, /*  2577 (  69) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  2578 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557706, /*  2579 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18544748, /*  2580 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34133684, /*  2581 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438874, /*  2582 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18544584, /*  2583 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34133520, /*  2584 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  2585 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438710, /*  2586 (  70) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146806, /*  2587 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52451832, /*  2588 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146642, /*  2589 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  2590 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16320, /*  2591 (  70) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*  2592 (  70) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3362, /*  2593 (  70) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2594 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557706, /*  2595 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18544748, /*  2596 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35563982, /*  2597 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563818, /*  2598 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18544584, /*  2599 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51034656, /*  2600 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35550860, /*  2601 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  2602 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550696, /*  2603 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51021698, /*  2604 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*  2605 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  2606 (  71) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18557870, /*  2607 (  71) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16320, /*  2608 (  71) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  2609 (  71) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  2610 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*  2611 (  72) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  2612 (  72) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121458, /*  2613 (  72) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  2614 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  2615 (  73) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015422, /*  2616 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34146644, /*  2617 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  2618 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133682, /*  2619 (  73) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
      134420, /*  2620 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028708, /*  2621 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  2622 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*  2623 (  74) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34015422, /*  2624 (  74) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34133682, /*  2625 (  74) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  2626 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  2627 (  75) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34015422, /*  2628 (  75) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      121458, /*  2629 (  75) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  2630 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  2631 (  76) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  2632 (  76) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133682, /*  2633 (  76) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  2634 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139794, /*  2635 (  77) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
      121458, /*  2636 (  77) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    51152756, /*  2637 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51034820, /*  2638 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3198, /*  2639 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  2640 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
      134420, /*  2641 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  2642 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  2643 (  78) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    35550858, /*  2644 (  78) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
        3198, /*  2645 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  2646 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  2647 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
      134420, /*  2648 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35563820, /*  2649 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  2650 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  2651 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      121458, /*  2652 (  79) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015584, /*  2653 (  79) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34133520, /*  2654 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  2655 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  2656 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      134420, /*  2657 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  2658 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550696, /*  2659 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
      121458, /*  2660 (  80) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    35432760, /*  2661 (  80) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35563982, /*  2662 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  2663 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  2664 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      134420, /*  2665 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  2666 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  2667 (  81) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52438710, /*  2668 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52569932, /*  2669 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52451996, /*  2670 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  2671 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556970, /*  2672 (  81) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
      134420, /*  2673 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  2674 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*  2675 (  72) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3198, /*  2676 (  72) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17127570, /*  2677 (  72) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  2678 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  2679 (  73) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015422, /*  2680 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51152756, /*  2681 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  2682 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139794, /*  2683 (  73) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17140532, /*  2684 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028708, /*  2685 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  2686 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*  2687 (  74) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34015422, /*  2688 (  74) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139794, /*  2689 (  74) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  2690 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  2691 (  75) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015422, /*  2692 (  75) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127570, /*  2693 (  75) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  2694 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  2695 (  76) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  2696 (  76) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139794, /*  2697 (  76) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  2698 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021696, /*  2699 (  77) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17127570, /*  2700 (  77) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51034658, /*  2701 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34146806, /*  2702 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  2703 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  2704 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17140532, /*  2705 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  2706 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  2707 (  78) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52556970, /*  2708 (  78) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3198, /*  2709 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  2710 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  2711 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17140532, /*  2712 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52569932, /*  2713 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  2714 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  2715 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127570, /*  2716 (  79) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015584, /*  2717 (  79) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  2718 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3198, /*  2719 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152918, /*  2720 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140532, /*  2721 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  2722 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556808, /*  2723 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17127570, /*  2724 (  80) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35432760, /*  2725 (  80) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52570094, /*  2726 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  2727 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  2728 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140532, /*  2729 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  2730 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  2731 (  81) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35550696, /*  2732 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52451834, /*  2733 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35563982, /*  2734 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  2735 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*  2736 (  81) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140532, /*  2737 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  2738 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  2739 (  72) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3198, /*  2740 (  72) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17009472, /*  2741 (  72) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  2742 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009472, /*  2743 (  73) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34015422, /*  2744 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51034658, /*  2745 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3198, /*  2746 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021696, /*  2747 (  73) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17022434, /*  2748 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34028708, /*  2749 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  2750 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  2751 (  74) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015422, /*  2752 (  74) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51021696, /*  2753 (  74) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  2754 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  2755 (  75) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34015422, /*  2756 (  75) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009472, /*  2757 (  75) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  2758 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  2759 (  76) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3198, /*  2760 (  76) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021696, /*  2761 (  76) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  2762 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133682, /*  2763 (  77) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17009472, /*  2764 (  77) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146644, /*  2765 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152918, /*  2766 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  2767 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139632, /*  2768 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17022434, /*  2769 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  2770 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009472, /*  2771 (  78) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52438872, /*  2772 (  78) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  2773 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  2774 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  2775 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022434, /*  2776 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52451834, /*  2777 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  2778 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  2779 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17009472, /*  2780 (  79) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34015584, /*  2781 (  79) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51021534, /*  2782 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  2783 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  2784 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022434, /*  2785 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  2786 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438710, /*  2787 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17009472, /*  2788 (  80) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35432760, /*  2789 (  80) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52451996, /*  2790 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  2791 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  2792 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17022434, /*  2793 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  2794 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009472, /*  2795 (  81) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52556808, /*  2796 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35563820, /*  2797 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52570094, /*  2798 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  2799 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550858, /*  2800 (  81) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17022434, /*  2801 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  2802 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*  2803 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
        3198, /*  2804 (  72) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17009312, /*  2805 (  72) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  2806 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  2807 (  73) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015422, /*  2808 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51034818, /*  2809 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  2810 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021536, /*  2811 (  73) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022594, /*  2812 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34028708, /*  2813 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  2814 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*  2815 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34015422, /*  2816 (  74) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51021536, /*  2817 (  74) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  2818 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  2819 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34015422, /*  2820 (  75) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009312, /*  2821 (  75) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  2822 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  2823 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  2824 (  76) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021536, /*  2825 (  76) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  2826 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438712, /*  2827 (  77) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17009312, /*  2828 (  77) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52451994, /*  2829 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35445884, /*  2830 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
        3198, /*  2831 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  2832 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022594, /*  2833 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  2834 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  2835 (  78) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51139634, /*  2836 (  78) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  2837 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  2838 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  2839 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17022594, /*  2840 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51152916, /*  2841 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  2842 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  2843 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009312, /*  2844 (  79) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015424, /*  2845 (  79) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51021534, /*  2846 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  2847 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  2848 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022594, /*  2849 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  2850 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139632, /*  2851 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17009312, /*  2852 (  80) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34133522, /*  2853 (  80) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152918, /*  2854 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  2855 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  2856 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17022594, /*  2857 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  2858 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  2859 (  81) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35550696, /*  2860 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52570092, /*  2861 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35563982, /*  2862 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  2863 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556810, /*  2864 (  81) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17022594, /*  2865 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  2866 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439770, /*  2867 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  2868 (  72) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18426488, /*  2869 (  72) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  2870 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  2871 (  73) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015422, /*  2872 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451994, /*  2873 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  2874 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438712, /*  2875 (  73) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439770, /*  2876 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34028708, /*  2877 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  2878 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439770, /*  2879 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34015422, /*  2880 (  74) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438712, /*  2881 (  74) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  2882 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  2883 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34015422, /*  2884 (  75) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426488, /*  2885 (  75) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  2886 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  2887 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  2888 (  76) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438712, /*  2889 (  76) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  2890 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432600, /*  2891 (  77) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18426488, /*  2892 (  77) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35445882, /*  2893 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51034820, /*  2894 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3198, /*  2895 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  2896 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18439770, /*  2897 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  2898 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  2899 (  78) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52556810, /*  2900 (  78) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  2901 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  2902 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  2903 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439770, /*  2904 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52570092, /*  2905 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  2906 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  2907 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426488, /*  2908 (  79) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015424, /*  2909 (  79) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52438710, /*  2910 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  2911 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*  2912 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439770, /*  2913 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  2914 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556808, /*  2915 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18426488, /*  2916 (  80) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34133522, /*  2917 (  80) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52570094, /*  2918 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  2919 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  2920 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439770, /*  2921 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  2922 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  2923 (  81) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51139632, /*  2924 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35563980, /*  2925 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51152918, /*  2926 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  2927 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550698, /*  2928 (  81) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18439770, /*  2929 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  2930 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  2931 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3198, /*  2932 (  72) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1420376, /*  2933 (  72) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  2934 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420376, /*  2935 (  73) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015422, /*  2936 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35445882, /*  2937 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  2938 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432600, /*  2939 (  73) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1433658, /*  2940 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34028708, /*  2941 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  2942 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  2943 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34015422, /*  2944 (  74) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35432600, /*  2945 (  74) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  2946 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  2947 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34015422, /*  2948 (  75) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1420376, /*  2949 (  75) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  2950 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  2951 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  2952 (  76) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432600, /*  2953 (  76) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  2954 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021536, /*  2955 (  77) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1420376, /*  2956 (  77) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51034818, /*  2957 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52451996, /*  2958 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  2959 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438710, /*  2960 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1433658, /*  2961 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  2962 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420376, /*  2963 (  78) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35550698, /*  2964 (  78) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  2965 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  2966 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  2967 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1433658, /*  2968 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35563980, /*  2969 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  2970 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  2971 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1420376, /*  2972 (  79) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015424, /*  2973 (  79) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35432598, /*  2974 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  2975 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  2976 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1433658, /*  2977 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  2978 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550696, /*  2979 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1420376, /*  2980 (  80) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34133522, /*  2981 (  80) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35563982, /*  2982 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  2983 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  2984 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1433658, /*  2985 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  2986 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420376, /*  2987 (  81) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52556808, /*  2988 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51152916, /*  2989 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52570094, /*  2990 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  2991 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139634, /*  2992 (  81) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1433658, /*  2993 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  2994 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*  2995 (  72) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
        3198, /*  2996 (  72) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1433496, /*  2997 (  72) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  2998 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  2999 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34015422, /*  3000 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35432762, /*  3001 (  73) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
        3198, /*  3002 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445720, /*  3003 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1420538, /*  3004 (  73) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34028708, /*  3005 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  3006 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*  3007 (  74) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015422, /*  3008 (  74) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35445720, /*  3009 (  74) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  3010 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  3011 (  75) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34015422, /*  3012 (  75) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1433496, /*  3013 (  75) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  3014 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  3015 (  76) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
        3198, /*  3016 (  76) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445720, /*  3017 (  76) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  3018 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563818, /*  3019 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1433496, /*  3020 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35550860, /*  3021 (  77) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146806, /*  3022 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  3023 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  3024 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1420538, /*  3025 (  77) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  3026 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  3027 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52451832, /*  3028 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  3029 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  3030 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  3031 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1420538, /*  3032 (  78) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52438874, /*  3033 (  78) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  3034 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  3035 (  79) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1433496, /*  3036 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34028544, /*  3037 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35432598, /*  3038 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  3039 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  3040 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420538, /*  3041 (  79) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  3042 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438710, /*  3043 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1433496, /*  3044 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51034656, /*  3045 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52451996, /*  3046 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  3047 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  3048 (  80) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1420538, /*  3049 (  80) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  3050 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  3051 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51139632, /*  3052 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52556972, /*  3053 (  81) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51152918, /*  3054 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  3055 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52569930, /*  3056 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1420538, /*  3057 (  81) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  3058 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*  3059 (  72) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3198, /*  3060 (  72) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551594, /*  3061 (  72) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3062 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  3063 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34015422, /*  3064 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550860, /*  3065 (  73) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  3066 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563818, /*  3067 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1538636, /*  3068 (  73) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028708, /*  3069 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  3070 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*  3071 (  74) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34015422, /*  3072 (  74) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35563818, /*  3073 (  74) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  3074 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  3075 (  75) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34015422, /*  3076 (  75) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551594, /*  3077 (  75) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3078 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  3079 (  76) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  3080 (  76) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563818, /*  3081 (  76) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  3082 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146642, /*  3083 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1551594, /*  3084 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34133684, /*  3085 (  77) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35445884, /*  3086 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
        3198, /*  3087 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  3088 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1538636, /*  3089 (  77) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3090 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  3091 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52569930, /*  3092 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3198, /*  3093 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  3094 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  3095 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1538636, /*  3096 (  78) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52556972, /*  3097 (  78) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  3098 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  3099 (  79) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551594, /*  3100 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34028544, /*  3101 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  3102 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
        3198, /*  3103 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563982, /*  3104 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538636, /*  3105 (  79) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3106 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556808, /*  3107 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1551594, /*  3108 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51034656, /*  3109 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570094, /*  3110 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3111 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  3112 (  80) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1538636, /*  3113 (  80) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3114 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  3115 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52438710, /*  3116 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51139796, /*  3117 (  81) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451996, /*  3118 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  3119 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152754, /*  3120 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1538636, /*  3121 (  81) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3122 (  72) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  3123 (  72) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  3124 (  72) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      134418, /*  3125 (  72) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  3126 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134418, /*  3127 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015422, /*  3128 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34133684, /*  3129 (  73) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  3130 (  73) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146642, /*  3131 (  73) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
      121460, /*  3132 (  73) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028708, /*  3133 (  73) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  3134 (  74) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  3135 (  74) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34015422, /*  3136 (  74) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34146642, /*  3137 (  74) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  3138 (  75) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  3139 (  75) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34015422, /*  3140 (  75) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      134418, /*  3141 (  75) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  3142 (  76) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  3143 (  76) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3198, /*  3144 (  76) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146642, /*  3145 (  76) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  3146 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445720, /*  3147 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
      134418, /*  3148 (  77) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    35432762, /*  3149 (  77) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35563982, /*  3150 (  77) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  3151 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550696, /*  3152 (  77) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
      121460, /*  3153 (  77) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  3154 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134418, /*  3155 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    51152754, /*  3156 (  78) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3198, /*  3157 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  3158 (  78) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  3159 (  78) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
      121460, /*  3160 (  78) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51139796, /*  3161 (  78) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  3162 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  3163 (  79) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      134418, /*  3164 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34028544, /*  3165 (  79) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34133520, /*  3166 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  3167 (  79) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  3168 (  79) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121460, /*  3169 (  79) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  3170 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139632, /*  3171 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
      134418, /*  3172 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    51034656, /*  3173 (  80) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51152918, /*  3174 (  80) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  3175 (  80) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  3176 (  80) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      121460, /*  3177 (  80) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  3178 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134418, /*  3179 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52556808, /*  3180 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52438874, /*  3181 (  81) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52570094, /*  3182 (  81) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3183 (  81) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451832, /*  3184 (  81) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
      121460, /*  3185 (  81) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  3186 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  3187 (  82) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551596, /*  3188 (  82) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  3189 (  82) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3190 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3191 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551596, /*  3192 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3198, /*  3193 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550858, /*  3194 (  83) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028708, /*  3195 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35563820, /*  3196 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538634, /*  3197 (  83) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3198 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550858, /*  3199 (  84) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34015422, /*  3200 (  84) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551596, /*  3201 (  84) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3202 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3203 (  85) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35563820, /*  3204 (  85) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538634, /*  3205 (  85) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3206 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550858, /*  3207 (  86) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
        3198, /*  3208 (  86) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563820, /*  3209 (  86) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  3210 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  3211 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52569932, /*  3212 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1551596, /*  3213 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3198, /*  3214 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  3215 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52556970, /*  3216 (  87) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1538634, /*  3217 (  87) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3218 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  3219 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1551596, /*  3220 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3198, /*  3221 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  3222 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34133682, /*  3223 (  88) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35432598, /*  3224 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1538634, /*  3225 (  88) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3226 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551596, /*  3227 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35432760, /*  3228 (  89) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34133520, /*  3229 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  3230 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  3231 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34146806, /*  3232 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1538634, /*  3233 (  89) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3234 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550696, /*  3235 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34015584, /*  3236 (  90) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551596, /*  3237 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563982, /*  3238 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  3239 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028546, /*  3240 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538634, /*  3241 (  90) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3242 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139794, /*  3243 (  91) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52438710, /*  3244 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152756, /*  3245 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1551596, /*  3246 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52451996, /*  3247 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  3248 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1538634, /*  3249 (  91) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3250 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  3251 (  82) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557708, /*  3252 (  82) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18544746, /*  3253 (  82) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3254 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3255 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18557708, /*  3256 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3198, /*  3257 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556970, /*  3258 (  83) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028708, /*  3259 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52569932, /*  3260 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18544746, /*  3261 (  83) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3262 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  3263 (  84) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34015422, /*  3264 (  84) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18557708, /*  3265 (  84) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3266 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3267 (  85) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52569932, /*  3268 (  85) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18544746, /*  3269 (  85) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3270 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  3271 (  86) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3198, /*  3272 (  86) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52569932, /*  3273 (  86) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  3274 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*  3275 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52451834, /*  3276 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18557708, /*  3277 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3198, /*  3278 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  3279 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    52438872, /*  3280 (  87) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18544746, /*  3281 (  87) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3282 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  3283 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18557708, /*  3284 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3198, /*  3285 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  3286 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139794, /*  3287 (  88) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35432598, /*  3288 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18544746, /*  3289 (  88) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3290 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557708, /*  3291 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35432760, /*  3292 (  89) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51139632, /*  3293 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3198, /*  3294 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  3295 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51152918, /*  3296 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18544746, /*  3297 (  89) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3298 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556808, /*  3299 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34015584, /*  3300 (  90) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18557708, /*  3301 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  3302 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3303 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028546, /*  3304 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544746, /*  3305 (  90) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3306 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021696, /*  3307 (  91) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35550696, /*  3308 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034658, /*  3309 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557708, /*  3310 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35563982, /*  3311 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  3312 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18544746, /*  3313 (  91) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3314 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  3315 (  82) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439610, /*  3316 (  82) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  3317 (  82) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3318 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3319 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439610, /*  3320 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3198, /*  3321 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*  3322 (  83) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34028708, /*  3323 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52451834, /*  3324 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18426648, /*  3325 (  83) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3326 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438872, /*  3327 (  84) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34015422, /*  3328 (  84) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439610, /*  3329 (  84) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  3330 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3331 (  85) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451834, /*  3332 (  85) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18426648, /*  3333 (  85) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3334 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438872, /*  3335 (  86) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  3336 (  86) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451834, /*  3337 (  86) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  3338 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152918, /*  3339 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563820, /*  3340 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18439610, /*  3341 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3198, /*  3342 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139632, /*  3343 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35550858, /*  3344 (  87) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18426648, /*  3345 (  87) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3346 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  3347 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439610, /*  3348 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3198, /*  3349 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  3350 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51021696, /*  3351 (  88) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35432598, /*  3352 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18426648, /*  3353 (  88) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3354 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439610, /*  3355 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35432760, /*  3356 (  89) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51021534, /*  3357 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  3358 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  3359 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51034820, /*  3360 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18426648, /*  3361 (  89) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3362 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438710, /*  3363 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34015584, /*  3364 (  90) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439610, /*  3365 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*  3366 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  3367 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028546, /*  3368 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18426648, /*  3369 (  90) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3370 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133682, /*  3371 (  91) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    52556808, /*  3372 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146644, /*  3373 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18439610, /*  3374 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52570094, /*  3375 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3376 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18426648, /*  3377 (  91) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3378 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  3379 (  82) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140692, /*  3380 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  3381 (  82) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  3382 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3383 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17140692, /*  3384 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  3385 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139634, /*  3386 (  83) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34028708, /*  3387 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51152916, /*  3388 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127410, /*  3389 (  83) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  3390 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139634, /*  3391 (  84) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015422, /*  3392 (  84) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17140692, /*  3393 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  3394 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3395 (  85) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51152916, /*  3396 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127410, /*  3397 (  85) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  3398 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139634, /*  3399 (  86) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  3400 (  86) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152916, /*  3401 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  3402 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  3403 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52570092, /*  3404 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17140692, /*  3405 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  3406 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  3407 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52556810, /*  3408 (  87) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17127410, /*  3409 (  87) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  3410 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  3411 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17140692, /*  3412 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  3413 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  3414 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51021536, /*  3415 (  88) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34133520, /*  3416 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17127410, /*  3417 (  88) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  3418 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140692, /*  3419 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34133522, /*  3420 (  89) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51021534, /*  3421 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  3422 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  3423 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51034820, /*  3424 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17127410, /*  3425 (  89) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  3426 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139632, /*  3427 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34015424, /*  3428 (  90) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140692, /*  3429 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51152918, /*  3430 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  3431 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028706, /*  3432 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127410, /*  3433 (  90) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  3434 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438712, /*  3435 (  91) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35550696, /*  3436 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52451994, /*  3437 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140692, /*  3438 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35563982, /*  3439 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  3440 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17127410, /*  3441 (  91) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  3442 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  3443 (  82) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557868, /*  3444 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18544586, /*  3445 (  82) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3446 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3447 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18557868, /*  3448 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  3449 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556810, /*  3450 (  83) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34028708, /*  3451 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52570092, /*  3452 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18544586, /*  3453 (  83) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3454 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  3455 (  84) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015422, /*  3456 (  84) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18557868, /*  3457 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3458 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3459 (  85) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52570092, /*  3460 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18544586, /*  3461 (  85) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3462 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  3463 (  86) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3464 (  86) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570092, /*  3465 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  3466 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  3467 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563980, /*  3468 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18557868, /*  3469 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  3470 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  3471 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35550698, /*  3472 (  87) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18544586, /*  3473 (  87) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3474 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  3475 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18557868, /*  3476 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  3477 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  3478 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438712, /*  3479 (  88) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34133520, /*  3480 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18544586, /*  3481 (  88) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3482 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557868, /*  3483 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34133522, /*  3484 (  89) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438710, /*  3485 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  3486 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  3487 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    52451996, /*  3488 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18544586, /*  3489 (  89) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3490 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556808, /*  3491 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34015424, /*  3492 (  90) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18557868, /*  3493 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  3494 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3495 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028706, /*  3496 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544586, /*  3497 (  90) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3498 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432600, /*  3499 (  91) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139632, /*  3500 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445882, /*  3501 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18557868, /*  3502 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51152918, /*  3503 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  3504 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18544586, /*  3505 (  91) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3506 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  3507 (  82) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551756, /*  3508 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  3509 (  82) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3510 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3511 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551756, /*  3512 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  3513 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550698, /*  3514 (  83) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028708, /*  3515 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35563980, /*  3516 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1538474, /*  3517 (  83) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3518 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550698, /*  3519 (  84) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34015422, /*  3520 (  84) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551756, /*  3521 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3522 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3523 (  85) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35563980, /*  3524 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1538474, /*  3525 (  85) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3526 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550698, /*  3527 (  86) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  3528 (  86) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563980, /*  3529 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  3530 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451996, /*  3531 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51152916, /*  3532 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1551756, /*  3533 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  3534 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438710, /*  3535 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51139634, /*  3536 (  87) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1538474, /*  3537 (  87) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3538 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  3539 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1551756, /*  3540 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  3541 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  3542 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35432600, /*  3543 (  88) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34133520, /*  3544 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1538474, /*  3545 (  88) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3546 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551756, /*  3547 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34133522, /*  3548 (  89) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35432598, /*  3549 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  3550 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  3551 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35445884, /*  3552 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1538474, /*  3553 (  89) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3554 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550696, /*  3555 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34015424, /*  3556 (  90) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551756, /*  3557 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35563982, /*  3558 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  3559 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028706, /*  3560 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1538474, /*  3561 (  90) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3562 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021536, /*  3563 (  91) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52556808, /*  3564 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51034818, /*  3565 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1551756, /*  3566 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52570094, /*  3567 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3568 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1538474, /*  3569 (  91) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3570 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  3571 (  82) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18426650, /*  3572 (  82) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439608, /*  3573 (  82) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3574 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3575 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426650, /*  3576 (  83) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3198, /*  3577 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451832, /*  3578 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34028708, /*  3579 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52438874, /*  3580 (  83) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439608, /*  3581 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3582 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451832, /*  3583 (  84) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34015422, /*  3584 (  84) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426650, /*  3585 (  84) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  3586 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3587 (  85) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438874, /*  3588 (  85) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439608, /*  3589 (  85) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3590 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451832, /*  3591 (  86) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  3592 (  86) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438874, /*  3593 (  86) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  3594 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*  3595 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556972, /*  3596 (  87) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18426650, /*  3597 (  87) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3198, /*  3598 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  3599 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    52569930, /*  3600 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18439608, /*  3601 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3602 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  3603 (  88) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18426650, /*  3604 (  88) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3198, /*  3605 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  3606 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35445720, /*  3607 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51021534, /*  3608 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18439608, /*  3609 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3610 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426650, /*  3611 (  89) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51034656, /*  3612 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35432598, /*  3613 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  3614 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  3615 (  89) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35445884, /*  3616 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18439608, /*  3617 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3618 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438710, /*  3619 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34028544, /*  3620 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426650, /*  3621 (  90) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*  3622 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  3623 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015586, /*  3624 (  90) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18439608, /*  3625 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3626 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563818, /*  3627 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51139632, /*  3628 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35550860, /*  3629 (  91) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18426650, /*  3630 (  91) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51152918, /*  3631 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  3632 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439608, /*  3633 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3634 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  3635 (  82) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18544748, /*  3636 (  82) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557706, /*  3637 (  82) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3638 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3639 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544748, /*  3640 (  83) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3198, /*  3641 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52569930, /*  3642 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028708, /*  3643 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52556972, /*  3644 (  83) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557706, /*  3645 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3646 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  3647 (  84) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34015422, /*  3648 (  84) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544748, /*  3649 (  84) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3650 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3651 (  85) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556972, /*  3652 (  85) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18557706, /*  3653 (  85) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3654 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  3655 (  86) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3198, /*  3656 (  86) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556972, /*  3657 (  86) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  3658 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  3659 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139796, /*  3660 (  87) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18544748, /*  3661 (  87) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3198, /*  3662 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  3663 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51152754, /*  3664 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18557706, /*  3665 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3666 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  3667 (  88) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18544748, /*  3668 (  88) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3198, /*  3669 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  3670 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563818, /*  3671 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51021534, /*  3672 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18557706, /*  3673 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3674 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18544748, /*  3675 (  89) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51034656, /*  3676 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35550696, /*  3677 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
        3198, /*  3678 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  3679 (  89) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563982, /*  3680 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18557706, /*  3681 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3682 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556808, /*  3683 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028544, /*  3684 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544748, /*  3685 (  90) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  3686 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3687 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015586, /*  3688 (  90) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18557706, /*  3689 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3690 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146642, /*  3691 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    52438710, /*  3692 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34133684, /*  3693 (  91) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18544748, /*  3694 (  91) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52451996, /*  3695 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  3696 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557706, /*  3697 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3698 (  82) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3198, /*  3699 (  82) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17127572, /*  3700 (  82) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140530, /*  3701 (  82) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  3702 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3703 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127572, /*  3704 (  83) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3198, /*  3705 (  83) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152754, /*  3706 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028708, /*  3707 (  83) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51139796, /*  3708 (  83) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140530, /*  3709 (  83) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  3710 (  84) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152754, /*  3711 (  84) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34015422, /*  3712 (  84) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127572, /*  3713 (  84) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  3714 (  85) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3715 (  85) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139796, /*  3716 (  85) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140530, /*  3717 (  85) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  3718 (  86) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152754, /*  3719 (  86) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3198, /*  3720 (  86) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139796, /*  3721 (  86) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  3722 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563982, /*  3723 (  87) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438874, /*  3724 (  87) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17127572, /*  3725 (  87) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3198, /*  3726 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550696, /*  3727 (  87) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52451832, /*  3728 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140530, /*  3729 (  87) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  3730 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  3731 (  88) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17127572, /*  3732 (  88) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3198, /*  3733 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  3734 (  88) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34146642, /*  3735 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51021534, /*  3736 (  88) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17140530, /*  3737 (  88) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  3738 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127572, /*  3739 (  89) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51034656, /*  3740 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34133520, /*  3741 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  3742 (  89) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  3743 (  89) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34146806, /*  3744 (  89) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17140530, /*  3745 (  89) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  3746 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139632, /*  3747 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028544, /*  3748 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127572, /*  3749 (  90) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152918, /*  3750 (  90) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  3751 (  90) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015586, /*  3752 (  90) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140530, /*  3753 (  90) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  3754 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445720, /*  3755 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52556808, /*  3756 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35432762, /*  3757 (  91) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17127572, /*  3758 (  91) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52570094, /*  3759 (  91) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3760 (  91) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140530, /*  3761 (  91) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  3762 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  3763 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18426486, /*  3764 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
      134420, /*  3765 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  3766 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  3767 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557708, /*  3768 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18544746, /*  3769 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3770 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  3771 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015422, /*  3772 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  3773 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146644, /*  3774 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52569932, /*  3775 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18426486, /*  3776 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
      134420, /*  3777 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  3778 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  3779 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556970, /*  3780 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  3781 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  3782 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557708, /*  3783 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*  3784 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544746, /*  3785 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3786 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3787 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  3788 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
      134420, /*  3789 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52556970, /*  3790 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  3791 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  3792 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557708, /*  3793 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3794 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3795 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      121458, /*  3796 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52438710, /*  3797 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146644, /*  3798 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52569932, /*  3799 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18439772, /*  3800 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544746, /*  3801 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  3802 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  3803 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52569932, /*  3804 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18426486, /*  3805 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  3806 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556970, /*  3807 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  3808 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  3809 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  3810 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  3811 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34028546, /*  3812 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      121458, /*  3813 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015584, /*  3814 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426486, /*  3815 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
      134420, /*  3816 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133520, /*  3817 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  3818 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  3819 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18439772, /*  3820 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557708, /*  3821 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52438872, /*  3822 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18544746, /*  3823 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  3824 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556808, /*  3825 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  3826 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139794, /*  3827 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
      121458, /*  3828 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    35550858, /*  3829 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034820, /*  3830 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51152756, /*  3831 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18426486, /*  3832 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
      134420, /*  3833 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  3834 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  3835 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35445884, /*  3836 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  3837 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18439772, /*  3838 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557708, /*  3839 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18544746, /*  3840 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35563820, /*  3841 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  3842 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  3843 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1538472, /*  3844 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17140532, /*  3845 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3198, /*  3846 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  3847 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439610, /*  3848 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  3849 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3850 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  3851 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015422, /*  3852 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  3853 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51152756, /*  3854 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451834, /*  3855 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1538472, /*  3856 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17140532, /*  3857 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35563982, /*  3858 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  3859 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*  3860 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51139794, /*  3861 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1551758, /*  3862 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439610, /*  3863 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*  3864 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18426648, /*  3865 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3866 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3867 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  3868 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17140532, /*  3869 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52438872, /*  3870 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51139794, /*  3871 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1551758, /*  3872 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439610, /*  3873 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  3874 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3875 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127570, /*  3876 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35550696, /*  3877 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51152756, /*  3878 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451834, /*  3879 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1551758, /*  3880 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18426648, /*  3881 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  3882 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  3883 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451834, /*  3884 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1538472, /*  3885 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  3886 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*  3887 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51139794, /*  3888 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1551758, /*  3889 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3890 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  3891 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028546, /*  3892 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127570, /*  3893 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015584, /*  3894 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1538472, /*  3895 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17140532, /*  3896 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51139632, /*  3897 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3198, /*  3898 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152918, /*  3899 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1551758, /*  3900 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439610, /*  3901 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35550858, /*  3902 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18426648, /*  3903 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52451996, /*  3904 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438710, /*  3905 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  3906 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021696, /*  3907 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17127570, /*  3908 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52556970, /*  3909 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146806, /*  3910 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51034658, /*  3911 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1538472, /*  3912 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17140532, /*  3913 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3198, /*  3914 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  3915 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35445884, /*  3916 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  3917 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1551758, /*  3918 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439610, /*  3919 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  3920 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52569932, /*  3921 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  3922 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009472, /*  3923 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    18544584, /*  3924 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17022434, /*  3925 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3198, /*  3926 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  3927 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551596, /*  3928 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  3929 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3930 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009472, /*  3931 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34015422, /*  3932 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  3933 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51034658, /*  3934 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563820, /*  3935 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18544584, /*  3936 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17022434, /*  3937 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52570094, /*  3938 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  3939 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550858, /*  3940 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51021696, /*  3941 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18557870, /*  3942 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551596, /*  3943 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028708, /*  3944 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538634, /*  3945 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3946 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3947 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  3948 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17022434, /*  3949 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35550858, /*  3950 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51021696, /*  3951 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18557870, /*  3952 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551596, /*  3953 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  3954 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  3955 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009472, /*  3956 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52556808, /*  3957 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51034658, /*  3958 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563820, /*  3959 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18557870, /*  3960 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1538634, /*  3961 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  3962 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  3963 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35563820, /*  3964 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18544584, /*  3965 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  3966 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550858, /*  3967 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51021696, /*  3968 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18557870, /*  3969 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  3970 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  3971 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34028546, /*  3972 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17009472, /*  3973 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34015584, /*  3974 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544584, /*  3975 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17022434, /*  3976 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51021534, /*  3977 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  3978 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  3979 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  3980 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551596, /*  3981 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52556970, /*  3982 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1538634, /*  3983 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35563982, /*  3984 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35550696, /*  3985 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  3986 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133682, /*  3987 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17009472, /*  3988 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52438872, /*  3989 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152918, /*  3990 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146644, /*  3991 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18544584, /*  3992 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17022434, /*  3993 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3198, /*  3994 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139632, /*  3995 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445884, /*  3996 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  3997 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18557870, /*  3998 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551596, /*  3999 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  4000 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52451834, /*  4001 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  4002 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009472, /*  4003 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
     1538472, /*  4004 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17022434, /*  4005 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3198, /*  4006 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  4007 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557708, /*  4008 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18544746, /*  4009 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4010 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009472, /*  4011 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34015422, /*  4012 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  4013 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034658, /*  4014 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52569932, /*  4015 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1538472, /*  4016 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17022434, /*  4017 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35563982, /*  4018 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  4019 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556970, /*  4020 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51021696, /*  4021 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1551758, /*  4022 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557708, /*  4023 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*  4024 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544746, /*  4025 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4026 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4027 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  4028 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17022434, /*  4029 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52556970, /*  4030 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51021696, /*  4031 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1551758, /*  4032 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557708, /*  4033 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4034 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4035 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009472, /*  4036 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35550696, /*  4037 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034658, /*  4038 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52569932, /*  4039 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1551758, /*  4040 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18544746, /*  4041 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4042 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  4043 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52569932, /*  4044 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1538472, /*  4045 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  4046 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556970, /*  4047 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51021696, /*  4048 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1551758, /*  4049 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4050 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  4051 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028546, /*  4052 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17009472, /*  4053 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34015584, /*  4054 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1538472, /*  4055 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17022434, /*  4056 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51021534, /*  4057 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  4058 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  4059 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  4060 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557708, /*  4061 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35550858, /*  4062 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18544746, /*  4063 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  4064 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556808, /*  4065 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  4066 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139794, /*  4067 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17009472, /*  4068 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52438872, /*  4069 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146806, /*  4070 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152756, /*  4071 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1538472, /*  4072 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17022434, /*  4073 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3198, /*  4074 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  4075 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35445884, /*  4076 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  4077 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1551758, /*  4078 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557708, /*  4079 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18544746, /*  4080 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52451834, /*  4081 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  4082 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  4083 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    18426486, /*  4084 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17140532, /*  4085 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3198, /*  4086 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  4087 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1551596, /*  4088 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  4089 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  4090 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  4091 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015422, /*  4092 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  4093 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152756, /*  4094 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563820, /*  4095 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18426486, /*  4096 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17140532, /*  4097 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451996, /*  4098 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  4099 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550858, /*  4100 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51139794, /*  4101 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439772, /*  4102 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1551596, /*  4103 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028708, /*  4104 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538634, /*  4105 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  4106 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4107 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  4108 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140532, /*  4109 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35550858, /*  4110 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51139794, /*  4111 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439772, /*  4112 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1551596, /*  4113 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4114 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4115 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127570, /*  4116 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52438710, /*  4117 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152756, /*  4118 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563820, /*  4119 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18439772, /*  4120 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1538634, /*  4121 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  4122 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  4123 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563820, /*  4124 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18426486, /*  4125 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  4126 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550858, /*  4127 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51139794, /*  4128 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439772, /*  4129 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  4130 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  4131 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34028546, /*  4132 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127570, /*  4133 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34015584, /*  4134 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426486, /*  4135 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17140532, /*  4136 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51139632, /*  4137 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3198, /*  4138 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152918, /*  4139 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18439772, /*  4140 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1551596, /*  4141 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52438872, /*  4142 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1538634, /*  4143 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35563982, /*  4144 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35550696, /*  4145 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  4146 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133682, /*  4147 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17127570, /*  4148 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52556970, /*  4149 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51034820, /*  4150 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34146644, /*  4151 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18426486, /*  4152 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17140532, /*  4153 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3198, /*  4154 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  4155 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35445884, /*  4156 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  4157 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18439772, /*  4158 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1551596, /*  4159 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  4160 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52569932, /*  4161 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  4162 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  4163 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18544584, /*  4164 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
      134420, /*  4165 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  4166 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  4167 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439610, /*  4168 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  4169 (  92) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  4170 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  4171 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015422, /*  4172 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  4173 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146644, /*  4174 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52451834, /*  4175 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18544584, /*  4176 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
      134420, /*  4177 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52570094, /*  4178 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  4179 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*  4180 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34133682, /*  4181 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  4182 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439610, /*  4183 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*  4184 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18426648, /*  4185 (  93) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  4186 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4187 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  4188 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
      134420, /*  4189 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52438872, /*  4190 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34133682, /*  4191 (  94) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  4192 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439610, /*  4193 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  4194 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4195 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      121458, /*  4196 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52556808, /*  4197 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146644, /*  4198 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52451834, /*  4199 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18557870, /*  4200 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426648, /*  4201 (  95) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  4202 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  4203 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52451834, /*  4204 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18544584, /*  4205 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  4206 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*  4207 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34133682, /*  4208 (  96) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  4209 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4210 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  4211 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34028546, /*  4212 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      121458, /*  4213 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015584, /*  4214 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544584, /*  4215 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
      134420, /*  4216 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133520, /*  4217 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  4218 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  4219 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18557870, /*  4220 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439610, /*  4221 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52556970, /*  4222 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18426648, /*  4223 (  97) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52451996, /*  4224 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438710, /*  4225 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  4226 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021696, /*  4227 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
      121458, /*  4228 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    35550858, /*  4229 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51152918, /*  4230 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51034658, /*  4231 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18544584, /*  4232 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
      134420, /*  4233 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  4234 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139632, /*  4235 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445884, /*  4236 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432598, /*  4237 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18557870, /*  4238 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439610, /*  4239 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  4240 (  98) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35563820, /*  4241 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  4242 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  4243 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
     1538472, /*  4244 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17022594, /*  4245 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
        3198, /*  4246 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  4247 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557868, /*  4248 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18544586, /*  4249 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4250 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  4251 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015422, /*  4252 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  4253 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034818, /*  4254 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570092, /*  4255 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1538472, /*  4256 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17022594, /*  4257 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563982, /*  4258 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  4259 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556810, /*  4260 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  4261 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  4262 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557868, /*  4263 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34028708, /*  4264 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544586, /*  4265 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4266 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4267 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  4268 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17022594, /*  4269 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52556810, /*  4270 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  4271 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  4272 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557868, /*  4273 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4274 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4275 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009312, /*  4276 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35550696, /*  4277 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034818, /*  4278 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570092, /*  4279 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1551758, /*  4280 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18544586, /*  4281 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4282 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  4283 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570092, /*  4284 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1538472, /*  4285 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  4286 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556810, /*  4287 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  4288 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  4289 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4290 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  4291 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028706, /*  4292 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009312, /*  4293 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015424, /*  4294 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538472, /*  4295 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17022594, /*  4296 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51021534, /*  4297 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  4298 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  4299 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  4300 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557868, /*  4301 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35550698, /*  4302 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18544586, /*  4303 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  4304 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556808, /*  4305 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  4306 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438712, /*  4307 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17009312, /*  4308 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51139634, /*  4309 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35445884, /*  4310 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52451994, /*  4311 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1538472, /*  4312 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17022594, /*  4313 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
        3198, /*  4314 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  4315 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34146806, /*  4316 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  4317 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1551758, /*  4318 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18557868, /*  4319 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18544586, /*  4320 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51152916, /*  4321 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  4322 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  4323 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127408, /*  4324 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    18439770, /*  4325 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  4326 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  4327 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551756, /*  4328 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  4329 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4330 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  4331 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015422, /*  4332 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  4333 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52451994, /*  4334 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563980, /*  4335 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17127408, /*  4336 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    18439770, /*  4337 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51152918, /*  4338 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  4339 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550698, /*  4340 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438712, /*  4341 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140694, /*  4342 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551756, /*  4343 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34028708, /*  4344 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538474, /*  4345 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4346 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4347 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  4348 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439770, /*  4349 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35550698, /*  4350 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438712, /*  4351 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140694, /*  4352 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551756, /*  4353 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  4354 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4355 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426488, /*  4356 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51139632, /*  4357 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52451994, /*  4358 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563980, /*  4359 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17140694, /*  4360 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1538474, /*  4361 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4362 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  4363 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563980, /*  4364 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17127408, /*  4365 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  4366 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550698, /*  4367 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438712, /*  4368 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140694, /*  4369 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4370 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  4371 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028706, /*  4372 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426488, /*  4373 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015424, /*  4374 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127408, /*  4375 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    18439770, /*  4376 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52438710, /*  4377 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  4378 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*  4379 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140694, /*  4380 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551756, /*  4381 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51139634, /*  4382 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1538474, /*  4383 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563982, /*  4384 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35550696, /*  4385 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  4386 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432600, /*  4387 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18426488, /*  4388 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52556810, /*  4389 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51034820, /*  4390 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35445882, /*  4391 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17127408, /*  4392 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    18439770, /*  4393 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  4394 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  4395 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34146806, /*  4396 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  4397 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17140694, /*  4398 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551756, /*  4399 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  4400 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52570092, /*  4401 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  4402 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420376, /*  4403 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    18544584, /*  4404 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1433658, /*  4405 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3198, /*  4406 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  4407 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140692, /*  4408 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  4409 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4410 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420376, /*  4411 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015422, /*  4412 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  4413 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445882, /*  4414 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51152916, /*  4415 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18544584, /*  4416 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1433658, /*  4417 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52570094, /*  4418 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  4419 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139634, /*  4420 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35432600, /*  4421 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  4422 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140692, /*  4423 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34028708, /*  4424 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127410, /*  4425 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4426 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4427 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  4428 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1433658, /*  4429 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51139634, /*  4430 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35432600, /*  4431 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  4432 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140692, /*  4433 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  4434 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4435 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1420376, /*  4436 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52556808, /*  4437 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445882, /*  4438 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51152916, /*  4439 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18557870, /*  4440 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127410, /*  4441 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4442 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  4443 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51152916, /*  4444 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18544584, /*  4445 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  4446 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139634, /*  4447 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35432600, /*  4448 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  4449 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4450 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570092, /*  4451 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028706, /*  4452 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1420376, /*  4453 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015424, /*  4454 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544584, /*  4455 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1433658, /*  4456 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35432598, /*  4457 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  4458 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  4459 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  4460 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140692, /*  4461 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52556810, /*  4462 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17127410, /*  4463 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152918, /*  4464 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139632, /*  4465 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  4466 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021536, /*  4467 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1420376, /*  4468 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35550698, /*  4469 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52451996, /*  4470 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51034818, /*  4471 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18544584, /*  4472 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1433658, /*  4473 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3198, /*  4474 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438710, /*  4475 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146806, /*  4476 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  4477 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  4478 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140692, /*  4479 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  4480 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35563980, /*  4481 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  4482 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420376, /*  4483 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    17127408, /*  4484 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1433658, /*  4485 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3198, /*  4486 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  4487 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557868, /*  4488 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18544586, /*  4489 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4490 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420376, /*  4491 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015422, /*  4492 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  4493 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445882, /*  4494 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52570092, /*  4495 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17127408, /*  4496 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1433658, /*  4497 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152918, /*  4498 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  4499 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556810, /*  4500 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35432600, /*  4501 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*  4502 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557868, /*  4503 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34028708, /*  4504 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544586, /*  4505 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4506 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4507 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  4508 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1433658, /*  4509 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52556810, /*  4510 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35432600, /*  4511 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*  4512 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557868, /*  4513 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4514 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4515 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1420376, /*  4516 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51139632, /*  4517 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445882, /*  4518 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52570092, /*  4519 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17140694, /*  4520 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544586, /*  4521 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4522 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  4523 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52570092, /*  4524 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17127408, /*  4525 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  4526 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556810, /*  4527 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35432600, /*  4528 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*  4529 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4530 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  4531 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028706, /*  4532 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1420376, /*  4533 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015424, /*  4534 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127408, /*  4535 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1433658, /*  4536 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35432598, /*  4537 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  4538 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  4539 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*  4540 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557868, /*  4541 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51139634, /*  4542 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18544586, /*  4543 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  4544 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556808, /*  4545 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  4546 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438712, /*  4547 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1420376, /*  4548 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35550698, /*  4549 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51034820, /*  4550 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52451994, /*  4551 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17127408, /*  4552 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1433658, /*  4553 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3198, /*  4554 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021534, /*  4555 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34146806, /*  4556 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  4557 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17140694, /*  4558 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557868, /*  4559 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18544586, /*  4560 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35563980, /*  4561 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  4562 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  4563 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
     1538472, /*  4564 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    18439770, /*  4565 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  4566 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  4567 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140692, /*  4568 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  4569 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4570 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  4571 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015422, /*  4572 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  4573 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52451994, /*  4574 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152916, /*  4575 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1538472, /*  4576 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    18439770, /*  4577 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35563982, /*  4578 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3198, /*  4579 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139634, /*  4580 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52438712, /*  4581 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1551758, /*  4582 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140692, /*  4583 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34028708, /*  4584 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127410, /*  4585 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4586 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4587 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550696, /*  4588 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18439770, /*  4589 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51139634, /*  4590 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52438712, /*  4591 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1551758, /*  4592 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140692, /*  4593 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  4594 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4595 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426488, /*  4596 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35550696, /*  4597 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52451994, /*  4598 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152916, /*  4599 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1551758, /*  4600 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17127410, /*  4601 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4602 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  4603 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152916, /*  4604 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1538472, /*  4605 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3198, /*  4606 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139634, /*  4607 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52438712, /*  4608 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1551758, /*  4609 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4610 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  4611 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028706, /*  4612 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426488, /*  4613 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015424, /*  4614 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538472, /*  4615 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    18439770, /*  4616 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52438710, /*  4617 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3198, /*  4618 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*  4619 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1551758, /*  4620 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140692, /*  4621 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35550698, /*  4622 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17127410, /*  4623 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152918, /*  4624 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139632, /*  4625 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  4626 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021536, /*  4627 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18426488, /*  4628 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52556810, /*  4629 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35445884, /*  4630 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51034818, /*  4631 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1538472, /*  4632 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    18439770, /*  4633 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  4634 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  4635 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34146806, /*  4636 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  4637 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1551758, /*  4638 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    17140692, /*  4639 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  4640 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52570092, /*  4641 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  4642 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  4643 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    18544584, /*  4644 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17022594, /*  4645 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
        3198, /*  4646 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  4647 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551756, /*  4648 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  4649 (  92) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4650 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  4651 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015422, /*  4652 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  4653 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51034818, /*  4654 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35563980, /*  4655 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18544584, /*  4656 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17022594, /*  4657 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52570094, /*  4658 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  4659 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550698, /*  4660 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51021536, /*  4661 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  4662 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551756, /*  4663 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34028708, /*  4664 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1538474, /*  4665 (  93) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4666 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4667 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  4668 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17022594, /*  4669 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35550698, /*  4670 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51021536, /*  4671 (  94) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  4672 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551756, /*  4673 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  4674 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4675 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009312, /*  4676 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52556808, /*  4677 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51034818, /*  4678 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35563980, /*  4679 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18557870, /*  4680 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1538474, /*  4681 (  95) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  4682 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  4683 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35563980, /*  4684 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18544584, /*  4685 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  4686 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550698, /*  4687 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51021536, /*  4688 (  96) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  4689 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4690 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570092, /*  4691 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028706, /*  4692 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009312, /*  4693 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015424, /*  4694 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544584, /*  4695 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17022594, /*  4696 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51021534, /*  4697 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
        3198, /*  4698 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  4699 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18557870, /*  4700 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551756, /*  4701 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52556810, /*  4702 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1538474, /*  4703 (  97) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563982, /*  4704 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35550696, /*  4705 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  4706 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432600, /*  4707 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17009312, /*  4708 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51139634, /*  4709 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451996, /*  4710 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35445882, /*  4711 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18544584, /*  4712 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17022594, /*  4713 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
        3198, /*  4714 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438710, /*  4715 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146806, /*  4716 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133520, /*  4717 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  4718 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1551756, /*  4719 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  4720 (  98) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51152916, /*  4721 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  4722 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  4723 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17127408, /*  4724 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1420538, /*  4725 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
        3198, /*  4726 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  4727 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544748, /*  4728 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557706, /*  4729 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4730 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  4731 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34015422, /*  4732 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  4733 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35432762, /*  4734 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52556972, /*  4735 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17127408, /*  4736 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1420538, /*  4737 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51152918, /*  4738 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  4739 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52569930, /*  4740 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445720, /*  4741 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17140694, /*  4742 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544748, /*  4743 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*  4744 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18557706, /*  4745 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4746 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4747 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  4748 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1420538, /*  4749 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52569930, /*  4750 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445720, /*  4751 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17140694, /*  4752 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544748, /*  4753 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4754 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4755 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1433496, /*  4756 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51139632, /*  4757 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35432762, /*  4758 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52556972, /*  4759 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17140694, /*  4760 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557706, /*  4761 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4762 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  4763 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52556972, /*  4764 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17127408, /*  4765 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  4766 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52569930, /*  4767 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445720, /*  4768 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17140694, /*  4769 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4770 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  4771 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015586, /*  4772 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1433496, /*  4773 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34028544, /*  4774 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127408, /*  4775 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1420538, /*  4776 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35432598, /*  4777 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  4778 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  4779 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*  4780 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544748, /*  4781 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51152754, /*  4782 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18557706, /*  4783 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  4784 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556808, /*  4785 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  4786 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563818, /*  4787 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1433496, /*  4788 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52451832, /*  4789 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146806, /*  4790 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35550860, /*  4791 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17127408, /*  4792 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1420538, /*  4793 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
        3198, /*  4794 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  4795 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51034820, /*  4796 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  4797 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17140694, /*  4798 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18544748, /*  4799 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557706, /*  4800 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52438874, /*  4801 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  4802 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  4803 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    18426486, /*  4804 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
     1538636, /*  4805 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3198, /*  4806 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  4807 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127572, /*  4808 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140530, /*  4809 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  4810 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  4811 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34015422, /*  4812 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  4813 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35550860, /*  4814 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51139796, /*  4815 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18426486, /*  4816 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
     1538636, /*  4817 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52451996, /*  4818 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  4819 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152754, /*  4820 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35563818, /*  4821 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18439772, /*  4822 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127572, /*  4823 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028708, /*  4824 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140530, /*  4825 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  4826 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4827 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  4828 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1538636, /*  4829 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51152754, /*  4830 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35563818, /*  4831 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18439772, /*  4832 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127572, /*  4833 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  4834 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4835 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551594, /*  4836 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52438710, /*  4837 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35550860, /*  4838 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51139796, /*  4839 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18439772, /*  4840 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17140530, /*  4841 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  4842 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  4843 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51139796, /*  4844 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18426486, /*  4845 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  4846 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152754, /*  4847 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35563818, /*  4848 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18439772, /*  4849 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  4850 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  4851 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34015586, /*  4852 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551594, /*  4853 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34028544, /*  4854 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426486, /*  4855 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
     1538636, /*  4856 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550696, /*  4857 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
        3198, /*  4858 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563982, /*  4859 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18439772, /*  4860 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127572, /*  4861 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451832, /*  4862 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140530, /*  4863 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51152918, /*  4864 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139632, /*  4865 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  4866 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146642, /*  4867 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1551594, /*  4868 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52569930, /*  4869 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445884, /*  4870 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34133684, /*  4871 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18426486, /*  4872 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
     1538636, /*  4873 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3198, /*  4874 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  4875 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51034820, /*  4876 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  4877 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18439772, /*  4878 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17127572, /*  4879 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140530, /*  4880 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52556972, /*  4881 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  4882 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134418, /*  4883 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18544584, /*  4884 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
      121460, /*  4885 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  4886 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  4887 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426650, /*  4888 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439608, /*  4889 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  4890 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134418, /*  4891 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015422, /*  4892 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  4893 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133684, /*  4894 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438874, /*  4895 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18544584, /*  4896 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
      121460, /*  4897 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52570094, /*  4898 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  4899 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451832, /*  4900 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146642, /*  4901 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  4902 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426650, /*  4903 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*  4904 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18439608, /*  4905 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  4906 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4907 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  4908 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
      121460, /*  4909 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451832, /*  4910 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146642, /*  4911 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  4912 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426650, /*  4913 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  4914 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4915 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      134418, /*  4916 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52556808, /*  4917 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133684, /*  4918 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438874, /*  4919 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18557870, /*  4920 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439608, /*  4921 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  4922 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  4923 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438874, /*  4924 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18544584, /*  4925 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  4926 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451832, /*  4927 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146642, /*  4928 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557870, /*  4929 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4930 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556972, /*  4931 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015586, /*  4932 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      134418, /*  4933 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34028544, /*  4934 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544584, /*  4935 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
      121460, /*  4936 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133520, /*  4937 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  4938 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  4939 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18557870, /*  4940 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426650, /*  4941 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52569930, /*  4942 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    18439608, /*  4943 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52451996, /*  4944 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438710, /*  4945 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  4946 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445720, /*  4947 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
      134418, /*  4948 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    51152754, /*  4949 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35563982, /*  4950 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35432762, /*  4951 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18544584, /*  4952 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
      121460, /*  4953 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  4954 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550696, /*  4955 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034820, /*  4956 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  4957 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18557870, /*  4958 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18426650, /*  4959 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439608, /*  4960 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51139796, /*  4961 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  4962 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134418, /*  4963 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18426486, /*  4964 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
      121460, /*  4965 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  4966 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  4967 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544748, /*  4968 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557706, /*  4969 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4970 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134418, /*  4971 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015422, /*  4972 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  4973 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34133684, /*  4974 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556972, /*  4975 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18426486, /*  4976 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
      121460, /*  4977 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  4978 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3198, /*  4979 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52569930, /*  4980 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146642, /*  4981 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  4982 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544748, /*  4983 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34028708, /*  4984 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18557706, /*  4985 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  4986 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4987 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438710, /*  4988 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
      121460, /*  4989 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52569930, /*  4990 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146642, /*  4991 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  4992 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544748, /*  4993 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  4994 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  4995 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      134418, /*  4996 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52438710, /*  4997 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34133684, /*  4998 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556972, /*  4999 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18439772, /*  5000 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18557706, /*  5001 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  5002 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  5003 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556972, /*  5004 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18426486, /*  5005 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3198, /*  5006 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52569930, /*  5007 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146642, /*  5008 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  5009 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  5010 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  5011 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34015586, /*  5012 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      134418, /*  5013 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34028544, /*  5014 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426486, /*  5015 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
      121460, /*  5016 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133520, /*  5017 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3198, /*  5018 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  5019 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18439772, /*  5020 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544748, /*  5021 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52451832, /*  5022 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18557706, /*  5023 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  5024 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556808, /*  5025 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  5026 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563818, /*  5027 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
      134418, /*  5028 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    51152754, /*  5029 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445884, /*  5030 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35550860, /*  5031 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18426486, /*  5032 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
      121460, /*  5033 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3198, /*  5034 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432598, /*  5035 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51034820, /*  5036 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  5037 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18439772, /*  5038 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544748, /*  5039 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18557706, /*  5040 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51139796, /*  5041 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  5042 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  5043 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    17127408, /*  5044 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1538636, /*  5045 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3198, /*  5046 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140694, /*  5047 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18426650, /*  5048 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439608, /*  5049 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  5050 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  5051 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34015422, /*  5052 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  5053 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35550860, /*  5054 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438874, /*  5055 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17127408, /*  5056 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1538636, /*  5057 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51152918, /*  5058 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3198, /*  5059 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451832, /*  5060 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563818, /*  5061 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17140694, /*  5062 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18426650, /*  5063 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*  5064 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18439608, /*  5065 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  5066 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  5067 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139632, /*  5068 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1538636, /*  5069 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52451832, /*  5070 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563818, /*  5071 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17140694, /*  5072 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18426650, /*  5073 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  5074 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  5075 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551594, /*  5076 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51139632, /*  5077 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35550860, /*  5078 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438874, /*  5079 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140694, /*  5080 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18439608, /*  5081 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  5082 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  5083 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438874, /*  5084 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17127408, /*  5085 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3198, /*  5086 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451832, /*  5087 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563818, /*  5088 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17140694, /*  5089 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  5090 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  5091 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015586, /*  5092 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551594, /*  5093 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34028544, /*  5094 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17127408, /*  5095 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1538636, /*  5096 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550696, /*  5097 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
        3198, /*  5098 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563982, /*  5099 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17140694, /*  5100 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18426650, /*  5101 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51152754, /*  5102 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439608, /*  5103 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52451996, /*  5104 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438710, /*  5105 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  5106 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445720, /*  5107 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1551594, /*  5108 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52569930, /*  5109 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146806, /*  5110 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35432762, /*  5111 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17127408, /*  5112 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1538636, /*  5113 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3198, /*  5114 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133520, /*  5115 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51034820, /*  5116 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  5117 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17140694, /*  5118 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18426650, /*  5119 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439608, /*  5120 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52556972, /*  5121 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5122 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  5123 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    18544584, /*  5124 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1420538, /*  5125 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
        3198, /*  5126 (  92) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18557870, /*  5127 (  92) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127572, /*  5128 (  92) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140530, /*  5129 (  92) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  5130 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  5131 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34015422, /*  5132 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  5133 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35432762, /*  5134 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139796, /*  5135 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18544584, /*  5136 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1420538, /*  5137 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52570094, /*  5138 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3198, /*  5139 (  93) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152754, /*  5140 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445720, /*  5141 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18557870, /*  5142 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127572, /*  5143 (  93) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028708, /*  5144 (  93) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140530, /*  5145 (  93) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  5146 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  5147 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556808, /*  5148 (  94) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1420538, /*  5149 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51152754, /*  5150 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445720, /*  5151 (  94) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18557870, /*  5152 (  94) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127572, /*  5153 (  94) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  5154 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015422, /*  5155 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1433496, /*  5156 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52556808, /*  5157 (  95) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35432762, /*  5158 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139796, /*  5159 (  95) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18557870, /*  5160 (  95) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17140530, /*  5161 (  95) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  5162 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  5163 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139796, /*  5164 (  96) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18544584, /*  5165 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
        3198, /*  5166 (  96) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152754, /*  5167 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35445720, /*  5168 (  96) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18557870, /*  5169 (  96) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  5170 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556972, /*  5171 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015586, /*  5172 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1433496, /*  5173 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34028544, /*  5174 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544584, /*  5175 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1420538, /*  5176 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35432598, /*  5177 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3198, /*  5178 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  5179 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18557870, /*  5180 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127572, /*  5181 (  97) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52569930, /*  5182 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17140530, /*  5183 (  97) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51152918, /*  5184 (  97) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139632, /*  5185 (  97) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  5186 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146642, /*  5187 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1433496, /*  5188 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52451832, /*  5189 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563982, /*  5190 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34133684, /*  5191 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18544584, /*  5192 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1420538, /*  5193 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
        3198, /*  5194 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550696, /*  5195 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034820, /*  5196 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021534, /*  5197 (  98) [-1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18557870, /*  5198 (  98) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    17127572, /*  5199 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140530, /*  5200 (  98) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52438874, /*  5201 (  98) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  5202 (  99) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  5203 (  99) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16320, /*  5204 (  99) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3200, /*  5205 (  99) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  5206 ( 100) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  5207 ( 100) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  5208 ( 100) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015584, /*  5209 ( 100) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015424, /*  5210 ( 100) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3360, /*  5211 ( 100) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  5212 ( 100) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028544, /*  5213 ( 100) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  5214 ( 101) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  5215 ( 101) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3360, /*  5216 ( 101) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028544, /*  5217 ( 101) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  5218 ( 102) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  5219 ( 102) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  5220 ( 102) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*  5221 ( 102) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16320, /*  5222 ( 102) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034656, /*  5223 ( 102) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51021536, /*  5224 ( 102) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3360, /*  5225 ( 102) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  5226 ( 103) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438712, /*  5227 ( 103) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3200, /*  5228 ( 103) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  5229 ( 103) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*  5230 ( 103) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3360, /*  5231 ( 103) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*  5232 ( 103) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451832, /*  5233 ( 103) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  5234 ( 104) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  5235 ( 104) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3200, /*  5236 ( 104) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  5237 ( 104) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556970, /*  5238 ( 104) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52569930, /*  5239 ( 104) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3360, /*  5240 ( 104) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570094, /*  5241 ( 104) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5242 ( 105) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  5243 ( 105) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  5244 ( 105) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      121458, /*  5245 ( 105) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  5246 ( 106) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  5247 ( 106) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121458, /*  5248 ( 106) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16320, /*  5249 ( 106) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  5250 ( 106) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133682, /*  5251 ( 106) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34028708, /*  5252 ( 106) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028544, /*  5253 ( 106) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  5254 ( 107) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  5255 ( 107) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028544, /*  5256 ( 107) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34133682, /*  5257 ( 107) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  5258 ( 108) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  5259 ( 108) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133522, /*  5260 ( 108) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133682, /*  5261 ( 108) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  5262 ( 109) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139794, /*  5263 ( 109) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
      121458, /*  5264 ( 109) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    51034820, /*  5265 ( 109) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16320, /*  5266 ( 109) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034656, /*  5267 ( 109) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51139634, /*  5268 ( 109) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      121298, /*  5269 ( 109) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  5270 ( 110) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  5271 ( 110) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16320, /*  5272 ( 110) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015584, /*  5273 ( 110) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      121298, /*  5274 ( 110) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  5275 ( 110) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146642, /*  5276 ( 110) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34015424, /*  5277 ( 110) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  5278 ( 111) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  5279 ( 111) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16320, /*  5280 ( 111) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  5281 ( 111) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51152754, /*  5282 ( 111) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51021536, /*  5283 ( 111) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51152918, /*  5284 ( 111) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51021696, /*  5285 ( 111) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  5286 ( 112) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  5287 ( 112) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52556810, /*  5288 ( 112) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16320, /*  5289 ( 112) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  5290 ( 112) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  5291 ( 112) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52556970, /*  5292 ( 112) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52451832, /*  5293 ( 112) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  5294 ( 113) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  5295 ( 113) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16320, /*  5296 ( 113) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  5297 ( 113) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52569930, /*  5298 ( 113) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52438712, /*  5299 ( 113) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438872, /*  5300 ( 113) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52570094, /*  5301 ( 113) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5302 ( 105) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  5303 ( 105) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  5304 ( 105) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17009312, /*  5305 ( 105) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  5306 ( 106) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  5307 ( 106) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17009312, /*  5308 ( 106) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3360, /*  5309 ( 106) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  5310 ( 106) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51021536, /*  5311 ( 106) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34028708, /*  5312 ( 106) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015584, /*  5313 ( 106) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  5314 ( 107) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022432, /*  5315 ( 107) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34015584, /*  5316 ( 107) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51021536, /*  5317 ( 107) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  5318 ( 108) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  5319 ( 108) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034656, /*  5320 ( 108) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51021536, /*  5321 ( 108) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  5322 ( 109) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438712, /*  5323 ( 109) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17009312, /*  5324 ( 109) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35445884, /*  5325 ( 109) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
        3360, /*  5326 ( 109) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432760, /*  5327 ( 109) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52451832, /*  5328 ( 109) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17022432, /*  5329 ( 109) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  5330 ( 110) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  5331 ( 110) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3360, /*  5332 ( 110) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015424, /*  5333 ( 110) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17022432, /*  5334 ( 110) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034820, /*  5335 ( 110) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*  5336 ( 110) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34028544, /*  5337 ( 110) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  5338 ( 111) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  5339 ( 111) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3360, /*  5340 ( 111) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  5341 ( 111) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52438872, /*  5342 ( 111) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35445720, /*  5343 ( 111) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52451996, /*  5344 ( 111) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35432600, /*  5345 ( 111) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  5346 ( 112) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  5347 ( 112) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52569930, /*  5348 ( 112) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3360, /*  5349 ( 112) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  5350 ( 112) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563982, /*  5351 ( 112) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52556810, /*  5352 ( 112) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35550858, /*  5353 ( 112) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  5354 ( 113) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  5355 ( 113) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3360, /*  5356 ( 113) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  5357 ( 113) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52556970, /*  5358 ( 113) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35563818, /*  5359 ( 113) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35550698, /*  5360 ( 113) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52570094, /*  5361 ( 113) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5362 ( 105) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  5363 ( 105) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  5364 ( 105) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433496, /*  5365 ( 105) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  5366 ( 106) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  5367 ( 106) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1433496, /*  5368 ( 106) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3200, /*  5369 ( 106) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  5370 ( 106) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445720, /*  5371 ( 106) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34028708, /*  5372 ( 106) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015424, /*  5373 ( 106) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  5374 ( 107) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  5375 ( 107) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34015424, /*  5376 ( 107) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35445720, /*  5377 ( 107) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  5378 ( 108) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  5379 ( 108) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  5380 ( 108) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445720, /*  5381 ( 108) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  5382 ( 109) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563818, /*  5383 ( 109) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1433496, /*  5384 ( 109) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146806, /*  5385 ( 109) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3200, /*  5386 ( 109) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  5387 ( 109) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35550858, /*  5388 ( 109) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1420536, /*  5389 ( 109) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  5390 ( 110) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  5391 ( 110) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3200, /*  5392 ( 110) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  5393 ( 110) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1420536, /*  5394 ( 110) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445884, /*  5395 ( 110) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432600, /*  5396 ( 110) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34015584, /*  5397 ( 110) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  5398 ( 111) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  5399 ( 111) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3200, /*  5400 ( 111) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  5401 ( 111) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35550698, /*  5402 ( 111) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34133682, /*  5403 ( 111) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35563982, /*  5404 ( 111) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146642, /*  5405 ( 111) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  5406 ( 112) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  5407 ( 112) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52556970, /*  5408 ( 112) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3200, /*  5409 ( 112) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  5410 ( 112) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152918, /*  5411 ( 112) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52569930, /*  5412 ( 112) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51139634, /*  5413 ( 112) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  5414 ( 113) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  5415 ( 113) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3200, /*  5416 ( 113) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  5417 ( 113) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52556810, /*  5418 ( 113) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51139794, /*  5419 ( 113) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152754, /*  5420 ( 113) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52570094, /*  5421 ( 113) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5422 ( 114) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  5423 ( 114) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439608, /*  5424 ( 114) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5425 ( 114) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  5426 ( 115) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  5427 ( 115) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439608, /*  5428 ( 115) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5429 ( 115) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438872, /*  5430 ( 115) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34015424, /*  5431 ( 115) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028708, /*  5432 ( 115) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52451832, /*  5433 ( 115) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  5434 ( 116) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438872, /*  5435 ( 116) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451832, /*  5436 ( 116) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3200, /*  5437 ( 116) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  5438 ( 117) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  5439 ( 117) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52438872, /*  5440 ( 117) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18439608, /*  5441 ( 117) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  5442 ( 118) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  5443 ( 118) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439608, /*  5444 ( 118) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5445 ( 118) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  5446 ( 118) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35432600, /*  5447 ( 118) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*  5448 ( 118) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51021696, /*  5449 ( 118) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  5450 ( 119) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  5451 ( 119) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34133522, /*  5452 ( 119) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    18439608, /*  5453 ( 119) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5454 ( 119) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*  5455 ( 119) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556970, /*  5456 ( 119) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52569930, /*  5457 ( 119) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  5458 ( 120) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  5459 ( 120) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439608, /*  5460 ( 120) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5461 ( 120) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550858, /*  5462 ( 120) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51139634, /*  5463 ( 120) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51152918, /*  5464 ( 120) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563818, /*  5465 ( 120) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  5466 ( 121) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  5467 ( 121) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439608, /*  5468 ( 121) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5469 ( 121) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  5470 ( 121) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451996, /*  5471 ( 121) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438712, /*  5472 ( 121) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34028544, /*  5473 ( 121) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  5474 ( 122) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426648, /*  5475 ( 122) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52556810, /*  5476 ( 122) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18439608, /*  5477 ( 122) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5478 ( 122) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133682, /*  5479 ( 122) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146642, /*  5480 ( 122) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    52570094, /*  5481 ( 122) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5482 ( 114) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  5483 ( 114) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  5484 ( 114) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  5485 ( 114) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  5486 ( 115) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  5487 ( 115) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  5488 ( 115) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  5489 ( 115) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550698, /*  5490 ( 115) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028544, /*  5491 ( 115) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  5492 ( 115) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35550858, /*  5493 ( 115) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  5494 ( 116) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550698, /*  5495 ( 116) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35550858, /*  5496 ( 116) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16320, /*  5497 ( 116) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  5498 ( 117) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  5499 ( 117) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550698, /*  5500 ( 117) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538634, /*  5501 ( 117) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  5502 ( 118) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  5503 ( 118) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  5504 ( 118) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  5505 ( 118) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432760, /*  5506 ( 118) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34146642, /*  5507 ( 118) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*  5508 ( 118) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35432600, /*  5509 ( 118) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  5510 ( 119) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  5511 ( 119) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51034656, /*  5512 ( 119) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1538634, /*  5513 ( 119) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  5514 ( 119) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  5515 ( 119) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52556810, /*  5516 ( 119) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556970, /*  5517 ( 119) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  5518 ( 120) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  5519 ( 120) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  5520 ( 120) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  5521 ( 120) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139634, /*  5522 ( 120) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52451832, /*  5523 ( 120) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*  5524 ( 120) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51139794, /*  5525 ( 120) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  5526 ( 121) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  5527 ( 121) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  5528 ( 121) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  5529 ( 121) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015424, /*  5530 ( 121) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35563982, /*  5531 ( 121) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563818, /*  5532 ( 121) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34015584, /*  5533 ( 121) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  5534 ( 122) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538474, /*  5535 ( 122) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52569930, /*  5536 ( 122) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1538634, /*  5537 ( 122) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  5538 ( 122) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021536, /*  5539 ( 122) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*  5540 ( 122) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570094, /*  5541 ( 122) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5542 ( 114) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  5543 ( 114) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  5544 ( 114) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  5545 ( 114) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  5546 ( 115) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  5547 ( 115) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  5548 ( 115) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  5549 ( 115) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152754, /*  5550 ( 115) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34015584, /*  5551 ( 115) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  5552 ( 115) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51139634, /*  5553 ( 115) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  5554 ( 116) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152754, /*  5555 ( 116) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51139634, /*  5556 ( 116) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3360, /*  5557 ( 116) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  5558 ( 117) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  5559 ( 117) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51152754, /*  5560 ( 117) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127410, /*  5561 ( 117) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  5562 ( 118) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  5563 ( 118) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  5564 ( 118) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  5565 ( 118) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133522, /*  5566 ( 118) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51021696, /*  5567 ( 118) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034820, /*  5568 ( 118) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34146642, /*  5569 ( 118) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  5570 ( 119) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  5571 ( 119) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35432760, /*  5572 ( 119) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17127410, /*  5573 ( 119) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  5574 ( 119) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  5575 ( 119) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52569930, /*  5576 ( 119) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52556810, /*  5577 ( 119) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5578 ( 120) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  5579 ( 120) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  5580 ( 120) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  5581 ( 120) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451832, /*  5582 ( 120) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35550858, /*  5583 ( 120) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35563982, /*  5584 ( 120) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438712, /*  5585 ( 120) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  5586 ( 121) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  5587 ( 121) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  5588 ( 121) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  5589 ( 121) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028544, /*  5590 ( 121) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51152918, /*  5591 ( 121) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139794, /*  5592 ( 121) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34015424, /*  5593 ( 121) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  5594 ( 122) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140530, /*  5595 ( 122) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52556970, /*  5596 ( 122) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17127410, /*  5597 ( 122) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  5598 ( 122) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445720, /*  5599 ( 122) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35432600, /*  5600 ( 122) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52570094, /*  5601 ( 122) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5602 ( 123) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127410, /*  5603 ( 123) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18439608, /*  5604 ( 123) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
     1538634, /*  5605 ( 123) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  5606 ( 124) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*  5607 ( 124) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51139634, /*  5608 ( 124) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17127410, /*  5609 ( 124) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35550858, /*  5610 ( 124) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028708, /*  5611 ( 124) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52451832, /*  5612 ( 124) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1538634, /*  5613 ( 124) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  5614 ( 125) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550858, /*  5615 ( 125) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17127410, /*  5616 ( 125) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451832, /*  5617 ( 125) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  5618 ( 126) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*  5619 ( 126) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35432760, /*  5620 ( 126) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34146806, /*  5621 ( 126) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17127410, /*  5622 ( 126) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51021536, /*  5623 ( 126) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52569930, /*  5624 ( 126) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1538634, /*  5625 ( 126) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  5626 ( 127) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139794, /*  5627 ( 127) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439608, /*  5628 ( 127) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52451996, /*  5629 ( 127) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17127410, /*  5630 ( 127) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35550698, /*  5631 ( 127) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028544, /*  5632 ( 127) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1538634, /*  5633 ( 127) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  5634 ( 128) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*  5635 ( 128) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35432600, /*  5636 ( 128) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17127410, /*  5637 ( 128) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34146642, /*  5638 ( 128) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51021696, /*  5639 ( 128) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570094, /*  5640 ( 128) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1538634, /*  5641 ( 128) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  5642 ( 129) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  5643 ( 129) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18439608, /*  5644 ( 129) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16320, /*  5645 ( 129) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  5646 ( 129) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    18544586, /*  5647 ( 129) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    18439772, /*  5648 ( 129) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544746, /*  5649 ( 129) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  5650 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  5651 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121458, /*  5652 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18439608, /*  5653 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52556810, /*  5654 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16320, /*  5655 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121298, /*  5656 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    18544586, /*  5657 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52451996, /*  5658 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52556970, /*  5659 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  5660 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  5661 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028708, /*  5662 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544746, /*  5663 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34028544, /*  5664 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451832, /*  5665 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  5666 ( 131) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  5667 ( 131) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    18544586, /*  5668 ( 131) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556970, /*  5669 ( 131) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  5670 ( 131) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  5671 ( 131) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34028544, /*  5672 ( 131) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451832, /*  5673 ( 131) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  5674 ( 132) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  5675 ( 132) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556810, /*  5676 ( 132) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18439608, /*  5677 ( 132) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16320, /*  5678 ( 132) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556970, /*  5679 ( 132) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  5680 ( 132) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  5681 ( 132) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  5682 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  5683 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18439608, /*  5684 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16320, /*  5685 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015584, /*  5686 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      121298, /*  5687 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    18544586, /*  5688 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34146806, /*  5689 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146642, /*  5690 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  5691 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52438712, /*  5692 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438872, /*  5693 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18544746, /*  5694 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  5695 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015424, /*  5696 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52569930, /*  5697 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  5698 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139794, /*  5699 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
      121458, /*  5700 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18439608, /*  5701 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35550858, /*  5702 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51034820, /*  5703 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16320, /*  5704 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034656, /*  5705 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51139634, /*  5706 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      121298, /*  5707 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    18544586, /*  5708 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    35445720, /*  5709 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445884, /*  5710 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35550698, /*  5711 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18439772, /*  5712 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18544746, /*  5713 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  5714 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121458, /*  5715 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18439608, /*  5716 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16320, /*  5717 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432600, /*  5718 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432760, /*  5719 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35563982, /*  5720 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      121298, /*  5721 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    18544586, /*  5722 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51152754, /*  5723 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51021536, /*  5724 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439772, /*  5725 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51021696, /*  5726 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18544746, /*  5727 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35563818, /*  5728 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51152918, /*  5729 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  5730 ( 129) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  5731 ( 129) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
     1538634, /*  5732 ( 129) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3360, /*  5733 ( 129) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  5734 ( 129) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    18557706, /*  5735 ( 129) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
     1551758, /*  5736 ( 129) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18544586, /*  5737 ( 129) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  5738 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  5739 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17009312, /*  5740 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
     1538634, /*  5741 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52569930, /*  5742 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3360, /*  5743 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  5744 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    18557706, /*  5745 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35563982, /*  5746 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52556810, /*  5747 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  5748 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  5749 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34028708, /*  5750 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544586, /*  5751 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34015584, /*  5752 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550858, /*  5753 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  5754 ( 131) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022432, /*  5755 ( 131) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    18557706, /*  5756 ( 131) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52556810, /*  5757 ( 131) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  5758 ( 131) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  5759 ( 131) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34015584, /*  5760 ( 131) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550858, /*  5761 ( 131) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  5762 ( 132) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  5763 ( 132) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52569930, /*  5764 ( 132) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1538634, /*  5765 ( 132) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3360, /*  5766 ( 132) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556810, /*  5767 ( 132) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  5768 ( 132) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551758, /*  5769 ( 132) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  5770 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  5771 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
     1538634, /*  5772 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3360, /*  5773 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015424, /*  5774 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17022432, /*  5775 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    18557706, /*  5776 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51034820, /*  5777 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*  5778 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1551758, /*  5779 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563818, /*  5780 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35550698, /*  5781 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18544586, /*  5782 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52570094, /*  5783 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34028544, /*  5784 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556970, /*  5785 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  5786 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438712, /*  5787 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17009312, /*  5788 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
     1538634, /*  5789 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    51139634, /*  5790 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35445884, /*  5791 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
        3360, /*  5792 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432760, /*  5793 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52451832, /*  5794 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17022432, /*  5795 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    18557706, /*  5796 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34133682, /*  5797 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*  5798 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152754, /*  5799 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1551758, /*  5800 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18544586, /*  5801 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
       16484, /*  5802 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17009312, /*  5803 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
     1538634, /*  5804 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3360, /*  5805 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146642, /*  5806 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34133522, /*  5807 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152918, /*  5808 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17022432, /*  5809 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    18557706, /*  5810 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52438872, /*  5811 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35445720, /*  5812 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1551758, /*  5813 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35432600, /*  5814 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18544586, /*  5815 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    51139794, /*  5816 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52451996, /*  5817 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  5818 ( 129) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  5819 ( 129) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17127410, /*  5820 ( 129) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  5821 ( 129) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  5822 ( 129) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    18544746, /*  5823 ( 129) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    17140694, /*  5824 ( 129) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557706, /*  5825 ( 129) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  5826 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  5827 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1433496, /*  5828 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17127410, /*  5829 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52556970, /*  5830 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3200, /*  5831 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  5832 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    18544746, /*  5833 ( 130) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51152918, /*  5834 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52569930, /*  5835 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445720, /*  5836 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17140694, /*  5837 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028708, /*  5838 ( 130) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18557706, /*  5839 ( 130) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    34015424, /*  5840 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51139634, /*  5841 ( 130) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  5842 ( 131) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  5843 ( 131) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    18544746, /*  5844 ( 131) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52569930, /*  5845 ( 131) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445720, /*  5846 ( 131) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17140694, /*  5847 ( 131) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34015424, /*  5848 ( 131) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51139634, /*  5849 ( 131) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  5850 ( 132) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  5851 ( 132) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52556970, /*  5852 ( 132) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17127410, /*  5853 ( 132) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  5854 ( 132) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  5855 ( 132) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445720, /*  5856 ( 132) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17140694, /*  5857 ( 132) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  5858 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  5859 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17127410, /*  5860 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  5861 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  5862 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1420536, /*  5863 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    18544746, /*  5864 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35445884, /*  5865 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432600, /*  5866 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*  5867 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51139794, /*  5868 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152754, /*  5869 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18557706, /*  5870 ( 133) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  5871 ( 133) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34015584, /*  5872 ( 133) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52556810, /*  5873 ( 133) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  5874 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563818, /*  5875 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1433496, /*  5876 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17127410, /*  5877 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451832, /*  5878 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34146806, /*  5879 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3200, /*  5880 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  5881 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35550858, /*  5882 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1420536, /*  5883 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    18544746, /*  5884 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    51021536, /*  5885 ( 134) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*  5886 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52438872, /*  5887 ( 134) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140694, /*  5888 ( 134) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18557706, /*  5889 ( 134) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  5890 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433496, /*  5891 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17127410, /*  5892 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  5893 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021696, /*  5894 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034656, /*  5895 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52451996, /*  5896 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1420536, /*  5897 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    18544746, /*  5898 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    35550698, /*  5899 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34133682, /*  5900 ( 135) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17140694, /*  5901 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34146642, /*  5902 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18557706, /*  5903 ( 135) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52438712, /*  5904 ( 135) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35563982, /*  5905 ( 135) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  5906 ( 136) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  5907 ( 136) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  5908 ( 136) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439608, /*  5909 ( 136) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5910 ( 136) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  5911 ( 136) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439772, /*  5912 ( 136) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  5913 ( 136) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  5914 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  5915 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  5916 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52438712, /*  5917 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439608, /*  5918 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5919 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  5920 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015584, /*  5921 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451832, /*  5922 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52438872, /*  5923 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*  5924 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439772, /*  5925 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  5926 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  5927 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028544, /*  5928 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015424, /*  5929 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  5930 ( 138) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  5931 ( 138) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3200, /*  5932 ( 138) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  5933 ( 138) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439772, /*  5934 ( 138) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52438872, /*  5935 ( 138) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34028544, /*  5936 ( 138) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451832, /*  5937 ( 138) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  5938 ( 139) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*  5939 ( 139) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16320, /*  5940 ( 139) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015584, /*  5941 ( 139) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439772, /*  5942 ( 139) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52438712, /*  5943 ( 139) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438872, /*  5944 ( 139) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34015424, /*  5945 ( 139) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  5946 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  5947 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  5948 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34133522, /*  5949 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556810, /*  5950 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18439608, /*  5951 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5952 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  5953 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  5954 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556970, /*  5955 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  5956 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146642, /*  5957 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439772, /*  5958 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  5959 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570094, /*  5960 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52569930, /*  5961 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  5962 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  5963 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  5964 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    18439608, /*  5965 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5966 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  5967 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*  5968 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16320, /*  5969 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034656, /*  5970 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35432600, /*  5971 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432760, /*  5972 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445720, /*  5973 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445884, /*  5974 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51021536, /*  5975 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439772, /*  5976 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  5977 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  5978 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  5979 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  5980 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51139794, /*  5981 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439608, /*  5982 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
        3200, /*  5983 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550858, /*  5984 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16320, /*  5985 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139634, /*  5986 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563982, /*  5987 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51152754, /*  5988 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35550698, /*  5989 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18439772, /*  5990 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  5991 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563818, /*  5992 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51152918, /*  5993 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  5994 ( 136) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  5995 ( 136) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  5996 ( 136) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  5997 ( 136) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  5998 ( 136) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3360, /*  5999 ( 136) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551758, /*  6000 ( 136) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  6001 ( 136) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6002 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  6003 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  6004 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563818, /*  6005 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1538634, /*  6006 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  6007 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3360, /*  6008 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015424, /*  6009 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35550858, /*  6010 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35550698, /*  6011 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563982, /*  6012 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551758, /*  6013 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  6014 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028708, /*  6015 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015584, /*  6016 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028544, /*  6017 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6018 ( 138) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  6019 ( 138) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  6020 ( 138) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015424, /*  6021 ( 138) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551758, /*  6022 ( 138) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550698, /*  6023 ( 138) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34015584, /*  6024 ( 138) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35550858, /*  6025 ( 138) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  6026 ( 139) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538634, /*  6027 ( 139) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3360, /*  6028 ( 139) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015424, /*  6029 ( 139) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551758, /*  6030 ( 139) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563818, /*  6031 ( 139) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35550698, /*  6032 ( 139) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028544, /*  6033 ( 139) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6034 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  6035 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  6036 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51034656, /*  6037 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52569930, /*  6038 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1538634, /*  6039 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  6040 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3360, /*  6041 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  6042 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52556810, /*  6043 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  6044 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021696, /*  6045 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1551758, /*  6046 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  6047 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570094, /*  6048 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556970, /*  6049 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16484, /*  6050 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  6051 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  6052 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  6053 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  6054 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  6055 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432600, /*  6056 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
        3360, /*  6057 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432760, /*  6058 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34146642, /*  6059 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34133522, /*  6060 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133682, /*  6061 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146806, /*  6062 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35445720, /*  6063 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1551758, /*  6064 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  6065 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6066 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551594, /*  6067 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  6068 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52438712, /*  6069 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1538634, /*  6070 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16320, /*  6071 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139634, /*  6072 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3360, /*  6073 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451832, /*  6074 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152918, /*  6075 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52438872, /*  6076 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51152754, /*  6077 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1551758, /*  6078 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  6079 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139794, /*  6080 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52451996, /*  6081 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  6082 ( 136) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  6083 ( 136) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17140530, /*  6084 ( 136) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  6085 ( 136) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  6086 ( 136) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3200, /*  6087 ( 136) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  6088 ( 136) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  6089 ( 136) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6090 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  6091 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17140530, /*  6092 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51139794, /*  6093 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127410, /*  6094 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  6095 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3200, /*  6096 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  6097 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51139634, /*  6098 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51152754, /*  6099 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152918, /*  6100 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140694, /*  6101 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  6102 ( 137) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  6103 ( 137) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015424, /*  6104 ( 137) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015584, /*  6105 ( 137) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6106 ( 138) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  6107 ( 138) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
        3360, /*  6108 ( 138) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028544, /*  6109 ( 138) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17140694, /*  6110 ( 138) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152754, /*  6111 ( 138) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34015424, /*  6112 ( 138) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51139634, /*  6113 ( 138) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  6114 ( 139) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127410, /*  6115 ( 139) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  6116 ( 139) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  6117 ( 139) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17140694, /*  6118 ( 139) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51139794, /*  6119 ( 139) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152754, /*  6120 ( 139) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34015584, /*  6121 ( 139) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6122 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  6123 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17140530, /*  6124 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35432760, /*  6125 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52556970, /*  6126 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17127410, /*  6127 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  6128 ( 140) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3200, /*  6129 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  6130 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52569930, /*  6131 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35445720, /*  6132 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35432600, /*  6133 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140694, /*  6134 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  6135 ( 140) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570094, /*  6136 ( 140) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556810, /*  6137 ( 140) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  6138 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  6139 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17140530, /*  6140 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17127410, /*  6141 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  6142 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  6143 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146642, /*  6144 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3200, /*  6145 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  6146 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51021696, /*  6147 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034656, /*  6148 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51021536, /*  6149 ( 141) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034820, /*  6150 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34133682, /*  6151 ( 141) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17140694, /*  6152 ( 141) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  6153 ( 141) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6154 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127570, /*  6155 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17140530, /*  6156 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    35563818, /*  6157 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17127410, /*  6158 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3360, /*  6159 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451832, /*  6160 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3200, /*  6161 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550858, /*  6162 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52451996, /*  6163 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35550698, /*  6164 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438872, /*  6165 ( 142) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140694, /*  6166 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16320, /*  6167 ( 142) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438712, /*  6168 ( 142) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35563982, /*  6169 ( 142) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  6170 ( 143) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  6171 ( 143) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18426648, /*  6172 ( 143) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
     1551594, /*  6173 ( 143) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538474, /*  6174 ( 143) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  6175 ( 143) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  6176 ( 143) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    18439608, /*  6177 ( 143) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17127570, /*  6178 ( 143) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16320, /*  6179 ( 143) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17127410, /*  6180 ( 143) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551758, /*  6181 ( 143) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439772, /*  6182 ( 143) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  6183 ( 143) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140530, /*  6184 ( 143) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
     1538634, /*  6185 ( 143) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  6186 ( 144) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*  6187 ( 144) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17140694, /*  6188 ( 144) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17127570, /*  6189 ( 144) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16320, /*  6190 ( 144) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*  6191 ( 144) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51152754, /*  6192 ( 144) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127410, /*  6193 ( 144) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52438872, /*  6194 ( 144) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563818, /*  6195 ( 144) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1538474, /*  6196 ( 144) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34015584, /*  6197 ( 144) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439772, /*  6198 ( 144) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    34015424, /*  6199 ( 144) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028708, /*  6200 ( 144) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140530, /*  6201 ( 144) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52438712, /*  6202 ( 144) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18426648, /*  6203 ( 144) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
     1551594, /*  6204 ( 144) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35563982, /*  6205 ( 144) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51152918, /*  6206 ( 144) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3360, /*  6207 ( 144) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550858, /*  6208 ( 144) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028544, /*  6209 ( 144) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451832, /*  6210 ( 144) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18426488, /*  6211 ( 144) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51139794, /*  6212 ( 144) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3200, /*  6213 ( 144) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139634, /*  6214 ( 144) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1551758, /*  6215 ( 144) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550698, /*  6216 ( 144) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538634, /*  6217 ( 144) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  6218 ( 145) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426488, /*  6219 ( 145) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51139794, /*  6220 ( 145) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1538474, /*  6221 ( 145) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  6222 ( 145) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140694, /*  6223 ( 145) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35550858, /*  6224 ( 145) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34015584, /*  6225 ( 145) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51152754, /*  6226 ( 145) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17127410, /*  6227 ( 145) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1551758, /*  6228 ( 145) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    18439772, /*  6229 ( 145) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52438872, /*  6230 ( 145) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35563818, /*  6231 ( 145) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028544, /*  6232 ( 145) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451832, /*  6233 ( 145) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  6234 ( 146) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439608, /*  6235 ( 146) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17140694, /*  6236 ( 146) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17127570, /*  6237 ( 146) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16320, /*  6238 ( 146) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445720, /*  6239 ( 146) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52556970, /*  6240 ( 146) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17127410, /*  6241 ( 146) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51021696, /*  6242 ( 146) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52570094, /*  6243 ( 146) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1538474, /*  6244 ( 146) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51034820, /*  6245 ( 146) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34146806, /*  6246 ( 146) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133682, /*  6247 ( 146) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51021536, /*  6248 ( 146) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439772, /*  6249 ( 146) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    17140530, /*  6250 ( 146) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    18426648, /*  6251 ( 146) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
     1551594, /*  6252 ( 146) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    52556810, /*  6253 ( 146) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34133522, /*  6254 ( 146) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51034656, /*  6255 ( 146) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35432760, /*  6256 ( 146) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445884, /*  6257 ( 146) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34146642, /*  6258 ( 146) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    52569930, /*  6259 ( 146) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3360, /*  6260 ( 146) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18426488, /*  6261 ( 146) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3200, /*  6262 ( 146) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432600, /*  6263 ( 146) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1551758, /*  6264 ( 146) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538634, /*  6265 ( 146) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  6266 ( 147) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  6267 ( 147) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*  6268 ( 147) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  6269 ( 147) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18544586, /*  6270 ( 147) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3360, /*  6271 ( 147) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18544746, /*  6272 ( 147) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    18557706, /*  6273 ( 147) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  6274 ( 148) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  6275 ( 148) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556810, /*  6276 ( 148) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3200, /*  6277 ( 148) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  6278 ( 148) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015584, /*  6279 ( 148) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544586, /*  6280 ( 148) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556970, /*  6281 ( 148) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52569930, /*  6282 ( 148) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34015424, /*  6283 ( 148) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3360, /*  6284 ( 148) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34028708, /*  6285 ( 148) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18544746, /*  6286 ( 148) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52570094, /*  6287 ( 148) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34028544, /*  6288 ( 148) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18557706, /*  6289 ( 148) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  6290 ( 149) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  6291 ( 149) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
        3200, /*  6292 ( 149) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  6293 ( 149) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18544586, /*  6294 ( 149) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    52556970, /*  6295 ( 149) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52569930, /*  6296 ( 149) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028544, /*  6297 ( 149) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6298 ( 150) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  6299 ( 150) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34133522, /*  6300 ( 150) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52438712, /*  6301 ( 150) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3200, /*  6302 ( 150) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  6303 ( 150) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451996, /*  6304 ( 150) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18544586, /*  6305 ( 150) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
    34146806, /*  6306 ( 150) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133682, /*  6307 ( 150) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34146642, /*  6308 ( 150) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3360, /*  6309 ( 150) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52438872, /*  6310 ( 150) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18544746, /*  6311 ( 150) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
    52451832, /*  6312 ( 150) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18557706, /*  6313 ( 150) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6]  1 */
       16484, /*  6314 ( 151) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  6315 ( 151) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
      134418, /*  6316 ( 151) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18439608, /*  6317 ( 151) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17009472, /*  6318 ( 151) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
     1420376, /*  6319 ( 151) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    17127410, /*  6320 ( 151) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
     1538634, /*  6321 ( 151) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  6322 ( 152) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  6323 ( 152) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
      134418, /*  6324 ( 152) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18439608, /*  6325 ( 152) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17009472, /*  6326 ( 152) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35432600, /*  6327 ( 152) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51139634, /*  6328 ( 152) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1420376, /*  6329 ( 152) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    17127410, /*  6330 ( 152) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34146642, /*  6331 ( 152) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35550858, /*  6332 ( 152) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51021696, /*  6333 ( 152) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34028708, /*  6334 ( 152) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52570094, /*  6335 ( 152) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52451832, /*  6336 ( 152) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1538634, /*  6337 ( 152) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  6338 ( 153) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18557870, /*  6339 ( 153) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
     1420376, /*  6340 ( 153) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    17127410, /*  6341 ( 153) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34146642, /*  6342 ( 153) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35550858, /*  6343 ( 153) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51021696, /*  6344 ( 153) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52451832, /*  6345 ( 153) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  6346 ( 154) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139794, /*  6347 ( 154) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18557870, /*  6348 ( 154) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6]  1 */
      134418, /*  6349 ( 154) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    18439608, /*  6350 ( 154) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    17009472, /*  6351 ( 154) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35432760, /*  6352 ( 154) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52451996, /*  6353 ( 154) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51021536, /*  6354 ( 154) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1420376, /*  6355 ( 154) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34146806, /*  6356 ( 154) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17127410, /*  6357 ( 154) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35550698, /*  6358 ( 154) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52569930, /*  6359 ( 154) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34028544, /*  6360 ( 154) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1538634, /*  6361 ( 154) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  6362 ( 155) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6363 ( 155) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  6364 ( 155) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6365 ( 155) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6366 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  6367 ( 156) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028546, /*  6368 ( 156) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3200, /*  6369 ( 156) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6370 ( 156) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  6371 ( 156) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028708, /*  6372 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*  6373 ( 156) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6374 ( 157) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  6375 ( 157) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015586, /*  6376 ( 157) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*  6377 ( 157) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6378 ( 158) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  6379 ( 158) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015586, /*  6380 ( 158) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3200, /*  6381 ( 158) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6382 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  6383 ( 159) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3200, /*  6384 ( 159) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6385 ( 159) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  6386 ( 159) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146806, /*  6387 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133684, /*  6388 ( 159) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16322, /*  6389 ( 159) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6390 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  6391 ( 160) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6392 ( 160) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  6393 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021698, /*  6394 ( 160) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034658, /*  6395 ( 160) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021536, /*  6396 ( 160) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16322, /*  6397 ( 160) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6398 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  6399 ( 161) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3200, /*  6400 ( 161) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6401 ( 161) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  6402 ( 161) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52451996, /*  6403 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438712, /*  6404 ( 161) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16322, /*  6405 ( 161) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6406 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  6407 ( 162) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6408 ( 162) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  6409 ( 162) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563982, /*  6410 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35550698, /*  6411 ( 162) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563820, /*  6412 ( 162) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16322, /*  6413 ( 162) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6414 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  6415 ( 163) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3200, /*  6416 ( 163) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6417 ( 163) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  6418 ( 163) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52556972, /*  6419 ( 163) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52570094, /*  6420 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16322, /*  6421 ( 163) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6422 ( 155) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6423 ( 155) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  6424 ( 155) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16482, /*  6425 ( 155) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6426 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  6427 ( 156) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028706, /*  6428 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16320, /*  6429 ( 156) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  6430 ( 156) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  6431 ( 156) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  6432 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*  6433 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6434 ( 157) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  6435 ( 157) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028546, /*  6436 ( 157) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*  6437 ( 157) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6438 ( 158) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  6439 ( 158) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028546, /*  6440 ( 158) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16320, /*  6441 ( 158) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6442 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  6443 ( 159) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16320, /*  6444 ( 159) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  6445 ( 159) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  6446 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034820, /*  6447 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034658, /*  6448 ( 159) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16482, /*  6449 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6450 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  6451 ( 160) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  6452 ( 160) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  6453 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445722, /*  6454 ( 160) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445882, /*  6455 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35445720, /*  6456 ( 160) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16482, /*  6457 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6458 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  6459 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16320, /*  6460 ( 161) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  6461 ( 161) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  6462 ( 161) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563982, /*  6463 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563818, /*  6464 ( 161) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16482, /*  6465 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6466 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  6467 ( 162) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  6468 ( 162) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  6469 ( 162) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51152918, /*  6470 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51152754, /*  6471 ( 162) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152916, /*  6472 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16482, /*  6473 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6474 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  6475 ( 163) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16320, /*  6476 ( 163) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16322, /*  6477 ( 163) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52570092, /*  6478 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52569932, /*  6479 ( 163) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52570094, /*  6480 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16482, /*  6481 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6482 ( 155) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6483 ( 155) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3360, /*  6484 ( 155) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
        3362, /*  6485 ( 155) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6486 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  6487 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015586, /*  6488 ( 156) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3360, /*  6489 ( 156) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16482, /*  6490 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34015584, /*  6491 ( 156) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  6492 ( 156) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*  6493 ( 156) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6494 ( 157) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  6495 ( 157) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028706, /*  6496 ( 157) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3362, /*  6497 ( 157) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6498 ( 158) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  6499 ( 158) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028706, /*  6500 ( 158) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3360, /*  6501 ( 158) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  6502 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  6503 ( 159) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3360, /*  6504 ( 159) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16482, /*  6505 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432762, /*  6506 ( 159) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445884, /*  6507 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445882, /*  6508 ( 159) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3362, /*  6509 ( 159) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6510 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  6511 ( 160) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16482, /*  6512 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  6513 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146804, /*  6514 ( 160) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34133684, /*  6515 ( 160) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133682, /*  6516 ( 160) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3362, /*  6517 ( 160) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6518 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  6519 ( 161) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3360, /*  6520 ( 161) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16482, /*  6521 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152916, /*  6522 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51152918, /*  6523 ( 161) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139794, /*  6524 ( 161) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3362, /*  6525 ( 161) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6526 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  6527 ( 162) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16482, /*  6528 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  6529 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451996, /*  6530 ( 162) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52438872, /*  6531 ( 162) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52438874, /*  6532 ( 162) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3362, /*  6533 ( 162) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6534 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  6535 ( 163) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3360, /*  6536 ( 163) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16482, /*  6537 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556972, /*  6538 ( 163) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52570092, /*  6539 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52570094, /*  6540 ( 163) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3362, /*  6541 ( 163) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  6542 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6543 ( 164) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  6544 ( 164) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134420, /*  6545 ( 164) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  6546 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  6547 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34133522, /*  6548 ( 165) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3362, /*  6549 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  6550 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121298, /*  6551 ( 165) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134420, /*  6552 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028708, /*  6553 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6554 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*  6555 ( 166) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133522, /*  6556 ( 166) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34015586, /*  6557 ( 166) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6558 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6559 ( 167) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  6560 ( 167) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133522, /*  6561 ( 167) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  6562 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  6563 ( 168) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121298, /*  6564 ( 168) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34015586, /*  6565 ( 168) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6566 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  6567 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3362, /*  6568 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  6569 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021698, /*  6570 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51139634, /*  6571 ( 169) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      121298, /*  6572 ( 169) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134420, /*  6573 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  6574 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6575 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  6576 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      121298, /*  6577 ( 170) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445884, /*  6578 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35550698, /*  6579 ( 170) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      134420, /*  6580 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35563820, /*  6581 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  6582 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  6583 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3362, /*  6584 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  6585 ( 171) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  6586 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133684, /*  6587 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      134420, /*  6588 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34015424, /*  6589 ( 171) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6590 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6591 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  6592 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35432600, /*  6593 ( 172) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35563982, /*  6594 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      121298, /*  6595 ( 172) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445722, /*  6596 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      134420, /*  6597 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  6598 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6599 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  6600 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      121298, /*  6601 ( 173) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51139796, /*  6602 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51021536, /*  6603 ( 173) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      134420, /*  6604 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51152918, /*  6605 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  6606 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  6607 ( 174) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3362, /*  6608 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  6609 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52569932, /*  6610 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
      121298, /*  6611 ( 174) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  6612 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
      134420, /*  6613 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  6614 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  6615 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3362, /*  6616 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  6617 ( 175) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52556972, /*  6618 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
      134420, /*  6619 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52438712, /*  6620 ( 175) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52570094, /*  6621 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  6622 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6623 ( 164) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  6624 ( 164) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      121460, /*  6625 ( 164) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  6626 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  6627 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34133522, /*  6628 ( 165) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16322, /*  6629 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  6630 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121298, /*  6631 ( 165) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      121460, /*  6632 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028708, /*  6633 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6634 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  6635 ( 166) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133522, /*  6636 ( 166) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34028546, /*  6637 ( 166) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6638 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6639 ( 167) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  6640 ( 167) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133522, /*  6641 ( 167) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  6642 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  6643 ( 168) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121298, /*  6644 ( 168) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028546, /*  6645 ( 168) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6646 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  6647 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16322, /*  6648 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  6649 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445722, /*  6650 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35550698, /*  6651 ( 169) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      121298, /*  6652 ( 169) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      121460, /*  6653 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  6654 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6655 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  6656 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      121298, /*  6657 ( 170) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034820, /*  6658 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51139634, /*  6659 ( 170) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      121460, /*  6660 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51139796, /*  6661 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  6662 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  6663 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16322, /*  6664 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  6665 ( 171) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  6666 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146644, /*  6667 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121460, /*  6668 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34015424, /*  6669 ( 171) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6670 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6671 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  6672 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51021536, /*  6673 ( 172) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51152918, /*  6674 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      121298, /*  6675 ( 172) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51021698, /*  6676 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      121460, /*  6677 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  6678 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6679 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  6680 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      121298, /*  6681 ( 173) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35563820, /*  6682 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35432600, /*  6683 ( 173) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      121460, /*  6684 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35563982, /*  6685 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  6686 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  6687 ( 174) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16322, /*  6688 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  6689 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52556972, /*  6690 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
      121298, /*  6691 ( 174) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  6692 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
      121460, /*  6693 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  6694 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  6695 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16322, /*  6696 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  6697 ( 175) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52569932, /*  6698 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
      121460, /*  6699 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52438712, /*  6700 ( 175) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52570094, /*  6701 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  6702 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6703 ( 164) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022432, /*  6704 ( 164) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17022594, /*  6705 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  6706 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  6707 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51034656, /*  6708 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16322, /*  6709 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  6710 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17022432, /*  6711 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17022594, /*  6712 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34028708, /*  6713 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6714 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*  6715 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034656, /*  6716 ( 166) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34028546, /*  6717 ( 166) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6718 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6719 ( 167) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  6720 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034656, /*  6721 ( 167) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  6722 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  6723 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17022432, /*  6724 ( 168) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34028546, /*  6725 ( 168) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6726 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  6727 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16322, /*  6728 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  6729 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445722, /*  6730 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52451832, /*  6731 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17022432, /*  6732 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17022594, /*  6733 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  6734 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6735 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  6736 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17022432, /*  6737 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146806, /*  6738 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152754, /*  6739 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17022594, /*  6740 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51152916, /*  6741 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  6742 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  6743 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16322, /*  6744 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022432, /*  6745 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034820, /*  6746 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034658, /*  6747 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022594, /*  6748 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34028544, /*  6749 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6750 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6751 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  6752 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146642, /*  6753 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51152918, /*  6754 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17022432, /*  6755 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146804, /*  6756 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17022594, /*  6757 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  6758 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16322, /*  6759 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  6760 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022432, /*  6761 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52451834, /*  6762 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35445720, /*  6763 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022594, /*  6764 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52451996, /*  6765 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  6766 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  6767 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16322, /*  6768 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  6769 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52570092, /*  6770 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17022432, /*  6771 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563982, /*  6772 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17022594, /*  6773 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  6774 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  6775 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16322, /*  6776 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022432, /*  6777 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52569932, /*  6778 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17022594, /*  6779 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563818, /*  6780 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52570094, /*  6781 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  6782 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6783 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  6784 ( 164) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17022434, /*  6785 ( 164) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  6786 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  6787 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51034656, /*  6788 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16482, /*  6789 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034658, /*  6790 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022432, /*  6791 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17022434, /*  6792 ( 165) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34028708, /*  6793 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6794 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  6795 ( 166) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51034656, /*  6796 ( 166) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34028706, /*  6797 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6798 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6799 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034658, /*  6800 ( 167) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034656, /*  6801 ( 167) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  6802 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  6803 ( 168) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022432, /*  6804 ( 168) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34028706, /*  6805 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6806 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  6807 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16482, /*  6808 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  6809 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146804, /*  6810 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51152754, /*  6811 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17022432, /*  6812 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17022434, /*  6813 ( 169) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  6814 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6815 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445882, /*  6816 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022432, /*  6817 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35445884, /*  6818 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52451832, /*  6819 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17022434, /*  6820 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52451834, /*  6821 ( 170) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  6822 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  6823 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*  6824 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  6825 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034820, /*  6826 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51034818, /*  6827 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17022434, /*  6828 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34028544, /*  6829 ( 171) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6830 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6831 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  6832 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35445720, /*  6833 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52451996, /*  6834 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17022432, /*  6835 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35445722, /*  6836 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17022434, /*  6837 ( 172) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  6838 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6839 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146644, /*  6840 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17022432, /*  6841 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51152916, /*  6842 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34146642, /*  6843 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17022434, /*  6844 ( 173) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51152918, /*  6845 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  6846 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  6847 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16482, /*  6848 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563980, /*  6849 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52569932, /*  6850 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17022432, /*  6851 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563982, /*  6852 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17022434, /*  6853 ( 174) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  6854 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  6855 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16482, /*  6856 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022432, /*  6857 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52570092, /*  6858 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17022434, /*  6859 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35563818, /*  6860 ( 175) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52570094, /*  6861 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  6862 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6863 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1420536, /*  6864 ( 164) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1420538, /*  6865 ( 164) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  6866 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  6867 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35432760, /*  6868 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16482, /*  6869 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432762, /*  6870 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420536, /*  6871 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1420538, /*  6872 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34028708, /*  6873 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6874 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*  6875 ( 166) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35432760, /*  6876 ( 166) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34028706, /*  6877 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6878 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6879 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432762, /*  6880 ( 167) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432760, /*  6881 ( 167) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  6882 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  6883 ( 168) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420536, /*  6884 ( 168) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34028706, /*  6885 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6886 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  6887 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16482, /*  6888 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  6889 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34146804, /*  6890 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35550858, /*  6891 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1420536, /*  6892 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1420538, /*  6893 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  6894 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6895 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034818, /*  6896 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1420536, /*  6897 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51034820, /*  6898 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52438872, /*  6899 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1420538, /*  6900 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52438874, /*  6901 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  6902 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  6903 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16482, /*  6904 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1420536, /*  6905 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445884, /*  6906 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445882, /*  6907 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1420538, /*  6908 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015584, /*  6909 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6910 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6911 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  6912 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51021696, /*  6913 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52451996, /*  6914 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1420536, /*  6915 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51021698, /*  6916 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1420538, /*  6917 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  6918 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16482, /*  6919 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133684, /*  6920 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1420536, /*  6921 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35563980, /*  6922 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34133682, /*  6923 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1420538, /*  6924 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35563982, /*  6925 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  6926 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  6927 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16482, /*  6928 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152916, /*  6929 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52556972, /*  6930 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1420536, /*  6931 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152918, /*  6932 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1420538, /*  6933 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  6934 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  6935 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16482, /*  6936 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1420536, /*  6937 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52570092, /*  6938 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1420538, /*  6939 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51139794, /*  6940 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52570094, /*  6941 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  6942 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6943 ( 164) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  6944 ( 164) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433658, /*  6945 ( 164) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  6946 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  6947 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35432760, /*  6948 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3362, /*  6949 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  6950 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1420536, /*  6951 ( 165) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433658, /*  6952 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34028708, /*  6953 ( 165) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6954 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  6955 ( 166) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35432760, /*  6956 ( 166) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34015586, /*  6957 ( 166) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6958 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6959 ( 167) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  6960 ( 167) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35432760, /*  6961 ( 167) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  6962 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445882, /*  6963 ( 168) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1420536, /*  6964 ( 168) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34015586, /*  6965 ( 168) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  6966 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  6967 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
        3362, /*  6968 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  6969 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51021698, /*  6970 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52438872, /*  6971 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1420536, /*  6972 ( 169) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433658, /*  6973 ( 169) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  6974 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6975 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  6976 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1420536, /*  6977 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146806, /*  6978 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35550858, /*  6979 ( 170) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1433658, /*  6980 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35563980, /*  6981 ( 170) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  6982 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  6983 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3362, /*  6984 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  6985 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445884, /*  6986 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35432762, /*  6987 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1433658, /*  6988 ( 171) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34015584, /*  6989 ( 171) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  6990 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6991 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  6992 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34133682, /*  6993 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35563982, /*  6994 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1420536, /*  6995 ( 172) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146804, /*  6996 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1433658, /*  6997 ( 172) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  6998 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3362, /*  6999 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  7000 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1420536, /*  7001 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52438874, /*  7002 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51021696, /*  7003 ( 173) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1433658, /*  7004 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52451996, /*  7005 ( 173) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  7006 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  7007 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3362, /*  7008 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  7009 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52570092, /*  7010 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1420536, /*  7011 ( 174) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152918, /*  7012 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1433658, /*  7013 ( 174) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  7014 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  7015 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3362, /*  7016 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  7017 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52556972, /*  7018 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1433658, /*  7019 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51139794, /*  7020 ( 175) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52570094, /*  7021 ( 175) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  7022 ( 176) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*  7023 ( 176) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      121460, /*  7024 ( 176) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3200, /*  7025 ( 176) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  7026 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  7027 ( 177) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3200, /*  7028 ( 177) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  7029 ( 177) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133684, /*  7030 ( 177) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      134420, /*  7031 ( 177) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34028708, /*  7032 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015424, /*  7033 ( 177) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  7034 ( 178) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  7035 ( 178) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
      121460, /*  7036 ( 178) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146644, /*  7037 ( 178) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  7038 ( 179) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  7039 ( 179) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34133684, /*  7040 ( 179) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3200, /*  7041 ( 179) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  7042 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  7043 ( 180) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133522, /*  7044 ( 180) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34015586, /*  7045 ( 180) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028546, /*  7046 ( 180) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3200, /*  7047 ( 180) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*  7048 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      134420, /*  7049 ( 180) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  7050 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  7051 ( 181) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3200, /*  7052 ( 181) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  7053 ( 181) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51034820, /*  7054 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51139796, /*  7055 ( 181) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51021536, /*  7056 ( 181) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      134420, /*  7057 ( 181) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  7058 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  7059 ( 182) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3200, /*  7060 ( 182) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  7061 ( 182) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52451996, /*  7062 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52556972, /*  7063 ( 182) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
      134420, /*  7064 ( 182) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52438712, /*  7065 ( 182) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  7066 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  7067 ( 183) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
        3200, /*  7068 ( 183) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  7069 ( 183) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35563982, /*  7070 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35445722, /*  7071 ( 183) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35550698, /*  7072 ( 183) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      134420, /*  7073 ( 183) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  7074 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  7075 ( 184) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
      121460, /*  7076 ( 184) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52556810, /*  7077 ( 184) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3200, /*  7078 ( 184) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  7079 ( 184) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
      134420, /*  7080 ( 184) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52570094, /*  7081 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  7082 ( 176) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*  7083 ( 176) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17022434, /*  7084 ( 176) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16320, /*  7085 ( 176) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  7086 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  7087 ( 177) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16320, /*  7088 ( 177) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034818, /*  7089 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034658, /*  7090 ( 177) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022594, /*  7091 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34028708, /*  7092 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028544, /*  7093 ( 177) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  7094 ( 178) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  7095 ( 178) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17022434, /*  7096 ( 178) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51034818, /*  7097 ( 178) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  7098 ( 179) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034818, /*  7099 ( 179) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51034658, /*  7100 ( 179) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16320, /*  7101 ( 179) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  7102 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  7103 ( 180) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51034656, /*  7104 ( 180) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34028546, /*  7105 ( 180) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028706, /*  7106 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16320, /*  7107 ( 180) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  7108 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022594, /*  7109 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  7110 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  7111 ( 181) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16320, /*  7112 ( 181) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  7113 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35445884, /*  7114 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52451834, /*  7115 ( 181) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35445720, /*  7116 ( 181) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022594, /*  7117 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  7118 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  7119 ( 182) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16320, /*  7120 ( 182) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570092, /*  7121 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35563982, /*  7122 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52569932, /*  7123 ( 182) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17022594, /*  7124 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563818, /*  7125 ( 182) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  7126 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  7127 ( 183) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16320, /*  7128 ( 183) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146644, /*  7129 ( 183) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152918, /*  7130 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146804, /*  7131 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51152754, /*  7132 ( 183) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17022594, /*  7133 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  7134 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  7135 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    17022434, /*  7136 ( 184) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52569930, /*  7137 ( 184) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16320, /*  7138 ( 184) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563820, /*  7139 ( 184) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17022594, /*  7140 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52570094, /*  7141 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  7142 ( 176) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*  7143 ( 176) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
     1433658, /*  7144 ( 176) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3360, /*  7145 ( 176) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  7146 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  7147 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3360, /*  7148 ( 177) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432762, /*  7149 ( 177) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445882, /*  7150 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1420538, /*  7151 ( 177) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34028708, /*  7152 ( 177) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34015584, /*  7153 ( 177) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  7154 ( 178) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  7155 ( 178) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1433658, /*  7156 ( 178) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35432762, /*  7157 ( 178) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  7158 ( 179) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  7159 ( 179) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35445882, /*  7160 ( 179) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3360, /*  7161 ( 179) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  7162 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  7163 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35432760, /*  7164 ( 180) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34028706, /*  7165 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34015586, /*  7166 ( 180) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3360, /*  7167 ( 180) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  7168 ( 180) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420538, /*  7169 ( 180) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  7170 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  7171 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3360, /*  7172 ( 181) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550860, /*  7173 ( 181) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146806, /*  7174 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35563980, /*  7175 ( 181) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34133682, /*  7176 ( 181) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1420538, /*  7177 ( 181) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  7178 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  7179 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3360, /*  7180 ( 182) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556972, /*  7181 ( 182) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51152918, /*  7182 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52570092, /*  7183 ( 182) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1420538, /*  7184 ( 182) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51139794, /*  7185 ( 182) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  7186 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  7187 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
        3360, /*  7188 ( 183) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034818, /*  7189 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52451996, /*  7190 ( 183) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51021698, /*  7191 ( 183) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52438872, /*  7192 ( 183) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1420538, /*  7193 ( 183) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  7194 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  7195 ( 184) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1433658, /*  7196 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52556970, /*  7197 ( 184) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3360, /*  7198 ( 184) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152916, /*  7199 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
     1420538, /*  7200 ( 184) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52570094, /*  7201 ( 184) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
       16484, /*  7202 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  7203 ( 185) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    17009474, /*  7204 ( 185) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3200, /*  7205 ( 185) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  7206 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  7207 ( 186) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021698, /*  7208 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022434, /*  7209 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    17009474, /*  7210 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015424, /*  7211 ( 186) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028708, /*  7212 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51034658, /*  7213 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  7214 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  7215 ( 187) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17022434, /*  7216 ( 187) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51021698, /*  7217 ( 187) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  7218 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  7219 ( 188) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17009474, /*  7220 ( 188) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51034658, /*  7221 ( 188) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  7222 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021698, /*  7223 ( 189) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3200, /*  7224 ( 189) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034658, /*  7225 ( 189) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  7226 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  7227 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3200, /*  7228 ( 190) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  7229 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022434, /*  7230 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    17009474, /*  7231 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51021536, /*  7232 ( 190) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34028546, /*  7233 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  7234 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  7235 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3200, /*  7236 ( 191) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  7237 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35432600, /*  7238 ( 191) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17022434, /*  7239 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35445884, /*  7240 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17009474, /*  7241 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  7242 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  7243 ( 192) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3200, /*  7244 ( 192) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  7245 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17022434, /*  7246 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51139796, /*  7247 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146806, /*  7248 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17009474, /*  7249 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  7250 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  7251 ( 193) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569932, /*  7252 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17022434, /*  7253 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35563982, /*  7254 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52556972, /*  7255 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17009474, /*  7256 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35550698, /*  7257 ( 193) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  7258 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  7259 ( 194) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  7260 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17022434, /*  7261 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51139634, /*  7262 ( 194) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34133684, /*  7263 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17009474, /*  7264 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51152918, /*  7265 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  7266 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  7267 ( 195) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  7268 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35432762, /*  7269 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52451996, /*  7270 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35445722, /*  7271 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17009474, /*  7272 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52438712, /*  7273 ( 195) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  7274 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  7275 ( 196) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3200, /*  7276 ( 196) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  7277 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17022434, /*  7278 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    17009474, /*  7279 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52570094, /*  7280 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35563820, /*  7281 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  7282 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*  7283 ( 185) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
     1433498, /*  7284 ( 185) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
        3200, /*  7285 ( 185) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  7286 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  7287 ( 186) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445722, /*  7288 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420538, /*  7289 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
     1433498, /*  7290 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34015424, /*  7291 ( 186) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028708, /*  7292 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35432762, /*  7293 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  7294 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  7295 ( 187) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1420538, /*  7296 ( 187) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35445722, /*  7297 ( 187) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  7298 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  7299 ( 188) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1433498, /*  7300 ( 188) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35432762, /*  7301 ( 188) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  7302 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445722, /*  7303 ( 189) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
        3200, /*  7304 ( 189) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432762, /*  7305 ( 189) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  7306 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  7307 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3200, /*  7308 ( 190) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  7309 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420538, /*  7310 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
     1433498, /*  7311 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35432600, /*  7312 ( 190) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34015586, /*  7313 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  7314 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  7315 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3200, /*  7316 ( 191) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  7317 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51021536, /*  7318 ( 191) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1420538, /*  7319 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51034820, /*  7320 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1433498, /*  7321 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  7322 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  7323 ( 192) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3200, /*  7324 ( 192) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  7325 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1420538, /*  7326 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35563820, /*  7327 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146806, /*  7328 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1433498, /*  7329 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  7330 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  7331 ( 193) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556972, /*  7332 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1420538, /*  7333 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51152918, /*  7334 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52569932, /*  7335 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1433498, /*  7336 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51139634, /*  7337 ( 193) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  7338 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  7339 ( 194) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  7340 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1420538, /*  7341 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35550698, /*  7342 ( 194) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146644, /*  7343 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1433498, /*  7344 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35563982, /*  7345 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  7346 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  7347 ( 195) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*  7348 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51034658, /*  7349 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52451996, /*  7350 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51021698, /*  7351 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1433498, /*  7352 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52438712, /*  7353 ( 195) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  7354 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  7355 ( 196) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3200, /*  7356 ( 196) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  7357 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1420538, /*  7358 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
     1433498, /*  7359 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52570094, /*  7360 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51139796, /*  7361 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  7362 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  7363 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433498, /*  7364 ( 185) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16320, /*  7365 ( 185) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  7366 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  7367 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  7368 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1433658, /*  7369 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433498, /*  7370 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    34028544, /*  7371 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  7372 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35445882, /*  7373 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  7374 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  7375 ( 187) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1433658, /*  7376 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445722, /*  7377 ( 187) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  7378 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  7379 ( 188) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1433498, /*  7380 ( 188) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35445882, /*  7381 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  7382 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445722, /*  7383 ( 189) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16320, /*  7384 ( 189) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445882, /*  7385 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  7386 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  7387 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16320, /*  7388 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  7389 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1433658, /*  7390 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433498, /*  7391 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35445720, /*  7392 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34028706, /*  7393 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  7394 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  7395 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16320, /*  7396 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563820, /*  7397 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146642, /*  7398 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1433658, /*  7399 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146806, /*  7400 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1433498, /*  7401 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  7402 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  7403 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16320, /*  7404 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  7405 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1433658, /*  7406 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52451834, /*  7407 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51034820, /*  7408 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1433498, /*  7409 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  7410 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  7411 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570092, /*  7412 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1433658, /*  7413 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152918, /*  7414 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52569932, /*  7415 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1433498, /*  7416 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51152754, /*  7417 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  7418 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  7419 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034818, /*  7420 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1433658, /*  7421 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52451832, /*  7422 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51034658, /*  7423 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1433498, /*  7424 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52451996, /*  7425 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  7426 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  7427 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1433658, /*  7428 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146644, /*  7429 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35563982, /*  7430 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146804, /*  7431 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1433498, /*  7432 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35563818, /*  7433 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  7434 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  7435 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16320, /*  7436 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152756, /*  7437 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1433658, /*  7438 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1433498, /*  7439 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    52570094, /*  7440 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51152916, /*  7441 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  7442 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*  7443 ( 185) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  7444 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16320, /*  7445 ( 185) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  7446 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  7447 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  7448 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
      134420, /*  7449 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  7450 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34028544, /*  7451 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  7452 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34146644, /*  7453 ( 186) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  7454 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  7455 ( 187) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      134420, /*  7456 ( 187) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146804, /*  7457 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  7458 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  7459 ( 188) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      134580, /*  7460 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34146644, /*  7461 ( 188) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  7462 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146804, /*  7463 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16320, /*  7464 ( 189) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146644, /*  7465 ( 189) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  7466 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  7467 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16320, /*  7468 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  7469 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      134420, /*  7470 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  7471 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34146642, /*  7472 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34028546, /*  7473 ( 190) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  7474 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  7475 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16320, /*  7476 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563980, /*  7477 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35445720, /*  7478 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
      134420, /*  7479 ( 191) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445884, /*  7480 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      134580, /*  7481 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  7482 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  7483 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16320, /*  7484 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152756, /*  7485 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      134420, /*  7486 ( 192) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51152916, /*  7487 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51034820, /*  7488 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      134580, /*  7489 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  7490 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  7491 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52569932, /*  7492 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
      134420, /*  7493 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  7494 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52570092, /*  7495 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
      134580, /*  7496 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52451832, /*  7497 ( 193) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  7498 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  7499 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034658, /*  7500 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      134420, /*  7501 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51152754, /*  7502 ( 194) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51034818, /*  7503 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
      134580, /*  7504 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    51152918, /*  7505 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  7506 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  7507 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      134420, /*  7508 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445882, /*  7509 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    35563982, /*  7510 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35445722, /*  7511 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      134580, /*  7512 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    35563818, /*  7513 ( 195) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  7514 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  7515 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16320, /*  7516 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  7517 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
      134420, /*  7518 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  7519 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52570094, /*  7520 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52451834, /*  7521 ( 196) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  7522 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  7523 ( 185) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  7524 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
        3360, /*  7525 ( 185) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  7526 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  7527 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  7528 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
      121460, /*  7529 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  7530 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34015584, /*  7531 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  7532 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34133684, /*  7533 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  7534 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  7535 ( 187) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      121460, /*  7536 ( 187) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146804, /*  7537 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  7538 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  7539 ( 188) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
      134580, /*  7540 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34133684, /*  7541 ( 188) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  7542 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146804, /*  7543 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
        3360, /*  7544 ( 189) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34133684, /*  7545 ( 189) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  7546 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  7547 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3360, /*  7548 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  7549 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121460, /*  7550 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  7551 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    34133682, /*  7552 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    34015586, /*  7553 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  7554 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  7555 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3360, /*  7556 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152916, /*  7557 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51021696, /*  7558 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
      121460, /*  7559 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034820, /*  7560 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      134580, /*  7561 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  7562 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  7563 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3360, /*  7564 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550860, /*  7565 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      121460, /*  7566 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35563980, /*  7567 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35445884, /*  7568 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      134580, /*  7569 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
       16484, /*  7570 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  7571 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52556972, /*  7572 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
      121460, /*  7573 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  7574 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52570092, /*  7575 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
      134580, /*  7576 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52438872, /*  7577 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  7578 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  7579 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432762, /*  7580 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      121460, /*  7581 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35550858, /*  7582 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35445882, /*  7583 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
      134580, /*  7584 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    35563982, /*  7585 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  7586 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  7587 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
      121460, /*  7588 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034818, /*  7589 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    51152918, /*  7590 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51021698, /*  7591 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      134580, /*  7592 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    51139794, /*  7593 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  7594 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  7595 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3360, /*  7596 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  7597 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
      121460, /*  7598 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
      134580, /*  7599 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6]  1 */
    52570094, /*  7600 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52438874, /*  7601 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  7602 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*  7603 ( 185) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17009474, /*  7604 ( 185) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
        3360, /*  7605 ( 185) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  7606 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  7607 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51021698, /*  7608 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022594, /*  7609 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17009474, /*  7610 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    34015584, /*  7611 ( 186) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  7612 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51034818, /*  7613 ( 186) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  7614 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  7615 ( 187) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17022594, /*  7616 ( 187) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51021698, /*  7617 ( 187) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  7618 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  7619 ( 188) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17009474, /*  7620 ( 188) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51034818, /*  7621 ( 188) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  7622 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021698, /*  7623 ( 189) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
        3360, /*  7624 ( 189) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034818, /*  7625 ( 189) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  7626 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  7627 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3360, /*  7628 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  7629 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022594, /*  7630 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17009474, /*  7631 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51021696, /*  7632 ( 190) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34028706, /*  7633 ( 190) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  7634 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  7635 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
        3360, /*  7636 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51139796, /*  7637 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34133682, /*  7638 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17022594, /*  7639 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146806, /*  7640 ( 191) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17009474, /*  7641 ( 191) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  7642 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  7643 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3360, /*  7644 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  7645 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17022594, /*  7646 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52438874, /*  7647 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35445884, /*  7648 ( 192) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17009474, /*  7649 ( 192) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  7650 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  7651 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52570092, /*  7652 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17022594, /*  7653 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563982, /*  7654 ( 193) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52556972, /*  7655 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17009474, /*  7656 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35550858, /*  7657 ( 193) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  7658 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  7659 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445882, /*  7660 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022594, /*  7661 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52438872, /*  7662 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35432762, /*  7663 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17009474, /*  7664 ( 194) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52451996, /*  7665 ( 194) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  7666 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  7667 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17022594, /*  7668 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34133684, /*  7669 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51152918, /*  7670 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146804, /*  7671 ( 195) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17009474, /*  7672 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51139794, /*  7673 ( 195) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  7674 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  7675 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3360, /*  7676 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550860, /*  7677 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17022594, /*  7678 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17009474, /*  7679 ( 196) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    52570094, /*  7680 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35563980, /*  7681 ( 196) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  7682 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  7683 ( 197) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    17022434, /*  7684 ( 197) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    17127572, /*  7685 ( 197) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7686 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  7687 ( 198) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51034658, /*  7688 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022434, /*  7689 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
      121298, /*  7690 ( 198) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51139796, /*  7691 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34028708, /*  7692 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127572, /*  7693 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7694 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  7695 ( 199) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34133522, /*  7696 ( 199) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17022434, /*  7697 ( 199) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
       16484, /*  7698 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  7699 ( 200) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51034658, /*  7700 ( 200) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17127572, /*  7701 ( 200) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7702 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  7703 ( 201) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      121298, /*  7704 ( 201) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034658, /*  7705 ( 201) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  7706 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  7707 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022434, /*  7708 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    51139634, /*  7709 ( 202) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      121298, /*  7710 ( 202) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34133684, /*  7711 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34028546, /*  7712 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127572, /*  7713 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7714 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  7715 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17022434, /*  7716 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
      121298, /*  7717 ( 203) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445884, /*  7718 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52556972, /*  7719 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35550698, /*  7720 ( 203) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17127572, /*  7721 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7722 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  7723 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51021698, /*  7724 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022434, /*  7725 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
      121298, /*  7726 ( 204) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  7727 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34015424, /*  7728 ( 204) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127572, /*  7729 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7730 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  7731 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52569932, /*  7732 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35432600, /*  7733 ( 205) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17022434, /*  7734 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35563982, /*  7735 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      121298, /*  7736 ( 205) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    17127572, /*  7737 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7738 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  7739 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34146644, /*  7740 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17022434, /*  7741 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
      121298, /*  7742 ( 206) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51021536, /*  7743 ( 206) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    51152918, /*  7744 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17127572, /*  7745 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7746 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  7747 ( 207) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35550860, /*  7748 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17022434, /*  7749 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
      121298, /*  7750 ( 207) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  7751 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35445722, /*  7752 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17127572, /*  7753 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7754 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022434, /*  7755 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0]  1 */
    35432762, /*  7756 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      121298, /*  7757 ( 208) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52438712, /*  7758 ( 208) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52570094, /*  7759 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35563820, /*  7760 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17127572, /*  7761 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  7762 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121298, /*  7763 ( 197) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
     1420538, /*  7764 ( 197) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
     1551596, /*  7765 ( 197) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7766 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  7767 ( 198) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35432762, /*  7768 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420538, /*  7769 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
      121298, /*  7770 ( 198) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35563820, /*  7771 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028708, /*  7772 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551596, /*  7773 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7774 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  7775 ( 199) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34133522, /*  7776 ( 199) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1420538, /*  7777 ( 199) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
       16484, /*  7778 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  7779 ( 200) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35432762, /*  7780 ( 200) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1551596, /*  7781 ( 200) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7782 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  7783 ( 201) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      121298, /*  7784 ( 201) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35432762, /*  7785 ( 201) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  7786 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  7787 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420538, /*  7788 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    35550698, /*  7789 ( 202) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      121298, /*  7790 ( 202) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146644, /*  7791 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34015586, /*  7792 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551596, /*  7793 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7794 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  7795 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1420538, /*  7796 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
      121298, /*  7797 ( 203) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034820, /*  7798 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52569932, /*  7799 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51139634, /*  7800 ( 203) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1551596, /*  7801 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7802 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  7803 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35445722, /*  7804 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1420538, /*  7805 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
      121298, /*  7806 ( 204) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    34146806, /*  7807 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    34015424, /*  7808 ( 204) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551596, /*  7809 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7810 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  7811 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52556972, /*  7812 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  7813 ( 205) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1420538, /*  7814 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51152918, /*  7815 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      121298, /*  7816 ( 205) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
     1551596, /*  7817 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7818 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  7819 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34133684, /*  7820 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1420538, /*  7821 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
      121298, /*  7822 ( 206) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35432600, /*  7823 ( 206) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    35563982, /*  7824 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551596, /*  7825 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7826 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  7827 ( 207) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51152756, /*  7828 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1420538, /*  7829 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
      121298, /*  7830 ( 207) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  7831 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51021698, /*  7832 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551596, /*  7833 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7834 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420538, /*  7835 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0]  1 */
    51034658, /*  7836 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      121298, /*  7837 ( 208) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52438712, /*  7838 ( 208) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    52570094, /*  7839 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51139796, /*  7840 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1551596, /*  7841 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  7842 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022432, /*  7843 ( 197) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
     1433658, /*  7844 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    18439610, /*  7845 ( 197) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7846 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  7847 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35445882, /*  7848 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1433658, /*  7849 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17022432, /*  7850 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52451834, /*  7851 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34028708, /*  7852 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18439610, /*  7853 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7854 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  7855 ( 199) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51034656, /*  7856 ( 199) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1433658, /*  7857 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
       16484, /*  7858 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  7859 ( 200) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35445882, /*  7860 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18439610, /*  7861 ( 200) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7862 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  7863 ( 201) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17022432, /*  7864 ( 201) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35445882, /*  7865 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  7866 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  7867 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1433658, /*  7868 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52451832, /*  7869 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17022432, /*  7870 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034658, /*  7871 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34028706, /*  7872 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439610, /*  7873 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7874 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  7875 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1433658, /*  7876 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17022432, /*  7877 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146806, /*  7878 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52569932, /*  7879 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51152754, /*  7880 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439610, /*  7881 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7882 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  7883 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    35445722, /*  7884 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1433658, /*  7885 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17022432, /*  7886 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034820, /*  7887 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34028544, /*  7888 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439610, /*  7889 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7890 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  7891 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52570092, /*  7892 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146642, /*  7893 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1433658, /*  7894 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152918, /*  7895 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17022432, /*  7896 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    18439610, /*  7897 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7898 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  7899 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51034818, /*  7900 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1433658, /*  7901 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17022432, /*  7902 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35445720, /*  7903 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    52451996, /*  7904 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439610, /*  7905 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7906 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  7907 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    51152756, /*  7908 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1433658, /*  7909 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17022432, /*  7910 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563982, /*  7911 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146804, /*  7912 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439610, /*  7913 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7914 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1433658, /*  7915 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146644, /*  7916 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17022432, /*  7917 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563818, /*  7918 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52570094, /*  7919 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51152916, /*  7920 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439610, /*  7921 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  7922 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022432, /*  7923 ( 197) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
      134420, /*  7924 ( 197) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    17140692, /*  7925 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  7926 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  7927 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34146644, /*  7928 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      134420, /*  7929 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    17022432, /*  7930 ( 198) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51152916, /*  7931 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028708, /*  7932 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140692, /*  7933 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  7934 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  7935 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    51034656, /*  7936 ( 199) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
      134420, /*  7937 ( 199) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  7938 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  7939 ( 200) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34146644, /*  7940 ( 200) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17140692, /*  7941 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  7942 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  7943 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17022432, /*  7944 ( 201) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146644, /*  7945 ( 201) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  7946 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*  7947 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      134420, /*  7948 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51152754, /*  7949 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17022432, /*  7950 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034818, /*  7951 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    34028546, /*  7952 ( 202) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17140692, /*  7953 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  7954 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  7955 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
      134420, /*  7956 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    17022432, /*  7957 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35445884, /*  7958 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52570092, /*  7959 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52451832, /*  7960 ( 203) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140692, /*  7961 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  7962 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  7963 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146804, /*  7964 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
      134420, /*  7965 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    17022432, /*  7966 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    51034820, /*  7967 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34028544, /*  7968 ( 204) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17140692, /*  7969 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  7970 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  7971 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52569932, /*  7972 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35445720, /*  7973 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
      134420, /*  7974 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  7975 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17022432, /*  7976 ( 205) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    17140692, /*  7977 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  7978 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  7979 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51034658, /*  7980 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
      134420, /*  7981 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    17022432, /*  7982 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34146642, /*  7983 ( 206) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51152918, /*  7984 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140692, /*  7985 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  7986 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  7987 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52451994, /*  7988 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
      134420, /*  7989 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    17022432, /*  7990 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563982, /*  7991 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35445722, /*  7992 ( 207) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140692, /*  7993 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  7994 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      134420, /*  7995 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35445882, /*  7996 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022432, /*  7997 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563818, /*  7998 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    52570094, /*  7999 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52451834, /*  8000 ( 208) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17140692, /*  8001 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16484, /*  8002 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  8003 ( 197) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
      121460, /*  8004 ( 197) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
     1551756, /*  8005 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8006 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  8007 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34133684, /*  8008 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121460, /*  8009 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
     1420536, /*  8010 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35563980, /*  8011 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028708, /*  8012 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551756, /*  8013 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8014 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  8015 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    35432760, /*  8016 ( 199) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
      121460, /*  8017 ( 199) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
       16484, /*  8018 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  8019 ( 200) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34133684, /*  8020 ( 200) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1551756, /*  8021 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8022 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  8023 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1420536, /*  8024 ( 201) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34133684, /*  8025 ( 201) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  8026 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146806, /*  8027 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
      121460, /*  8028 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    35550858, /*  8029 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1420536, /*  8030 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445882, /*  8031 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    34015586, /*  8032 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551756, /*  8033 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8034 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  8035 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
      121460, /*  8036 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
     1420536, /*  8037 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51034820, /*  8038 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52570092, /*  8039 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52438872, /*  8040 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1551756, /*  8041 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8042 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  8043 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34146804, /*  8044 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
      121460, /*  8045 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
     1420536, /*  8046 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445884, /*  8047 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34015584, /*  8048 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551756, /*  8049 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8050 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  8051 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52556972, /*  8052 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021696, /*  8053 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
      121460, /*  8054 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    52451996, /*  8055 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1420536, /*  8056 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
     1551756, /*  8057 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8058 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  8059 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35432762, /*  8060 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
      121460, /*  8061 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
     1420536, /*  8062 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34133682, /*  8063 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35563982, /*  8064 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551756, /*  8065 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8066 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  8067 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    52451994, /*  8068 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
      121460, /*  8069 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
     1420536, /*  8070 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152918, /*  8071 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51021698, /*  8072 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551756, /*  8073 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8074 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
      121460, /*  8075 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6]  1 */
    51034818, /*  8076 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
     1420536, /*  8077 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51139794, /*  8078 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52570094, /*  8079 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    52438874, /*  8080 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1551756, /*  8081 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
       16484, /*  8082 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1420536, /*  8083 ( 197) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    17022594, /*  8084 ( 197) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    18426650, /*  8085 ( 197) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8086 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  8087 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51034818, /*  8088 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17022594, /*  8089 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
     1420536, /*  8090 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    52438874, /*  8091 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    34028708, /*  8092 ( 198) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    18426650, /*  8093 ( 198) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8094 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  8095 ( 199) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35432760, /*  8096 ( 199) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022594, /*  8097 ( 199) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
       16484, /*  8098 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  8099 ( 200) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51034818, /*  8100 ( 200) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18426650, /*  8101 ( 200) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8102 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  8103 ( 201) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1420536, /*  8104 ( 201) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51034818, /*  8105 ( 201) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  8106 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  8107 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022594, /*  8108 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    52438872, /*  8109 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
     1420536, /*  8110 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35432762, /*  8111 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34028706, /*  8112 ( 202) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426650, /*  8113 ( 202) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8114 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  8115 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17022594, /*  8116 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
     1420536, /*  8117 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    34146806, /*  8118 ( 203) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556972, /*  8119 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35550858, /*  8120 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18426650, /*  8121 ( 203) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8122 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  8123 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    51021698, /*  8124 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17022594, /*  8125 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
     1420536, /*  8126 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    35445884, /*  8127 ( 204) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34015584, /*  8128 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426650, /*  8129 ( 204) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8130 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  8131 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52570092, /*  8132 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  8133 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17022594, /*  8134 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    35563982, /*  8135 ( 205) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1420536, /*  8136 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    18426650, /*  8137 ( 205) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8138 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  8139 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35445882, /*  8140 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    17022594, /*  8141 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
     1420536, /*  8142 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51021696, /*  8143 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    52451996, /*  8144 ( 206) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18426650, /*  8145 ( 206) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8146 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  8147 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    35550860, /*  8148 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17022594, /*  8149 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
     1420536, /*  8150 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51152918, /*  8151 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34146804, /*  8152 ( 207) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18426650, /*  8153 ( 207) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8154 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17022594, /*  8155 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0]  1 */
    34133684, /*  8156 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1420536, /*  8157 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0]  1 */
    51139794, /*  8158 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    52570094, /*  8159 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35563980, /*  8160 ( 208) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18426650, /*  8161 ( 208) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16484, /*  8162 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551596, /*  8163 ( 209) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
        3200, /*  8164 ( 209) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1538636, /*  8165 ( 209) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  8166 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  8167 ( 210) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  8168 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551596, /*  8169 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538636, /*  8170 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34015424, /*  8171 ( 210) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028708, /*  8172 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35563820, /*  8173 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  8174 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  8175 ( 211) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
     1551596, /*  8176 ( 211) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550860, /*  8177 ( 211) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  8178 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  8179 ( 212) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35563820, /*  8180 ( 212) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538636, /*  8181 ( 212) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  8182 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  8183 ( 213) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563820, /*  8184 ( 213) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
        3200, /*  8185 ( 213) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  8186 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  8187 ( 214) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034820, /*  8188 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52569932, /*  8189 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
     1551596, /*  8190 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538636, /*  8191 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52556972, /*  8192 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021536, /*  8193 ( 214) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  8194 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  8195 ( 215) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34146644, /*  8196 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1551596, /*  8197 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35432600, /*  8198 ( 215) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1538636, /*  8199 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34133684, /*  8200 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    35445884, /*  8201 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  8202 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  8203 ( 216) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3200, /*  8204 ( 216) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551596, /*  8205 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35432762, /*  8206 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
     1538636, /*  8207 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35445722, /*  8208 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34146806, /*  8209 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  8210 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  8211 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3200, /*  8212 ( 217) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551596, /*  8213 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35563982, /*  8214 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538636, /*  8215 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550698, /*  8216 ( 217) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    34028546, /*  8217 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  8218 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  8219 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3200, /*  8220 ( 218) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  8221 ( 218) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
     1551596, /*  8222 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51139634, /*  8223 ( 218) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1538636, /*  8224 ( 218) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    51152918, /*  8225 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  8226 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  8227 ( 219) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  8228 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
     1551596, /*  8229 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538636, /*  8230 ( 219) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52451996, /*  8231 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    51139796, /*  8232 ( 219) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    52438712, /*  8233 ( 219) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  8234 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  8235 ( 220) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3200, /*  8236 ( 220) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51021698, /*  8237 ( 220) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
     1551596, /*  8238 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
     1538636, /*  8239 ( 220) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52570094, /*  8240 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51034658, /*  8241 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  8242 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127572, /*  8243 ( 209) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
        3200, /*  8244 ( 209) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140532, /*  8245 ( 209) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  8246 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  8247 ( 210) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  8248 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17127572, /*  8249 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140532, /*  8250 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34015424, /*  8251 ( 210) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    34028708, /*  8252 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51139796, /*  8253 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  8254 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  8255 ( 211) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    17127572, /*  8256 ( 211) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152756, /*  8257 ( 211) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  8258 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015424, /*  8259 ( 212) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51139796, /*  8260 ( 212) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140532, /*  8261 ( 212) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  8262 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  8263 ( 213) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51139796, /*  8264 ( 213) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3200, /*  8265 ( 213) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16484, /*  8266 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  8267 ( 214) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445884, /*  8268 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52556972, /*  8269 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    17127572, /*  8270 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140532, /*  8271 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52569932, /*  8272 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35432600, /*  8273 ( 214) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  8274 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  8275 ( 215) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133684, /*  8276 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17127572, /*  8277 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51021536, /*  8278 ( 215) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17140532, /*  8279 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34146644, /*  8280 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    51034820, /*  8281 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  8282 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34133522, /*  8283 ( 216) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
        3200, /*  8284 ( 216) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127572, /*  8285 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51034658, /*  8286 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    17140532, /*  8287 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51021698, /*  8288 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34146806, /*  8289 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  8290 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  8291 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3200, /*  8292 ( 217) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17127572, /*  8293 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152918, /*  8294 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140532, /*  8295 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51139634, /*  8296 ( 217) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    34015586, /*  8297 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  8298 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52438874, /*  8299 ( 218) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3200, /*  8300 ( 218) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451834, /*  8301 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    17127572, /*  8302 ( 218) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35550698, /*  8303 ( 218) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17140532, /*  8304 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35563982, /*  8305 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  8306 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3200, /*  8307 ( 219) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  8308 ( 219) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17127572, /*  8309 ( 219) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140532, /*  8310 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451996, /*  8311 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35563820, /*  8312 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52438712, /*  8313 ( 219) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  8314 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556810, /*  8315 ( 220) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
        3200, /*  8316 ( 220) [-1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35445722, /*  8317 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17127572, /*  8318 ( 220) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    17140532, /*  8319 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52570094, /*  8320 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35432762, /*  8321 ( 220) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  8322 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    17140692, /*  8323 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
       16320, /*  8324 ( 209) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140532, /*  8325 ( 209) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  8326 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  8327 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152756, /*  8328 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140692, /*  8329 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17140532, /*  8330 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34028544, /*  8331 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  8332 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    51152916, /*  8333 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  8334 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  8335 ( 211) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    17140692, /*  8336 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51152756, /*  8337 ( 211) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  8338 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  8339 ( 212) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    51152916, /*  8340 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    17140532, /*  8341 ( 212) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
       16484, /*  8342 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152756, /*  8343 ( 213) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    51152916, /*  8344 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16320, /*  8345 ( 213) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  8346 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  8347 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445884, /*  8348 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    52570092, /*  8349 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    17140692, /*  8350 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17140532, /*  8351 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52569932, /*  8352 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35445720, /*  8353 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  8354 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  8355 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034818, /*  8356 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    17140692, /*  8357 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34146642, /*  8358 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    17140532, /*  8359 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51034658, /*  8360 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    34146806, /*  8361 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  8362 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  8363 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16320, /*  8364 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140692, /*  8365 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    34146644, /*  8366 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    17140532, /*  8367 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    34146804, /*  8368 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    51034820, /*  8369 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  8370 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028546, /*  8371 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16320, /*  8372 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    17140692, /*  8373 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    51152918, /*  8374 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    17140532, /*  8375 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    51152754, /*  8376 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    34028706, /*  8377 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  8378 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563980, /*  8379 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16320, /*  8380 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563820, /*  8381 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    17140692, /*  8382 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    52451832, /*  8383 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140532, /*  8384 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52451996, /*  8385 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  8386 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  8387 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  8388 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    17140692, /*  8389 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17140532, /*  8390 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    35563982, /*  8391 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    52451834, /*  8392 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    35563818, /*  8393 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  8394 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  8395 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16320, /*  8396 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445722, /*  8397 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    17140692, /*  8398 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6]  1 */
    17140532, /*  8399 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6]  1 */
    52570094, /*  8400 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    35445882, /*  8401 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
       16484, /*  8402 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18439610, /*  8403 ( 209) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
       16320, /*  8404 ( 209) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439770, /*  8405 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  8406 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  8407 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  8408 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18439610, /*  8409 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439770, /*  8410 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34028544, /*  8411 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  8412 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52451834, /*  8413 ( 210) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  8414 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  8415 ( 211) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18439610, /*  8416 ( 211) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451994, /*  8417 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  8418 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028544, /*  8419 ( 212) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52451834, /*  8420 ( 212) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439770, /*  8421 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  8422 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  8423 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52451834, /*  8424 ( 213) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16320, /*  8425 ( 213) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  8426 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  8427 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  8428 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52569932, /*  8429 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18439610, /*  8430 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439770, /*  8431 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52570092, /*  8432 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34146642, /*  8433 ( 214) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  8434 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  8435 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034658, /*  8436 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    18439610, /*  8437 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35445720, /*  8438 ( 215) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18439770, /*  8439 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51034818, /*  8440 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    35445884, /*  8441 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  8442 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51034656, /*  8443 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16320, /*  8444 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439610, /*  8445 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35445882, /*  8446 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    18439770, /*  8447 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35445722, /*  8448 ( 216) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    51034820, /*  8449 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  8450 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  8451 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16320, /*  8452 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439610, /*  8453 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*  8454 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439770, /*  8455 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52451832, /*  8456 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34028546, /*  8457 ( 217) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  8458 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35563820, /*  8459 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16320, /*  8460 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35563980, /*  8461 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18439610, /*  8462 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51152754, /*  8463 ( 218) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18439770, /*  8464 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51152918, /*  8465 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
       16484, /*  8466 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
       16320, /*  8467 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152756, /*  8468 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    18439610, /*  8469 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439770, /*  8470 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35563982, /*  8471 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    51152916, /*  8472 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    35563818, /*  8473 ( 219) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  8474 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52569930, /*  8475 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
       16320, /*  8476 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  8477 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18439610, /*  8478 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439770, /*  8479 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52570094, /*  8480 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34146644, /*  8481 ( 220) [ 1,  0,  0,  0, -1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  8482 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    18426650, /*  8483 ( 209) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
        3360, /*  8484 ( 209) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18439770, /*  8485 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  8486 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  8487 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    52451994, /*  8488 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    18426650, /*  8489 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439770, /*  8490 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    34015584, /*  8491 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  8492 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    52438874, /*  8493 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
       16484, /*  8494 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  8495 ( 211) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    18426650, /*  8496 ( 211) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451994, /*  8497 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
       16484, /*  8498 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  8499 ( 212) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    52438874, /*  8500 ( 212) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439770, /*  8501 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
       16484, /*  8502 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52451994, /*  8503 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    52438874, /*  8504 ( 213) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
        3360, /*  8505 ( 213) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  8506 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  8507 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146806, /*  8508 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
    52556972, /*  8509 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    18426650, /*  8510 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439770, /*  8511 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52570092, /*  8512 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
    34133682, /*  8513 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
       16484, /*  8514 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  8515 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35432762, /*  8516 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    18426650, /*  8517 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51021696, /*  8518 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18439770, /*  8519 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35445882, /*  8520 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
    51034820, /*  8521 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
       16484, /*  8522 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  8523 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3360, /*  8524 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18426650, /*  8525 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    51034818, /*  8526 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
    18439770, /*  8527 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51021698, /*  8528 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    35445884, /*  8529 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  8530 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34028706, /*  8531 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
        3360, /*  8532 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    18426650, /*  8533 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    52451996, /*  8534 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0] -1 */
    18439770, /*  8535 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52438872, /*  8536 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0] -1 */
    34015586, /*  8537 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
       16484, /*  8538 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51139796, /*  8539 ( 218) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
        3360, /*  8540 ( 218) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51152916, /*  8541 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
    18426650, /*  8542 ( 218) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    35550858, /*  8543 ( 218) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    18439770, /*  8544 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    35563982, /*  8545 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  8546 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  8547 ( 219) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550860, /*  8548 ( 219) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    18426650, /*  8549 ( 219) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439770, /*  8550 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    51152918, /*  8551 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  6] -1 */
    35563980, /*  8552 ( 219) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    51139794, /*  8553 ( 219) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  6] -1 */
       16484, /*  8554 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    52556970, /*  8555 ( 220) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
        3360, /*  8556 ( 220) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    34146804, /*  8557 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    18426650, /*  8558 ( 220) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  0]  1 */
    18439770, /*  8559 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  0]  1 */
    52570094, /*  8560 ( 220) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    34133684, /*  8561 ( 220) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  8562 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
     1551756, /*  8563 ( 209) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
        3360, /*  8564 ( 209) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1538636, /*  8565 ( 209) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  8566 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  8567 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35550860, /*  8568 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1551756, /*  8569 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538636, /*  8570 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34015584, /*  8571 ( 210) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    34028708, /*  8572 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
    35563980, /*  8573 ( 210) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
       16484, /*  8574 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  8575 ( 211) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
     1551756, /*  8576 ( 211) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35550860, /*  8577 ( 211) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
       16484, /*  8578 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015584, /*  8579 ( 212) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
    35563980, /*  8580 ( 212) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
     1538636, /*  8581 ( 212) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
       16484, /*  8582 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35550860, /*  8583 ( 213) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
    35563980, /*  8584 ( 213) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
        3360, /*  8585 ( 213) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
       16484, /*  8586 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  8587 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    51034820, /*  8588 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  0,  0] -1 */
    52570092, /*  8589 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  6,  6] -1 */
     1551756, /*  8590 ( 214) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
     1538636, /*  8591 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    52556972, /*  8592 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 6,  6,  6] -1 */
    51021696, /*  8593 ( 214) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 6,  0,  0] -1 */
       16484, /*  8594 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
        3360, /*  8595 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
    35445882, /*  8596 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
     1551756, /*  8597 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34133682, /*  8598 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
     1538636, /*  8599 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35432762, /*  8600 ( 215) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
    34146806, /*  8601 ( 215) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
       16484, /*  8602 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    35432760, /*  8603 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  0] -1 */
        3360, /*  8604 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551756, /*  8605 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    34133684, /*  8606 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  6] -1 */
     1538636, /*  8607 ( 216) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    34146804, /*  8608 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  6] -1 */
    35445884, /*  8609 ( 216) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  0] -1 */
       16484, /*  8610 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    34015586, /*  8611 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0] -1 */
        3360, /*  8612 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0]  1 */
     1551756, /*  8613 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6]  1 */
    35563982, /*  8614 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6] -1 */
     1538636, /*  8615 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  6,  6]  1 */
    35550858, /*  8616 ( 217) [-1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  6,  6] -1 */
    34028706, /*  8617 ( 217) [ 1,  0,  0,  0,  1,  0,  0,  0, -1] [ 0,  0,  0] -1 */
       16484, /*  8618 ( 218) [ 1,  0,  0,  0,  1,  0,  0,  0,  1] [ 0,  0,  0]  1 */
    51152916, /*  8619 ( 218) [ 1,  0,  0,  0,  1,  