Submitting patches
==================

Sparse uses a patch submit process similar to the Linux Kernel
[Submitting Patches](https://www.kernel.org/doc/html/v4.12/process/submitting-patches.html)

This document mostly focuses on the parts that might be different from the Linux
Kernel submitting process.

1. Git clone a sparse repository:

        git clone git://git.kernel.org/pub/scm/devel/sparse/sparse.git

2. [Coding Style](https://www.kernel.org/doc/html/v4.12/process/coding-style.html) remains the same.

3. Sign off the patch.

   The usage of the Signed-off-by tag is the same as [Linux Kernel Sign your work](https://www.kernel.org/doc/html/v4.12/process/submitting-patches.html#sign-your-work-the-developer-s-certificate-of-origin).

   Notice that sparse uses the MIT License.

