# 2025-09-15 Triage Log

Difficult week to interpret, because a positive change in [#145910](https://github.com/rust-lang/rust/pull/145910) performs a bit worse in our benchmarks than it would in the real world. Overall result is probably still slightly negative, because there's more work from added features. On the other hand, we also have a nice improvement in reducing the number of query dependencies in compiler's incremental system in [#145186](https://github.com/rust-lang/rust/pull/145186).

Triage done by **@panstromek**.
Revision range: [f13ef0d7..52618eb3](https://perf.rust-lang.org/?start=f13ef0d75d834c826c9479a5d244bcfb9891df45&end=52618eb338609df44978b0ca4451ab7941fd1c7a&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 2.7%]   | 72    |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.0%, 3.5%]   | 96    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.9%, -0.1%] | 10    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-2.9%, -0.1%] | 41    |
| All ❌✅ (primary)                 | 0.4%  | [-0.9%, 2.7%]  | 82    |


1 Regression, 1 Improvement, 6 Mixed; 3 of them in rollups
36 artifact comparisons made in total

#### Regressions

consider item bounds for non-yet-defined opaque types [#146329](https://github.com/rust-lang/rust/pull/146329) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=408eacfb95ea19e248c0fe5e377980bc00682c1b&end=a171994070dc18c3a32fc1aa2d98cf03ae96b63e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 0.8%]   | 11    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |

`tt-muncher`, `ucd` and `tuple-stress` all look like noise to me. The rest is in new-solver, which is still WIP and not enabled by default.

#### Improvements

Make `AssocItem` aware of its impl kind [#145186](https://github.com/rust-lang/rust/pull/145186) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b50f345a2f3f49764024cabc30ef99e15c0240f7&end=637b50be01093962ac6f4432d6881ab41d6d90b4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 15    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-1.2%, -0.1%] | 25    |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.1%] | 15    |


#### Mixed

Rollup of 4 pull requests [#146304](https://github.com/rust-lang/rust/pull/146304) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=23718020b12d7e5a54f82a19910e8356ee719667&end=12eb345e5593a10e61b4aef766076c8bd552fea6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 0.4%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.9%]   | 13    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -2.7% | [-2.9%, -2.5%] | 6     |
| All ❌✅ (primary)                 | 0.2%  | [-0.2%, 0.4%]  | 9     |

Seems to be caused by https://github.com/rust-lang/rust/pull/146297, pinged the author and continuing the discussion there.

Ignore intrinsic calls in cross-crate-inlining cost model [#145910](https://github.com/rust-lang/rust/pull/145910) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2f3f27bf79ec147fec9d2e7980605307a74067f4&end=a09fbe2c8372643a27a8082236120f95ed4e6bba&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.3%, 2.4%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [0.2%, 3.0%]   | 9     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.7%, -0.4%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.1%] | 14    |
| All ❌✅ (primary)                 | 0.5%  | [-0.7%, 2.4%]  | 15    |

Already triaged by reviewer. Justified in PR description. Should be an improvement overall, but causes a lot of CGU perturbation in our benchmark suite.

eagerly compute `sub_unification_table` again [#140375](https://github.com/rust-lang/rust/pull/140375) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a78f9aa87fa828ad4a5c11f1e3b93e94d9352ad6&end=9c27f27ea3bab79a2fec827ef3ae0009959d60f4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 1.4%]   | 61    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.1%, 2.7%]   | 71    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.8%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-2.9%, -0.2%] | 21    |
| All ❌✅ (primary)                 | 0.3%  | [-0.8%, 1.4%]  | 64    |

Expected regression, triaged by author and @Kobzol

Rollup of 11 pull requests [#146360](https://github.com/rust-lang/rust/pull/146360) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fefce3cecd63cebf2d7c9aa3dd90a84379fcfa1a&end=be8de5d6a0fc5cb2924e174a809a0aff303f281a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.4%]   | 10    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.1%, -0.1%] | 9     |
| All ❌✅ (primary)                 | -     | -              | 0     |

Tiny changes mostly in artificial stress tests, overall slightly positive. Probably not worth more investigation.

Rollup of 5 pull requests [#146409](https://github.com/rust-lang/rust/pull/146409) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7ad23f43a225546c095123de52cc07d8719f8e2b&end=565a9ca63e9df4b223fed0da01f15e578acfb538&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.2%]   | 3     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.4%]   | 3     |

Some small regressions. I suspect the primary regressions in `unicode-normalization` come from https://github.com/rust-lang/rust/pull/144765, because it contains a few giant tables with a lot of range patterns. The other candidate would be https://github.com/rust-lang/rust/pull/146178 but I don't see anything that would be related in that benchmark.

Either way, together with the secondary benchmarks, all of those are tiny changes (0.002s) on tiny benchmarks, so I don't think this is worth more investigation.

Constify Eq, Ord, PartialOrd [#144847](https://github.com/rust-lang/rust/pull/144847) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a171994070dc18c3a32fc1aa2d98cf03ae96b63e&end=5c11fb842afc9876e985886c30292a227caee632&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.1%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.3%]   | 8     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.2%, -0.1%] | 2     |
| All ❌✅ (primary)                 | 0.1%  | [0.1%, 0.1%]   | 1     |

Slight regression in doc benchmarks, similar to [pre-merge results](https://github.com/rust-lang/rust/pull/144847#issuecomment-3189779391). Expected because of more const handling (looks like more time is spent in const related queries from a brief look at the detailed results of hello-world: https://perf.rust-lang.org/detailed-query.html?commit=5c11fb842afc9876e985886c30292a227caee632&benchmark=helloworld-doc&scenario=full&base_commit=a171994070dc18c3a32fc1aa2d98cf03ae96b63e)

Justified by https://github.com/rust-lang/rust/pull/144847#issuecomment-3193410781, if I understand correctly.
