# 2022-02-02 Triage Log

This was a relatively quiet week with regressions and improvements relatively equally each other out. The big exception is with a somewhat large regression in rustdoc which was needed for a large and important architectural change. This could lead to users see somewhat slower doc build times with more memory used especially in projects with large crate dependency graphs.

Triage done by **@rylev**.
Revision range: [c54dfee65126a0ac385d55389a316e89095a0713..1ea4851715893ee3f365a8ef09d47165e9a7864f](https://perf.rust-lang.org/?start=c54dfee65126a0ac385d55389a316e89095a0713&end=1ea4851715893ee3f365a8ef09d47165e9a7864f&absolute=false&stat=instructions%3Au)

2 Regressions, 4 Improvements, 2 Mixed; 1 of them in rollups
35 comparisons made in total

#### Regressions

rustdoc: Pre-calculate traits that are in scope for doc links [#88679](https://github.com/rust-lang/rust/issues/88679)
- Average relevant regression: 5.4%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=d502eda250d0090f4990cc6880c88b95a92b4818&end=788b1fe5b79a8b74215022f9df49b0eae68a50b9&stat=instructions:u): 9.1% on `full` builds of `regression-31157 doc`
- All the regressions are localized to rustdoc and are quite substantial but exacerbated by an architectural issue which needs to be solved.
- The regressions are well known and extensively discussed in the PR with the [next steps](https://github.com/rust-lang/rust/pull/88679#issuecomment-1021810724) being tracked in an issue.


Store def_id_to_hir_id as variant in hir_owner. [#93373](https://github.com/rust-lang/rust/issues/93373)
- Average relevant regression: 1.2%
- Average relevant improvement: -0.3%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=86f5e177bca8121e1edc9864023a8ea61acf9034&end=24b8bb13bff98bb747cd403b86596af43aceee78&stat=instructions:u): 5.5% on `incr-unchanged` builds of `match-stress-enum check`
- This is the first commit (originally bundled with [#93301](https://github.com/rust-lang/rust/issues/93301)) of a larger PR ([#89278](https://github.com/rust-lang/rust/pull/89278)) which saw larger PR regressions than the two sub PRs combined.
- A more detailed justification for this can be [found here](https://github.com/rust-lang/rust/pull/93373#issuecomment-1027962065), but in general this allows for even more incremental compilation and is thus worth the small immediate compilation performance penalty. 


#### Improvements

Fix the unsoundness in the `early_otherwise_branch` mir opt pass [#91840](https://github.com/rust-lang/rust/issues/91840)
- Average relevant improvement: -1.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=788b1fe5b79a8b74215022f9df49b0eae68a50b9&end=a7f375789bab1a4e4a291c963081a8ca7d2b6bd7&stat=instructions:u): -6.9% on `full` builds of `deeply-nested-async check`


Only traverse attrs once while checking for coherence override attributes [#93343](https://github.com/rust-lang/rust/issues/93343)
- Average relevant improvement: -1.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5ab502c6d308b0ccac8127c0464e432334755a60&end=312a7995e73e390646bc61920ffead7a640addc6&stat=instructions:u): -1.4% on `incr-full` builds of `stm32f4 check`


Rollup of 10 pull requests [#93427](https://github.com/rust-lang/rust/issues/93427)
- Average relevant improvement: -1.2%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e0a55f4491a729bffc63b402ba903d90858c806b&end=6250d5a08cf0870d3655fa98b83718bc01ff6f45&stat=instructions:u): -1.9% on `full` builds of `ctfe-stress-4 doc`


Disable drop range analysis [#93284](https://github.com/rust-lang/rust/issues/93284)
- Average relevant improvement: -1.6%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=547f2ba06bc4aa93a375c54e1af3fd1216eeaf62&end=686663a49e57870c78a4cd047f23a44175fc67a4&stat=instructions:u): -2.0% on `full` builds of `await-call-tree check`


#### Mixed

Store hir_id_to_def_id in OwnerInfo. [#93301](https://github.com/rust-lang/rust/issues/93301)
- Average relevant regression: 0.6%
- Average relevant improvement: -0.5%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a7f375789bab1a4e4a291c963081a8ca7d2b6bd7&end=6abb6385b2cb7249f67b9b3ce7522527767dd907&stat=instructions:u): -0.6% on `full` builds of `unused-warnings check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a7f375789bab1a4e4a291c963081a8ca7d2b6bd7&end=6abb6385b2cb7249f67b9b3ce7522527767dd907&stat=instructions:u): 2.2% on `incr-unchanged` builds of `match-stress-enum check`
- This is the first commit (originally bundled with [#93373](https://github.com/rust-lang/rust/issues/93373)) of a larger PR ([#89278](https://github.com/rust-lang/rust/pull/89278)) which saw larger PR regressions than the two sub PRs combined.


Create `core::fmt::ArgumentV1` with generics instead of fn pointer [#90891](https://github.com/rust-lang/rust/issues/90891)
- Average relevant regression: 1.2%
- Average relevant improvement: -1.2%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=08df8b81d6e723c66fee579d57d61dc60bc21fc1&end=e58e7b10e13595b4df1b105bfb9ad03c8dee7832&stat=instructions:u): -6.7% on `full` builds of `tokio-webpush-simple opt`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=08df8b81d6e723c66fee579d57d61dc60bc21fc1&end=e58e7b10e13595b4df1b105bfb9ad03c8dee7832&stat=instructions:u): 2.1% on `full` builds of `keccak check`
- The improvements outweigh the regressions considerably and this was [considered](https://github.com/rust-lang/rust/pull/90891#issuecomment-970851616) a fine trade off.


#### Untriaged Pull Requests

- [#93466 Make dead code check a query.](https://github.com/rust-lang/rust/pull/93466)
- [#93288 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/93288)
- [#93138 Rollup of 17 pull requests](https://github.com/rust-lang/rust/pull/93138)
- [#93095 Store a `Symbol` instead of an `Ident` in `AssocItem`](https://github.com/rust-lang/rust/pull/93095)
- [#92896 Update some rustc dependencies to deduplicate them](https://github.com/rust-lang/rust/pull/92896)
- [#92844 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/92844)
- [#92816 Remove deprecated LLVM-style inline assembly](https://github.com/rust-lang/rust/pull/92816)
- [#92805 partially revertish `lazily "compute" anon const default substs`](https://github.com/rust-lang/rust/pull/92805)
- [#92534 Hash `Ident` spans in all HIR structures](https://github.com/rust-lang/rust/pull/92534)
- [#92356 Add {Add,Sub,Mul,Div,Rem,BitXor,BitOr,BitAnd}{,Assign}<$t> to Saturat…](https://github.com/rust-lang/rust/pull/92356)
- [#92277 rustc_metadata: Stop passing `CrateMetadataRef` by reference (step 1)](https://github.com/rust-lang/rust/pull/92277)
- [#92252 Update pulldown-cmark version to 0.9](https://github.com/rust-lang/rust/pull/92252)
- [#92229 Do not display `~const Drop` in rustdoc](https://github.com/rust-lang/rust/pull/92229)
- [#92227 Rustdoc: use `is_doc_hidden` method on more places](https://github.com/rust-lang/rust/pull/92227)
- [#92149 Fix bad caching of `~const Drop` bounds](https://github.com/rust-lang/rust/pull/92149)
- [#92135 Add `#[inline]` modifier to `TypeId::of`](https://github.com/rust-lang/rust/pull/92135)
- [#92110 Backport LLVM changes to disable deferred inlining](https://github.com/rust-lang/rust/pull/92110)
- [#92106 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/92106)
- [#92088 intra-doc: Use an enum to represent URL fragments](https://github.com/rust-lang/rust/pull/92088)
- [#92064 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92064)
- [#92062 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92062)
- [#92041 Remove 'speculative evaluation' of predicates](https://github.com/rust-lang/rust/pull/92041)
- [#92003 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92003)
- [#91996 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91996)
- [#91959 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91959)
- [#91924 Fully serialize AdtDef](https://github.com/rust-lang/rust/pull/91924)
- [#91900 rustdoc: make `--passes` and `--no-defaults` have no effect](https://github.com/rust-lang/rust/pull/91900)
- [#91844 Eliminate `ObligationCauseData`](https://github.com/rust-lang/rust/pull/91844)
- [#91841 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/91841)
