More than one parameter was used for a coroutine.

Erroneous code example:

```compile_fail,E0628
#![feature(coroutines, coroutine_trait)]

fn main() {
    let coroutine = |a: i32, b: i32| {
        // error: too many parameters for a coroutine
        // Allowed only 0 or 1 parameter
        yield a;
    };
}
```

At present, it is not permitted to pass more than one explicit
parameter for a coroutine.This can be fixed by using
at most 1 parameter for the coroutine. For example, we might resolve
the previous example by passing only one parameter.

```
#![feature(coroutines, coroutine_trait)]

fn main() {
    let coroutine = |a: i32| {
        yield a;
    };
}
```
