#! /bin/sh

# Test upload of a CSV file.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
DB_FILE=${DB_DIR}/test1.db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}.db

cp ${DB_FILE} ${TMP_DB_FILE}

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}.db/bibliography"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

echo "==="

perl -lne 'print "$_\r"' <<EOF |
--------------------------b989696a28305e74
Content-Disposition: form-data; name="csvfile"; filename="fill.csv"
Content-Type: application/octet-stream

# This is a comment,,
authors,title
Saulius Gražulis,Opus Magnum vol. 1
Saulius Gražulis,Opus Magnum vol. 2
Saulius Gražulis,Opus Magnum vol. 3
Saulius Gražulis,Opus Magnum vol. 4
Saulius Gražulis,Opus Magnum vol. 5
Saulius Gražulis,Opus Magnum vol. 6
Saulius Gražulis,Opus Magnum vol. 7
Saulius Gražulis,Opus Magnum vol. 8
Saulius Gražulis,Opus Magnum vol. 9
Saulius Gražulis,Opus Magnum vol. 10
Saulius Gražulis,Opus Magnum vol. 11
Saulius Gražulis,Opus Magnum vol. 12

--------------------------b989696a28305e74
Content-Disposition: form-data; name="column:year"

2018
--------------------------b989696a28305e74--
EOF
${INPUT_SCRIPT}

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

rm -f ${TMP_DB_FILE}
