% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_beepr.R
\name{handler_beepr}
\alias{handler_beepr}
\title{Progression Handler: Progress Reported as 'beepr' Sounds (Audio)}
\usage{
handler_beepr(
  initiate = 2L,
  update = 10L,
  finish = 11L,
  interrupt = 9L,
  intrusiveness = getOption("progressr.intrusiveness.audio", 5),
  target = "audio",
  ...
)
}
\arguments{
\item{initiate, update, finish, interrupt}{(integer) Indices of \code{\link[beepr:beep]{beepr::beep()}}
sounds to play when progress starts, is updated, completes, or is
interrupted.  For silence, use \code{NA_integer_}.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[beepr:beep]{beepr::beep()}}.
}
\section{Requirements}{

This progression handler requires the \pkg{beepr} package.
}

\examples{
if (requireNamespace("beepr", quietly = TRUE)) {

  handlers("beepr")
  with_progress({ y <- slow_sum(1:10) })
  print(y)
  
}
}
