% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-point.R
\name{time_point_cast}
\alias{time_point_cast}
\title{Cast a time point between precisions}
\usage{
time_point_cast(x, precision)
}
\arguments{
\item{x}{\verb{[clock_sys_time / clock_naive_time]}

A sys-time or naive-time.}

\item{precision}{\verb{[character(1)]}

A time point precision. One of:
\itemize{
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} cast to the new \code{precision}.
}
\description{
Casting is one way to change a time point's precision.

Casting to a less precise precision will completely drop information that
is more precise than the precision that you are casting to. It does so
in a way that makes it round towards zero. When converting time points
to a less precise precision, you often want \code{\link[=time_point_floor]{time_point_floor()}} instead
of \code{time_point_cast()}, as that handles pre-1970 dates (which are
stored as negative durations) in a more intuitive manner.

Casting to a more precise precision is done through a multiplication by
a conversion factor between the current precision and the new precision.
}
\examples{
# Hour precision time points
# One is pre-1970, one is post-1970
x <- duration_hours(c(25, -25))
x <- as_naive_time(x)
x

# Casting rounds the underlying duration towards 0
cast <- time_point_cast(x, "day")
cast

# Flooring rounds the underlying duration towards negative infinity,
# which is often more intuitive for time points.
# Note that the cast ends up rounding the pre-1970 date up to the next
# day, while the post-1970 date is rounded down.
floor <- time_point_floor(x, "day")
floor

# Casting to a more precise precision, hour->millisecond
time_point_cast(x, "millisecond")
}
