% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_html_style}
\alias{ansi_html_style}
\title{CSS styles for the output of \code{ansi_html()}}
\usage{
ansi_html_style(
  colors = TRUE,
  palette = c("vscode", "dichro", "vga", "winxp", "win10", "macos", "putty", "mirc",
    "xterm", "ubuntu", "eclipse", "iterm", "iterm-pastel", "iterm-smoooooth",
    "iterm-snazzy", "iterm-solarized", "iterm-tango")
)
}
\arguments{
\item{colors}{Whether or not to include colors. \code{FALSE} will not include
colors, \code{TRUE} or \code{8} will include eight colors (plus their bright
variants), \code{256} will include 256 colors.}

\item{palette}{Character scalar, palette to use for the first eight colors
plus their bright variants. Terminals define these colors differently,
and cli includes a couple of examples. Sources of palettes:
\itemize{
\item https://en.wikipedia.org/wiki/ANSI_escape_code#3-bit_and_4-bit
\item iTerm2 builtin palettes
\item \url{https://github.com/sindresorhus/iterm2-snazzy}
}}
}
\value{
Named list of CSS declaration blocks, where the names are
CSS selectors. It has a \code{format()} and \code{print()} methods, which you
can use to write the output to a CSS or HTML file.
}
\description{
CSS styles for the output of \code{ansi_html()}
}
\examples{
ansi_html_style(colors = FALSE)
ansi_html_style(colors = 8, palette = "iterm-snazzy")
}
\seealso{
Other ANSI to HTML conversion: 
\code{\link{ansi_html}()}
}
\concept{ANSI to HTML conversion}
