# Generating Sample Data to help with Testing/Features

## Setup Python

### With Home Assistant (via the `unifiprotect` integration)

1. Make sure you have the _Community_ [SSH & Web Terminal Add-On](https://github.com/hassio-addons/addon-ssh) install
2. Open an SSH or Web terminal to the add-on
3. Run

   ```bash
   docker exec -it homeassistant bash
   ```

Use `/config/ufp-data` for your `-o` argument below.

### Without Home Assistant

1. Ensure Python 3.10+ is installed
2. Install uiprotect by issuing this command: `pip install uiprotect`

Use `./ufp-data` for your `-o` argument below.

## Generate Data

Inside the Python environment from above, run the following command. If you are using Home Assistant, use `-o /config/ufp-data` so it will output data in your config folder to make it easy to get off of your HA instance.

```bash
uiprotect generate-sample-data -o /path/to/ufp-data --actual -w 300 -v -U your-unifi-protect-username -P your-unifi-protect-password -a ip-address-to-unifi-protect
```

This will generate a ton of data from your UniFi Protect instance for 5 minutes. During this time, go do stuff with your sensor to trigger events. When it is all done, you will have a bunch of json files in `/path/to/ufp-data`. Download those and zip them up and send them to us.

It is recommended that you _do not_ post these files publicly as they do have some sensitive data in them related to your UniFi Network. If you would like you manually clean out the sensitive data from these files, feel free.

The most critical data for you to remove are the `authUserId`, `accessKey`, and `users` keys from the `sample_bootstrap.json` file.
