---
name: Bug report
about: Create a report to help us improve
title: ''
labels: ''
assignees: ''
---

# Prerequisites

*Note: You may remove this section prior to submitting your report.*

A small team of volunteers monitors issues. Please help us to help you by making it simple to understand and, if possible,
replicate your issue. Prior to reporting a bug please:

 - [ ] Test the latest release of the library.
 - [ ] Search existing issues.
 - [ ] Read the relevant documentation. 
 - [ ] Review your server configuration and logs.
 - [ ] Consider testing against a different server (e.g. [mqtt.eclipseprojects.io](https://mqtt.eclipseprojects.io/) or [test.mosquitto.org](https://test.mosquitto.org/))
 - [ ] If possible, test using another tool (e.g. [MQTTX](https://mqttx.app/) / [mosquitto_sub](https://mosquitto.org/man/mosquitto_sub-1.html))
     to confirm the issue is specific to this client.
 - [ ] If you are unsure if you have found a bug, please consider asking on [stackoverflow](https://stackoverflow.com/) for a quicker response.

# Bug Description

*Please provide a clear and concise description of the bug.* 

# Reproduction

*Please provide detailed steps showing how to replicate the issue (it's difficult to fix an issue we cannot replicate).
If errors are output then include the full error (including any stack trace).*   
*Most issues should include a [minimal example](https://stackoverflow.com/help/minimal-reproducible-example) that 
demonstrates the issue (ideally one that can be run without modification, i.e. runnable code using a public broker).*

# Environment

* Python version:
* Library version:
* Operating system (including version):
* MQTT server (name, version, configuration, hosting details):

# Logs

For many issues, especially when you cannot provide code to replicate the issue, it's helpful to include logs. Please 
consider including:
 * library logs; see [the readme](https://github.com/eclipse/paho.mqtt.python#enable_logger) and [logger example](https://github.com/eclipse/paho.mqtt.python/blob/master/examples/client_logger.py).
 * broker logs (availability will depend the server in use)


