# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hybridkubernetes.aio import ConnectedKubernetesClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestConnectedKubernetesConnectedClusterOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ConnectedKubernetesClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connected_cluster_begin_create_or_replace(self, resource_group):
        response = await (
            await self.client.connected_cluster.begin_create_or_replace(
                resource_group_name=resource_group.name,
                cluster_name="str",
                connected_cluster={
                    "agentPublicKeyCertificate": "str",
                    "identity": {"type": "SystemAssigned", "principalId": "str", "tenantId": "str"},
                    "location": "str",
                    "aadProfile": {"adminGroupObjectIDs": ["str"], "enableAzureRBAC": bool, "tenantID": "str"},
                    "agentVersion": "str",
                    "arcAgentProfile": {
                        "agentAutoUpgrade": "Enabled",
                        "agentErrors": [
                            {"component": "str", "message": "str", "severity": "str", "time": "2020-02-20 00:00:00"}
                        ],
                        "agentState": "str",
                        "desiredAgentVersion": "str",
                        "systemComponents": [
                            {"currentVersion": "str", "majorVersion": 0, "type": "str", "userSpecifiedVersion": "str"}
                        ],
                    },
                    "arcAgentryConfigurations": [
                        {"feature": "str", "protectedSettings": {"str": "str"}, "settings": {"str": "str"}}
                    ],
                    "azureHybridBenefit": "str",
                    "connectivityStatus": "str",
                    "distribution": "str",
                    "distributionVersion": "str",
                    "gateway": {"enabled": bool, "resourceId": "str"},
                    "id": "str",
                    "infrastructure": "str",
                    "kind": "str",
                    "kubernetesVersion": "str",
                    "lastConnectivityTime": "2020-02-20 00:00:00",
                    "managedIdentityCertificateExpirationTime": "2020-02-20 00:00:00",
                    "miscellaneousProperties": {"str": "str"},
                    "name": "str",
                    "offering": "str",
                    "oidcIssuerProfile": {"enabled": bool, "issuerUrl": "str", "selfHostedIssuerUrl": "str"},
                    "privateLinkScopeResourceId": "str",
                    "privateLinkState": "Disabled",
                    "provisioningState": "str",
                    "securityProfile": {"workloadIdentity": {"enabled": bool}},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "totalCoreCount": 0,
                    "totalNodeCount": 0,
                    "type": "str",
                },
                api_version="2024-12-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connected_cluster_update(self, resource_group):
        response = await self.client.connected_cluster.update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            connected_cluster_patch={
                "azureHybridBenefit": "str",
                "distribution": "str",
                "distributionVersion": "str",
                "tags": {"str": "str"},
            },
            api_version="2024-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connected_cluster_get(self, resource_group):
        response = await self.client.connected_cluster.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connected_cluster_begin_delete(self, resource_group):
        response = await (
            await self.client.connected_cluster.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                api_version="2024-12-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connected_cluster_list_cluster_user_credential(self, resource_group):
        response = await self.client.connected_cluster.list_cluster_user_credential(
            resource_group_name=resource_group.name,
            cluster_name="str",
            properties={"authenticationMethod": "str", "clientProxy": bool},
            api_version="2024-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connected_cluster_list_by_resource_group(self, resource_group):
        response = self.client.connected_cluster.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-12-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connected_cluster_list_by_subscription(self, resource_group):
        response = self.client.connected_cluster.list_by_subscription(
            api_version="2024-12-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
