# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.msi.aio import ManagedServiceIdentityClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestManagedServiceIdentityUserAssignedIdentitiesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ManagedServiceIdentityClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_user_assigned_identities_list_by_subscription(self, resource_group):
        response = self.client.user_assigned_identities.list_by_subscription(
            api_version="2023-01-31",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_user_assigned_identities_list_by_resource_group(self, resource_group):
        response = self.client.user_assigned_identities.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-01-31",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_user_assigned_identities_create_or_update(self, resource_group):
        response = await self.client.user_assigned_identities.create_or_update(
            resource_group_name=resource_group.name,
            resource_name="str",
            parameters={
                "location": "str",
                "clientId": "str",
                "id": "str",
                "name": "str",
                "principalId": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "tenantId": "str",
                "type": "str",
            },
            api_version="2023-01-31",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_user_assigned_identities_update(self, resource_group):
        response = await self.client.user_assigned_identities.update(
            resource_group_name=resource_group.name,
            resource_name="str",
            parameters={
                "clientId": "str",
                "id": "str",
                "location": "str",
                "name": "str",
                "principalId": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "tenantId": "str",
                "type": "str",
            },
            api_version="2023-01-31",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_user_assigned_identities_get(self, resource_group):
        response = await self.client.user_assigned_identities.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-01-31",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_user_assigned_identities_delete(self, resource_group):
        response = await self.client.user_assigned_identities.delete(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-01-31",
        )

        # please add some check logic here by yourself
        # ...
