# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementIpamPoolsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ipam_pools_list(self, resource_group):
        response = self.client.ipam_pools.list(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ipam_pools_begin_create(self, resource_group):
        response = self.client.ipam_pools.begin_create(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            pool_name="str",
            body={
                "location": "str",
                "properties": {
                    "addressPrefixes": ["str"],
                    "description": "str",
                    "displayName": "str",
                    "ipAddressType": ["str"],
                    "parentPoolName": "str",
                    "provisioningState": "str",
                },
                "etag": "str",
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ipam_pools_update(self, resource_group):
        response = self.client.ipam_pools.update(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            pool_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ipam_pools_get(self, resource_group):
        response = self.client.ipam_pools.get(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            pool_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ipam_pools_begin_delete(self, resource_group):
        response = self.client.ipam_pools.begin_delete(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            pool_name="str",
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ipam_pools_get_pool_usage(self, resource_group):
        response = self.client.ipam_pools.get_pool_usage(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            pool_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_ipam_pools_list_associated_resources(self, resource_group):
        response = self.client.ipam_pools.list_associated_resources(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            pool_name="str",
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
