// Pre-include stdlib.h to avoid redefinition of integer type macros (INT8_MIN and similar in generated code)
#if !defined(_MSC_VER) || (_MSC_VER >= 1600) // Visual Studio 2010+
#include "stdint.h"
#endif

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

    /* The c++ scanner is a mess. The FlexLexer.h header file relies on the
     * following macro. This is required in order to pass the c++-multiple-scanners
     * test in the regression suite. We get reports that it breaks inheritance.
     * We will address this in a future release of flex, or omit the C++ scanner
     * altogether.
     */
    #define yyFlexLexer exptocasFlexLexer

#ifdef yyalloc
#define exptocasalloc_ALREADY_DEFINED
#else
#define yyalloc exptocasalloc
#endif

#ifdef yyrealloc
#define exptocasrealloc_ALREADY_DEFINED
#else
#define yyrealloc exptocasrealloc
#endif

#ifdef yyfree
#define exptocasfree_ALREADY_DEFINED
#else
#define yyfree exptocasfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */
#include <iostream>
#include <errno.h>
#include <cstdlib>
#include <cstdio>
#include <cstring>
/* end standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{

	std::streambuf* yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

#define yytext_ptr yytext
#define YY_INTERACTIVE

#include <FlexLexer.h>

inline int yyFlexLexer::yywrap() { return 1; }
int yyFlexLexer::yylex()
	{
	LexerError( "yyFlexLexer::yylex invoked but %option yyclass used" );
	return 0;
	}

#define YY_DECL int exptocas::scanner::yylex()

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 56
#define YY_END_OF_BUFFER 57
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[306] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   44,   44,   57,   54,   52,   55,   40,   40,
       54,   39,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   38,   53,   53,   53,
       53,   53,    3,    3,   14,   14,   49,   49,   46,   46,
       46,   46,   44,   44,   44,   52,    2,    1,   39,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   21,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   38,   53,   53,   53,   53,   53,
        4,    0,    0,    0,   45,   42,   43,   44,   44,   44,

        1,   53,   36,   53,   20,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   19,   53,   53,   53,   53,   53,   37,   53,   53,
       53,   53,   53,    0,    0,   43,   44,   44,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   17,   53,
       53,   53,   53,   24,   48,   53,   53,   30,   53,   53,
       53,    7,   53,   53,   53,   53,   53,   53,    0,    0,
       44,   44,   53,   34,   18,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   35,   53,   53,   53,   53,   53,
       53,   53,   53,   13,   53,   53,   53,    0,    0,    0,

       44,   44,   53,   53,   53,   53,    9,   53,   53,   53,
       53,   22,   53,    5,   15,   25,   53,   53,   29,   53,
       12,   53,   53,    0,    0,    0,   44,   44,   53,   27,
       53,   53,   53,   53,   23,   26,   53,   32,   53,   53,
       53,   11,    0,    0,    0,   44,   44,   31,   53,   53,
       53,   41,   28,   53,    8,   53,    0,    8,    0,   44,
       41,    0,   53,   53,   53,   33,   53,    0,   50,   44,
        0,   53,    6,   53,   10,   10,   44,    0,   53,   16,
       44,    0,   53,   44,    0,   53,   47,    0,   53,    0,
       53,    0,   53,    0,   53,    0,   53,    0,   53,    0,

       53,    0,   53,   51,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    1,    1,    1,    1,    4,    5,
        6,    7,    1,    8,    9,    8,    1,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   11,   12,    1,
       11,    1,    8,    1,   13,   14,   15,   16,   17,   18,
       19,   20,   21,   22,   22,   23,   24,   25,   26,   27,
       28,   29,   30,   31,   32,   33,   34,   22,   35,   22,
       36,    8,   37,    1,   38,    1,   39,   39,   39,   39,

       39,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,    1,   40,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[41] =
    {   0,
        1,    2,    3,    2,    2,    2,    1,    1,    2,    4,
        2,    2,    5,    5,    5,    5,    4,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    1,    1,    4,    4,    2
    } ;

static const flex_int16_t yy_base[316] =
    {   0,
        0,    0,   24,   26,   29,   35,   52,   54,   45,   51,
       61,   62,   79,  119,  412,  413,  409,  413,  403,  413,
      400,  398,   75,   79,  381,    0,  381,  373,  379,   45,
      371,   49,   76,   86,  367,   48,   60,  376,  380,  382,
      373,  372,  413,  390,  413,  370,  413,  369,  413,  389,
      385,  382,    0,  365,  357,  386,  413,    0,  377,    0,
      356,  369,  355,  364,  356,  356,   78,  355,  348,  348,
      358,  352,    0,  358,  343,  360,  349,  351,   83,  341,
      115,  342,  347,  357,  101,  116,  349,  336,  118,  102,
      413,  348,  347,  358,  413,  413,    0,    0,  345,  335,

        0,  328,  332,  344,    0,  333,  325,  316,  332,  328,
      336,  333,  318,  327,  333,  320,  324,  321,  326,  325,
       95,    0,  320,  309,  322,  321,  309,  326,  297,  305,
      312,  294,  314,  292,  291,    0,  290,  312,  297,  296,
      289,  306,  291,  291,  289,  302,  287,  298,    0,  301,
      298,  296,  287,    0,    0,  288,  296,    0,  285,  274,
      279,    0,  275,  113,  289,  272,  121,  275,  129,  274,
      284,  270,  287,    0,    0,  286,  285,  282,  261,  266,
      273,  276,  279,  262,    0,  265,  276,  257,  268,  259,
      254,  267,  248,    0,  265,  256,  250,  254,  243,  245,

      244,  254,  259,  248,  247,  251,    0,  257,  243,  239,
      244,    0,  253,    0,    0,    0,  248,  229,    0,  236,
        0,  231,  244,  229,  232,  235,  232,  230,  224,    0,
      223,  236,  221,  226,    0,    0,  227,    0,  222,  231,
      226,    0,  225,  228,  227,  228,  217,    0,  159,  212,
      210,    0,    0,  179,    0,  164,  163,  413,  181,  161,
        0,  174,  173,  176,  162,    0,  152,  151,  413,  164,
      159,  158,    0,  157,    0,  413,  155,  164,  163,    0,
      153,  139,  138,  163,  159,  158,  413,  146,  141,  141,
      133,  127,  124,  122,  121,  132,  128,   82,   77,   64,

       44,   60,   37,  413,  413,  199,  204,  209,  214,  216,
      221,  223,  228,  233,  237
    } ;

static const flex_int16_t yy_def[316] =
    {   0,
      305,    1,    1,    1,    1,    1,  306,  306,  307,  307,
      308,  308,  309,  309,  305,  305,  305,  305,  305,  305,
      305,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  305,  305,  305,  305,  305,  305,  305,  311,
      305,  305,  312,  312,  312,  305,  305,  313,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      305,  305,  305,  311,  305,  305,  314,  312,  312,  312,

      313,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  305,  305,  314,  312,  312,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  305,  305,
      312,  312,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  305,  305,  305,

      312,  312,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  305,  305,  305,  312,  312,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  305,  305,  305,  312,  312,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  305,  305,  305,  312,
      312,  315,  249,  310,  310,  310,  310,  305,  305,  312,
      305,  310,  310,  310,  310,  305,  312,  305,  310,  310,
      312,  305,  310,  312,  305,  310,  305,  305,  310,  305,
      310,  305,  310,  305,  310,  305,  310,  305,  310,  305,

      310,  305,  310,  305,    0,  305,  305,  305,  305,  305,
      305,  305,  305,  305,  305
    } ;

static const flex_int16_t yy_nxt[454] =
    {   0,
       16,   17,   18,   16,   19,   20,   16,   20,   21,   22,
       20,   20,   23,   24,   25,   26,   27,   28,   26,   26,
       29,   26,   30,   26,   31,   32,   26,   26,   33,   34,
       35,   36,   26,   26,   26,   20,   20,   37,   37,   16,
       38,   26,   38,   26,   40,   41,   26,   18,  304,   42,
       40,   41,   26,   18,   18,   42,   18,   39,   44,   39,
       44,   46,   39,   18,   18,   70,   73,   46,   39,   85,
       71,  304,   83,   74,  303,   75,   84,   48,   48,   49,
       49,   18,   50,   51,   49,   49,   49,   52,   61,   49,
       49,   64,   76,  108,  302,   54,   55,   85,   85,   62,

       78,  301,   79,   63,   65,  121,  300,   77,  109,  110,
       85,  157,  158,  122,   49,   49,   80,   81,   49,   49,
       49,   18,   50,   51,   49,   49,   49,   52,  124,   49,
       49,  129,  112,  132,  133,   54,   55,  196,   85,   85,
      299,  125,  178,  193,  298,  198,  109,  110,  109,  110,
      178,  297,  296,  295,   49,   49,  294,  293,   49,  199,
      262,  262,  262,  262,  262,  292,  291,  262,  263,  262,
      262,  290,  289,  288,  287,  286,  285,  284,  283,  282,
      281,  280,  279,  278,  277,  276,  275,  274,  273,  272,
      271,  270,  269,  268,  267,  266,  263,  263,  262,   43,

       43,   43,   43,   43,   45,   45,   45,   45,   45,   47,
       47,   47,   47,   47,   53,   53,   53,   53,   53,   60,
       60,   94,   94,   94,   94,   94,   98,   98,  101,  101,
      265,  101,  101,  136,  136,  264,  136,  136,  262,  262,
      262,  261,  260,  259,  258,  257,  256,  255,  254,  253,
      252,  251,  250,  249,  248,  247,  246,  245,  244,  243,
      242,  241,  240,  239,  238,  237,  236,  235,  234,  233,
      232,  231,  230,  229,  228,  227,  226,  225,  224,  223,
      222,  221,  220,  219,  218,  217,  216,  215,  214,  213,
      212,  211,  210,  209,  208,  207,  206,  205,  204,  203,

      202,  201,  200,  197,  195,  194,  192,  191,  190,  189,
      188,  187,  186,  185,  184,  183,  182,  181,  180,  179,
      178,  177,  176,  175,  174,  173,  172,  171,  170,  169,
      168,  167,  166,  165,  164,  128,  163,  162,  161,  160,
      159,  156,  155,  154,  153,  152,  151,  150,  149,  148,
      147,  146,  145,  144,  143,  142,  141,  140,  139,  138,
      137,   95,  135,  134,  131,  130,  128,  127,  126,  123,
      120,  119,  118,  117,  116,  115,  114,  113,  112,  111,
      107,  106,  105,  104,  103,  102,   59,   56,  100,   99,
       97,   96,   95,   93,   92,   91,   90,   89,   88,   87,

       86,   82,   72,   69,   68,   67,   66,   59,   58,   57,
       56,  305,   15,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305
    } ;

static const flex_int16_t yy_chk[454] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        3,    3,    4,    4,    5,    5,    5,    9,  303,    5,
        6,    6,    6,   10,    7,    6,    8,    3,    7,    4,
        8,    9,    5,   11,   12,   30,   32,   10,    6,   37,
       30,  302,   36,   32,  301,   32,   36,   11,   12,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   23,   13,
       13,   24,   33,   67,  300,   13,   13,   37,   37,   23,

       34,  299,   34,   23,   24,   79,  298,   33,   67,   67,
       85,  121,  121,   79,   13,   13,   34,   34,   13,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   81,   14,
       14,   86,   90,   89,   90,   14,   14,  167,   85,   85,
      297,   81,  164,  164,  296,  169,   86,   86,   89,   89,
      167,  295,  294,  293,   14,   14,  292,  291,   14,  169,
      249,  249,  249,  249,  249,  290,  289,  249,  249,  249,
      249,  288,  286,  285,  284,  283,  282,  281,  279,  278,
      277,  274,  272,  271,  270,  268,  267,  265,  264,  263,
      262,  260,  259,  257,  256,  254,  249,  249,  249,  306,

      306,  306,  306,  306,  307,  307,  307,  307,  307,  308,
      308,  308,  308,  308,  309,  309,  309,  309,  309,  310,
      310,  311,  311,  311,  311,  311,  312,  312,  313,  313,
      251,  313,  313,  314,  314,  250,  314,  314,  315,  315,
      315,  247,  246,  245,  244,  243,  241,  240,  239,  237,
      234,  233,  232,  231,  229,  228,  227,  226,  225,  224,
      223,  222,  220,  218,  217,  213,  211,  210,  209,  208,
      206,  205,  204,  203,  202,  201,  200,  199,  198,  197,
      196,  195,  193,  192,  191,  190,  189,  188,  187,  186,
      184,  183,  182,  181,  180,  179,  178,  177,  176,  173,

      172,  171,  170,  168,  166,  165,  163,  161,  160,  159,
      157,  156,  153,  152,  151,  150,  148,  147,  146,  145,
      144,  143,  142,  141,  140,  139,  138,  137,  135,  134,
      133,  132,  131,  130,  129,  128,  127,  126,  125,  124,
      123,  120,  119,  118,  117,  116,  115,  114,  113,  112,
      111,  110,  109,  108,  107,  106,  104,  103,  102,  100,
       99,   94,   93,   92,   88,   87,   84,   83,   82,   80,
       78,   77,   76,   75,   74,   72,   71,   70,   69,   68,
       66,   65,   64,   63,   62,   61,   59,   56,   55,   54,
       52,   51,   50,   48,   46,   44,   42,   41,   40,   39,

       38,   35,   31,   29,   28,   27,   25,   22,   21,   19,
       17,   15,  305,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET

// Created:	Thu Oct 28 12:21:16 1999
// Author:	Andrey BETENEV
// Copyright (c) 1999-2020 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

/*****************************************************************************

This LEX scanner is performs lexical analysis of EXPRESS schema file   
for EXPRESS -> CASCADE/XSTEP classes generator                             

On the stage of lexical scanner comments (single- and multi-line),         
definitions of CONSTANT, FUNCTION, RULE items and clauses WHERE, INVERSE
and DERIVE of TYPE amd ENTITY items are dismissed (ignored)         

Then, keywords such as ENTITY, SUPERTYPE, SET etc., names of items         
and special symbols are identified and returned to parser (yacc) as tokens 

Also, error processing and current line number tracking functions are defined

*****************************************************************************/

/************************************/
/* Section 1                        */
/* definitions                      */

#include <stdlib.h>
#include <string.h>

#include <TColStd_HSequenceOfHAsciiString.hxx>
#include <Express_HSequenceOfField.hxx>
#include <Express_HSequenceOfItem.hxx>
#include <Express_Field.hxx>
#include <Express_Item.hxx>
#include <Express_Type.hxx>
#include <Express_Schema.hxx>
#include <Express_Reference.hxx>

#include "exptocas.tab.hxx"       /* define tokens */

/* Auxiliary functions */

static int fun_level=0;
static int ec_linenum=1;
static int ec_state = 0;

int yywrap(void) { return 1; }

int ec_curline ( void )
{
  return ec_linenum;
}

int ec_error ( const std::string& s, const std::string& text )
{
  printf ( "\nError at line %d: %s \"%s\"\n", ec_curline(), s.c_str(), text.c_str() );
  return 0;
}

/*
    c++                 generate C++ parser class
*/
#define YY_NO_UNISTD_H 1

// Tell flex which function to define
#ifdef  YY_DECL
# undef YY_DECL
#endif
#define YY_DECL int exptocas::scanner::lex (exptocas::parser::semantic_type* yylval)

typedef exptocas::parser::token token;

/************************************/
/* Section 2                        */
/* parsing rules                    */

#define INITIAL 0
#define TYP 1
#define ENT 2
#define COMM 3
#define SKP 4
#define RULE 5
#define FUN 6

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif
    
#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
#define ECHO LexerOutput( yytext, yyleng )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
\
	if ( (int)(result = LexerInput( (char *) buf, max_size )) < 0 ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) LexerError( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
#define YY_DECL int yyFlexLexer::yylex()
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin.rdbuf(std::cin.rdbuf());

		if ( ! yyout )
			yyout.rdbuf(std::cout.rdbuf());

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 306 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 413 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
{ /* Eat line comments */ }
	YY_BREAK
case 2:
YY_RULE_SETUP
{ ec_state = YYSTATE; BEGIN(COMM); }
	YY_BREAK
case 3:
YY_RULE_SETUP
{ /* Eat multiline comments */ }
	YY_BREAK
case 4:
YY_RULE_SETUP
{ BEGIN(ec_state); }
	YY_BREAK
case 5:
YY_RULE_SETUP
{ return yylval->num = token::KSCHEM; }
	YY_BREAK
case 6:
YY_RULE_SETUP
{ return yylval->num = token::KENDS; }
	YY_BREAK
case 7:
YY_RULE_SETUP
{ BEGIN(TYP); return yylval->num = token::KTYP; }
	YY_BREAK
case 8:
YY_RULE_SETUP
{ BEGIN(0);   return yylval->num = token::KENDT; }
	YY_BREAK
case 9:
YY_RULE_SETUP
{ BEGIN(ENT); return yylval->num = token::KENT; }
	YY_BREAK
case 10:
YY_RULE_SETUP
{ BEGIN(0);  return yylval->num = token::KENDE; }
	YY_BREAK
case 11:
case 12:
case 13:
YY_RULE_SETUP
{ BEGIN(SKP); }
	YY_BREAK
case 14:
YY_RULE_SETUP
{ /* eat contents of WHERE and DERIVE subclauses of ENTITY and TYPE */ }
	YY_BREAK
case 15:
YY_RULE_SETUP
{ return yylval->num = token::KSEL; }
	YY_BREAK
case 16:
YY_RULE_SETUP
{ return yylval->num = token::KENUM; }
	YY_BREAK
case 17:
YY_RULE_SETUP
{ return yylval->num = token::KLIST; }
	YY_BREAK
case 18:
YY_RULE_SETUP
{ return yylval->num = token::KARR; }
	YY_BREAK
case 19:
YY_RULE_SETUP
{ return yylval->num = token::KSET; }
	YY_BREAK
case 20:
YY_RULE_SETUP
{ return yylval->num = token::KBAG; }
	YY_BREAK
case 21:
YY_RULE_SETUP
{ return yylval->num = token::KOF; }
	YY_BREAK
case 22:
YY_RULE_SETUP
{ return yylval->num = token::KNUM; }
	YY_BREAK
case 23:
YY_RULE_SETUP
{ return yylval->num = token::KINT; }
	YY_BREAK
case 24:
YY_RULE_SETUP
{ return yylval->num = token::KDBL; }
	YY_BREAK
case 25:
YY_RULE_SETUP
{ return yylval->num = token::KSTR; }
	YY_BREAK
case 26:
YY_RULE_SETUP
{ return yylval->num = token::KLOG; }
	YY_BREAK
case 27:
YY_RULE_SETUP
{ return yylval->num = token::KBOOL; }
	YY_BREAK
case 28:
YY_RULE_SETUP
{ return yylval->num = token::KOPT; }
	YY_BREAK
case 29:
YY_RULE_SETUP
{ return yylval->num = token::KUNIQ; }
	YY_BREAK
case 30:
YY_RULE_SETUP
{ return yylval->num = token::KSELF; }
	YY_BREAK
case 31:
YY_RULE_SETUP
{ return yylval->num = token::KABSTR; }
	YY_BREAK
case 32:
YY_RULE_SETUP
{ return yylval->num = token::KSUBT; }
	YY_BREAK
case 33:
YY_RULE_SETUP
{ return yylval->num = token::KSPRT; }
	YY_BREAK
case 34:
YY_RULE_SETUP
{ return yylval->num = token::KANDOR; }
	YY_BREAK
case 35:
YY_RULE_SETUP
{ return yylval->num = token::K1OF; }
	YY_BREAK
case 36:
YY_RULE_SETUP
{ return yylval->num = token::KAND; }
	YY_BREAK
case 37:
YY_RULE_SETUP
{ yylval->str = strdup ( yytext ); return token::NAME; }
	YY_BREAK
case 38:
YY_RULE_SETUP
{ yylval->str = strdup ( yytext ); return token::NAME; }
	YY_BREAK
case 39:
YY_RULE_SETUP
{ yylval->num = atoi ( yytext ); return token::NUMBER; }
	YY_BREAK
case 40:
YY_RULE_SETUP
{ return yylval->num = yytext[0]; }
	YY_BREAK
case 41:
YY_RULE_SETUP
{ BEGIN(FUN); fun_level++; }
	YY_BREAK
case 42:
YY_RULE_SETUP
{ ec_state = YYSTATE; BEGIN(COMM); /* eat comments in functions */ }
	YY_BREAK
case 43:
YY_RULE_SETUP
{ /* Eat line comments in functions */ }
	YY_BREAK
case 44:
YY_RULE_SETUP
{ /* eat FUNCTIONs - skip IDs explicitly */ }
	YY_BREAK
case 45:
/* rule 45 can match eol */
YY_RULE_SETUP
{ /* eat FUNCTIONs - skip strings explicitly */ }
	YY_BREAK
case 46:
YY_RULE_SETUP
{ /* eat FUNCTIONs - skip all other symbols in functions */ }
	YY_BREAK
case 47:
YY_RULE_SETUP
{ fun_level--; if ( ! fun_level ) BEGIN(0); }
	YY_BREAK
case 48:
YY_RULE_SETUP
{ BEGIN(RULE); /* eat RULEs */ }
	YY_BREAK
case 49:
YY_RULE_SETUP
{ /* eat RULEs */ }
	YY_BREAK
case 50:
YY_RULE_SETUP
{ BEGIN(0); }
	YY_BREAK
case 51:
/* rule 51 can match eol */
YY_RULE_SETUP
{ /* eat CONSTANTs */
                       char *s = yytext; /* but don't forget to count lines.. */
                       while ( *s ) if ( *(s++) == '\n' ) ec_linenum++;
                     }
	YY_BREAK
case 52:
YY_RULE_SETUP
{ /* eat spaces */ }
	YY_BREAK
case 53:
YY_RULE_SETUP
{ ec_error ( "unknown keyword ", yytext ); /* put unrecognized keywords to cerr */ }
	YY_BREAK
case 54:
YY_RULE_SETUP
{ ec_error ( "unknown symbol ", yytext ); /* put unrecognized data to cerr */ }
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
{ ec_linenum++; /* count lines */ }
	YY_BREAK
case 56:
YY_RULE_SETUP
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(TYP):
case YY_STATE_EOF(ENT):
case YY_STATE_EOF(COMM):
case YY_STATE_EOF(SKP):
case YY_STATE_EOF(RULE):
case YY_STATE_EOF(FUN):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin.rdbuf();
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* The contents of this function are C++ specific, so the () macro is not used.
 * This constructor simply maintains backward compatibility.
 * DEPRECATED
 */
yyFlexLexer::yyFlexLexer( std::istream* arg_yyin, std::ostream* arg_yyout ):
	yyin(arg_yyin ? arg_yyin->rdbuf() : std::cin.rdbuf()),
	yyout(arg_yyout ? arg_yyout->rdbuf() : std::cout.rdbuf())
{
	ctor_common();
}

/* The contents of this function are C++ specific, so the () macro is not used.
 */
yyFlexLexer::yyFlexLexer( std::istream& arg_yyin, std::ostream& arg_yyout ):
	yyin(arg_yyin.rdbuf()),
	yyout(arg_yyout.rdbuf())
{
	ctor_common();
}

/* The contents of this function are C++ specific, so the () macro is not used.
 */
void yyFlexLexer::ctor_common()
{
	yy_c_buf_p = 0;
	yy_init = 0;
	yy_start = 0;
	yy_flex_debug = 0;
	yylineno = 1;	// this will only get updated if %option yylineno

	yy_did_buffer_switch_on_eof = 0;

	yy_looking_for_trail_begin = 0;
	yy_more_flag = 0;
	yy_more_len = 0;
	yy_more_offset = yy_prev_more_offset = 0;

	yy_start_stack_ptr = yy_start_stack_depth = 0;
	yy_start_stack = NULL;

	yy_buffer_stack = NULL;
	yy_buffer_stack_top = 0;
	yy_buffer_stack_max = 0;

	yy_state_buf = 0;

}

/* The contents of this function are C++ specific, so the () macro is not used.
 */
yyFlexLexer::~yyFlexLexer()
{
	delete [] yy_state_buf;
	yyfree( yy_start_stack  );
	yy_delete_buffer( YY_CURRENT_BUFFER );
	yyfree( yy_buffer_stack  );
}

/* The contents of this function are C++ specific, so the () macro is not used.
 */
void yyFlexLexer::switch_streams( std::istream& new_in, std::ostream& new_out )
{
	// was if( new_in )
	yy_delete_buffer( YY_CURRENT_BUFFER );
	yy_switch_to_buffer( yy_create_buffer( new_in, YY_BUF_SIZE  ) );

	// was if( new_out )
	yyout.rdbuf(new_out.rdbuf());
}

/* The contents of this function are C++ specific, so the () macro is not used.
 */
void yyFlexLexer::switch_streams( std::istream* new_in, std::ostream* new_out )
{
	if( ! new_in ) {
		new_in = &yyin;
	}

	if ( ! new_out ) {
		new_out = &yyout;
	}

	switch_streams(*new_in, *new_out);
}

#ifdef YY_INTERACTIVE
int yyFlexLexer::LexerInput( char* buf, int /* max_size */ )
#else
int yyFlexLexer::LexerInput( char* buf, int max_size )
#endif
{
	if ( yyin.eof() || yyin.fail() )
		return 0;

#ifdef YY_INTERACTIVE
	yyin.get( buf[0] );

	if ( yyin.eof() )
		return 0;

	if ( yyin.bad() )
		return -1;

	return 1;

#else
	(void) yyin.read( buf, max_size );

	if ( yyin.bad() )
		return -1;
	else
		return yyin.gcount();
#endif
}

void yyFlexLexer::LexerOutput( const char* buf, int size )
{
	(void) yyout.write( buf, size );
}

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
int yyFlexLexer::yy_get_next_buffer()
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    yy_state_type yyFlexLexer::yy_get_previous_state()
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 306 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    yy_state_type yyFlexLexer::yy_try_NUL_trans( yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 306 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 305);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT
    void yyFlexLexer::yyunput( int c, char* yy_bp)
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}
#endif

    int yyFlexLexer::yyinput()
{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyFlexLexer::yyrestart( std::istream& input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Delegate to the new version that takes an istream reference.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
void yyFlexLexer::yyrestart( std::istream* input_file )
{
	if( ! input_file ) {
		input_file = &yyin;
	}
	yyrestart( *input_file );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yyFlexLexer::yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

    void yyFlexLexer::yy_load_buffer_state()
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin.rdbuf(YY_CURRENT_BUFFER_LVALUE->yy_input_file);
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yyFlexLexer::yy_create_buffer( std::istream& file, int size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Delegate creation of buffers to the new version that takes an istream reference.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
	YY_BUFFER_STATE yyFlexLexer::yy_create_buffer( std::istream* file, int size )
{
	return yy_create_buffer( *file, size );
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yyFlexLexer::yy_delete_buffer( YY_BUFFER_STATE b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    void yyFlexLexer::yy_init_buffer( YY_BUFFER_STATE b, std::istream& file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file.rdbuf();
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

	b->yy_is_interactive = 0;
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yyFlexLexer::yy_flush_buffer( YY_BUFFER_STATE b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yyFlexLexer::yypush_buffer_state (YY_BUFFER_STATE new_buffer)
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yyFlexLexer::yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
void yyFlexLexer::yyensure_buffer_stack(void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

    void yyFlexLexer::yy_push_state( int _new_state )
{
    	if ( (yy_start_stack_ptr) >= (yy_start_stack_depth) )
		{
		yy_size_t new_size;

		(yy_start_stack_depth) += YY_START_STACK_INCR;
		new_size = (yy_size_t) (yy_start_stack_depth) * sizeof( int );

		if ( ! (yy_start_stack) )
			(yy_start_stack) = (int *) yyalloc( new_size  );

		else
			(yy_start_stack) = (int *) yyrealloc(
					(void *) (yy_start_stack), new_size  );

		if ( ! (yy_start_stack) )
			YY_FATAL_ERROR( "out of memory expanding start-condition stack" );
		}

	(yy_start_stack)[(yy_start_stack_ptr)++] = YY_START;

	BEGIN(_new_state);
}

    void yyFlexLexer::yy_pop_state()
{
    	if ( --(yy_start_stack_ptr) < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN((yy_start_stack)[(yy_start_stack_ptr)]);
}

    int yyFlexLexer::yy_top_state()
{
    	return (yy_start_stack)[(yy_start_stack_ptr) - 1];
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

void yyFlexLexer::LexerError( const char* msg )
{
    	std::cerr << msg << std::endl;
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

/************************************/
/* Section 3                        */
/* auxiliary procedures             */

exptocas::scanner::scanner(std::istream* in, std::ostream* out)
    : exptocasFlexLexer(in, out)
{
}

/*
int main ( void )
{
  yylex();
}
*/

