/*
 * Decompiled with CFR 0.152.
 */
package gov.pnnl.bse.nwchem;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.util.NSProperty;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.axis.client.Call;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.BasisSetBrowse;
import org.scidac.cmcs.tools.bse.BasisSetDescriptor;
import org.scidac.cmcs.tools.bse.BseCall;

public class Test {
    private static HashMap ecpNameMappings = null;
    private static long lastUpdatedECPMappingTime = 0L;
    private static long minTimeOutTime = 60000L;
    private static Logger log = Logger.getLogger(Test.class.getPackage().getName());
    private static final String BSECONTRIB_PWD = "vg4Judsm";

    public static void main(String[] args) {
        String dataServer = "https://bse.pnl.gov/sam";
        String descUrl = "/files/projects/Basis_Set_Curators/Gaussian/emsl-lib/LANL2DZDPECP-AGG.xml";
        String bsElts = "H C N O F Si P S Cl Ge As Se Br Sn Sb Te I Pb Bi";
        String hostIp = "0.0.0.0";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostIp = addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            log.info("Can't get host ip.");
        }
        try {
            Call call = BseCall.getCall("getBasisSetNwchem");
            log.info(dataServer + descUrl);
            log.info(bsElts);
            String bsdata = (String)call.invoke(new Object[]{dataServer + descUrl, "true", bsElts, "nwchem-library", "lisong.sun@pnl.gov", "Lisong Sun", hostIp, "false"});
            System.out.println("bsdata " + bsdata);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static HashMap getECPNameMappings() {
        if (ecpNameMappings != null && new Date().getTime() - lastUpdatedECPMappingTime < minTimeOutTime) {
            log.info("Returning existing name mapping");
            return ecpNameMappings;
        }
        ecpNameMappings = new HashMap();
        lastUpdatedECPMappingTime = new Date().getTime();
        BSEProperties props = BSEProperties.getBSEProperties();
        String dataServer = props.getProperty("BseDataServer");
        String rootUrl = props.getProperty("Gaussian");
        Vector returnProps = props.getPropertyAsNSPropertyVector("PropertyList");
        Vector<NSProperty> searchProps = new Vector<NSProperty>();
        searchProps.add(new NSProperty("http://purl.org/dc/elements/1.1/:format"));
        Hashtable bsList = null;
        try {
            DSI dsi = new DSI(dataServer + rootUrl, "bsecontrib", BSECONTRIB_PWD);
            log.info("DSI " + dsi);
            bsList = dsi.searchMetaData(returnProps, searchProps, Integer.MAX_VALUE, "chemical/x-emsl-ecp");
            log.info("BS LIST " + bsList);
        }
        catch (StatusException e) {
            log.severe("Error getting ecps for mapping " + e.getMessage());
            System.err.println("Error getting ecps for mapping " + e.getMessage());
            e.printStackTrace();
        }
        if (bsList != null) {
            BasisSetBrowse bsbrowse = new BasisSetBrowse(0, bsList);
            for (BasisSetDescriptor desc : bsbrowse.getBasisSets()) {
                if (!desc.getCurationStatus().equals("published")) continue;
                String nameUsedInLink = desc.getUrl();
                String nwChemTitle = Test.convertBsNameToNWChem(desc.getName());
                if (nameUsedInLink.indexOf("/") > -1) {
                    nameUsedInLink = nameUsedInLink.substring(nameUsedInLink.lastIndexOf("/") + 1);
                }
                log.info("putting " + nameUsedInLink + " " + nwChemTitle);
                ecpNameMappings.put(nameUsedInLink, nwChemTitle);
            }
        }
        return ecpNameMappings;
    }

    protected static String convertBsNameToNWChem(String bsName) {
        String newName = bsName.toLowerCase();
        if (newName.indexOf(42) >= 0) {
            newName = newName.replace('*', 's');
        }
        if (newName.indexOf(40) >= 0) {
            newName = newName.replaceAll("\\(", "");
        }
        if (newName.indexOf(41) >= 0) {
            newName = newName.replaceAll("\\)", "");
        }
        if (newName.indexOf(" ") >= 0) {
            newName = newName.replaceAll(" ", "_");
        }
        if (newName.indexOf(",") >= 0) {
            newName = newName.replaceAll(",", "_");
        }
        if (newName.indexOf("/") >= 0) {
            newName = newName.replaceAll("/", "_");
        }
        return newName;
    }
}

