/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.util.Hashtable;
import java.util.Vector;

public class TestSinglePropFind {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Does a propfind for a named property");
            System.err.println("Usage: TestPropFind <url> <ns:propname>");
            System.exit(-1);
        }
        String url = args[0];
        NSProperty nsProp = new NSProperty(args[1]);
        Vector<NSProperty> propVec = new Vector<NSProperty>();
        propVec.add(nsProp);
        DialogAuthListener dal = new DialogAuthListener();
        DSI dsi = new DSI(url, dal);
        try {
            Hashtable props = dsi.getMetaData(propVec);
            if (props != null) {
                for (Object tmp : props.keySet()) {
                    DSIProperty prop = (DSIProperty)props.get(tmp);
                    String propVal = prop.getPropertyAsString().trim();
                    if (propVal.length() == 0) {
                        propVal = prop.getPropertyAsXMLString(true).trim();
                    }
                    System.out.println(prop.getPropertyKey() + "=" + propVal);
                }
            } else {
                System.out.println("propfind is null");
            }
        }
        catch (StatusException ex) {
            System.out.println(ex.getMessage());
            System.out.println(LoggerUtils.getStackTrace(ex));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(LoggerUtils.getStackTrace(e));
        }
        System.exit(0);
    }
}

