/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Return a regular expression to parse a regular expression string.
*
* @module @stdlib/regexp/regexp
*
* @example
* var reRegExp = require( '@stdlib/regexp/regexp' );
*
* var RE_REGEXP = reRegExp();
*
* var bool = RE_REGEXP.test( '/^beep$/' );
* // returns true
*
* bool = RE_REGEXP.test( '' );
* // returns false
*
* @example
* var reRegExp = require( '@stdlib/regexp/regexp' );
*
* var RE_REGEXP = reRegExp();
*
* var parts = RE_REGEXP.exec( '/^.*$/ig' );
* // returns [ '/^.*$/ig', '^.*$', 'ig', 'index': 0, 'input': '/^.*$/ig' ]
*/

// MAIN //

var setReadOnly = require( '@stdlib/utils/define-nonenumerable-read-only-property' );
var reRegExp = require( './main.js' );
var REGEXP = require( './regexp.js' );


// MAIN //

setReadOnly( reRegExp, 'REGEXP', REGEXP );


// EXPORTS //

module.exports = reRegExp;


// EXPORTS //

module.exports = reRegExp;
