/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

public final class ZipLong
implements Cloneable {
    private long value;

    public ZipLong(long value) {
        this.value = value;
    }

    public ZipLong(byte[] bytes) {
        this(bytes, 0);
    }

    public ZipLong(byte[] bytes, int offset) {
        this.value = (long)(bytes[offset + 3] << 24) & 0xFF000000L;
        this.value += (long)(bytes[offset + 2] << 16 & 0xFF0000);
        this.value += (long)(bytes[offset + 1] << 8 & 0xFF00);
        this.value += (long)(bytes[offset] & 0xFF);
    }

    public byte[] getBytes() {
        byte[] result = new byte[]{(byte)(this.value & 0xFFL), (byte)((this.value & 0xFF00L) >> 8), (byte)((this.value & 0xFF0000L) >> 16), (byte)((this.value & 0xFF000000L) >> 24)};
        return result;
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ZipLong)) {
            return false;
        }
        return this.value == ((ZipLong)o).getValue();
    }

    public int hashCode() {
        return (int)this.value;
    }
}

