
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file GraphShadeAttributes.h
    \\brief Definition of GraphShade Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "GraphShadeAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

GraphShadeAttributes::GraphShadeAttributes():
	
	style_(MagTranslator<string, GraphShadeStyle>().magics("graph_shade_style"))
	 
{
} 


GraphShadeAttributes::~GraphShadeAttributes()
{
	
}

    
void GraphShadeAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	
	setMember(prefix, "graph_shade_style", style_, params);
	
}

void GraphShadeAttributes::copy(const GraphShadeAttributes& other)
{
	style_ = unique_ptr<GraphShadeStyle>(other.style_->clone());
	
} 


bool GraphShadeAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	if ( acceptNode(node, style_) )
		return true;
	
	return false;
}

void GraphShadeAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), style_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), style_, *elt); 
		
	}
}

void GraphShadeAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " style = " <<  *style_;
	
	out << "]" << "\n";
}

void GraphShadeAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"graph_shade_style\":";
	style_->toxml(out);
	
}

static MagicsParameter<string> graph_shade_style("graph_shade_style", "area_fill", ""); 
#include "GraphShadeStyle.h"
static SimpleObjectMaker<GraphShadeStyle , GraphShadeStyle> solid_GraphShadeStyle("solid");
static SimpleObjectMaker<GraphShadeStyle , GraphShadeStyle> area_fill_GraphShadeStyle("area_fill");
static SimpleObjectMaker<HatchGraphShadeStyle , GraphShadeStyle> hatch_HatchGraphShadeStyle("hatch");
static SimpleObjectMaker<DotGraphShadeStyle , GraphShadeStyle> dot_DotGraphShadeStyle("dot");
