/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "bankdata.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "./bankdata_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */
GWEN_LIST_FUNCTIONS(AQFINTS_BANKDATA, AQFINTS_BankData)


AQFINTS_BANKDATA *AQFINTS_BankData_new(void)
{
  AQFINTS_BANKDATA *p_struct;

  GWEN_NEW_OBJECT(AQFINTS_BANKDATA, p_struct)
  p_struct->_refCount=1;
  GWEN_LIST_INIT(AQFINTS_BANKDATA, p_struct)
  /* members */
  p_struct->version=0;
  p_struct->country=0;
  p_struct->bankCode=NULL;
  p_struct->bankName=NULL;
  p_struct->jobTypesPerMsg=0;
  p_struct->maxMsgSize=0;
  p_struct->minTimeout=0;
  p_struct->maxTimeout=0;
  memset(p_struct->hbciVersions, 0, (9)*sizeof(int));
  memset(p_struct->languages, 0, (9)*sizeof(int));
  p_struct->runtimeFlags=0;
  /* virtual functions */

  return p_struct;
}

void AQFINTS_BankData_free(AQFINTS_BANKDATA *p_struct)
{
  if (p_struct) {
    assert(p_struct->_refCount);
    if (p_struct->_refCount==1) {
      GWEN_LIST_FINI(AQFINTS_BANKDATA, p_struct)
      /* members */
      free(p_struct->bankCode);
      p_struct->bankCode=NULL;
      free(p_struct->bankName);
      p_struct->bankName=NULL;
      p_struct->_refCount=0;
      GWEN_FREE_OBJECT(p_struct);
    }
    else
      p_struct->_refCount--;
  }
}

void AQFINTS_BankData_Attach(AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

AQFINTS_BANKDATA *AQFINTS_BankData_dup(const AQFINTS_BANKDATA *p_src)
{
  AQFINTS_BANKDATA *p_struct;

  assert(p_src);
  p_struct=AQFINTS_BankData_new();
  /* member "version" */
  p_struct->version=p_src->version;

  /* member "country" */
  p_struct->country=p_src->country;

  /* member "bankCode" */
  if (p_struct->bankCode) {
    free(p_struct->bankCode);
    p_struct->bankCode=NULL;
    p_struct->bankCode=NULL;
  }
  if (p_src->bankCode) {
    p_struct->bankCode=strdup(p_src->bankCode);
  }

  /* member "bankName" */
  if (p_struct->bankName) {
    free(p_struct->bankName);
    p_struct->bankName=NULL;
    p_struct->bankName=NULL;
  }
  if (p_src->bankName) {
    p_struct->bankName=strdup(p_src->bankName);
  }

  /* member "jobTypesPerMsg" */
  p_struct->jobTypesPerMsg=p_src->jobTypesPerMsg;

  /* member "maxMsgSize" */
  p_struct->maxMsgSize=p_src->maxMsgSize;

  /* member "minTimeout" */
  p_struct->minTimeout=p_src->minTimeout;

  /* member "maxTimeout" */
  p_struct->maxTimeout=p_src->maxTimeout;

  /* member "hbciVersions" */
  memmove(p_struct->hbciVersions, p_src->hbciVersions, (9)*sizeof(int));

  /* member "languages" */
  memmove(p_struct->languages, p_src->languages, (9)*sizeof(int));

  /* member "runtimeFlags" */
  p_struct->runtimeFlags=p_src->runtimeFlags;

  return p_struct;
}

AQFINTS_BANKDATA *AQFINTS_BankData_copy(AQFINTS_BANKDATA *p_struct, const AQFINTS_BANKDATA *p_src)
{
  assert(p_struct);
  assert(p_src);
  /* member "version" */
  p_struct->version=p_src->version;

  /* member "country" */
  p_struct->country=p_src->country;

  /* member "bankCode" */
  if (p_struct->bankCode) {
    free(p_struct->bankCode);
    p_struct->bankCode=NULL;
    p_struct->bankCode=NULL;
  }
  if (p_src->bankCode) {
    p_struct->bankCode=strdup(p_src->bankCode);
  }

  /* member "bankName" */
  if (p_struct->bankName) {
    free(p_struct->bankName);
    p_struct->bankName=NULL;
    p_struct->bankName=NULL;
  }
  if (p_src->bankName) {
    p_struct->bankName=strdup(p_src->bankName);
  }

  /* member "jobTypesPerMsg" */
  p_struct->jobTypesPerMsg=p_src->jobTypesPerMsg;

  /* member "maxMsgSize" */
  p_struct->maxMsgSize=p_src->maxMsgSize;

  /* member "minTimeout" */
  p_struct->minTimeout=p_src->minTimeout;

  /* member "maxTimeout" */
  p_struct->maxTimeout=p_src->maxTimeout;

  /* member "hbciVersions" */
  memmove(p_struct->hbciVersions, p_src->hbciVersions, (9)*sizeof(int));

  /* member "languages" */
  memmove(p_struct->languages, p_src->languages, (9)*sizeof(int));

  /* member "runtimeFlags" */
  p_struct->runtimeFlags=p_src->runtimeFlags;

  return p_struct;
}

int AQFINTS_BankData_GetVersion(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->version;
}

int AQFINTS_BankData_GetCountry(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->country;
}

const char *AQFINTS_BankData_GetBankCode(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->bankCode;
}

const char *AQFINTS_BankData_GetBankName(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->bankName;
}

int AQFINTS_BankData_GetJobTypesPerMsg(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->jobTypesPerMsg;
}

int AQFINTS_BankData_GetMaxMsgSize(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->maxMsgSize;
}

int AQFINTS_BankData_GetMinTimeout(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->minTimeout;
}

int AQFINTS_BankData_GetMaxTimeout(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->maxTimeout;
}

const int *AQFINTS_BankData_GetHbciVersions(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->hbciVersions;
}

const int *AQFINTS_BankData_GetLanguages(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->languages;
}

uint32_t AQFINTS_BankData_GetRuntimeFlags(const AQFINTS_BANKDATA *p_struct)
{
  assert(p_struct);
  return p_struct->runtimeFlags;
}

void AQFINTS_BankData_SetVersion(AQFINTS_BANKDATA *p_struct, int p_src)
{
  assert(p_struct);
  p_struct->version=p_src;
}

void AQFINTS_BankData_SetCountry(AQFINTS_BANKDATA *p_struct, int p_src)
{
  assert(p_struct);
  p_struct->country=p_src;
}

void AQFINTS_BankData_SetBankCode(AQFINTS_BANKDATA *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->bankCode) {
    free(p_struct->bankCode);
    p_struct->bankCode=NULL;
  }
  if (p_src) {
    p_struct->bankCode=strdup(p_src);
  }
  else {
    p_struct->bankCode=NULL;
  }
}

void AQFINTS_BankData_SetBankName(AQFINTS_BANKDATA *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->bankName) {
    free(p_struct->bankName);
    p_struct->bankName=NULL;
  }
  if (p_src) {
    p_struct->bankName=strdup(p_src);
  }
  else {
    p_struct->bankName=NULL;
  }
}

void AQFINTS_BankData_SetJobTypesPerMsg(AQFINTS_BANKDATA *p_struct, int p_src)
{
  assert(p_struct);
  p_struct->jobTypesPerMsg=p_src;
}

void AQFINTS_BankData_SetMaxMsgSize(AQFINTS_BANKDATA *p_struct, int p_src)
{
  assert(p_struct);
  p_struct->maxMsgSize=p_src;
}

void AQFINTS_BankData_SetMinTimeout(AQFINTS_BANKDATA *p_struct, int p_src)
{
  assert(p_struct);
  p_struct->minTimeout=p_src;
}

void AQFINTS_BankData_SetMaxTimeout(AQFINTS_BANKDATA *p_struct, int p_src)
{
  assert(p_struct);
  p_struct->maxTimeout=p_src;
}

void AQFINTS_BankData_SetHbciVersions(AQFINTS_BANKDATA *p_struct, const int *p_src)
{
  assert(p_struct);
  memmove(p_struct->hbciVersions, p_src, (9)*sizeof(int));
}

void AQFINTS_BankData_SetLanguages(AQFINTS_BANKDATA *p_struct, const int *p_src)
{
  assert(p_struct);
  memmove(p_struct->languages, p_src, (9)*sizeof(int));
}

void AQFINTS_BankData_SetRuntimeFlags(AQFINTS_BANKDATA *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->runtimeFlags=p_src;
}

void AQFINTS_BankData_AddRuntimeFlags(AQFINTS_BANKDATA *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->runtimeFlags|=p_src;
}

void AQFINTS_BankData_SubRuntimeFlags(AQFINTS_BANKDATA *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->runtimeFlags&=~p_src;
}

/* list1 functions */
AQFINTS_BANKDATA_LIST *AQFINTS_BankData_List_dup(const AQFINTS_BANKDATA_LIST *p_src)
{
  AQFINTS_BANKDATA_LIST *p_dest;
  AQFINTS_BANKDATA *p_elem;

  assert(p_src);
  p_dest=AQFINTS_BankData_List_new();
  p_elem=AQFINTS_BankData_List_First(p_src);
  while (p_elem) {
    AQFINTS_BANKDATA *p_cpy;

    p_cpy=AQFINTS_BankData_dup(p_elem);
    AQFINTS_BankData_List_Add(p_cpy, p_dest);
    p_elem=AQFINTS_BankData_List_Next(p_elem);
  }

  return p_dest;
}

void AQFINTS_BankData_ReadDb(AQFINTS_BANKDATA *p_struct, GWEN_DB_NODE *p_db)
{
  assert(p_struct);
  /* member "version" */
  p_struct->version=GWEN_DB_GetIntValue(p_db, "version", 0, 0);

  /* member "country" */
  p_struct->country=GWEN_DB_GetIntValue(p_db, "country", 0, 0);

  /* member "bankCode" */
  if (p_struct->bankCode) {
    free(p_struct->bankCode);
    p_struct->bankCode=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "bankCode", 0, NULL);
    if (s)
      p_struct->bankCode=strdup(s);
  }
  if (p_struct->bankCode==NULL) {
    p_struct->bankCode=NULL;
  }

  /* member "bankName" */
  if (p_struct->bankName) {
    free(p_struct->bankName);
    p_struct->bankName=NULL;
  }
  {
    const char *s;
    s=GWEN_DB_GetCharValue(p_db, "bankName", 0, NULL);
    if (s)
      p_struct->bankName=strdup(s);
  }
  if (p_struct->bankName==NULL) {
    p_struct->bankName=NULL;
  }

  /* member "jobTypesPerMsg" */
  p_struct->jobTypesPerMsg=GWEN_DB_GetIntValue(p_db, "jobTypesPerMsg", 0, 0);

  /* member "maxMsgSize" */
  p_struct->maxMsgSize=GWEN_DB_GetIntValue(p_db, "maxMsgSize", 0, 0);

  /* member "minTimeout" */
  p_struct->minTimeout=GWEN_DB_GetIntValue(p_db, "minTimeout", 0, 0);

  /* member "maxTimeout" */
  p_struct->maxTimeout=GWEN_DB_GetIntValue(p_db, "maxTimeout", 0, 0);

  /* member "hbciVersions" */
  {
    int i;
    memset(p_struct->hbciVersions, 0, (9)*sizeof(int));
    for (i=0; i < 9; i++) {
      int v;
      v=GWEN_DB_GetIntValue(p_db, "hbciVersions", i, 0);
      if (v==0)
        break;
      p_struct->hbciVersions[i]=v;
    }
  }

  /* member "languages" */
  {
    int i;
    memset(p_struct->languages, 0, (9)*sizeof(int));
    for (i=0; i < 9; i++) {
      int v;
      v=GWEN_DB_GetIntValue(p_db, "languages", i, 0);
      if (v==0)
        break;
      p_struct->languages[i]=v;
    }
  }

  /* member "runtimeFlags" */
  /* member "runtimeFlags" is volatile, just presetting */
  p_struct->runtimeFlags=0;

}

int AQFINTS_BankData_WriteDb(const AQFINTS_BANKDATA *p_struct, GWEN_DB_NODE *p_db)
{
  int p_rv;

  assert(p_struct);
  /* member "version" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "version", p_struct->version);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "country" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "country", p_struct->country);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "bankCode" */
  if (p_struct->bankCode)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "bankCode", p_struct->bankCode);
  else {
    GWEN_DB_DeleteVar(p_db, "bankCode");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "bankName" */
  if (p_struct->bankName)
    p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "bankName", p_struct->bankName);
  else {
    GWEN_DB_DeleteVar(p_db, "bankName");
    p_rv=0;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "jobTypesPerMsg" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "jobTypesPerMsg", p_struct->jobTypesPerMsg);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "maxMsgSize" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "maxMsgSize", p_struct->maxMsgSize);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "minTimeout" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "minTimeout", p_struct->minTimeout);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "maxTimeout" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "maxTimeout", p_struct->maxTimeout);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "hbciVersions" */
  {
    int i=0;
    int result=0;
    GWEN_DB_DeleteVar(p_db, "hbciVersions");
    for (i=0; i < 9; i++) {
      result=GWEN_DB_SetIntValue(p_db, 0, "hbciVersions", p_struct->hbciVersions[i]);
    }
    p_rv=result;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "languages" */
  {
    int i=0;
    int result=0;
    GWEN_DB_DeleteVar(p_db, "languages");
    for (i=0; i < 9; i++) {
      result=GWEN_DB_SetIntValue(p_db, 0, "languages", p_struct->languages[i]);
    }
    p_rv=result;
  }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "runtimeFlags" is volatile, not writing to db */

  return 0;
}

AQFINTS_BANKDATA *AQFINTS_BankData_fromDb(GWEN_DB_NODE *p_db)
{
  AQFINTS_BANKDATA *p_struct;
  p_struct=AQFINTS_BankData_new();
  AQFINTS_BankData_ReadDb(p_struct, p_db);
  return p_struct;
}

int AQFINTS_BankData_toDb(const AQFINTS_BANKDATA *p_struct, GWEN_DB_NODE *p_db)
{
  return AQFINTS_BankData_WriteDb(p_struct, p_db);
}

int AQFINTS_BankData_GetHbciVersionsAt(const AQFINTS_BANKDATA *p_struct, int idx)
{
  if (p_struct && (idx < 9))
    return p_struct->hbciVersions[idx];
  return 0;
}
int AQFINTS_BankData_SetHbciVersionsAt(AQFINTS_BANKDATA *p_struct, int idx, int v)
{
  if (p_struct && (idx < 9)) {
    p_struct->hbciVersions[idx]=v;
    return 0;
  }
  return GWEN_ERROR_INVALID;
}
void AQFINTS_BankData_PresetHbciVersions(AQFINTS_BANKDATA *p_struct, int v)
{
  int i;
  for (i=0; i < 9; i++)
    p_struct->hbciVersions[i]=v;
}
int AQFINTS_BankData_GetLanguagesAt(const AQFINTS_BANKDATA *p_struct, int idx)
{
  if (p_struct && (idx < 9))
    return p_struct->languages[idx];
  return 0;
}
int AQFINTS_BankData_SetLanguagesAt(AQFINTS_BANKDATA *p_struct, int idx, int v)
{
  if (p_struct && (idx < 9)) {
    p_struct->languages[idx]=v;
    return 0;
  }
  return GWEN_ERROR_INVALID;
}
void AQFINTS_BankData_PresetLanguages(AQFINTS_BANKDATA *p_struct, int v)
{
  int i;
  for (i=0; i < 9; i++)
    p_struct->languages[i]=v;
}

/* code headers */

