/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_APP_WINDOW_HEADER
#define LIFEOGRAPH_APP_WINDOW_HEADER

#define LIFEOGRAPH_DEVELOPMENT_VERSION


#include <gtkmm.h>

#include "helpers.hpp"
#include "settings.hpp"
#include "ui_login.hpp"
#include "ui_entry.hpp"
#include "ui_diary.hpp"
#include "ui_extra.hpp"


namespace LIFEO
{

class AppWindow : public Gtk::ApplicationWindow
{
    public:
        enum InfoResponse { RESP_OK = 10, RESP_UNDO_REMOVE_DIARY = 20 };

                                    AppWindow( BaseObjectType*,
                                               const Glib::RefPtr<Gtk::Builder>& );
                                    ~AppWindow();
        static AppWindow*           p;

        void                        update_title();

        void                        enter_selection_mode()
        { m_Hb_main->get_style_context()->add_class( "selection-mode" ); }
        void                        exit_selection_mode()
        { m_Hb_main->get_style_context()->remove_class( "selection-mode" ); }

        bool                        confirm_dismiss_element( const Ustring&,
                                                             Gtk::Widget* = nullptr );

        void                        login();
        bool                        finish_login_session( bool = true );
        void                        logout( bool );

        void                        handle_login();
        void                        handle_edit_enabled();
        void                        handle_logout();

        void                        handle_undo();
        void                        handle_redo();

        static void                 show_about();

        void                        show_info( Gtk::MessageType, const Ustring&,
                                               const Ustring& = "",
                                               InfoResponse = RESP_OK );
        void                        handle_infobar_response( int );
        void                        hide_infobar();

        bool                        write_backup();

        void                        refresh_panels();

        // METHODS INVOLVING MULTIPLE PANELS AT ONCE
        void                        show_entry( Entry* );

        // AUTO LOGOUT FUNCTIONALITY
        bool                        handle_idle();
        void                        freeze_auto_logout();
        void                        unfreeze_auto_logout();
        void                        update_auto_logout_count_down();
        void                        disable_auto_logout_for_the_session();
        void                        reenable_auto_logout_for_the_session();
        bool                        is_auto_logout_in_use()
        { return( m_auto_logout_freeze_level == 0 ); }
        void                        handle_auto_logout_toggled();
        void                        update_toggle_auto_logout_gui( bool = false );

        bool                        on_event( GdkEvent* ) override;

        // UI FUNCTIONALITY
        UILogin*                    UI_login{ nullptr };
        UIDiary*                    UI_diary{ nullptr };
        UIEntry*                    UI_entry{ nullptr };
        UIExtra*                    UI_extra{ nullptr };

    protected:
        bool                        on_delete_event( GdkEventAny* ) override;

        // WIDGETS
        Gtk::Box*                   m_Bx_main;
        Gtk::HeaderBar*             m_Hb_main;
        Gtk::Stack*                 m_St_main{ nullptr };
        Gtk::InfoBar*               m_IB_info;
        Gtk::Label*                 m_L_info;
        Gtk::Button*                m_B_info;

        Gtk::Paned*                 m_paned_entry{ nullptr };
        Gtk::Paned*                 m_paned_main{ nullptr };

        Gtk::Button*                m_B_back;

        sigc::connection            m_connection_backup;

        int                         m_seconds_remaining{ LOGOUT_COUNTDOWN + 1 };
        sigc::connection            m_connection_timeout;
        int                         m_auto_logout_freeze_level{ 1 }; // reflects the result of all factors
        InfoResponse                m_resp_cur; // FIXME: a most unfortunate solution!!
        bool                        m_flag_info_is_visible{ false };

        // ACTIONS
        Action                      m_A_toggle_auto_logout;
        Action                      m_A_logout_wo_saving;
        Action                      m_A_show_preferences;
};

} // end of namespace LIFEO

#endif
