/*
Jaxe - Editeur XML en Java

Copyright (C) 2010 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package jaxe.wxs;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;

import org.w3c.dom.Element;

import jaxe.JaxeException;


public class WXSInclude extends WXSAnnotated {
    
    protected String schemaLocation = null; // URI
    
    protected WXSSchema schemaInclu = null;
    
    
    public WXSInclude(final Element el, final WXSSchema schema) {
        parseAnnotation(el);
        if (el.getAttributeNode("schemaLocation") != null)
            schemaLocation = el.getAttribute("schemaLocation");
    }
    
    protected void inclusions(final WXSSchema schema) throws JaxeException {
        schemaInclu = schema.nouveauSchemaInclu(schemaLocation, null, schema);
    }
    
}
