#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER1="mailto:vincent.vole@example.com"
USER2="mailto:harvey.horse@example.com"
SENDER="mailto:paul.boddie@example.com"

mkdir -p "$PREFS/$USER1"
echo 'Europe/Oslo' > "$PREFS/$USER1/TZID"
echo 'share' > "$PREFS/$USER1/freebusy_sharing"

mkdir -p "$PREFS/$USER2"
echo 'Europe/Oslo' > "$PREFS/$USER2/TZID"
echo 'share' > "$PREFS/$USER2/freebusy_sharing"

mkdir -p "$PREFS/$SENDER"
echo 'Europe/Oslo' > "$PREFS/$SENDER/TZID"

# Test free/busy responses.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/fb-request-person-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/fb-request-person.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& ! grep -q '^FREEBUSY' out1.tmp \
&& echo "Success" \
|| echo "Failed"

# Publish an event, testing registration in the outgoing handler.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring-rdate.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out1f.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out1f.tmp" \
&& echo "Success" \
|| echo "Failed"

# There should be an event created by the sender.

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "object" "event26@example.com" \
>  out1O.tmp

   grep -q 'event26@example.com' "out1O.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test registration in the incoming handler for the recipients.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring-rdate.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   ! grep -q 'METHOD:REPLY' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out2f.tmp

   ! grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy_other" "$SENDER" \
>  out2o.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out2o.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out2f2.tmp

   ! grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out2f2.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy_other" "$SENDER" \
>  out2o2.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out2o2.tmp" \
&& echo "Success" \
|| echo "Failed"

# There should be an event created by the sender.

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "object" "event26@example.com" \
>  out2O.tmp

   grep -q 'event26@example.com' "out2O.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "object" "event26@example.com" \
>  out2O2.tmp

   grep -q 'event26@example.com' "out2O2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test acceptance and registration in the outgoing handler.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER1" "event26@example.com" 2>> $ERROR \
| tee out3.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out3f.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER2" "event26@example.com" 2>> $ERROR \
| tee out32.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out3f2.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out3f2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test registration in the incoming handler.

  "$PERSON_SCRIPT" $ARGS < out3.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out4f.tmp

   [ `grep "event26@example.com" "out4f.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out4f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy_other" "$SENDER" \
>  out4o.tmp

   [ `grep "event26@example.com" "out4o.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out4o.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < out32.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out42.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out4f2.tmp

   [ `grep "event26@example.com" "out4f2.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out4f2.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy_other" "$SENDER" \
>  out4o2.tmp

   [ `grep "event26@example.com" "out4o2.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out4o2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test recurrence declining in the outgoing handler.
# Only the first user declines.

  "$DECLINE_SCRIPT" $DECLINE_ARGS "$USER1" "20141011T100000" "20141011T110000" "event26@example.com" "20141011T100000" 2>> $ERROR \
| tee out5.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out5s.tmp

   [ `grep "event26@example.com" "out5s.tmp" | wc -l` = '1' ] \
&& ! grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out5s.tmp" \
&& echo "Success" \
|| echo "Failed"

# There should be a recurrence created by the user.

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "object" "event26@example.com" \
>  out5O.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "recurrence" "event26@example.com" "20141011T100000" \
>  out5R.tmp

   grep -q 'event26@example.com' "out5O.tmp" \
&& grep -q 'event26@example.com' "out5R.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test declining in the incoming handler.

  "$PERSON_SCRIPT" $ARGS < out5.tmp 2>> $ERROR \
| tee out6r.tmp \
| "$SHOWMAIL" \
> out6.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out6f.tmp

   [ `grep "event26@example.com" "out6f.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out6f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER1" \
>  out6o.tmp

   [ `grep "event26@example.com" "out6o.tmp" | wc -l` = '1' ] \
&& ! grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out6o.tmp" \
&& echo "Success" \
|| echo "Failed"

# The second user is still attending the original event.

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER2" \
>  out6o2.tmp

   [ `grep "event26@example.com" "out6o2.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out6o2.tmp" \
&& echo "Success" \
|| echo "Failed"

# There should be a recurrence created by the user.

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "object" "event26@example.com" \
>  out6O.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "recurrence" "event26@example.com" "20141011T100000" \
>  out6R.tmp

   grep -q 'event26@example.com' "out6O.tmp" \
&& grep -q 'event26@example.com' "out6R.tmp" \
&& echo "Success" \
|| echo "Failed"

# This should cause the organiser to tell the second user about the recurrence.

   grep -q 'METHOD:REQUEST' out6.tmp \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < out6r.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out62.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "object" "event26@example.com" \
>  out6O2.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "recurrence" "event26@example.com" "20141011T100000" \
>  out6R2.tmp

# The second user's schedule should remain unchanged.
# NOTE: The nature of the periods might need to change, with the recurrence
# NOTE: taking over the affected period.

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out6f2.tmp

   [ `grep "event26@example.com" "out6f2.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out6f2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test recurrence acceptance in the outgoing handler.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER1" "20141011T100000" "20141011T110000" "event26@example.com" "20141011T100000" 2>> $ERROR \
| tee out7.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out7s.tmp

   [ `grep "event26@example.com" "out7s.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out7s.tmp" \
&& echo "Success" \
|| echo "Failed"

# There should still be a recurrence created by the user.

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "object" "event26@example.com" \
>  out7O.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "recurrence" "event26@example.com" "20141011T100000" \
>  out7R.tmp

   grep -q 'event26@example.com' "out7O.tmp" \
&& grep -q 'event26@example.com' "out7R.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test acceptance in the incoming handler.

  "$PERSON_SCRIPT" $ARGS < out7.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out8.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out8f.tmp

   [ `grep "event26@example.com" "out8f.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out8f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER1" \
>  out8o.tmp

   [ `grep "event26@example.com" "out8o.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out8o.tmp" \
&& echo "Success" \
|| echo "Failed"

# The second user should not have been affected.

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER2" \
>  out8o2.tmp

   [ `grep "event26@example.com" "out8o2.tmp" | wc -l` = '2' ] \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out8o2.tmp" \
&& echo "Success" \
|| echo "Failed"

# There should be a recurrence created by the user.

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "object" "event26@example.com" \
>  out8O.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "recurrence" "event26@example.com" "20141011T100000" \
>  out8R.tmp

   grep -q 'event26@example.com' "out8O.tmp" \
&& grep -q 'event26@example.com' "out8R.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test recurrence declining in the outgoing handler.
# Now the second user declines the parent event.

  "$DECLINE_SCRIPT" $DECLINE_ARGS "$USER2" "event26@example.com" 2>> $ERROR \
| tee out9.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out9s.tmp

   [ `grep "event26@example.com" "out9s.tmp" | wc -l` = '0' ] \
&& ! grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out9s.tmp" \
&& ! grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out9s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test declining in the incoming handler.

  "$PERSON_SCRIPT" $ARGS < out9.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out10.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out10f.tmp

   [ `grep "event26@example.com" "out10f.tmp" | wc -l` = '2' ] \
&& grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out10f.tmp" \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out10f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER2" \
>  out10o.tmp

   [ `grep "event26@example.com" "out10o.tmp" | wc -l` = '1' ] \
&& ! grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out10o.tmp" \
&& grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out10o.tmp" \
&& echo "Success" \
|| echo "Failed"
