-- Copyright 2004-2023 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

CREATE TABLE TEST(ID INT);
> ok

INSERT INTO TEST VALUES (1), (2), (3);
> update count: 3

DELETE FROM TEST WHERE EXISTS (SELECT X FROM SYSTEM_RANGE(1, 3) WHERE X = ID) AND ROWNUM() = 1;
> update count: 1

SELECT ID FROM TEST;
> ID
> --
> 2
> 3
> rows: 2

DROP TABLE TEST;
> ok

CREATE TABLE TEST(ID INT PRIMARY KEY) AS SELECT * FROM SYSTEM_RANGE(1, 13);
> ok

DELETE FROM TEST WHERE ID <= 12 FETCH FIRST ROW ONLY;
> update count: 1

DELETE FROM TEST WHERE ID <= 12 FETCH FIRST ROWS ONLY;
> update count: 1

DELETE FROM TEST WHERE ID <= 12 FETCH NEXT ROW ONLY;
> update count: 1

DELETE FROM TEST WHERE ID <= 12 FETCH NEXT ROWS ONLY;
> update count: 1

DELETE FROM TEST WHERE ID <= 12 FETCH FIRST 2 ROW ONLY;
> update count: 2

DELETE FROM TEST WHERE ID <= 12 FETCH FIRST 2 ROWS ONLY;
> update count: 2

DELETE FROM TEST WHERE ID <= 12 FETCH NEXT 2 ROW ONLY;
> update count: 2

DELETE FROM TEST WHERE ID <= 12 FETCH NEXT 2 ROWS ONLY;
> update count: 2

EXPLAIN DELETE FROM TEST WHERE ID <= 12 FETCH FIRST 2 ROWS ONLY;
>> DELETE FROM "PUBLIC"."TEST" /* PUBLIC.PRIMARY_KEY_2: ID <= 12 */ WHERE "ID" <= 12 FETCH FIRST 2 ROWS ONLY

EXPLAIN DELETE FROM TEST FETCH FIRST 1 ROW ONLY;
>> DELETE FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */ FETCH FIRST ROW ONLY

EXPLAIN DELETE FROM TEST;
>> DELETE FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */

TABLE TEST;
>> 13

DROP TABLE TEST;
> ok

CREATE TABLE TEST(id int) AS SELECT x FROM system_range(1, 100);
> ok

SET MODE MSSQLServer;
> ok

DELETE TOP 10 FROM TEST;
> update count: 10

SET MODE Regular;
> ok

SELECT COUNT(*) FROM TEST;
>> 90

DELETE FROM TEST LIMIT ((SELECT COUNT(*) FROM TEST) / 10);
> update count: 9

SELECT COUNT(*) FROM TEST;
>> 81

EXPLAIN DELETE FROM TEST LIMIT ((SELECT COUNT(*) FROM TEST) / 10);
>> DELETE FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */ FETCH FIRST (SELECT COUNT(*) FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */ /* direct lookup */) / 10 ROWS ONLY

DELETE FROM TEST LIMIT ?;
{
10
};
> update count: 10

SELECT COUNT(*) FROM TEST;
>> 71

DROP TABLE TEST;
> ok
