//*
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//*
// These .proto interfaces are private and stable.
// Please see http://wiki.apache.org/hadoop/Compatibility
// for what changes are allowed for a *stable* .proto interface.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: encryption.proto

package hadoop_hdfs

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ReencryptActionProto int32

const (
	ReencryptActionProto_CANCEL_REENCRYPT ReencryptActionProto = 1
	ReencryptActionProto_START_REENCRYPT  ReencryptActionProto = 2
)

// Enum value maps for ReencryptActionProto.
var (
	ReencryptActionProto_name = map[int32]string{
		1: "CANCEL_REENCRYPT",
		2: "START_REENCRYPT",
	}
	ReencryptActionProto_value = map[string]int32{
		"CANCEL_REENCRYPT": 1,
		"START_REENCRYPT":  2,
	}
)

func (x ReencryptActionProto) Enum() *ReencryptActionProto {
	p := new(ReencryptActionProto)
	*p = x
	return p
}

func (x ReencryptActionProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReencryptActionProto) Descriptor() protoreflect.EnumDescriptor {
	return file_encryption_proto_enumTypes[0].Descriptor()
}

func (ReencryptActionProto) Type() protoreflect.EnumType {
	return &file_encryption_proto_enumTypes[0]
}

func (x ReencryptActionProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ReencryptActionProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ReencryptActionProto(num)
	return nil
}

// Deprecated: Use ReencryptActionProto.Descriptor instead.
func (ReencryptActionProto) EnumDescriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{0}
}

type ReencryptionStateProto int32

const (
	ReencryptionStateProto_SUBMITTED  ReencryptionStateProto = 1
	ReencryptionStateProto_PROCESSING ReencryptionStateProto = 2
	ReencryptionStateProto_COMPLETED  ReencryptionStateProto = 3
)

// Enum value maps for ReencryptionStateProto.
var (
	ReencryptionStateProto_name = map[int32]string{
		1: "SUBMITTED",
		2: "PROCESSING",
		3: "COMPLETED",
	}
	ReencryptionStateProto_value = map[string]int32{
		"SUBMITTED":  1,
		"PROCESSING": 2,
		"COMPLETED":  3,
	}
)

func (x ReencryptionStateProto) Enum() *ReencryptionStateProto {
	p := new(ReencryptionStateProto)
	*p = x
	return p
}

func (x ReencryptionStateProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReencryptionStateProto) Descriptor() protoreflect.EnumDescriptor {
	return file_encryption_proto_enumTypes[1].Descriptor()
}

func (ReencryptionStateProto) Type() protoreflect.EnumType {
	return &file_encryption_proto_enumTypes[1]
}

func (x ReencryptionStateProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ReencryptionStateProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ReencryptionStateProto(num)
	return nil
}

// Deprecated: Use ReencryptionStateProto.Descriptor instead.
func (ReencryptionStateProto) EnumDescriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{1}
}

type CreateEncryptionZoneRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src     *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
	KeyName *string `protobuf:"bytes,2,opt,name=keyName" json:"keyName,omitempty"`
}

func (x *CreateEncryptionZoneRequestProto) Reset() {
	*x = CreateEncryptionZoneRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEncryptionZoneRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEncryptionZoneRequestProto) ProtoMessage() {}

func (x *CreateEncryptionZoneRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEncryptionZoneRequestProto.ProtoReflect.Descriptor instead.
func (*CreateEncryptionZoneRequestProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{0}
}

func (x *CreateEncryptionZoneRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

func (x *CreateEncryptionZoneRequestProto) GetKeyName() string {
	if x != nil && x.KeyName != nil {
		return *x.KeyName
	}
	return ""
}

type CreateEncryptionZoneResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateEncryptionZoneResponseProto) Reset() {
	*x = CreateEncryptionZoneResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEncryptionZoneResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEncryptionZoneResponseProto) ProtoMessage() {}

func (x *CreateEncryptionZoneResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEncryptionZoneResponseProto.ProtoReflect.Descriptor instead.
func (*CreateEncryptionZoneResponseProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{1}
}

type ListEncryptionZonesRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id *int64 `protobuf:"varint,1,req,name=id" json:"id,omitempty"`
}

func (x *ListEncryptionZonesRequestProto) Reset() {
	*x = ListEncryptionZonesRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEncryptionZonesRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEncryptionZonesRequestProto) ProtoMessage() {}

func (x *ListEncryptionZonesRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEncryptionZonesRequestProto.ProtoReflect.Descriptor instead.
func (*ListEncryptionZonesRequestProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{2}
}

func (x *ListEncryptionZonesRequestProto) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

type EncryptionZoneProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id                    *int64                      `protobuf:"varint,1,req,name=id" json:"id,omitempty"`
	Path                  *string                     `protobuf:"bytes,2,req,name=path" json:"path,omitempty"`
	Suite                 *CipherSuiteProto           `protobuf:"varint,3,req,name=suite,enum=hadoop.hdfs.CipherSuiteProto" json:"suite,omitempty"`
	CryptoProtocolVersion *CryptoProtocolVersionProto `protobuf:"varint,4,req,name=cryptoProtocolVersion,enum=hadoop.hdfs.CryptoProtocolVersionProto" json:"cryptoProtocolVersion,omitempty"`
	KeyName               *string                     `protobuf:"bytes,5,req,name=keyName" json:"keyName,omitempty"`
}

func (x *EncryptionZoneProto) Reset() {
	*x = EncryptionZoneProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncryptionZoneProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionZoneProto) ProtoMessage() {}

func (x *EncryptionZoneProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionZoneProto.ProtoReflect.Descriptor instead.
func (*EncryptionZoneProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{3}
}

func (x *EncryptionZoneProto) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *EncryptionZoneProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *EncryptionZoneProto) GetSuite() CipherSuiteProto {
	if x != nil && x.Suite != nil {
		return *x.Suite
	}
	return CipherSuiteProto_UNKNOWN
}

func (x *EncryptionZoneProto) GetCryptoProtocolVersion() CryptoProtocolVersionProto {
	if x != nil && x.CryptoProtocolVersion != nil {
		return *x.CryptoProtocolVersion
	}
	return CryptoProtocolVersionProto_UNKNOWN_PROTOCOL_VERSION
}

func (x *EncryptionZoneProto) GetKeyName() string {
	if x != nil && x.KeyName != nil {
		return *x.KeyName
	}
	return ""
}

type ListEncryptionZonesResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Zones   []*EncryptionZoneProto `protobuf:"bytes,1,rep,name=zones" json:"zones,omitempty"`
	HasMore *bool                  `protobuf:"varint,2,req,name=hasMore" json:"hasMore,omitempty"`
}

func (x *ListEncryptionZonesResponseProto) Reset() {
	*x = ListEncryptionZonesResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEncryptionZonesResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEncryptionZonesResponseProto) ProtoMessage() {}

func (x *ListEncryptionZonesResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEncryptionZonesResponseProto.ProtoReflect.Descriptor instead.
func (*ListEncryptionZonesResponseProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{4}
}

func (x *ListEncryptionZonesResponseProto) GetZones() []*EncryptionZoneProto {
	if x != nil {
		return x.Zones
	}
	return nil
}

func (x *ListEncryptionZonesResponseProto) GetHasMore() bool {
	if x != nil && x.HasMore != nil {
		return *x.HasMore
	}
	return false
}

type ReencryptEncryptionZoneRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Action *ReencryptActionProto `protobuf:"varint,1,req,name=action,enum=hadoop.hdfs.ReencryptActionProto" json:"action,omitempty"`
	Zone   *string               `protobuf:"bytes,2,req,name=zone" json:"zone,omitempty"`
}

func (x *ReencryptEncryptionZoneRequestProto) Reset() {
	*x = ReencryptEncryptionZoneRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReencryptEncryptionZoneRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReencryptEncryptionZoneRequestProto) ProtoMessage() {}

func (x *ReencryptEncryptionZoneRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReencryptEncryptionZoneRequestProto.ProtoReflect.Descriptor instead.
func (*ReencryptEncryptionZoneRequestProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{5}
}

func (x *ReencryptEncryptionZoneRequestProto) GetAction() ReencryptActionProto {
	if x != nil && x.Action != nil {
		return *x.Action
	}
	return ReencryptActionProto_CANCEL_REENCRYPT
}

func (x *ReencryptEncryptionZoneRequestProto) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

type ReencryptEncryptionZoneResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReencryptEncryptionZoneResponseProto) Reset() {
	*x = ReencryptEncryptionZoneResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReencryptEncryptionZoneResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReencryptEncryptionZoneResponseProto) ProtoMessage() {}

func (x *ReencryptEncryptionZoneResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReencryptEncryptionZoneResponseProto.ProtoReflect.Descriptor instead.
func (*ReencryptEncryptionZoneResponseProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{6}
}

type ListReencryptionStatusRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id *int64 `protobuf:"varint,1,req,name=id" json:"id,omitempty"`
}

func (x *ListReencryptionStatusRequestProto) Reset() {
	*x = ListReencryptionStatusRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReencryptionStatusRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReencryptionStatusRequestProto) ProtoMessage() {}

func (x *ListReencryptionStatusRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReencryptionStatusRequestProto.ProtoReflect.Descriptor instead.
func (*ListReencryptionStatusRequestProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{7}
}

func (x *ListReencryptionStatusRequestProto) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

type ZoneReencryptionStatusProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id               *int64                  `protobuf:"varint,1,req,name=id" json:"id,omitempty"`
	Path             *string                 `protobuf:"bytes,2,req,name=path" json:"path,omitempty"`
	State            *ReencryptionStateProto `protobuf:"varint,3,req,name=state,enum=hadoop.hdfs.ReencryptionStateProto" json:"state,omitempty"`
	EzKeyVersionName *string                 `protobuf:"bytes,4,req,name=ezKeyVersionName" json:"ezKeyVersionName,omitempty"`
	SubmissionTime   *int64                  `protobuf:"varint,5,req,name=submissionTime" json:"submissionTime,omitempty"`
	Canceled         *bool                   `protobuf:"varint,6,req,name=canceled" json:"canceled,omitempty"`
	NumReencrypted   *int64                  `protobuf:"varint,7,req,name=numReencrypted" json:"numReencrypted,omitempty"`
	NumFailures      *int64                  `protobuf:"varint,8,req,name=numFailures" json:"numFailures,omitempty"`
	CompletionTime   *int64                  `protobuf:"varint,9,opt,name=completionTime" json:"completionTime,omitempty"`
	LastFile         *string                 `protobuf:"bytes,10,opt,name=lastFile" json:"lastFile,omitempty"`
}

func (x *ZoneReencryptionStatusProto) Reset() {
	*x = ZoneReencryptionStatusProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZoneReencryptionStatusProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZoneReencryptionStatusProto) ProtoMessage() {}

func (x *ZoneReencryptionStatusProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZoneReencryptionStatusProto.ProtoReflect.Descriptor instead.
func (*ZoneReencryptionStatusProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{8}
}

func (x *ZoneReencryptionStatusProto) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *ZoneReencryptionStatusProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *ZoneReencryptionStatusProto) GetState() ReencryptionStateProto {
	if x != nil && x.State != nil {
		return *x.State
	}
	return ReencryptionStateProto_SUBMITTED
}

func (x *ZoneReencryptionStatusProto) GetEzKeyVersionName() string {
	if x != nil && x.EzKeyVersionName != nil {
		return *x.EzKeyVersionName
	}
	return ""
}

func (x *ZoneReencryptionStatusProto) GetSubmissionTime() int64 {
	if x != nil && x.SubmissionTime != nil {
		return *x.SubmissionTime
	}
	return 0
}

func (x *ZoneReencryptionStatusProto) GetCanceled() bool {
	if x != nil && x.Canceled != nil {
		return *x.Canceled
	}
	return false
}

func (x *ZoneReencryptionStatusProto) GetNumReencrypted() int64 {
	if x != nil && x.NumReencrypted != nil {
		return *x.NumReencrypted
	}
	return 0
}

func (x *ZoneReencryptionStatusProto) GetNumFailures() int64 {
	if x != nil && x.NumFailures != nil {
		return *x.NumFailures
	}
	return 0
}

func (x *ZoneReencryptionStatusProto) GetCompletionTime() int64 {
	if x != nil && x.CompletionTime != nil {
		return *x.CompletionTime
	}
	return 0
}

func (x *ZoneReencryptionStatusProto) GetLastFile() string {
	if x != nil && x.LastFile != nil {
		return *x.LastFile
	}
	return ""
}

type ListReencryptionStatusResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Statuses []*ZoneReencryptionStatusProto `protobuf:"bytes,1,rep,name=statuses" json:"statuses,omitempty"`
	HasMore  *bool                          `protobuf:"varint,2,req,name=hasMore" json:"hasMore,omitempty"`
}

func (x *ListReencryptionStatusResponseProto) Reset() {
	*x = ListReencryptionStatusResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReencryptionStatusResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReencryptionStatusResponseProto) ProtoMessage() {}

func (x *ListReencryptionStatusResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReencryptionStatusResponseProto.ProtoReflect.Descriptor instead.
func (*ListReencryptionStatusResponseProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{9}
}

func (x *ListReencryptionStatusResponseProto) GetStatuses() []*ZoneReencryptionStatusProto {
	if x != nil {
		return x.Statuses
	}
	return nil
}

func (x *ListReencryptionStatusResponseProto) GetHasMore() bool {
	if x != nil && x.HasMore != nil {
		return *x.HasMore
	}
	return false
}

type GetEZForPathRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Src *string `protobuf:"bytes,1,req,name=src" json:"src,omitempty"`
}

func (x *GetEZForPathRequestProto) Reset() {
	*x = GetEZForPathRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEZForPathRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEZForPathRequestProto) ProtoMessage() {}

func (x *GetEZForPathRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEZForPathRequestProto.ProtoReflect.Descriptor instead.
func (*GetEZForPathRequestProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{10}
}

func (x *GetEZForPathRequestProto) GetSrc() string {
	if x != nil && x.Src != nil {
		return *x.Src
	}
	return ""
}

type GetEZForPathResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Zone *EncryptionZoneProto `protobuf:"bytes,1,opt,name=zone" json:"zone,omitempty"`
}

func (x *GetEZForPathResponseProto) Reset() {
	*x = GetEZForPathResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_encryption_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEZForPathResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEZForPathResponseProto) ProtoMessage() {}

func (x *GetEZForPathResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_encryption_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEZForPathResponseProto.ProtoReflect.Descriptor instead.
func (*GetEZForPathResponseProto) Descriptor() ([]byte, []int) {
	return file_encryption_proto_rawDescGZIP(), []int{11}
}

func (x *GetEZForPathResponseProto) GetZone() *EncryptionZoneProto {
	if x != nil {
		return x.Zone
	}
	return nil
}

var File_encryption_proto protoreflect.FileDescriptor

var file_encryption_proto_rawDesc = []byte{
	0x0a, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x0b, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x1a,
	0x0a, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4e, 0x0a, 0x20, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a,
	0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72,
	0x63, 0x12, 0x18, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x23, 0x0a, 0x21, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a,
	0x6f, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x31, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52,
	0x02, 0x69, 0x64, 0x22, 0xe7, 0x01, 0x0a, 0x13, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5a, 0x6f, 0x6e, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12,
	0x33, 0x0a, 0x05, 0x73, 0x75, 0x69, 0x74, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x1d,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x69, 0x70,
	0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x73,
	0x75, 0x69, 0x74, 0x65, 0x12, 0x5d, 0x0a, 0x15, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x02, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x15, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x74, 0x0a,
	0x20, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a,
	0x6f, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x36, 0x0a, 0x05, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a, 0x6f, 0x6e, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x05, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x68, 0x61, 0x73,
	0x4d, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x68, 0x61, 0x73, 0x4d,
	0x6f, 0x72, 0x65, 0x22, 0x74, 0x0a, 0x23, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a, 0x6f, 0x6e, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x39, 0x0a, 0x06, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x22, 0x26, 0x0a, 0x24, 0x52, 0x65, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5a, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x34, 0x0a, 0x22, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x22, 0xfa, 0x02, 0x0a, 0x1b, 0x5a, 0x6f, 0x6e, 0x65,
	0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x39, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x65, 0x7a, 0x4b, 0x65, 0x79, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x10, 0x65, 0x7a, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x02, 0x28, 0x08, 0x52, 0x08, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x65, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0e,
	0x6e, 0x75, 0x6d, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x12, 0x20,
	0x0a, 0x0b, 0x6e, 0x75, 0x6d, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x18, 0x08, 0x20,
	0x02, 0x28, 0x03, 0x52, 0x0b, 0x6e, 0x75, 0x6d, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x73, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x61, 0x73, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x44, 0x0a, 0x08,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x5a, 0x6f, 0x6e,
	0x65, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x08, 0x52, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65, 0x22, 0x2c, 0x0a, 0x18,
	0x47, 0x65, 0x74, 0x45, 0x5a, 0x46, 0x6f, 0x72, 0x50, 0x61, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x72, 0x63, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x73, 0x72, 0x63, 0x22, 0x51, 0x0a, 0x19, 0x47, 0x65,
	0x74, 0x45, 0x5a, 0x46, 0x6f, 0x72, 0x50, 0x61, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x34, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a, 0x6f,
	0x6e, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x2a, 0x41, 0x0a,
	0x14, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x5f,
	0x52, 0x45, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53,
	0x54, 0x41, 0x52, 0x54, 0x5f, 0x52, 0x45, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x10, 0x02,
	0x2a, 0x46, 0x0a, 0x16, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55,
	0x42, 0x4d, 0x49, 0x54, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f,
	0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d,
	0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x42, 0x7d, 0x0a, 0x25, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x42, 0x15, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5a, 0x6f, 0x6e,
	0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x5a, 0x3a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x6c, 0x69, 0x6e, 0x6d, 0x61, 0x72, 0x63, 0x2f, 0x68,
	0x64, 0x66, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x5f,
	0x68, 0x64, 0x66, 0x73, 0xa0, 0x01, 0x01,
}

var (
	file_encryption_proto_rawDescOnce sync.Once
	file_encryption_proto_rawDescData = file_encryption_proto_rawDesc
)

func file_encryption_proto_rawDescGZIP() []byte {
	file_encryption_proto_rawDescOnce.Do(func() {
		file_encryption_proto_rawDescData = protoimpl.X.CompressGZIP(file_encryption_proto_rawDescData)
	})
	return file_encryption_proto_rawDescData
}

var file_encryption_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_encryption_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_encryption_proto_goTypes = []interface{}{
	(ReencryptActionProto)(0),                    // 0: hadoop.hdfs.ReencryptActionProto
	(ReencryptionStateProto)(0),                  // 1: hadoop.hdfs.ReencryptionStateProto
	(*CreateEncryptionZoneRequestProto)(nil),     // 2: hadoop.hdfs.CreateEncryptionZoneRequestProto
	(*CreateEncryptionZoneResponseProto)(nil),    // 3: hadoop.hdfs.CreateEncryptionZoneResponseProto
	(*ListEncryptionZonesRequestProto)(nil),      // 4: hadoop.hdfs.ListEncryptionZonesRequestProto
	(*EncryptionZoneProto)(nil),                  // 5: hadoop.hdfs.EncryptionZoneProto
	(*ListEncryptionZonesResponseProto)(nil),     // 6: hadoop.hdfs.ListEncryptionZonesResponseProto
	(*ReencryptEncryptionZoneRequestProto)(nil),  // 7: hadoop.hdfs.ReencryptEncryptionZoneRequestProto
	(*ReencryptEncryptionZoneResponseProto)(nil), // 8: hadoop.hdfs.ReencryptEncryptionZoneResponseProto
	(*ListReencryptionStatusRequestProto)(nil),   // 9: hadoop.hdfs.ListReencryptionStatusRequestProto
	(*ZoneReencryptionStatusProto)(nil),          // 10: hadoop.hdfs.ZoneReencryptionStatusProto
	(*ListReencryptionStatusResponseProto)(nil),  // 11: hadoop.hdfs.ListReencryptionStatusResponseProto
	(*GetEZForPathRequestProto)(nil),             // 12: hadoop.hdfs.GetEZForPathRequestProto
	(*GetEZForPathResponseProto)(nil),            // 13: hadoop.hdfs.GetEZForPathResponseProto
	(CipherSuiteProto)(0),                        // 14: hadoop.hdfs.CipherSuiteProto
	(CryptoProtocolVersionProto)(0),              // 15: hadoop.hdfs.CryptoProtocolVersionProto
}
var file_encryption_proto_depIdxs = []int32{
	14, // 0: hadoop.hdfs.EncryptionZoneProto.suite:type_name -> hadoop.hdfs.CipherSuiteProto
	15, // 1: hadoop.hdfs.EncryptionZoneProto.cryptoProtocolVersion:type_name -> hadoop.hdfs.CryptoProtocolVersionProto
	5,  // 2: hadoop.hdfs.ListEncryptionZonesResponseProto.zones:type_name -> hadoop.hdfs.EncryptionZoneProto
	0,  // 3: hadoop.hdfs.ReencryptEncryptionZoneRequestProto.action:type_name -> hadoop.hdfs.ReencryptActionProto
	1,  // 4: hadoop.hdfs.ZoneReencryptionStatusProto.state:type_name -> hadoop.hdfs.ReencryptionStateProto
	10, // 5: hadoop.hdfs.ListReencryptionStatusResponseProto.statuses:type_name -> hadoop.hdfs.ZoneReencryptionStatusProto
	5,  // 6: hadoop.hdfs.GetEZForPathResponseProto.zone:type_name -> hadoop.hdfs.EncryptionZoneProto
	7,  // [7:7] is the sub-list for method output_type
	7,  // [7:7] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_encryption_proto_init() }
func file_encryption_proto_init() {
	if File_encryption_proto != nil {
		return
	}
	file_hdfs_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_encryption_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEncryptionZoneRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEncryptionZoneResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEncryptionZonesRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncryptionZoneProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEncryptionZonesResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReencryptEncryptionZoneRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReencryptEncryptionZoneResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReencryptionStatusRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ZoneReencryptionStatusProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReencryptionStatusResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEZForPathRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_encryption_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEZForPathResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_encryption_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_encryption_proto_goTypes,
		DependencyIndexes: file_encryption_proto_depIdxs,
		EnumInfos:         file_encryption_proto_enumTypes,
		MessageInfos:      file_encryption_proto_msgTypes,
	}.Build()
	File_encryption_proto = out.File
	file_encryption_proto_rawDesc = nil
	file_encryption_proto_goTypes = nil
	file_encryption_proto_depIdxs = nil
}
