package storsimple

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/storsimple8000series/mgmt/2017-06-01/storsimple"

// AccessControlRecord the access control record.
type AccessControlRecord struct {
	autorest.Response `json:"-"`
	// AccessControlRecordProperties - The properties of access control record.
	*AccessControlRecordProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessControlRecord.
func (acr AccessControlRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acr.AccessControlRecordProperties != nil {
		objectMap["properties"] = acr.AccessControlRecordProperties
	}
	if acr.Kind != "" {
		objectMap["kind"] = acr.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccessControlRecord struct.
func (acr *AccessControlRecord) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessControlRecordProperties AccessControlRecordProperties
				err = json.Unmarshal(*v, &accessControlRecordProperties)
				if err != nil {
					return err
				}
				acr.AccessControlRecordProperties = &accessControlRecordProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				acr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				acr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				acr.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acr.Kind = kind
			}
		}
	}

	return nil
}

// AccessControlRecordList the collection of access control records.
type AccessControlRecordList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]AccessControlRecord `json:"value,omitempty"`
}

// AccessControlRecordProperties the properties of access control record.
type AccessControlRecordProperties struct {
	// InitiatorName - The iSCSI initiator name (IQN).
	InitiatorName *string `json:"initiatorName,omitempty"`
	// VolumeCount - READ-ONLY; The number of volumes using the access control record.
	VolumeCount *int32 `json:"volumeCount,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessControlRecordProperties.
func (acrp AccessControlRecordProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acrp.InitiatorName != nil {
		objectMap["initiatorName"] = acrp.InitiatorName
	}
	return json.Marshal(objectMap)
}

// AccessControlRecordsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AccessControlRecordsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccessControlRecordsClient) (AccessControlRecord, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccessControlRecordsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccessControlRecordsCreateOrUpdateFuture.Result.
func (future *AccessControlRecordsCreateOrUpdateFuture) result(client AccessControlRecordsClient) (acr AccessControlRecord, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.AccessControlRecordsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		acr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.AccessControlRecordsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if acr.Response.Response, err = future.GetResult(sender); err == nil && acr.Response.Response.StatusCode != http.StatusNoContent {
		acr, err = client.CreateOrUpdateResponder(acr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.AccessControlRecordsCreateOrUpdateFuture", "Result", acr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccessControlRecordsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AccessControlRecordsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccessControlRecordsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccessControlRecordsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccessControlRecordsDeleteFuture.Result.
func (future *AccessControlRecordsDeleteFuture) result(client AccessControlRecordsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.AccessControlRecordsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.AccessControlRecordsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AcsConfiguration the ACS configuration.
type AcsConfiguration struct {
	// Namespace - The namespace.
	Namespace *string `json:"namespace,omitempty"`
	// Realm - The realm.
	Realm *string `json:"realm,omitempty"`
	// ServiceURL - The service URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
}

// Alert the alert.
type Alert struct {
	// AlertProperties - The properties of the alert.
	*AlertProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AlertProperties != nil {
		objectMap["properties"] = a.AlertProperties
	}
	if a.Kind != "" {
		objectMap["kind"] = a.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = kind
			}
		}
	}

	return nil
}

// AlertErrorDetails the details of the error for which the alert was raised
type AlertErrorDetails struct {
	// ErrorCode - The error code
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - The error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Occurences - The number of occurrences
	Occurences *int32 `json:"occurences,omitempty"`
}

// AlertFilter the OData filters to be used for Alert
type AlertFilter struct {
	// Status - Specifies the status of the alerts to be filtered. Only 'Equality' operator is supported for this property. Possible values include: 'Active', 'Cleared'
	Status AlertStatus `json:"status,omitempty"`
	// Severity - Specifies the severity of the alerts to be filtered. Only 'Equality' operator is supported for this property. Possible values include: 'Informational', 'Warning', 'Critical'
	Severity AlertSeverity `json:"severity,omitempty"`
	// SourceType - Specifies the source type of the alerts to be filtered. Only 'Equality' operator is supported for this property. Possible values include: 'AlertSourceTypeResource', 'AlertSourceTypeDevice'
	SourceType AlertSourceType `json:"sourceType,omitempty"`
	// SourceName - Specifies the source name of the alerts to be filtered. Only 'Equality' operator is supported for this property.
	SourceName *string `json:"sourceName,omitempty"`
	// AppearedOnTime - Specifies the appeared time (in UTC) of the alerts to be filtered. Only 'Greater-Than' and 'Lesser-Than' operators are supported for this property.
	AppearedOnTime *date.Time `json:"appearedOnTime,omitempty"`
}

// AlertList the collection of alerts.
type AlertList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - The URI of the next page of alerts.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertListIterator provides access to a complete listing of Alert values.
type AlertListIterator struct {
	i    int
	page AlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListIterator) Response() AlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListIterator type.
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return AlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AlertList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AlertList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// alertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AlertList) alertListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AlertListPage contains a page of Alert values.
type AlertListPage struct {
	fn func(context.Context, AlertList) (AlertList, error)
	al AlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListPage) Response() AlertList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListPage) Values() []Alert {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AlertListPage type.
func NewAlertListPage(cur AlertList, getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return AlertListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AlertNotificationProperties the properties of the alert notification settings.
type AlertNotificationProperties struct {
	// EmailNotification - Indicates whether email notification enabled or not. Possible values include: 'Enabled', 'Disabled'
	EmailNotification AlertEmailNotificationStatus `json:"emailNotification,omitempty"`
	// AlertNotificationCulture - The alert notification culture.
	AlertNotificationCulture *string `json:"alertNotificationCulture,omitempty"`
	// NotificationToServiceOwners - The value indicating whether alert notification enabled for admin or not. Possible values include: 'Enabled', 'Disabled'
	NotificationToServiceOwners AlertEmailNotificationStatus `json:"notificationToServiceOwners,omitempty"`
	// AdditionalRecipientEmailList - The alert notification email list.
	AdditionalRecipientEmailList *[]string `json:"additionalRecipientEmailList,omitempty"`
}

// AlertProperties the properties of alert
type AlertProperties struct {
	// Title - The title of the alert
	Title *string `json:"title,omitempty"`
	// Scope - The scope of the alert. Possible values include: 'AlertScopeResource', 'AlertScopeDevice'
	Scope AlertScope `json:"scope,omitempty"`
	// AlertType - The type of the alert
	AlertType *string `json:"alertType,omitempty"`
	// AppearedAtTime - The UTC time at which the alert was raised
	AppearedAtTime *date.Time `json:"appearedAtTime,omitempty"`
	// AppearedAtSourceTime - The source time at which the alert was raised
	AppearedAtSourceTime *date.Time `json:"appearedAtSourceTime,omitempty"`
	// ClearedAtTime - The UTC time at which the alert was cleared
	ClearedAtTime *date.Time `json:"clearedAtTime,omitempty"`
	// ClearedAtSourceTime - The source time at which the alert was cleared
	ClearedAtSourceTime *date.Time `json:"clearedAtSourceTime,omitempty"`
	// Source - The source at which the alert was raised
	Source *AlertSource `json:"source,omitempty"`
	// Recommendation - The recommended action for the issue raised in the alert
	Recommendation *string `json:"recommendation,omitempty"`
	// ResolutionReason - The reason for resolving the alert
	ResolutionReason *string `json:"resolutionReason,omitempty"`
	// Severity - The severity of the alert. Possible values include: 'Informational', 'Warning', 'Critical'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Status - The current status of the alert. Possible values include: 'Active', 'Cleared'
	Status AlertStatus `json:"status,omitempty"`
	// ErrorDetails - The details of the error for which the alert was raised
	ErrorDetails *AlertErrorDetails `json:"errorDetails,omitempty"`
	// DetailedInformation - More details about the alert
	DetailedInformation map[string]*string `json:"detailedInformation"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Title != nil {
		objectMap["title"] = ap.Title
	}
	if ap.Scope != "" {
		objectMap["scope"] = ap.Scope
	}
	if ap.AlertType != nil {
		objectMap["alertType"] = ap.AlertType
	}
	if ap.AppearedAtTime != nil {
		objectMap["appearedAtTime"] = ap.AppearedAtTime
	}
	if ap.AppearedAtSourceTime != nil {
		objectMap["appearedAtSourceTime"] = ap.AppearedAtSourceTime
	}
	if ap.ClearedAtTime != nil {
		objectMap["clearedAtTime"] = ap.ClearedAtTime
	}
	if ap.ClearedAtSourceTime != nil {
		objectMap["clearedAtSourceTime"] = ap.ClearedAtSourceTime
	}
	if ap.Source != nil {
		objectMap["source"] = ap.Source
	}
	if ap.Recommendation != nil {
		objectMap["recommendation"] = ap.Recommendation
	}
	if ap.ResolutionReason != nil {
		objectMap["resolutionReason"] = ap.ResolutionReason
	}
	if ap.Severity != "" {
		objectMap["severity"] = ap.Severity
	}
	if ap.Status != "" {
		objectMap["status"] = ap.Status
	}
	if ap.ErrorDetails != nil {
		objectMap["errorDetails"] = ap.ErrorDetails
	}
	if ap.DetailedInformation != nil {
		objectMap["detailedInformation"] = ap.DetailedInformation
	}
	return json.Marshal(objectMap)
}

// AlertSettings the alert settings.
type AlertSettings struct {
	autorest.Response `json:"-"`
	// AlertNotificationProperties - The properties of the alert notification settings.
	*AlertNotificationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertSettings.
func (as AlertSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if as.AlertNotificationProperties != nil {
		objectMap["properties"] = as.AlertNotificationProperties
	}
	if as.Kind != "" {
		objectMap["kind"] = as.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertSettings struct.
func (as *AlertSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertNotificationProperties AlertNotificationProperties
				err = json.Unmarshal(*v, &alertNotificationProperties)
				if err != nil {
					return err
				}
				as.AlertNotificationProperties = &alertNotificationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				as.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				as.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				as.Kind = kind
			}
		}
	}

	return nil
}

// AlertSource the source details at which the alert was raised
type AlertSource struct {
	// Name - The name of the source
	Name *string `json:"name,omitempty"`
	// TimeZone - The time zone of the source
	TimeZone *string `json:"timeZone,omitempty"`
	// AlertSourceType - The source type of the alert. Possible values include: 'AlertSourceTypeResource', 'AlertSourceTypeDevice'
	AlertSourceType AlertSourceType `json:"alertSourceType,omitempty"`
}

// AsymmetricEncryptedSecret represent the secrets intended for encryption with asymmetric key pair.
type AsymmetricEncryptedSecret struct {
	// Value - The value of the secret.
	Value *string `json:"value,omitempty"`
	// EncryptionCertThumbprint - Thumbprint certificate that was used to encrypt "Value". If the value in unencrypted, it will be null.
	EncryptionCertThumbprint *string `json:"encryptionCertThumbprint,omitempty"`
	// EncryptionAlgorithm - The algorithm used to encrypt "Value". Possible values include: 'EncryptionAlgorithmNone', 'EncryptionAlgorithmAES256', 'EncryptionAlgorithmRSAESPKCS1V15'
	EncryptionAlgorithm EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// AvailableProviderOperation represents available provider operation.
type AvailableProviderOperation struct {
	// Name - The name of the operation being performed on a particular object. Name format: "{resourceProviderNamespace}/{resourceType}/{read|write|delete|action}". Eg. Microsoft.StorSimple/managers/devices/volumeContainers/read, Microsoft.StorSimple/managers/devices/alerts/clearAlerts/action
	Name *string `json:"name,omitempty"`
	// Display - Contains the localized display information for this particular operation/action.
	Display *AvailableProviderOperationDisplay `json:"display,omitempty"`
	// Origin - The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX. Default value is "user,system"
	Origin *string `json:"origin,omitempty"`
	// Properties - Reserved for future use.
	Properties interface{} `json:"properties,omitempty"`
}

// AvailableProviderOperationDisplay contains the localized display information for this particular
// operation/action. These value will be used by several clients for (a) custom role definitions for RBAC,
// (b) complex query filters for the event service and (c) audit history/records for management operations.
type AvailableProviderOperationDisplay struct {
	// Provider - The localized friendly form of the resource provider name - it is expected to also include the publisher/company responsible. It should use Title Casing and begin with 'Microsoft' for 1st party services.
	Provider *string `json:"provider,omitempty"`
	// Resource - The localized friendly form of the resource type related to this action/operation - it should match the public documentation for the resource provider. It should use Title Casing - for examples, please refer to the 'name' section.
	Resource *string `json:"resource,omitempty"`
	// Operation - The localized friendly name for the operation, as it should be shown to the user. It should be concise (to fit in drop downs) but clear (i.e. self-documenting). It should use Title Casing and include the entity/resource to which it applies.
	Operation *string `json:"operation,omitempty"`
	// Description - The localized friendly description for the operation, as it should be shown to the user. It should be thorough, yet concise - it will be used in tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// AvailableProviderOperationList list of available provider operations.
type AvailableProviderOperationList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]AvailableProviderOperation `json:"value,omitempty"`
	// NextLink - The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableProviderOperationListIterator provides access to a complete listing of
// AvailableProviderOperation values.
type AvailableProviderOperationListIterator struct {
	i    int
	page AvailableProviderOperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableProviderOperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableProviderOperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableProviderOperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableProviderOperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableProviderOperationListIterator) Response() AvailableProviderOperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableProviderOperationListIterator) Value() AvailableProviderOperation {
	if !iter.page.NotDone() {
		return AvailableProviderOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableProviderOperationListIterator type.
func NewAvailableProviderOperationListIterator(page AvailableProviderOperationListPage) AvailableProviderOperationListIterator {
	return AvailableProviderOperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apol AvailableProviderOperationList) IsEmpty() bool {
	return apol.Value == nil || len(*apol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (apol AvailableProviderOperationList) hasNextLink() bool {
	return apol.NextLink != nil && len(*apol.NextLink) != 0
}

// availableProviderOperationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apol AvailableProviderOperationList) availableProviderOperationListPreparer(ctx context.Context) (*http.Request, error) {
	if !apol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apol.NextLink)))
}

// AvailableProviderOperationListPage contains a page of AvailableProviderOperation values.
type AvailableProviderOperationListPage struct {
	fn   func(context.Context, AvailableProviderOperationList) (AvailableProviderOperationList, error)
	apol AvailableProviderOperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableProviderOperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableProviderOperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.apol)
		if err != nil {
			return err
		}
		page.apol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableProviderOperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableProviderOperationListPage) NotDone() bool {
	return !page.apol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableProviderOperationListPage) Response() AvailableProviderOperationList {
	return page.apol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableProviderOperationListPage) Values() []AvailableProviderOperation {
	if page.apol.IsEmpty() {
		return nil
	}
	return *page.apol.Value
}

// Creates a new instance of the AvailableProviderOperationListPage type.
func NewAvailableProviderOperationListPage(cur AvailableProviderOperationList, getNextPage func(context.Context, AvailableProviderOperationList) (AvailableProviderOperationList, error)) AvailableProviderOperationListPage {
	return AvailableProviderOperationListPage{
		fn:   getNextPage,
		apol: cur,
	}
}

// Backup the backup.
type Backup struct {
	// BackupProperties - The properties of the backup.
	*BackupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Backup.
func (b Backup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BackupProperties != nil {
		objectMap["properties"] = b.BackupProperties
	}
	if b.Kind != "" {
		objectMap["kind"] = b.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Backup struct.
func (b *Backup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupProperties BackupProperties
				err = json.Unmarshal(*v, &backupProperties)
				if err != nil {
					return err
				}
				b.BackupProperties = &backupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				b.Kind = kind
			}
		}
	}

	return nil
}

// BackupElement the backup element.
type BackupElement struct {
	// ElementID - The path ID that uniquely identifies the backup element.
	ElementID *string `json:"elementId,omitempty"`
	// ElementName - The name of the backup element.
	ElementName *string `json:"elementName,omitempty"`
	// ElementType - The hierarchical type of the backup element.
	ElementType *string `json:"elementType,omitempty"`
	// SizeInBytes - The size in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// VolumeName - The name of the volume.
	VolumeName *string `json:"volumeName,omitempty"`
	// VolumeContainerID - The path ID of the volume container.
	VolumeContainerID *string `json:"volumeContainerId,omitempty"`
	// VolumeType - The volume type. Possible values include: 'Tiered', 'Archival', 'LocallyPinned'
	VolumeType VolumeType `json:"volumeType,omitempty"`
}

// BackupFilter the OData filters to be used for backups.
type BackupFilter struct {
	// BackupPolicyID - Specifies the backupPolicyId of the backups to be filtered. Only 'Equality' operator is supported for this property.
	BackupPolicyID *string `json:"backupPolicyId,omitempty"`
	// VolumeID - Specifies the volumeId of the backups to be filtered. Only 'Equality' operator is supported for this property.
	VolumeID *string `json:"volumeId,omitempty"`
	// CreatedTime - Specifies the creation time of the backups to be filtered. Only 'Greater Than or Equal To' and 'Lesser Than or Equal To' operators are supported for this property.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
}

// BackupList the collection of backups.
type BackupList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Backup `json:"value,omitempty"`
	// NextLink - The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackupListIterator provides access to a complete listing of Backup values.
type BackupListIterator struct {
	i    int
	page BackupListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupListIterator) Response() BackupList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupListIterator) Value() Backup {
	if !iter.page.NotDone() {
		return Backup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupListIterator type.
func NewBackupListIterator(page BackupListPage) BackupListIterator {
	return BackupListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bl BackupList) IsEmpty() bool {
	return bl.Value == nil || len(*bl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bl BackupList) hasNextLink() bool {
	return bl.NextLink != nil && len(*bl.NextLink) != 0
}

// backupListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bl BackupList) backupListPreparer(ctx context.Context) (*http.Request, error) {
	if !bl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bl.NextLink)))
}

// BackupListPage contains a page of Backup values.
type BackupListPage struct {
	fn func(context.Context, BackupList) (BackupList, error)
	bl BackupList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bl)
		if err != nil {
			return err
		}
		page.bl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupListPage) NotDone() bool {
	return !page.bl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupListPage) Response() BackupList {
	return page.bl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupListPage) Values() []Backup {
	if page.bl.IsEmpty() {
		return nil
	}
	return *page.bl.Value
}

// Creates a new instance of the BackupListPage type.
func NewBackupListPage(cur BackupList, getNextPage func(context.Context, BackupList) (BackupList, error)) BackupListPage {
	return BackupListPage{
		fn: getNextPage,
		bl: cur,
	}
}

// BackupPoliciesBackupNowFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupPoliciesBackupNowFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupPoliciesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupPoliciesBackupNowFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupPoliciesBackupNowFuture.Result.
func (future *BackupPoliciesBackupNowFuture) result(client BackupPoliciesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupPoliciesBackupNowFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupPoliciesBackupNowFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackupPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupPoliciesClient) (BackupPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupPoliciesCreateOrUpdateFuture.Result.
func (future *BackupPoliciesCreateOrUpdateFuture) result(client BackupPoliciesClient) (bp BackupPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bp.Response.Response, err = future.GetResult(sender); err == nil && bp.Response.Response.StatusCode != http.StatusNoContent {
		bp, err = client.CreateOrUpdateResponder(bp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.BackupPoliciesCreateOrUpdateFuture", "Result", bp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupPoliciesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupPoliciesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupPoliciesDeleteFuture.Result.
func (future *BackupPoliciesDeleteFuture) result(client BackupPoliciesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupPoliciesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupPoliciesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackupPolicy the backup policy.
type BackupPolicy struct {
	autorest.Response `json:"-"`
	// BackupPolicyProperties - The properties of the backup policy.
	*BackupPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupPolicy.
func (bp BackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.BackupPolicyProperties != nil {
		objectMap["properties"] = bp.BackupPolicyProperties
	}
	if bp.Kind != "" {
		objectMap["kind"] = bp.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupPolicy struct.
func (bp *BackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupPolicyProperties BackupPolicyProperties
				err = json.Unmarshal(*v, &backupPolicyProperties)
				if err != nil {
					return err
				}
				bp.BackupPolicyProperties = &backupPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bp.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bp.Kind = kind
			}
		}
	}

	return nil
}

// BackupPolicyList the collection of backup policies.
type BackupPolicyList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]BackupPolicy `json:"value,omitempty"`
}

// BackupPolicyProperties the properties of the backup policy.
type BackupPolicyProperties struct {
	// VolumeIds - The path IDs of the volumes which are part of the backup policy.
	VolumeIds *[]string `json:"volumeIds,omitempty"`
	// NextBackupTime - READ-ONLY; The time of the next backup for the backup policy.
	NextBackupTime *date.Time `json:"nextBackupTime,omitempty"`
	// LastBackupTime - READ-ONLY; The time of the last backup for the backup policy.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// SchedulesCount - READ-ONLY; The count of schedules the backup policy contains.
	SchedulesCount *int64 `json:"schedulesCount,omitempty"`
	// ScheduledBackupStatus - READ-ONLY; Indicates whether at least one of the schedules in the backup policy is active or not. Possible values include: 'ScheduledBackupStatusDisabled', 'ScheduledBackupStatusEnabled'
	ScheduledBackupStatus ScheduledBackupStatus `json:"scheduledBackupStatus,omitempty"`
	// BackupPolicyCreationType - READ-ONLY; The backup policy creation type. Indicates whether this was created through SaaS or through StorSimple Snapshot Manager. Possible values include: 'BackupPolicyCreationTypeBySaaS', 'BackupPolicyCreationTypeBySSM'
	BackupPolicyCreationType BackupPolicyCreationType `json:"backupPolicyCreationType,omitempty"`
	// SsmHostName - READ-ONLY; If the backup policy was created by StorSimple Snapshot Manager, then this field indicates the hostname of the StorSimple Snapshot Manager.
	SsmHostName *string `json:"ssmHostName,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupPolicyProperties.
func (bpp BackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bpp.VolumeIds != nil {
		objectMap["volumeIds"] = bpp.VolumeIds
	}
	return json.Marshal(objectMap)
}

// BackupProperties the properties of the backup.
type BackupProperties struct {
	// CreatedOn - The time when the backup was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// SizeInBytes - The backup size in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// BackupType - The type of the backup. Possible values include: 'LocalSnapshot', 'CloudSnapshot'
	BackupType BackupType `json:"backupType,omitempty"`
	// BackupJobCreationType - The backup job creation type. Possible values include: 'Adhoc', 'BySchedule', 'BySSM'
	BackupJobCreationType BackupJobCreationType `json:"backupJobCreationType,omitempty"`
	// BackupPolicyID - The path ID of the backup policy.
	BackupPolicyID *string `json:"backupPolicyId,omitempty"`
	// SsmHostName - The StorSimple Snapshot Manager host name.
	SsmHostName *string `json:"ssmHostName,omitempty"`
	// Elements - The backup elements.
	Elements *[]BackupElement `json:"elements,omitempty"`
}

// BackupSchedule the backup schedule.
type BackupSchedule struct {
	autorest.Response `json:"-"`
	// BackupScheduleProperties - The properties of the backup schedule.
	*BackupScheduleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupSchedule.
func (bs BackupSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bs.BackupScheduleProperties != nil {
		objectMap["properties"] = bs.BackupScheduleProperties
	}
	if bs.Kind != "" {
		objectMap["kind"] = bs.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupSchedule struct.
func (bs *BackupSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupScheduleProperties BackupScheduleProperties
				err = json.Unmarshal(*v, &backupScheduleProperties)
				if err != nil {
					return err
				}
				bs.BackupScheduleProperties = &backupScheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bs.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bs.Kind = kind
			}
		}
	}

	return nil
}

// BackupScheduleList the backup schedule list.
type BackupScheduleList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]BackupSchedule `json:"value,omitempty"`
}

// BackupScheduleProperties the properties of the backup schedule.
type BackupScheduleProperties struct {
	// ScheduleRecurrence - The schedule recurrence.
	ScheduleRecurrence *ScheduleRecurrence `json:"scheduleRecurrence,omitempty"`
	// BackupType - The type of backup which needs to be taken. Possible values include: 'LocalSnapshot', 'CloudSnapshot'
	BackupType BackupType `json:"backupType,omitempty"`
	// RetentionCount - The number of backups to be retained.
	RetentionCount *int64 `json:"retentionCount,omitempty"`
	// StartTime - The start time of the schedule.
	StartTime *date.Time `json:"startTime,omitempty"`
	// ScheduleStatus - The schedule status. Possible values include: 'ScheduleStatusEnabled', 'ScheduleStatusDisabled'
	ScheduleStatus ScheduleStatus `json:"scheduleStatus,omitempty"`
	// LastSuccessfulRun - READ-ONLY; The last successful backup run which was triggered for the schedule.
	LastSuccessfulRun *date.Time `json:"lastSuccessfulRun,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupScheduleProperties.
func (bsp BackupScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsp.ScheduleRecurrence != nil {
		objectMap["scheduleRecurrence"] = bsp.ScheduleRecurrence
	}
	if bsp.BackupType != "" {
		objectMap["backupType"] = bsp.BackupType
	}
	if bsp.RetentionCount != nil {
		objectMap["retentionCount"] = bsp.RetentionCount
	}
	if bsp.StartTime != nil {
		objectMap["startTime"] = bsp.StartTime
	}
	if bsp.ScheduleStatus != "" {
		objectMap["scheduleStatus"] = bsp.ScheduleStatus
	}
	return json.Marshal(objectMap)
}

// BackupSchedulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupSchedulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupSchedulesClient) (BackupSchedule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupSchedulesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupSchedulesCreateOrUpdateFuture.Result.
func (future *BackupSchedulesCreateOrUpdateFuture) result(client BackupSchedulesClient) (bs BackupSchedule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupSchedulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupSchedulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bs.Response.Response, err = future.GetResult(sender); err == nil && bs.Response.Response.StatusCode != http.StatusNoContent {
		bs, err = client.CreateOrUpdateResponder(bs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.BackupSchedulesCreateOrUpdateFuture", "Result", bs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupSchedulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupSchedulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupSchedulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupSchedulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupSchedulesDeleteFuture.Result.
func (future *BackupSchedulesDeleteFuture) result(client BackupSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupSchedulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupSchedulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackupsCloneFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BackupsCloneFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupsCloneFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupsCloneFuture.Result.
func (future *BackupsCloneFuture) result(client BackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupsCloneFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupsCloneFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupsDeleteFuture.Result.
func (future *BackupsDeleteFuture) result(client BackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackupsRestoreFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupsRestoreFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupsRestoreFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupsRestoreFuture.Result.
func (future *BackupsRestoreFuture) result(client BackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupsRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupsRestoreFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BandwidthRateSettingProperties the properties of the bandwidth setting.
type BandwidthRateSettingProperties struct {
	// Schedules - The schedules.
	Schedules *[]BandwidthSchedule `json:"schedules,omitempty"`
	// VolumeCount - READ-ONLY; The number of volumes that uses the bandwidth setting.
	VolumeCount *int32 `json:"volumeCount,omitempty"`
}

// MarshalJSON is the custom marshaler for BandwidthRateSettingProperties.
func (brsp BandwidthRateSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if brsp.Schedules != nil {
		objectMap["schedules"] = brsp.Schedules
	}
	return json.Marshal(objectMap)
}

// BandwidthSchedule the schedule for bandwidth setting.
type BandwidthSchedule struct {
	// Start - The start time of the schedule.
	Start *Time `json:"start,omitempty"`
	// Stop - The stop time of the schedule.
	Stop *Time `json:"stop,omitempty"`
	// RateInMbps - The rate in Mbps.
	RateInMbps *int32 `json:"rateInMbps,omitempty"`
	// Days - The days of the week when this schedule is applicable.
	Days *[]DayOfWeek `json:"days,omitempty"`
}

// BandwidthSetting the bandwidth setting.
type BandwidthSetting struct {
	autorest.Response `json:"-"`
	// BandwidthRateSettingProperties - The properties of the bandwidth setting.
	*BandwidthRateSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for BandwidthSetting.
func (bs BandwidthSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bs.BandwidthRateSettingProperties != nil {
		objectMap["properties"] = bs.BandwidthRateSettingProperties
	}
	if bs.Kind != "" {
		objectMap["kind"] = bs.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BandwidthSetting struct.
func (bs *BandwidthSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bandwidthRateSettingProperties BandwidthRateSettingProperties
				err = json.Unmarshal(*v, &bandwidthRateSettingProperties)
				if err != nil {
					return err
				}
				bs.BandwidthRateSettingProperties = &bandwidthRateSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bs.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bs.Kind = kind
			}
		}
	}

	return nil
}

// BandwidthSettingList the collection of bandwidth setting entities.
type BandwidthSettingList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]BandwidthSetting `json:"value,omitempty"`
}

// BandwidthSettingsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BandwidthSettingsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BandwidthSettingsClient) (BandwidthSetting, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BandwidthSettingsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BandwidthSettingsCreateOrUpdateFuture.Result.
func (future *BandwidthSettingsCreateOrUpdateFuture) result(client BandwidthSettingsClient) (bs BandwidthSetting, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BandwidthSettingsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BandwidthSettingsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bs.Response.Response, err = future.GetResult(sender); err == nil && bs.Response.Response.StatusCode != http.StatusNoContent {
		bs, err = client.CreateOrUpdateResponder(bs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.BandwidthSettingsCreateOrUpdateFuture", "Result", bs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BandwidthSettingsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BandwidthSettingsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BandwidthSettingsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BandwidthSettingsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BandwidthSettingsDeleteFuture.Result.
func (future *BandwidthSettingsDeleteFuture) result(client BandwidthSettingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BandwidthSettingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.BandwidthSettingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BaseModel represents the base class for all other ARM object models
type BaseModel struct {
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for BaseModel.
func (bm BaseModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bm.Kind != "" {
		objectMap["kind"] = bm.Kind
	}
	return json.Marshal(objectMap)
}

// ChapSettings the Challenge-Handshake Authentication Protocol (CHAP) settings.
type ChapSettings struct {
	// InitiatorUser - The CHAP initiator user.
	InitiatorUser *string `json:"initiatorUser,omitempty"`
	// InitiatorSecret - The CHAP initiator secret.
	InitiatorSecret *AsymmetricEncryptedSecret `json:"initiatorSecret,omitempty"`
	// TargetUser - The CHAP target user.
	TargetUser *string `json:"targetUser,omitempty"`
	// TargetSecret - The target secret.
	TargetSecret *AsymmetricEncryptedSecret `json:"targetSecret,omitempty"`
}

// ClearAlertRequest the request for clearing the alert
type ClearAlertRequest struct {
	// ResolutionMessage - The resolution message while clearing the alert
	ResolutionMessage *string `json:"resolutionMessage,omitempty"`
	// Alerts - The list of alert IDs to be cleared
	Alerts *[]string `json:"alerts,omitempty"`
}

// CloneRequest the clone job request.
type CloneRequest struct {
	// TargetDeviceID - The path ID of the device which will act as the clone target.
	TargetDeviceID *string `json:"targetDeviceId,omitempty"`
	// TargetVolumeName - The name of the new volume which will be created and the backup will be cloned into.
	TargetVolumeName *string `json:"targetVolumeName,omitempty"`
	// TargetAccessControlRecordIds - The list of path IDs of the access control records to be associated to the new cloned volume.
	TargetAccessControlRecordIds *[]string `json:"targetAccessControlRecordIds,omitempty"`
	// BackupElement - The backup element that is cloned.
	BackupElement *BackupElement `json:"backupElement,omitempty"`
}

// CloudAppliance the cloud appliance.
type CloudAppliance struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// VnetName - The name of the virtual network.
	VnetName *string `json:"vnetName,omitempty"`
	// VnetRegion - The virtual network region.
	VnetRegion *string `json:"vnetRegion,omitempty"`
	// IsVnetDNSConfigured - Indicates whether virtual network used is configured with DNS or not.
	IsVnetDNSConfigured *bool `json:"isVnetDnsConfigured,omitempty"`
	// IsVnetExpressConfigured - Indicates whether virtual network used is configured with express route or not.
	IsVnetExpressConfigured *bool `json:"isVnetExpressConfigured,omitempty"`
	// SubnetName - The name of the subnet.
	SubnetName *string `json:"subnetName,omitempty"`
	// StorageAccountName - The name of the storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// StorageAccountType - The type of the storage account.
	StorageAccountType *string `json:"storageAccountType,omitempty"`
	// VMType - The type of the virtual machine.
	VMType *string `json:"vmType,omitempty"`
	// VMImageName - The name of the virtual machine image.
	VMImageName *string `json:"vmImageName,omitempty"`
	// ModelNumber - The model number.
	ModelNumber *string `json:"modelNumber,omitempty"`
}

// CloudApplianceConfiguration the cloud appliance configuration
type CloudApplianceConfiguration struct {
	// CloudApplianceConfigurationProperties - The properties.
	*CloudApplianceConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudApplianceConfiguration.
func (cac CloudApplianceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cac.CloudApplianceConfigurationProperties != nil {
		objectMap["properties"] = cac.CloudApplianceConfigurationProperties
	}
	if cac.Kind != "" {
		objectMap["kind"] = cac.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudApplianceConfiguration struct.
func (cac *CloudApplianceConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cloudApplianceConfigurationProperties CloudApplianceConfigurationProperties
				err = json.Unmarshal(*v, &cloudApplianceConfigurationProperties)
				if err != nil {
					return err
				}
				cac.CloudApplianceConfigurationProperties = &cloudApplianceConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cac.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cac.Kind = kind
			}
		}
	}

	return nil
}

// CloudApplianceConfigurationList the cloud appliance configuration list
type CloudApplianceConfigurationList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]CloudApplianceConfiguration `json:"value,omitempty"`
}

// CloudApplianceConfigurationProperties the properties of cloud appliance configuration.
type CloudApplianceConfigurationProperties struct {
	// ModelNumber - The model number.
	ModelNumber *string `json:"modelNumber,omitempty"`
	// CloudPlatform - The cloud platform.
	CloudPlatform *string `json:"cloudPlatform,omitempty"`
	// AcsConfiguration - The ACS configuration.
	AcsConfiguration *AcsConfiguration `json:"acsConfiguration,omitempty"`
	// SupportedStorageAccountTypes - The supported storage account types.
	SupportedStorageAccountTypes *[]string `json:"supportedStorageAccountTypes,omitempty"`
	// SupportedRegions - The supported regions.
	SupportedRegions *[]string `json:"supportedRegions,omitempty"`
	// SupportedVMTypes - The supported virtual machine types.
	SupportedVMTypes *[]string `json:"supportedVmTypes,omitempty"`
	// SupportedVMImages - The supported virtual machine images.
	SupportedVMImages *[]VMImage `json:"supportedVmImages,omitempty"`
}

// CloudApplianceSettings the cloud appliance settings.
type CloudApplianceSettings struct {
	// ServiceDataEncryptionKey - The service data encryption key (encrypted with DAK).
	ServiceDataEncryptionKey *AsymmetricEncryptedSecret `json:"serviceDataEncryptionKey,omitempty"`
	// ChannelIntegrityKey - The channel integrity key (encrypted with DAK).
	ChannelIntegrityKey *AsymmetricEncryptedSecret `json:"channelIntegrityKey,omitempty"`
}

// CloudAppliancesProvisionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudAppliancesProvisionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudAppliancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudAppliancesProvisionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudAppliancesProvisionFuture.Result.
func (future *CloudAppliancesProvisionFuture) result(client CloudAppliancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesProvisionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.CloudAppliancesProvisionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConfigureDeviceRequest the mandatory device configuration request.
type ConfigureDeviceRequest struct {
	// ConfigureDeviceRequestProperties - The properties of the configure device request.
	*ConfigureDeviceRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigureDeviceRequest.
func (cdr ConfigureDeviceRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdr.ConfigureDeviceRequestProperties != nil {
		objectMap["properties"] = cdr.ConfigureDeviceRequestProperties
	}
	if cdr.Kind != "" {
		objectMap["kind"] = cdr.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConfigureDeviceRequest struct.
func (cdr *ConfigureDeviceRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var configureDeviceRequestProperties ConfigureDeviceRequestProperties
				err = json.Unmarshal(*v, &configureDeviceRequestProperties)
				if err != nil {
					return err
				}
				cdr.ConfigureDeviceRequestProperties = &configureDeviceRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cdr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cdr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cdr.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cdr.Kind = kind
			}
		}
	}

	return nil
}

// ConfigureDeviceRequestProperties the properties of the configure device request.
type ConfigureDeviceRequestProperties struct {
	// FriendlyName - The friendly name for the device.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// CurrentDeviceName - The current name of the device.
	CurrentDeviceName *string `json:"currentDeviceName,omitempty"`
	// TimeZone - The device time zone. For eg: "Pacific Standard Time"
	TimeZone *string `json:"timeZone,omitempty"`
	// DNSSettings - The secondary DNS Settings of the device.
	DNSSettings *SecondaryDNSSettings `json:"dnsSettings,omitempty"`
	// NetworkInterfaceData0Settings - The 'Data 0' network interface card settings.
	NetworkInterfaceData0Settings *NetworkInterfaceData0Settings `json:"networkInterfaceData0Settings,omitempty"`
}

// ControllerPowerStateChangeRequest the controller power state change request.
type ControllerPowerStateChangeRequest struct {
	// ControllerPowerStateChangeRequestProperties - The properties of the controller power state change request.
	*ControllerPowerStateChangeRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ControllerPowerStateChangeRequest.
func (cpscr ControllerPowerStateChangeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpscr.ControllerPowerStateChangeRequestProperties != nil {
		objectMap["properties"] = cpscr.ControllerPowerStateChangeRequestProperties
	}
	if cpscr.Kind != "" {
		objectMap["kind"] = cpscr.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ControllerPowerStateChangeRequest struct.
func (cpscr *ControllerPowerStateChangeRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var controllerPowerStateChangeRequestProperties ControllerPowerStateChangeRequestProperties
				err = json.Unmarshal(*v, &controllerPowerStateChangeRequestProperties)
				if err != nil {
					return err
				}
				cpscr.ControllerPowerStateChangeRequestProperties = &controllerPowerStateChangeRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cpscr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cpscr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cpscr.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cpscr.Kind = kind
			}
		}
	}

	return nil
}

// ControllerPowerStateChangeRequestProperties the properties of the controller power state change request.
type ControllerPowerStateChangeRequestProperties struct {
	// Action - The power state that the request is expecting for the controller of the device. Possible values include: 'Start', 'Restart', 'Shutdown'
	Action ControllerPowerStateAction `json:"action,omitempty"`
	// ActiveController - The active controller that the request is expecting on the device. Possible values include: 'ControllerIDUnknown', 'ControllerIDNone', 'ControllerIDController0', 'ControllerIDController1'
	ActiveController ControllerID `json:"activeController,omitempty"`
	// Controller0State - The controller 0's status that the request is expecting on the device. Possible values include: 'ControllerStatusNotPresent', 'ControllerStatusPoweredOff', 'ControllerStatusOk', 'ControllerStatusRecovering', 'ControllerStatusWarning', 'ControllerStatusFailure'
	Controller0State ControllerStatus `json:"controller0State,omitempty"`
	// Controller1State - The controller 1's status that the request is expecting on the device. Possible values include: 'ControllerStatusNotPresent', 'ControllerStatusPoweredOff', 'ControllerStatusOk', 'ControllerStatusRecovering', 'ControllerStatusWarning', 'ControllerStatusFailure'
	Controller1State ControllerStatus `json:"controller1State,omitempty"`
}

// DataStatistics the additional details related to the data related statistics of a job. Currently
// applicable only for Backup, Clone and Restore jobs.
type DataStatistics struct {
	// TotalData - The total bytes of data to be processed, as part of the job.
	TotalData *int64 `json:"totalData,omitempty"`
	// ProcessedData - The number of bytes of data processed till now, as part of the job.
	ProcessedData *int64 `json:"processedData,omitempty"`
	// CloudData - The number of bytes of data written to cloud, as part of the job.
	CloudData *int64 `json:"cloudData,omitempty"`
	// Throughput - The average throughput of data processed(bytes/sec), as part of the job.
	Throughput *int64 `json:"throughput,omitempty"`
}

// Device the StorSimple device.
type Device struct {
	autorest.Response `json:"-"`
	// DeviceProperties - The properties of the StorSimple device.
	*DeviceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Device.
func (d Device) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DeviceProperties != nil {
		objectMap["properties"] = d.DeviceProperties
	}
	if d.Kind != "" {
		objectMap["kind"] = d.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Device struct.
func (d *Device) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deviceProperties DeviceProperties
				err = json.Unmarshal(*v, &deviceProperties)
				if err != nil {
					return err
				}
				d.DeviceProperties = &deviceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = kind
			}
		}
	}

	return nil
}

// DeviceDetails the additional device details regarding the end point count and volume container count.
type DeviceDetails struct {
	// EndpointCount - The total number of endpoints that are currently on the device ( i.e. number of volumes).
	EndpointCount *int32 `json:"endpointCount,omitempty"`
	// VolumeContainerCount - The total number of volume containers on the device.
	VolumeContainerCount *int32 `json:"volumeContainerCount,omitempty"`
}

// DeviceList the collection of devices.
type DeviceList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Device `json:"value,omitempty"`
}

// DevicePatch the device patch.
type DevicePatch struct {
	// DevicePatchProperties - The properties of the device patch.
	*DevicePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DevicePatch.
func (dp DevicePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.DevicePatchProperties != nil {
		objectMap["properties"] = dp.DevicePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DevicePatch struct.
func (dp *DevicePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var devicePatchProperties DevicePatchProperties
				err = json.Unmarshal(*v, &devicePatchProperties)
				if err != nil {
					return err
				}
				dp.DevicePatchProperties = &devicePatchProperties
			}
		}
	}

	return nil
}

// DevicePatchProperties the properties of the device patch.
type DevicePatchProperties struct {
	// DeviceDescription - Short description given for the device
	DeviceDescription *string `json:"deviceDescription,omitempty"`
}

// DeviceProperties the properties of the StorSimple device.
type DeviceProperties struct {
	// FriendlyName - The friendly name of the device.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ActivationTime - The UTC time at which the device was activated
	ActivationTime *date.Time `json:"activationTime,omitempty"`
	// Culture - The language culture setting on the device. For eg: "en-US"
	Culture *string `json:"culture,omitempty"`
	// DeviceDescription - The device description.
	DeviceDescription *string `json:"deviceDescription,omitempty"`
	// DeviceSoftwareVersion - The version number of the software running on the device.
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty"`
	// FriendlySoftwareName - The friendly name of the software running on the device.
	FriendlySoftwareName *string `json:"friendlySoftwareName,omitempty"`
	// DeviceConfigurationStatus - The current configuration status of the device. Possible values include: 'Complete', 'Pending'
	DeviceConfigurationStatus DeviceConfigurationStatus `json:"deviceConfigurationStatus,omitempty"`
	// TargetIqn - The target IQN.
	TargetIqn *string `json:"targetIqn,omitempty"`
	// ModelDescription - The device model.
	ModelDescription *string `json:"modelDescription,omitempty"`
	// Status - The current status of the device. Possible values include: 'Unknown', 'Online', 'Offline', 'Deactivated', 'RequiresAttention', 'MaintenanceMode', 'Creating', 'Provisioning', 'Deactivating', 'Deleted', 'ReadyToSetup'
	Status DeviceStatus `json:"status,omitempty"`
	// SerialNumber - The serial number.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// DeviceType - The type of the device. Possible values include: 'DeviceTypeInvalid', 'DeviceTypeSeries8000VirtualAppliance', 'DeviceTypeSeries8000PhysicalAppliance'
	DeviceType DeviceType `json:"deviceType,omitempty"`
	// ActiveController - The identifier of the active controller of the device. Possible values include: 'ControllerIDUnknown', 'ControllerIDNone', 'ControllerIDController0', 'ControllerIDController1'
	ActiveController ControllerID `json:"activeController,omitempty"`
	// FriendlySoftwareVersion - The device friendly software version.
	FriendlySoftwareVersion *string `json:"friendlySoftwareVersion,omitempty"`
	// AvailableLocalStorageInBytes - The storage in bytes that is available locally on the device.
	AvailableLocalStorageInBytes *int64 `json:"availableLocalStorageInBytes,omitempty"`
	// AvailableTieredStorageInBytes - The storage in bytes that is available on the device for tiered volumes.
	AvailableTieredStorageInBytes *int64 `json:"availableTieredStorageInBytes,omitempty"`
	// ProvisionedTieredStorageInBytes - The storage in bytes that has been provisioned on the device for tiered volumes.
	ProvisionedTieredStorageInBytes *int64 `json:"provisionedTieredStorageInBytes,omitempty"`
	// ProvisionedLocalStorageInBytes - The storage in bytes used for locally pinned volumes on the device (including additional local reservation).
	ProvisionedLocalStorageInBytes *int64 `json:"provisionedLocalStorageInBytes,omitempty"`
	// ProvisionedVolumeSizeInBytes - Total capacity in bytes of tiered and locally pinned volumes on the device
	ProvisionedVolumeSizeInBytes *int64 `json:"provisionedVolumeSizeInBytes,omitempty"`
	// UsingStorageInBytes - The storage in bytes that is currently being used on the device, including both local and cloud.
	UsingStorageInBytes *int64 `json:"usingStorageInBytes,omitempty"`
	// TotalTieredStorageInBytes - The total tiered storage available on the device in bytes.
	TotalTieredStorageInBytes *int64 `json:"totalTieredStorageInBytes,omitempty"`
	// AgentGroupVersion - The device agent group version.
	AgentGroupVersion *int32 `json:"agentGroupVersion,omitempty"`
	// NetworkInterfaceCardCount - The number of network interface cards
	NetworkInterfaceCardCount *int32 `json:"networkInterfaceCardCount,omitempty"`
	// DeviceLocation - The location of the virtual appliance.
	DeviceLocation *string `json:"deviceLocation,omitempty"`
	// VirtualMachineAPIType - READ-ONLY; The virtual machine API type. Possible values include: 'Classic', 'Arm'
	VirtualMachineAPIType VirtualMachineAPIType `json:"virtualMachineApiType,omitempty"`
	// Details - The additional device details regarding the end point count and volume container count.
	Details *DeviceDetails `json:"details,omitempty"`
	// RolloverDetails - The additional device details for the service data encryption key rollover.
	RolloverDetails *DeviceRolloverDetails `json:"rolloverDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceProperties.
func (dp DeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.FriendlyName != nil {
		objectMap["friendlyName"] = dp.FriendlyName
	}
	if dp.ActivationTime != nil {
		objectMap["activationTime"] = dp.ActivationTime
	}
	if dp.Culture != nil {
		objectMap["culture"] = dp.Culture
	}
	if dp.DeviceDescription != nil {
		objectMap["deviceDescription"] = dp.DeviceDescription
	}
	if dp.DeviceSoftwareVersion != nil {
		objectMap["deviceSoftwareVersion"] = dp.DeviceSoftwareVersion
	}
	if dp.FriendlySoftwareName != nil {
		objectMap["friendlySoftwareName"] = dp.FriendlySoftwareName
	}
	if dp.DeviceConfigurationStatus != "" {
		objectMap["deviceConfigurationStatus"] = dp.DeviceConfigurationStatus
	}
	if dp.TargetIqn != nil {
		objectMap["targetIqn"] = dp.TargetIqn
	}
	if dp.ModelDescription != nil {
		objectMap["modelDescription"] = dp.ModelDescription
	}
	if dp.Status != "" {
		objectMap["status"] = dp.Status
	}
	if dp.SerialNumber != nil {
		objectMap["serialNumber"] = dp.SerialNumber
	}
	if dp.DeviceType != "" {
		objectMap["deviceType"] = dp.DeviceType
	}
	if dp.ActiveController != "" {
		objectMap["activeController"] = dp.ActiveController
	}
	if dp.FriendlySoftwareVersion != nil {
		objectMap["friendlySoftwareVersion"] = dp.FriendlySoftwareVersion
	}
	if dp.AvailableLocalStorageInBytes != nil {
		objectMap["availableLocalStorageInBytes"] = dp.AvailableLocalStorageInBytes
	}
	if dp.AvailableTieredStorageInBytes != nil {
		objectMap["availableTieredStorageInBytes"] = dp.AvailableTieredStorageInBytes
	}
	if dp.ProvisionedTieredStorageInBytes != nil {
		objectMap["provisionedTieredStorageInBytes"] = dp.ProvisionedTieredStorageInBytes
	}
	if dp.ProvisionedLocalStorageInBytes != nil {
		objectMap["provisionedLocalStorageInBytes"] = dp.ProvisionedLocalStorageInBytes
	}
	if dp.ProvisionedVolumeSizeInBytes != nil {
		objectMap["provisionedVolumeSizeInBytes"] = dp.ProvisionedVolumeSizeInBytes
	}
	if dp.UsingStorageInBytes != nil {
		objectMap["usingStorageInBytes"] = dp.UsingStorageInBytes
	}
	if dp.TotalTieredStorageInBytes != nil {
		objectMap["totalTieredStorageInBytes"] = dp.TotalTieredStorageInBytes
	}
	if dp.AgentGroupVersion != nil {
		objectMap["agentGroupVersion"] = dp.AgentGroupVersion
	}
	if dp.NetworkInterfaceCardCount != nil {
		objectMap["networkInterfaceCardCount"] = dp.NetworkInterfaceCardCount
	}
	if dp.DeviceLocation != nil {
		objectMap["deviceLocation"] = dp.DeviceLocation
	}
	if dp.Details != nil {
		objectMap["details"] = dp.Details
	}
	if dp.RolloverDetails != nil {
		objectMap["rolloverDetails"] = dp.RolloverDetails
	}
	return json.Marshal(objectMap)
}

// DeviceRolloverDetails the additional device details for the service data encryption key rollover.
type DeviceRolloverDetails struct {
	// AuthorizationEligibility - The eligibility status of device for service data encryption key rollover. Possible values include: 'InEligible', 'Eligible'
	AuthorizationEligibility AuthorizationEligibility `json:"authorizationEligibility,omitempty"`
	// AuthorizationStatus - The authorization status of the device for service data encryption key rollover. Possible values include: 'AuthorizationStatusDisabled', 'AuthorizationStatusEnabled'
	AuthorizationStatus AuthorizationStatus `json:"authorizationStatus,omitempty"`
	// InEligibilityReason - The reason for inEligibility of device, in case it's not eligible for service data encryption key rollover. Possible values include: 'DeviceNotOnline', 'NotSupportedAppliance', 'RolloverPending'
	InEligibilityReason InEligibilityCategory `json:"inEligibilityReason,omitempty"`
}

// DevicesConfigureFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesConfigureFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesConfigureFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesConfigureFuture.Result.
func (future *DevicesConfigureFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesConfigureFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesConfigureFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDeactivateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDeactivateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesDeactivateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesDeactivateFuture.Result.
func (future *DevicesDeactivateFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesDeactivateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesDeactivateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesDeleteFuture.Result.
func (future *DevicesDeleteFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeviceSettingsCreateOrUpdateAlertSettingsFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DeviceSettingsCreateOrUpdateAlertSettingsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeviceSettingsClient) (AlertSettings, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeviceSettingsCreateOrUpdateAlertSettingsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeviceSettingsCreateOrUpdateAlertSettingsFuture.Result.
func (future *DeviceSettingsCreateOrUpdateAlertSettingsFuture) result(client DeviceSettingsClient) (as AlertSettings, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DeviceSettingsCreateOrUpdateAlertSettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		as.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DeviceSettingsCreateOrUpdateAlertSettingsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if as.Response.Response, err = future.GetResult(sender); err == nil && as.Response.Response.StatusCode != http.StatusNoContent {
		as, err = client.CreateOrUpdateAlertSettingsResponder(as.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.DeviceSettingsCreateOrUpdateAlertSettingsFuture", "Result", as.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeviceSettingsCreateOrUpdateTimeSettingsFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DeviceSettingsCreateOrUpdateTimeSettingsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeviceSettingsClient) (TimeSettings, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeviceSettingsCreateOrUpdateTimeSettingsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeviceSettingsCreateOrUpdateTimeSettingsFuture.Result.
func (future *DeviceSettingsCreateOrUpdateTimeSettingsFuture) result(client DeviceSettingsClient) (ts TimeSettings, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DeviceSettingsCreateOrUpdateTimeSettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ts.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DeviceSettingsCreateOrUpdateTimeSettingsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ts.Response.Response, err = future.GetResult(sender); err == nil && ts.Response.Response.StatusCode != http.StatusNoContent {
		ts, err = client.CreateOrUpdateTimeSettingsResponder(ts.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.DeviceSettingsCreateOrUpdateTimeSettingsFuture", "Result", ts.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeviceSettingsSyncRemotemanagementCertificateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DeviceSettingsSyncRemotemanagementCertificateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeviceSettingsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeviceSettingsSyncRemotemanagementCertificateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeviceSettingsSyncRemotemanagementCertificateFuture.Result.
func (future *DeviceSettingsSyncRemotemanagementCertificateFuture) result(client DeviceSettingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DeviceSettingsSyncRemotemanagementCertificateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DeviceSettingsSyncRemotemanagementCertificateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeviceSettingsUpdateNetworkSettingsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeviceSettingsUpdateNetworkSettingsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeviceSettingsClient) (NetworkSettings, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeviceSettingsUpdateNetworkSettingsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeviceSettingsUpdateNetworkSettingsFuture.Result.
func (future *DeviceSettingsUpdateNetworkSettingsFuture) result(client DeviceSettingsClient) (ns NetworkSettings, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DeviceSettingsUpdateNetworkSettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ns.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DeviceSettingsUpdateNetworkSettingsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ns.Response.Response, err = future.GetResult(sender); err == nil && ns.Response.Response.StatusCode != http.StatusNoContent {
		ns, err = client.UpdateNetworkSettingsResponder(ns.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.DeviceSettingsUpdateNetworkSettingsFuture", "Result", ns.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeviceSettingsUpdateSecuritySettingsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeviceSettingsUpdateSecuritySettingsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeviceSettingsClient) (SecuritySettings, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeviceSettingsUpdateSecuritySettingsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeviceSettingsUpdateSecuritySettingsFuture.Result.
func (future *DeviceSettingsUpdateSecuritySettingsFuture) result(client DeviceSettingsClient) (ss SecuritySettings, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DeviceSettingsUpdateSecuritySettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ss.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DeviceSettingsUpdateSecuritySettingsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ss.Response.Response, err = future.GetResult(sender); err == nil && ss.Response.Response.StatusCode != http.StatusNoContent {
		ss, err = client.UpdateSecuritySettingsResponder(ss.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.DeviceSettingsUpdateSecuritySettingsFuture", "Result", ss.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DevicesFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesFailoverFuture.Result.
func (future *DevicesFailoverFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesInstallUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesInstallUpdatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesInstallUpdatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesInstallUpdatesFuture.Result.
func (future *DevicesInstallUpdatesFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesInstallUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesInstallUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesScanForUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesScanForUpdatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesScanForUpdatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesScanForUpdatesFuture.Result.
func (future *DevicesScanForUpdatesFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesScanForUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesScanForUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DimensionFilter the dimension filter.
type DimensionFilter struct {
	// Name - Specifies the dimension name. E.g., NetworkInterface. Valid values are the ones specified in the field "dimensions" in the ListMetricDefinitions call. Only 'Equality' operator is supported for this property.
	Name *string `json:"name,omitempty"`
	// Values - Specifies the dimension value. E.g., Data0. Valid values are the ones returned in the field "dimensions" in the ListMetricDefinitions call. Only 'Equality' operator is supported for this property.
	Values *string `json:"values,omitempty"`
}

// DNSSettings the DNS(Domain Name Server) settings of a device.
type DNSSettings struct {
	// PrimaryDNSServer - The primary IPv4 DNS server for the device
	PrimaryDNSServer *string `json:"primaryDnsServer,omitempty"`
	// PrimaryIpv6DNSServer - The primary IPv6 DNS server for the device
	PrimaryIpv6DNSServer *string `json:"primaryIpv6DnsServer,omitempty"`
	// SecondaryDNSServers - The secondary IPv4 DNS server for the device
	SecondaryDNSServers *[]string `json:"secondaryDnsServers,omitempty"`
	// SecondaryIpv6DNSServers - The secondary IPv6 DNS server for the device
	SecondaryIpv6DNSServers *[]string `json:"secondaryIpv6DnsServers,omitempty"`
}

// EncryptionSettings the encryption settings.
type EncryptionSettings struct {
	autorest.Response `json:"-"`
	// EncryptionSettingsProperties - The properties of the encryption settings.
	*EncryptionSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionSettings.
func (es EncryptionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.EncryptionSettingsProperties != nil {
		objectMap["properties"] = es.EncryptionSettingsProperties
	}
	if es.Kind != "" {
		objectMap["kind"] = es.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EncryptionSettings struct.
func (es *EncryptionSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var encryptionSettingsProperties EncryptionSettingsProperties
				err = json.Unmarshal(*v, &encryptionSettingsProperties)
				if err != nil {
					return err
				}
				es.EncryptionSettingsProperties = &encryptionSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				es.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				es.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				es.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				es.Kind = kind
			}
		}
	}

	return nil
}

// EncryptionSettingsProperties the properties of encryption settings.
type EncryptionSettingsProperties struct {
	// EncryptionStatus - The encryption status to indicates if encryption is enabled or not. Possible values include: 'EncryptionStatusEnabled', 'EncryptionStatusDisabled'
	EncryptionStatus EncryptionStatus `json:"encryptionStatus,omitempty"`
	// KeyRolloverStatus - The key rollover status to indicates if key rollover is required or not. If secret's encryption has been upgraded, then it requires key rollover. Possible values include: 'Required', 'NotRequired'
	KeyRolloverStatus KeyRolloverStatus `json:"keyRolloverStatus,omitempty"`
}

// FailoverRequest the request object for triggering a failover of volume containers, from a source device
// to a target device.
type FailoverRequest struct {
	// TargetDeviceID - The ARM path ID of the device which will act as the failover target.
	TargetDeviceID *string `json:"targetDeviceId,omitempty"`
	// VolumeContainers - The list of path IDs of the volume containers which needs to be failed-over to the target device.
	VolumeContainers *[]string `json:"volumeContainers,omitempty"`
}

// FailoverSet the failover set on a device.
type FailoverSet struct {
	// VolumeContainers - The list of meta data of volume containers, which are part of the failover set.
	VolumeContainers *[]VolumeContainerFailoverMetadata `json:"volumeContainers,omitempty"`
	// EligibilityResult - The eligibility result of the failover set, for failover.
	EligibilityResult *FailoverSetEligibilityResult `json:"eligibilityResult,omitempty"`
}

// FailoverSetEligibilityResult the eligibility result of failover set, for failover.
type FailoverSetEligibilityResult struct {
	// IsEligibleForFailover - Represents if this failover set is eligible for failover or not.
	IsEligibleForFailover *bool `json:"isEligibleForFailover,omitempty"`
	// ErrorMessage - The error message, if the failover set is not eligible for failover.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// FailoverSetsList the list of failover sets.
type FailoverSetsList struct {
	autorest.Response `json:"-"`
	// Value - The list of failover sets.
	Value *[]FailoverSet `json:"value,omitempty"`
}

// FailoverTarget represents the eligibility of a device as a failover target device.
type FailoverTarget struct {
	// DeviceID - The path ID of the device.
	DeviceID *string `json:"deviceId,omitempty"`
	// DeviceStatus - The status of the device. Possible values include: 'Unknown', 'Online', 'Offline', 'Deactivated', 'RequiresAttention', 'MaintenanceMode', 'Creating', 'Provisioning', 'Deactivating', 'Deleted', 'ReadyToSetup'
	DeviceStatus DeviceStatus `json:"deviceStatus,omitempty"`
	// ModelDescription - The model number of the device.
	ModelDescription *string `json:"modelDescription,omitempty"`
	// DeviceSoftwareVersion - The software version of the device.
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty"`
	// DataContainersCount - The count of data containers on the device.
	DataContainersCount *int32 `json:"dataContainersCount,omitempty"`
	// VolumesCount - The count of volumes on the device.
	VolumesCount *int32 `json:"volumesCount,omitempty"`
	// AvailableLocalStorageInBytes - The amount of free local storage available on the device in bytes.
	AvailableLocalStorageInBytes *int64 `json:"availableLocalStorageInBytes,omitempty"`
	// AvailableTieredStorageInBytes - The amount of free tiered storage available for the device in bytes.
	AvailableTieredStorageInBytes *int64 `json:"availableTieredStorageInBytes,omitempty"`
	// DeviceLocation - The geo location (applicable only for cloud appliances) of the device.
	DeviceLocation *string `json:"deviceLocation,omitempty"`
	// FriendlyDeviceSoftwareVersion - The friendly name for the current version of software on the device.
	FriendlyDeviceSoftwareVersion *string `json:"friendlyDeviceSoftwareVersion,omitempty"`
	// EligibilityResult - The eligibility result of the device, as a failover target device.
	EligibilityResult *TargetEligibilityResult `json:"eligibilityResult,omitempty"`
}

// FailoverTargetsList the list of all devices in a resource and their eligibility status as a failover
// target device.
type FailoverTargetsList struct {
	autorest.Response `json:"-"`
	// Value - The list of all the failover targets.
	Value *[]FailoverTarget `json:"value,omitempty"`
}

// Feature the feature.
type Feature struct {
	// Name - The name of the feature.
	Name *string `json:"name,omitempty"`
	// Status - The feature support status. Possible values include: 'NotAvailable', 'UnsupportedDeviceVersion', 'Supported'
	Status FeatureSupportStatus `json:"status,omitempty"`
}

// FeatureFilter the OData filter to be used for features.
type FeatureFilter struct {
	// DeviceID - Specifies the device ID for which the features are required. Only 'Equality' operator is supported for this property.
	DeviceID *string `json:"deviceId,omitempty"`
}

// FeatureList the collections of features.
type FeatureList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Feature `json:"value,omitempty"`
}

// HardwareComponent the hardware component.
type HardwareComponent struct {
	// ComponentID - The component ID.
	ComponentID *string `json:"componentId,omitempty"`
	// DisplayName - The display name of the hardware component.
	DisplayName *string `json:"displayName,omitempty"`
	// Status - The status of the hardware component. Possible values include: 'HardwareComponentStatusUnknown', 'HardwareComponentStatusNotPresent', 'HardwareComponentStatusPoweredOff', 'HardwareComponentStatusOk', 'HardwareComponentStatusRecovering', 'HardwareComponentStatusWarning', 'HardwareComponentStatusFailure'
	Status HardwareComponentStatus `json:"status,omitempty"`
	// StatusDisplayName - The display name of the status of hardware component.
	StatusDisplayName *string `json:"statusDisplayName,omitempty"`
}

// HardwareComponentGroup the hardware component group.
type HardwareComponentGroup struct {
	// HardwareComponentGroupProperties - The properties of the hardware component group.
	*HardwareComponentGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for HardwareComponentGroup.
func (hcg HardwareComponentGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hcg.HardwareComponentGroupProperties != nil {
		objectMap["properties"] = hcg.HardwareComponentGroupProperties
	}
	if hcg.Kind != "" {
		objectMap["kind"] = hcg.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HardwareComponentGroup struct.
func (hcg *HardwareComponentGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hardwareComponentGroupProperties HardwareComponentGroupProperties
				err = json.Unmarshal(*v, &hardwareComponentGroupProperties)
				if err != nil {
					return err
				}
				hcg.HardwareComponentGroupProperties = &hardwareComponentGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hcg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hcg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hcg.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hcg.Kind = kind
			}
		}
	}

	return nil
}

// HardwareComponentGroupList the collection of hardware component groups.
type HardwareComponentGroupList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]HardwareComponentGroup `json:"value,omitempty"`
}

// HardwareComponentGroupProperties the properties of hardware component group.
type HardwareComponentGroupProperties struct {
	// DisplayName - The display name the hardware component group.
	DisplayName *string `json:"displayName,omitempty"`
	// LastUpdatedTime - The last updated time.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// Components - The list of hardware components.
	Components *[]HardwareComponent `json:"components,omitempty"`
}

// HardwareComponentGroupsChangeControllerPowerStateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type HardwareComponentGroupsChangeControllerPowerStateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HardwareComponentGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HardwareComponentGroupsChangeControllerPowerStateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HardwareComponentGroupsChangeControllerPowerStateFuture.Result.
func (future *HardwareComponentGroupsChangeControllerPowerStateFuture) result(client HardwareComponentGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.HardwareComponentGroupsChangeControllerPowerStateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.HardwareComponentGroupsChangeControllerPowerStateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Job the job.
type Job struct {
	autorest.Response `json:"-"`
	// Status - The current status of the job. Possible values include: 'Running', 'Succeeded', 'Failed', 'Canceled'
	Status JobStatus `json:"status,omitempty"`
	// StartTime - The UTC time at which the job was started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The UTC time at which the job completed.
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - The percentage of the job that is already complete.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// Error - The error details, if any, for the job.
	Error *JobErrorDetails `json:"error,omitempty"`
	// JobProperties - The properties of the job.
	*JobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.Status != "" {
		objectMap["status"] = j.Status
	}
	if j.StartTime != nil {
		objectMap["startTime"] = j.StartTime
	}
	if j.EndTime != nil {
		objectMap["endTime"] = j.EndTime
	}
	if j.PercentComplete != nil {
		objectMap["percentComplete"] = j.PercentComplete
	}
	if j.Error != nil {
		objectMap["error"] = j.Error
	}
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	if j.Kind != "" {
		objectMap["kind"] = j.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status JobStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				j.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				j.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				j.EndTime = &endTime
			}
		case "percentComplete":
			if v != nil {
				var percentComplete int32
				err = json.Unmarshal(*v, &percentComplete)
				if err != nil {
					return err
				}
				j.PercentComplete = &percentComplete
			}
		case "error":
			if v != nil {
				var errorVar JobErrorDetails
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				j.Error = &errorVar
			}
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				j.Kind = kind
			}
		}
	}

	return nil
}

// JobErrorDetails the job error details. Contains list of job error items.
type JobErrorDetails struct {
	// ErrorDetails - The error details.
	ErrorDetails *[]JobErrorItem `json:"errorDetails,omitempty"`
	// Code - The error code intended for programmatic access.
	Code *string `json:"code,omitempty"`
	// Message - The error message intended to describe the error in detail.
	Message *string `json:"message,omitempty"`
}

// JobErrorItem the job error items.
type JobErrorItem struct {
	// Recommendations - The recommended actions.
	Recommendations *[]string `json:"recommendations,omitempty"`
	// Code - The error code intended for programmatic access.
	Code *string `json:"code,omitempty"`
	// Message - The error message intended to describe the error in detail.
	Message *string `json:"message,omitempty"`
}

// JobFilter the OData filter to be used for jobs.
type JobFilter struct {
	// Status - Specifies the status of the jobs to be filtered. For e.g., "Running", "Succeeded", "Failed" or "Canceled". Only 'Equality' operator is supported for this property.
	Status *string `json:"status,omitempty"`
	// JobType - Specifies the type of the jobs to be filtered. For e.g., "ScheduledBackup", "ManualBackup", "RestoreBackup", "CloneVolume", "FailoverVolumeContainers", "CreateLocallyPinnedVolume", "ModifyVolume", "InstallUpdates", "SupportPackageLogs", or "CreateCloudAppliance". Only 'Equality' operator can be used for this property.
	JobType *string `json:"jobType,omitempty"`
	// StartTime - Specifies the start time of the jobs to be filtered.  Only 'Greater Than or Equal To' and 'Lesser Than or Equal To' operators are supported for this property.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// JobList the collection of jobs.
type JobList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobListIterator provides access to a complete listing of Job values.
type JobListIterator struct {
	i    int
	page JobListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListIterator) Response() JobList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobListIterator type.
func NewJobListIterator(page JobListPage) JobListIterator {
	return JobListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jl JobList) IsEmpty() bool {
	return jl.Value == nil || len(*jl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jl JobList) hasNextLink() bool {
	return jl.NextLink != nil && len(*jl.NextLink) != 0
}

// jobListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jl JobList) jobListPreparer(ctx context.Context) (*http.Request, error) {
	if !jl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jl.NextLink)))
}

// JobListPage contains a page of Job values.
type JobListPage struct {
	fn func(context.Context, JobList) (JobList, error)
	jl JobList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jl)
		if err != nil {
			return err
		}
		page.jl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListPage) NotDone() bool {
	return !page.jl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListPage) Response() JobList {
	return page.jl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListPage) Values() []Job {
	if page.jl.IsEmpty() {
		return nil
	}
	return *page.jl.Value
}

// Creates a new instance of the JobListPage type.
func NewJobListPage(cur JobList, getNextPage func(context.Context, JobList) (JobList, error)) JobListPage {
	return JobListPage{
		fn: getNextPage,
		jl: cur,
	}
}

// JobProperties the properties of the job.
type JobProperties struct {
	// JobType - The type of the job. Possible values include: 'ScheduledBackup', 'ManualBackup', 'RestoreBackup', 'CloneVolume', 'FailoverVolumeContainers', 'CreateLocallyPinnedVolume', 'ModifyVolume', 'InstallUpdates', 'SupportPackageLogs', 'CreateCloudAppliance'
	JobType JobType `json:"jobType,omitempty"`
	// DataStats - The data statistics properties of the job.
	DataStats *DataStatistics `json:"dataStats,omitempty"`
	// EntityLabel - The entity identifier for which the job ran.
	EntityLabel *string `json:"entityLabel,omitempty"`
	// EntityType - The entity type for which the job ran.
	EntityType *string `json:"entityType,omitempty"`
	// JobStages - The job stages.
	JobStages *[]JobStage `json:"jobStages,omitempty"`
	// DeviceID - The device ID in which the job ran.
	DeviceID *string `json:"deviceId,omitempty"`
	// IsCancellable - Represents whether the job is cancellable or not.
	IsCancellable *bool `json:"isCancellable,omitempty"`
	// BackupType - The backup type (CloudSnapshot | LocalSnapshot). Applicable only for backup jobs. Possible values include: 'LocalSnapshot', 'CloudSnapshot'
	BackupType BackupType `json:"backupType,omitempty"`
	// SourceDeviceID - The source device ID of the failover job.
	SourceDeviceID *string `json:"sourceDeviceId,omitempty"`
	// BackupPointInTime - The time of the backup used for the failover.
	BackupPointInTime *date.Time `json:"backupPointInTime,omitempty"`
}

// JobsCancelFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsCancelFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JobsCancelFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JobsCancelFuture.Result.
func (future *JobsCancelFuture) result(client JobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.JobsCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.JobsCancelFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobStage the details about the specific stage of a job.
type JobStage struct {
	// Message - The message of the job stage.
	Message *string `json:"message,omitempty"`
	// StageStatus - The stage status. Possible values include: 'Running', 'Succeeded', 'Failed', 'Canceled'
	StageStatus JobStatus `json:"stageStatus,omitempty"`
	// Detail - The details of the stage.
	Detail *string `json:"detail,omitempty"`
	// ErrorCode - The error code of the stage if any.
	ErrorCode *string `json:"errorCode,omitempty"`
}

// Key the key.
type Key struct {
	autorest.Response `json:"-"`
	// ActivationKey - The activation key for the device.
	ActivationKey *string `json:"activationKey,omitempty"`
}

// ListFailoverTargetsRequest the request object for fetching the list of failover targets (eligible
// devices for failover).
type ListFailoverTargetsRequest struct {
	// VolumeContainers - The list of path IDs of the volume containers that needs to be failed-over, for which we want to fetch the eligible targets.
	VolumeContainers *[]string `json:"volumeContainers,omitempty"`
}

// Manager the StorSimple Manager.
type Manager struct {
	autorest.Response `json:"-"`
	// ManagerProperties - The properties of the StorSimple Manager.
	*ManagerProperties `json:"properties,omitempty"`
	// Etag - The etag of the manager.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The geo location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Manager.
func (mVar Manager) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.ManagerProperties != nil {
		objectMap["properties"] = mVar.ManagerProperties
	}
	if mVar.Etag != nil {
		objectMap["etag"] = mVar.Etag
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Manager struct.
func (mVar *Manager) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managerProperties ManagerProperties
				err = json.Unmarshal(*v, &managerProperties)
				if err != nil {
					return err
				}
				mVar.ManagerProperties = &managerProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mVar.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		}
	}

	return nil
}

// ManagerExtendedInfo the extended info of the manager.
type ManagerExtendedInfo struct {
	autorest.Response `json:"-"`
	// ManagerExtendedInfoProperties - The extended info properties.
	*ManagerExtendedInfoProperties `json:"properties,omitempty"`
	// Etag - The etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagerExtendedInfo.
func (mei ManagerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mei.ManagerExtendedInfoProperties != nil {
		objectMap["properties"] = mei.ManagerExtendedInfoProperties
	}
	if mei.Etag != nil {
		objectMap["etag"] = mei.Etag
	}
	if mei.Kind != "" {
		objectMap["kind"] = mei.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagerExtendedInfo struct.
func (mei *ManagerExtendedInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managerExtendedInfoProperties ManagerExtendedInfoProperties
				err = json.Unmarshal(*v, &managerExtendedInfoProperties)
				if err != nil {
					return err
				}
				mei.ManagerExtendedInfoProperties = &managerExtendedInfoProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mei.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mei.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mei.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mei.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mei.Kind = kind
			}
		}
	}

	return nil
}

// ManagerExtendedInfoProperties the properties of the manager extended info.
type ManagerExtendedInfoProperties struct {
	// Version - The version of the extended info being persisted.
	Version *string `json:"version,omitempty"`
	// IntegrityKey - Represents the CIK of the resource.
	IntegrityKey *string `json:"integrityKey,omitempty"`
	// EncryptionKey - Represents the CEK of the resource.
	EncryptionKey *string `json:"encryptionKey,omitempty"`
	// EncryptionKeyThumbprint - Represents the Cert thumbprint that was used to encrypt the CEK.
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`
	// PortalCertificateThumbprint - Represents the portal thumbprint which can be used optionally to encrypt the entire data before storing it.
	PortalCertificateThumbprint *string `json:"portalCertificateThumbprint,omitempty"`
	// Algorithm - Represents the encryption algorithm used to encrypt the keys. None - if Key is saved in plain text format. Algorithm name - if key is encrypted
	Algorithm *string `json:"algorithm,omitempty"`
}

// ManagerIntrinsicSettings intrinsic settings which refers to the type of the StorSimple Manager.
type ManagerIntrinsicSettings struct {
	// Type - The type of StorSimple Manager. Possible values include: 'GardaV1', 'HelsinkiV1'
	Type ManagerType `json:"type,omitempty"`
}

// ManagerList the list of StorSimple Managers.
type ManagerList struct {
	autorest.Response `json:"-"`
	// Value - The list of StorSimple managers.
	Value *[]Manager `json:"value,omitempty"`
}

// ManagerPatch the StorSimple Manager patch.
type ManagerPatch struct {
	// Tags - The tags attached to the Manager.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagerPatch.
func (mp ManagerPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.Tags != nil {
		objectMap["tags"] = mp.Tags
	}
	return json.Marshal(objectMap)
}

// ManagerProperties the properties of the StorSimple Manager.
type ManagerProperties struct {
	// CisIntrinsicSettings - Represents the type of StorSimple Manager.
	CisIntrinsicSettings *ManagerIntrinsicSettings `json:"cisIntrinsicSettings,omitempty"`
	// Sku - Specifies the Sku.
	Sku *ManagerSku `json:"sku,omitempty"`
	// ProvisioningState - Specifies the state of the resource as it is getting provisioned. Value of "Succeeded" means the Manager was successfully created.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ManagerSku the Sku.
type ManagerSku struct {
	// Name - Refers to the sku name which should be "Standard"
	Name *string `json:"name,omitempty"`
}

// MetricAvailablity the metric availability.
type MetricAvailablity struct {
	// TimeGrain - The aggregation interval for the metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - The retention period for the metric at the specified timegrain.
	Retention *string `json:"retention,omitempty"`
}

// MetricData the metric data.
type MetricData struct {
	// TimeStamp - The time stamp of the metric data.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// Sum - The sum of all samples at the time stamp.
	Sum *float64 `json:"sum,omitempty"`
	// Count - The count of all samples at the time stamp.
	Count *int32 `json:"count,omitempty"`
	// Average - The average of all samples at the time stamp.
	Average *float64 `json:"average,omitempty"`
	// Minimum - The minimum of all samples at the time stamp.
	Minimum *float64 `json:"minimum,omitempty"`
	// Maximum - The maximum of all samples at the time stamp.
	Maximum *float64 `json:"maximum,omitempty"`
}

// MetricDefinition the monitoring metric definition.
type MetricDefinition struct {
	// Name - The metric name.
	Name *MetricName `json:"name,omitempty"`
	// Unit - The metric unit. Possible values include: 'Bytes', 'BytesPerSecond', 'Count', 'CountPerSecond', 'Percent', 'Seconds'
	Unit MetricUnit `json:"unit,omitempty"`
	// PrimaryAggregationType - The metric aggregation type. Possible values include: 'MetricAggregationTypeAverage', 'MetricAggregationTypeLast', 'MetricAggregationTypeMaximum', 'MetricAggregationTypeMinimum', 'MetricAggregationTypeNone', 'MetricAggregationTypeTotal'
	PrimaryAggregationType MetricAggregationType `json:"primaryAggregationType,omitempty"`
	// ResourceID - The metric source ID.
	ResourceID *string `json:"resourceId,omitempty"`
	// MetricAvailabilities - The available metric granularities.
	MetricAvailabilities *[]MetricAvailablity `json:"metricAvailabilities,omitempty"`
	// Dimensions - The available metric dimensions.
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// Category - The category of the metric.
	Category *string `json:"category,omitempty"`
	// Type - The metric definition type.
	Type *string `json:"type,omitempty"`
}

// MetricDefinitionList the list of metric definitions.
type MetricDefinitionList struct {
	autorest.Response `json:"-"`
	// Value - The list of metric definitions.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricDimension the metric dimension. It indicates the source of the metric.
type MetricDimension struct {
	// Name - The metric dimension name.
	Name *string `json:"name,omitempty"`
	// Value - The metric dimension values.
	Value *string `json:"value,omitempty"`
}

// MetricFilter the OData filters to be used for metrics.
type MetricFilter struct {
	// Name - Specifies the metric name filter specifying the name of the metric to be filtered on. Only 'Equality' operator is supported for this property.
	Name *MetricNameFilter `json:"name,omitempty"`
	// StartTime - Specifies the start time of the time range to be queried. Only 'Greater Than Or Equal To' operator is supported for this property.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Specifies the end time of the time range to be queried. Only 'Less Than Or Equal To' operator is supported for this property.
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - Specifies the time granularity of the metrics to be returned. E.g., "P1D". Valid values are the ones returned as the field "timeGrain" in the ListMetricDefinitions call. Only 'Equality' operator is supported for this property.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Category - Specifies the category of the metrics to be filtered. E.g., "CapacityUtilization". Valid values are the ones returned as the field "category" in the ListMetricDefinitions call. Only 'Equality' operator is supported for this property.
	Category *string `json:"category,omitempty"`
	// Dimensions - Specifies the source(the dimension) of the metrics to be filtered. Only 'Equality' operator is supported for this property.
	Dimensions *DimensionFilter `json:"dimensions,omitempty"`
}

// MetricList the metric list.
type MetricList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Metrics `json:"value,omitempty"`
}

// MetricName the metric name.
type MetricName struct {
	// Value - The metric name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The localized metric name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricNameFilter the metric name filter, specifying the name of the metric to be filtered on.
type MetricNameFilter struct {
	// Value - Specifies the metric name to be filtered on. E.g., CloudStorageUsed. Valid values are the ones returned in the field "name" in the ListMetricDefinitions call. Only 'Equality' operator is supported for this property.
	Value *string `json:"value,omitempty"`
}

// Metrics the monitoring metric.
type Metrics struct {
	// ResourceID - The ID of metric source.
	ResourceID *string `json:"resourceId,omitempty"`
	// StartTime - The start time of the metric data.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the metric data.
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - The time granularity of the metric data.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// PrimaryAggregation - The metric aggregation type. Possible values include: 'MetricAggregationTypeAverage', 'MetricAggregationTypeLast', 'MetricAggregationTypeMaximum', 'MetricAggregationTypeMinimum', 'MetricAggregationTypeNone', 'MetricAggregationTypeTotal'
	PrimaryAggregation MetricAggregationType `json:"primaryAggregation,omitempty"`
	// Name - The name of the metric.
	Name *MetricName `json:"name,omitempty"`
	// Dimensions - The metric dimensions.
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// Unit - The unit of the metric data. Possible values include: 'Bytes', 'BytesPerSecond', 'Count', 'CountPerSecond', 'Percent', 'Seconds'
	Unit MetricUnit `json:"unit,omitempty"`
	// Type - The type of the metric data.
	Type *string `json:"type,omitempty"`
	// Values - The list of the metric data.
	Values *[]MetricData `json:"values,omitempty"`
}

// NetworkAdapterList the collection of network adapters on the device.
type NetworkAdapterList struct {
	// Value - The value.
	Value *[]NetworkAdapters `json:"value,omitempty"`
}

// NetworkAdapters represents the network adapter on device.
type NetworkAdapters struct {
	// InterfaceID - The ID of the network adapter. Possible values include: 'NetInterfaceIDInvalid', 'NetInterfaceIDData0', 'NetInterfaceIDData1', 'NetInterfaceIDData2', 'NetInterfaceIDData3', 'NetInterfaceIDData4', 'NetInterfaceIDData5'
	InterfaceID NetInterfaceID `json:"interfaceId,omitempty"`
	// NetInterfaceStatus - Value indicating status of network adapter. Possible values include: 'NetInterfaceStatusEnabled', 'NetInterfaceStatusDisabled'
	NetInterfaceStatus NetInterfaceStatus `json:"netInterfaceStatus,omitempty"`
	// IsDefault - Value indicating whether this instance is default.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IscsiAndCloudStatus - Value indicating cloud and ISCSI status of network adapter. Possible values include: 'ISCSIAndCloudStatusDisabled', 'ISCSIAndCloudStatusIscsiEnabled', 'ISCSIAndCloudStatusCloudEnabled', 'ISCSIAndCloudStatusIscsiAndCloudEnabled'
	IscsiAndCloudStatus ISCSIAndCloudStatus `json:"iscsiAndCloudStatus,omitempty"`
	// Speed - The speed of the network adapter.
	Speed *int64 `json:"speed,omitempty"`
	// Mode - The mode of network adapter, either IPv4, IPv6 or both. Possible values include: 'NetworkModeInvalid', 'NetworkModeIPV4', 'NetworkModeIPV6', 'NetworkModeBOTH'
	Mode NetworkMode `json:"mode,omitempty"`
	// NicIpv4Settings - The IPv4 configuration of the network adapter.
	NicIpv4Settings *NicIPv4 `json:"nicIpv4Settings,omitempty"`
	// NicIpv6Settings - The IPv6 configuration of the network adapter.
	NicIpv6Settings *NicIPv6 `json:"nicIpv6Settings,omitempty"`
}

// NetworkInterfaceData0Settings the 'Data 0' network interface card settings.
type NetworkInterfaceData0Settings struct {
	// ControllerZeroIP - The controller 0's IPv4 address.
	ControllerZeroIP *string `json:"controllerZeroIp,omitempty"`
	// ControllerOneIP - The controller 1's IPv4 address.
	ControllerOneIP *string `json:"controllerOneIp,omitempty"`
}

// NetworkSettings represents the network settings of a device.
type NetworkSettings struct {
	autorest.Response `json:"-"`
	// NetworkSettingsProperties - The properties of network settings of a device.
	*NetworkSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkSettings.
func (ns NetworkSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ns.NetworkSettingsProperties != nil {
		objectMap["properties"] = ns.NetworkSettingsProperties
	}
	if ns.Kind != "" {
		objectMap["kind"] = ns.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkSettings struct.
func (ns *NetworkSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkSettingsProperties NetworkSettingsProperties
				err = json.Unmarshal(*v, &networkSettingsProperties)
				if err != nil {
					return err
				}
				ns.NetworkSettingsProperties = &networkSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ns.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ns.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ns.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ns.Kind = kind
			}
		}
	}

	return nil
}

// NetworkSettingsPatch represents the patch request for the network settings of a device.
type NetworkSettingsPatch struct {
	// NetworkSettingsPatchProperties - The properties of the network settings patch.
	*NetworkSettingsPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkSettingsPatch.
func (nsp NetworkSettingsPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nsp.NetworkSettingsPatchProperties != nil {
		objectMap["properties"] = nsp.NetworkSettingsPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkSettingsPatch struct.
func (nsp *NetworkSettingsPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkSettingsPatchProperties NetworkSettingsPatchProperties
				err = json.Unmarshal(*v, &networkSettingsPatchProperties)
				if err != nil {
					return err
				}
				nsp.NetworkSettingsPatchProperties = &networkSettingsPatchProperties
			}
		}
	}

	return nil
}

// NetworkSettingsPatchProperties the properties of the network settings patch.
type NetworkSettingsPatchProperties struct {
	// DNSSettings - The DNS (Domain Name System) settings of device.
	DNSSettings *DNSSettings `json:"dnsSettings,omitempty"`
	// NetworkAdapters - The network adapter list of device.
	NetworkAdapters *NetworkAdapterList `json:"networkAdapters,omitempty"`
}

// NetworkSettingsProperties the properties of the network settings of device.
type NetworkSettingsProperties struct {
	// DNSSettings - The DNS (Domain Name System) settings of device.
	DNSSettings *DNSSettings `json:"dnsSettings,omitempty"`
	// NetworkAdapters - The network adapter list of device.
	NetworkAdapters *NetworkAdapterList `json:"networkAdapters,omitempty"`
	// WebproxySettings - The webproxy settings of device.
	WebproxySettings *WebproxySettings `json:"webproxySettings,omitempty"`
}

// NicIPv4 details related to the IPv4 address configuration.
type NicIPv4 struct {
	// Ipv4Address - The IPv4 address of the network adapter.
	Ipv4Address *string `json:"ipv4Address,omitempty"`
	// Ipv4Netmask - The IPv4 netmask of the network adapter.
	Ipv4Netmask *string `json:"ipv4Netmask,omitempty"`
	// Ipv4Gateway - The IPv4 gateway of the network adapter.
	Ipv4Gateway *string `json:"ipv4Gateway,omitempty"`
	// Controller0Ipv4Address - The IPv4 address of Controller0.
	Controller0Ipv4Address *string `json:"controller0Ipv4Address,omitempty"`
	// Controller1Ipv4Address - The IPv4 address of Controller1.
	Controller1Ipv4Address *string `json:"controller1Ipv4Address,omitempty"`
}

// NicIPv6 details related to the IPv6 address configuration.
type NicIPv6 struct {
	// Ipv6Address - The IPv6 address of the network adapter.
	Ipv6Address *string `json:"ipv6Address,omitempty"`
	// Ipv6Prefix - The IPv6 prefix of the network adapter.
	Ipv6Prefix *string `json:"ipv6Prefix,omitempty"`
	// Ipv6Gateway - The IPv6 gateway of the network adapter.
	Ipv6Gateway *string `json:"ipv6Gateway,omitempty"`
	// Controller0Ipv6Address - The IPv6 address of Controller0.
	Controller0Ipv6Address *string `json:"controller0Ipv6Address,omitempty"`
	// Controller1Ipv6Address - The IPv6 address of Controller1.
	Controller1Ipv6Address *string `json:"controller1Ipv6Address,omitempty"`
}

// PublicKey the public key.
type PublicKey struct {
	autorest.Response `json:"-"`
	// Key - The key.
	Key *string `json:"key,omitempty"`
}

// RemoteManagementSettings the settings for remote management of a device.
type RemoteManagementSettings struct {
	// RemoteManagementMode - The remote management mode. Possible values include: 'RemoteManagementModeConfigurationUnknown', 'RemoteManagementModeConfigurationDisabled', 'RemoteManagementModeConfigurationHTTPSEnabled', 'RemoteManagementModeConfigurationHTTPSAndHTTPEnabled'
	RemoteManagementMode RemoteManagementModeConfiguration `json:"remoteManagementMode,omitempty"`
	// RemoteManagementCertificate - The remote management certificates.
	RemoteManagementCertificate *string `json:"remoteManagementCertificate,omitempty"`
}

// RemoteManagementSettingsPatch the settings for updating remote management mode of the device.
type RemoteManagementSettingsPatch struct {
	// RemoteManagementMode - The remote management mode. Possible values include: 'RemoteManagementModeConfigurationUnknown', 'RemoteManagementModeConfigurationDisabled', 'RemoteManagementModeConfigurationHTTPSEnabled', 'RemoteManagementModeConfigurationHTTPSAndHTTPEnabled'
	RemoteManagementMode RemoteManagementModeConfiguration `json:"remoteManagementMode,omitempty"`
}

// Resource the Azure Resource.
type Resource struct {
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The geo location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ScheduleRecurrence the schedule recurrence.
type ScheduleRecurrence struct {
	// RecurrenceType - The recurrence type. Possible values include: 'Minutes', 'Hourly', 'Daily', 'Weekly'
	RecurrenceType RecurrenceType `json:"recurrenceType,omitempty"`
	// RecurrenceValue - The recurrence value.
	RecurrenceValue *int32 `json:"recurrenceValue,omitempty"`
	// WeeklyDaysList - The week days list. Applicable only for schedules of recurrence type 'weekly'.
	WeeklyDaysList *[]DayOfWeek `json:"weeklyDaysList,omitempty"`
}

// SecondaryDNSSettings the secondary DNS settings.
type SecondaryDNSSettings struct {
	// SecondaryDNSServers - The list of secondary DNS Server IP addresses.
	SecondaryDNSServers *[]string `json:"secondaryDnsServers,omitempty"`
}

// SecuritySettings the security settings of a device.
type SecuritySettings struct {
	autorest.Response `json:"-"`
	// SecuritySettingsProperties - The properties of the security settings of a device.
	*SecuritySettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for SecuritySettings.
func (ss SecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.SecuritySettingsProperties != nil {
		objectMap["properties"] = ss.SecuritySettingsProperties
	}
	if ss.Kind != "" {
		objectMap["kind"] = ss.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecuritySettings struct.
func (ss *SecuritySettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securitySettingsProperties SecuritySettingsProperties
				err = json.Unmarshal(*v, &securitySettingsProperties)
				if err != nil {
					return err
				}
				ss.SecuritySettingsProperties = &securitySettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ss.Kind = kind
			}
		}
	}

	return nil
}

// SecuritySettingsPatch represents the patch request for the security settings of a device.
type SecuritySettingsPatch struct {
	// SecuritySettingsPatchProperties - The properties of the security settings patch.
	*SecuritySettingsPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SecuritySettingsPatch.
func (ssp SecuritySettingsPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssp.SecuritySettingsPatchProperties != nil {
		objectMap["properties"] = ssp.SecuritySettingsPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecuritySettingsPatch struct.
func (ssp *SecuritySettingsPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securitySettingsPatchProperties SecuritySettingsPatchProperties
				err = json.Unmarshal(*v, &securitySettingsPatchProperties)
				if err != nil {
					return err
				}
				ssp.SecuritySettingsPatchProperties = &securitySettingsPatchProperties
			}
		}
	}

	return nil
}

// SecuritySettingsPatchProperties the properties of the security settings patch.
type SecuritySettingsPatchProperties struct {
	// RemoteManagementSettings - The remote management settings.
	RemoteManagementSettings *RemoteManagementSettingsPatch `json:"remoteManagementSettings,omitempty"`
	// DeviceAdminPassword - The device administrator password.
	DeviceAdminPassword *AsymmetricEncryptedSecret `json:"deviceAdminPassword,omitempty"`
	// SnapshotPassword - The snapshot manager password.
	SnapshotPassword *AsymmetricEncryptedSecret `json:"snapshotPassword,omitempty"`
	// ChapSettings - The device CHAP and reverse-CHAP settings.
	ChapSettings *ChapSettings `json:"chapSettings,omitempty"`
	// CloudApplianceSettings - The cloud appliance settings.
	CloudApplianceSettings *CloudApplianceSettings `json:"cloudApplianceSettings,omitempty"`
}

// SecuritySettingsProperties the properties of security settings of a device.
type SecuritySettingsProperties struct {
	// RemoteManagementSettings - The settings for remote management of a device.
	RemoteManagementSettings *RemoteManagementSettings `json:"remoteManagementSettings,omitempty"`
	// ChapSettings - The Challenge-Handshake Authentication Protocol (CHAP) settings.
	ChapSettings *ChapSettings `json:"chapSettings,omitempty"`
}

// SendTestAlertEmailRequest the request for sending test alert email
type SendTestAlertEmailRequest struct {
	// EmailList - The list of email IDs to send the test alert email
	EmailList *[]string `json:"emailList,omitempty"`
}

// StorageAccountCredential the storage account credential.
type StorageAccountCredential struct {
	autorest.Response `json:"-"`
	// StorageAccountCredentialProperties - The storage account credential properties.
	*StorageAccountCredentialProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountCredential.
func (sac StorageAccountCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sac.StorageAccountCredentialProperties != nil {
		objectMap["properties"] = sac.StorageAccountCredentialProperties
	}
	if sac.Kind != "" {
		objectMap["kind"] = sac.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageAccountCredential struct.
func (sac *StorageAccountCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageAccountCredentialProperties StorageAccountCredentialProperties
				err = json.Unmarshal(*v, &storageAccountCredentialProperties)
				if err != nil {
					return err
				}
				sac.StorageAccountCredentialProperties = &storageAccountCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sac.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sac.Kind = kind
			}
		}
	}

	return nil
}

// StorageAccountCredentialList the collection of storage account credential entities.
type StorageAccountCredentialList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]StorageAccountCredential `json:"value,omitempty"`
}

// StorageAccountCredentialProperties the storage account credential properties.
type StorageAccountCredentialProperties struct {
	// EndPoint - The storage endpoint
	EndPoint *string `json:"endPoint,omitempty"`
	// SslStatus - Signifies whether SSL needs to be enabled or not. Possible values include: 'SslStatusEnabled', 'SslStatusDisabled'
	SslStatus SslStatus `json:"sslStatus,omitempty"`
	// AccessKey - The details of the storage account password.
	AccessKey *AsymmetricEncryptedSecret `json:"accessKey,omitempty"`
	// VolumesCount - READ-ONLY; The count of volumes using this storage account credential.
	VolumesCount *int32 `json:"volumesCount,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountCredentialProperties.
func (sacp StorageAccountCredentialProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sacp.EndPoint != nil {
		objectMap["endPoint"] = sacp.EndPoint
	}
	if sacp.SslStatus != "" {
		objectMap["sslStatus"] = sacp.SslStatus
	}
	if sacp.AccessKey != nil {
		objectMap["accessKey"] = sacp.AccessKey
	}
	return json.Marshal(objectMap)
}

// StorageAccountCredentialsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type StorageAccountCredentialsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StorageAccountCredentialsClient) (StorageAccountCredential, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StorageAccountCredentialsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StorageAccountCredentialsCreateOrUpdateFuture.Result.
func (future *StorageAccountCredentialsCreateOrUpdateFuture) result(client StorageAccountCredentialsClient) (sac StorageAccountCredential, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.StorageAccountCredentialsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sac.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.StorageAccountCredentialsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sac.Response.Response, err = future.GetResult(sender); err == nil && sac.Response.Response.StatusCode != http.StatusNoContent {
		sac, err = client.CreateOrUpdateResponder(sac.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.StorageAccountCredentialsCreateOrUpdateFuture", "Result", sac.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StorageAccountCredentialsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StorageAccountCredentialsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StorageAccountCredentialsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StorageAccountCredentialsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StorageAccountCredentialsDeleteFuture.Result.
func (future *StorageAccountCredentialsDeleteFuture) result(client StorageAccountCredentialsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.StorageAccountCredentialsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.StorageAccountCredentialsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SymmetricEncryptedSecret represents the secrets encrypted using Symmetric Encryption Key.
type SymmetricEncryptedSecret struct {
	autorest.Response `json:"-"`
	// Value - The value of the secret itself. If the secret is in plaintext or null then EncryptionAlgorithm will be none.
	Value *string `json:"value,omitempty"`
	// ValueCertificateThumbprint - The thumbprint of the cert that was used to encrypt "Value".
	ValueCertificateThumbprint *string `json:"valueCertificateThumbprint,omitempty"`
	// EncryptionAlgorithm - The algorithm used to encrypt the "Value". Possible values include: 'EncryptionAlgorithmNone', 'EncryptionAlgorithmAES256', 'EncryptionAlgorithmRSAESPKCS1V15'
	EncryptionAlgorithm EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// TargetEligibilityErrorMessage the error/warning message due to which the device is ineligible as a
// failover target device.
type TargetEligibilityErrorMessage struct {
	// Message - The localized error message stating the reason why the device is not eligible as a target device.
	Message *string `json:"message,omitempty"`
	// Resolution - The localized resolution message for the error.
	Resolution *string `json:"resolution,omitempty"`
	// ResultCode - The result code for the error, due to which the device does not qualify as a failover target device. Possible values include: 'TargetAndSourceCannotBeSameError', 'TargetIsNotOnlineError', 'TargetSourceIncompatibleVersionError', 'LocalToTieredVolumesConversionWarning', 'TargetInsufficientCapacityError', 'TargetInsufficientLocalVolumeMemoryError', 'TargetInsufficientTieredVolumeMemoryError'
	ResultCode TargetEligibilityResultCode `json:"resultCode,omitempty"`
}

// TargetEligibilityResult the eligibility result of device, as a failover target device.
type TargetEligibilityResult struct {
	// EligibilityStatus - The eligibility status of device, as a failover target device. Possible values include: 'TargetEligibilityStatusNotEligible', 'TargetEligibilityStatusEligible'
	EligibilityStatus TargetEligibilityStatus `json:"eligibilityStatus,omitempty"`
	// Messages - The list of error messages, if a device does not qualify as a failover target device.
	Messages *[]TargetEligibilityErrorMessage `json:"messages,omitempty"`
}

// Time the time.
type Time struct {
	// Hours - The hour.
	Hours *int32 `json:"hours,omitempty"`
	// Minutes - The minute.
	Minutes *int32 `json:"minutes,omitempty"`
	// Seconds - The second.
	Seconds *int32 `json:"seconds,omitempty"`
}

// TimeSettings the time settings of a device.
type TimeSettings struct {
	autorest.Response `json:"-"`
	// TimeSettingsProperties - The properties of the time settings of a device.
	*TimeSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TimeSettings.
func (ts TimeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ts.TimeSettingsProperties != nil {
		objectMap["properties"] = ts.TimeSettingsProperties
	}
	if ts.Kind != "" {
		objectMap["kind"] = ts.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TimeSettings struct.
func (ts *TimeSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var timeSettingsProperties TimeSettingsProperties
				err = json.Unmarshal(*v, &timeSettingsProperties)
				if err != nil {
					return err
				}
				ts.TimeSettingsProperties = &timeSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ts.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ts.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ts.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ts.Kind = kind
			}
		}
	}

	return nil
}

// TimeSettingsProperties the properties of time settings of a device.
type TimeSettingsProperties struct {
	// TimeZone - The timezone of device, like '(UTC -06:00) Central America'
	TimeZone *string `json:"timeZone,omitempty"`
	// PrimaryTimeServer - The primary Network Time Protocol (NTP) server name, like 'time.windows.com'.
	PrimaryTimeServer *string `json:"primaryTimeServer,omitempty"`
	// SecondaryTimeServer - The secondary Network Time Protocol (NTP) server name, like 'time.contoso.com'. It's optional.
	SecondaryTimeServer *[]string `json:"secondaryTimeServer,omitempty"`
}

// Updates the updates profile of a device.
type Updates struct {
	autorest.Response `json:"-"`
	// UpdatesProperties - The properties of the updates profile.
	*UpdatesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Updates.
func (u Updates) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UpdatesProperties != nil {
		objectMap["properties"] = u.UpdatesProperties
	}
	if u.Kind != "" {
		objectMap["kind"] = u.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Updates struct.
func (u *Updates) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updatesProperties UpdatesProperties
				err = json.Unmarshal(*v, &updatesProperties)
				if err != nil {
					return err
				}
				u.UpdatesProperties = &updatesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				u.Kind = kind
			}
		}
	}

	return nil
}

// UpdatesProperties the properties of the updates profile.
type UpdatesProperties struct {
	// RegularUpdatesAvailable - Set to 'true' if regular updates are available for the device.
	RegularUpdatesAvailable *bool `json:"regularUpdatesAvailable,omitempty"`
	// MaintenanceModeUpdatesAvailable - Set to 'true' if maintenance mode update available.
	MaintenanceModeUpdatesAvailable *bool `json:"maintenanceModeUpdatesAvailable,omitempty"`
	// IsUpdateInProgress - Indicates whether an update is in progress or not.
	IsUpdateInProgress *bool `json:"isUpdateInProgress,omitempty"`
	// LastUpdatedTime - The time when the last update was completed.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
}

// VMImage the virtual machine image.
type VMImage struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// Version - The version.
	Version *string `json:"version,omitempty"`
	// Offer - The offer.
	Offer *string `json:"offer,omitempty"`
	// Publisher - The publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The SKU.
	Sku *string `json:"sku,omitempty"`
}

// Volume the volume.
type Volume struct {
	autorest.Response `json:"-"`
	// VolumeProperties - The properties of the volume.
	*VolumeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Volume.
func (vVar Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.VolumeProperties != nil {
		objectMap["properties"] = vVar.VolumeProperties
	}
	if vVar.Kind != "" {
		objectMap["kind"] = vVar.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Volume struct.
func (vVar *Volume) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var volumeProperties VolumeProperties
				err = json.Unmarshal(*v, &volumeProperties)
				if err != nil {
					return err
				}
				vVar.VolumeProperties = &volumeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vVar.Kind = kind
			}
		}
	}

	return nil
}

// VolumeContainer the volume container.
type VolumeContainer struct {
	autorest.Response `json:"-"`
	// VolumeContainerProperties - The volume container properties.
	*VolumeContainerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the object. Currently only Series8000 is supported. Possible values include: 'Series8000'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeContainer.
func (vc VolumeContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vc.VolumeContainerProperties != nil {
		objectMap["properties"] = vc.VolumeContainerProperties
	}
	if vc.Kind != "" {
		objectMap["kind"] = vc.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VolumeContainer struct.
func (vc *VolumeContainer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var volumeContainerProperties VolumeContainerProperties
				err = json.Unmarshal(*v, &volumeContainerProperties)
				if err != nil {
					return err
				}
				vc.VolumeContainerProperties = &volumeContainerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vc.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vc.Kind = kind
			}
		}
	}

	return nil
}

// VolumeContainerFailoverMetadata the metadata of the volume container, that is being considered as part
// of a failover set.
type VolumeContainerFailoverMetadata struct {
	// VolumeContainerID - The path ID of the volume container.
	VolumeContainerID *string `json:"volumeContainerId,omitempty"`
	// Volumes - The list of metadata of volumes inside the volume container, which contains valid cloud snapshots.
	Volumes *[]VolumeFailoverMetadata `json:"volumes,omitempty"`
}

// VolumeContainerList the collection of volume container entities.
type VolumeContainerList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]VolumeContainer `json:"value,omitempty"`
}

// VolumeContainerProperties the properties of volume container.
type VolumeContainerProperties struct {
	// EncryptionKey - The key used to encrypt data in the volume container. It is required when property 'EncryptionStatus' is "Enabled".
	EncryptionKey *AsymmetricEncryptedSecret `json:"encryptionKey,omitempty"`
	// EncryptionStatus - READ-ONLY; The flag to denote whether encryption is enabled or not. Possible values include: 'EncryptionStatusEnabled', 'EncryptionStatusDisabled'
	EncryptionStatus EncryptionStatus `json:"encryptionStatus,omitempty"`
	// VolumeCount - READ-ONLY; The number of volumes in the volume Container.
	VolumeCount *int32 `json:"volumeCount,omitempty"`
	// StorageAccountCredentialID - The path ID of storage account associated with the volume container.
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`
	// OwnerShipStatus - READ-ONLY; The owner ship status of the volume container. Only when the status is "NotOwned", the delete operation on the volume container is permitted. Possible values include: 'Owned', 'NotOwned'
	OwnerShipStatus OwnerShipStatus `json:"ownerShipStatus,omitempty"`
	// BandWidthRateInMbps - The bandwidth-rate set on the volume container.
	BandWidthRateInMbps *int32 `json:"bandWidthRateInMbps,omitempty"`
	// BandwidthSettingID - The ID of the bandwidth setting associated with the volume container.
	BandwidthSettingID *string `json:"bandwidthSettingId,omitempty"`
	// TotalCloudStorageUsageInBytes - READ-ONLY; The total cloud storage for the volume container.
	TotalCloudStorageUsageInBytes *int64 `json:"totalCloudStorageUsageInBytes,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeContainerProperties.
func (vcp VolumeContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcp.EncryptionKey != nil {
		objectMap["encryptionKey"] = vcp.EncryptionKey
	}
	if vcp.StorageAccountCredentialID != nil {
		objectMap["storageAccountCredentialId"] = vcp.StorageAccountCredentialID
	}
	if vcp.BandWidthRateInMbps != nil {
		objectMap["bandWidthRateInMbps"] = vcp.BandWidthRateInMbps
	}
	if vcp.BandwidthSettingID != nil {
		objectMap["bandwidthSettingId"] = vcp.BandwidthSettingID
	}
	return json.Marshal(objectMap)
}

// VolumeContainersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VolumeContainersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumeContainersClient) (VolumeContainer, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VolumeContainersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VolumeContainersCreateOrUpdateFuture.Result.
func (future *VolumeContainersCreateOrUpdateFuture) result(client VolumeContainersClient) (vc VolumeContainer, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.VolumeContainersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.VolumeContainersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vc.Response.Response, err = future.GetResult(sender); err == nil && vc.Response.Response.StatusCode != http.StatusNoContent {
		vc, err = client.CreateOrUpdateResponder(vc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.VolumeContainersCreateOrUpdateFuture", "Result", vc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VolumeContainersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumeContainersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumeContainersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VolumeContainersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VolumeContainersDeleteFuture.Result.
func (future *VolumeContainersDeleteFuture) result(client VolumeContainersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.VolumeContainersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.VolumeContainersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VolumeFailoverMetadata the metadata of a volume that has valid cloud snapshot.
type VolumeFailoverMetadata struct {
	// VolumeID - The path ID of the volume.
	VolumeID *string `json:"volumeId,omitempty"`
	// VolumeType - The type of the volume. Possible values include: 'Tiered', 'Archival', 'LocallyPinned'
	VolumeType VolumeType `json:"volumeType,omitempty"`
	// SizeInBytes - The size of the volume in bytes at the time the snapshot was taken.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// BackupCreatedDate - The date at which the snapshot was taken.
	BackupCreatedDate *date.Time `json:"backupCreatedDate,omitempty"`
	// BackupElementID - The path ID of the backup-element for this volume, inside the backup set.
	BackupElementID *string `json:"backupElementId,omitempty"`
	// BackupID - The path ID of the backup set.
	BackupID *string `json:"backupId,omitempty"`
	// BackupPolicyID - The path ID of the backup policy using which the snapshot was taken.
	BackupPolicyID *string `json:"backupPolicyId,omitempty"`
}

// VolumeList the collection of volumes.
type VolumeList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Volume `json:"value,omitempty"`
}

// VolumeProperties the properties of volume.
type VolumeProperties struct {
	// SizeInBytes - The size of the volume in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// VolumeType - The type of the volume. Possible values include: 'Tiered', 'Archival', 'LocallyPinned'
	VolumeType VolumeType `json:"volumeType,omitempty"`
	// VolumeContainerID - READ-ONLY; The ID of the volume container, in which this volume is created.
	VolumeContainerID *string `json:"volumeContainerId,omitempty"`
	// AccessControlRecordIds - The IDs of the access control records, associated with the volume.
	AccessControlRecordIds *[]string `json:"accessControlRecordIds,omitempty"`
	// VolumeStatus - The volume status. Possible values include: 'VolumeStatusOnline', 'VolumeStatusOffline'
	VolumeStatus VolumeStatus `json:"volumeStatus,omitempty"`
	// OperationStatus - READ-ONLY; The operation status on the volume. Possible values include: 'OperationStatusNone', 'OperationStatusUpdating', 'OperationStatusDeleting', 'OperationStatusRestoring'
	OperationStatus OperationStatus `json:"operationStatus,omitempty"`
	// BackupStatus - READ-ONLY; The backup status of the volume. Possible values include: 'BackupStatusEnabled', 'BackupStatusDisabled'
	BackupStatus BackupStatus `json:"backupStatus,omitempty"`
	// MonitoringStatus - The monitoring status of the volume. Possible values include: 'MonitoringStatusEnabled', 'MonitoringStatusDisabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
	// BackupPolicyIds - READ-ONLY; The IDs of the backup policies, in which this volume is part of.
	BackupPolicyIds *[]string `json:"backupPolicyIds,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeProperties.
func (vp VolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.SizeInBytes != nil {
		objectMap["sizeInBytes"] = vp.SizeInBytes
	}
	if vp.VolumeType != "" {
		objectMap["volumeType"] = vp.VolumeType
	}
	if vp.AccessControlRecordIds != nil {
		objectMap["accessControlRecordIds"] = vp.AccessControlRecordIds
	}
	if vp.VolumeStatus != "" {
		objectMap["volumeStatus"] = vp.VolumeStatus
	}
	if vp.MonitoringStatus != "" {
		objectMap["monitoringStatus"] = vp.MonitoringStatus
	}
	return json.Marshal(objectMap)
}

// VolumesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (Volume, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VolumesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VolumesCreateOrUpdateFuture.Result.
func (future *VolumesCreateOrUpdateFuture) result(client VolumesClient) (vVar Volume, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.VolumesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vVar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.VolumesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vVar.Response.Response, err = future.GetResult(sender); err == nil && vVar.Response.Response.StatusCode != http.StatusNoContent {
		vVar, err = client.CreateOrUpdateResponder(vVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.VolumesCreateOrUpdateFuture", "Result", vVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VolumesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VolumesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VolumesDeleteFuture.Result.
func (future *VolumesDeleteFuture) result(client VolumesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.VolumesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storsimple.VolumesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WebproxySettings the web proxy settings on the device.
type WebproxySettings struct {
	// ConnectionURI - The connection URI.
	ConnectionURI *string `json:"connectionUri,omitempty"`
	// Authentication - The authentication type. Possible values include: 'Invalid', 'None', 'Basic', 'NTLM'
	Authentication AuthenticationType `json:"authentication,omitempty"`
	// Username - The webproxy username.
	Username *string `json:"username,omitempty"`
}
