package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// GovernanceRuleClient is the API spec for Microsoft.Security (Azure Security Center) resource provider
type GovernanceRuleClient struct {
	BaseClient
}

// NewGovernanceRuleClient creates an instance of the GovernanceRuleClient client.
func NewGovernanceRuleClient(subscriptionID string) GovernanceRuleClient {
	return NewGovernanceRuleClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewGovernanceRuleClientWithBaseURI creates an instance of the GovernanceRuleClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewGovernanceRuleClientWithBaseURI(baseURI string, subscriptionID string) GovernanceRuleClient {
	return GovernanceRuleClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List get a list of all relevant governanceRules over a subscription level scope
func (client GovernanceRuleClient) List(ctx context.Context) (result GovernanceRuleListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceRuleClient.List")
		defer func() {
			sc := -1
			if result.grl.Response.Response != nil {
				sc = result.grl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.GovernanceRuleClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceRuleClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.grl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.GovernanceRuleClient", "List", resp, "Failure sending request")
		return
	}

	result.grl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceRuleClient", "List", resp, "Failure responding to request")
		return
	}
	if result.grl.hasNextLink() && result.grl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client GovernanceRuleClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/governanceRules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client GovernanceRuleClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client GovernanceRuleClient) ListResponder(resp *http.Response) (result GovernanceRuleList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client GovernanceRuleClient) listNextResults(ctx context.Context, lastResults GovernanceRuleList) (result GovernanceRuleList, err error) {
	req, err := lastResults.governanceRuleListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.GovernanceRuleClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.GovernanceRuleClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceRuleClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client GovernanceRuleClient) ListComplete(ctx context.Context) (result GovernanceRuleListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceRuleClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}
