package servicemap

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Accuracy enumerates the values for accuracy.
type Accuracy string

const (
	// Actual ...
	Actual Accuracy = "actual"
	// Estimated ...
	Estimated Accuracy = "estimated"
)

// PossibleAccuracyValues returns an array of possible values for the Accuracy const type.
func PossibleAccuracyValues() []Accuracy {
	return []Accuracy{Actual, Estimated}
}

// AzureCloudServiceRoleType enumerates the values for azure cloud service role type.
type AzureCloudServiceRoleType string

const (
	// Unknown ...
	Unknown AzureCloudServiceRoleType = "unknown"
	// Web ...
	Web AzureCloudServiceRoleType = "web"
	// Worker ...
	Worker AzureCloudServiceRoleType = "worker"
)

// PossibleAzureCloudServiceRoleTypeValues returns an array of possible values for the AzureCloudServiceRoleType const type.
func PossibleAzureCloudServiceRoleTypeValues() []AzureCloudServiceRoleType {
	return []AzureCloudServiceRoleType{Unknown, Web, Worker}
}

// Bitness enumerates the values for bitness.
type Bitness string

const (
	// SixFourbit ...
	SixFourbit Bitness = "64bit"
	// ThreeTwobit ...
	ThreeTwobit Bitness = "32bit"
)

// PossibleBitnessValues returns an array of possible values for the Bitness const type.
func PossibleBitnessValues() []Bitness {
	return []Bitness{SixFourbit, ThreeTwobit}
}

// ConnectionFailureState enumerates the values for connection failure state.
type ConnectionFailureState string

const (
	// Failed ...
	Failed ConnectionFailureState = "failed"
	// Mixed ...
	Mixed ConnectionFailureState = "mixed"
	// Ok ...
	Ok ConnectionFailureState = "ok"
)

// PossibleConnectionFailureStateValues returns an array of possible values for the ConnectionFailureState const type.
func PossibleConnectionFailureStateValues() []ConnectionFailureState {
	return []ConnectionFailureState{Failed, Mixed, Ok}
}

// HypervisorType enumerates the values for hypervisor type.
type HypervisorType string

const (
	// HypervisorTypeHyperv ...
	HypervisorTypeHyperv HypervisorType = "hyperv"
	// HypervisorTypeUnknown ...
	HypervisorTypeUnknown HypervisorType = "unknown"
)

// PossibleHypervisorTypeValues returns an array of possible values for the HypervisorType const type.
func PossibleHypervisorTypeValues() []HypervisorType {
	return []HypervisorType{HypervisorTypeHyperv, HypervisorTypeUnknown}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindRefclientgroup ...
	KindRefclientgroup Kind = "ref:clientgroup"
	// KindRefmachine ...
	KindRefmachine Kind = "ref:machine"
	// KindRefmachinewithhints ...
	KindRefmachinewithhints Kind = "ref:machinewithhints"
	// KindRefport ...
	KindRefport Kind = "ref:port"
	// KindRefprocess ...
	KindRefprocess Kind = "ref:process"
	// KindResourceReference ...
	KindResourceReference Kind = "ResourceReference"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindRefclientgroup, KindRefmachine, KindRefmachinewithhints, KindRefport, KindRefprocess, KindResourceReference}
}

// KindBasicCoreResource enumerates the values for kind basic core resource.
type KindBasicCoreResource string

const (
	// KindClientGroup ...
	KindClientGroup KindBasicCoreResource = "clientGroup"
	// KindCoreResource ...
	KindCoreResource KindBasicCoreResource = "CoreResource"
	// KindMachine ...
	KindMachine KindBasicCoreResource = "machine"
	// KindMachineGroup ...
	KindMachineGroup KindBasicCoreResource = "machineGroup"
	// KindPort ...
	KindPort KindBasicCoreResource = "port"
	// KindProcess ...
	KindProcess KindBasicCoreResource = "process"
)

// PossibleKindBasicCoreResourceValues returns an array of possible values for the KindBasicCoreResource const type.
func PossibleKindBasicCoreResourceValues() []KindBasicCoreResource {
	return []KindBasicCoreResource{KindClientGroup, KindCoreResource, KindMachine, KindMachineGroup, KindPort, KindProcess}
}

// KindBasicHostingConfiguration enumerates the values for kind basic hosting configuration.
type KindBasicHostingConfiguration string

const (
	// KindHostingConfiguration ...
	KindHostingConfiguration KindBasicHostingConfiguration = "HostingConfiguration"
	// KindProviderazure ...
	KindProviderazure KindBasicHostingConfiguration = "provider:azure"
)

// PossibleKindBasicHostingConfigurationValues returns an array of possible values for the KindBasicHostingConfiguration const type.
func PossibleKindBasicHostingConfigurationValues() []KindBasicHostingConfiguration {
	return []KindBasicHostingConfiguration{KindHostingConfiguration, KindProviderazure}
}

// KindBasicMapRequest enumerates the values for kind basic map request.
type KindBasicMapRequest string

const (
	// KindMapmachineGroupDependency ...
	KindMapmachineGroupDependency KindBasicMapRequest = "map:machine-group-dependency"
	// KindMapmachineListDependency ...
	KindMapmachineListDependency KindBasicMapRequest = "map:machine-list-dependency"
	// KindMapRequest ...
	KindMapRequest KindBasicMapRequest = "MapRequest"
	// KindMapsingleMachineDependency ...
	KindMapsingleMachineDependency KindBasicMapRequest = "map:single-machine-dependency"
	// KindMultipleMachinesMapRequest ...
	KindMultipleMachinesMapRequest KindBasicMapRequest = "MultipleMachinesMapRequest"
)

// PossibleKindBasicMapRequestValues returns an array of possible values for the KindBasicMapRequest const type.
func PossibleKindBasicMapRequestValues() []KindBasicMapRequest {
	return []KindBasicMapRequest{KindMapmachineGroupDependency, KindMapmachineListDependency, KindMapRequest, KindMapsingleMachineDependency, KindMultipleMachinesMapRequest}
}

// KindBasicProcessHostingConfiguration enumerates the values for kind basic process hosting configuration.
type KindBasicProcessHostingConfiguration string

const (
	// KindBasicProcessHostingConfigurationKindProcessHostingConfiguration ...
	KindBasicProcessHostingConfigurationKindProcessHostingConfiguration KindBasicProcessHostingConfiguration = "ProcessHostingConfiguration"
	// KindBasicProcessHostingConfigurationKindProviderazure ...
	KindBasicProcessHostingConfigurationKindProviderazure KindBasicProcessHostingConfiguration = "provider:azure"
)

// PossibleKindBasicProcessHostingConfigurationValues returns an array of possible values for the KindBasicProcessHostingConfiguration const type.
func PossibleKindBasicProcessHostingConfigurationValues() []KindBasicProcessHostingConfiguration {
	return []KindBasicProcessHostingConfiguration{KindBasicProcessHostingConfigurationKindProcessHostingConfiguration, KindBasicProcessHostingConfigurationKindProviderazure}
}

// KindBasicRelationship enumerates the values for kind basic relationship.
type KindBasicRelationship string

const (
	// KindRelacceptor ...
	KindRelacceptor KindBasicRelationship = "rel:acceptor"
	// KindRelationship ...
	KindRelationship KindBasicRelationship = "Relationship"
	// KindRelconnection ...
	KindRelconnection KindBasicRelationship = "rel:connection"
)

// PossibleKindBasicRelationshipValues returns an array of possible values for the KindBasicRelationship const type.
func PossibleKindBasicRelationshipValues() []KindBasicRelationship {
	return []KindBasicRelationship{KindRelacceptor, KindRelationship, KindRelconnection}
}

// MachineGroupType enumerates the values for machine group type.
type MachineGroupType string

const (
	// MachineGroupTypeAzureCs ...
	MachineGroupTypeAzureCs MachineGroupType = "azure-cs"
	// MachineGroupTypeAzureSf ...
	MachineGroupTypeAzureSf MachineGroupType = "azure-sf"
	// MachineGroupTypeAzureVmss ...
	MachineGroupTypeAzureVmss MachineGroupType = "azure-vmss"
	// MachineGroupTypeUnknown ...
	MachineGroupTypeUnknown MachineGroupType = "unknown"
	// MachineGroupTypeUserStatic ...
	MachineGroupTypeUserStatic MachineGroupType = "user-static"
)

// PossibleMachineGroupTypeValues returns an array of possible values for the MachineGroupType const type.
func PossibleMachineGroupTypeValues() []MachineGroupType {
	return []MachineGroupType{MachineGroupTypeAzureCs, MachineGroupTypeAzureSf, MachineGroupTypeAzureVmss, MachineGroupTypeUnknown, MachineGroupTypeUserStatic}
}

// MachineRebootStatus enumerates the values for machine reboot status.
type MachineRebootStatus string

const (
	// MachineRebootStatusNotRebooted ...
	MachineRebootStatusNotRebooted MachineRebootStatus = "notRebooted"
	// MachineRebootStatusRebooted ...
	MachineRebootStatusRebooted MachineRebootStatus = "rebooted"
	// MachineRebootStatusUnknown ...
	MachineRebootStatusUnknown MachineRebootStatus = "unknown"
)

// PossibleMachineRebootStatusValues returns an array of possible values for the MachineRebootStatus const type.
func PossibleMachineRebootStatusValues() []MachineRebootStatus {
	return []MachineRebootStatus{MachineRebootStatusNotRebooted, MachineRebootStatusRebooted, MachineRebootStatusUnknown}
}

// MonitoringState enumerates the values for monitoring state.
type MonitoringState string

const (
	// Discovered ...
	Discovered MonitoringState = "discovered"
	// Monitored ...
	Monitored MonitoringState = "monitored"
)

// PossibleMonitoringStateValues returns an array of possible values for the MonitoringState const type.
func PossibleMonitoringStateValues() []MonitoringState {
	return []MonitoringState{Discovered, Monitored}
}

// OperatingSystemFamily enumerates the values for operating system family.
type OperatingSystemFamily string

const (
	// OperatingSystemFamilyAix ...
	OperatingSystemFamilyAix OperatingSystemFamily = "aix"
	// OperatingSystemFamilyLinux ...
	OperatingSystemFamilyLinux OperatingSystemFamily = "linux"
	// OperatingSystemFamilySolaris ...
	OperatingSystemFamilySolaris OperatingSystemFamily = "solaris"
	// OperatingSystemFamilyUnknown ...
	OperatingSystemFamilyUnknown OperatingSystemFamily = "unknown"
	// OperatingSystemFamilyWindows ...
	OperatingSystemFamilyWindows OperatingSystemFamily = "windows"
)

// PossibleOperatingSystemFamilyValues returns an array of possible values for the OperatingSystemFamily const type.
func PossibleOperatingSystemFamilyValues() []OperatingSystemFamily {
	return []OperatingSystemFamily{OperatingSystemFamilyAix, OperatingSystemFamilyLinux, OperatingSystemFamilySolaris, OperatingSystemFamilyUnknown, OperatingSystemFamilyWindows}
}

// ProcessRole enumerates the values for process role.
type ProcessRole string

const (
	// AppServer ...
	AppServer ProcessRole = "appServer"
	// DatabaseServer ...
	DatabaseServer ProcessRole = "databaseServer"
	// LdapServer ...
	LdapServer ProcessRole = "ldapServer"
	// SmbServer ...
	SmbServer ProcessRole = "smbServer"
	// WebServer ...
	WebServer ProcessRole = "webServer"
)

// PossibleProcessRoleValues returns an array of possible values for the ProcessRole const type.
func PossibleProcessRoleValues() []ProcessRole {
	return []ProcessRole{AppServer, DatabaseServer, LdapServer, SmbServer, WebServer}
}

// Provider enumerates the values for provider.
type Provider string

const (
	// Azure ...
	Azure Provider = "azure"
)

// PossibleProviderValues returns an array of possible values for the Provider const type.
func PossibleProviderValues() []Provider {
	return []Provider{Azure}
}

// Provider1 enumerates the values for provider 1.
type Provider1 string

const (
	// Provider1Azure ...
	Provider1Azure Provider1 = "azure"
)

// PossibleProvider1Values returns an array of possible values for the Provider1 const type.
func PossibleProvider1Values() []Provider1 {
	return []Provider1{Provider1Azure}
}

// VirtualizationState enumerates the values for virtualization state.
type VirtualizationState string

const (
	// VirtualizationStateHypervisor ...
	VirtualizationStateHypervisor VirtualizationState = "hypervisor"
	// VirtualizationStatePhysical ...
	VirtualizationStatePhysical VirtualizationState = "physical"
	// VirtualizationStateUnknown ...
	VirtualizationStateUnknown VirtualizationState = "unknown"
	// VirtualizationStateVirtual ...
	VirtualizationStateVirtual VirtualizationState = "virtual"
)

// PossibleVirtualizationStateValues returns an array of possible values for the VirtualizationState const type.
func PossibleVirtualizationStateValues() []VirtualizationState {
	return []VirtualizationState{VirtualizationStateHypervisor, VirtualizationStatePhysical, VirtualizationStateUnknown, VirtualizationStateVirtual}
}

// VirtualMachineType enumerates the values for virtual machine type.
type VirtualMachineType string

const (
	// VirtualMachineTypeHyperv ...
	VirtualMachineTypeHyperv VirtualMachineType = "hyperv"
	// VirtualMachineTypeLdom ...
	VirtualMachineTypeLdom VirtualMachineType = "ldom"
	// VirtualMachineTypeLpar ...
	VirtualMachineTypeLpar VirtualMachineType = "lpar"
	// VirtualMachineTypeUnknown ...
	VirtualMachineTypeUnknown VirtualMachineType = "unknown"
	// VirtualMachineTypeVirtualPc ...
	VirtualMachineTypeVirtualPc VirtualMachineType = "virtualPc"
	// VirtualMachineTypeVmware ...
	VirtualMachineTypeVmware VirtualMachineType = "vmware"
	// VirtualMachineTypeXen ...
	VirtualMachineTypeXen VirtualMachineType = "xen"
)

// PossibleVirtualMachineTypeValues returns an array of possible values for the VirtualMachineType const type.
func PossibleVirtualMachineTypeValues() []VirtualMachineType {
	return []VirtualMachineType{VirtualMachineTypeHyperv, VirtualMachineTypeLdom, VirtualMachineTypeLpar, VirtualMachineTypeUnknown, VirtualMachineTypeVirtualPc, VirtualMachineTypeVmware, VirtualMachineTypeXen}
}
