package insights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AggregationType enumerates the values for aggregation type.
type AggregationType string

const (
	// Average ...
	Average AggregationType = "Average"
	// Count ...
	Count AggregationType = "Count"
	// Maximum ...
	Maximum AggregationType = "Maximum"
	// Minimum ...
	Minimum AggregationType = "Minimum"
	// None ...
	None AggregationType = "None"
	// Total ...
	Total AggregationType = "Total"
)

// PossibleAggregationTypeValues returns an array of possible values for the AggregationType const type.
func PossibleAggregationTypeValues() []AggregationType {
	return []AggregationType{Average, Count, Maximum, Minimum, None, Total}
}

// AggregationTypeEnum enumerates the values for aggregation type enum.
type AggregationTypeEnum string

const (
	// AggregationTypeEnumAverage ...
	AggregationTypeEnumAverage AggregationTypeEnum = "Average"
	// AggregationTypeEnumCount ...
	AggregationTypeEnumCount AggregationTypeEnum = "Count"
	// AggregationTypeEnumMaximum ...
	AggregationTypeEnumMaximum AggregationTypeEnum = "Maximum"
	// AggregationTypeEnumMinimum ...
	AggregationTypeEnumMinimum AggregationTypeEnum = "Minimum"
	// AggregationTypeEnumTotal ...
	AggregationTypeEnumTotal AggregationTypeEnum = "Total"
)

// PossibleAggregationTypeEnumValues returns an array of possible values for the AggregationTypeEnum const type.
func PossibleAggregationTypeEnumValues() []AggregationTypeEnum {
	return []AggregationTypeEnum{AggregationTypeEnumAverage, AggregationTypeEnumCount, AggregationTypeEnumMaximum, AggregationTypeEnumMinimum, AggregationTypeEnumTotal}
}

// BaselineSensitivity enumerates the values for baseline sensitivity.
type BaselineSensitivity string

const (
	// High ...
	High BaselineSensitivity = "High"
	// Low ...
	Low BaselineSensitivity = "Low"
	// Medium ...
	Medium BaselineSensitivity = "Medium"
)

// PossibleBaselineSensitivityValues returns an array of possible values for the BaselineSensitivity const type.
func PossibleBaselineSensitivityValues() []BaselineSensitivity {
	return []BaselineSensitivity{High, Low, Medium}
}

// CategoryType enumerates the values for category type.
type CategoryType string

const (
	// Logs ...
	Logs CategoryType = "Logs"
	// Metrics ...
	Metrics CategoryType = "Metrics"
)

// PossibleCategoryTypeValues returns an array of possible values for the CategoryType const type.
func PossibleCategoryTypeValues() []CategoryType {
	return []CategoryType{Logs, Metrics}
}

// ComparisonOperationType enumerates the values for comparison operation type.
type ComparisonOperationType string

const (
	// Equals ...
	Equals ComparisonOperationType = "Equals"
	// GreaterThan ...
	GreaterThan ComparisonOperationType = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual ComparisonOperationType = "GreaterThanOrEqual"
	// LessThan ...
	LessThan ComparisonOperationType = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual ComparisonOperationType = "LessThanOrEqual"
	// NotEquals ...
	NotEquals ComparisonOperationType = "NotEquals"
)

// PossibleComparisonOperationTypeValues returns an array of possible values for the ComparisonOperationType const type.
func PossibleComparisonOperationTypeValues() []ComparisonOperationType {
	return []ComparisonOperationType{Equals, GreaterThan, GreaterThanOrEqual, LessThan, LessThanOrEqual, NotEquals}
}

// ConditionOperator enumerates the values for condition operator.
type ConditionOperator string

const (
	// ConditionOperatorGreaterThan ...
	ConditionOperatorGreaterThan ConditionOperator = "GreaterThan"
	// ConditionOperatorGreaterThanOrEqual ...
	ConditionOperatorGreaterThanOrEqual ConditionOperator = "GreaterThanOrEqual"
	// ConditionOperatorLessThan ...
	ConditionOperatorLessThan ConditionOperator = "LessThan"
	// ConditionOperatorLessThanOrEqual ...
	ConditionOperatorLessThanOrEqual ConditionOperator = "LessThanOrEqual"
)

// PossibleConditionOperatorValues returns an array of possible values for the ConditionOperator const type.
func PossibleConditionOperatorValues() []ConditionOperator {
	return []ConditionOperator{ConditionOperatorGreaterThan, ConditionOperatorGreaterThanOrEqual, ConditionOperatorLessThan, ConditionOperatorLessThanOrEqual}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// CriterionType enumerates the values for criterion type.
type CriterionType string

const (
	// CriterionTypeDynamicThresholdCriterion ...
	CriterionTypeDynamicThresholdCriterion CriterionType = "DynamicThresholdCriterion"
	// CriterionTypeMultiMetricCriteria ...
	CriterionTypeMultiMetricCriteria CriterionType = "MultiMetricCriteria"
	// CriterionTypeStaticThresholdCriterion ...
	CriterionTypeStaticThresholdCriterion CriterionType = "StaticThresholdCriterion"
)

// PossibleCriterionTypeValues returns an array of possible values for the CriterionType const type.
func PossibleCriterionTypeValues() []CriterionType {
	return []CriterionType{CriterionTypeDynamicThresholdCriterion, CriterionTypeMultiMetricCriteria, CriterionTypeStaticThresholdCriterion}
}

// DataStatus enumerates the values for data status.
type DataStatus string

const (
	// NotPresent ...
	NotPresent DataStatus = "notPresent"
	// Present ...
	Present DataStatus = "present"
)

// PossibleDataStatusValues returns an array of possible values for the DataStatus const type.
func PossibleDataStatusValues() []DataStatus {
	return []DataStatus{NotPresent, Present}
}

// DimensionOperator enumerates the values for dimension operator.
type DimensionOperator string

const (
	// Exclude ...
	Exclude DimensionOperator = "Exclude"
	// Include ...
	Include DimensionOperator = "Include"
)

// PossibleDimensionOperatorValues returns an array of possible values for the DimensionOperator const type.
func PossibleDimensionOperatorValues() []DimensionOperator {
	return []DimensionOperator{Exclude, Include}
}

// DynamicThresholdOperator enumerates the values for dynamic threshold operator.
type DynamicThresholdOperator string

const (
	// DynamicThresholdOperatorGreaterOrLessThan ...
	DynamicThresholdOperatorGreaterOrLessThan DynamicThresholdOperator = "GreaterOrLessThan"
	// DynamicThresholdOperatorGreaterThan ...
	DynamicThresholdOperatorGreaterThan DynamicThresholdOperator = "GreaterThan"
	// DynamicThresholdOperatorLessThan ...
	DynamicThresholdOperatorLessThan DynamicThresholdOperator = "LessThan"
)

// PossibleDynamicThresholdOperatorValues returns an array of possible values for the DynamicThresholdOperator const type.
func PossibleDynamicThresholdOperatorValues() []DynamicThresholdOperator {
	return []DynamicThresholdOperator{DynamicThresholdOperatorGreaterOrLessThan, DynamicThresholdOperatorGreaterThan, DynamicThresholdOperatorLessThan}
}

// DynamicThresholdSensitivity enumerates the values for dynamic threshold sensitivity.
type DynamicThresholdSensitivity string

const (
	// DynamicThresholdSensitivityHigh ...
	DynamicThresholdSensitivityHigh DynamicThresholdSensitivity = "High"
	// DynamicThresholdSensitivityLow ...
	DynamicThresholdSensitivityLow DynamicThresholdSensitivity = "Low"
	// DynamicThresholdSensitivityMedium ...
	DynamicThresholdSensitivityMedium DynamicThresholdSensitivity = "Medium"
)

// PossibleDynamicThresholdSensitivityValues returns an array of possible values for the DynamicThresholdSensitivity const type.
func PossibleDynamicThresholdSensitivityValues() []DynamicThresholdSensitivity {
	return []DynamicThresholdSensitivity{DynamicThresholdSensitivityHigh, DynamicThresholdSensitivityLow, DynamicThresholdSensitivityMedium}
}

// EventLevel enumerates the values for event level.
type EventLevel string

const (
	// EventLevelCritical ...
	EventLevelCritical EventLevel = "Critical"
	// EventLevelError ...
	EventLevelError EventLevel = "Error"
	// EventLevelInformational ...
	EventLevelInformational EventLevel = "Informational"
	// EventLevelVerbose ...
	EventLevelVerbose EventLevel = "Verbose"
	// EventLevelWarning ...
	EventLevelWarning EventLevel = "Warning"
)

// PossibleEventLevelValues returns an array of possible values for the EventLevel const type.
func PossibleEventLevelValues() []EventLevel {
	return []EventLevel{EventLevelCritical, EventLevelError, EventLevelInformational, EventLevelVerbose, EventLevelWarning}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// LogAlert ...
	LogAlert Kind = "LogAlert"
	// LogToMetric ...
	LogToMetric Kind = "LogToMetric"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{LogAlert, LogToMetric}
}

// KnownColumnDefinitionType enumerates the values for known column definition type.
type KnownColumnDefinitionType string

const (
	// Boolean ...
	Boolean KnownColumnDefinitionType = "boolean"
	// Datetime ...
	Datetime KnownColumnDefinitionType = "datetime"
	// Dynamic ...
	Dynamic KnownColumnDefinitionType = "dynamic"
	// Int ...
	Int KnownColumnDefinitionType = "int"
	// Long ...
	Long KnownColumnDefinitionType = "long"
	// Real ...
	Real KnownColumnDefinitionType = "real"
	// String ...
	String KnownColumnDefinitionType = "string"
)

// PossibleKnownColumnDefinitionTypeValues returns an array of possible values for the KnownColumnDefinitionType const type.
func PossibleKnownColumnDefinitionTypeValues() []KnownColumnDefinitionType {
	return []KnownColumnDefinitionType{Boolean, Datetime, Dynamic, Int, Long, Real, String}
}

// KnownDataCollectionEndpointProvisioningState enumerates the values for known data collection endpoint
// provisioning state.
type KnownDataCollectionEndpointProvisioningState string

const (
	// Creating ...
	Creating KnownDataCollectionEndpointProvisioningState = "Creating"
	// Deleting ...
	Deleting KnownDataCollectionEndpointProvisioningState = "Deleting"
	// Failed ...
	Failed KnownDataCollectionEndpointProvisioningState = "Failed"
	// Succeeded ...
	Succeeded KnownDataCollectionEndpointProvisioningState = "Succeeded"
	// Updating ...
	Updating KnownDataCollectionEndpointProvisioningState = "Updating"
)

// PossibleKnownDataCollectionEndpointProvisioningStateValues returns an array of possible values for the KnownDataCollectionEndpointProvisioningState const type.
func PossibleKnownDataCollectionEndpointProvisioningStateValues() []KnownDataCollectionEndpointProvisioningState {
	return []KnownDataCollectionEndpointProvisioningState{Creating, Deleting, Failed, Succeeded, Updating}
}

// KnownDataCollectionEndpointResourceKind enumerates the values for known data collection endpoint resource
// kind.
type KnownDataCollectionEndpointResourceKind string

const (
	// Linux ...
	Linux KnownDataCollectionEndpointResourceKind = "Linux"
	// Windows ...
	Windows KnownDataCollectionEndpointResourceKind = "Windows"
)

// PossibleKnownDataCollectionEndpointResourceKindValues returns an array of possible values for the KnownDataCollectionEndpointResourceKind const type.
func PossibleKnownDataCollectionEndpointResourceKindValues() []KnownDataCollectionEndpointResourceKind {
	return []KnownDataCollectionEndpointResourceKind{Linux, Windows}
}

// KnownDataCollectionRuleAssociationProvisioningState enumerates the values for known data collection rule
// association provisioning state.
type KnownDataCollectionRuleAssociationProvisioningState string

const (
	// KnownDataCollectionRuleAssociationProvisioningStateCreating ...
	KnownDataCollectionRuleAssociationProvisioningStateCreating KnownDataCollectionRuleAssociationProvisioningState = "Creating"
	// KnownDataCollectionRuleAssociationProvisioningStateDeleting ...
	KnownDataCollectionRuleAssociationProvisioningStateDeleting KnownDataCollectionRuleAssociationProvisioningState = "Deleting"
	// KnownDataCollectionRuleAssociationProvisioningStateFailed ...
	KnownDataCollectionRuleAssociationProvisioningStateFailed KnownDataCollectionRuleAssociationProvisioningState = "Failed"
	// KnownDataCollectionRuleAssociationProvisioningStateSucceeded ...
	KnownDataCollectionRuleAssociationProvisioningStateSucceeded KnownDataCollectionRuleAssociationProvisioningState = "Succeeded"
	// KnownDataCollectionRuleAssociationProvisioningStateUpdating ...
	KnownDataCollectionRuleAssociationProvisioningStateUpdating KnownDataCollectionRuleAssociationProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleAssociationProvisioningStateValues returns an array of possible values for the KnownDataCollectionRuleAssociationProvisioningState const type.
func PossibleKnownDataCollectionRuleAssociationProvisioningStateValues() []KnownDataCollectionRuleAssociationProvisioningState {
	return []KnownDataCollectionRuleAssociationProvisioningState{KnownDataCollectionRuleAssociationProvisioningStateCreating, KnownDataCollectionRuleAssociationProvisioningStateDeleting, KnownDataCollectionRuleAssociationProvisioningStateFailed, KnownDataCollectionRuleAssociationProvisioningStateSucceeded, KnownDataCollectionRuleAssociationProvisioningStateUpdating}
}

// KnownDataCollectionRuleProvisioningState enumerates the values for known data collection rule provisioning
// state.
type KnownDataCollectionRuleProvisioningState string

const (
	// KnownDataCollectionRuleProvisioningStateCreating ...
	KnownDataCollectionRuleProvisioningStateCreating KnownDataCollectionRuleProvisioningState = "Creating"
	// KnownDataCollectionRuleProvisioningStateDeleting ...
	KnownDataCollectionRuleProvisioningStateDeleting KnownDataCollectionRuleProvisioningState = "Deleting"
	// KnownDataCollectionRuleProvisioningStateFailed ...
	KnownDataCollectionRuleProvisioningStateFailed KnownDataCollectionRuleProvisioningState = "Failed"
	// KnownDataCollectionRuleProvisioningStateSucceeded ...
	KnownDataCollectionRuleProvisioningStateSucceeded KnownDataCollectionRuleProvisioningState = "Succeeded"
	// KnownDataCollectionRuleProvisioningStateUpdating ...
	KnownDataCollectionRuleProvisioningStateUpdating KnownDataCollectionRuleProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleProvisioningStateValues returns an array of possible values for the KnownDataCollectionRuleProvisioningState const type.
func PossibleKnownDataCollectionRuleProvisioningStateValues() []KnownDataCollectionRuleProvisioningState {
	return []KnownDataCollectionRuleProvisioningState{KnownDataCollectionRuleProvisioningStateCreating, KnownDataCollectionRuleProvisioningStateDeleting, KnownDataCollectionRuleProvisioningStateFailed, KnownDataCollectionRuleProvisioningStateSucceeded, KnownDataCollectionRuleProvisioningStateUpdating}
}

// KnownDataCollectionRuleResourceKind enumerates the values for known data collection rule resource kind.
type KnownDataCollectionRuleResourceKind string

const (
	// KnownDataCollectionRuleResourceKindLinux ...
	KnownDataCollectionRuleResourceKindLinux KnownDataCollectionRuleResourceKind = "Linux"
	// KnownDataCollectionRuleResourceKindWindows ...
	KnownDataCollectionRuleResourceKindWindows KnownDataCollectionRuleResourceKind = "Windows"
)

// PossibleKnownDataCollectionRuleResourceKindValues returns an array of possible values for the KnownDataCollectionRuleResourceKind const type.
func PossibleKnownDataCollectionRuleResourceKindValues() []KnownDataCollectionRuleResourceKind {
	return []KnownDataCollectionRuleResourceKind{KnownDataCollectionRuleResourceKindLinux, KnownDataCollectionRuleResourceKindWindows}
}

// KnownDataFlowStreams enumerates the values for known data flow streams.
type KnownDataFlowStreams string

const (
	// MicrosoftEvent ...
	MicrosoftEvent KnownDataFlowStreams = "Microsoft-Event"
	// MicrosoftInsightsMetrics ...
	MicrosoftInsightsMetrics KnownDataFlowStreams = "Microsoft-InsightsMetrics"
	// MicrosoftPerf ...
	MicrosoftPerf KnownDataFlowStreams = "Microsoft-Perf"
	// MicrosoftSyslog ...
	MicrosoftSyslog KnownDataFlowStreams = "Microsoft-Syslog"
	// MicrosoftWindowsEvent ...
	MicrosoftWindowsEvent KnownDataFlowStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownDataFlowStreamsValues returns an array of possible values for the KnownDataFlowStreams const type.
func PossibleKnownDataFlowStreamsValues() []KnownDataFlowStreams {
	return []KnownDataFlowStreams{MicrosoftEvent, MicrosoftInsightsMetrics, MicrosoftPerf, MicrosoftSyslog, MicrosoftWindowsEvent}
}

// KnownExtensionDataSourceStreams enumerates the values for known extension data source streams.
type KnownExtensionDataSourceStreams string

const (
	// KnownExtensionDataSourceStreamsMicrosoftEvent ...
	KnownExtensionDataSourceStreamsMicrosoftEvent KnownExtensionDataSourceStreams = "Microsoft-Event"
	// KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics ...
	KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics KnownExtensionDataSourceStreams = "Microsoft-InsightsMetrics"
	// KnownExtensionDataSourceStreamsMicrosoftPerf ...
	KnownExtensionDataSourceStreamsMicrosoftPerf KnownExtensionDataSourceStreams = "Microsoft-Perf"
	// KnownExtensionDataSourceStreamsMicrosoftSyslog ...
	KnownExtensionDataSourceStreamsMicrosoftSyslog KnownExtensionDataSourceStreams = "Microsoft-Syslog"
	// KnownExtensionDataSourceStreamsMicrosoftWindowsEvent ...
	KnownExtensionDataSourceStreamsMicrosoftWindowsEvent KnownExtensionDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownExtensionDataSourceStreamsValues returns an array of possible values for the KnownExtensionDataSourceStreams const type.
func PossibleKnownExtensionDataSourceStreamsValues() []KnownExtensionDataSourceStreams {
	return []KnownExtensionDataSourceStreams{KnownExtensionDataSourceStreamsMicrosoftEvent, KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics, KnownExtensionDataSourceStreamsMicrosoftPerf, KnownExtensionDataSourceStreamsMicrosoftSyslog, KnownExtensionDataSourceStreamsMicrosoftWindowsEvent}
}

// KnownLogFileTextSettingsRecordStartTimestampFormat enumerates the values for known log file text settings
// record start timestamp format.
type KnownLogFileTextSettingsRecordStartTimestampFormat string

const (
	// DdMMMyyyyHHmmsszzz ...
	DdMMMyyyyHHmmsszzz KnownLogFileTextSettingsRecordStartTimestampFormat = "dd/MMM/yyyy:HH:mm:ss zzz"
	// DdMMyyHHmmss ...
	DdMMyyHHmmss KnownLogFileTextSettingsRecordStartTimestampFormat = "ddMMyy HH:mm:ss"
	// ISO8601 ...
	ISO8601 KnownLogFileTextSettingsRecordStartTimestampFormat = "ISO 8601"
	// MDYYYYHHMMSSAMPM ...
	MDYYYYHHMMSSAMPM KnownLogFileTextSettingsRecordStartTimestampFormat = "M/D/YYYY HH:MM:SS AM/PM"
	// MMMdhhmmss ...
	MMMdhhmmss KnownLogFileTextSettingsRecordStartTimestampFormat = "MMM d hh:mm:ss"
	// MonDDYYYYHHMMSS ...
	MonDDYYYYHHMMSS KnownLogFileTextSettingsRecordStartTimestampFormat = "Mon DD, YYYY HH:MM:SS"
	// YyMMddHHmmss ...
	YyMMddHHmmss KnownLogFileTextSettingsRecordStartTimestampFormat = "yyMMdd HH:mm:ss"
	// YYYYMMDDHHMMSS ...
	YYYYMMDDHHMMSS KnownLogFileTextSettingsRecordStartTimestampFormat = "YYYY-MM-DD HH:MM:SS"
	// YyyyMMDdTHHmmssK ...
	YyyyMMDdTHHmmssK KnownLogFileTextSettingsRecordStartTimestampFormat = "yyyy-MM-ddTHH:mm:ssK"
)

// PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues returns an array of possible values for the KnownLogFileTextSettingsRecordStartTimestampFormat const type.
func PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues() []KnownLogFileTextSettingsRecordStartTimestampFormat {
	return []KnownLogFileTextSettingsRecordStartTimestampFormat{DdMMMyyyyHHmmsszzz, DdMMyyHHmmss, ISO8601, MDYYYYHHMMSSAMPM, MMMdhhmmss, MonDDYYYYHHMMSS, YyMMddHHmmss, YYYYMMDDHHMMSS, YyyyMMDdTHHmmssK}
}

// KnownPerfCounterDataSourceStreams enumerates the values for known perf counter data source streams.
type KnownPerfCounterDataSourceStreams string

const (
	// KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics ...
	KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics KnownPerfCounterDataSourceStreams = "Microsoft-InsightsMetrics"
	// KnownPerfCounterDataSourceStreamsMicrosoftPerf ...
	KnownPerfCounterDataSourceStreamsMicrosoftPerf KnownPerfCounterDataSourceStreams = "Microsoft-Perf"
)

// PossibleKnownPerfCounterDataSourceStreamsValues returns an array of possible values for the KnownPerfCounterDataSourceStreams const type.
func PossibleKnownPerfCounterDataSourceStreamsValues() []KnownPerfCounterDataSourceStreams {
	return []KnownPerfCounterDataSourceStreams{KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics, KnownPerfCounterDataSourceStreamsMicrosoftPerf}
}

// KnownPublicNetworkAccessOptions enumerates the values for known public network access options.
type KnownPublicNetworkAccessOptions string

const (
	// Disabled ...
	Disabled KnownPublicNetworkAccessOptions = "Disabled"
	// Enabled ...
	Enabled KnownPublicNetworkAccessOptions = "Enabled"
)

// PossibleKnownPublicNetworkAccessOptionsValues returns an array of possible values for the KnownPublicNetworkAccessOptions const type.
func PossibleKnownPublicNetworkAccessOptionsValues() []KnownPublicNetworkAccessOptions {
	return []KnownPublicNetworkAccessOptions{Disabled, Enabled}
}

// KnownSyslogDataSourceFacilityNames enumerates the values for known syslog data source facility names.
type KnownSyslogDataSourceFacilityNames string

const (
	// KnownSyslogDataSourceFacilityNamesAsterisk ...
	KnownSyslogDataSourceFacilityNamesAsterisk KnownSyslogDataSourceFacilityNames = "*"
	// KnownSyslogDataSourceFacilityNamesAuth ...
	KnownSyslogDataSourceFacilityNamesAuth KnownSyslogDataSourceFacilityNames = "auth"
	// KnownSyslogDataSourceFacilityNamesAuthpriv ...
	KnownSyslogDataSourceFacilityNamesAuthpriv KnownSyslogDataSourceFacilityNames = "authpriv"
	// KnownSyslogDataSourceFacilityNamesCron ...
	KnownSyslogDataSourceFacilityNamesCron KnownSyslogDataSourceFacilityNames = "cron"
	// KnownSyslogDataSourceFacilityNamesDaemon ...
	KnownSyslogDataSourceFacilityNamesDaemon KnownSyslogDataSourceFacilityNames = "daemon"
	// KnownSyslogDataSourceFacilityNamesKern ...
	KnownSyslogDataSourceFacilityNamesKern KnownSyslogDataSourceFacilityNames = "kern"
	// KnownSyslogDataSourceFacilityNamesLocal0 ...
	KnownSyslogDataSourceFacilityNamesLocal0 KnownSyslogDataSourceFacilityNames = "local0"
	// KnownSyslogDataSourceFacilityNamesLocal1 ...
	KnownSyslogDataSourceFacilityNamesLocal1 KnownSyslogDataSourceFacilityNames = "local1"
	// KnownSyslogDataSourceFacilityNamesLocal2 ...
	KnownSyslogDataSourceFacilityNamesLocal2 KnownSyslogDataSourceFacilityNames = "local2"
	// KnownSyslogDataSourceFacilityNamesLocal3 ...
	KnownSyslogDataSourceFacilityNamesLocal3 KnownSyslogDataSourceFacilityNames = "local3"
	// KnownSyslogDataSourceFacilityNamesLocal4 ...
	KnownSyslogDataSourceFacilityNamesLocal4 KnownSyslogDataSourceFacilityNames = "local4"
	// KnownSyslogDataSourceFacilityNamesLocal5 ...
	KnownSyslogDataSourceFacilityNamesLocal5 KnownSyslogDataSourceFacilityNames = "local5"
	// KnownSyslogDataSourceFacilityNamesLocal6 ...
	KnownSyslogDataSourceFacilityNamesLocal6 KnownSyslogDataSourceFacilityNames = "local6"
	// KnownSyslogDataSourceFacilityNamesLocal7 ...
	KnownSyslogDataSourceFacilityNamesLocal7 KnownSyslogDataSourceFacilityNames = "local7"
	// KnownSyslogDataSourceFacilityNamesLpr ...
	KnownSyslogDataSourceFacilityNamesLpr KnownSyslogDataSourceFacilityNames = "lpr"
	// KnownSyslogDataSourceFacilityNamesMail ...
	KnownSyslogDataSourceFacilityNamesMail KnownSyslogDataSourceFacilityNames = "mail"
	// KnownSyslogDataSourceFacilityNamesMark ...
	KnownSyslogDataSourceFacilityNamesMark KnownSyslogDataSourceFacilityNames = "mark"
	// KnownSyslogDataSourceFacilityNamesNews ...
	KnownSyslogDataSourceFacilityNamesNews KnownSyslogDataSourceFacilityNames = "news"
	// KnownSyslogDataSourceFacilityNamesSyslog ...
	KnownSyslogDataSourceFacilityNamesSyslog KnownSyslogDataSourceFacilityNames = "syslog"
	// KnownSyslogDataSourceFacilityNamesUser ...
	KnownSyslogDataSourceFacilityNamesUser KnownSyslogDataSourceFacilityNames = "user"
	// KnownSyslogDataSourceFacilityNamesUucp ...
	KnownSyslogDataSourceFacilityNamesUucp KnownSyslogDataSourceFacilityNames = "uucp"
)

// PossibleKnownSyslogDataSourceFacilityNamesValues returns an array of possible values for the KnownSyslogDataSourceFacilityNames const type.
func PossibleKnownSyslogDataSourceFacilityNamesValues() []KnownSyslogDataSourceFacilityNames {
	return []KnownSyslogDataSourceFacilityNames{KnownSyslogDataSourceFacilityNamesAsterisk, KnownSyslogDataSourceFacilityNamesAuth, KnownSyslogDataSourceFacilityNamesAuthpriv, KnownSyslogDataSourceFacilityNamesCron, KnownSyslogDataSourceFacilityNamesDaemon, KnownSyslogDataSourceFacilityNamesKern, KnownSyslogDataSourceFacilityNamesLocal0, KnownSyslogDataSourceFacilityNamesLocal1, KnownSyslogDataSourceFacilityNamesLocal2, KnownSyslogDataSourceFacilityNamesLocal3, KnownSyslogDataSourceFacilityNamesLocal4, KnownSyslogDataSourceFacilityNamesLocal5, KnownSyslogDataSourceFacilityNamesLocal6, KnownSyslogDataSourceFacilityNamesLocal7, KnownSyslogDataSourceFacilityNamesLpr, KnownSyslogDataSourceFacilityNamesMail, KnownSyslogDataSourceFacilityNamesMark, KnownSyslogDataSourceFacilityNamesNews, KnownSyslogDataSourceFacilityNamesSyslog, KnownSyslogDataSourceFacilityNamesUser, KnownSyslogDataSourceFacilityNamesUucp}
}

// KnownSyslogDataSourceLogLevels enumerates the values for known syslog data source log levels.
type KnownSyslogDataSourceLogLevels string

const (
	// KnownSyslogDataSourceLogLevelsAlert ...
	KnownSyslogDataSourceLogLevelsAlert KnownSyslogDataSourceLogLevels = "Alert"
	// KnownSyslogDataSourceLogLevelsAsterisk ...
	KnownSyslogDataSourceLogLevelsAsterisk KnownSyslogDataSourceLogLevels = "*"
	// KnownSyslogDataSourceLogLevelsCritical ...
	KnownSyslogDataSourceLogLevelsCritical KnownSyslogDataSourceLogLevels = "Critical"
	// KnownSyslogDataSourceLogLevelsDebug ...
	KnownSyslogDataSourceLogLevelsDebug KnownSyslogDataSourceLogLevels = "Debug"
	// KnownSyslogDataSourceLogLevelsEmergency ...
	KnownSyslogDataSourceLogLevelsEmergency KnownSyslogDataSourceLogLevels = "Emergency"
	// KnownSyslogDataSourceLogLevelsError ...
	KnownSyslogDataSourceLogLevelsError KnownSyslogDataSourceLogLevels = "Error"
	// KnownSyslogDataSourceLogLevelsInfo ...
	KnownSyslogDataSourceLogLevelsInfo KnownSyslogDataSourceLogLevels = "Info"
	// KnownSyslogDataSourceLogLevelsNotice ...
	KnownSyslogDataSourceLogLevelsNotice KnownSyslogDataSourceLogLevels = "Notice"
	// KnownSyslogDataSourceLogLevelsWarning ...
	KnownSyslogDataSourceLogLevelsWarning KnownSyslogDataSourceLogLevels = "Warning"
)

// PossibleKnownSyslogDataSourceLogLevelsValues returns an array of possible values for the KnownSyslogDataSourceLogLevels const type.
func PossibleKnownSyslogDataSourceLogLevelsValues() []KnownSyslogDataSourceLogLevels {
	return []KnownSyslogDataSourceLogLevels{KnownSyslogDataSourceLogLevelsAlert, KnownSyslogDataSourceLogLevelsAsterisk, KnownSyslogDataSourceLogLevelsCritical, KnownSyslogDataSourceLogLevelsDebug, KnownSyslogDataSourceLogLevelsEmergency, KnownSyslogDataSourceLogLevelsError, KnownSyslogDataSourceLogLevelsInfo, KnownSyslogDataSourceLogLevelsNotice, KnownSyslogDataSourceLogLevelsWarning}
}

// KnownSyslogDataSourceStreams enumerates the values for known syslog data source streams.
type KnownSyslogDataSourceStreams string

const (
	// KnownSyslogDataSourceStreamsMicrosoftSyslog ...
	KnownSyslogDataSourceStreamsMicrosoftSyslog KnownSyslogDataSourceStreams = "Microsoft-Syslog"
)

// PossibleKnownSyslogDataSourceStreamsValues returns an array of possible values for the KnownSyslogDataSourceStreams const type.
func PossibleKnownSyslogDataSourceStreamsValues() []KnownSyslogDataSourceStreams {
	return []KnownSyslogDataSourceStreams{KnownSyslogDataSourceStreamsMicrosoftSyslog}
}

// KnownWindowsEventLogDataSourceStreams enumerates the values for known windows event log data source streams.
type KnownWindowsEventLogDataSourceStreams string

const (
	// KnownWindowsEventLogDataSourceStreamsMicrosoftEvent ...
	KnownWindowsEventLogDataSourceStreamsMicrosoftEvent KnownWindowsEventLogDataSourceStreams = "Microsoft-Event"
	// KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent ...
	KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent KnownWindowsEventLogDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownWindowsEventLogDataSourceStreamsValues returns an array of possible values for the KnownWindowsEventLogDataSourceStreams const type.
func PossibleKnownWindowsEventLogDataSourceStreamsValues() []KnownWindowsEventLogDataSourceStreams {
	return []KnownWindowsEventLogDataSourceStreams{KnownWindowsEventLogDataSourceStreamsMicrosoftEvent, KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent}
}

// MetricClass enumerates the values for metric class.
type MetricClass string

const (
	// Availability ...
	Availability MetricClass = "Availability"
	// Errors ...
	Errors MetricClass = "Errors"
	// Latency ...
	Latency MetricClass = "Latency"
	// Saturation ...
	Saturation MetricClass = "Saturation"
	// Transactions ...
	Transactions MetricClass = "Transactions"
)

// PossibleMetricClassValues returns an array of possible values for the MetricClass const type.
func PossibleMetricClassValues() []MetricClass {
	return []MetricClass{Availability, Errors, Latency, Saturation, Transactions}
}

// MetricStatisticType enumerates the values for metric statistic type.
type MetricStatisticType string

const (
	// MetricStatisticTypeAverage ...
	MetricStatisticTypeAverage MetricStatisticType = "Average"
	// MetricStatisticTypeCount ...
	MetricStatisticTypeCount MetricStatisticType = "Count"
	// MetricStatisticTypeMax ...
	MetricStatisticTypeMax MetricStatisticType = "Max"
	// MetricStatisticTypeMin ...
	MetricStatisticTypeMin MetricStatisticType = "Min"
	// MetricStatisticTypeSum ...
	MetricStatisticTypeSum MetricStatisticType = "Sum"
)

// PossibleMetricStatisticTypeValues returns an array of possible values for the MetricStatisticType const type.
func PossibleMetricStatisticTypeValues() []MetricStatisticType {
	return []MetricStatisticType{MetricStatisticTypeAverage, MetricStatisticTypeCount, MetricStatisticTypeMax, MetricStatisticTypeMin, MetricStatisticTypeSum}
}

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// MetricUnitBitsPerSecond ...
	MetricUnitBitsPerSecond MetricUnit = "BitsPerSecond"
	// MetricUnitBytes ...
	MetricUnitBytes MetricUnit = "Bytes"
	// MetricUnitByteSeconds ...
	MetricUnitByteSeconds MetricUnit = "ByteSeconds"
	// MetricUnitBytesPerSecond ...
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	// MetricUnitCores ...
	MetricUnitCores MetricUnit = "Cores"
	// MetricUnitCount ...
	MetricUnitCount MetricUnit = "Count"
	// MetricUnitCountPerSecond ...
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	// MetricUnitMilliCores ...
	MetricUnitMilliCores MetricUnit = "MilliCores"
	// MetricUnitMilliSeconds ...
	MetricUnitMilliSeconds MetricUnit = "MilliSeconds"
	// MetricUnitNanoCores ...
	MetricUnitNanoCores MetricUnit = "NanoCores"
	// MetricUnitPercent ...
	MetricUnitPercent MetricUnit = "Percent"
	// MetricUnitSeconds ...
	MetricUnitSeconds MetricUnit = "Seconds"
	// MetricUnitUnspecified ...
	MetricUnitUnspecified MetricUnit = "Unspecified"
)

// PossibleMetricUnitValues returns an array of possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{MetricUnitBitsPerSecond, MetricUnitBytes, MetricUnitByteSeconds, MetricUnitBytesPerSecond, MetricUnitCores, MetricUnitCount, MetricUnitCountPerSecond, MetricUnitMilliCores, MetricUnitMilliSeconds, MetricUnitNanoCores, MetricUnitPercent, MetricUnitSeconds, MetricUnitUnspecified}
}

// NamespaceClassification enumerates the values for namespace classification.
type NamespaceClassification string

const (
	// Custom ...
	Custom NamespaceClassification = "Custom"
	// Platform ...
	Platform NamespaceClassification = "Platform"
	// Qos ...
	Qos NamespaceClassification = "Qos"
)

// PossibleNamespaceClassificationValues returns an array of possible values for the NamespaceClassification const type.
func PossibleNamespaceClassificationValues() []NamespaceClassification {
	return []NamespaceClassification{Custom, Platform, Qos}
}

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource"
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource"
	// OdataTypeRuleDataSource ...
	OdataTypeRuleDataSource OdataType = "RuleDataSource"
)

// PossibleOdataTypeValues returns an array of possible values for the OdataType const type.
func PossibleOdataTypeValues() []OdataType {
	return []OdataType{OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource, OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource, OdataTypeRuleDataSource}
}

// OdataTypeBasicMetricAlertCriteria enumerates the values for odata type basic metric alert criteria.
type OdataTypeBasicMetricAlertCriteria string

const (
	// OdataTypeMetricAlertCriteria ...
	OdataTypeMetricAlertCriteria OdataTypeBasicMetricAlertCriteria = "MetricAlertCriteria"
	// OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria ...
	OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria OdataTypeBasicMetricAlertCriteria = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria"
	// OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria ...
	OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria OdataTypeBasicMetricAlertCriteria = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria"
	// OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria ...
	OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria OdataTypeBasicMetricAlertCriteria = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria"
)

// PossibleOdataTypeBasicMetricAlertCriteriaValues returns an array of possible values for the OdataTypeBasicMetricAlertCriteria const type.
func PossibleOdataTypeBasicMetricAlertCriteriaValues() []OdataTypeBasicMetricAlertCriteria {
	return []OdataTypeBasicMetricAlertCriteria{OdataTypeMetricAlertCriteria, OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria, OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria, OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria}
}

// OdataTypeBasicRuleAction enumerates the values for odata type basic rule action.
type OdataTypeBasicRuleAction string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction OdataTypeBasicRuleAction = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction"
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction OdataTypeBasicRuleAction = "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction"
	// OdataTypeRuleAction ...
	OdataTypeRuleAction OdataTypeBasicRuleAction = "RuleAction"
)

// PossibleOdataTypeBasicRuleActionValues returns an array of possible values for the OdataTypeBasicRuleAction const type.
func PossibleOdataTypeBasicRuleActionValues() []OdataTypeBasicRuleAction {
	return []OdataTypeBasicRuleAction{OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction, OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction, OdataTypeRuleAction}
}

// OdataTypeBasicRuleCondition enumerates the values for odata type basic rule condition.
type OdataTypeBasicRuleCondition string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition ...
	OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition"
	// OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition ...
	OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition"
	// OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition ...
	OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition"
	// OdataTypeRuleCondition ...
	OdataTypeRuleCondition OdataTypeBasicRuleCondition = "RuleCondition"
)

// PossibleOdataTypeBasicRuleConditionValues returns an array of possible values for the OdataTypeBasicRuleCondition const type.
func PossibleOdataTypeBasicRuleConditionValues() []OdataTypeBasicRuleCondition {
	return []OdataTypeBasicRuleCondition{OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition, OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition, OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition, OdataTypeRuleCondition}
}

// OnboardingStatus enumerates the values for onboarding status.
type OnboardingStatus string

const (
	// NotOnboarded ...
	NotOnboarded OnboardingStatus = "notOnboarded"
	// Onboarded ...
	Onboarded OnboardingStatus = "onboarded"
	// Unknown ...
	Unknown OnboardingStatus = "unknown"
)

// PossibleOnboardingStatusValues returns an array of possible values for the OnboardingStatus const type.
func PossibleOnboardingStatusValues() []OnboardingStatus {
	return []OnboardingStatus{NotOnboarded, Onboarded, Unknown}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// OperatorEquals ...
	OperatorEquals Operator = "Equals"
	// OperatorGreaterThan ...
	OperatorGreaterThan Operator = "GreaterThan"
	// OperatorGreaterThanOrEqual ...
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// OperatorLessThan ...
	OperatorLessThan Operator = "LessThan"
	// OperatorLessThanOrEqual ...
	OperatorLessThanOrEqual Operator = "LessThanOrEqual"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{OperatorEquals, OperatorGreaterThan, OperatorGreaterThanOrEqual, OperatorLessThan, OperatorLessThanOrEqual}
}

// OperatorForCondition enumerates the values for operator for condition.
type OperatorForCondition string

const (
	// OperatorForConditionEquals ...
	OperatorForConditionEquals OperatorForCondition = "Equals"
	// OperatorForConditionGreaterThan ...
	OperatorForConditionGreaterThan OperatorForCondition = "GreaterThan"
	// OperatorForConditionGreaterThanOrEqual ...
	OperatorForConditionGreaterThanOrEqual OperatorForCondition = "GreaterThanOrEqual"
	// OperatorForConditionLessThan ...
	OperatorForConditionLessThan OperatorForCondition = "LessThan"
	// OperatorForConditionLessThanOrEqual ...
	OperatorForConditionLessThanOrEqual OperatorForCondition = "LessThanOrEqual"
)

// PossibleOperatorForConditionValues returns an array of possible values for the OperatorForCondition const type.
func PossibleOperatorForConditionValues() []OperatorForCondition {
	return []OperatorForCondition{OperatorForConditionEquals, OperatorForConditionGreaterThan, OperatorForConditionGreaterThanOrEqual, OperatorForConditionLessThan, OperatorForConditionLessThanOrEqual}
}

// PredictiveAutoscalePolicyScaleMode enumerates the values for predictive autoscale policy scale mode.
type PredictiveAutoscalePolicyScaleMode string

const (
	// PredictiveAutoscalePolicyScaleModeDisabled ...
	PredictiveAutoscalePolicyScaleModeDisabled PredictiveAutoscalePolicyScaleMode = "Disabled"
	// PredictiveAutoscalePolicyScaleModeEnabled ...
	PredictiveAutoscalePolicyScaleModeEnabled PredictiveAutoscalePolicyScaleMode = "Enabled"
	// PredictiveAutoscalePolicyScaleModeForecastOnly ...
	PredictiveAutoscalePolicyScaleModeForecastOnly PredictiveAutoscalePolicyScaleMode = "ForecastOnly"
)

// PossiblePredictiveAutoscalePolicyScaleModeValues returns an array of possible values for the PredictiveAutoscalePolicyScaleMode const type.
func PossiblePredictiveAutoscalePolicyScaleModeValues() []PredictiveAutoscalePolicyScaleMode {
	return []PredictiveAutoscalePolicyScaleMode{PredictiveAutoscalePolicyScaleModeDisabled, PredictiveAutoscalePolicyScaleModeEnabled, PredictiveAutoscalePolicyScaleModeForecastOnly}
}

// ReceiverStatus enumerates the values for receiver status.
type ReceiverStatus string

const (
	// ReceiverStatusDisabled ...
	ReceiverStatusDisabled ReceiverStatus = "Disabled"
	// ReceiverStatusEnabled ...
	ReceiverStatusEnabled ReceiverStatus = "Enabled"
	// ReceiverStatusNotSpecified ...
	ReceiverStatusNotSpecified ReceiverStatus = "NotSpecified"
)

// PossibleReceiverStatusValues returns an array of possible values for the ReceiverStatus const type.
func PossibleReceiverStatusValues() []ReceiverStatus {
	return []ReceiverStatus{ReceiverStatusDisabled, ReceiverStatusEnabled, ReceiverStatusNotSpecified}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// RecurrenceFrequencyDay ...
	RecurrenceFrequencyDay RecurrenceFrequency = "Day"
	// RecurrenceFrequencyHour ...
	RecurrenceFrequencyHour RecurrenceFrequency = "Hour"
	// RecurrenceFrequencyMinute ...
	RecurrenceFrequencyMinute RecurrenceFrequency = "Minute"
	// RecurrenceFrequencyMonth ...
	RecurrenceFrequencyMonth RecurrenceFrequency = "Month"
	// RecurrenceFrequencyNone ...
	RecurrenceFrequencyNone RecurrenceFrequency = "None"
	// RecurrenceFrequencySecond ...
	RecurrenceFrequencySecond RecurrenceFrequency = "Second"
	// RecurrenceFrequencyWeek ...
	RecurrenceFrequencyWeek RecurrenceFrequency = "Week"
	// RecurrenceFrequencyYear ...
	RecurrenceFrequencyYear RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{RecurrenceFrequencyDay, RecurrenceFrequencyHour, RecurrenceFrequencyMinute, RecurrenceFrequencyMonth, RecurrenceFrequencyNone, RecurrenceFrequencySecond, RecurrenceFrequencyWeek, RecurrenceFrequencyYear}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// ResultTypeData ...
	ResultTypeData ResultType = "Data"
	// ResultTypeMetadata ...
	ResultTypeMetadata ResultType = "Metadata"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{ResultTypeData, ResultTypeMetadata}
}

// ScaleDirection enumerates the values for scale direction.
type ScaleDirection string

const (
	// ScaleDirectionDecrease ...
	ScaleDirectionDecrease ScaleDirection = "Decrease"
	// ScaleDirectionIncrease ...
	ScaleDirectionIncrease ScaleDirection = "Increase"
	// ScaleDirectionNone ...
	ScaleDirectionNone ScaleDirection = "None"
)

// PossibleScaleDirectionValues returns an array of possible values for the ScaleDirection const type.
func PossibleScaleDirectionValues() []ScaleDirection {
	return []ScaleDirection{ScaleDirectionDecrease, ScaleDirectionIncrease, ScaleDirectionNone}
}

// ScaleRuleMetricDimensionOperationType enumerates the values for scale rule metric dimension operation type.
type ScaleRuleMetricDimensionOperationType string

const (
	// ScaleRuleMetricDimensionOperationTypeEquals ...
	ScaleRuleMetricDimensionOperationTypeEquals ScaleRuleMetricDimensionOperationType = "Equals"
	// ScaleRuleMetricDimensionOperationTypeNotEquals ...
	ScaleRuleMetricDimensionOperationTypeNotEquals ScaleRuleMetricDimensionOperationType = "NotEquals"
)

// PossibleScaleRuleMetricDimensionOperationTypeValues returns an array of possible values for the ScaleRuleMetricDimensionOperationType const type.
func PossibleScaleRuleMetricDimensionOperationTypeValues() []ScaleRuleMetricDimensionOperationType {
	return []ScaleRuleMetricDimensionOperationType{ScaleRuleMetricDimensionOperationTypeEquals, ScaleRuleMetricDimensionOperationTypeNotEquals}
}

// ScaleType enumerates the values for scale type.
type ScaleType string

const (
	// ChangeCount ...
	ChangeCount ScaleType = "ChangeCount"
	// ExactCount ...
	ExactCount ScaleType = "ExactCount"
	// PercentChangeCount ...
	PercentChangeCount ScaleType = "PercentChangeCount"
	// ServiceAllowedNextValue ...
	ServiceAllowedNextValue ScaleType = "ServiceAllowedNextValue"
)

// PossibleScaleTypeValues returns an array of possible values for the ScaleType const type.
func PossibleScaleTypeValues() []ScaleType {
	return []ScaleType{ChangeCount, ExactCount, PercentChangeCount, ServiceAllowedNextValue}
}

// TimeAggregation enumerates the values for time aggregation.
type TimeAggregation string

const (
	// TimeAggregationAverage ...
	TimeAggregationAverage TimeAggregation = "Average"
	// TimeAggregationCount ...
	TimeAggregationCount TimeAggregation = "Count"
	// TimeAggregationMaximum ...
	TimeAggregationMaximum TimeAggregation = "Maximum"
	// TimeAggregationMinimum ...
	TimeAggregationMinimum TimeAggregation = "Minimum"
	// TimeAggregationTotal ...
	TimeAggregationTotal TimeAggregation = "Total"
)

// PossibleTimeAggregationValues returns an array of possible values for the TimeAggregation const type.
func PossibleTimeAggregationValues() []TimeAggregation {
	return []TimeAggregation{TimeAggregationAverage, TimeAggregationCount, TimeAggregationMaximum, TimeAggregationMinimum, TimeAggregationTotal}
}

// TimeAggregationOperator enumerates the values for time aggregation operator.
type TimeAggregationOperator string

const (
	// TimeAggregationOperatorAverage ...
	TimeAggregationOperatorAverage TimeAggregationOperator = "Average"
	// TimeAggregationOperatorLast ...
	TimeAggregationOperatorLast TimeAggregationOperator = "Last"
	// TimeAggregationOperatorMaximum ...
	TimeAggregationOperatorMaximum TimeAggregationOperator = "Maximum"
	// TimeAggregationOperatorMinimum ...
	TimeAggregationOperatorMinimum TimeAggregationOperator = "Minimum"
	// TimeAggregationOperatorTotal ...
	TimeAggregationOperatorTotal TimeAggregationOperator = "Total"
)

// PossibleTimeAggregationOperatorValues returns an array of possible values for the TimeAggregationOperator const type.
func PossibleTimeAggregationOperatorValues() []TimeAggregationOperator {
	return []TimeAggregationOperator{TimeAggregationOperatorAverage, TimeAggregationOperatorLast, TimeAggregationOperatorMaximum, TimeAggregationOperatorMinimum, TimeAggregationOperatorTotal}
}

// TimeAggregationType enumerates the values for time aggregation type.
type TimeAggregationType string

const (
	// TimeAggregationTypeAverage ...
	TimeAggregationTypeAverage TimeAggregationType = "Average"
	// TimeAggregationTypeCount ...
	TimeAggregationTypeCount TimeAggregationType = "Count"
	// TimeAggregationTypeLast ...
	TimeAggregationTypeLast TimeAggregationType = "Last"
	// TimeAggregationTypeMaximum ...
	TimeAggregationTypeMaximum TimeAggregationType = "Maximum"
	// TimeAggregationTypeMinimum ...
	TimeAggregationTypeMinimum TimeAggregationType = "Minimum"
	// TimeAggregationTypeTotal ...
	TimeAggregationTypeTotal TimeAggregationType = "Total"
)

// PossibleTimeAggregationTypeValues returns an array of possible values for the TimeAggregationType const type.
func PossibleTimeAggregationTypeValues() []TimeAggregationType {
	return []TimeAggregationType{TimeAggregationTypeAverage, TimeAggregationTypeCount, TimeAggregationTypeLast, TimeAggregationTypeMaximum, TimeAggregationTypeMinimum, TimeAggregationTypeTotal}
}
