package deviceupdate

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/deviceupdate/mgmt/2020-03-01-preview/deviceupdate"

// Account device Update account details.
type Account struct {
	autorest.Response `json:"-"`
	// AccountProperties - Device Update account properties.
	*AccountProperties `json:"properties,omitempty"`
	// Identity - The type of identity used for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				a.SystemData = &systemData
			}
		}
	}

	return nil
}

// AccountList list of Accounts.
type AccountList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of Accounts list.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of Accounts.
	Value *[]Account `json:"value,omitempty"`
}

// AccountListIterator provides access to a complete listing of Account values.
type AccountListIterator struct {
	i    int
	page AccountListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListIterator) Response() AccountList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListIterator type.
func NewAccountListIterator(page AccountListPage) AccountListIterator {
	return AccountListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AccountList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AccountList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// accountListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AccountList) accountListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AccountListPage contains a page of Account values.
type AccountListPage struct {
	fn func(context.Context, AccountList) (AccountList, error)
	al AccountList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListPage) Response() AccountList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListPage) Values() []Account {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AccountListPage type.
func NewAccountListPage(cur AccountList, getNextPage func(context.Context, AccountList) (AccountList, error)) AccountListPage {
	return AccountListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AccountProperties device Update account properties.
type AccountProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateDeleted', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateAccepted', 'ProvisioningStateCreating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// HostName - READ-ONLY; API host name.
	HostName *string `json:"hostName,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for the container registry. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (a AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = a.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// AccountsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsCreateFuture.Result.
func (future *AccountsCreateFuture) result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.AccountsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("deviceupdate.AccountsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "deviceupdate.AccountsCreateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsDeleteFuture.Result.
func (future *AccountsDeleteFuture) result(client AccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.AccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("deviceupdate.AccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AccountsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsUpdateFuture.Result.
func (future *AccountsUpdateFuture) result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.AccountsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("deviceupdate.AccountsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.UpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "deviceupdate.AccountsUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountUpdate request payload used to update and existing Accounts.
type AccountUpdate struct {
	// Identity - The type of identity used for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs that describe the resource. This will overwrite the existing tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AccountUpdate.
func (au AccountUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if au.Identity != nil {
		objectMap["identity"] = au.Identity
	}
	if au.Location != nil {
		objectMap["location"] = au.Location
	}
	if au.Tags != nil {
		objectMap["tags"] = au.Tags
	}
	return json.Marshal(objectMap)
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CheckNameAvailabilityRequest the check availability request body.
type CheckNameAvailabilityRequest struct {
	// Name - The name of the resource for which availability needs to be checked.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse the check availability result.
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates if the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the given name is not available. Possible values include: 'Invalid', 'AlreadyExists'
	Reason CheckNameAvailabilityReason `json:"reason,omitempty"`
	// Message - Detailed reason why the given name is available.
	Message *string `json:"message,omitempty"`
}

// DiagnosticStorageProperties customer-initiated diagnostic log collection storage properties
type DiagnosticStorageProperties struct {
	// AuthenticationType - Authentication Type
	AuthenticationType *string `json:"authenticationType,omitempty"`
	// ConnectionString - ConnectionString of the diagnostic storage account
	ConnectionString *string `json:"connectionString,omitempty"`
	// ResourceID - ResourceId of the diagnostic storage account
	ResourceID *string `json:"resourceId,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GroupInformation the group information for creating a private endpoint on an Account
type GroupInformation struct {
	autorest.Response `json:"-"`
	// GroupInformationProperties - The properties for a group information object
	*GroupInformationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupInformation.
func (gi GroupInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gi.GroupInformationProperties != nil {
		objectMap["properties"] = gi.GroupInformationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GroupInformation struct.
func (gi *GroupInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var groupInformationProperties GroupInformationProperties
				err = json.Unmarshal(*v, &groupInformationProperties)
				if err != nil {
					return err
				}
				gi.GroupInformationProperties = &groupInformationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gi.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				gi.SystemData = &systemData
			}
		}
	}

	return nil
}

// GroupInformationProperties the properties for a group information object
type GroupInformationProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of private link group ID. Possible values include: 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState GroupIDProvisioningState `json:"provisioningState,omitempty"`
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupInformationProperties.
func (gip GroupInformationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gip.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = gip.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// Instance device Update instance details.
type Instance struct {
	autorest.Response `json:"-"`
	// InstanceProperties - Device Update instance properties.
	*InstanceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Instance.
func (i Instance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InstanceProperties != nil {
		objectMap["properties"] = i.InstanceProperties
	}
	if i.Tags != nil {
		objectMap["tags"] = i.Tags
	}
	if i.Location != nil {
		objectMap["location"] = i.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Instance struct.
func (i *Instance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var instanceProperties InstanceProperties
				err = json.Unmarshal(*v, &instanceProperties)
				if err != nil {
					return err
				}
				i.InstanceProperties = &instanceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				i.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				i.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				i.SystemData = &systemData
			}
		}
	}

	return nil
}

// InstanceList list of Instances.
type InstanceList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of Instances list.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of Instances.
	Value *[]Instance `json:"value,omitempty"`
}

// InstanceListIterator provides access to a complete listing of Instance values.
type InstanceListIterator struct {
	i    int
	page InstanceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InstanceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstanceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InstanceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InstanceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InstanceListIterator) Response() InstanceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InstanceListIterator) Value() Instance {
	if !iter.page.NotDone() {
		return Instance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InstanceListIterator type.
func NewInstanceListIterator(page InstanceListPage) InstanceListIterator {
	return InstanceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (il InstanceList) IsEmpty() bool {
	return il.Value == nil || len(*il.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (il InstanceList) hasNextLink() bool {
	return il.NextLink != nil && len(*il.NextLink) != 0
}

// instanceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (il InstanceList) instanceListPreparer(ctx context.Context) (*http.Request, error) {
	if !il.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(il.NextLink)))
}

// InstanceListPage contains a page of Instance values.
type InstanceListPage struct {
	fn func(context.Context, InstanceList) (InstanceList, error)
	il InstanceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InstanceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstanceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.il)
		if err != nil {
			return err
		}
		page.il = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InstanceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InstanceListPage) NotDone() bool {
	return !page.il.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InstanceListPage) Response() InstanceList {
	return page.il
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InstanceListPage) Values() []Instance {
	if page.il.IsEmpty() {
		return nil
	}
	return *page.il.Value
}

// Creates a new instance of the InstanceListPage type.
func NewInstanceListPage(cur InstanceList, getNextPage func(context.Context, InstanceList) (InstanceList, error)) InstanceListPage {
	return InstanceListPage{
		fn: getNextPage,
		il: cur,
	}
}

// InstanceProperties device Update instance properties.
type InstanceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateDeleted', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateAccepted', 'ProvisioningStateCreating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// AccountName - READ-ONLY; Parent Device Update Account name which Instance belongs to.
	AccountName *string `json:"accountName,omitempty"`
	// IotHubs - List of IoT Hubs associated with the account.
	IotHubs *[]IotHubSettings `json:"iotHubs,omitempty"`
	// EnableDiagnostics - Enables or Disables the diagnostic logs collection
	EnableDiagnostics           *bool                        `json:"enableDiagnostics,omitempty"`
	DiagnosticStorageProperties *DiagnosticStorageProperties `json:"diagnosticStorageProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceProperties.
func (i InstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.IotHubs != nil {
		objectMap["iotHubs"] = i.IotHubs
	}
	if i.EnableDiagnostics != nil {
		objectMap["enableDiagnostics"] = i.EnableDiagnostics
	}
	if i.DiagnosticStorageProperties != nil {
		objectMap["diagnosticStorageProperties"] = i.DiagnosticStorageProperties
	}
	return json.Marshal(objectMap)
}

// InstancesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InstancesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstancesClient) (Instance, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstancesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstancesCreateFuture.Result.
func (future *InstancesCreateFuture) result(client InstancesClient) (i Instance, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.InstancesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		i.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("deviceupdate.InstancesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if i.Response.Response, err = future.GetResult(sender); err == nil && i.Response.Response.StatusCode != http.StatusNoContent {
		i, err = client.CreateResponder(i.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "deviceupdate.InstancesCreateFuture", "Result", i.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstancesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InstancesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstancesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstancesDeleteFuture.Result.
func (future *InstancesDeleteFuture) result(client InstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.InstancesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("deviceupdate.InstancesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IotHubSettings device Update account integration with IoT Hub settings.
type IotHubSettings struct {
	// ResourceID - IoTHub resource ID
	ResourceID *string `json:"resourceId,omitempty"`
	// IoTHubConnectionString - IoTHub connection string.
	IoTHubConnectionString *string `json:"ioTHubConnectionString,omitempty"`
	// EventHubConnectionString - EventHub connection string.
	EventHubConnectionString *string `json:"eventHubConnectionString,omitempty"`
}

// ManagedServiceIdentity managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// PrincipalID - READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// Type - Possible values include: 'None', 'SystemAssigned', 'UserAssigned', 'SystemAssignedUserAssigned'
	Type                   ManagedServiceIdentityType       `json:"type,omitempty"`
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ManagedServiceIdentity.
func (msi ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msi.Type != "" {
		objectMap["type"] = msi.Type
	}
	if msi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = msi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// Operation details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Name - READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane operations.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is "user,system". Possible values include: 'OriginUser', 'OriginSystem', 'OriginUsersystem'
	Origin Origin `json:"origin,omitempty"`
	// ActionType - READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs. Possible values include: 'Internal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay localized display information for this particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft Compute".
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job Schedule Collections".
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult a list of REST API operations supported by an Azure Resource Provider. It contains
// an URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the resource provider
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pec.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// storage account
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("deviceupdate.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("deviceupdate.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResourceListResult the available private link resources for an Account
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of available private link resources for an Account
	Value *[]GroupInformation `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of private link resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'Pending', 'Approved', 'Rejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagUpdate request payload used to update an existing resource's tags.
type TagUpdate struct {
	// Tags - List of key value pairs that describe the resource. This will overwrite the existing tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagUpdate.
func (tu TagUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tu.Tags != nil {
		objectMap["tags"] = tu.Tags
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UserAssignedIdentity user assigned identity properties
type UserAssignedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client ID of the assigned identity.
	ClientID *uuid.UUID `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedIdentity.
func (uai UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}
