package desktopvirtualization

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/desktopvirtualization/mgmt/2021-09-03-preview/desktopvirtualization"

// Application schema for Application properties.
type Application struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ApplicationProperties - Detailed properties for Application
	*ApplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.SystemData != nil {
		objectMap["systemData"] = a.SystemData
	}
	if a.ApplicationProperties != nil {
		objectMap["properties"] = a.ApplicationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Application struct.
func (a *Application) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				a.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var applicationProperties ApplicationProperties
				err = json.Unmarshal(*v, &applicationProperties)
				if err != nil {
					return err
				}
				a.ApplicationProperties = &applicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// ApplicationGroup represents a ApplicationGroup definition.
type ApplicationGroup struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ApplicationGroupProperties - Detailed properties for ApplicationGroup
	*ApplicationGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ManagedBy - The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Kind - Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
	Kind *string `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags     map[string]*string                           `json:"tags"`
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`
	Sku      *ResourceModelWithAllowedPropertySetSku      `json:"sku,omitempty"`
	Plan     *ResourceModelWithAllowedPropertySetPlan     `json:"plan,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGroup.
func (ag ApplicationGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.SystemData != nil {
		objectMap["systemData"] = ag.SystemData
	}
	if ag.ApplicationGroupProperties != nil {
		objectMap["properties"] = ag.ApplicationGroupProperties
	}
	if ag.Location != nil {
		objectMap["location"] = ag.Location
	}
	if ag.ManagedBy != nil {
		objectMap["managedBy"] = ag.ManagedBy
	}
	if ag.Kind != nil {
		objectMap["kind"] = ag.Kind
	}
	if ag.Tags != nil {
		objectMap["tags"] = ag.Tags
	}
	if ag.Identity != nil {
		objectMap["identity"] = ag.Identity
	}
	if ag.Sku != nil {
		objectMap["sku"] = ag.Sku
	}
	if ag.Plan != nil {
		objectMap["plan"] = ag.Plan
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGroup struct.
func (ag *ApplicationGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ag.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var applicationGroupProperties ApplicationGroupProperties
				err = json.Unmarshal(*v, &applicationGroupProperties)
				if err != nil {
					return err
				}
				ag.ApplicationGroupProperties = &applicationGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ag.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ag.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ag.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ag.Location = &location
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				ag.ManagedBy = &managedBy
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ag.Kind = &kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ag.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ag.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ResourceModelWithAllowedPropertySetIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ag.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ResourceModelWithAllowedPropertySetSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ag.Sku = &sku
			}
		case "plan":
			if v != nil {
				var plan ResourceModelWithAllowedPropertySetPlan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				ag.Plan = &plan
			}
		}
	}

	return nil
}

// ApplicationGroupList list of ApplicationGroup definitions.
type ApplicationGroupList struct {
	autorest.Response `json:"-"`
	// Value - List of ApplicationGroup definitions.
	Value *[]ApplicationGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGroupList.
func (agl ApplicationGroupList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agl.Value != nil {
		objectMap["value"] = agl.Value
	}
	return json.Marshal(objectMap)
}

// ApplicationGroupListIterator provides access to a complete listing of ApplicationGroup values.
type ApplicationGroupListIterator struct {
	i    int
	page ApplicationGroupListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGroupListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGroupListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGroupListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGroupListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGroupListIterator) Response() ApplicationGroupList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGroupListIterator) Value() ApplicationGroup {
	if !iter.page.NotDone() {
		return ApplicationGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGroupListIterator type.
func NewApplicationGroupListIterator(page ApplicationGroupListPage) ApplicationGroupListIterator {
	return ApplicationGroupListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (agl ApplicationGroupList) IsEmpty() bool {
	return agl.Value == nil || len(*agl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (agl ApplicationGroupList) hasNextLink() bool {
	return agl.NextLink != nil && len(*agl.NextLink) != 0
}

// applicationGroupListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (agl ApplicationGroupList) applicationGroupListPreparer(ctx context.Context) (*http.Request, error) {
	if !agl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(agl.NextLink)))
}

// ApplicationGroupListPage contains a page of ApplicationGroup values.
type ApplicationGroupListPage struct {
	fn  func(context.Context, ApplicationGroupList) (ApplicationGroupList, error)
	agl ApplicationGroupList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGroupListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGroupListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.agl)
		if err != nil {
			return err
		}
		page.agl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGroupListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGroupListPage) NotDone() bool {
	return !page.agl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGroupListPage) Response() ApplicationGroupList {
	return page.agl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGroupListPage) Values() []ApplicationGroup {
	if page.agl.IsEmpty() {
		return nil
	}
	return *page.agl.Value
}

// Creates a new instance of the ApplicationGroupListPage type.
func NewApplicationGroupListPage(cur ApplicationGroupList, getNextPage func(context.Context, ApplicationGroupList) (ApplicationGroupList, error)) ApplicationGroupListPage {
	return ApplicationGroupListPage{
		fn:  getNextPage,
		agl: cur,
	}
}

// ApplicationGroupPatch applicationGroup properties that can be patched.
type ApplicationGroupPatch struct {
	// Tags - tags to be updated
	Tags map[string]*string `json:"tags"`
	// ApplicationGroupPatchProperties - ApplicationGroup properties that can be patched.
	*ApplicationGroupPatchProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGroupPatch.
func (agp ApplicationGroupPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agp.Tags != nil {
		objectMap["tags"] = agp.Tags
	}
	if agp.ApplicationGroupPatchProperties != nil {
		objectMap["properties"] = agp.ApplicationGroupPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGroupPatch struct.
func (agp *ApplicationGroupPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agp.Tags = tags
			}
		case "properties":
			if v != nil {
				var applicationGroupPatchProperties ApplicationGroupPatchProperties
				err = json.Unmarshal(*v, &applicationGroupPatchProperties)
				if err != nil {
					return err
				}
				agp.ApplicationGroupPatchProperties = &applicationGroupPatchProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agp.Type = &typeVar
			}
		}
	}

	return nil
}

// ApplicationGroupPatchProperties applicationGroup properties that can be patched.
type ApplicationGroupPatchProperties struct {
	// Description - Description of ApplicationGroup.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of ApplicationGroup.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// ApplicationGroupProperties schema for ApplicationGroup properties.
type ApplicationGroupProperties struct {
	// ObjectID - READ-ONLY; ObjectId of ApplicationGroup. (internal use)
	ObjectID *string `json:"objectId,omitempty"`
	// Description - Description of ApplicationGroup.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of ApplicationGroup.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// HostPoolArmPath - HostPool arm path of ApplicationGroup.
	HostPoolArmPath *string `json:"hostPoolArmPath,omitempty"`
	// WorkspaceArmPath - READ-ONLY; Workspace arm path of ApplicationGroup.
	WorkspaceArmPath *string `json:"workspaceArmPath,omitempty"`
	// ApplicationGroupType - Resource Type of ApplicationGroup. Possible values include: 'ApplicationGroupTypeRemoteApp', 'ApplicationGroupTypeDesktop'
	ApplicationGroupType ApplicationGroupType `json:"applicationGroupType,omitempty"`
	// MigrationRequest - The registration info of HostPool.
	MigrationRequest *MigrationRequestProperties `json:"migrationRequest,omitempty"`
	// CloudPcResource - READ-ONLY; Is cloud pc resource.
	CloudPcResource *bool `json:"cloudPcResource,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGroupProperties.
func (agp ApplicationGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agp.Description != nil {
		objectMap["description"] = agp.Description
	}
	if agp.FriendlyName != nil {
		objectMap["friendlyName"] = agp.FriendlyName
	}
	if agp.HostPoolArmPath != nil {
		objectMap["hostPoolArmPath"] = agp.HostPoolArmPath
	}
	if agp.ApplicationGroupType != "" {
		objectMap["applicationGroupType"] = agp.ApplicationGroupType
	}
	if agp.MigrationRequest != nil {
		objectMap["migrationRequest"] = agp.MigrationRequest
	}
	return json.Marshal(objectMap)
}

// ApplicationList list of Application definitions.
type ApplicationList struct {
	autorest.Response `json:"-"`
	// Value - List of Application definitions.
	Value *[]Application `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationList.
func (al ApplicationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Value != nil {
		objectMap["value"] = al.Value
	}
	return json.Marshal(objectMap)
}

// ApplicationListIterator provides access to a complete listing of Application values.
type ApplicationListIterator struct {
	i    int
	page ApplicationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListIterator) Response() ApplicationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationListIterator type.
func NewApplicationListIterator(page ApplicationListPage) ApplicationListIterator {
	return ApplicationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ApplicationList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al ApplicationList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// applicationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ApplicationList) applicationListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ApplicationListPage contains a page of Application values.
type ApplicationListPage struct {
	fn func(context.Context, ApplicationList) (ApplicationList, error)
	al ApplicationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListPage) Response() ApplicationList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListPage) Values() []Application {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ApplicationListPage type.
func NewApplicationListPage(cur ApplicationList, getNextPage func(context.Context, ApplicationList) (ApplicationList, error)) ApplicationListPage {
	return ApplicationListPage{
		fn: getNextPage,
		al: cur,
	}
}

// ApplicationPatch application properties that can be patched.
type ApplicationPatch struct {
	// Tags - tags to be updated
	Tags map[string]*string `json:"tags"`
	// ApplicationPatchProperties - Detailed properties for Application
	*ApplicationPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationPatch.
func (ap ApplicationPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Tags != nil {
		objectMap["tags"] = ap.Tags
	}
	if ap.ApplicationPatchProperties != nil {
		objectMap["properties"] = ap.ApplicationPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationPatch struct.
func (ap *ApplicationPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ap.Tags = tags
			}
		case "properties":
			if v != nil {
				var applicationPatchProperties ApplicationPatchProperties
				err = json.Unmarshal(*v, &applicationPatchProperties)
				if err != nil {
					return err
				}
				ap.ApplicationPatchProperties = &applicationPatchProperties
			}
		}
	}

	return nil
}

// ApplicationPatchProperties application properties that can be patched.
type ApplicationPatchProperties struct {
	// Description - Description of Application.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Application.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// FilePath - Specifies a path for the executable file for the application.
	FilePath *string `json:"filePath,omitempty"`
	// CommandLineSetting - Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all. Possible values include: 'CommandLineSettingDoNotAllow', 'CommandLineSettingAllow', 'CommandLineSettingRequire'
	CommandLineSetting CommandLineSetting `json:"commandLineSetting,omitempty"`
	// CommandLineArguments - Command Line Arguments for Application.
	CommandLineArguments *string `json:"commandLineArguments,omitempty"`
	// ShowInPortal - Specifies whether to show the RemoteApp program in the RD Web Access server.
	ShowInPortal *bool `json:"showInPortal,omitempty"`
	// IconPath - Path to icon.
	IconPath *string `json:"iconPath,omitempty"`
	// IconIndex - Index of the icon.
	IconIndex *int32 `json:"iconIndex,omitempty"`
	// MsixPackageFamilyName - Specifies the package family name for MSIX applications
	MsixPackageFamilyName *string `json:"msixPackageFamilyName,omitempty"`
	// MsixPackageApplicationID - Specifies the package application Id for MSIX applications
	MsixPackageApplicationID *string `json:"msixPackageApplicationId,omitempty"`
	// ApplicationType - Resource Type of Application. Possible values include: 'RemoteApplicationTypeInBuilt', 'RemoteApplicationTypeMsixApplication'
	ApplicationType RemoteApplicationType `json:"applicationType,omitempty"`
}

// ApplicationProperties schema for Application properties.
type ApplicationProperties struct {
	// ObjectID - READ-ONLY; ObjectId of Application. (internal use)
	ObjectID *string `json:"objectId,omitempty"`
	// Description - Description of Application.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Application.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// FilePath - Specifies a path for the executable file for the application.
	FilePath *string `json:"filePath,omitempty"`
	// MsixPackageFamilyName - Specifies the package family name for MSIX applications
	MsixPackageFamilyName *string `json:"msixPackageFamilyName,omitempty"`
	// MsixPackageApplicationID - Specifies the package application Id for MSIX applications
	MsixPackageApplicationID *string `json:"msixPackageApplicationId,omitempty"`
	// ApplicationType - Resource Type of Application. Possible values include: 'RemoteApplicationTypeInBuilt', 'RemoteApplicationTypeMsixApplication'
	ApplicationType RemoteApplicationType `json:"applicationType,omitempty"`
	// CommandLineSetting - Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all. Possible values include: 'CommandLineSettingDoNotAllow', 'CommandLineSettingAllow', 'CommandLineSettingRequire'
	CommandLineSetting CommandLineSetting `json:"commandLineSetting,omitempty"`
	// CommandLineArguments - Command Line Arguments for Application.
	CommandLineArguments *string `json:"commandLineArguments,omitempty"`
	// ShowInPortal - Specifies whether to show the RemoteApp program in the RD Web Access server.
	ShowInPortal *bool `json:"showInPortal,omitempty"`
	// IconPath - Path to icon.
	IconPath *string `json:"iconPath,omitempty"`
	// IconIndex - Index of the icon.
	IconIndex *int32 `json:"iconIndex,omitempty"`
	// IconHash - READ-ONLY; Hash of the icon.
	IconHash *string `json:"iconHash,omitempty"`
	// IconContent - READ-ONLY; the icon a 64 bit string as a byte array.
	IconContent *[]byte `json:"iconContent,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationProperties.
func (ap ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Description != nil {
		objectMap["description"] = ap.Description
	}
	if ap.FriendlyName != nil {
		objectMap["friendlyName"] = ap.FriendlyName
	}
	if ap.FilePath != nil {
		objectMap["filePath"] = ap.FilePath
	}
	if ap.MsixPackageFamilyName != nil {
		objectMap["msixPackageFamilyName"] = ap.MsixPackageFamilyName
	}
	if ap.MsixPackageApplicationID != nil {
		objectMap["msixPackageApplicationId"] = ap.MsixPackageApplicationID
	}
	if ap.ApplicationType != "" {
		objectMap["applicationType"] = ap.ApplicationType
	}
	if ap.CommandLineSetting != "" {
		objectMap["commandLineSetting"] = ap.CommandLineSetting
	}
	if ap.CommandLineArguments != nil {
		objectMap["commandLineArguments"] = ap.CommandLineArguments
	}
	if ap.ShowInPortal != nil {
		objectMap["showInPortal"] = ap.ShowInPortal
	}
	if ap.IconPath != nil {
		objectMap["iconPath"] = ap.IconPath
	}
	if ap.IconIndex != nil {
		objectMap["iconIndex"] = ap.IconIndex
	}
	return json.Marshal(objectMap)
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError cloud error object.
type CloudError struct {
	Error *CloudErrorProperties `json:"error,omitempty"`
}

// CloudErrorProperties cloud error object properties.
type CloudErrorProperties struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// Desktop schema for Desktop properties.
type Desktop struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// DesktopProperties - Detailed properties for Desktop
	*DesktopProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Desktop.
func (d Desktop) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.SystemData != nil {
		objectMap["systemData"] = d.SystemData
	}
	if d.DesktopProperties != nil {
		objectMap["properties"] = d.DesktopProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Desktop struct.
func (d *Desktop) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				d.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var desktopProperties DesktopProperties
				err = json.Unmarshal(*v, &desktopProperties)
				if err != nil {
					return err
				}
				d.DesktopProperties = &desktopProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DesktopList list of Desktop definitions.
type DesktopList struct {
	autorest.Response `json:"-"`
	// Value - List of Desktop definitions.
	Value *[]Desktop `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DesktopList.
func (dl DesktopList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dl.Value != nil {
		objectMap["value"] = dl.Value
	}
	return json.Marshal(objectMap)
}

// DesktopListIterator provides access to a complete listing of Desktop values.
type DesktopListIterator struct {
	i    int
	page DesktopListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DesktopListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DesktopListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DesktopListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DesktopListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DesktopListIterator) Response() DesktopList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DesktopListIterator) Value() Desktop {
	if !iter.page.NotDone() {
		return Desktop{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DesktopListIterator type.
func NewDesktopListIterator(page DesktopListPage) DesktopListIterator {
	return DesktopListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dl DesktopList) IsEmpty() bool {
	return dl.Value == nil || len(*dl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dl DesktopList) hasNextLink() bool {
	return dl.NextLink != nil && len(*dl.NextLink) != 0
}

// desktopListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dl DesktopList) desktopListPreparer(ctx context.Context) (*http.Request, error) {
	if !dl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dl.NextLink)))
}

// DesktopListPage contains a page of Desktop values.
type DesktopListPage struct {
	fn func(context.Context, DesktopList) (DesktopList, error)
	dl DesktopList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DesktopListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DesktopListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dl)
		if err != nil {
			return err
		}
		page.dl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DesktopListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DesktopListPage) NotDone() bool {
	return !page.dl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DesktopListPage) Response() DesktopList {
	return page.dl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DesktopListPage) Values() []Desktop {
	if page.dl.IsEmpty() {
		return nil
	}
	return *page.dl.Value
}

// Creates a new instance of the DesktopListPage type.
func NewDesktopListPage(cur DesktopList, getNextPage func(context.Context, DesktopList) (DesktopList, error)) DesktopListPage {
	return DesktopListPage{
		fn: getNextPage,
		dl: cur,
	}
}

// DesktopPatch desktop properties that can be patched.
type DesktopPatch struct {
	// Tags - tags to be updated
	Tags map[string]*string `json:"tags"`
	// DesktopPatchProperties - Detailed properties for Desktop
	*DesktopPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DesktopPatch.
func (dp DesktopPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Tags != nil {
		objectMap["tags"] = dp.Tags
	}
	if dp.DesktopPatchProperties != nil {
		objectMap["properties"] = dp.DesktopPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DesktopPatch struct.
func (dp *DesktopPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dp.Tags = tags
			}
		case "properties":
			if v != nil {
				var desktopPatchProperties DesktopPatchProperties
				err = json.Unmarshal(*v, &desktopPatchProperties)
				if err != nil {
					return err
				}
				dp.DesktopPatchProperties = &desktopPatchProperties
			}
		}
	}

	return nil
}

// DesktopPatchProperties desktop properties that can be patched.
type DesktopPatchProperties struct {
	// Description - Description of Desktop.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Desktop.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// DesktopProperties schema for Desktop properties.
type DesktopProperties struct {
	// ObjectID - READ-ONLY; ObjectId of Desktop. (internal use)
	ObjectID *string `json:"objectId,omitempty"`
	// Description - Description of Desktop.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Desktop.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// IconHash - READ-ONLY; Hash of the icon.
	IconHash *string `json:"iconHash,omitempty"`
	// IconContent - READ-ONLY; The icon a 64 bit string as a byte array.
	IconContent *[]byte `json:"iconContent,omitempty"`
}

// MarshalJSON is the custom marshaler for DesktopProperties.
func (dp DesktopProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Description != nil {
		objectMap["description"] = dp.Description
	}
	if dp.FriendlyName != nil {
		objectMap["friendlyName"] = dp.FriendlyName
	}
	return json.Marshal(objectMap)
}

// ExpandMsixImage represents the definition of contents retrieved after expanding the MSIX Image.
type ExpandMsixImage struct {
	// ExpandMsixImageProperties - Detailed properties for ExpandMsixImage
	*ExpandMsixImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpandMsixImage.
func (emi ExpandMsixImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if emi.ExpandMsixImageProperties != nil {
		objectMap["properties"] = emi.ExpandMsixImageProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpandMsixImage struct.
func (emi *ExpandMsixImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expandMsixImageProperties ExpandMsixImageProperties
				err = json.Unmarshal(*v, &expandMsixImageProperties)
				if err != nil {
					return err
				}
				emi.ExpandMsixImageProperties = &expandMsixImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				emi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				emi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				emi.Type = &typeVar
			}
		}
	}

	return nil
}

// ExpandMsixImageList list of MSIX package properties retrieved from MSIX Image expansion.
type ExpandMsixImageList struct {
	autorest.Response `json:"-"`
	// Value - List of MSIX package properties from give MSIX Image.
	Value *[]ExpandMsixImage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpandMsixImageList.
func (emil ExpandMsixImageList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if emil.Value != nil {
		objectMap["value"] = emil.Value
	}
	return json.Marshal(objectMap)
}

// ExpandMsixImageListIterator provides access to a complete listing of ExpandMsixImage values.
type ExpandMsixImageListIterator struct {
	i    int
	page ExpandMsixImageListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpandMsixImageListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpandMsixImageListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpandMsixImageListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpandMsixImageListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpandMsixImageListIterator) Response() ExpandMsixImageList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpandMsixImageListIterator) Value() ExpandMsixImage {
	if !iter.page.NotDone() {
		return ExpandMsixImage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpandMsixImageListIterator type.
func NewExpandMsixImageListIterator(page ExpandMsixImageListPage) ExpandMsixImageListIterator {
	return ExpandMsixImageListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (emil ExpandMsixImageList) IsEmpty() bool {
	return emil.Value == nil || len(*emil.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (emil ExpandMsixImageList) hasNextLink() bool {
	return emil.NextLink != nil && len(*emil.NextLink) != 0
}

// expandMsixImageListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (emil ExpandMsixImageList) expandMsixImageListPreparer(ctx context.Context) (*http.Request, error) {
	if !emil.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(emil.NextLink)))
}

// ExpandMsixImageListPage contains a page of ExpandMsixImage values.
type ExpandMsixImageListPage struct {
	fn   func(context.Context, ExpandMsixImageList) (ExpandMsixImageList, error)
	emil ExpandMsixImageList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpandMsixImageListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpandMsixImageListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.emil)
		if err != nil {
			return err
		}
		page.emil = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpandMsixImageListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpandMsixImageListPage) NotDone() bool {
	return !page.emil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpandMsixImageListPage) Response() ExpandMsixImageList {
	return page.emil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpandMsixImageListPage) Values() []ExpandMsixImage {
	if page.emil.IsEmpty() {
		return nil
	}
	return *page.emil.Value
}

// Creates a new instance of the ExpandMsixImageListPage type.
func NewExpandMsixImageListPage(cur ExpandMsixImageList, getNextPage func(context.Context, ExpandMsixImageList) (ExpandMsixImageList, error)) ExpandMsixImageListPage {
	return ExpandMsixImageListPage{
		fn:   getNextPage,
		emil: cur,
	}
}

// ExpandMsixImageProperties schema for Expand MSIX Image properties.
type ExpandMsixImageProperties struct {
	// PackageAlias - Alias of MSIX Package.
	PackageAlias *string `json:"packageAlias,omitempty"`
	// ImagePath - VHD/CIM image path on Network Share.
	ImagePath *string `json:"imagePath,omitempty"`
	// PackageName - Package Name from appxmanifest.xml.
	PackageName *string `json:"packageName,omitempty"`
	// PackageFamilyName - Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
	PackageFamilyName *string `json:"packageFamilyName,omitempty"`
	// PackageFullName - Package Full Name from appxmanifest.xml.
	PackageFullName *string `json:"packageFullName,omitempty"`
	// DisplayName - User friendly Name to be displayed in the portal.
	DisplayName *string `json:"displayName,omitempty"`
	// PackageRelativePath - Relative Path to the package inside the image.
	PackageRelativePath *string `json:"packageRelativePath,omitempty"`
	// IsRegularRegistration - Specifies how to register Package in feed.
	IsRegularRegistration *bool `json:"isRegularRegistration,omitempty"`
	// IsActive - Make this version of the package the active one across the hostpool.
	IsActive *bool `json:"isActive,omitempty"`
	// PackageDependencies - List of package dependencies.
	PackageDependencies *[]MsixPackageDependencies `json:"packageDependencies,omitempty"`
	// Version - Package Version found in the appxmanifest.xml.
	Version *string `json:"version,omitempty"`
	// LastUpdated - Date Package was last updated, found in the appxmanifest.xml.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// PackageApplications - List of package applications.
	PackageApplications *[]MsixPackageApplications `json:"packageApplications,omitempty"`
}

// HostPool represents a HostPool definition.
type HostPool struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// HostPoolProperties - Detailed properties for HostPool
	*HostPoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ManagedBy - The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Kind - Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
	Kind *string `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags     map[string]*string                           `json:"tags"`
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`
	Sku      *ResourceModelWithAllowedPropertySetSku      `json:"sku,omitempty"`
	Plan     *ResourceModelWithAllowedPropertySetPlan     `json:"plan,omitempty"`
}

// MarshalJSON is the custom marshaler for HostPool.
func (hp HostPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hp.SystemData != nil {
		objectMap["systemData"] = hp.SystemData
	}
	if hp.HostPoolProperties != nil {
		objectMap["properties"] = hp.HostPoolProperties
	}
	if hp.Location != nil {
		objectMap["location"] = hp.Location
	}
	if hp.ManagedBy != nil {
		objectMap["managedBy"] = hp.ManagedBy
	}
	if hp.Kind != nil {
		objectMap["kind"] = hp.Kind
	}
	if hp.Tags != nil {
		objectMap["tags"] = hp.Tags
	}
	if hp.Identity != nil {
		objectMap["identity"] = hp.Identity
	}
	if hp.Sku != nil {
		objectMap["sku"] = hp.Sku
	}
	if hp.Plan != nil {
		objectMap["plan"] = hp.Plan
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HostPool struct.
func (hp *HostPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				hp.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var hostPoolProperties HostPoolProperties
				err = json.Unmarshal(*v, &hostPoolProperties)
				if err != nil {
					return err
				}
				hp.HostPoolProperties = &hostPoolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				hp.Location = &location
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				hp.ManagedBy = &managedBy
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hp.Kind = &kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				hp.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				hp.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ResourceModelWithAllowedPropertySetIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				hp.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ResourceModelWithAllowedPropertySetSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				hp.Sku = &sku
			}
		case "plan":
			if v != nil {
				var plan ResourceModelWithAllowedPropertySetPlan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				hp.Plan = &plan
			}
		}
	}

	return nil
}

// HostPoolList list of HostPool definitions.
type HostPoolList struct {
	autorest.Response `json:"-"`
	// Value - List of HostPool definitions.
	Value *[]HostPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for HostPoolList.
func (hpl HostPoolList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hpl.Value != nil {
		objectMap["value"] = hpl.Value
	}
	return json.Marshal(objectMap)
}

// HostPoolListIterator provides access to a complete listing of HostPool values.
type HostPoolListIterator struct {
	i    int
	page HostPoolListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HostPoolListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostPoolListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HostPoolListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HostPoolListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HostPoolListIterator) Response() HostPoolList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HostPoolListIterator) Value() HostPool {
	if !iter.page.NotDone() {
		return HostPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HostPoolListIterator type.
func NewHostPoolListIterator(page HostPoolListPage) HostPoolListIterator {
	return HostPoolListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hpl HostPoolList) IsEmpty() bool {
	return hpl.Value == nil || len(*hpl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hpl HostPoolList) hasNextLink() bool {
	return hpl.NextLink != nil && len(*hpl.NextLink) != 0
}

// hostPoolListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hpl HostPoolList) hostPoolListPreparer(ctx context.Context) (*http.Request, error) {
	if !hpl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hpl.NextLink)))
}

// HostPoolListPage contains a page of HostPool values.
type HostPoolListPage struct {
	fn  func(context.Context, HostPoolList) (HostPoolList, error)
	hpl HostPoolList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HostPoolListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostPoolListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hpl)
		if err != nil {
			return err
		}
		page.hpl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HostPoolListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HostPoolListPage) NotDone() bool {
	return !page.hpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HostPoolListPage) Response() HostPoolList {
	return page.hpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HostPoolListPage) Values() []HostPool {
	if page.hpl.IsEmpty() {
		return nil
	}
	return *page.hpl.Value
}

// Creates a new instance of the HostPoolListPage type.
func NewHostPoolListPage(cur HostPoolList, getNextPage func(context.Context, HostPoolList) (HostPoolList, error)) HostPoolListPage {
	return HostPoolListPage{
		fn:  getNextPage,
		hpl: cur,
	}
}

// HostPoolPatch hostPool properties that can be patched.
type HostPoolPatch struct {
	// Tags - tags to be updated
	Tags map[string]*string `json:"tags"`
	// HostPoolPatchProperties - HostPool properties that can be patched.
	*HostPoolPatchProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HostPoolPatch.
func (hpp HostPoolPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hpp.Tags != nil {
		objectMap["tags"] = hpp.Tags
	}
	if hpp.HostPoolPatchProperties != nil {
		objectMap["properties"] = hpp.HostPoolPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HostPoolPatch struct.
func (hpp *HostPoolPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				hpp.Tags = tags
			}
		case "properties":
			if v != nil {
				var hostPoolPatchProperties HostPoolPatchProperties
				err = json.Unmarshal(*v, &hostPoolPatchProperties)
				if err != nil {
					return err
				}
				hpp.HostPoolPatchProperties = &hostPoolPatchProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hpp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hpp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hpp.Type = &typeVar
			}
		}
	}

	return nil
}

// HostPoolPatchProperties properties of HostPool.
type HostPoolPatchProperties struct {
	// FriendlyName - Friendly name of HostPool.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Description - Description of HostPool.
	Description *string `json:"description,omitempty"`
	// CustomRdpProperty - Custom rdp property of HostPool.
	CustomRdpProperty *string `json:"customRdpProperty,omitempty"`
	// MaxSessionLimit - The max session limit of HostPool.
	MaxSessionLimit *int32 `json:"maxSessionLimit,omitempty"`
	// PersonalDesktopAssignmentType - PersonalDesktopAssignment type for HostPool. Possible values include: 'PersonalDesktopAssignmentTypeAutomatic', 'PersonalDesktopAssignmentTypeDirect'
	PersonalDesktopAssignmentType PersonalDesktopAssignmentType `json:"personalDesktopAssignmentType,omitempty"`
	// LoadBalancerType - The type of the load balancer. Possible values include: 'LoadBalancerTypeBreadthFirst', 'LoadBalancerTypeDepthFirst', 'LoadBalancerTypePersistent'
	LoadBalancerType LoadBalancerType `json:"loadBalancerType,omitempty"`
	// Ring - The ring number of HostPool.
	Ring *int32 `json:"ring,omitempty"`
	// ValidationEnvironment - Is validation environment.
	ValidationEnvironment *bool `json:"validationEnvironment,omitempty"`
	// RegistrationInfo - The registration info of HostPool.
	RegistrationInfo *RegistrationInfoPatch `json:"registrationInfo,omitempty"`
	// VMTemplate - VM template for sessionhosts configuration within hostpool.
	VMTemplate *string `json:"vmTemplate,omitempty"`
	// SsoadfsAuthority - URL to customer ADFS server for signing WVD SSO certificates.
	SsoadfsAuthority *string `json:"ssoadfsAuthority,omitempty"`
	// SsoClientID - ClientId for the registered Relying Party used to issue WVD SSO certificates.
	SsoClientID *string `json:"ssoClientId,omitempty"`
	// SsoClientSecretKeyVaultPath - Path to Azure KeyVault storing the secret used for communication to ADFS.
	SsoClientSecretKeyVaultPath *string `json:"ssoClientSecretKeyVaultPath,omitempty"`
	// SsoSecretType - The type of single sign on Secret Type. Possible values include: 'SSOSecretTypeSharedKey', 'SSOSecretTypeCertificate', 'SSOSecretTypeSharedKeyInKeyVault', 'SSOSecretTypeCertificateInKeyVault'
	SsoSecretType SSOSecretType `json:"ssoSecretType,omitempty"`
	// PreferredAppGroupType - The type of preferred application group type, default to Desktop Application Group. Possible values include: 'PreferredAppGroupTypeNone', 'PreferredAppGroupTypeDesktop', 'PreferredAppGroupTypeRailApplications'
	PreferredAppGroupType PreferredAppGroupType `json:"preferredAppGroupType,omitempty"`
	// StartVMOnConnect - The flag to turn on/off StartVMOnConnect feature.
	StartVMOnConnect *bool `json:"startVMOnConnect,omitempty"`
	// PublicNetworkAccess - Enabled to allow this resource to be access from the public network. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// HostPoolProperties properties of HostPool.
type HostPoolProperties struct {
	// ObjectID - READ-ONLY; ObjectId of HostPool. (internal use)
	ObjectID *string `json:"objectId,omitempty"`
	// FriendlyName - Friendly name of HostPool.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Description - Description of HostPool.
	Description *string `json:"description,omitempty"`
	// HostPoolType - HostPool type for desktop. Possible values include: 'HostPoolTypePersonal', 'HostPoolTypePooled', 'HostPoolTypeBYODesktop'
	HostPoolType HostPoolType `json:"hostPoolType,omitempty"`
	// PersonalDesktopAssignmentType - PersonalDesktopAssignment type for HostPool. Possible values include: 'PersonalDesktopAssignmentTypeAutomatic', 'PersonalDesktopAssignmentTypeDirect'
	PersonalDesktopAssignmentType PersonalDesktopAssignmentType `json:"personalDesktopAssignmentType,omitempty"`
	// CustomRdpProperty - Custom rdp property of HostPool.
	CustomRdpProperty *string `json:"customRdpProperty,omitempty"`
	// MaxSessionLimit - The max session limit of HostPool.
	MaxSessionLimit *int32 `json:"maxSessionLimit,omitempty"`
	// LoadBalancerType - The type of the load balancer. Possible values include: 'LoadBalancerTypeBreadthFirst', 'LoadBalancerTypeDepthFirst', 'LoadBalancerTypePersistent'
	LoadBalancerType LoadBalancerType `json:"loadBalancerType,omitempty"`
	// Ring - The ring number of HostPool.
	Ring *int32 `json:"ring,omitempty"`
	// ValidationEnvironment - Is validation environment.
	ValidationEnvironment *bool `json:"validationEnvironment,omitempty"`
	// RegistrationInfo - The registration info of HostPool.
	RegistrationInfo *RegistrationInfo `json:"registrationInfo,omitempty"`
	// VMTemplate - VM template for sessionhosts configuration within hostpool.
	VMTemplate *string `json:"vmTemplate,omitempty"`
	// ApplicationGroupReferences - READ-ONLY; List of applicationGroup links.
	ApplicationGroupReferences *[]string `json:"applicationGroupReferences,omitempty"`
	// SsoadfsAuthority - URL to customer ADFS server for signing WVD SSO certificates.
	SsoadfsAuthority *string `json:"ssoadfsAuthority,omitempty"`
	// SsoClientID - ClientId for the registered Relying Party used to issue WVD SSO certificates.
	SsoClientID *string `json:"ssoClientId,omitempty"`
	// SsoClientSecretKeyVaultPath - Path to Azure KeyVault storing the secret used for communication to ADFS.
	SsoClientSecretKeyVaultPath *string `json:"ssoClientSecretKeyVaultPath,omitempty"`
	// SsoSecretType - The type of single sign on Secret Type. Possible values include: 'SSOSecretTypeSharedKey', 'SSOSecretTypeCertificate', 'SSOSecretTypeSharedKeyInKeyVault', 'SSOSecretTypeCertificateInKeyVault'
	SsoSecretType SSOSecretType `json:"ssoSecretType,omitempty"`
	// PreferredAppGroupType - The type of preferred application group type, default to Desktop Application Group. Possible values include: 'PreferredAppGroupTypeNone', 'PreferredAppGroupTypeDesktop', 'PreferredAppGroupTypeRailApplications'
	PreferredAppGroupType PreferredAppGroupType `json:"preferredAppGroupType,omitempty"`
	// StartVMOnConnect - The flag to turn on/off StartVMOnConnect feature.
	StartVMOnConnect *bool `json:"startVMOnConnect,omitempty"`
	// MigrationRequest - The registration info of HostPool.
	MigrationRequest *MigrationRequestProperties `json:"migrationRequest,omitempty"`
	// CloudPcResource - READ-ONLY; Is cloud pc resource.
	CloudPcResource *bool `json:"cloudPcResource,omitempty"`
	// PublicNetworkAccess - Enabled allows this resource to be accessed from both public and private networks, Disabled allows this resource to only be accessed via private endpoints. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for HostPoolProperties.
func (hpp HostPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hpp.FriendlyName != nil {
		objectMap["friendlyName"] = hpp.FriendlyName
	}
	if hpp.Description != nil {
		objectMap["description"] = hpp.Description
	}
	if hpp.HostPoolType != "" {
		objectMap["hostPoolType"] = hpp.HostPoolType
	}
	if hpp.PersonalDesktopAssignmentType != "" {
		objectMap["personalDesktopAssignmentType"] = hpp.PersonalDesktopAssignmentType
	}
	if hpp.CustomRdpProperty != nil {
		objectMap["customRdpProperty"] = hpp.CustomRdpProperty
	}
	if hpp.MaxSessionLimit != nil {
		objectMap["maxSessionLimit"] = hpp.MaxSessionLimit
	}
	if hpp.LoadBalancerType != "" {
		objectMap["loadBalancerType"] = hpp.LoadBalancerType
	}
	if hpp.Ring != nil {
		objectMap["ring"] = hpp.Ring
	}
	if hpp.ValidationEnvironment != nil {
		objectMap["validationEnvironment"] = hpp.ValidationEnvironment
	}
	if hpp.RegistrationInfo != nil {
		objectMap["registrationInfo"] = hpp.RegistrationInfo
	}
	if hpp.VMTemplate != nil {
		objectMap["vmTemplate"] = hpp.VMTemplate
	}
	if hpp.SsoadfsAuthority != nil {
		objectMap["ssoadfsAuthority"] = hpp.SsoadfsAuthority
	}
	if hpp.SsoClientID != nil {
		objectMap["ssoClientId"] = hpp.SsoClientID
	}
	if hpp.SsoClientSecretKeyVaultPath != nil {
		objectMap["ssoClientSecretKeyVaultPath"] = hpp.SsoClientSecretKeyVaultPath
	}
	if hpp.SsoSecretType != "" {
		objectMap["ssoSecretType"] = hpp.SsoSecretType
	}
	if hpp.PreferredAppGroupType != "" {
		objectMap["preferredAppGroupType"] = hpp.PreferredAppGroupType
	}
	if hpp.StartVMOnConnect != nil {
		objectMap["startVMOnConnect"] = hpp.StartVMOnConnect
	}
	if hpp.MigrationRequest != nil {
		objectMap["migrationRequest"] = hpp.MigrationRequest
	}
	if hpp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = hpp.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// LogSpecification specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Name - Name of the log
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// MigrationRequestProperties properties for arm migration.
type MigrationRequestProperties struct {
	// Operation - The type of operation for migration. Possible values include: 'OperationStart', 'OperationRevoke', 'OperationComplete', 'OperationHide', 'OperationUnhide'
	Operation Operation `json:"operation,omitempty"`
	// MigrationPath - The path to the legacy object to migrate.
	MigrationPath *string `json:"migrationPath,omitempty"`
}

// MSIXImageURI represents URI referring to MSIX Image
type MSIXImageURI struct {
	// URI - URI to Image
	URI *string `json:"uri,omitempty"`
}

// MSIXPackage schema for MSIX Package properties.
type MSIXPackage struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// MSIXPackageProperties - Detailed properties for MSIX Package
	*MSIXPackageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MSIXPackage.
func (mp MSIXPackage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.SystemData != nil {
		objectMap["systemData"] = mp.SystemData
	}
	if mp.MSIXPackageProperties != nil {
		objectMap["properties"] = mp.MSIXPackageProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MSIXPackage struct.
func (mp *MSIXPackage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mp.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var mSIXPackageProperties MSIXPackageProperties
				err = json.Unmarshal(*v, &mSIXPackageProperties)
				if err != nil {
					return err
				}
				mp.MSIXPackageProperties = &mSIXPackageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mp.Type = &typeVar
			}
		}
	}

	return nil
}

// MsixPackageApplications schema for MSIX Package Application properties.
type MsixPackageApplications struct {
	// AppID - Package Application Id, found in appxmanifest.xml.
	AppID *string `json:"appId,omitempty"`
	// Description - Description of Package Application.
	Description *string `json:"description,omitempty"`
	// AppUserModelID - Used to activate Package Application. Consists of Package Name and ApplicationID. Found in appxmanifest.xml.
	AppUserModelID *string `json:"appUserModelID,omitempty"`
	// FriendlyName - User friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// IconImageName - User friendly name.
	IconImageName *string `json:"iconImageName,omitempty"`
	// RawIcon - the icon a 64 bit string as a byte array.
	RawIcon *[]byte `json:"rawIcon,omitempty"`
	// RawPng - the icon a 64 bit string as a byte array.
	RawPng *[]byte `json:"rawPng,omitempty"`
}

// MsixPackageDependencies schema for MSIX Package Dependencies properties.
type MsixPackageDependencies struct {
	// DependencyName - Name of package dependency.
	DependencyName *string `json:"dependencyName,omitempty"`
	// Publisher - Name of dependency publisher.
	Publisher *string `json:"publisher,omitempty"`
	// MinVersion - Dependency version required.
	MinVersion *string `json:"minVersion,omitempty"`
}

// MSIXPackageList list of MSIX Package definitions.
type MSIXPackageList struct {
	autorest.Response `json:"-"`
	// Value - List of MSIX Package definitions.
	Value *[]MSIXPackage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for MSIXPackageList.
func (mpl MSIXPackageList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpl.Value != nil {
		objectMap["value"] = mpl.Value
	}
	return json.Marshal(objectMap)
}

// MSIXPackageListIterator provides access to a complete listing of MSIXPackage values.
type MSIXPackageListIterator struct {
	i    int
	page MSIXPackageListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MSIXPackageListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MSIXPackageListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MSIXPackageListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MSIXPackageListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MSIXPackageListIterator) Response() MSIXPackageList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MSIXPackageListIterator) Value() MSIXPackage {
	if !iter.page.NotDone() {
		return MSIXPackage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MSIXPackageListIterator type.
func NewMSIXPackageListIterator(page MSIXPackageListPage) MSIXPackageListIterator {
	return MSIXPackageListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mpl MSIXPackageList) IsEmpty() bool {
	return mpl.Value == nil || len(*mpl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mpl MSIXPackageList) hasNextLink() bool {
	return mpl.NextLink != nil && len(*mpl.NextLink) != 0
}

// mSIXPackageListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mpl MSIXPackageList) mSIXPackageListPreparer(ctx context.Context) (*http.Request, error) {
	if !mpl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mpl.NextLink)))
}

// MSIXPackageListPage contains a page of MSIXPackage values.
type MSIXPackageListPage struct {
	fn  func(context.Context, MSIXPackageList) (MSIXPackageList, error)
	mpl MSIXPackageList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MSIXPackageListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MSIXPackageListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mpl)
		if err != nil {
			return err
		}
		page.mpl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MSIXPackageListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MSIXPackageListPage) NotDone() bool {
	return !page.mpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MSIXPackageListPage) Response() MSIXPackageList {
	return page.mpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MSIXPackageListPage) Values() []MSIXPackage {
	if page.mpl.IsEmpty() {
		return nil
	}
	return *page.mpl.Value
}

// Creates a new instance of the MSIXPackageListPage type.
func NewMSIXPackageListPage(cur MSIXPackageList, getNextPage func(context.Context, MSIXPackageList) (MSIXPackageList, error)) MSIXPackageListPage {
	return MSIXPackageListPage{
		fn:  getNextPage,
		mpl: cur,
	}
}

// MSIXPackagePatch MSIX Package properties that can be patched.
type MSIXPackagePatch struct {
	// MSIXPackagePatchProperties - Detailed properties for MSIX Package
	*MSIXPackagePatchProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MSIXPackagePatch.
func (mpp MSIXPackagePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpp.MSIXPackagePatchProperties != nil {
		objectMap["properties"] = mpp.MSIXPackagePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MSIXPackagePatch struct.
func (mpp *MSIXPackagePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mSIXPackagePatchProperties MSIXPackagePatchProperties
				err = json.Unmarshal(*v, &mSIXPackagePatchProperties)
				if err != nil {
					return err
				}
				mpp.MSIXPackagePatchProperties = &mSIXPackagePatchProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mpp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mpp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mpp.Type = &typeVar
			}
		}
	}

	return nil
}

// MSIXPackagePatchProperties MSIX Package properties that can be patched.
type MSIXPackagePatchProperties struct {
	// IsActive - Set a version of the package to be active across hostpool.
	IsActive *bool `json:"isActive,omitempty"`
	// IsRegularRegistration - Set Registration mode. Regular or Delayed.
	IsRegularRegistration *bool `json:"isRegularRegistration,omitempty"`
	// DisplayName - Display name for MSIX Package.
	DisplayName *string `json:"displayName,omitempty"`
}

// MSIXPackageProperties schema for MSIX Package properties.
type MSIXPackageProperties struct {
	// ImagePath - VHD/CIM image path on Network Share.
	ImagePath *string `json:"imagePath,omitempty"`
	// PackageName - Package Name from appxmanifest.xml.
	PackageName *string `json:"packageName,omitempty"`
	// PackageFamilyName - Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
	PackageFamilyName *string `json:"packageFamilyName,omitempty"`
	// DisplayName - User friendly Name to be displayed in the portal.
	DisplayName *string `json:"displayName,omitempty"`
	// PackageRelativePath - Relative Path to the package inside the image.
	PackageRelativePath *string `json:"packageRelativePath,omitempty"`
	// IsRegularRegistration - Specifies how to register Package in feed.
	IsRegularRegistration *bool `json:"isRegularRegistration,omitempty"`
	// IsActive - Make this version of the package the active one across the hostpool.
	IsActive *bool `json:"isActive,omitempty"`
	// PackageDependencies - List of package dependencies.
	PackageDependencies *[]MsixPackageDependencies `json:"packageDependencies,omitempty"`
	// Version - Package Version found in the appxmanifest.xml.
	Version *string `json:"version,omitempty"`
	// LastUpdated - Date Package was last updated, found in the appxmanifest.xml.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// PackageApplications - List of package applications.
	PackageApplications *[]MsixPackageApplications `json:"packageApplications,omitempty"`
}

// OperationProperties properties of the operation
type OperationProperties struct {
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// Plan plan for the resource.
type Plan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResultWithSystemData list of private endpoint connection associated with
// the specified storage account
type PrivateEndpointConnectionListResultWithSystemData struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnectionWithSystemData `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionListResultWithSystemData.
func (peclrwsd PrivateEndpointConnectionListResultWithSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if peclrwsd.Value != nil {
		objectMap["value"] = peclrwsd.Value
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionListResultWithSystemDataIterator provides access to a complete listing of
// PrivateEndpointConnectionWithSystemData values.
type PrivateEndpointConnectionListResultWithSystemDataIterator struct {
	i    int
	page PrivateEndpointConnectionListResultWithSystemDataPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultWithSystemDataIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultWithSystemDataIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultWithSystemDataIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultWithSystemDataIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultWithSystemDataIterator) Response() PrivateEndpointConnectionListResultWithSystemData {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultWithSystemDataIterator) Value() PrivateEndpointConnectionWithSystemData {
	if !iter.page.NotDone() {
		return PrivateEndpointConnectionWithSystemData{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultWithSystemDataIterator type.
func NewPrivateEndpointConnectionListResultWithSystemDataIterator(page PrivateEndpointConnectionListResultWithSystemDataPage) PrivateEndpointConnectionListResultWithSystemDataIterator {
	return PrivateEndpointConnectionListResultWithSystemDataIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclrwsd PrivateEndpointConnectionListResultWithSystemData) IsEmpty() bool {
	return peclrwsd.Value == nil || len(*peclrwsd.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (peclrwsd PrivateEndpointConnectionListResultWithSystemData) hasNextLink() bool {
	return peclrwsd.NextLink != nil && len(*peclrwsd.NextLink) != 0
}

// privateEndpointConnectionListResultWithSystemDataPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclrwsd PrivateEndpointConnectionListResultWithSystemData) privateEndpointConnectionListResultWithSystemDataPreparer(ctx context.Context) (*http.Request, error) {
	if !peclrwsd.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclrwsd.NextLink)))
}

// PrivateEndpointConnectionListResultWithSystemDataPage contains a page of
// PrivateEndpointConnectionWithSystemData values.
type PrivateEndpointConnectionListResultWithSystemDataPage struct {
	fn       func(context.Context, PrivateEndpointConnectionListResultWithSystemData) (PrivateEndpointConnectionListResultWithSystemData, error)
	peclrwsd PrivateEndpointConnectionListResultWithSystemData
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultWithSystemDataPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultWithSystemDataPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.peclrwsd)
		if err != nil {
			return err
		}
		page.peclrwsd = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultWithSystemDataPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultWithSystemDataPage) NotDone() bool {
	return !page.peclrwsd.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultWithSystemDataPage) Response() PrivateEndpointConnectionListResultWithSystemData {
	return page.peclrwsd
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultWithSystemDataPage) Values() []PrivateEndpointConnectionWithSystemData {
	if page.peclrwsd.IsEmpty() {
		return nil
	}
	return *page.peclrwsd.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultWithSystemDataPage type.
func NewPrivateEndpointConnectionListResultWithSystemDataPage(cur PrivateEndpointConnectionListResultWithSystemData, getNextPage func(context.Context, PrivateEndpointConnectionListResultWithSystemData) (PrivateEndpointConnectionListResultWithSystemData, error)) PrivateEndpointConnectionListResultWithSystemDataPage {
	return PrivateEndpointConnectionListResultWithSystemDataPage{
		fn:       getNextPage,
		peclrwsd: cur,
	}
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionWithSystemData the Private Endpoint Connection resource.
type PrivateEndpointConnectionWithSystemData struct {
	autorest.Response `json:"-"`
	SystemData        *SystemData `json:"systemData,omitempty"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionWithSystemData.
func (pecwsd PrivateEndpointConnectionWithSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecwsd.SystemData != nil {
		objectMap["systemData"] = pecwsd.SystemData
	}
	if pecwsd.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pecwsd.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnectionWithSystemData struct.
func (pecwsd *PrivateEndpointConnectionWithSystemData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pecwsd.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pecwsd.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pecwsd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pecwsd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pecwsd.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceListResult.
func (plrlr PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrlr.Value != nil {
		objectMap["value"] = plrlr.Value
	}
	return json.Marshal(objectMap)
}

// PrivateLinkResourceListResultIterator provides access to a complete listing of PrivateLinkResource
// values.
type PrivateLinkResourceListResultIterator struct {
	i    int
	page PrivateLinkResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListResultIterator) Response() PrivateLinkResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListResultIterator type.
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return PrivateLinkResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrlr PrivateLinkResourceListResult) IsEmpty() bool {
	return plrlr.Value == nil || len(*plrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrlr PrivateLinkResourceListResult) hasNextLink() bool {
	return plrlr.NextLink != nil && len(*plrlr.NextLink) != 0
}

// privateLinkResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrlr PrivateLinkResourceListResult) privateLinkResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrlr.NextLink)))
}

// PrivateLinkResourceListResultPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListResultPage struct {
	fn    func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)
	plrlr PrivateLinkResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrlr)
		if err != nil {
			return err
		}
		page.plrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListResultPage) NotDone() bool {
	return !page.plrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListResultPage) Response() PrivateLinkResourceListResult {
	return page.plrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListResultPage) Values() []PrivateLinkResource {
	if page.plrlr.IsEmpty() {
		return nil
	}
	return *page.plrlr.Value
}

// Creates a new instance of the PrivateLinkResourceListResultPage type.
func NewPrivateLinkResourceListResultPage(cur PrivateLinkResourceListResult, getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return PrivateLinkResourceListResultPage{
		fn:    getNextPage,
		plrlr: cur,
	}
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RegistrationInfo represents a RegistrationInfo definition.
type RegistrationInfo struct {
	autorest.Response `json:"-"`
	// ExpirationTime - Expiration time of registration token.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// Token - The registration token base64 encoded string.
	Token *string `json:"token,omitempty"`
	// RegistrationTokenOperation - The type of resetting the token. Possible values include: 'RegistrationTokenOperationDelete', 'RegistrationTokenOperationNone', 'RegistrationTokenOperationUpdate'
	RegistrationTokenOperation RegistrationTokenOperation `json:"registrationTokenOperation,omitempty"`
}

// RegistrationInfoPatch represents a RegistrationInfo definition.
type RegistrationInfoPatch struct {
	// ExpirationTime - Expiration time of registration token.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// RegistrationTokenOperation - The type of resetting the token. Possible values include: 'RegistrationTokenOperationDelete', 'RegistrationTokenOperationNone', 'RegistrationTokenOperationUpdate'
	RegistrationTokenOperation RegistrationTokenOperation `json:"registrationTokenOperation,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySet the resource model definition containing the full set of allowed
// properties for a resource. Except properties bag, there cannot be a top level property outside of this
// set.
type ResourceModelWithAllowedPropertySet struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ManagedBy - The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Kind - Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
	Kind *string `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags     map[string]*string                           `json:"tags"`
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`
	Sku      *ResourceModelWithAllowedPropertySetSku      `json:"sku,omitempty"`
	Plan     *ResourceModelWithAllowedPropertySetPlan     `json:"plan,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySet.
func (rmwaps ResourceModelWithAllowedPropertySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Location != nil {
		objectMap["location"] = rmwaps.Location
	}
	if rmwaps.ManagedBy != nil {
		objectMap["managedBy"] = rmwaps.ManagedBy
	}
	if rmwaps.Kind != nil {
		objectMap["kind"] = rmwaps.Kind
	}
	if rmwaps.Tags != nil {
		objectMap["tags"] = rmwaps.Tags
	}
	if rmwaps.Identity != nil {
		objectMap["identity"] = rmwaps.Identity
	}
	if rmwaps.Sku != nil {
		objectMap["sku"] = rmwaps.Sku
	}
	if rmwaps.Plan != nil {
		objectMap["plan"] = rmwaps.Plan
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetIdentity ...
type ResourceModelWithAllowedPropertySetIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySetIdentity.
func (rmwaps ResourceModelWithAllowedPropertySetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Type != "" {
		objectMap["type"] = rmwaps.Type
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetPlan ...
type ResourceModelWithAllowedPropertySetPlan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// ResourceModelWithAllowedPropertySetSku ...
type ResourceModelWithAllowedPropertySetSku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ResourceProviderOperation supported operation of this resource provider.
type ResourceProviderOperation struct {
	// Name - Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`
	// IsDataAction - Is a data action.
	IsDataAction *bool                `json:"isDataAction,omitempty"`
	Properties   *OperationProperties `json:"properties,omitempty"`
}

// ResourceProviderOperationDisplay display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Provider - Resource provider: Microsoft Desktop Virtualization.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of this operation.
	Description *string `json:"description,omitempty"`
}

// ResourceProviderOperationList result of the request to list operations.
type ResourceProviderOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by this resource provider.
	Value *[]ResourceProviderOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceProviderOperationList.
func (rpol ResourceProviderOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpol.Value != nil {
		objectMap["value"] = rpol.Value
	}
	return json.Marshal(objectMap)
}

// ResourceProviderOperationListIterator provides access to a complete listing of ResourceProviderOperation
// values.
type ResourceProviderOperationListIterator struct {
	i    int
	page ResourceProviderOperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceProviderOperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceProviderOperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceProviderOperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceProviderOperationListIterator) Response() ResourceProviderOperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceProviderOperationListIterator) Value() ResourceProviderOperation {
	if !iter.page.NotDone() {
		return ResourceProviderOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceProviderOperationListIterator type.
func NewResourceProviderOperationListIterator(page ResourceProviderOperationListPage) ResourceProviderOperationListIterator {
	return ResourceProviderOperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rpol ResourceProviderOperationList) IsEmpty() bool {
	return rpol.Value == nil || len(*rpol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rpol ResourceProviderOperationList) hasNextLink() bool {
	return rpol.NextLink != nil && len(*rpol.NextLink) != 0
}

// resourceProviderOperationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rpol ResourceProviderOperationList) resourceProviderOperationListPreparer(ctx context.Context) (*http.Request, error) {
	if !rpol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rpol.NextLink)))
}

// ResourceProviderOperationListPage contains a page of ResourceProviderOperation values.
type ResourceProviderOperationListPage struct {
	fn   func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)
	rpol ResourceProviderOperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceProviderOperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rpol)
		if err != nil {
			return err
		}
		page.rpol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceProviderOperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceProviderOperationListPage) NotDone() bool {
	return !page.rpol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceProviderOperationListPage) Response() ResourceProviderOperationList {
	return page.rpol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceProviderOperationListPage) Values() []ResourceProviderOperation {
	if page.rpol.IsEmpty() {
		return nil
	}
	return *page.rpol.Value
}

// Creates a new instance of the ResourceProviderOperationListPage type.
func NewResourceProviderOperationListPage(cur ResourceProviderOperationList, getNextPage func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)) ResourceProviderOperationListPage {
	return ResourceProviderOperationListPage{
		fn:   getNextPage,
		rpol: cur,
	}
}

// ScalingHostPoolReference scaling plan reference to hostpool.
type ScalingHostPoolReference struct {
	// HostPoolArmPath - Arm path of referenced hostpool.
	HostPoolArmPath *string `json:"hostPoolArmPath,omitempty"`
	// ScalingPlanEnabled - Is the scaling plan enabled for this hostpool.
	ScalingPlanEnabled *bool `json:"scalingPlanEnabled,omitempty"`
}

// ScalingPlan represents a scaling plan definition.
type ScalingPlan struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ScalingPlanProperties - Detailed properties for scaling plan.
	*ScalingPlanProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ManagedBy - The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Kind - Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
	Kind *string `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags     map[string]*string                           `json:"tags"`
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`
	Sku      *ResourceModelWithAllowedPropertySetSku      `json:"sku,omitempty"`
	Plan     *ResourceModelWithAllowedPropertySetPlan     `json:"plan,omitempty"`
}

// MarshalJSON is the custom marshaler for ScalingPlan.
func (sp ScalingPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.SystemData != nil {
		objectMap["systemData"] = sp.SystemData
	}
	if sp.ScalingPlanProperties != nil {
		objectMap["properties"] = sp.ScalingPlanProperties
	}
	if sp.Location != nil {
		objectMap["location"] = sp.Location
	}
	if sp.ManagedBy != nil {
		objectMap["managedBy"] = sp.ManagedBy
	}
	if sp.Kind != nil {
		objectMap["kind"] = sp.Kind
	}
	if sp.Tags != nil {
		objectMap["tags"] = sp.Tags
	}
	if sp.Identity != nil {
		objectMap["identity"] = sp.Identity
	}
	if sp.Sku != nil {
		objectMap["sku"] = sp.Sku
	}
	if sp.Plan != nil {
		objectMap["plan"] = sp.Plan
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScalingPlan struct.
func (sp *ScalingPlan) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sp.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var scalingPlanProperties ScalingPlanProperties
				err = json.Unmarshal(*v, &scalingPlanProperties)
				if err != nil {
					return err
				}
				sp.ScalingPlanProperties = &scalingPlanProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sp.Location = &location
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				sp.ManagedBy = &managedBy
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sp.Kind = &kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sp.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sp.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ResourceModelWithAllowedPropertySetIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sp.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ResourceModelWithAllowedPropertySetSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sp.Sku = &sku
			}
		case "plan":
			if v != nil {
				var plan ResourceModelWithAllowedPropertySetPlan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				sp.Plan = &plan
			}
		}
	}

	return nil
}

// ScalingPlanList list of scaling plan definitions.
type ScalingPlanList struct {
	autorest.Response `json:"-"`
	// Value - List of scaling plan definitions.
	Value *[]ScalingPlan `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ScalingPlanList.
func (spl ScalingPlanList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spl.Value != nil {
		objectMap["value"] = spl.Value
	}
	return json.Marshal(objectMap)
}

// ScalingPlanListIterator provides access to a complete listing of ScalingPlan values.
type ScalingPlanListIterator struct {
	i    int
	page ScalingPlanListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScalingPlanListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScalingPlanListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScalingPlanListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScalingPlanListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScalingPlanListIterator) Response() ScalingPlanList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScalingPlanListIterator) Value() ScalingPlan {
	if !iter.page.NotDone() {
		return ScalingPlan{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScalingPlanListIterator type.
func NewScalingPlanListIterator(page ScalingPlanListPage) ScalingPlanListIterator {
	return ScalingPlanListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spl ScalingPlanList) IsEmpty() bool {
	return spl.Value == nil || len(*spl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spl ScalingPlanList) hasNextLink() bool {
	return spl.NextLink != nil && len(*spl.NextLink) != 0
}

// scalingPlanListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spl ScalingPlanList) scalingPlanListPreparer(ctx context.Context) (*http.Request, error) {
	if !spl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spl.NextLink)))
}

// ScalingPlanListPage contains a page of ScalingPlan values.
type ScalingPlanListPage struct {
	fn  func(context.Context, ScalingPlanList) (ScalingPlanList, error)
	spl ScalingPlanList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScalingPlanListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScalingPlanListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spl)
		if err != nil {
			return err
		}
		page.spl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScalingPlanListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScalingPlanListPage) NotDone() bool {
	return !page.spl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScalingPlanListPage) Response() ScalingPlanList {
	return page.spl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScalingPlanListPage) Values() []ScalingPlan {
	if page.spl.IsEmpty() {
		return nil
	}
	return *page.spl.Value
}

// Creates a new instance of the ScalingPlanListPage type.
func NewScalingPlanListPage(cur ScalingPlanList, getNextPage func(context.Context, ScalingPlanList) (ScalingPlanList, error)) ScalingPlanListPage {
	return ScalingPlanListPage{
		fn:  getNextPage,
		spl: cur,
	}
}

// ScalingPlanPatch scaling plan properties that can be patched.
type ScalingPlanPatch struct {
	// Tags - tags to be updated
	Tags map[string]*string `json:"tags"`
	// ScalingPlanPatchProperties - Detailed properties for scaling plan
	*ScalingPlanPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ScalingPlanPatch.
func (spp ScalingPlanPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spp.Tags != nil {
		objectMap["tags"] = spp.Tags
	}
	if spp.ScalingPlanPatchProperties != nil {
		objectMap["properties"] = spp.ScalingPlanPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScalingPlanPatch struct.
func (spp *ScalingPlanPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				spp.Tags = tags
			}
		case "properties":
			if v != nil {
				var scalingPlanPatchProperties ScalingPlanPatchProperties
				err = json.Unmarshal(*v, &scalingPlanPatchProperties)
				if err != nil {
					return err
				}
				spp.ScalingPlanPatchProperties = &scalingPlanPatchProperties
			}
		}
	}

	return nil
}

// ScalingPlanPatchProperties scaling plan properties.
type ScalingPlanPatchProperties struct {
	// Description - Description of scaling plan.
	Description *string `json:"description,omitempty"`
	// FriendlyName - User friendly name of scaling plan.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// TimeZone - Timezone of the scaling plan.
	TimeZone *string `json:"timeZone,omitempty"`
	// ExclusionTag - Exclusion tag for scaling plan.
	ExclusionTag *string `json:"exclusionTag,omitempty"`
	// Schedules - List of ScalingSchedule definitions.
	Schedules *[]ScalingSchedule `json:"schedules,omitempty"`
	// HostPoolReferences - List of ScalingHostPoolReference definitions.
	HostPoolReferences *[]ScalingHostPoolReference `json:"hostPoolReferences,omitempty"`
}

// ScalingPlanProperties scaling plan properties.
type ScalingPlanProperties struct {
	// ObjectID - READ-ONLY; ObjectId of scaling plan. (internal use)
	ObjectID *string `json:"objectId,omitempty"`
	// Description - Description of scaling plan.
	Description *string `json:"description,omitempty"`
	// FriendlyName - User friendly name of scaling plan.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// TimeZone - Timezone of the scaling plan.
	TimeZone *string `json:"timeZone,omitempty"`
	// HostPoolType - HostPool type for desktop. Possible values include: 'ScalingHostPoolTypePooled'
	HostPoolType ScalingHostPoolType `json:"hostPoolType,omitempty"`
	// ExclusionTag - Exclusion tag for scaling plan.
	ExclusionTag *string `json:"exclusionTag,omitempty"`
	// Schedules - List of ScalingSchedule definitions.
	Schedules *[]ScalingSchedule `json:"schedules,omitempty"`
	// HostPoolReferences - List of ScalingHostPoolReference definitions.
	HostPoolReferences *[]ScalingHostPoolReference `json:"hostPoolReferences,omitempty"`
}

// MarshalJSON is the custom marshaler for ScalingPlanProperties.
func (spp ScalingPlanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spp.Description != nil {
		objectMap["description"] = spp.Description
	}
	if spp.FriendlyName != nil {
		objectMap["friendlyName"] = spp.FriendlyName
	}
	if spp.TimeZone != nil {
		objectMap["timeZone"] = spp.TimeZone
	}
	if spp.HostPoolType != "" {
		objectMap["hostPoolType"] = spp.HostPoolType
	}
	if spp.ExclusionTag != nil {
		objectMap["exclusionTag"] = spp.ExclusionTag
	}
	if spp.Schedules != nil {
		objectMap["schedules"] = spp.Schedules
	}
	if spp.HostPoolReferences != nil {
		objectMap["hostPoolReferences"] = spp.HostPoolReferences
	}
	return json.Marshal(objectMap)
}

// ScalingSchedule scaling plan schedule.
type ScalingSchedule struct {
	// Name - Name of the scaling schedule.
	Name *string `json:"name,omitempty"`
	// DaysOfWeek - Set of days of the week on which this schedule is active.
	DaysOfWeek *[]string `json:"daysOfWeek,omitempty"`
	// RampUpStartTime - Starting time for ramp up period.
	RampUpStartTime *Time `json:"rampUpStartTime,omitempty"`
	// RampUpLoadBalancingAlgorithm - Load balancing algorithm for ramp up period. Possible values include: 'SessionHostLoadBalancingAlgorithmBreadthFirst', 'SessionHostLoadBalancingAlgorithmDepthFirst'
	RampUpLoadBalancingAlgorithm SessionHostLoadBalancingAlgorithm `json:"rampUpLoadBalancingAlgorithm,omitempty"`
	// RampUpMinimumHostsPct - Minimum host percentage for ramp up period.
	RampUpMinimumHostsPct *int32 `json:"rampUpMinimumHostsPct,omitempty"`
	// RampUpCapacityThresholdPct - Capacity threshold for ramp up period.
	RampUpCapacityThresholdPct *int32 `json:"rampUpCapacityThresholdPct,omitempty"`
	// PeakStartTime - Starting time for peak period.
	PeakStartTime *Time `json:"peakStartTime,omitempty"`
	// PeakLoadBalancingAlgorithm - Load balancing algorithm for peak period. Possible values include: 'SessionHostLoadBalancingAlgorithmBreadthFirst', 'SessionHostLoadBalancingAlgorithmDepthFirst'
	PeakLoadBalancingAlgorithm SessionHostLoadBalancingAlgorithm `json:"peakLoadBalancingAlgorithm,omitempty"`
	// RampDownStartTime - Starting time for ramp down period.
	RampDownStartTime *Time `json:"rampDownStartTime,omitempty"`
	// RampDownLoadBalancingAlgorithm - Load balancing algorithm for ramp down period. Possible values include: 'SessionHostLoadBalancingAlgorithmBreadthFirst', 'SessionHostLoadBalancingAlgorithmDepthFirst'
	RampDownLoadBalancingAlgorithm SessionHostLoadBalancingAlgorithm `json:"rampDownLoadBalancingAlgorithm,omitempty"`
	// RampDownMinimumHostsPct - Minimum host percentage for ramp down period.
	RampDownMinimumHostsPct *int32 `json:"rampDownMinimumHostsPct,omitempty"`
	// RampDownCapacityThresholdPct - Capacity threshold for ramp down period.
	RampDownCapacityThresholdPct *int32 `json:"rampDownCapacityThresholdPct,omitempty"`
	// RampDownForceLogoffUsers - Should users be logged off forcefully from hosts.
	RampDownForceLogoffUsers *bool `json:"rampDownForceLogoffUsers,omitempty"`
	// RampDownStopHostsWhen - Specifies when to stop hosts during ramp down period. Possible values include: 'StopHostsWhenZeroSessions', 'StopHostsWhenZeroActiveSessions'
	RampDownStopHostsWhen StopHostsWhen `json:"rampDownStopHostsWhen,omitempty"`
	// RampDownWaitTimeMinutes - Number of minutes to wait to stop hosts during ramp down period.
	RampDownWaitTimeMinutes *int32 `json:"rampDownWaitTimeMinutes,omitempty"`
	// RampDownNotificationMessage - Notification message for users during ramp down period.
	RampDownNotificationMessage *string `json:"rampDownNotificationMessage,omitempty"`
	// OffPeakStartTime - Starting time for off-peak period.
	OffPeakStartTime *Time `json:"offPeakStartTime,omitempty"`
	// OffPeakLoadBalancingAlgorithm - Load balancing algorithm for off-peak period. Possible values include: 'SessionHostLoadBalancingAlgorithmBreadthFirst', 'SessionHostLoadBalancingAlgorithmDepthFirst'
	OffPeakLoadBalancingAlgorithm SessionHostLoadBalancingAlgorithm `json:"offPeakLoadBalancingAlgorithm,omitempty"`
}

// SendMessage represents message sent to a UserSession.
type SendMessage struct {
	// MessageTitle - Title of message.
	MessageTitle *string `json:"messageTitle,omitempty"`
	// MessageBody - Body of message.
	MessageBody *string `json:"messageBody,omitempty"`
}

// ServiceSpecification service specification payload
type ServiceSpecification struct {
	// LogSpecifications - Specifications of the Log for Azure Monitoring
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
}

// SessionHost represents a SessionHost definition.
type SessionHost struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// SessionHostProperties - Detailed properties for SessionHost
	*SessionHostProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionHost.
func (sh SessionHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sh.SystemData != nil {
		objectMap["systemData"] = sh.SystemData
	}
	if sh.SessionHostProperties != nil {
		objectMap["properties"] = sh.SessionHostProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SessionHost struct.
func (sh *SessionHost) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sh.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var sessionHostProperties SessionHostProperties
				err = json.Unmarshal(*v, &sessionHostProperties)
				if err != nil {
					return err
				}
				sh.SessionHostProperties = &sessionHostProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sh.Type = &typeVar
			}
		}
	}

	return nil
}

// SessionHostHealthCheckFailureDetails contains details on the failure.
type SessionHostHealthCheckFailureDetails struct {
	// Message - READ-ONLY; Failure message: hints on what is wrong and how to recover.
	Message *string `json:"message,omitempty"`
	// ErrorCode - READ-ONLY; Error code corresponding for the failure.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// LastHealthCheckDateTime - READ-ONLY; The timestamp of the last update.
	LastHealthCheckDateTime *date.Time `json:"lastHealthCheckDateTime,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionHostHealthCheckFailureDetails.
func (shhcfd SessionHostHealthCheckFailureDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SessionHostHealthCheckReport the report for session host information.
type SessionHostHealthCheckReport struct {
	// HealthCheckName - READ-ONLY; Represents the name of the health check operation performed. Possible values include: 'HealthCheckNameDomainJoinedCheck', 'HealthCheckNameDomainTrustCheck', 'HealthCheckNameFSLogixHealthCheck', 'HealthCheckNameSxSStackListenerCheck', 'HealthCheckNameUrlsAccessibleCheck', 'HealthCheckNameMonitoringAgentCheck', 'HealthCheckNameDomainReachable', 'HealthCheckNameWebRTCRedirectorCheck', 'HealthCheckNameSupportedEncryptionCheck', 'HealthCheckNameMetaDataServiceCheck', 'HealthCheckNameAppAttachHealthCheck'
	HealthCheckName HealthCheckName `json:"healthCheckName,omitempty"`
	// HealthCheckResult - READ-ONLY; Represents the Health state of the health check we performed. Possible values include: 'HealthCheckResultUnknown', 'HealthCheckResultHealthCheckSucceeded', 'HealthCheckResultHealthCheckFailed', 'HealthCheckResultSessionHostShutdown'
	HealthCheckResult HealthCheckResult `json:"healthCheckResult,omitempty"`
	// AdditionalFailureDetails - READ-ONLY; Additional detailed information on the failure.
	AdditionalFailureDetails *SessionHostHealthCheckFailureDetails `json:"additionalFailureDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionHostHealthCheckReport.
func (shhcr SessionHostHealthCheckReport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SessionHostList list of SessionHost definitions.
type SessionHostList struct {
	autorest.Response `json:"-"`
	// Value - List of SessionHost definitions.
	Value *[]SessionHost `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionHostList.
func (shl SessionHostList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if shl.Value != nil {
		objectMap["value"] = shl.Value
	}
	return json.Marshal(objectMap)
}

// SessionHostListIterator provides access to a complete listing of SessionHost values.
type SessionHostListIterator struct {
	i    int
	page SessionHostListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SessionHostListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SessionHostListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SessionHostListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SessionHostListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SessionHostListIterator) Response() SessionHostList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SessionHostListIterator) Value() SessionHost {
	if !iter.page.NotDone() {
		return SessionHost{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SessionHostListIterator type.
func NewSessionHostListIterator(page SessionHostListPage) SessionHostListIterator {
	return SessionHostListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (shl SessionHostList) IsEmpty() bool {
	return shl.Value == nil || len(*shl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (shl SessionHostList) hasNextLink() bool {
	return shl.NextLink != nil && len(*shl.NextLink) != 0
}

// sessionHostListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (shl SessionHostList) sessionHostListPreparer(ctx context.Context) (*http.Request, error) {
	if !shl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(shl.NextLink)))
}

// SessionHostListPage contains a page of SessionHost values.
type SessionHostListPage struct {
	fn  func(context.Context, SessionHostList) (SessionHostList, error)
	shl SessionHostList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SessionHostListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SessionHostListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.shl)
		if err != nil {
			return err
		}
		page.shl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SessionHostListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SessionHostListPage) NotDone() bool {
	return !page.shl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SessionHostListPage) Response() SessionHostList {
	return page.shl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SessionHostListPage) Values() []SessionHost {
	if page.shl.IsEmpty() {
		return nil
	}
	return *page.shl.Value
}

// Creates a new instance of the SessionHostListPage type.
func NewSessionHostListPage(cur SessionHostList, getNextPage func(context.Context, SessionHostList) (SessionHostList, error)) SessionHostListPage {
	return SessionHostListPage{
		fn:  getNextPage,
		shl: cur,
	}
}

// SessionHostPatch sessionHost properties that can be patched.
type SessionHostPatch struct {
	// SessionHostPatchProperties - Detailed properties for SessionHost
	*SessionHostPatchProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionHostPatch.
func (shp SessionHostPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if shp.SessionHostPatchProperties != nil {
		objectMap["properties"] = shp.SessionHostPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SessionHostPatch struct.
func (shp *SessionHostPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sessionHostPatchProperties SessionHostPatchProperties
				err = json.Unmarshal(*v, &sessionHostPatchProperties)
				if err != nil {
					return err
				}
				shp.SessionHostPatchProperties = &sessionHostPatchProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				shp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				shp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				shp.Type = &typeVar
			}
		}
	}

	return nil
}

// SessionHostPatchProperties sessionHost properties that can be patched.
type SessionHostPatchProperties struct {
	// AllowNewSession - Allow a new session.
	AllowNewSession *bool `json:"allowNewSession,omitempty"`
	// AssignedUser - User assigned to SessionHost.
	AssignedUser *string `json:"assignedUser,omitempty"`
}

// SessionHostProperties schema for SessionHost properties.
type SessionHostProperties struct {
	// ObjectID - READ-ONLY; ObjectId of SessionHost. (internal use)
	ObjectID *string `json:"objectId,omitempty"`
	// LastHeartBeat - Last heart beat from SessionHost.
	LastHeartBeat *date.Time `json:"lastHeartBeat,omitempty"`
	// Sessions - Number of sessions on SessionHost.
	Sessions *int32 `json:"sessions,omitempty"`
	// AgentVersion - Version of agent on SessionHost.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// AllowNewSession - Allow a new session.
	AllowNewSession *bool `json:"allowNewSession,omitempty"`
	// VirtualMachineID - READ-ONLY; Virtual Machine Id of SessionHost's underlying virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// ResourceID - READ-ONLY; Resource Id of SessionHost's underlying virtual machine.
	ResourceID *string `json:"resourceId,omitempty"`
	// AssignedUser - User assigned to SessionHost.
	AssignedUser *string `json:"assignedUser,omitempty"`
	// Status - Status for a SessionHost. Possible values include: 'StatusAvailable', 'StatusUnavailable', 'StatusShutdown', 'StatusDisconnected', 'StatusUpgrading', 'StatusUpgradeFailed', 'StatusNoHeartbeat', 'StatusNotJoinedToDomain', 'StatusDomainTrustRelationshipLost', 'StatusSxSStackListenerNotReady', 'StatusFSLogixNotHealthy', 'StatusNeedsAssistance'
	Status Status `json:"status,omitempty"`
	// StatusTimestamp - READ-ONLY; The timestamp of the status.
	StatusTimestamp *date.Time `json:"statusTimestamp,omitempty"`
	// OsVersion - The version of the OS on the session host.
	OsVersion *string `json:"osVersion,omitempty"`
	// SxSStackVersion - The version of the side by side stack on the session host.
	SxSStackVersion *string `json:"sxSStackVersion,omitempty"`
	// UpdateState - Update state of a SessionHost. Possible values include: 'UpdateStateInitial', 'UpdateStatePending', 'UpdateStateStarted', 'UpdateStateSucceeded', 'UpdateStateFailed'
	UpdateState UpdateState `json:"updateState,omitempty"`
	// LastUpdateTime - READ-ONLY; The timestamp of the last update.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	// UpdateErrorMessage - The error message.
	UpdateErrorMessage *string `json:"updateErrorMessage,omitempty"`
	// SessionHostHealthCheckResults - READ-ONLY; List of SessionHostHealthCheckReports
	SessionHostHealthCheckResults *[]SessionHostHealthCheckReport `json:"sessionHostHealthCheckResults,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionHostProperties.
func (shp SessionHostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if shp.LastHeartBeat != nil {
		objectMap["lastHeartBeat"] = shp.LastHeartBeat
	}
	if shp.Sessions != nil {
		objectMap["sessions"] = shp.Sessions
	}
	if shp.AgentVersion != nil {
		objectMap["agentVersion"] = shp.AgentVersion
	}
	if shp.AllowNewSession != nil {
		objectMap["allowNewSession"] = shp.AllowNewSession
	}
	if shp.AssignedUser != nil {
		objectMap["assignedUser"] = shp.AssignedUser
	}
	if shp.Status != "" {
		objectMap["status"] = shp.Status
	}
	if shp.OsVersion != nil {
		objectMap["osVersion"] = shp.OsVersion
	}
	if shp.SxSStackVersion != nil {
		objectMap["sxSStackVersion"] = shp.SxSStackVersion
	}
	if shp.UpdateState != "" {
		objectMap["updateState"] = shp.UpdateState
	}
	if shp.UpdateErrorMessage != nil {
		objectMap["updateErrorMessage"] = shp.UpdateErrorMessage
	}
	return json.Marshal(objectMap)
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// StartMenuItem represents a StartMenuItem definition.
type StartMenuItem struct {
	// StartMenuItemProperties - Detailed properties for StartMenuItem
	*StartMenuItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StartMenuItem.
func (smi StartMenuItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smi.StartMenuItemProperties != nil {
		objectMap["properties"] = smi.StartMenuItemProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StartMenuItem struct.
func (smi *StartMenuItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var startMenuItemProperties StartMenuItemProperties
				err = json.Unmarshal(*v, &startMenuItemProperties)
				if err != nil {
					return err
				}
				smi.StartMenuItemProperties = &startMenuItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				smi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				smi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				smi.Type = &typeVar
			}
		}
	}

	return nil
}

// StartMenuItemList list of StartMenuItem definitions.
type StartMenuItemList struct {
	autorest.Response `json:"-"`
	// Value - List of StartMenuItem definitions.
	Value *[]StartMenuItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for StartMenuItemList.
func (smil StartMenuItemList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smil.Value != nil {
		objectMap["value"] = smil.Value
	}
	return json.Marshal(objectMap)
}

// StartMenuItemListIterator provides access to a complete listing of StartMenuItem values.
type StartMenuItemListIterator struct {
	i    int
	page StartMenuItemListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StartMenuItemListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StartMenuItemListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StartMenuItemListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StartMenuItemListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StartMenuItemListIterator) Response() StartMenuItemList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StartMenuItemListIterator) Value() StartMenuItem {
	if !iter.page.NotDone() {
		return StartMenuItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StartMenuItemListIterator type.
func NewStartMenuItemListIterator(page StartMenuItemListPage) StartMenuItemListIterator {
	return StartMenuItemListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (smil StartMenuItemList) IsEmpty() bool {
	return smil.Value == nil || len(*smil.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (smil StartMenuItemList) hasNextLink() bool {
	return smil.NextLink != nil && len(*smil.NextLink) != 0
}

// startMenuItemListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (smil StartMenuItemList) startMenuItemListPreparer(ctx context.Context) (*http.Request, error) {
	if !smil.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(smil.NextLink)))
}

// StartMenuItemListPage contains a page of StartMenuItem values.
type StartMenuItemListPage struct {
	fn   func(context.Context, StartMenuItemList) (StartMenuItemList, error)
	smil StartMenuItemList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StartMenuItemListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StartMenuItemListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.smil)
		if err != nil {
			return err
		}
		page.smil = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StartMenuItemListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StartMenuItemListPage) NotDone() bool {
	return !page.smil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StartMenuItemListPage) Response() StartMenuItemList {
	return page.smil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StartMenuItemListPage) Values() []StartMenuItem {
	if page.smil.IsEmpty() {
		return nil
	}
	return *page.smil.Value
}

// Creates a new instance of the StartMenuItemListPage type.
func NewStartMenuItemListPage(cur StartMenuItemList, getNextPage func(context.Context, StartMenuItemList) (StartMenuItemList, error)) StartMenuItemListPage {
	return StartMenuItemListPage{
		fn:   getNextPage,
		smil: cur,
	}
}

// StartMenuItemProperties schema for StartMenuItem properties.
type StartMenuItemProperties struct {
	// AppAlias - Alias of StartMenuItem.
	AppAlias *string `json:"appAlias,omitempty"`
	// FilePath - Path to the file of StartMenuItem.
	FilePath *string `json:"filePath,omitempty"`
	// CommandLineArguments - Command line arguments for StartMenuItem.
	CommandLineArguments *string `json:"commandLineArguments,omitempty"`
	// IconPath - Path to the icon.
	IconPath *string `json:"iconPath,omitempty"`
	// IconIndex - Index of the icon.
	IconIndex *int32 `json:"iconIndex,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// Time the time for a scaling action to occur.
type Time struct {
	// Hour - The hour.
	Hour *int32 `json:"hour,omitempty"`
	// Minute - The minute.
	Minute *int32 `json:"minute,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UserSession represents a UserSession definition.
type UserSession struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// UserSessionProperties - Detailed properties for UserSession
	*UserSessionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for UserSession.
func (us UserSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if us.SystemData != nil {
		objectMap["systemData"] = us.SystemData
	}
	if us.UserSessionProperties != nil {
		objectMap["properties"] = us.UserSessionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserSession struct.
func (us *UserSession) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				us.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var userSessionProperties UserSessionProperties
				err = json.Unmarshal(*v, &userSessionProperties)
				if err != nil {
					return err
				}
				us.UserSessionProperties = &userSessionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				us.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				us.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				us.Type = &typeVar
			}
		}
	}

	return nil
}

// UserSessionList list of UserSession definitions.
type UserSessionList struct {
	autorest.Response `json:"-"`
	// Value - List of UserSession definitions.
	Value *[]UserSession `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for UserSessionList.
func (usl UserSessionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usl.Value != nil {
		objectMap["value"] = usl.Value
	}
	return json.Marshal(objectMap)
}

// UserSessionListIterator provides access to a complete listing of UserSession values.
type UserSessionListIterator struct {
	i    int
	page UserSessionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserSessionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserSessionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserSessionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserSessionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserSessionListIterator) Response() UserSessionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserSessionListIterator) Value() UserSession {
	if !iter.page.NotDone() {
		return UserSession{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserSessionListIterator type.
func NewUserSessionListIterator(page UserSessionListPage) UserSessionListIterator {
	return UserSessionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usl UserSessionList) IsEmpty() bool {
	return usl.Value == nil || len(*usl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (usl UserSessionList) hasNextLink() bool {
	return usl.NextLink != nil && len(*usl.NextLink) != 0
}

// userSessionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usl UserSessionList) userSessionListPreparer(ctx context.Context) (*http.Request, error) {
	if !usl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usl.NextLink)))
}

// UserSessionListPage contains a page of UserSession values.
type UserSessionListPage struct {
	fn  func(context.Context, UserSessionList) (UserSessionList, error)
	usl UserSessionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserSessionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserSessionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.usl)
		if err != nil {
			return err
		}
		page.usl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserSessionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserSessionListPage) NotDone() bool {
	return !page.usl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserSessionListPage) Response() UserSessionList {
	return page.usl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserSessionListPage) Values() []UserSession {
	if page.usl.IsEmpty() {
		return nil
	}
	return *page.usl.Value
}

// Creates a new instance of the UserSessionListPage type.
func NewUserSessionListPage(cur UserSessionList, getNextPage func(context.Context, UserSessionList) (UserSessionList, error)) UserSessionListPage {
	return UserSessionListPage{
		fn:  getNextPage,
		usl: cur,
	}
}

// UserSessionProperties schema for UserSession properties.
type UserSessionProperties struct {
	// ObjectID - READ-ONLY; ObjectId of user session. (internal use)
	ObjectID *string `json:"objectId,omitempty"`
	// UserPrincipalName - The user principal name.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// ApplicationType - Application type of application. Possible values include: 'ApplicationTypeRemoteApp', 'ApplicationTypeDesktop'
	ApplicationType ApplicationType `json:"applicationType,omitempty"`
	// SessionState - State of user session. Possible values include: 'SessionStateUnknown', 'SessionStateActive', 'SessionStateDisconnected', 'SessionStatePending', 'SessionStateLogOff', 'SessionStateUserProfileDiskMounted'
	SessionState SessionState `json:"sessionState,omitempty"`
	// ActiveDirectoryUserName - The active directory user name.
	ActiveDirectoryUserName *string `json:"activeDirectoryUserName,omitempty"`
	// CreateTime - The timestamp of the user session create.
	CreateTime *date.Time `json:"createTime,omitempty"`
}

// MarshalJSON is the custom marshaler for UserSessionProperties.
func (usp UserSessionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usp.UserPrincipalName != nil {
		objectMap["userPrincipalName"] = usp.UserPrincipalName
	}
	if usp.ApplicationType != "" {
		objectMap["applicationType"] = usp.ApplicationType
	}
	if usp.SessionState != "" {
		objectMap["sessionState"] = usp.SessionState
	}
	if usp.ActiveDirectoryUserName != nil {
		objectMap["activeDirectoryUserName"] = usp.ActiveDirectoryUserName
	}
	if usp.CreateTime != nil {
		objectMap["createTime"] = usp.CreateTime
	}
	return json.Marshal(objectMap)
}

// Workspace represents a Workspace definition.
type Workspace struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// WorkspaceProperties - Detailed properties for Workspace
	*WorkspaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ManagedBy - The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Kind - Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
	Kind *string `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags     map[string]*string                           `json:"tags"`
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`
	Sku      *ResourceModelWithAllowedPropertySetSku      `json:"sku,omitempty"`
	Plan     *ResourceModelWithAllowedPropertySetPlan     `json:"plan,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.SystemData != nil {
		objectMap["systemData"] = w.SystemData
	}
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.ManagedBy != nil {
		objectMap["managedBy"] = w.ManagedBy
	}
	if w.Kind != nil {
		objectMap["kind"] = w.Kind
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Identity != nil {
		objectMap["identity"] = w.Identity
	}
	if w.Sku != nil {
		objectMap["sku"] = w.Sku
	}
	if w.Plan != nil {
		objectMap["plan"] = w.Plan
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				w.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				w.ManagedBy = &managedBy
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				w.Kind = &kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				w.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ResourceModelWithAllowedPropertySetIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				w.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ResourceModelWithAllowedPropertySetSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				w.Sku = &sku
			}
		case "plan":
			if v != nil {
				var plan ResourceModelWithAllowedPropertySetPlan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				w.Plan = &plan
			}
		}
	}

	return nil
}

// WorkspaceList list of Workspace definitions.
type WorkspaceList struct {
	autorest.Response `json:"-"`
	// Value - List of Workspace definitions.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceList.
func (wl WorkspaceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wl.Value != nil {
		objectMap["value"] = wl.Value
	}
	return json.Marshal(objectMap)
}

// WorkspaceListIterator provides access to a complete listing of Workspace values.
type WorkspaceListIterator struct {
	i    int
	page WorkspaceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListIterator) Response() WorkspaceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceListIterator type.
func NewWorkspaceListIterator(page WorkspaceListPage) WorkspaceListIterator {
	return WorkspaceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wl WorkspaceList) IsEmpty() bool {
	return wl.Value == nil || len(*wl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wl WorkspaceList) hasNextLink() bool {
	return wl.NextLink != nil && len(*wl.NextLink) != 0
}

// workspaceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wl WorkspaceList) workspaceListPreparer(ctx context.Context) (*http.Request, error) {
	if !wl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wl.NextLink)))
}

// WorkspaceListPage contains a page of Workspace values.
type WorkspaceListPage struct {
	fn func(context.Context, WorkspaceList) (WorkspaceList, error)
	wl WorkspaceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wl)
		if err != nil {
			return err
		}
		page.wl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListPage) NotDone() bool {
	return !page.wl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListPage) Response() WorkspaceList {
	return page.wl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListPage) Values() []Workspace {
	if page.wl.IsEmpty() {
		return nil
	}
	return *page.wl.Value
}

// Creates a new instance of the WorkspaceListPage type.
func NewWorkspaceListPage(cur WorkspaceList, getNextPage func(context.Context, WorkspaceList) (WorkspaceList, error)) WorkspaceListPage {
	return WorkspaceListPage{
		fn: getNextPage,
		wl: cur,
	}
}

// WorkspacePatch workspace properties that can be patched.
type WorkspacePatch struct {
	// Tags - tags to be updated
	Tags map[string]*string `json:"tags"`
	// WorkspacePatchProperties - Detailed properties for Workspace
	*WorkspacePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspacePatch.
func (wp WorkspacePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Tags != nil {
		objectMap["tags"] = wp.Tags
	}
	if wp.WorkspacePatchProperties != nil {
		objectMap["properties"] = wp.WorkspacePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspacePatch struct.
func (wp *WorkspacePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wp.Tags = tags
			}
		case "properties":
			if v != nil {
				var workspacePatchProperties WorkspacePatchProperties
				err = json.Unmarshal(*v, &workspacePatchProperties)
				if err != nil {
					return err
				}
				wp.WorkspacePatchProperties = &workspacePatchProperties
			}
		}
	}

	return nil
}

// WorkspacePatchProperties workspace properties that can be patched.
type WorkspacePatchProperties struct {
	// Description - Description of Workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ApplicationGroupReferences - List of applicationGroup links.
	ApplicationGroupReferences *[]string `json:"applicationGroupReferences,omitempty"`
	// PublicNetworkAccess - Enabled to allow this resource to be access from the public network. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// WorkspaceProperties schema for Workspace properties.
type WorkspaceProperties struct {
	// ObjectID - READ-ONLY; ObjectId of Workspace. (internal use)
	ObjectID *string `json:"objectId,omitempty"`
	// Description - Description of Workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ApplicationGroupReferences - List of applicationGroup resource Ids.
	ApplicationGroupReferences *[]string `json:"applicationGroupReferences,omitempty"`
	// CloudPcResource - READ-ONLY; Is cloud pc resource.
	CloudPcResource *bool `json:"cloudPcResource,omitempty"`
	// PublicNetworkAccess - Enabled allows this resource to be accessed from both public and private networks, Disabled allows this resource to only be accessed via private endpoints. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceProperties.
func (wp WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Description != nil {
		objectMap["description"] = wp.Description
	}
	if wp.FriendlyName != nil {
		objectMap["friendlyName"] = wp.FriendlyName
	}
	if wp.ApplicationGroupReferences != nil {
		objectMap["applicationGroupReferences"] = wp.ApplicationGroupReferences
	}
	if wp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = wp.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}
