package network

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ManagerCommitsClient is the network Client
type ManagerCommitsClient struct {
	BaseClient
}

// NewManagerCommitsClient creates an instance of the ManagerCommitsClient client.
func NewManagerCommitsClient(subscriptionID string) ManagerCommitsClient {
	return NewManagerCommitsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewManagerCommitsClientWithBaseURI creates an instance of the ManagerCommitsClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewManagerCommitsClientWithBaseURI(baseURI string, subscriptionID string) ManagerCommitsClient {
	return ManagerCommitsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Post post a Network Manager Commit.
// Parameters:
// parameters - parameters supplied to specify which Managed Network commit is.
// resourceGroupName - the name of the resource group.
// networkManagerName - the name of the network manager.
func (client ManagerCommitsClient) Post(ctx context.Context, parameters ManagerCommit, resourceGroupName string, networkManagerName string) (result ManagerCommitsPostFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagerCommitsClient.Post")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TargetLocations", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("network.ManagerCommitsClient", "Post", err.Error())
	}

	req, err := client.PostPreparer(ctx, parameters, resourceGroupName, networkManagerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ManagerCommitsClient", "Post", nil, "Failure preparing request")
		return
	}

	result, err = client.PostSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ManagerCommitsClient", "Post", result.Response(), "Failure sending request")
		return
	}

	return
}

// PostPreparer prepares the Post request.
func (client ManagerCommitsClient) PostPreparer(ctx context.Context, parameters ManagerCommit, resourceGroupName string, networkManagerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"networkManagerName": autorest.Encode("path", networkManagerName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.CommitID = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/commit", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PostSender sends the Post request. The method will close the
// http.Response Body if it receives an error.
func (client ManagerCommitsClient) PostSender(req *http.Request) (future ManagerCommitsPostFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// PostResponder handles the response to the Post request. The method always
// closes the http.Response Body.
func (client ManagerCommitsClient) PostResponder(resp *http.Response) (result ManagerCommit, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
