package migrate

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// HyperVMachinesClient is the discover your workloads for Azure.
type HyperVMachinesClient struct {
	BaseClient
}

// NewHyperVMachinesClient creates an instance of the HyperVMachinesClient client.
func NewHyperVMachinesClient() HyperVMachinesClient {
	return NewHyperVMachinesClientWithBaseURI(DefaultBaseURI)
}

// NewHyperVMachinesClientWithBaseURI creates an instance of the HyperVMachinesClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewHyperVMachinesClientWithBaseURI(baseURI string) HyperVMachinesClient {
	return HyperVMachinesClient{NewWithBaseURI(baseURI)}
}

// GetAllMachinesInSite sends the get all machines in site request.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// siteName - site name.
// APIVersion - the API version to use for this operation.
// continuationToken - optional parameter for continuation token.
// totalRecordCount - total count of machines in the given site.
func (client HyperVMachinesClient) GetAllMachinesInSite(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string, filter string, top *int32, continuationToken string, totalRecordCount *int32) (result HyperVMachineCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVMachinesClient.GetAllMachinesInSite")
		defer func() {
			sc := -1
			if result.hvmc.Response.Response != nil {
				sc = result.hvmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getAllMachinesInSiteNextResults
	req, err := client.GetAllMachinesInSitePreparer(ctx, subscriptionID, resourceGroupName, siteName, APIVersion, filter, top, continuationToken, totalRecordCount)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVMachinesClient", "GetAllMachinesInSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAllMachinesInSiteSender(req)
	if err != nil {
		result.hvmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "migrate.HyperVMachinesClient", "GetAllMachinesInSite", resp, "Failure sending request")
		return
	}

	result.hvmc, err = client.GetAllMachinesInSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVMachinesClient", "GetAllMachinesInSite", resp, "Failure responding to request")
		return
	}
	if result.hvmc.hasNextLink() && result.hvmc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetAllMachinesInSitePreparer prepares the GetAllMachinesInSite request.
func (client HyperVMachinesClient) GetAllMachinesInSitePreparer(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string, filter string, top *int32, continuationToken string, totalRecordCount *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(continuationToken) > 0 {
		queryParameters["continuationToken"] = autorest.Encode("query", continuationToken)
	}
	if totalRecordCount != nil {
		queryParameters["totalRecordCount"] = autorest.Encode("query", *totalRecordCount)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}/machines", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAllMachinesInSiteSender sends the GetAllMachinesInSite request. The method will close the
// http.Response Body if it receives an error.
func (client HyperVMachinesClient) GetAllMachinesInSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAllMachinesInSiteResponder handles the response to the GetAllMachinesInSite request. The method always
// closes the http.Response Body.
func (client HyperVMachinesClient) GetAllMachinesInSiteResponder(resp *http.Response) (result HyperVMachineCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getAllMachinesInSiteNextResults retrieves the next set of results, if any.
func (client HyperVMachinesClient) getAllMachinesInSiteNextResults(ctx context.Context, lastResults HyperVMachineCollection) (result HyperVMachineCollection, err error) {
	req, err := lastResults.hyperVMachineCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "migrate.HyperVMachinesClient", "getAllMachinesInSiteNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetAllMachinesInSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "migrate.HyperVMachinesClient", "getAllMachinesInSiteNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetAllMachinesInSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVMachinesClient", "getAllMachinesInSiteNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetAllMachinesInSiteComplete enumerates all values, automatically crossing page boundaries as required.
func (client HyperVMachinesClient) GetAllMachinesInSiteComplete(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, APIVersion string, filter string, top *int32, continuationToken string, totalRecordCount *int32) (result HyperVMachineCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVMachinesClient.GetAllMachinesInSite")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetAllMachinesInSite(ctx, subscriptionID, resourceGroupName, siteName, APIVersion, filter, top, continuationToken, totalRecordCount)
	return
}

// GetMachine sends the get machine request.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// siteName - site name.
// machineName - machine ARM name.
// APIVersion - the API version to use for this operation.
func (client HyperVMachinesClient) GetMachine(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, machineName string, APIVersion string) (result HyperVMachine, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HyperVMachinesClient.GetMachine")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMachinePreparer(ctx, subscriptionID, resourceGroupName, siteName, machineName, APIVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVMachinesClient", "GetMachine", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMachineSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "migrate.HyperVMachinesClient", "GetMachine", resp, "Failure sending request")
		return
	}

	result, err = client.GetMachineResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.HyperVMachinesClient", "GetMachine", resp, "Failure responding to request")
		return
	}

	return
}

// GetMachinePreparer prepares the GetMachine request.
func (client HyperVMachinesClient) GetMachinePreparer(ctx context.Context, subscriptionID string, resourceGroupName string, siteName string, machineName string, APIVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"machineName":       autorest.Encode("path", machineName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}/machines/{machineName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMachineSender sends the GetMachine request. The method will close the
// http.Response Body if it receives an error.
func (client HyperVMachinesClient) GetMachineSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMachineResponder handles the response to the GetMachine request. The method always
// closes the http.Response Body.
func (client HyperVMachinesClient) GetMachineResponder(resp *http.Response) (result HyperVMachine, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
