package containerinstance

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/containerinstance/mgmt/2020-11-01/containerinstance"

// AzureFileVolume the properties of the Azure File volume. Azure File shares are mounted as volumes.
type AzureFileVolume struct {
	// ShareName - The name of the Azure File share to be mounted as a volume.
	ShareName *string `json:"shareName,omitempty"`
	// ReadOnly - The flag indicating whether the Azure File shared mounted as a volume is read-only.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// StorageAccountName - The name of the storage account that contains the Azure File share.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// StorageAccountKey - The storage account access key used to access the Azure File share.
	StorageAccountKey *string `json:"storageAccountKey,omitempty"`
}

// CachedImages the cached image and OS type.
type CachedImages struct {
	// OsType - The OS type of the cached image.
	OsType *string `json:"osType,omitempty"`
	// Image - The cached image name.
	Image *string `json:"image,omitempty"`
}

// CachedImagesListResult the response containing cached images.
type CachedImagesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of cached images.
	Value *[]CachedImages `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of cached images.
	NextLink *string `json:"nextLink,omitempty"`
}

// CachedImagesListResultIterator provides access to a complete listing of CachedImages values.
type CachedImagesListResultIterator struct {
	i    int
	page CachedImagesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CachedImagesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CachedImagesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CachedImagesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CachedImagesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CachedImagesListResultIterator) Response() CachedImagesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CachedImagesListResultIterator) Value() CachedImages {
	if !iter.page.NotDone() {
		return CachedImages{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CachedImagesListResultIterator type.
func NewCachedImagesListResultIterator(page CachedImagesListResultPage) CachedImagesListResultIterator {
	return CachedImagesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cilr CachedImagesListResult) IsEmpty() bool {
	return cilr.Value == nil || len(*cilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cilr CachedImagesListResult) hasNextLink() bool {
	return cilr.NextLink != nil && len(*cilr.NextLink) != 0
}

// cachedImagesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cilr CachedImagesListResult) cachedImagesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cilr.NextLink)))
}

// CachedImagesListResultPage contains a page of CachedImages values.
type CachedImagesListResultPage struct {
	fn   func(context.Context, CachedImagesListResult) (CachedImagesListResult, error)
	cilr CachedImagesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CachedImagesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CachedImagesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cilr)
		if err != nil {
			return err
		}
		page.cilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CachedImagesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CachedImagesListResultPage) NotDone() bool {
	return !page.cilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CachedImagesListResultPage) Response() CachedImagesListResult {
	return page.cilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CachedImagesListResultPage) Values() []CachedImages {
	if page.cilr.IsEmpty() {
		return nil
	}
	return *page.cilr.Value
}

// Creates a new instance of the CachedImagesListResultPage type.
func NewCachedImagesListResultPage(cur CachedImagesListResult, getNextPage func(context.Context, CachedImagesListResult) (CachedImagesListResult, error)) CachedImagesListResultPage {
	return CachedImagesListResultPage{
		fn:   getNextPage,
		cilr: cur,
	}
}

// Capabilities the regional capabilities.
type Capabilities struct {
	// ResourceType - READ-ONLY; The resource type that this capability describes.
	ResourceType *string `json:"resourceType,omitempty"`
	// OsType - READ-ONLY; The OS type that this capability describes.
	OsType *string `json:"osType,omitempty"`
	// Location - READ-ONLY; The resource location.
	Location *string `json:"location,omitempty"`
	// IPAddressType - READ-ONLY; The ip address type that this capability describes.
	IPAddressType *string `json:"ipAddressType,omitempty"`
	// Gpu - READ-ONLY; The GPU sku that this capability describes.
	Gpu *string `json:"gpu,omitempty"`
	// Capabilities - READ-ONLY; The supported capabilities.
	Capabilities *CapabilitiesCapabilities `json:"capabilities,omitempty"`
}

// MarshalJSON is the custom marshaler for Capabilities.
func (c Capabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CapabilitiesCapabilities the supported capabilities.
type CapabilitiesCapabilities struct {
	// MaxMemoryInGB - READ-ONLY; The maximum allowed memory request in GB.
	MaxMemoryInGB *float64 `json:"maxMemoryInGB,omitempty"`
	// MaxCPU - READ-ONLY; The maximum allowed CPU request in cores.
	MaxCPU *float64 `json:"maxCpu,omitempty"`
	// MaxGpuCount - READ-ONLY; The maximum allowed GPU count.
	MaxGpuCount *float64 `json:"maxGpuCount,omitempty"`
}

// MarshalJSON is the custom marshaler for CapabilitiesCapabilities.
func (c CapabilitiesCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CapabilitiesListResult the response containing list of capabilities.
type CapabilitiesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of capabilities.
	Value *[]Capabilities `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of capabilities.
	NextLink *string `json:"nextLink,omitempty"`
}

// CapabilitiesListResultIterator provides access to a complete listing of Capabilities values.
type CapabilitiesListResultIterator struct {
	i    int
	page CapabilitiesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CapabilitiesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapabilitiesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CapabilitiesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CapabilitiesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CapabilitiesListResultIterator) Response() CapabilitiesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CapabilitiesListResultIterator) Value() Capabilities {
	if !iter.page.NotDone() {
		return Capabilities{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CapabilitiesListResultIterator type.
func NewCapabilitiesListResultIterator(page CapabilitiesListResultPage) CapabilitiesListResultIterator {
	return CapabilitiesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CapabilitiesListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr CapabilitiesListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// capabilitiesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CapabilitiesListResult) capabilitiesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CapabilitiesListResultPage contains a page of Capabilities values.
type CapabilitiesListResultPage struct {
	fn  func(context.Context, CapabilitiesListResult) (CapabilitiesListResult, error)
	clr CapabilitiesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CapabilitiesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapabilitiesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CapabilitiesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CapabilitiesListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CapabilitiesListResultPage) Response() CapabilitiesListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CapabilitiesListResultPage) Values() []Capabilities {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CapabilitiesListResultPage type.
func NewCapabilitiesListResultPage(cur CapabilitiesListResult, getNextPage func(context.Context, CapabilitiesListResult) (CapabilitiesListResult, error)) CapabilitiesListResultPage {
	return CapabilitiesListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// CloudError an error response from the Container Instance service.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Container Instance service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// Container a container instance.
type Container struct {
	// Name - The user-provided name of the container instance.
	Name *string `json:"name,omitempty"`
	// ContainerProperties - The properties of the container instance.
	*ContainerProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Container.
func (c Container) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.ContainerProperties != nil {
		objectMap["properties"] = c.ContainerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Container struct.
func (c *Container) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "properties":
			if v != nil {
				var containerProperties ContainerProperties
				err = json.Unmarshal(*v, &containerProperties)
				if err != nil {
					return err
				}
				c.ContainerProperties = &containerProperties
			}
		}
	}

	return nil
}

// ContainerAttachResponse the information for the output stream from container attach.
type ContainerAttachResponse struct {
	autorest.Response `json:"-"`
	// WebSocketURI - The uri for the output stream from the attach.
	WebSocketURI *string `json:"webSocketUri,omitempty"`
	// Password - The password to the output stream from the attach. Send as an Authorization header value when connecting to the websocketUri.
	Password *string `json:"password,omitempty"`
}

// ContainerExec the container execution command, for liveness or readiness probe
type ContainerExec struct {
	// Command - The commands to execute within the container.
	Command *[]string `json:"command,omitempty"`
}

// ContainerExecRequest the container exec request.
type ContainerExecRequest struct {
	// Command - The command to be executed.
	Command *string `json:"command,omitempty"`
	// TerminalSize - The size of the terminal.
	TerminalSize *ContainerExecRequestTerminalSize `json:"terminalSize,omitempty"`
}

// ContainerExecRequestTerminalSize the size of the terminal.
type ContainerExecRequestTerminalSize struct {
	// Rows - The row size of the terminal
	Rows *int32 `json:"rows,omitempty"`
	// Cols - The column size of the terminal
	Cols *int32 `json:"cols,omitempty"`
}

// ContainerExecResponse the information for the container exec command.
type ContainerExecResponse struct {
	autorest.Response `json:"-"`
	// WebSocketURI - The uri for the exec websocket.
	WebSocketURI *string `json:"webSocketUri,omitempty"`
	// Password - The password to start the exec command.
	Password *string `json:"password,omitempty"`
}

// ContainerGroup a container group.
type ContainerGroup struct {
	autorest.Response `json:"-"`
	// Identity - The identity of the container group, if configured.
	Identity *ContainerGroupIdentity `json:"identity,omitempty"`
	// ContainerGroupProperties - The container group properties
	*ContainerGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ContainerGroup.
func (cg ContainerGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cg.Identity != nil {
		objectMap["identity"] = cg.Identity
	}
	if cg.ContainerGroupProperties != nil {
		objectMap["properties"] = cg.ContainerGroupProperties
	}
	if cg.Location != nil {
		objectMap["location"] = cg.Location
	}
	if cg.Tags != nil {
		objectMap["tags"] = cg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContainerGroup struct.
func (cg *ContainerGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ContainerGroupIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				cg.Identity = &identity
			}
		case "properties":
			if v != nil {
				var containerGroupProperties ContainerGroupProperties
				err = json.Unmarshal(*v, &containerGroupProperties)
				if err != nil {
					return err
				}
				cg.ContainerGroupProperties = &containerGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cg.Tags = tags
			}
		}
	}

	return nil
}

// ContainerGroupDiagnostics container group diagnostic information.
type ContainerGroupDiagnostics struct {
	// LogAnalytics - Container group log analytics information.
	LogAnalytics *LogAnalytics `json:"logAnalytics,omitempty"`
}

// ContainerGroupIdentity identity for the container group.
type ContainerGroupIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of the container group identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with the container group. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the container group. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the container group. Possible values include: 'SystemAssigned', 'UserAssigned', 'SystemAssignedUserAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the container group. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ContainerGroupIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ContainerGroupIdentity.
func (cgiVar ContainerGroupIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgiVar.Type != "" {
		objectMap["type"] = cgiVar.Type
	}
	if cgiVar.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = cgiVar.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ContainerGroupIdentityUserAssignedIdentitiesValue ...
type ContainerGroupIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerGroupIdentityUserAssignedIdentitiesValue.
func (cgiAiv ContainerGroupIdentityUserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ContainerGroupListResult the container group list response that contains the container group properties.
type ContainerGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container groups.
	Value *[]ContainerGroup `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of container groups.
	NextLink *string `json:"nextLink,omitempty"`
}

// ContainerGroupListResultIterator provides access to a complete listing of ContainerGroup values.
type ContainerGroupListResultIterator struct {
	i    int
	page ContainerGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ContainerGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ContainerGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ContainerGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ContainerGroupListResultIterator) Response() ContainerGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ContainerGroupListResultIterator) Value() ContainerGroup {
	if !iter.page.NotDone() {
		return ContainerGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ContainerGroupListResultIterator type.
func NewContainerGroupListResultIterator(page ContainerGroupListResultPage) ContainerGroupListResultIterator {
	return ContainerGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cglr ContainerGroupListResult) IsEmpty() bool {
	return cglr.Value == nil || len(*cglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cglr ContainerGroupListResult) hasNextLink() bool {
	return cglr.NextLink != nil && len(*cglr.NextLink) != 0
}

// containerGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cglr ContainerGroupListResult) containerGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cglr.NextLink)))
}

// ContainerGroupListResultPage contains a page of ContainerGroup values.
type ContainerGroupListResultPage struct {
	fn   func(context.Context, ContainerGroupListResult) (ContainerGroupListResult, error)
	cglr ContainerGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ContainerGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cglr)
		if err != nil {
			return err
		}
		page.cglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ContainerGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ContainerGroupListResultPage) NotDone() bool {
	return !page.cglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ContainerGroupListResultPage) Response() ContainerGroupListResult {
	return page.cglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ContainerGroupListResultPage) Values() []ContainerGroup {
	if page.cglr.IsEmpty() {
		return nil
	}
	return *page.cglr.Value
}

// Creates a new instance of the ContainerGroupListResultPage type.
func NewContainerGroupListResultPage(cur ContainerGroupListResult, getNextPage func(context.Context, ContainerGroupListResult) (ContainerGroupListResult, error)) ContainerGroupListResultPage {
	return ContainerGroupListResultPage{
		fn:   getNextPage,
		cglr: cur,
	}
}

// ContainerGroupNetworkProfile container group network profile information.
type ContainerGroupNetworkProfile struct {
	// ID - The identifier for a network profile.
	ID *string `json:"id,omitempty"`
}

// ContainerGroupProperties the container group properties
type ContainerGroupProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the container group. This only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Containers - The containers within the container group.
	Containers *[]Container `json:"containers,omitempty"`
	// ImageRegistryCredentials - The image registry credentials by which the container group is created from.
	ImageRegistryCredentials *[]ImageRegistryCredential `json:"imageRegistryCredentials,omitempty"`
	// RestartPolicy - Restart policy for all containers within the container group.
	// - `Always` Always restart
	// - `OnFailure` Restart on failure
	// - `Never` Never restart
	// . Possible values include: 'Always', 'OnFailure', 'Never'
	RestartPolicy ContainerGroupRestartPolicy `json:"restartPolicy,omitempty"`
	// IPAddress - The IP address type of the container group.
	IPAddress *IPAddress `json:"ipAddress,omitempty"`
	// OsType - The operating system type required by the containers in the container group. Possible values include: 'Windows', 'Linux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// Volumes - The list of volumes that can be mounted by containers in this container group.
	Volumes *[]Volume `json:"volumes,omitempty"`
	// InstanceView - READ-ONLY; The instance view of the container group. Only valid in response.
	InstanceView *ContainerGroupPropertiesInstanceView `json:"instanceView,omitempty"`
	// Diagnostics - The diagnostic information for a container group.
	Diagnostics *ContainerGroupDiagnostics `json:"diagnostics,omitempty"`
	// NetworkProfile - The network profile information for a container group.
	NetworkProfile *ContainerGroupNetworkProfile `json:"networkProfile,omitempty"`
	// DNSConfig - The DNS config information for a container group.
	DNSConfig *DNSConfiguration `json:"dnsConfig,omitempty"`
	// Sku - The SKU for a container group. Possible values include: 'Standard', 'Dedicated'
	Sku ContainerGroupSku `json:"sku,omitempty"`
	// EncryptionProperties - The encryption properties for a container group.
	EncryptionProperties *EncryptionProperties `json:"encryptionProperties,omitempty"`
	// InitContainers - The init containers for a container group.
	InitContainers *[]InitContainerDefinition `json:"initContainers,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerGroupProperties.
func (cg ContainerGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cg.Containers != nil {
		objectMap["containers"] = cg.Containers
	}
	if cg.ImageRegistryCredentials != nil {
		objectMap["imageRegistryCredentials"] = cg.ImageRegistryCredentials
	}
	if cg.RestartPolicy != "" {
		objectMap["restartPolicy"] = cg.RestartPolicy
	}
	if cg.IPAddress != nil {
		objectMap["ipAddress"] = cg.IPAddress
	}
	if cg.OsType != "" {
		objectMap["osType"] = cg.OsType
	}
	if cg.Volumes != nil {
		objectMap["volumes"] = cg.Volumes
	}
	if cg.Diagnostics != nil {
		objectMap["diagnostics"] = cg.Diagnostics
	}
	if cg.NetworkProfile != nil {
		objectMap["networkProfile"] = cg.NetworkProfile
	}
	if cg.DNSConfig != nil {
		objectMap["dnsConfig"] = cg.DNSConfig
	}
	if cg.Sku != "" {
		objectMap["sku"] = cg.Sku
	}
	if cg.EncryptionProperties != nil {
		objectMap["encryptionProperties"] = cg.EncryptionProperties
	}
	if cg.InitContainers != nil {
		objectMap["initContainers"] = cg.InitContainers
	}
	return json.Marshal(objectMap)
}

// ContainerGroupPropertiesInstanceView the instance view of the container group. Only valid in response.
type ContainerGroupPropertiesInstanceView struct {
	// Events - READ-ONLY; The events of this container group.
	Events *[]Event `json:"events,omitempty"`
	// State - READ-ONLY; The state of the container group. Only valid in response.
	State *string `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerGroupPropertiesInstanceView.
func (cgV ContainerGroupPropertiesInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ContainerGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ContainerGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ContainerGroupsClient) (ContainerGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ContainerGroupsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ContainerGroupsCreateOrUpdateFuture.Result.
func (future *ContainerGroupsCreateOrUpdateFuture) result(client ContainerGroupsClient) (cg ContainerGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerinstance.ContainerGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerinstance.ContainerGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cg.Response.Response, err = future.GetResult(sender); err == nil && cg.Response.Response.StatusCode != http.StatusNoContent {
		cg, err = client.CreateOrUpdateResponder(cg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerinstance.ContainerGroupsCreateOrUpdateFuture", "Result", cg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ContainerGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ContainerGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ContainerGroupsClient) (ContainerGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ContainerGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ContainerGroupsDeleteFuture.Result.
func (future *ContainerGroupsDeleteFuture) result(client ContainerGroupsClient) (cg ContainerGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerinstance.ContainerGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerinstance.ContainerGroupsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cg.Response.Response, err = future.GetResult(sender); err == nil && cg.Response.Response.StatusCode != http.StatusNoContent {
		cg, err = client.DeleteResponder(cg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerinstance.ContainerGroupsDeleteFuture", "Result", cg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ContainerGroupsRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ContainerGroupsRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ContainerGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ContainerGroupsRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ContainerGroupsRestartFuture.Result.
func (future *ContainerGroupsRestartFuture) result(client ContainerGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerinstance.ContainerGroupsRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerinstance.ContainerGroupsRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ContainerGroupsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ContainerGroupsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ContainerGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ContainerGroupsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ContainerGroupsStartFuture.Result.
func (future *ContainerGroupsStartFuture) result(client ContainerGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerinstance.ContainerGroupsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerinstance.ContainerGroupsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ContainerHTTPGet the container Http Get settings, for liveness or readiness probe
type ContainerHTTPGet struct {
	// Path - The path to probe.
	Path *string `json:"path,omitempty"`
	// Port - The port number to probe.
	Port *int32 `json:"port,omitempty"`
	// Scheme - The scheme. Possible values include: 'HTTP', 'HTTPS'
	Scheme Scheme `json:"scheme,omitempty"`
	// HTTPHeaders - The HTTP headers.
	HTTPHeaders *HTTPHeaders `json:"httpHeaders,omitempty"`
}

// ContainerPort the port exposed on the container instance.
type ContainerPort struct {
	// Protocol - The protocol associated with the port. Possible values include: 'ContainerNetworkProtocolTCP', 'ContainerNetworkProtocolUDP'
	Protocol ContainerNetworkProtocol `json:"protocol,omitempty"`
	// Port - The port number exposed within the container group.
	Port *int32 `json:"port,omitempty"`
}

// ContainerProbe the container probe, for liveness or readiness
type ContainerProbe struct {
	// Exec - The execution command to probe
	Exec *ContainerExec `json:"exec,omitempty"`
	// HTTPGet - The Http Get settings to probe
	HTTPGet *ContainerHTTPGet `json:"httpGet,omitempty"`
	// InitialDelaySeconds - The initial delay seconds.
	InitialDelaySeconds *int32 `json:"initialDelaySeconds,omitempty"`
	// PeriodSeconds - The period seconds.
	PeriodSeconds *int32 `json:"periodSeconds,omitempty"`
	// FailureThreshold - The failure threshold.
	FailureThreshold *int32 `json:"failureThreshold,omitempty"`
	// SuccessThreshold - The success threshold.
	SuccessThreshold *int32 `json:"successThreshold,omitempty"`
	// TimeoutSeconds - The timeout seconds.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
}

// ContainerProperties the container instance properties.
type ContainerProperties struct {
	// Image - The name of the image used to create the container instance.
	Image *string `json:"image,omitempty"`
	// Command - The commands to execute within the container instance in exec form.
	Command *[]string `json:"command,omitempty"`
	// Ports - The exposed ports on the container instance.
	Ports *[]ContainerPort `json:"ports,omitempty"`
	// EnvironmentVariables - The environment variables to set in the container instance.
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// InstanceView - READ-ONLY; The instance view of the container instance. Only valid in response.
	InstanceView *ContainerPropertiesInstanceView `json:"instanceView,omitempty"`
	// Resources - The resource requirements of the container instance.
	Resources *ResourceRequirements `json:"resources,omitempty"`
	// VolumeMounts - The volume mounts available to the container instance.
	VolumeMounts *[]VolumeMount `json:"volumeMounts,omitempty"`
	// LivenessProbe - The liveness probe.
	LivenessProbe *ContainerProbe `json:"livenessProbe,omitempty"`
	// ReadinessProbe - The readiness probe.
	ReadinessProbe *ContainerProbe `json:"readinessProbe,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerProperties.
func (cp ContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Image != nil {
		objectMap["image"] = cp.Image
	}
	if cp.Command != nil {
		objectMap["command"] = cp.Command
	}
	if cp.Ports != nil {
		objectMap["ports"] = cp.Ports
	}
	if cp.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = cp.EnvironmentVariables
	}
	if cp.Resources != nil {
		objectMap["resources"] = cp.Resources
	}
	if cp.VolumeMounts != nil {
		objectMap["volumeMounts"] = cp.VolumeMounts
	}
	if cp.LivenessProbe != nil {
		objectMap["livenessProbe"] = cp.LivenessProbe
	}
	if cp.ReadinessProbe != nil {
		objectMap["readinessProbe"] = cp.ReadinessProbe
	}
	return json.Marshal(objectMap)
}

// ContainerPropertiesInstanceView the instance view of the container instance. Only valid in response.
type ContainerPropertiesInstanceView struct {
	// RestartCount - READ-ONLY; The number of times that the container instance has been restarted.
	RestartCount *int32 `json:"restartCount,omitempty"`
	// CurrentState - READ-ONLY; Current container instance state.
	CurrentState *ContainerState `json:"currentState,omitempty"`
	// PreviousState - READ-ONLY; Previous container instance state.
	PreviousState *ContainerState `json:"previousState,omitempty"`
	// Events - READ-ONLY; The events of the container instance.
	Events *[]Event `json:"events,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerPropertiesInstanceView.
func (cpV ContainerPropertiesInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ContainerState the container instance state.
type ContainerState struct {
	// State - READ-ONLY; The state of the container instance.
	State *string `json:"state,omitempty"`
	// StartTime - READ-ONLY; The date-time when the container instance state started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// ExitCode - READ-ONLY; The container instance exit codes correspond to those from the `docker run` command.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// FinishTime - READ-ONLY; The date-time when the container instance state finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// DetailStatus - READ-ONLY; The human-readable status of the container instance state.
	DetailStatus *string `json:"detailStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerState.
func (cs ContainerState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DNSConfiguration DNS configuration for the container group.
type DNSConfiguration struct {
	// NameServers - The DNS servers for the container group.
	NameServers *[]string `json:"nameServers,omitempty"`
	// SearchDomains - The DNS search domains for hostname lookup in the container group.
	SearchDomains *string `json:"searchDomains,omitempty"`
	// Options - The DNS options for the container group.
	Options *string `json:"options,omitempty"`
}

// EncryptionProperties the container group encryption properties.
type EncryptionProperties struct {
	// VaultBaseURL - The keyvault base url.
	VaultBaseURL *string `json:"vaultBaseUrl,omitempty"`
	// KeyName - The encryption key name.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - The encryption key version.
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// EnvironmentVariable the environment variable to set within the container instance.
type EnvironmentVariable struct {
	// Name - The name of the environment variable.
	Name *string `json:"name,omitempty"`
	// Value - The value of the environment variable.
	Value *string `json:"value,omitempty"`
	// SecureValue - The value of the secure environment variable.
	SecureValue *string `json:"secureValue,omitempty"`
}

// Event a container group or container instance event.
type Event struct {
	// Count - READ-ONLY; The count of the event.
	Count *int32 `json:"count,omitempty"`
	// FirstTimestamp - READ-ONLY; The date-time of the earliest logged event.
	FirstTimestamp *date.Time `json:"firstTimestamp,omitempty"`
	// LastTimestamp - READ-ONLY; The date-time of the latest logged event.
	LastTimestamp *date.Time `json:"lastTimestamp,omitempty"`
	// Name - READ-ONLY; The event name.
	Name *string `json:"name,omitempty"`
	// Message - READ-ONLY; The event message.
	Message *string `json:"message,omitempty"`
	// Type - READ-ONLY; The event type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Event.
func (e Event) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GitRepoVolume represents a volume that is populated with the contents of a git repository
type GitRepoVolume struct {
	// Directory - Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
	Directory *string `json:"directory,omitempty"`
	// Repository - Repository URL
	Repository *string `json:"repository,omitempty"`
	// Revision - Commit hash for the specified revision.
	Revision *string `json:"revision,omitempty"`
}

// GpuResource the GPU resource.
type GpuResource struct {
	// Count - The count of the GPU resource.
	Count *int32 `json:"count,omitempty"`
	// Sku - The SKU of the GPU resource. Possible values include: 'K80', 'P100', 'V100'
	Sku GpuSku `json:"sku,omitempty"`
}

// HTTPHeaders the HTTP headers.
type HTTPHeaders struct {
	// Name - The header name.
	Name *string `json:"name,omitempty"`
	// Value - The header value.
	Value *string `json:"value,omitempty"`
}

// ImageRegistryCredential image registry credential.
type ImageRegistryCredential struct {
	// Server - The Docker image registry server without a protocol such as "http" and "https".
	Server *string `json:"server,omitempty"`
	// Username - The username for the private registry.
	Username *string `json:"username,omitempty"`
	// Password - The password for the private registry.
	Password *string `json:"password,omitempty"`
}

// InitContainerDefinition the init container definition.
type InitContainerDefinition struct {
	// Name - The name for the init container.
	Name *string `json:"name,omitempty"`
	// InitContainerPropertiesDefinition - The properties for the init container.
	*InitContainerPropertiesDefinition `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for InitContainerDefinition.
func (icd InitContainerDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icd.Name != nil {
		objectMap["name"] = icd.Name
	}
	if icd.InitContainerPropertiesDefinition != nil {
		objectMap["properties"] = icd.InitContainerPropertiesDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InitContainerDefinition struct.
func (icd *InitContainerDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				icd.Name = &name
			}
		case "properties":
			if v != nil {
				var initContainerPropertiesDefinition InitContainerPropertiesDefinition
				err = json.Unmarshal(*v, &initContainerPropertiesDefinition)
				if err != nil {
					return err
				}
				icd.InitContainerPropertiesDefinition = &initContainerPropertiesDefinition
			}
		}
	}

	return nil
}

// InitContainerPropertiesDefinition the init container definition properties.
type InitContainerPropertiesDefinition struct {
	// Image - The image of the init container.
	Image *string `json:"image,omitempty"`
	// Command - The command to execute within the init container in exec form.
	Command *[]string `json:"command,omitempty"`
	// EnvironmentVariables - The environment variables to set in the init container.
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// InstanceView - READ-ONLY; The instance view of the init container. Only valid in response.
	InstanceView *InitContainerPropertiesDefinitionInstanceView `json:"instanceView,omitempty"`
	// VolumeMounts - The volume mounts available to the init container.
	VolumeMounts *[]VolumeMount `json:"volumeMounts,omitempty"`
}

// MarshalJSON is the custom marshaler for InitContainerPropertiesDefinition.
func (icpd InitContainerPropertiesDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icpd.Image != nil {
		objectMap["image"] = icpd.Image
	}
	if icpd.Command != nil {
		objectMap["command"] = icpd.Command
	}
	if icpd.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = icpd.EnvironmentVariables
	}
	if icpd.VolumeMounts != nil {
		objectMap["volumeMounts"] = icpd.VolumeMounts
	}
	return json.Marshal(objectMap)
}

// InitContainerPropertiesDefinitionInstanceView the instance view of the init container. Only valid in
// response.
type InitContainerPropertiesDefinitionInstanceView struct {
	// RestartCount - READ-ONLY; The number of times that the init container has been restarted.
	RestartCount *int32 `json:"restartCount,omitempty"`
	// CurrentState - READ-ONLY; The current state of the init container.
	CurrentState *ContainerState `json:"currentState,omitempty"`
	// PreviousState - READ-ONLY; The previous state of the init container.
	PreviousState *ContainerState `json:"previousState,omitempty"`
	// Events - READ-ONLY; The events of the init container.
	Events *[]Event `json:"events,omitempty"`
}

// MarshalJSON is the custom marshaler for InitContainerPropertiesDefinitionInstanceView.
func (icpdV InitContainerPropertiesDefinitionInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IPAddress IP address for the container group.
type IPAddress struct {
	// Ports - The list of ports exposed on the container group.
	Ports *[]Port `json:"ports,omitempty"`
	// Type - Specifies if the IP is exposed to the public internet or private VNET. Possible values include: 'Public', 'Private'
	Type ContainerGroupIPAddressType `json:"type,omitempty"`
	// IP - The IP exposed to the public internet.
	IP *string `json:"ip,omitempty"`
	// DNSNameLabel - The Dns name label for the IP.
	DNSNameLabel *string `json:"dnsNameLabel,omitempty"`
	// Fqdn - READ-ONLY; The FQDN for the IP.
	Fqdn *string `json:"fqdn,omitempty"`
}

// MarshalJSON is the custom marshaler for IPAddress.
func (ia IPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ia.Ports != nil {
		objectMap["ports"] = ia.Ports
	}
	if ia.Type != "" {
		objectMap["type"] = ia.Type
	}
	if ia.IP != nil {
		objectMap["ip"] = ia.IP
	}
	if ia.DNSNameLabel != nil {
		objectMap["dnsNameLabel"] = ia.DNSNameLabel
	}
	return json.Marshal(objectMap)
}

// LogAnalytics container group log analytics information.
type LogAnalytics struct {
	// WorkspaceID - The workspace id for log analytics
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// WorkspaceKey - The workspace key for log analytics
	WorkspaceKey *string `json:"workspaceKey,omitempty"`
	// LogType - The log type to be used. Possible values include: 'ContainerInsights', 'ContainerInstanceLogs'
	LogType LogAnalyticsLogType `json:"logType,omitempty"`
	// Metadata - Metadata for log analytics.
	Metadata map[string]*string `json:"metadata"`
	// WorkspaceResourceID - The workspace resource id for log analytics
	WorkspaceResourceID map[string]*string `json:"workspaceResourceId"`
}

// MarshalJSON is the custom marshaler for LogAnalytics.
func (la LogAnalytics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if la.WorkspaceID != nil {
		objectMap["workspaceId"] = la.WorkspaceID
	}
	if la.WorkspaceKey != nil {
		objectMap["workspaceKey"] = la.WorkspaceKey
	}
	if la.LogType != "" {
		objectMap["logType"] = la.LogType
	}
	if la.Metadata != nil {
		objectMap["metadata"] = la.Metadata
	}
	if la.WorkspaceResourceID != nil {
		objectMap["workspaceResourceId"] = la.WorkspaceResourceID
	}
	return json.Marshal(objectMap)
}

// Logs the logs.
type Logs struct {
	autorest.Response `json:"-"`
	// Content - The content of the log.
	Content *string `json:"content,omitempty"`
}

// Operation an operation for Azure Container Instance service.
type Operation struct {
	// Name - The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - The display information of the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Properties - The additional properties.
	Properties interface{} `json:"properties,omitempty"`
	// Origin - The intended executor of the operation. Possible values include: 'User', 'System'
	Origin OperationsOrigin `json:"origin,omitempty"`
}

// OperationDisplay the display information of the operation.
type OperationDisplay struct {
	// Provider - The name of the provider of the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - The name of the resource type of the operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - The friendly name of the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - The description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the operation list response that contains all operations for Azure Container
// Instance service.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Port the port exposed on the container group.
type Port struct {
	// Protocol - The protocol associated with the port. Possible values include: 'TCP', 'UDP'
	Protocol ContainerGroupNetworkProtocol `json:"protocol,omitempty"`
	// Port - The port number.
	Port *int32 `json:"port,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceLimits the resource limits.
type ResourceLimits struct {
	// MemoryInGB - The memory limit in GB of this container instance.
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	// CPU - The CPU limit of this container instance.
	CPU *float64 `json:"cpu,omitempty"`
	// Gpu - The GPU limit of this container instance.
	Gpu *GpuResource `json:"gpu,omitempty"`
}

// ResourceRequests the resource requests.
type ResourceRequests struct {
	// MemoryInGB - The memory request in GB of this container instance.
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	// CPU - The CPU request of this container instance.
	CPU *float64 `json:"cpu,omitempty"`
	// Gpu - The GPU request of this container instance.
	Gpu *GpuResource `json:"gpu,omitempty"`
}

// ResourceRequirements the resource requirements.
type ResourceRequirements struct {
	// Requests - The resource requests of this container instance.
	Requests *ResourceRequests `json:"requests,omitempty"`
	// Limits - The resource limits of this container instance.
	Limits *ResourceLimits `json:"limits,omitempty"`
}

// Usage a single usage result
type Usage struct {
	// Unit - READ-ONLY; Unit of the usage result
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; The current usage of the resource
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The maximum permitted usage of the resource.
	Limit *int32 `json:"limit,omitempty"`
	// Name - READ-ONLY; The name object of the resource
	Name *UsageName `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UsageListResult the response containing the usage data
type UsageListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The usage data.
	Value *[]Usage `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for UsageListResult.
func (ulr UsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UsageName the name object of the resource
type UsageName struct {
	// Value - READ-ONLY; The name of the resource
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The localized name of the resource
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for UsageName.
func (u UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Volume the properties of the volume.
type Volume struct {
	// Name - The name of the volume.
	Name *string `json:"name,omitempty"`
	// AzureFile - The Azure File volume.
	AzureFile *AzureFileVolume `json:"azureFile,omitempty"`
	// EmptyDir - The empty directory volume.
	EmptyDir interface{} `json:"emptyDir,omitempty"`
	// Secret - The secret volume.
	Secret map[string]*string `json:"secret"`
	// GitRepo - The git repo volume.
	GitRepo *GitRepoVolume `json:"gitRepo,omitempty"`
}

// MarshalJSON is the custom marshaler for Volume.
func (vVar Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.Name != nil {
		objectMap["name"] = vVar.Name
	}
	if vVar.AzureFile != nil {
		objectMap["azureFile"] = vVar.AzureFile
	}
	if vVar.EmptyDir != nil {
		objectMap["emptyDir"] = vVar.EmptyDir
	}
	if vVar.Secret != nil {
		objectMap["secret"] = vVar.Secret
	}
	if vVar.GitRepo != nil {
		objectMap["gitRepo"] = vVar.GitRepo
	}
	return json.Marshal(objectMap)
}

// VolumeMount the properties of the volume mount.
type VolumeMount struct {
	// Name - The name of the volume mount.
	Name *string `json:"name,omitempty"`
	// MountPath - The path within the container where the volume should be mounted. Must not contain colon (:).
	MountPath *string `json:"mountPath,omitempty"`
	// ReadOnly - The flag indicating whether the volume mount is read-only.
	ReadOnly *bool `json:"readOnly,omitempty"`
}
