package translatortextapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v3.0/translatortext"
)

// TranslatorClientAPI contains the set of methods on the TranslatorClient type.
type TranslatorClientAPI interface {
	BreakSentence(ctx context.Context, textParameter []translatortext.BreakSentenceTextInput, language string, script string, xClientTraceID string) (result translatortext.ListBreakSentenceResultItem, err error)
	Detect(ctx context.Context, textParameter []translatortext.DetectTextInput, xClientTraceID string) (result translatortext.ListDetectResultItem, err error)
	DictionaryExamples(ctx context.Context, from string, toParameter string, textParameter []translatortext.DictionaryExampleTextInput, xClientTraceID string) (result translatortext.ListDictionaryExampleResultItem, err error)
	DictionaryLookup(ctx context.Context, from string, toParameter string, textParameter []translatortext.DictionaryLookupTextInput, xClientTraceID string) (result translatortext.ListDictionaryLookupResultItem, err error)
	Languages(ctx context.Context, scope []string, acceptLanguage string, xClientTraceID string) (result translatortext.LanguagesResult, err error)
	Translate(ctx context.Context, toParameter []string, textParameter []translatortext.TranslateTextInput, from string, textType string, category string, profanityAction string, profanityMarker string, includeAlignment *bool, includeSentenceLength *bool, suggestedFrom string, fromScript string, toScript []string, xClientTraceID string) (result translatortext.ListTranslateResultAllItem, err error)
	Transliterate(ctx context.Context, language string, fromScript string, toScript string, texts []translatortext.TransliterateTextInput, xClientTraceID string) (result translatortext.ListTransliterateResultItem, err error)
}

var _ TranslatorClientAPI = (*translatortext.TranslatorClient)(nil)
